# -*- coding: utf-8 -*-
# Generated by Django 1.11.17 on 2020-04-07 22:32
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('packagedb', '0033_auto_20190128_2056'),
    ]

    operations = [
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('path', models.CharField(help_text='The full path value of a resource (file or directory) in the archive it is from.', max_length=2000)),
                ('size', models.BigIntegerField(blank=True, help_text='Size in bytes.', null=True)),
                ('sha1', models.CharField(blank=True, help_text='SHA1 checksum hex-encoded, as in sha1sum.', max_length=40, null=True)),
                ('md5', models.CharField(blank=True, help_text='MD5 checksum hex-encoded, as in md5sum.', max_length=32, null=True)),
                ('copyright', models.TextField(blank=True, help_text='Copyright statements detected in this Resource', null=True)),
                ('license_expression', models.CharField(blank=True, help_text='The combined and normalized license expression for this Resource as derived from its detected license expressions', max_length=1024, null=True)),
                ('additional_details', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='An optional JSON-formatted field to identify additional resource attributes.')),
                ('package', models.ForeignKey(help_text='The Package that this Resource is from', on_delete=django.db.models.deletion.CASCADE, related_name='resources', to='packagedb.Package')),
            ],
            options={
                'ordering': ('package', 'path'),
            },
        ),
        migrations.AlterUniqueTogether(
            name='resource',
            unique_together=set([('package', 'path')]),
        ),
    ]
