#Copyright (c) 2010 Erik Tollerud (etolleru@uci.edu) 
from __future__ import division,with_statement

#Warning: this file is overwritten in the build_py stage of setup.py to freeze
#the version number - this file is only used in dev mode or during build.

#these components can be changed for new versions
major = 0
minor = 1
bugfix = None
dev = True


#everything below here is derived
release = not dev

def _get_repo_revision():
    """
    Returns the bzr revision number.
    
    :returns: The revision number
    :rtype: int
    
    :except ValueError: If this is a release version
    :except IOError: If the .bzr directory or info files cannot be found 
    """
    import os
    from os import path

    if release:
        raise ValueError('revsion number not valid for release')
    bzrdir = path.join(path.split(__file__)[0],'..','.bzr')
    if not path.exists(bzrdir):
        raise IOError('.bzr directory does not exist, cannot get revision')
    
    lrevfn = path.join(bzrdir,'branch','last-revision')
    if not path.exists(lrevfn):
        raise IOError('last-revision file does not exist, cannot get revision')
        
    with open(lrevfn) as f:
        s = f.read()
        
    return int(s.split()[0])
    
def _get_devstr():
    try:
        rnum = _get_repo_revision()
        return 'dev-r'+str(rnum)
    except IOError:
        from warnings import warn
        warn('Could not find bzr, so no revision number available for dev build of astropysics - this may prevent this install from overwriting the previous version')
        return 'dev'
    
    
version = str(major)+'.' +\
          str(minor) +\
          (('.'+str(bugfix)) if bugfix else '') +\
          ('.'+_get_devstr() if dev else '')
          
_frozen_version_py_template = """#Autogenerated in astropysics setup.py on %s
#these components can be changed for new versions
version = '%s'

major = %s
minor = %s
bugfix = %s
dev = %s

release = not dev
"""
