#/*
# * Copyright (c) 2019,2020 Xilinx Inc. All rights reserved.
# *
# * Author:
# *       Bruce Ashfield <bruce.ashfield@xilinx.com>
# *
# * SPDX-License-Identifier: BSD-3-Clause
# */

from enum import Enum

class XPm_PowerNodeType(Enum):
    XPM_NODETYPE_POWER_ISLAND=1
    XPM_NODETYPE_POWER_DOMAIN_PMC=2
    XPM_NODETYPE_POWER_DOMAIN_PS_FULL=3
    XPM_NODETYPE_POWER_DOMAIN_PS_LOW=4
    XPM_NODETYPE_POWER_DOMAIN_NOC=5
    XPM_NODETYPE_POWER_DOMAIN_CPM=6
    XPM_NODETYPE_POWER_DOMAIN_ME=7
    XPM_NODETYPE_POWER_DOMAIN_PL=8
    XPM_NODETYPE_POWER_ISLAND_XRAM=9

class XPm_ClockNodeType(Enum):
    XPM_NODETYPE_CLOCK_PLL=1
    XPM_NODETYPE_CLOCK_OUT=2
    XPM_NODETYPE_CLOCK_REF=3
    XPM_NODETYPE_CLOCK_SUBNODE=4

class XPm_ResetNodeType(Enum):
    XPM_NODETYPE_RESET_PERIPHERAL=1
    XPM_NODETYPE_RESET_DBG=2
    XPM_NODETYPE_RESET_POR=3
    XPM_NODETYPE_RESET_SRST=4

class XPm_MemicNodeType(Enum):
    XPM_NODETYPE_MEMIC_MASTER=1
    XPM_NODETYPE_MEMIC_SLAVE=2

class XPm_PinNodeType(Enum):
    XPM_NODETYPE_LPD_MIO=1
    XPM_NODETYPE_PMC_MIO=2

class XPm_DeviceNodeType(Enum):
    XPM_NODETYPE_DEV_CORE_PMC=1
    XPM_NODETYPE_DEV_CORE_PSM=2
    XPM_NODETYPE_DEV_CORE_APU=3
    XPM_NODETYPE_DEV_CORE_RPU=4
    XPM_NODETYPE_DEV_OCM=5
    XPM_NODETYPE_DEV_TCM=6
    XPM_NODETYPE_DEV_L2CACHE=7
    XPM_NODETYPE_DEV_DDR=8
    XPM_NODETYPE_DEV_PERIPH=9
    XPM_NODETYPE_DEV_SOC=10
    XPM_NODETYPE_DEV_GT=11
    XPM_NODETYPE_DEV_EFUSE=12
    XPM_NODETYPE_DEV_XRAM=13

#define NODEID(CLASS, SUBCLASS, TYPE, INDEX)	\
#	((((CLASS) & NODE_CLASS_MASK_BITS) << NODE_CLASS_SHIFT) | \
#        (((SUBCLASS) & NODE_SUBCLASS_MASK_BITS) << NODE_SUBCLASS_SHIFT) | \
#        (((TYPE) & NODE_TYPE_MASK_BITS) << NODE_TYPE_SHIFT) | \
#        (((INDEX) & NODE_INDEX_MASK_BITS) << NODE_INDEX_SHIFT))

