'''
Copyright (2017) Sandia Corporation.
Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
the U.S. Government retains certain rights in this software.

minimega dev team <minimega-dev@sandia.gov>

minimega bindings for Python

**************************************************************************
* THIS FILE IS AUTOMATICALLY GENERATED. DO NOT MODIFY THIS FILE BY HAND. *
**************************************************************************

This API uses a UNIX domain socket to communicate with a running instance of
minimega. The protocol is documented here, under "Command Port and the Local
Command Flag":

	http://minimega.org/articles/usage.article#TOC_2.2.

This file is automatically generated from the output of "minimega -cli". See
"doc.bash" for details on how to regenerate this file using pyapigen.

This API *should* work for both python2.7 and python3. Please report any issues
to the bug tracker:

	https://github.com/sandia-minimega/minimega/issues
'''


import copy
import json
import socket
import threading


# This is the revision of minimega these bindings were created for and the date
# that the bindings were generated.
__version__ = '2c70078885161c224276e0dccccb9ddc014d401c'
__date__ = '2021-01-12 06:04:04.156746525 -0800 PST m=+0.101356060'


class Error(Exception): pass


# HAX: python 2/3 hack
try:
	basestring
	def _isstr(obj):
		return isinstance(obj, basestring)
except NameError:
	def _isstr(obj):
		return isinstance(obj, str)


def connect(path='/tmp/minimega/minimega', raise_errors=True, debug=False, namespace=None):
	'''
	Connect to the minimega instance with UNIX socket at <path> and return a
	new minimega API object. See help(minimega.minimega) for an explaination of
	the other parameters.
	'''
	mm = minimega(path, raise_errors, debug, namespace)
	for resp in mm.version():
		if __version__ not in resp['Response']:
			print('WARNING: API was built using a different version of minimega')
	return mm


def print_rows(resps):
	'''
	print_rows walks the response from minimega and prints all tabular data.
	'''
	for resp in resps:
		for row in resp['Tabular'] or []:
			print(row)

def as_dict(resp):
	'''
	as_dict converts a minimega Header/Tabular response into a list of dictionaries.
	'''
	res = []
	for row in resp['Tabular']:
		res.append({header: row[i] for (i, header) in enumerate(resp['Header'])})

	return res


def discard(mm):
	'''
	discard streams responses from minimega until there are none left
	'''
	try:
		for _ in mm.streamResponses():
			pass
	except Exception as e:
		if str(e) != 'no responses to stream from last command':
			raise


class minimega(object):
	'''
	This class communicates with a running instance of minimega using a UNIX
	domain socket.

	Each minimega command can be called from this object, and the response will
	be returned unless an Exception is thrown.
	'''

	def __init__(self, path, raise_errors, debug, namespace):
		'''
		Connects to the minimega instance with UNIX socket at <path>. If
		<raise_errors> is set, the Python APIs will raise an Exception whenever
		minimega returns a response with an error. If <debug> is set, debugging
		information will be printed. The <namespace> parameter allows you to
		"bind" the minimega object to a particular namespace (see
		help(minimega.minimega.namespace) for more info on namespaces).
		'''

		self.moreResponses = False

		self._lock = threading.Lock()
		self._path = path
		self._raise_errors = raise_errors
		self._debug = debug
		self._namespace = namespace
		self._socket = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
		self._socket.connect(path)
		self._socketfile = self._socket.makefile('rb')


	def _get_response(self):
		'''
		_get_response reads a single response from minimega
		'''
		line = self._socketfile.readline().decode('utf-8')
		try:
			response = json.loads(line)
		except ValueError as e:
			if self._debug:
				print(e)

		if not response:
			raise Error('Expected response, socket closed')

		if self._debug:
			print('[debug] response: ' + str(response))
		if self._raise_errors:
			for resp in response['Resp']:
				if resp['Error'] != '':
					raise Error(resp['Error'])

		return response


	def _run(self, *args):
		'''
		_run sends a command to minimega and returns the first response,
		setting a flag if there are more responses to read with
		streamResponses.
		'''
		cmd = list(args)
		if self._namespace is not None:
			cmd = ['namespace', self._namespace] + cmd

		msg = json.dumps({'Command': ' '.join([str(v) for v in cmd if v])})

		with self._lock:
			if self.moreResponses:
				raise Error('more responses to be read from last command')

			if self._debug:
				print('[debug] sending cmd: ' + msg)

			if len(msg) != self._socket.send(msg.encode('utf-8')):
				raise Error('failed to write message to minimega')

			response = self._get_response()
			if response['More']:
				self.moreResponses = True

			return response['Resp']

	def namespace(self, name):
		'''
		Returns a new instance for use in a with statement:

			with mm.namespace("name") as mm:
				mm.vm_info(...)

		Note that this wraps the existing minimega connection so multiple
		instances can be used concurrently but the commands themselves will be
		executed serially.
		'''

		class __namespacer__:
			def __enter__(_):
				# clone the current instance and update the namespace
				mm = copy.copy(self)
				mm._namespace = name

				return mm

			def __exit__(self, type, value, traceback):
				pass

		return __namespacer__()


	def streamResponses(self):
		'''
		streamResponses returns a generator for additional responses to a
		previous command.
		'''

		with self._lock:
			if not self.moreResponses:
				raise Error('no responses to stream from last command')

			self.moreResponses = False

			response = self._get_response()

			while response['More']:
				yield response['Resp']
				response = self._get_response()

			yield response['Resp']


	
	def background(self,command,):
		'''
Variants:
	background <command>...

Execute a command under the credentials of the running user.

Commands run in the background and control returns immediately. Any output is
logged at the "info" level.
		'''
		# background <command>...
		if command != None:
			return self._run("background", command)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def bridge(self,):
		'''
Variants:
	bridge

When called with no arguments, display information about all managed bridges.

To add a trunk interface to a specific bridge, use 'bridge trunk'. For example,
to add interface bar to bridge foo:

	bridge trunk foo bar

To create a vxlan or GRE tunnel to another bridge, use 'bridge tunnel'. For
example, to create a vxlan tunnel to another bridge with IP 10.0.0.1:

	bridge tunnel vxlan mega_bridge 10.0.0.1

Note: bridge is not a namespace-aware command.
		'''
		# bridge
		if True:
			return self._run("bridge")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def bridge_config(self,bridge,config,):
		'''
Variants:
	bridge config <bridge> <config>

When called with no arguments, display information about all managed bridges.

To add a trunk interface to a specific bridge, use 'bridge trunk'. For example,
to add interface bar to bridge foo:

	bridge trunk foo bar

To create a vxlan or GRE tunnel to another bridge, use 'bridge tunnel'. For
example, to create a vxlan tunnel to another bridge with IP 10.0.0.1:

	bridge tunnel vxlan mega_bridge 10.0.0.1

Note: bridge is not a namespace-aware command.
		'''
		# bridge config <bridge> <config>
		if bridge != None and config != None:
			return self._run("bridge", "config", bridge, config)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def bridge_destroy(self,bridge,):
		'''
Variants:
	bridge destroy <bridge>

When called with no arguments, display information about all managed bridges.

To add a trunk interface to a specific bridge, use 'bridge trunk'. For example,
to add interface bar to bridge foo:

	bridge trunk foo bar

To create a vxlan or GRE tunnel to another bridge, use 'bridge tunnel'. For
example, to create a vxlan tunnel to another bridge with IP 10.0.0.1:

	bridge tunnel vxlan mega_bridge 10.0.0.1

Note: bridge is not a namespace-aware command.
		'''
		# bridge destroy <bridge>
		if bridge != None:
			return self._run("bridge", "destroy", bridge)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def bridge_notrunk(self,bridge,interface,):
		'''
Variants:
	bridge notrunk <bridge> <interface>

When called with no arguments, display information about all managed bridges.

To add a trunk interface to a specific bridge, use 'bridge trunk'. For example,
to add interface bar to bridge foo:

	bridge trunk foo bar

To create a vxlan or GRE tunnel to another bridge, use 'bridge tunnel'. For
example, to create a vxlan tunnel to another bridge with IP 10.0.0.1:

	bridge tunnel vxlan mega_bridge 10.0.0.1

Note: bridge is not a namespace-aware command.
		'''
		# bridge notrunk <bridge> <interface>
		if bridge != None and interface != None:
			return self._run("bridge", "notrunk", bridge, interface)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def bridge_notunnel(self,bridge,interface,):
		'''
Variants:
	bridge notunnel <bridge> <interface>

When called with no arguments, display information about all managed bridges.

To add a trunk interface to a specific bridge, use 'bridge trunk'. For example,
to add interface bar to bridge foo:

	bridge trunk foo bar

To create a vxlan or GRE tunnel to another bridge, use 'bridge tunnel'. For
example, to create a vxlan tunnel to another bridge with IP 10.0.0.1:

	bridge tunnel vxlan mega_bridge 10.0.0.1

Note: bridge is not a namespace-aware command.
		'''
		# bridge notunnel <bridge> <interface>
		if bridge != None and interface != None:
			return self._run("bridge", "notunnel", bridge, interface)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def bridge_trunk(self,bridge,interface,):
		'''
Variants:
	bridge trunk <bridge> <interface>

When called with no arguments, display information about all managed bridges.

To add a trunk interface to a specific bridge, use 'bridge trunk'. For example,
to add interface bar to bridge foo:

	bridge trunk foo bar

To create a vxlan or GRE tunnel to another bridge, use 'bridge tunnel'. For
example, to create a vxlan tunnel to another bridge with IP 10.0.0.1:

	bridge tunnel vxlan mega_bridge 10.0.0.1

Note: bridge is not a namespace-aware command.
		'''
		# bridge trunk <bridge> <interface>
		if bridge != None and interface != None:
			return self._run("bridge", "trunk", bridge, interface)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def bridge_tunnel(self,vxlan_or_gre,bridge,remote,key=None,):
		'''
Variants:
	bridge tunnel <vxlan,gre> <bridge> <remote ip> <key>
	bridge tunnel <vxlan,gre> <bridge> <remote ip>

When called with no arguments, display information about all managed bridges.

To add a trunk interface to a specific bridge, use 'bridge trunk'. For example,
to add interface bar to bridge foo:

	bridge trunk foo bar

To create a vxlan or GRE tunnel to another bridge, use 'bridge tunnel'. For
example, to create a vxlan tunnel to another bridge with IP 10.0.0.1:

	bridge tunnel vxlan mega_bridge 10.0.0.1

Note: bridge is not a namespace-aware command.
		'''
		# bridge tunnel <vxlan,gre> <bridge> <remote ip> <key>
		if vxlan_or_gre != None and bridge != None and remote != None and key != None:
			# Validate that choice was valid for vxlan_or_gre
			if vxlan_or_gre not in ["vxlan","gre",]:
				raise ValueError("invalid value for vxlan_or_gre")
			return self._run("bridge", "tunnel", vxlan_or_gre, bridge, remote, key)
	
		# bridge tunnel <vxlan,gre> <bridge> <remote ip>
		if vxlan_or_gre != None and bridge != None and remote != None:
			# Validate that choice was valid for vxlan_or_gre
			if vxlan_or_gre not in ["vxlan","gre",]:
				raise ValueError("invalid value for vxlan_or_gre")
			return self._run("bridge", "tunnel", vxlan_or_gre, bridge, remote)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture(self,):
		'''
Variants:
	capture

show active captures
		'''
		# capture
		if True:
			return self._run("capture")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture_netflow_bridge(self,bridge,filename=None,tcp_or_udp=None,hostname_port=None,):
		'''
Variants:
	capture netflow bridge <bridge> <tcp,udp> <hostname:port>
	capture netflow bridge <bridge> <filename>

Note: the capture API is not fully namespace-aware and should be used with
caution. See notes below.

Capture experiment data including netflow and PCAP. Netflow capture obtains
netflow data from any local openvswitch switch, and can write to file, another
socket, or both. Netflow data can be written out in raw or ascii format, and
file output can be compressed on the fly. Multiple netflow writers can be
configured. There are several APIs to configure new netflow captures:

	capture netflow mode [raw,ascii]
	capture netflow gzip [true,false]
	capture netflow timeout [timeout]

PCAP capture can be from a bridge or VM interface. To set the snaplen or filter
for new PCAP captures, use:

	capture pcap snaplen <size>
	capture pcap filter <bpf>

Examples:

	# Capture netflow for mega_bridge to foo.netflow
	capture netflow bridge mega_bridge foo.netflow

	# Capture all bridge foo traffic to foo.pcap
	capture pcap bridge foo foo.pcap

	# Capture the 0-th interface for VM foo to foo.pcap
	capture pcap vm foo 0 foo.pcap

When run without arguments, capture prints all running captures. To stop a
capture, use the delete commands:

	capture netflow delete bridge <bridge>
	capture pcap delete bridge <bridge>
	capture pcap delete vm <name>

To stop all captures of a particular kind, replace <bridge> or <vm> with "all".
If a VM has multiple interfaces and there are multiple captures running,
calling "capture pcap delete vm <name>" stops all the captures for that VM. To
stop all captures of all types, use "clear capture".

Notes with namespaces:
 * Capturing traffic directly from the bridge (as PCAP or netflow) is not
   recommended if different namespaces share the same bridge. If this is the
   case, the captured traffic would contain data from across namespaces.
 * Due to the way Open vSwitch implements netflow, there can be only one
   netflow object per bridge. This means that the netflow timeout is shared
   across namespaces. Additionally, note that the API is also not
   bridge-specific.

Due to the above intricacies, the following commands only run on the local
minimega instance:

	capture <netflow,> <bridge,> <bridge> <filename>
	capture <netflow,> <bridge,> <bridge> <tcp,udp> <hostname:port>
	capture <netflow,> <delete,> bridge <name>
	capture <netflow,> <timeout,> [timeout in seconds]
	capture <pcap,> bridge <bridge> <filename>
	capture <pcap,> <delete,> bridge <name>
		'''
		# capture netflow bridge <bridge> <tcp,udp> <hostname:port>
		if bridge != None and tcp_or_udp != None and hostname_port != None:
			# Validate that choice was valid for tcp_or_udp
			if tcp_or_udp not in ["tcp","udp",]:
				raise ValueError("invalid value for tcp_or_udp")
			return self._run("capture", "netflow", "bridge", bridge, tcp_or_udp, hostname_port)
	
		# capture netflow bridge <bridge> <filename>
		if bridge != None and filename != None:
			return self._run("capture", "netflow", "bridge", bridge, filename)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture_netflow_delete_bridge(self,name,):
		'''
Variants:
	capture netflow delete bridge <name>

Note: the capture API is not fully namespace-aware and should be used with
caution. See notes below.

Capture experiment data including netflow and PCAP. Netflow capture obtains
netflow data from any local openvswitch switch, and can write to file, another
socket, or both. Netflow data can be written out in raw or ascii format, and
file output can be compressed on the fly. Multiple netflow writers can be
configured. There are several APIs to configure new netflow captures:

	capture netflow mode [raw,ascii]
	capture netflow gzip [true,false]
	capture netflow timeout [timeout]

PCAP capture can be from a bridge or VM interface. To set the snaplen or filter
for new PCAP captures, use:

	capture pcap snaplen <size>
	capture pcap filter <bpf>

Examples:

	# Capture netflow for mega_bridge to foo.netflow
	capture netflow bridge mega_bridge foo.netflow

	# Capture all bridge foo traffic to foo.pcap
	capture pcap bridge foo foo.pcap

	# Capture the 0-th interface for VM foo to foo.pcap
	capture pcap vm foo 0 foo.pcap

When run without arguments, capture prints all running captures. To stop a
capture, use the delete commands:

	capture netflow delete bridge <bridge>
	capture pcap delete bridge <bridge>
	capture pcap delete vm <name>

To stop all captures of a particular kind, replace <bridge> or <vm> with "all".
If a VM has multiple interfaces and there are multiple captures running,
calling "capture pcap delete vm <name>" stops all the captures for that VM. To
stop all captures of all types, use "clear capture".

Notes with namespaces:
 * Capturing traffic directly from the bridge (as PCAP or netflow) is not
   recommended if different namespaces share the same bridge. If this is the
   case, the captured traffic would contain data from across namespaces.
 * Due to the way Open vSwitch implements netflow, there can be only one
   netflow object per bridge. This means that the netflow timeout is shared
   across namespaces. Additionally, note that the API is also not
   bridge-specific.

Due to the above intricacies, the following commands only run on the local
minimega instance:

	capture <netflow,> <bridge,> <bridge> <filename>
	capture <netflow,> <bridge,> <bridge> <tcp,udp> <hostname:port>
	capture <netflow,> <delete,> bridge <name>
	capture <netflow,> <timeout,> [timeout in seconds]
	capture <pcap,> bridge <bridge> <filename>
	capture <pcap,> <delete,> bridge <name>
		'''
		# capture netflow delete bridge <name>
		if name != None:
			return self._run("capture", "netflow", "delete", "bridge", name)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture_netflow_gzip(self,true_or_false=None,):
		'''
Variants:
	capture netflow gzip <true,false>
	capture netflow gzip

configure captures
		'''
		# capture netflow gzip <true,false>
		if true_or_false != None:
			# Validate that choice was valid for true_or_false
			if true_or_false not in ["true","false",]:
				raise ValueError("invalid value for true_or_false")
			return self._run("capture", "netflow", "gzip", true_or_false)
	
		# capture netflow gzip
		if True:
			return self._run("capture", "netflow", "gzip")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture_netflow_mode(self,raw_or_ascii=None,):
		'''
Variants:
	capture netflow mode <raw,ascii>
	capture netflow mode

configure captures
		'''
		# capture netflow mode <raw,ascii>
		if raw_or_ascii != None:
			# Validate that choice was valid for raw_or_ascii
			if raw_or_ascii not in ["raw","ascii",]:
				raise ValueError("invalid value for raw_or_ascii")
			return self._run("capture", "netflow", "mode", raw_or_ascii)
	
		# capture netflow mode
		if True:
			return self._run("capture", "netflow", "mode")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture_netflow_timeout(self,timeout=None,):
		'''
Variants:
	capture netflow timeout <timeout in seconds>
	capture netflow timeout

Note: the capture API is not fully namespace-aware and should be used with
caution. See notes below.

Capture experiment data including netflow and PCAP. Netflow capture obtains
netflow data from any local openvswitch switch, and can write to file, another
socket, or both. Netflow data can be written out in raw or ascii format, and
file output can be compressed on the fly. Multiple netflow writers can be
configured. There are several APIs to configure new netflow captures:

	capture netflow mode [raw,ascii]
	capture netflow gzip [true,false]
	capture netflow timeout [timeout]

PCAP capture can be from a bridge or VM interface. To set the snaplen or filter
for new PCAP captures, use:

	capture pcap snaplen <size>
	capture pcap filter <bpf>

Examples:

	# Capture netflow for mega_bridge to foo.netflow
	capture netflow bridge mega_bridge foo.netflow

	# Capture all bridge foo traffic to foo.pcap
	capture pcap bridge foo foo.pcap

	# Capture the 0-th interface for VM foo to foo.pcap
	capture pcap vm foo 0 foo.pcap

When run without arguments, capture prints all running captures. To stop a
capture, use the delete commands:

	capture netflow delete bridge <bridge>
	capture pcap delete bridge <bridge>
	capture pcap delete vm <name>

To stop all captures of a particular kind, replace <bridge> or <vm> with "all".
If a VM has multiple interfaces and there are multiple captures running,
calling "capture pcap delete vm <name>" stops all the captures for that VM. To
stop all captures of all types, use "clear capture".

Notes with namespaces:
 * Capturing traffic directly from the bridge (as PCAP or netflow) is not
   recommended if different namespaces share the same bridge. If this is the
   case, the captured traffic would contain data from across namespaces.
 * Due to the way Open vSwitch implements netflow, there can be only one
   netflow object per bridge. This means that the netflow timeout is shared
   across namespaces. Additionally, note that the API is also not
   bridge-specific.

Due to the above intricacies, the following commands only run on the local
minimega instance:

	capture <netflow,> <bridge,> <bridge> <filename>
	capture <netflow,> <bridge,> <bridge> <tcp,udp> <hostname:port>
	capture <netflow,> <delete,> bridge <name>
	capture <netflow,> <timeout,> [timeout in seconds]
	capture <pcap,> bridge <bridge> <filename>
	capture <pcap,> <delete,> bridge <name>
		'''
		# capture netflow timeout <timeout in seconds>
		if timeout != None:
			return self._run("capture", "netflow", "timeout", timeout)
	
		# capture netflow timeout
		if True:
			return self._run("capture", "netflow", "timeout")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture_pcap_bridge(self,bridge,filename,):
		'''
Variants:
	capture pcap bridge <bridge> <filename>

Note: the capture API is not fully namespace-aware and should be used with
caution. See notes below.

Capture experiment data including netflow and PCAP. Netflow capture obtains
netflow data from any local openvswitch switch, and can write to file, another
socket, or both. Netflow data can be written out in raw or ascii format, and
file output can be compressed on the fly. Multiple netflow writers can be
configured. There are several APIs to configure new netflow captures:

	capture netflow mode [raw,ascii]
	capture netflow gzip [true,false]
	capture netflow timeout [timeout]

PCAP capture can be from a bridge or VM interface. To set the snaplen or filter
for new PCAP captures, use:

	capture pcap snaplen <size>
	capture pcap filter <bpf>

Examples:

	# Capture netflow for mega_bridge to foo.netflow
	capture netflow bridge mega_bridge foo.netflow

	# Capture all bridge foo traffic to foo.pcap
	capture pcap bridge foo foo.pcap

	# Capture the 0-th interface for VM foo to foo.pcap
	capture pcap vm foo 0 foo.pcap

When run without arguments, capture prints all running captures. To stop a
capture, use the delete commands:

	capture netflow delete bridge <bridge>
	capture pcap delete bridge <bridge>
	capture pcap delete vm <name>

To stop all captures of a particular kind, replace <bridge> or <vm> with "all".
If a VM has multiple interfaces and there are multiple captures running,
calling "capture pcap delete vm <name>" stops all the captures for that VM. To
stop all captures of all types, use "clear capture".

Notes with namespaces:
 * Capturing traffic directly from the bridge (as PCAP or netflow) is not
   recommended if different namespaces share the same bridge. If this is the
   case, the captured traffic would contain data from across namespaces.
 * Due to the way Open vSwitch implements netflow, there can be only one
   netflow object per bridge. This means that the netflow timeout is shared
   across namespaces. Additionally, note that the API is also not
   bridge-specific.

Due to the above intricacies, the following commands only run on the local
minimega instance:

	capture <netflow,> <bridge,> <bridge> <filename>
	capture <netflow,> <bridge,> <bridge> <tcp,udp> <hostname:port>
	capture <netflow,> <delete,> bridge <name>
	capture <netflow,> <timeout,> [timeout in seconds]
	capture <pcap,> bridge <bridge> <filename>
	capture <pcap,> <delete,> bridge <name>
		'''
		# capture pcap bridge <bridge> <filename>
		if bridge != None and filename != None:
			return self._run("capture", "pcap", "bridge", bridge, filename)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture_pcap_delete_bridge(self,bridge,):
		'''
Variants:
	capture pcap delete bridge <bridge>

Note: the capture API is not fully namespace-aware and should be used with
caution. See notes below.

Capture experiment data including netflow and PCAP. Netflow capture obtains
netflow data from any local openvswitch switch, and can write to file, another
socket, or both. Netflow data can be written out in raw or ascii format, and
file output can be compressed on the fly. Multiple netflow writers can be
configured. There are several APIs to configure new netflow captures:

	capture netflow mode [raw,ascii]
	capture netflow gzip [true,false]
	capture netflow timeout [timeout]

PCAP capture can be from a bridge or VM interface. To set the snaplen or filter
for new PCAP captures, use:

	capture pcap snaplen <size>
	capture pcap filter <bpf>

Examples:

	# Capture netflow for mega_bridge to foo.netflow
	capture netflow bridge mega_bridge foo.netflow

	# Capture all bridge foo traffic to foo.pcap
	capture pcap bridge foo foo.pcap

	# Capture the 0-th interface for VM foo to foo.pcap
	capture pcap vm foo 0 foo.pcap

When run without arguments, capture prints all running captures. To stop a
capture, use the delete commands:

	capture netflow delete bridge <bridge>
	capture pcap delete bridge <bridge>
	capture pcap delete vm <name>

To stop all captures of a particular kind, replace <bridge> or <vm> with "all".
If a VM has multiple interfaces and there are multiple captures running,
calling "capture pcap delete vm <name>" stops all the captures for that VM. To
stop all captures of all types, use "clear capture".

Notes with namespaces:
 * Capturing traffic directly from the bridge (as PCAP or netflow) is not
   recommended if different namespaces share the same bridge. If this is the
   case, the captured traffic would contain data from across namespaces.
 * Due to the way Open vSwitch implements netflow, there can be only one
   netflow object per bridge. This means that the netflow timeout is shared
   across namespaces. Additionally, note that the API is also not
   bridge-specific.

Due to the above intricacies, the following commands only run on the local
minimega instance:

	capture <netflow,> <bridge,> <bridge> <filename>
	capture <netflow,> <bridge,> <bridge> <tcp,udp> <hostname:port>
	capture <netflow,> <delete,> bridge <name>
	capture <netflow,> <timeout,> [timeout in seconds]
	capture <pcap,> bridge <bridge> <filename>
	capture <pcap,> <delete,> bridge <name>
		'''
		# capture pcap delete bridge <bridge>
		if bridge != None:
			return self._run("capture", "pcap", "delete", "bridge", bridge)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture_pcap_delete_vm(self,vm,):
		'''
Variants:
	capture pcap delete vm <vm name>

capture experiment data for a VM
		'''
		# capture pcap delete vm <vm name>
		if vm != None:
			return self._run("capture", "pcap", "delete", "vm", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture_pcap_filter(self,bpf=None,):
		'''
Variants:
	capture pcap filter <bpf>
	capture pcap filter

configure captures
		'''
		# capture pcap filter <bpf>
		if bpf != None:
			return self._run("capture", "pcap", "filter", bpf)
	
		# capture pcap filter
		if True:
			return self._run("capture", "pcap", "filter")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture_pcap_snaplen(self,size=None,):
		'''
Variants:
	capture pcap snaplen <size>
	capture pcap snaplen

configure captures
		'''
		# capture pcap snaplen <size>
		if size != None:
			return self._run("capture", "pcap", "snaplen", size)
	
		# capture pcap snaplen
		if True:
			return self._run("capture", "pcap", "snaplen")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def capture_pcap_vm(self,vm,interface,filename,):
		'''
Variants:
	capture pcap vm <vm name> <interface index> <filename>

capture experiment data for a VM
		'''
		# capture pcap vm <vm name> <interface index> <filename>
		if vm != None and interface != None and filename != None:
			return self._run("capture", "pcap", "vm", vm, interface, filename)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc(self,):
		'''
Variants:
	cc

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc
		if True:
			return self._run("cc")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_background(self,command,):
		'''
Variants:
	cc background <command>...

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc background <command>...
		if command != None:
			return self._run("cc", "background", command)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_clients(self,):
		'''
Variants:
	cc clients

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc clients
		if True:
			return self._run("cc", "clients")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_commands(self,):
		'''
Variants:
	cc commands

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc commands
		if True:
			return self._run("cc", "commands")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_delete_command(self,id,):
		'''
Variants:
	cc delete command <id or prefix or all>

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc delete command <id or prefix or all>
		if id != None:
			return self._run("cc", "delete", "command", id)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_delete_response(self,id,):
		'''
Variants:
	cc delete response <id or prefix or all>

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc delete response <id or prefix or all>
		if id != None:
			return self._run("cc", "delete", "response", id)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_exec(self,command,):
		'''
Variants:
	cc exec <command>...

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc exec <command>...
		if command != None:
			return self._run("cc", "exec", command)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_filter(self,filter=None,):
		'''
Variants:
	cc filter <filter>...
	cc filter

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc filter <filter>...
		if filter != None:
			return self._run("cc", "filter", filter)
	
		# cc filter
		if True:
			return self._run("cc", "filter")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_listen(self,port,):
		'''
Variants:
	cc listen <port>

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc listen <port>
		if port != None:
			return self._run("cc", "listen", port)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_log_level(self,debug_or_info_or_warn_or_error_or_fatal,):
		'''
Variants:
	cc log level <debug,info,warn,error,fatal>

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc log level <debug,info,warn,error,fatal>
		if debug_or_info_or_warn_or_error_or_fatal != None:
			# Validate that choice was valid for debug_or_info_or_warn_or_error_or_fatal
			if debug_or_info_or_warn_or_error_or_fatal not in ["debug","info","warn","error","fatal",]:
				raise ValueError("invalid value for debug_or_info_or_warn_or_error_or_fatal")
			return self._run("cc", "log", "level", debug_or_info_or_warn_or_error_or_fatal)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_mount(self,uuid=None,path=None,):
		'''
Variants:
	cc mount <uuid or name> <path>
	cc mount <uuid or name>
	cc mount

list mounted filesystems
		'''
		# cc mount <uuid or name> <path>
		if uuid != None and path != None:
			return self._run("cc", "mount", uuid, path)
	
		# cc mount <uuid or name>
		if uuid != None:
			return self._run("cc", "mount", uuid)
	
		# cc mount
		if True:
			return self._run("cc", "mount")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_prefix(self,prefix=None,):
		'''
Variants:
	cc prefix <prefix>
	cc prefix

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc prefix <prefix>
		if prefix != None:
			return self._run("cc", "prefix", prefix)
	
		# cc prefix
		if True:
			return self._run("cc", "prefix")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_process_kill(self,pid,):
		'''
Variants:
	cc process kill <pid or all>

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc process kill <pid or all>
		if pid != None:
			return self._run("cc", "process", "kill", pid)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_process_killall(self,name,):
		'''
Variants:
	cc process killall <name>

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc process killall <name>
		if name != None:
			return self._run("cc", "process", "killall", name)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_process_list(self,vm,):
		'''
Variants:
	cc process list <vm name, uuid or all>

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc process list <vm name, uuid or all>
		if vm != None:
			return self._run("cc", "process", "list", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_recv(self,file,):
		'''
Variants:
	cc recv <file>...

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc recv <file>...
		if file != None:
			return self._run("cc", "recv", file)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_responses(self,id,raw=None,):
		'''
Variants:
	cc responses <id or prefix or all> <raw,>
	cc responses <id or prefix or all>

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc responses <id or prefix or all> <raw,>
		if id != None and raw != None:
			return self._run("cc", "responses", id, raw)
	
		# cc responses <id or prefix or all>
		if id != None:
			return self._run("cc", "responses", id)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_rtunnel(self,src,host,dst,):
		'''
Variants:
	cc rtunnel <src port> <host> <dst port>

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc rtunnel <src port> <host> <dst port>
		if src != None and host != None and dst != None:
			return self._run("cc", "rtunnel", src, host, dst)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_send(self,file,):
		'''
Variants:
	cc send <file>...

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc send <file>...
		if file != None:
			return self._run("cc", "send", file)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def cc_tunnel(self,vm,src,host,dst,):
		'''
Variants:
	cc tunnel <vm name or uuid> <src port> <host> <dst port>

Command and control for VMs running the miniccc client. Commands may include
regular commands, backgrounded commands, and any number of sent and/or received
files. Commands will be executed in command creation order. For example, to
send a file 'foo' and display the contents on a remote VM:

	cc send foo
	cc exec cat foo

Files to be sent must be in the filepath directory, as set by the -filepath
flag when launching minimega.

Executed commands can have their stdio tied to pipes used by the plumb and pipe
APIs. To use named pipes, simply specify stdin, stdout, or stderr as a
key=value pair. For example:

	cc exec stderr=foo cat server.log
	cc background stdin=foo stdout=bar /usr/bin/program

Responses are organized in a structure within <filepath>/miniccc_responses, and
include subdirectories for each client response named by the client's UUID.
Responses can also be displayed on the command line with the 'responses'
command.

Filters may be set to limit which clients may execute a posted command.  For
example, to filter on VMs that are running windows and have a specific IP.

	cc filter os=windows ip=10.0.0.1

Users can also filter by VM tags. For example, to filter on VMs that have the
tag with key foo and value bar set:

	cc filter tag=foo:bar

If users wish, they may drop the tag= prefix and key=value pairs will be
treated as tags:

	cc filter foo=bar

Users can also filter by any column in "vm info" using a similar syntax:

	cc filter name=server
	cc filter vlan=DMZ

"vm info" columns take precedance over tags when both define the same key.

"cc mount" allows direct access to a guest's filesystem over the command and
control connection. When given a VM uuid or name and a path, the VM's
filesystem is mounted to the local machine at the provided path. "cc mount"
without arguments displays the existing mounts. Users can use "clear cc mount"
to unmount the filesystem of one or all VMs. This should be done before killing
or stopping the VM ("clear namespace <name>" will handle this automatically).

For more documentation, see the article "Command and Control API Tutorial".
		'''
		# cc tunnel <vm name or uuid> <src port> <host> <dst port>
		if vm != None and src != None and host != None and dst != None:
			return self._run("cc", "tunnel", vm, src, host, dst)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def check(self,):
		'''
Variants:
	check

minimega maintains a list of external packages that it depends on, such as
qemu. Calling check will attempt to find each of these executables in the
avaiable path and check to make sure they meet the minimum version
requirements. Returns errors for all missing executables and all minimum
versions not met.
		'''
		# check
		if True:
			return self._run("check")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_all(self,):
		'''
Variants:
	clear all

Runs all the "clear ..." handlers on the local instance -- as close to nuke as
you can get without restarting minimega. Restarting minimega is preferable.
		'''
		# clear all
		if True:
			return self._run("clear", "all")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_capture(self,netflow_or_pcap=None,):
		'''
Variants:
	clear capture <netflow,pcap>
	clear capture

Resets state for captures across the namespace. See "help capture" for more
information.
		'''
		# clear capture <netflow,pcap>
		if netflow_or_pcap != None:
			# Validate that choice was valid for netflow_or_pcap
			if netflow_or_pcap not in ["netflow","pcap",]:
				raise ValueError("invalid value for netflow_or_pcap")
			return self._run("clear", "capture", netflow_or_pcap)
	
		# clear capture
		if True:
			return self._run("clear", "capture")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_cc(self,):
		'''
Variants:
	clear cc

Resets state for the command and control infrastructure provided by minimega.
See "help cc" for more information.
		'''
		# clear cc
		if True:
			return self._run("clear", "cc")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_cc_commands(self,):
		'''
Variants:
	clear cc commands

Resets state for the command and control infrastructure provided by minimega.
See "help cc" for more information.
		'''
		# clear cc commands
		if True:
			return self._run("clear", "cc", "commands")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_cc_filter(self,):
		'''
Variants:
	clear cc filter

Resets state for the command and control infrastructure provided by minimega.
See "help cc" for more information.
		'''
		# clear cc filter
		if True:
			return self._run("clear", "cc", "filter")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_cc_mount(self,uuid=None,):
		'''
Variants:
	clear cc mount <uuid or name or path>
	clear cc mount

unmount VM filesystem
		'''
		# clear cc mount <uuid or name or path>
		if uuid != None:
			return self._run("clear", "cc", "mount", uuid)
	
		# clear cc mount
		if True:
			return self._run("clear", "cc", "mount")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_cc_prefix(self,):
		'''
Variants:
	clear cc prefix

Resets state for the command and control infrastructure provided by minimega.
See "help cc" for more information.
		'''
		# clear cc prefix
		if True:
			return self._run("clear", "cc", "prefix")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_cc_responses(self,):
		'''
Variants:
	clear cc responses

Resets state for the command and control infrastructure provided by minimega.
See "help cc" for more information.
		'''
		# clear cc responses
		if True:
			return self._run("clear", "cc", "responses")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_deploy_flags(self,):
		'''
Variants:
	clear deploy flags

Reset the deploy flags to their default value, which is equal to the launch
flags used when launching minimega.
		'''
		# clear deploy flags
		if True:
			return self._run("clear", "deploy", "flags")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_history(self,):
		'''
Variants:
	clear history

Reset the command history. See "help history" for more information.
		'''
		# clear history
		if True:
			return self._run("clear", "history")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_log(self,):
		'''
Variants:
	clear log

Resets state for logging. See "help log ..." for more information.
		'''
		# clear log
		if True:
			return self._run("clear", "log")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_log_file(self,):
		'''
Variants:
	clear log file

Resets state for logging. See "help log ..." for more information.
		'''
		# clear log file
		if True:
			return self._run("clear", "log", "file")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_log_filter(self,):
		'''
Variants:
	clear log filter

Resets state for logging. See "help log ..." for more information.
		'''
		# clear log filter
		if True:
			return self._run("clear", "log", "filter")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_log_level(self,):
		'''
Variants:
	clear log level

Resets state for logging. See "help log ..." for more information.
		'''
		# clear log level
		if True:
			return self._run("clear", "log", "level")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_log_ring(self,):
		'''
Variants:
	clear log ring

Resets state for logging. See "help log ..." for more information.
		'''
		# clear log ring
		if True:
			return self._run("clear", "log", "ring")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_log_stderr(self,):
		'''
Variants:
	clear log stderr

Resets state for logging. See "help log ..." for more information.
		'''
		# clear log stderr
		if True:
			return self._run("clear", "log", "stderr")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_log_syslog(self,):
		'''
Variants:
	clear log syslog

Resets state for logging. See "help log ..." for more information.
		'''
		# clear log syslog
		if True:
			return self._run("clear", "log", "syslog")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_optimize(self,):
		'''
Variants:
	clear optimize

Resets state for virtualization optimizations. See "help optimize" for more
information.
		'''
		# clear optimize
		if True:
			return self._run("clear", "optimize")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_optimize_affinity(self,filter=None,):
		'''
Variants:
	clear optimize affinity <filter,>
	clear optimize affinity

Resets state for virtualization optimizations. See "help optimize" for more
information.
		'''
		# clear optimize affinity <filter,>
		if filter != None:
			return self._run("clear", "optimize", "affinity", filter)
	
		# clear optimize affinity
		if True:
			return self._run("clear", "optimize", "affinity")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_optimize_hugepages(self,):
		'''
Variants:
	clear optimize hugepages

Resets state for virtualization optimizations. See "help optimize" for more
information.
		'''
		# clear optimize hugepages
		if True:
			return self._run("clear", "optimize", "hugepages")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_optimize_ksm(self,):
		'''
Variants:
	clear optimize ksm

Resets state for virtualization optimizations. See "help optimize" for more
information.
		'''
		# clear optimize ksm
		if True:
			return self._run("clear", "optimize", "ksm")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_pipe(self,pipe=None,):
		'''
Variants:
	clear pipe <pipe>
	clear pipe

reset pipe state
		'''
		# clear pipe <pipe>
		if pipe != None:
			return self._run("clear", "pipe", pipe)
	
		# clear pipe
		if True:
			return self._run("clear", "pipe")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_pipe_log(self,pipe,):
		'''
Variants:
	clear pipe <pipe> log

reset pipe state
		'''
		# clear pipe <pipe> log
		if pipe != None:
			return self._run("clear", "pipe", pipe, "log")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_pipe_mode(self,pipe,):
		'''
Variants:
	clear pipe <pipe> mode

reset pipe state
		'''
		# clear pipe <pipe> mode
		if pipe != None:
			return self._run("clear", "pipe", pipe, "mode")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_pipe_via(self,pipe,):
		'''
Variants:
	clear pipe <pipe> via

reset pipe state
		'''
		# clear pipe <pipe> via
		if pipe != None:
			return self._run("clear", "pipe", pipe, "via")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_plumb(self,pipeline=None,):
		'''
Variants:
	clear plumb <pipeline>...
	clear plumb

reset plumber state
		'''
		# clear plumb <pipeline>...
		if pipeline != None:
			return self._run("clear", "plumb", pipeline)
	
		# clear plumb
		if True:
			return self._run("clear", "plumb")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_qos(self,vm,tap=None,):
		'''
Variants:
	clear qos <vm target> <tap index>
	clear qos <vm target>

Remove QoS constraints from a VM's interface. To clear QoS from all interfaces
for a VM, use the wildcard:

	clear qos foo all

See "vm start" for a full description of allowable targets.
		'''
		# clear qos <vm target> <tap index>
		if vm != None and tap != None:
			return self._run("clear", "qos", vm, tap)
	
		# clear qos <vm target>
		if vm != None:
			return self._run("clear", "qos", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router(self,vm=None,):
		'''
Variants:
	clear router <vm>
	clear router


		'''
		# clear router <vm>
		if vm != None:
			return self._run("clear", "router", vm)
	
		# clear router
		if True:
			return self._run("clear", "router")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_dhcp(self,vm,listen=None,):
		'''
Variants:
	clear router <vm> dhcp <listen address>
	clear router <vm> dhcp


		'''
		# clear router <vm> dhcp <listen address>
		if vm != None and listen != None:
			return self._run("clear", "router", vm, "dhcp", listen)
	
		# clear router <vm> dhcp
		if vm != None:
			return self._run("clear", "router", vm, "dhcp")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_dhcp_dns(self,vm,listen,):
		'''
Variants:
	clear router <vm> dhcp <listen address> dns


		'''
		# clear router <vm> dhcp <listen address> dns
		if vm != None and listen != None:
			return self._run("clear", "router", vm, "dhcp", listen, "dns")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_dhcp_range(self,vm,listen,):
		'''
Variants:
	clear router <vm> dhcp <listen address> range


		'''
		# clear router <vm> dhcp <listen address> range
		if vm != None and listen != None:
			return self._run("clear", "router", vm, "dhcp", listen, "range")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_dhcp_router(self,vm,listen,):
		'''
Variants:
	clear router <vm> dhcp <listen address> router


		'''
		# clear router <vm> dhcp <listen address> router
		if vm != None and listen != None:
			return self._run("clear", "router", vm, "dhcp", listen, "router")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_dhcp_static(self,vm,listen,mac=None,):
		'''
Variants:
	clear router <vm> dhcp <listen address> static <mac>
	clear router <vm> dhcp <listen address> static


		'''
		# clear router <vm> dhcp <listen address> static <mac>
		if vm != None and listen != None and mac != None:
			return self._run("clear", "router", vm, "dhcp", listen, "static", mac)
	
		# clear router <vm> dhcp <listen address> static
		if vm != None and listen != None:
			return self._run("clear", "router", vm, "dhcp", listen, "static")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_dns(self,vm,ip=None,):
		'''
Variants:
	clear router <vm> dns <ip>
	clear router <vm> dns


		'''
		# clear router <vm> dns <ip>
		if vm != None and ip != None:
			return self._run("clear", "router", vm, "dns", ip)
	
		# clear router <vm> dns
		if vm != None:
			return self._run("clear", "router", vm, "dns")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_gw(self,vm,):
		'''
Variants:
	clear router <vm> gw


		'''
		# clear router <vm> gw
		if vm != None:
			return self._run("clear", "router", vm, "gw")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_interface(self,vm,network=None,IPv4_MASK=None,lo=None,):
		'''
Variants:
	clear router <vm> interface <network> <IPv4/MASK or IPv6/MASK or dhcp or all> <lo,>
	clear router <vm> interface <network> <IPv4/MASK or IPv6/MASK or dhcp or all>
	clear router <vm> interface <network>
	clear router <vm> interface


		'''
		# clear router <vm> interface <network> <IPv4/MASK or IPv6/MASK or dhcp or all> <lo,>
		if vm != None and network != None and IPv4_MASK != None and lo != None:
			return self._run("clear", "router", vm, "interface", network, IPv4_MASK, lo)
	
		# clear router <vm> interface <network> <IPv4/MASK or IPv6/MASK or dhcp or all>
		if vm != None and network != None and IPv4_MASK != None:
			return self._run("clear", "router", vm, "interface", network, IPv4_MASK)
	
		# clear router <vm> interface <network>
		if vm != None and network != None:
			return self._run("clear", "router", vm, "interface", network)
	
		# clear router <vm> interface
		if vm != None:
			return self._run("clear", "router", vm, "interface")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_ra(self,vm,subnet=None,):
		'''
Variants:
	clear router <vm> ra <subnet>
	clear router <vm> ra


		'''
		# clear router <vm> ra <subnet>
		if vm != None and subnet != None:
			return self._run("clear", "router", vm, "ra", subnet)
	
		# clear router <vm> ra
		if vm != None:
			return self._run("clear", "router", vm, "ra")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_rid(self,vm,):
		'''
Variants:
	clear router <vm> rid


		'''
		# clear router <vm> rid
		if vm != None:
			return self._run("clear", "router", vm, "rid")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_route(self,vm,static_or_namedstatic=None,):
		'''
Variants:
	clear router <vm> route <static,namedstatic>
	clear router <vm> route


		'''
		# clear router <vm> route <static,namedstatic>
		if vm != None and static_or_namedstatic != None:
			# Validate that choice was valid for static_or_namedstatic
			if static_or_namedstatic not in ["static","namedstatic",]:
				raise ValueError("invalid value for static_or_namedstatic")
			return self._run("clear", "router", vm, "route", static_or_namedstatic)
	
		# clear router <vm> route
		if vm != None:
			return self._run("clear", "router", vm, "route")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_route_bgp(self,vm,processname,local_or_neighbor=None,):
		'''
Variants:
	clear router <vm> route bgp <processname> <local,neighbor>
	clear router <vm> route bgp <processname>


		'''
		# clear router <vm> route bgp <processname> <local,neighbor>
		if vm != None and processname != None and local_or_neighbor != None:
			# Validate that choice was valid for local_or_neighbor
			if local_or_neighbor not in ["local","neighbor",]:
				raise ValueError("invalid value for local_or_neighbor")
			return self._run("clear", "router", vm, "route", "bgp", processname, local_or_neighbor)
	
		# clear router <vm> route bgp <processname>
		if vm != None and processname != None:
			return self._run("clear", "router", vm, "route", "bgp", processname)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_route_bgp_rrclient(self,vm,processname,):
		'''
Variants:
	clear router <vm> route bgp <processname> rrclient


		'''
		# clear router <vm> route bgp <processname> rrclient
		if vm != None and processname != None:
			return self._run("clear", "router", vm, "route", "bgp", processname, "rrclient")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_route_ospf(self,vm,area=None,network=None,):
		'''
Variants:
	clear router <vm> route ospf <area> <network>
	clear router <vm> route ospf <area>
	clear router <vm> route ospf


		'''
		# clear router <vm> route ospf <area> <network>
		if vm != None and area != None and network != None:
			return self._run("clear", "router", vm, "route", "ospf", area, network)
	
		# clear router <vm> route ospf <area>
		if vm != None and area != None:
			return self._run("clear", "router", vm, "route", "ospf", area)
	
		# clear router <vm> route ospf
		if vm != None:
			return self._run("clear", "router", vm, "route", "ospf")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_route_ospf_export(self,vm,area,Ipv4_Mask,):
		'''
Variants:
	clear router <vm> route ospf <area> export <Ipv4/Mask or staticroutename>


		'''
		# clear router <vm> route ospf <area> export <Ipv4/Mask or staticroutename>
		if vm != None and area != None and Ipv4_Mask != None:
			return self._run("clear", "router", vm, "route", "ospf", area, "export", Ipv4_Mask)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_route_static(self,vm,network,staticroutename=None,):
		'''
Variants:
	clear router <vm> route static <network or all> <staticroutename>
	clear router <vm> route static <network or all>


		'''
		# clear router <vm> route static <network or all> <staticroutename>
		if vm != None and network != None and staticroutename != None:
			return self._run("clear", "router", vm, "route", "static", network, staticroutename)
	
		# clear router <vm> route static <network or all>
		if vm != None and network != None:
			return self._run("clear", "router", vm, "route", "static", network)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_router_upstream(self,vm,):
		'''
Variants:
	clear router <vm> upstream


		'''
		# clear router <vm> upstream
		if vm != None:
			return self._run("clear", "router", vm, "upstream")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_tap(self,):
		'''
Variants:
	clear tap

Reset state for taps. To delete individual taps, use "tap delete".

"clear tap mirror" can be used to delete one or all mirrors. Mirrors are
identified by the destination for the mirror since a source can have multiple
mirrors. "clear tap" also deletes all mirrors.

Only affects taps on the local node.
		'''
		# clear tap
		if True:
			return self._run("clear", "tap")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_tap_mirror(self,name=None,vm=None,interface=None,):
		'''
Variants:
	clear tap mirror <vm name> <interface index or all>
	clear tap mirror <name>
	clear tap mirror

Reset state for taps. To delete individual taps, use "tap delete".

"clear tap mirror" can be used to delete one or all mirrors. Mirrors are
identified by the destination for the mirror since a source can have multiple
mirrors. "clear tap" also deletes all mirrors.

Only affects taps on the local node.
		'''
		# clear tap mirror <vm name> <interface index or all>
		if vm != None and interface != None:
			return self._run("clear", "tap", "mirror", vm, interface)
	
		# clear tap mirror <name>
		if name != None:
			return self._run("clear", "tap", "mirror", name)
	
		# clear tap mirror
		if True:
			return self._run("clear", "tap", "mirror")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vlans(self,prefix=None,):
		'''
Variants:
	clear vlans <prefix>
	clear vlans

Clear one or more aliases, freeing the VLANs for reuse. You should only clear
allocated VLANs once you have killed all the VMs connected to them.

By default, "clear vlans" only clears aliases for the current namespace. If
given "all" as the prefix, all state about managed VLANs is cleared across
*all* namespaces, including blacklisted VLANS. You should only use this if you
want a completely clean slate.
		'''
		# clear vlans <prefix>
		if prefix != None:
			return self._run("clear", "vlans", prefix)
	
		# clear vlans
		if True:
			return self._run("clear", "vlans")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config(self,):
		'''
Variants:
	clear vm config

reset one or more configurations to default value
		'''
		# clear vm config
		if True:
			return self._run("clear", "vm", "config")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_append(self,):
		'''
Variants:
	clear vm config append

reset one or more configurations to default value
		'''
		# clear vm config append
		if True:
			return self._run("clear", "vm", "config", "append")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_backchannel(self,):
		'''
Variants:
	clear vm config backchannel

reset one or more configurations to default value
		'''
		# clear vm config backchannel
		if True:
			return self._run("clear", "vm", "config", "backchannel")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_cdrom(self,):
		'''
Variants:
	clear vm config cdrom

reset one or more configurations to default value
		'''
		# clear vm config cdrom
		if True:
			return self._run("clear", "vm", "config", "cdrom")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_colocate(self,):
		'''
Variants:
	clear vm config colocate

reset one or more configurations to default value
		'''
		# clear vm config colocate
		if True:
			return self._run("clear", "vm", "config", "colocate")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_cores(self,):
		'''
Variants:
	clear vm config cores

reset one or more configurations to default value
		'''
		# clear vm config cores
		if True:
			return self._run("clear", "vm", "config", "cores")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_coschedule(self,):
		'''
Variants:
	clear vm config coschedule

reset one or more configurations to default value
		'''
		# clear vm config coschedule
		if True:
			return self._run("clear", "vm", "config", "coschedule")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_cpu(self,):
		'''
Variants:
	clear vm config cpu

reset one or more configurations to default value
		'''
		# clear vm config cpu
		if True:
			return self._run("clear", "vm", "config", "cpu")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_disks(self,):
		'''
Variants:
	clear vm config disks

reset one or more configurations to default value
		'''
		# clear vm config disks
		if True:
			return self._run("clear", "vm", "config", "disks")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_fifos(self,):
		'''
Variants:
	clear vm config fifos

reset one or more configurations to default value
		'''
		# clear vm config fifos
		if True:
			return self._run("clear", "vm", "config", "fifos")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_filesystem(self,):
		'''
Variants:
	clear vm config filesystem

reset one or more configurations to default value
		'''
		# clear vm config filesystem
		if True:
			return self._run("clear", "vm", "config", "filesystem")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_hostname(self,):
		'''
Variants:
	clear vm config hostname

reset one or more configurations to default value
		'''
		# clear vm config hostname
		if True:
			return self._run("clear", "vm", "config", "hostname")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_init(self,):
		'''
Variants:
	clear vm config init

reset one or more configurations to default value
		'''
		# clear vm config init
		if True:
			return self._run("clear", "vm", "config", "init")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_initrd(self,):
		'''
Variants:
	clear vm config initrd

reset one or more configurations to default value
		'''
		# clear vm config initrd
		if True:
			return self._run("clear", "vm", "config", "initrd")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_kernel(self,):
		'''
Variants:
	clear vm config kernel

reset one or more configurations to default value
		'''
		# clear vm config kernel
		if True:
			return self._run("clear", "vm", "config", "kernel")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_machine(self,):
		'''
Variants:
	clear vm config machine

reset one or more configurations to default value
		'''
		# clear vm config machine
		if True:
			return self._run("clear", "vm", "config", "machine")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_memory(self,):
		'''
Variants:
	clear vm config memory

reset one or more configurations to default value
		'''
		# clear vm config memory
		if True:
			return self._run("clear", "vm", "config", "memory")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_migrate(self,):
		'''
Variants:
	clear vm config migrate

reset one or more configurations to default value
		'''
		# clear vm config migrate
		if True:
			return self._run("clear", "vm", "config", "migrate")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_networks(self,):
		'''
Variants:
	clear vm config networks

reset one or more configurations to default value
		'''
		# clear vm config networks
		if True:
			return self._run("clear", "vm", "config", "networks")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_preinit(self,):
		'''
Variants:
	clear vm config preinit

reset one or more configurations to default value
		'''
		# clear vm config preinit
		if True:
			return self._run("clear", "vm", "config", "preinit")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_qemu(self,):
		'''
Variants:
	clear vm config qemu

reset one or more configurations to default value
		'''
		# clear vm config qemu
		if True:
			return self._run("clear", "vm", "config", "qemu")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_qemu_append(self,):
		'''
Variants:
	clear vm config qemu-append

reset one or more configurations to default value
		'''
		# clear vm config qemu-append
		if True:
			return self._run("clear", "vm", "config", "qemu-append")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_qemu_override(self,):
		'''
Variants:
	clear vm config qemu-override

reset one or more configurations to default value
		'''
		# clear vm config qemu-override
		if True:
			return self._run("clear", "vm", "config", "qemu-override")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_schedule(self,):
		'''
Variants:
	clear vm config schedule

reset one or more configurations to default value
		'''
		# clear vm config schedule
		if True:
			return self._run("clear", "vm", "config", "schedule")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_serial_ports(self,):
		'''
Variants:
	clear vm config serial-ports

reset one or more configurations to default value
		'''
		# clear vm config serial-ports
		if True:
			return self._run("clear", "vm", "config", "serial-ports")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_snapshot(self,):
		'''
Variants:
	clear vm config snapshot

reset one or more configurations to default value
		'''
		# clear vm config snapshot
		if True:
			return self._run("clear", "vm", "config", "snapshot")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_sockets(self,):
		'''
Variants:
	clear vm config sockets

reset one or more configurations to default value
		'''
		# clear vm config sockets
		if True:
			return self._run("clear", "vm", "config", "sockets")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_tag(self,key,):
		'''
Variants:
	clear vm config tag <key>

Remove tags in the same manner as "clear vm tag".
		'''
		# clear vm config tag <key>
		if key != None:
			return self._run("clear", "vm", "config", "tag", key)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_tags(self,):
		'''
Variants:
	clear vm config tags

reset one or more configurations to default value
		'''
		# clear vm config tags
		if True:
			return self._run("clear", "vm", "config", "tags")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_threads(self,):
		'''
Variants:
	clear vm config threads

reset one or more configurations to default value
		'''
		# clear vm config threads
		if True:
			return self._run("clear", "vm", "config", "threads")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_uuid(self,):
		'''
Variants:
	clear vm config uuid

reset one or more configurations to default value
		'''
		# clear vm config uuid
		if True:
			return self._run("clear", "vm", "config", "uuid")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_vcpus(self,):
		'''
Variants:
	clear vm config vcpus

reset one or more configurations to default value
		'''
		# clear vm config vcpus
		if True:
			return self._run("clear", "vm", "config", "vcpus")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_vga(self,):
		'''
Variants:
	clear vm config vga

reset one or more configurations to default value
		'''
		# clear vm config vga
		if True:
			return self._run("clear", "vm", "config", "vga")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_virtio_ports(self,):
		'''
Variants:
	clear vm config virtio-ports

reset one or more configurations to default value
		'''
		# clear vm config virtio-ports
		if True:
			return self._run("clear", "vm", "config", "virtio-ports")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_config_volume(self,):
		'''
Variants:
	clear vm config volume

reset one or more configurations to default value
		'''
		# clear vm config volume
		if True:
			return self._run("clear", "vm", "config", "volume")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vm_tag(self,vm=None,tag=None,):
		'''
Variants:
	clear vm tag <vm target> <tag>
	clear vm tag <vm target>
	clear vm tag

Clears one, many, or all tags from a virtual machine.

Clear the tag "foo" from VM 0:

        clear vm tag 0 foo

Clear the tag "foo" from all VMs:

        clear vm tag all foo

Clear all tags from VM 0:

        clear vm tag 0

Clear all tags from all VMs:

        clear vm tag all
		'''
		# clear vm tag <vm target> <tag>
		if vm != None and tag != None:
			return self._run("clear", "vm", "tag", vm, tag)
	
		# clear vm tag <vm target>
		if vm != None:
			return self._run("clear", "vm", "tag", vm)
	
		# clear vm tag
		if True:
			return self._run("clear", "vm", "tag")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def clear_vnc(self,):
		'''
Variants:
	clear vnc

Resets the state for VNC recordings. See "help vnc" for more information.
		'''
		# clear vnc
		if True:
			return self._run("clear", "vnc")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def debug(self,):
		'''
Variants:
	debug

debug can help find and resolve issues with minimega. Without arguments, debug
prints the go version, the number of goroutines, and the number of cgo calls.

With arguments, debug writes files that can be read using "go tool pprof":

- memory: sampling of all heap allocations
- cpu: starts CPU profiling (must be stopped before read)
- goroutine: stack traces of all current goroutines
		'''
		# debug
		if True:
			return self._run("debug")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def debug_cpu_start(self,file,):
		'''
Variants:
	debug cpu start <file>

debug can help find and resolve issues with minimega. Without arguments, debug
prints the go version, the number of goroutines, and the number of cgo calls.

With arguments, debug writes files that can be read using "go tool pprof":

- memory: sampling of all heap allocations
- cpu: starts CPU profiling (must be stopped before read)
- goroutine: stack traces of all current goroutines
		'''
		# debug cpu start <file>
		if file != None:
			return self._run("debug", "cpu", "start", file)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def debug_cpu_stop(self,):
		'''
Variants:
	debug cpu stop

debug can help find and resolve issues with minimega. Without arguments, debug
prints the go version, the number of goroutines, and the number of cgo calls.

With arguments, debug writes files that can be read using "go tool pprof":

- memory: sampling of all heap allocations
- cpu: starts CPU profiling (must be stopped before read)
- goroutine: stack traces of all current goroutines
		'''
		# debug cpu stop
		if True:
			return self._run("debug", "cpu", "stop")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def debug_goroutine(self,file,):
		'''
Variants:
	debug goroutine <file>

debug can help find and resolve issues with minimega. Without arguments, debug
prints the go version, the number of goroutines, and the number of cgo calls.

With arguments, debug writes files that can be read using "go tool pprof":

- memory: sampling of all heap allocations
- cpu: starts CPU profiling (must be stopped before read)
- goroutine: stack traces of all current goroutines
		'''
		# debug goroutine <file>
		if file != None:
			return self._run("debug", "goroutine", file)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def debug_memory(self,file,):
		'''
Variants:
	debug memory <file>

debug can help find and resolve issues with minimega. Without arguments, debug
prints the go version, the number of goroutines, and the number of cgo calls.

With arguments, debug writes files that can be read using "go tool pprof":

- memory: sampling of all heap allocations
- cpu: starts CPU profiling (must be stopped before read)
- goroutine: stack traces of all current goroutines
		'''
		# debug memory <file>
		if file != None:
			return self._run("debug", "memory", file)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def deploy_flags(self,minimega=None,):
		'''
Variants:
	deploy flags <minimega flags>...
	deploy flags

deploy copies and runs minimega on remote nodes, facilitating the deployment of
minimega to a cluster. By default, deploy will launch minimega with the same
flags used when starting this minimega, and add the -nostdin flag so that the
remote minimega can be backgrounded. For example, to launch minimega on nodes
kn1 and kn2:

	deploy launch kn[1-2]

deploy uses scp/ssh to copy and run minimega. By default, minimega will attempt
to login to remote nodes using the current user. This can be changed by
providing a username. If using a different username, you can optionally specify
the use of sudo when launching minimega (you typically need to run minimega as
root).

In order to override the flags passed to remote minimega instances, provide
flags with 'deploy flags'. For example:

	deploy flags -base=/opt/minimega -level=debug

To customize stdout and stderr, use 'deploy stdout' and 'deploy stderr':

	deploy stdout /var/log/minimega.out
	deploy stderr /var/log/minimega.err

By default, stdout and stderr are written to /dev/null.
		'''
		# deploy flags <minimega flags>...
		if minimega != None:
			return self._run("deploy", "flags", minimega)
	
		# deploy flags
		if True:
			return self._run("deploy", "flags")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def deploy_launch(self,hosts,user=None,sudo=None,):
		'''
Variants:
	deploy launch <hosts> <user> <sudo,>
	deploy launch <hosts> <user>
	deploy launch <hosts>

deploy copies and runs minimega on remote nodes, facilitating the deployment of
minimega to a cluster. By default, deploy will launch minimega with the same
flags used when starting this minimega, and add the -nostdin flag so that the
remote minimega can be backgrounded. For example, to launch minimega on nodes
kn1 and kn2:

	deploy launch kn[1-2]

deploy uses scp/ssh to copy and run minimega. By default, minimega will attempt
to login to remote nodes using the current user. This can be changed by
providing a username. If using a different username, you can optionally specify
the use of sudo when launching minimega (you typically need to run minimega as
root).

In order to override the flags passed to remote minimega instances, provide
flags with 'deploy flags'. For example:

	deploy flags -base=/opt/minimega -level=debug

To customize stdout and stderr, use 'deploy stdout' and 'deploy stderr':

	deploy stdout /var/log/minimega.out
	deploy stderr /var/log/minimega.err

By default, stdout and stderr are written to /dev/null.
		'''
		# deploy launch <hosts> <user> <sudo,>
		if hosts != None and user != None and sudo != None:
			return self._run("deploy", "launch", hosts, user, sudo)
	
		# deploy launch <hosts> <user>
		if hosts != None and user != None:
			return self._run("deploy", "launch", hosts, user)
	
		# deploy launch <hosts>
		if hosts != None:
			return self._run("deploy", "launch", hosts)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def deploy_stderr(self,path=None,):
		'''
Variants:
	deploy stderr <path>
	deploy stderr

deploy copies and runs minimega on remote nodes, facilitating the deployment of
minimega to a cluster. By default, deploy will launch minimega with the same
flags used when starting this minimega, and add the -nostdin flag so that the
remote minimega can be backgrounded. For example, to launch minimega on nodes
kn1 and kn2:

	deploy launch kn[1-2]

deploy uses scp/ssh to copy and run minimega. By default, minimega will attempt
to login to remote nodes using the current user. This can be changed by
providing a username. If using a different username, you can optionally specify
the use of sudo when launching minimega (you typically need to run minimega as
root).

In order to override the flags passed to remote minimega instances, provide
flags with 'deploy flags'. For example:

	deploy flags -base=/opt/minimega -level=debug

To customize stdout and stderr, use 'deploy stdout' and 'deploy stderr':

	deploy stdout /var/log/minimega.out
	deploy stderr /var/log/minimega.err

By default, stdout and stderr are written to /dev/null.
		'''
		# deploy stderr <path>
		if path != None:
			return self._run("deploy", "stderr", path)
	
		# deploy stderr
		if True:
			return self._run("deploy", "stderr")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def deploy_stdout(self,path=None,):
		'''
Variants:
	deploy stdout <path>
	deploy stdout

deploy copies and runs minimega on remote nodes, facilitating the deployment of
minimega to a cluster. By default, deploy will launch minimega with the same
flags used when starting this minimega, and add the -nostdin flag so that the
remote minimega can be backgrounded. For example, to launch minimega on nodes
kn1 and kn2:

	deploy launch kn[1-2]

deploy uses scp/ssh to copy and run minimega. By default, minimega will attempt
to login to remote nodes using the current user. This can be changed by
providing a username. If using a different username, you can optionally specify
the use of sudo when launching minimega (you typically need to run minimega as
root).

In order to override the flags passed to remote minimega instances, provide
flags with 'deploy flags'. For example:

	deploy flags -base=/opt/minimega -level=debug

To customize stdout and stderr, use 'deploy stdout' and 'deploy stderr':

	deploy stdout /var/log/minimega.out
	deploy stderr /var/log/minimega.err

By default, stdout and stderr are written to /dev/null.
		'''
		# deploy stdout <path>
		if path != None:
			return self._run("deploy", "stdout", path)
	
		# deploy stdout
		if True:
			return self._run("deploy", "stdout")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def disk_create(self,qcow2_or_raw,image,size,):
		'''
Variants:
	disk create <qcow2,raw> <image name> <size>

Manipulate qcow disk images. Supports creating new images, snapshots of
existing images, and injecting one or more files into an existing image.

Example of creating a new disk:

	disk create qcow2 foo.qcow2 100G

The size argument is the size in bytes, or using optional suffixes "k"
(kilobyte), "M" (megabyte), "G" (gigabyte), "T" (terabyte).

Example of taking a snapshot of a disk:

	disk snapshot windows7.qc2 window7_miniccc.qc2

If the destination name is omitted, a name will be randomly generated and the
snapshot will be stored in the 'files' directory. Snapshots are always created
in the 'files' directory.

To inject files into an image:

	disk inject window7_miniccc.qc2 files "miniccc":"Program Files/miniccc"

Each argument after the image should be a source and destination pair,
separated by a ':'. If the file paths contain spaces, use double quotes.
Optionally, you may specify a partition (partition 1 will be used by default):

	disk inject window7_miniccc.qc2:2 files "miniccc":"Program Files/miniccc"

You may also specify that there is no partition on the disk, if your filesystem
was directly written to the disk (this is highly unusual):

	disk inject partitionless_disk.qc2:none files /miniccc:/miniccc

You can optionally specify mount arguments to use with inject. Multiple options
should be quoted. For example:

	disk inject foo.qcow2 options "-t fat -o offset=100" files foo:bar

Disk image paths are always relative to the 'files' directory. Users may also
use absolute paths if desired. The backing images for snapshots should always
be in the files directory.
		'''
		# disk create <qcow2,raw> <image name> <size>
		if qcow2_or_raw != None and image != None and size != None:
			# Validate that choice was valid for qcow2_or_raw
			if qcow2_or_raw not in ["qcow2","raw",]:
				raise ValueError("invalid value for qcow2_or_raw")
			return self._run("disk", "create", qcow2_or_raw, image, size)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def disk_info(self,image,):
		'''
Variants:
	disk info <image>

Manipulate qcow disk images. Supports creating new images, snapshots of
existing images, and injecting one or more files into an existing image.

Example of creating a new disk:

	disk create qcow2 foo.qcow2 100G

The size argument is the size in bytes, or using optional suffixes "k"
(kilobyte), "M" (megabyte), "G" (gigabyte), "T" (terabyte).

Example of taking a snapshot of a disk:

	disk snapshot windows7.qc2 window7_miniccc.qc2

If the destination name is omitted, a name will be randomly generated and the
snapshot will be stored in the 'files' directory. Snapshots are always created
in the 'files' directory.

To inject files into an image:

	disk inject window7_miniccc.qc2 files "miniccc":"Program Files/miniccc"

Each argument after the image should be a source and destination pair,
separated by a ':'. If the file paths contain spaces, use double quotes.
Optionally, you may specify a partition (partition 1 will be used by default):

	disk inject window7_miniccc.qc2:2 files "miniccc":"Program Files/miniccc"

You may also specify that there is no partition on the disk, if your filesystem
was directly written to the disk (this is highly unusual):

	disk inject partitionless_disk.qc2:none files /miniccc:/miniccc

You can optionally specify mount arguments to use with inject. Multiple options
should be quoted. For example:

	disk inject foo.qcow2 options "-t fat -o offset=100" files foo:bar

Disk image paths are always relative to the 'files' directory. Users may also
use absolute paths if desired. The backing images for snapshots should always
be in the files directory.
		'''
		# disk info <image>
		if image != None:
			return self._run("disk", "info", image)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def disk_inject_files(self,image,files,):
		'''
Variants:
	disk inject <image> files <files like /path/to/src:/path/to/dst>...

Manipulate qcow disk images. Supports creating new images, snapshots of
existing images, and injecting one or more files into an existing image.

Example of creating a new disk:

	disk create qcow2 foo.qcow2 100G

The size argument is the size in bytes, or using optional suffixes "k"
(kilobyte), "M" (megabyte), "G" (gigabyte), "T" (terabyte).

Example of taking a snapshot of a disk:

	disk snapshot windows7.qc2 window7_miniccc.qc2

If the destination name is omitted, a name will be randomly generated and the
snapshot will be stored in the 'files' directory. Snapshots are always created
in the 'files' directory.

To inject files into an image:

	disk inject window7_miniccc.qc2 files "miniccc":"Program Files/miniccc"

Each argument after the image should be a source and destination pair,
separated by a ':'. If the file paths contain spaces, use double quotes.
Optionally, you may specify a partition (partition 1 will be used by default):

	disk inject window7_miniccc.qc2:2 files "miniccc":"Program Files/miniccc"

You may also specify that there is no partition on the disk, if your filesystem
was directly written to the disk (this is highly unusual):

	disk inject partitionless_disk.qc2:none files /miniccc:/miniccc

You can optionally specify mount arguments to use with inject. Multiple options
should be quoted. For example:

	disk inject foo.qcow2 options "-t fat -o offset=100" files foo:bar

Disk image paths are always relative to the 'files' directory. Users may also
use absolute paths if desired. The backing images for snapshots should always
be in the files directory.
		'''
		# disk inject <image> files <files like /path/to/src:/path/to/dst>...
		if image != None and files != None:
			return self._run("disk", "inject", image, "files", files)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def disk_inject_options_files(self,image,options,files,):
		'''
Variants:
	disk inject <image> options <options> files <files like /path/to/src:/path/to/dst>...

Manipulate qcow disk images. Supports creating new images, snapshots of
existing images, and injecting one or more files into an existing image.

Example of creating a new disk:

	disk create qcow2 foo.qcow2 100G

The size argument is the size in bytes, or using optional suffixes "k"
(kilobyte), "M" (megabyte), "G" (gigabyte), "T" (terabyte).

Example of taking a snapshot of a disk:

	disk snapshot windows7.qc2 window7_miniccc.qc2

If the destination name is omitted, a name will be randomly generated and the
snapshot will be stored in the 'files' directory. Snapshots are always created
in the 'files' directory.

To inject files into an image:

	disk inject window7_miniccc.qc2 files "miniccc":"Program Files/miniccc"

Each argument after the image should be a source and destination pair,
separated by a ':'. If the file paths contain spaces, use double quotes.
Optionally, you may specify a partition (partition 1 will be used by default):

	disk inject window7_miniccc.qc2:2 files "miniccc":"Program Files/miniccc"

You may also specify that there is no partition on the disk, if your filesystem
was directly written to the disk (this is highly unusual):

	disk inject partitionless_disk.qc2:none files /miniccc:/miniccc

You can optionally specify mount arguments to use with inject. Multiple options
should be quoted. For example:

	disk inject foo.qcow2 options "-t fat -o offset=100" files foo:bar

Disk image paths are always relative to the 'files' directory. Users may also
use absolute paths if desired. The backing images for snapshots should always
be in the files directory.
		'''
		# disk inject <image> options <options> files <files like /path/to/src:/path/to/dst>...
		if image != None and options != None and files != None:
			return self._run("disk", "inject", image, "options", options, "files", files)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def disk_snapshot(self,image,dst=None,):
		'''
Variants:
	disk snapshot <image> <dst image>
	disk snapshot <image>

Manipulate qcow disk images. Supports creating new images, snapshots of
existing images, and injecting one or more files into an existing image.

Example of creating a new disk:

	disk create qcow2 foo.qcow2 100G

The size argument is the size in bytes, or using optional suffixes "k"
(kilobyte), "M" (megabyte), "G" (gigabyte), "T" (terabyte).

Example of taking a snapshot of a disk:

	disk snapshot windows7.qc2 window7_miniccc.qc2

If the destination name is omitted, a name will be randomly generated and the
snapshot will be stored in the 'files' directory. Snapshots are always created
in the 'files' directory.

To inject files into an image:

	disk inject window7_miniccc.qc2 files "miniccc":"Program Files/miniccc"

Each argument after the image should be a source and destination pair,
separated by a ':'. If the file paths contain spaces, use double quotes.
Optionally, you may specify a partition (partition 1 will be used by default):

	disk inject window7_miniccc.qc2:2 files "miniccc":"Program Files/miniccc"

You may also specify that there is no partition on the disk, if your filesystem
was directly written to the disk (this is highly unusual):

	disk inject partitionless_disk.qc2:none files /miniccc:/miniccc

You can optionally specify mount arguments to use with inject. Multiple options
should be quoted. For example:

	disk inject foo.qcow2 options "-t fat -o offset=100" files foo:bar

Disk image paths are always relative to the 'files' directory. Users may also
use absolute paths if desired. The backing images for snapshots should always
be in the files directory.
		'''
		# disk snapshot <image> <dst image>
		if image != None and dst != None:
			return self._run("disk", "snapshot", image, dst)
	
		# disk snapshot <image>
		if image != None:
			return self._run("disk", "snapshot", image)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def dnsmasq(self,):
		'''
Variants:
	dnsmasq

Start a dhcp/dns server on a specified IP with a specified range. For example,
to start a DHCP server on IP 10.0.0.1 serving the range 10.0.0.2 -
10.0.254.254:

	dnsmasq start 10.0.0.1 10.0.0.2 10.0.254.254

To start only a from a config file:

	dnsmasq start /path/to/config

To list running dnsmasq servers, invoke dnsmasq with no arguments. To kill a
running dnsmasq server, specify its ID from the list of running servers. For
example, to kill dnsmasq server 2:

	dnsmasq kill 2

To kill all running dnsmasq servers, pass all as the ID:

	dnsmasq kill all

dnsmasq will provide DNS service from the host, as well as from /etc/hosts. You
can specify an additional config file for dnsmasq by providing a file as an
additional argument.

	dnsmasq start 10.0.0.1 10.0.0.2 10.0.254.254 /tmp/dnsmasq-extra.conf

NOTE: If specifying an additional config file, you must provide the full path
to the file.
		'''
		# dnsmasq
		if True:
			return self._run("dnsmasq")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def dnsmasq_configure_dns(self,ID,ip=None,hostname=None,):
		'''
Variants:
	dnsmasq configure <ID> dns <ip> <hostname>
	dnsmasq configure <ID> dns

Configuration options for running dnsmasq instances. Define a static IP
allocation, specify a hostname->IP mapping for DNS, or set DHCP options.

To list all existing static IP allocations on the first running dnsmasq
server, do the following:

	dnsmasq configure 0 ip

To set up a static IP allocation for a VM with the MAC address
00:11:22:33:44:55:

	dnsmasq configure 0 ip 00:11:22:33:44:55 172.17.0.50

To see DNS entries:

	dnsmasq configure 0 dns

To add a DNS entry:

	dnsmasq configure 0 dns 172.17.0.50 example.com

To see a list of all DHCP options:

	dnsmasq configure 0 options

To add a DHCP option:

	dnsmasq configure 0 options option:dns-server,172.17.0.254
		'''
		# dnsmasq configure <ID> dns <ip> <hostname>
		if ID != None and ip != None and hostname != None:
			return self._run("dnsmasq", "configure", ID, "dns", ip, hostname)
	
		# dnsmasq configure <ID> dns
		if ID != None:
			return self._run("dnsmasq", "configure", ID, "dns")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def dnsmasq_configure_ip(self,ID,mac=None,ip=None,):
		'''
Variants:
	dnsmasq configure <ID> ip <mac address> <ip>
	dnsmasq configure <ID> ip

Configuration options for running dnsmasq instances. Define a static IP
allocation, specify a hostname->IP mapping for DNS, or set DHCP options.

To list all existing static IP allocations on the first running dnsmasq
server, do the following:

	dnsmasq configure 0 ip

To set up a static IP allocation for a VM with the MAC address
00:11:22:33:44:55:

	dnsmasq configure 0 ip 00:11:22:33:44:55 172.17.0.50

To see DNS entries:

	dnsmasq configure 0 dns

To add a DNS entry:

	dnsmasq configure 0 dns 172.17.0.50 example.com

To see a list of all DHCP options:

	dnsmasq configure 0 options

To add a DHCP option:

	dnsmasq configure 0 options option:dns-server,172.17.0.254
		'''
		# dnsmasq configure <ID> ip <mac address> <ip>
		if ID != None and mac != None and ip != None:
			return self._run("dnsmasq", "configure", ID, "ip", mac, ip)
	
		# dnsmasq configure <ID> ip
		if ID != None:
			return self._run("dnsmasq", "configure", ID, "ip")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def dnsmasq_configure_options(self,ID,optionstring=None,):
		'''
Variants:
	dnsmasq configure <ID> options <optionstring>
	dnsmasq configure <ID> options

Configuration options for running dnsmasq instances. Define a static IP
allocation, specify a hostname->IP mapping for DNS, or set DHCP options.

To list all existing static IP allocations on the first running dnsmasq
server, do the following:

	dnsmasq configure 0 ip

To set up a static IP allocation for a VM with the MAC address
00:11:22:33:44:55:

	dnsmasq configure 0 ip 00:11:22:33:44:55 172.17.0.50

To see DNS entries:

	dnsmasq configure 0 dns

To add a DNS entry:

	dnsmasq configure 0 dns 172.17.0.50 example.com

To see a list of all DHCP options:

	dnsmasq configure 0 options

To add a DHCP option:

	dnsmasq configure 0 options option:dns-server,172.17.0.254
		'''
		# dnsmasq configure <ID> options <optionstring>
		if ID != None and optionstring != None:
			return self._run("dnsmasq", "configure", ID, "options", optionstring)
	
		# dnsmasq configure <ID> options
		if ID != None:
			return self._run("dnsmasq", "configure", ID, "options")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def dnsmasq_kill(self,id,):
		'''
Variants:
	dnsmasq kill <id or all>

Start a dhcp/dns server on a specified IP with a specified range. For example,
to start a DHCP server on IP 10.0.0.1 serving the range 10.0.0.2 -
10.0.254.254:

	dnsmasq start 10.0.0.1 10.0.0.2 10.0.254.254

To start only a from a config file:

	dnsmasq start /path/to/config

To list running dnsmasq servers, invoke dnsmasq with no arguments. To kill a
running dnsmasq server, specify its ID from the list of running servers. For
example, to kill dnsmasq server 2:

	dnsmasq kill 2

To kill all running dnsmasq servers, pass all as the ID:

	dnsmasq kill all

dnsmasq will provide DNS service from the host, as well as from /etc/hosts. You
can specify an additional config file for dnsmasq by providing a file as an
additional argument.

	dnsmasq start 10.0.0.1 10.0.0.2 10.0.254.254 /tmp/dnsmasq-extra.conf

NOTE: If specifying an additional config file, you must provide the full path
to the file.
		'''
		# dnsmasq kill <id or all>
		if id != None:
			return self._run("dnsmasq", "kill", id)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def dnsmasq_start(self,listen=None,low=None,high=None,config=None,):
		'''
Variants:
	dnsmasq start <listen address> <low dhcp range> <high dhcp range> <config>
	dnsmasq start <listen address> <low dhcp range> <high dhcp range>
	dnsmasq start <config>

Start a dhcp/dns server on a specified IP with a specified range. For example,
to start a DHCP server on IP 10.0.0.1 serving the range 10.0.0.2 -
10.0.254.254:

	dnsmasq start 10.0.0.1 10.0.0.2 10.0.254.254

To start only a from a config file:

	dnsmasq start /path/to/config

To list running dnsmasq servers, invoke dnsmasq with no arguments. To kill a
running dnsmasq server, specify its ID from the list of running servers. For
example, to kill dnsmasq server 2:

	dnsmasq kill 2

To kill all running dnsmasq servers, pass all as the ID:

	dnsmasq kill all

dnsmasq will provide DNS service from the host, as well as from /etc/hosts. You
can specify an additional config file for dnsmasq by providing a file as an
additional argument.

	dnsmasq start 10.0.0.1 10.0.0.2 10.0.254.254 /tmp/dnsmasq-extra.conf

NOTE: If specifying an additional config file, you must provide the full path
to the file.
		'''
		# dnsmasq start <listen address> <low dhcp range> <high dhcp range> <config>
		if listen != None and low != None and high != None and config != None:
			return self._run("dnsmasq", "start", listen, low, high, config)
	
		# dnsmasq start <listen address> <low dhcp range> <high dhcp range>
		if listen != None and low != None and high != None:
			return self._run("dnsmasq", "start", listen, low, high)
	
		# dnsmasq start <config>
		if config != None:
			return self._run("dnsmasq", "start", config)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def echo(self,args=None,):
		'''
Variants:
	echo <args>...
	echo

display input text after comment removal
		'''
		# echo <args>...
		if args != None:
			return self._run("echo", args)
	
		# echo
		if True:
			return self._run("echo")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def file_delete(self,file,):
		'''
Variants:
	file delete <file>

file allows you to transfer and manage files served by minimega in the
directory set by the -filepath flag (default is 'base'/files).

To list files currently being served, issue the list command with a directory
relative to the served directory:

	file list /foo

Issuing "file list /" will list the contents of the served directory.

Files can be deleted with the delete command:

	file delete /foo

If a directory is given, the directory will be recursively deleted.

Files are transferred using the get command. When a get command is issued, the
node will begin searching for a file matching the path and name within the
mesh. If the file exists, it will be transferred to the requesting node. If
multiple different files exist with the same name, the behavior is undefined.
When a file transfer begins, control will return to minimega while the transfer
completes.

To see files that are currently being transferred, use the status command:

	file status

If a directory is specified, that directory will be recursively transferred to
the node.

You can also supply globs (wildcards) with the * operator. For example:

	file get *.qcow2
	file delete *.qcow2

The stream command allows users to stream files through the Response. Each part
of the file is returned as a separate response which can then be combined to
form the original file. This command blocks until the stream is complete.
		'''
		# file delete <file>
		if file != None:
			return self._run("file", "delete", file)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def file_get(self,file,):
		'''
Variants:
	file get <file>

file allows you to transfer and manage files served by minimega in the
directory set by the -filepath flag (default is 'base'/files).

To list files currently being served, issue the list command with a directory
relative to the served directory:

	file list /foo

Issuing "file list /" will list the contents of the served directory.

Files can be deleted with the delete command:

	file delete /foo

If a directory is given, the directory will be recursively deleted.

Files are transferred using the get command. When a get command is issued, the
node will begin searching for a file matching the path and name within the
mesh. If the file exists, it will be transferred to the requesting node. If
multiple different files exist with the same name, the behavior is undefined.
When a file transfer begins, control will return to minimega while the transfer
completes.

To see files that are currently being transferred, use the status command:

	file status

If a directory is specified, that directory will be recursively transferred to
the node.

You can also supply globs (wildcards) with the * operator. For example:

	file get *.qcow2
	file delete *.qcow2

The stream command allows users to stream files through the Response. Each part
of the file is returned as a separate response which can then be combined to
form the original file. This command blocks until the stream is complete.
		'''
		# file get <file>
		if file != None:
			return self._run("file", "get", file)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def file_list(self,path=None,):
		'''
Variants:
	file list <path>
	file list

file allows you to transfer and manage files served by minimega in the
directory set by the -filepath flag (default is 'base'/files).

To list files currently being served, issue the list command with a directory
relative to the served directory:

	file list /foo

Issuing "file list /" will list the contents of the served directory.

Files can be deleted with the delete command:

	file delete /foo

If a directory is given, the directory will be recursively deleted.

Files are transferred using the get command. When a get command is issued, the
node will begin searching for a file matching the path and name within the
mesh. If the file exists, it will be transferred to the requesting node. If
multiple different files exist with the same name, the behavior is undefined.
When a file transfer begins, control will return to minimega while the transfer
completes.

To see files that are currently being transferred, use the status command:

	file status

If a directory is specified, that directory will be recursively transferred to
the node.

You can also supply globs (wildcards) with the * operator. For example:

	file get *.qcow2
	file delete *.qcow2

The stream command allows users to stream files through the Response. Each part
of the file is returned as a separate response which can then be combined to
form the original file. This command blocks until the stream is complete.
		'''
		# file list <path>
		if path != None:
			return self._run("file", "list", path)
	
		# file list
		if True:
			return self._run("file", "list")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def file_status(self,):
		'''
Variants:
	file status

file allows you to transfer and manage files served by minimega in the
directory set by the -filepath flag (default is 'base'/files).

To list files currently being served, issue the list command with a directory
relative to the served directory:

	file list /foo

Issuing "file list /" will list the contents of the served directory.

Files can be deleted with the delete command:

	file delete /foo

If a directory is given, the directory will be recursively deleted.

Files are transferred using the get command. When a get command is issued, the
node will begin searching for a file matching the path and name within the
mesh. If the file exists, it will be transferred to the requesting node. If
multiple different files exist with the same name, the behavior is undefined.
When a file transfer begins, control will return to minimega while the transfer
completes.

To see files that are currently being transferred, use the status command:

	file status

If a directory is specified, that directory will be recursively transferred to
the node.

You can also supply globs (wildcards) with the * operator. For example:

	file get *.qcow2
	file delete *.qcow2

The stream command allows users to stream files through the Response. Each part
of the file is returned as a separate response which can then be combined to
form the original file. This command blocks until the stream is complete.
		'''
		# file status
		if True:
			return self._run("file", "status")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def file_stream(self,file,):
		'''
Variants:
	file stream <file>

file allows you to transfer and manage files served by minimega in the
directory set by the -filepath flag (default is 'base'/files).

To list files currently being served, issue the list command with a directory
relative to the served directory:

	file list /foo

Issuing "file list /" will list the contents of the served directory.

Files can be deleted with the delete command:

	file delete /foo

If a directory is given, the directory will be recursively deleted.

Files are transferred using the get command. When a get command is issued, the
node will begin searching for a file matching the path and name within the
mesh. If the file exists, it will be transferred to the requesting node. If
multiple different files exist with the same name, the behavior is undefined.
When a file transfer begins, control will return to minimega while the transfer
completes.

To see files that are currently being transferred, use the status command:

	file status

If a directory is specified, that directory will be recursively transferred to
the node.

You can also supply globs (wildcards) with the * operator. For example:

	file get *.qcow2
	file delete *.qcow2

The stream command allows users to stream files through the Response. Each part
of the file is returned as a separate response which can then be combined to
form the original file. This command blocks until the stream is complete.
		'''
		# file stream <file>
		if file != None:
			return self._run("file", "stream", file)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def history(self,):
		'''
Variants:
	history

history displays a list of all the commands that have been invoked since
minimega started on this host, or since the last time the history was cleared.
History includes only valid commands and comments. Invalid lines and blank
lines are not recorded. There are some commands that interact differently with
history, namely read. Instead of recording the "read" command in the history,
minimega records all the valid commands executed from the read file in the
history. This allows the full execution history to be listed using history.
		'''
		# history
		if True:
			return self._run("history")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host(self,):
		'''
Variants:
	host

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host
		if True:
			return self._run("host")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_cpucommit(self,):
		'''
Variants:
	host cpucommit

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host cpucommit
		if True:
			return self._run("host", "cpucommit")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_cpus(self,):
		'''
Variants:
	host cpus

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host cpus
		if True:
			return self._run("host", "cpus")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_load(self,):
		'''
Variants:
	host load

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host load
		if True:
			return self._run("host", "load")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_memcommit(self,):
		'''
Variants:
	host memcommit

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host memcommit
		if True:
			return self._run("host", "memcommit")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_memtotal(self,):
		'''
Variants:
	host memtotal

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host memtotal
		if True:
			return self._run("host", "memtotal")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_memused(self,):
		'''
Variants:
	host memused

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host memused
		if True:
			return self._run("host", "memused")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_name(self,):
		'''
Variants:
	host name

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host name
		if True:
			return self._run("host", "name")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_netcommit(self,):
		'''
Variants:
	host netcommit

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host netcommit
		if True:
			return self._run("host", "netcommit")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_rx(self,):
		'''
Variants:
	host rx

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host rx
		if True:
			return self._run("host", "rx")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_tx(self,):
		'''
Variants:
	host tx

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host tx
		if True:
			return self._run("host", "tx")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_uptime(self,):
		'''
Variants:
	host uptime

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host uptime
		if True:
			return self._run("host", "uptime")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_vmlimit(self,):
		'''
Variants:
	host vmlimit

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host vmlimit
		if True:
			return self._run("host", "vmlimit")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def host_vms(self,):
		'''
Variants:
	host vms

Report information about hosts in the current namespace:

- cpucommit  : total cpu commit
- cpus       : number of cpus
- load       : system load average
- memcommit  : total memory commit in MB
- memtotal   : total memory in MB
- memused    : memory used in MB
- name       : name of the machine
- netcommit  : total network interface commit
- rx         : RX bandwidth stats (MB/s)
- tx         : TX bandwidth stats (MB/s)
- uptime     : uptime
- vms        : number of VMs
- vmlimit    : limit based on coschedule values (-1 is no limit)

All VM-based stats are computed across namespaces.
		'''
		# host vms
		if True:
			return self._run("host", "vms")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def log_file(self,file=None,):
		'''
Variants:
	log file <file>
	log file

Log to a file. To disable file logging, call "clear log file".
		'''
		# log file <file>
		if file != None:
			return self._run("log", "file", file)
	
		# log file
		if True:
			return self._run("log", "file")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def log_filter(self,filter=None,):
		'''
Variants:
	log filter <filter>
	log filter

Control what data gets logged based on matching text. For example, to filter
out all logging messages containing the word "foo":

	log filter foo
		'''
		# log filter <filter>
		if filter != None:
			return self._run("log", "filter", filter)
	
		# log filter
		if True:
			return self._run("log", "filter")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def log_level(self,debug_or_info_or_warn_or_error_or_fatal=None,):
		'''
Variants:
	log level <debug,info,warn,error,fatal>
	log level

Set the log level to one of [debug,info,warn,error,fatal]. Log levels inherit
lower levels, so setting the level to error will also log fatal, and setting
the mode to debug will log everything.
		'''
		# log level <debug,info,warn,error,fatal>
		if debug_or_info_or_warn_or_error_or_fatal != None:
			# Validate that choice was valid for debug_or_info_or_warn_or_error_or_fatal
			if debug_or_info_or_warn_or_error_or_fatal not in ["debug","info","warn","error","fatal",]:
				raise ValueError("invalid value for debug_or_info_or_warn_or_error_or_fatal")
			return self._run("log", "level", debug_or_info_or_warn_or_error_or_fatal)
	
		# log level
		if True:
			return self._run("log", "level")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def log_ring(self,size=None,):
		'''
Variants:
	log ring <size>
	log ring

The log ring contains recent log messages, if it is enabled. By default
the ring is not enabled. When enabling it, the user can specify a size. The
larger the size, the more memory the logs will consume. The log ring can be
cleared by re-enabling it with the same (or different) size.

To disable the log ring, call "clear log ring".
		'''
		# log ring <size>
		if size != None:
			return self._run("log", "ring", size)
	
		# log ring
		if True:
			return self._run("log", "ring")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def log_stderr(self,true_or_false=None,):
		'''
Variants:
	log stderr <true,false>
	log stderr

enable or disable logging to stderr
		'''
		# log stderr <true,false>
		if true_or_false != None:
			# Validate that choice was valid for true_or_false
			if true_or_false not in ["true","false",]:
				raise ValueError("invalid value for true_or_false")
			return self._run("log", "stderr", true_or_false)
	
		# log stderr
		if True:
			return self._run("log", "stderr")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def log_syslog_local(self,):
		'''
Variants:
	log syslog local

Log to a syslog daemon on the provided network and address. For example, to log
over UDP to a syslog server foo on port 514:

	log syslog udp foo:514
		'''
		# log syslog local
		if True:
			return self._run("log", "syslog", "local")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def log_syslog_remote(self,tcp_or_udp,address,):
		'''
Variants:
	log syslog remote <tcp,udp> <address>

Log to a syslog daemon on the provided network and address. For example, to log
over UDP to a syslog server foo on port 514:

	log syslog udp foo:514
		'''
		# log syslog remote <tcp,udp> <address>
		if tcp_or_udp != None and address != None:
			# Validate that choice was valid for tcp_or_udp
			if tcp_or_udp not in ["tcp","udp",]:
				raise ValueError("invalid value for tcp_or_udp")
			return self._run("log", "syslog", "remote", tcp_or_udp, address)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def mesh_degree(self,degree=None,):
		'''
Variants:
	mesh degree <degree>
	mesh degree

view or set the current degree for this mesh node
		'''
		# mesh degree <degree>
		if degree != None:
			return self._run("mesh", "degree", degree)
	
		# mesh degree
		if True:
			return self._run("mesh", "degree")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def mesh_dial(self,hostname,):
		'''
Variants:
	mesh dial <hostname>

attempt to connect this node to another node
		'''
		# mesh dial <hostname>
		if hostname != None:
			return self._run("mesh", "dial", hostname)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def mesh_dot(self,filename,):
		'''
Variants:
	mesh dot <filename>

Output a graphviz formatted dot file representing the connected topology.
		'''
		# mesh dot <filename>
		if filename != None:
			return self._run("mesh", "dot", filename)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def mesh_hangup(self,hostname,):
		'''
Variants:
	mesh hangup <hostname>

disconnect from a client
		'''
		# mesh hangup <hostname>
		if hostname != None:
			return self._run("mesh", "hangup", hostname)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def mesh_list(self,all_or_peers=None,):
		'''
Variants:
	mesh list <all,peers>
	mesh list

Without "all" or "peers", displays the mesh adjacency list. If "all" is
specified, the hostnames of all nodes in the list are printed. If "peers" is
specified, the hostnames of all peers are printed (the local node is not
included).
		'''
		# mesh list <all,peers>
		if all_or_peers != None:
			# Validate that choice was valid for all_or_peers
			if all_or_peers not in ["all","peers",]:
				raise ValueError("invalid value for all_or_peers")
			return self._run("mesh", "list", all_or_peers)
	
		# mesh list
		if True:
			return self._run("mesh", "list")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def mesh_send(self,hostname,command,):
		'''
Variants:
	mesh send <hostname or range or all> (command)

Send a command to one or more connected clients. For example, to get the
vm info from nodes kn1 and kn2:

	mesh send kn[1-2] vm info

You can use 'all' to send a command to all connected clients.
		'''
		# mesh send <hostname or range or all> (command)
		if hostname != None and command != None:
			return self._run("mesh", "send", hostname, command)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def mesh_status(self,):
		'''
Variants:
	mesh status

display a short status report of the mesh
		'''
		# mesh status
		if True:
			return self._run("mesh", "status")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def mesh_timeout(self,timeout=None,):
		'''
Variants:
	mesh timeout <timeout>
	mesh timeout

View or set the timeout on sending mesh commands.

When a mesh command is issued, if a response isn't sent within mesh timeout
seconds, the command will be dropped and any future response will be discarded.
Note that this does not cancel the outstanding command - the node receiving the
command may still complete - but rather this node will stop waiting on a
response.

By default, the mesh timeout is 0 which disables timeouts.
		'''
		# mesh timeout <timeout>
		if timeout != None:
			return self._run("mesh", "timeout", timeout)
	
		# mesh timeout
		if True:
			return self._run("mesh", "timeout")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_add_hosts(self,hostname,):
		'''
Variants:
	ns add-hosts <hostname or range or all>

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns add-hosts <hostname or range or all>
		if hostname != None:
			return self._run("ns", "add-hosts", hostname)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_bridge(self,bridge,vxlan_or_gre=None,):
		'''
Variants:
	ns bridge <bridge> <vxlan,gre>
	ns bridge <bridge>

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns bridge <bridge> <vxlan,gre>
		if bridge != None and vxlan_or_gre != None:
			# Validate that choice was valid for vxlan_or_gre
			if vxlan_or_gre not in ["vxlan","gre",]:
				raise ValueError("invalid value for vxlan_or_gre")
			return self._run("ns", "bridge", bridge, vxlan_or_gre)
	
		# ns bridge <bridge>
		if bridge != None:
			return self._run("ns", "bridge", bridge)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_del_bridge(self,bridge,):
		'''
Variants:
	ns del-bridge <bridge>

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns del-bridge <bridge>
		if bridge != None:
			return self._run("ns", "del-bridge", bridge)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_del_hosts(self,hostname,):
		'''
Variants:
	ns del-hosts <hostname or range or all>

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns del-hosts <hostname or range or all>
		if hostname != None:
			return self._run("ns", "del-hosts", hostname)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_flush(self,):
		'''
Variants:
	ns flush

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns flush
		if True:
			return self._run("ns", "flush")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_hosts(self,):
		'''
Variants:
	ns hosts

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns hosts
		if True:
			return self._run("ns", "hosts")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_load(self,):
		'''
Variants:
	ns load

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns load
		if True:
			return self._run("ns", "load")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_load_cpucommit(self,):
		'''
Variants:
	ns load cpucommit

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns load cpucommit
		if True:
			return self._run("ns", "load", "cpucommit")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_load_memcommit(self,):
		'''
Variants:
	ns load memcommit

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns load memcommit
		if True:
			return self._run("ns", "load", "memcommit")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_load_netcommit(self,):
		'''
Variants:
	ns load netcommit

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns load netcommit
		if True:
			return self._run("ns", "load", "netcommit")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_queue(self,):
		'''
Variants:
	ns queue

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns queue
		if True:
			return self._run("ns", "queue")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_queueing(self,true_or_false=None,):
		'''
Variants:
	ns queueing <true,false>
	ns queueing

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns queueing <true,false>
		if true_or_false != None:
			# Validate that choice was valid for true_or_false
			if true_or_false not in ["true","false",]:
				raise ValueError("invalid value for true_or_false")
			return self._run("ns", "queueing", true_or_false)
	
		# ns queueing
		if True:
			return self._run("ns", "queueing")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_run(self,command,):
		'''
Variants:
	ns run (command)

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns run (command)
		if command != None:
			return self._run("ns", "run", command)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_schedule(self,):
		'''
Variants:
	ns schedule

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns schedule
		if True:
			return self._run("ns", "schedule")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_schedule_dry_run(self,):
		'''
Variants:
	ns schedule dry-run

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns schedule dry-run
		if True:
			return self._run("ns", "schedule", "dry-run")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_schedule_dump(self,):
		'''
Variants:
	ns schedule dump

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns schedule dump
		if True:
			return self._run("ns", "schedule", "dump")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_schedule_mv(self,vm,dst,):
		'''
Variants:
	ns schedule mv <vm target> <dst>

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns schedule mv <vm target> <dst>
		if vm != None and dst != None:
			return self._run("ns", "schedule", "mv", vm, dst)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_schedule_status(self,):
		'''
Variants:
	ns schedule status

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns schedule status
		if True:
			return self._run("ns", "schedule", "status")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def ns_snapshot(self,name=None,):
		'''
Variants:
	ns snapshot <name>
	ns snapshot

Display or modify the active namespace.

- hosts     : list hosts
- add-hosts : add comma-separated list of hosts to the namespace
- del-hosts : delete comma-separated list of hosts from the namespace
- load      : display or change host load is computed for scheduler, based on:
  - cpucommit : total CPU commit divided by number of CPUs (default)
  - netcommit : total NIC
  - memcommit : total memory commit divided by total memory
- queue     : display VM queue
- flush     : clear the VM queue
- queueing  : toggle VMs queueing when launching (default false)
- schedule  : run scheduler (same as "vm launch")
  - dry-run : determine VM placement and print out VM -> host assignments
  - dump    : print out VM -> host assignments (after dry-run)
  - mv      : manually edit VM placement in schedule (after dry-run)
  - status  : display scheduling status
- bridge    : create a bridge, defaults to GRE mesh between hosts
- del-bridge: destroy a bridge
- snapshot  : take a snapshot of namespace or print snapshot progress
- run       : run a command on all nodes in the namespace
		'''
		# ns snapshot <name>
		if name != None:
			return self._run("ns", "snapshot", name)
	
		# ns snapshot
		if True:
			return self._run("ns", "snapshot")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def nuke(self,):
		'''
Variants:
	nuke

After a crash, the VM state on the machine can be difficult to recover from.
nuke attempts to kill all instances of QEMU, remove all taps and bridges, and
removes the temporary minimega state on the harddisk.

Should be run with caution.
		'''
		# nuke
		if True:
			return self._run("nuke")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def optimize(self,):
		'''
Variants:
	optimize

Enable or disable several virtualization optimizations, including Kernel
Samepage Merging, CPU affinity for VMs, and the use of hugepages.

To enable/disable Kernel Samepage Merging (KSM):

	optimize ksm [true,false]

To enable hugepage support for future VM launches:

	optimize hugepages </path/to/hugepages_mount>

To disable hugepage support:

	clear optimize hugepages

To enable/disable CPU affinity support for VMs in the namespace:

	optimize affinity [true,false]

To set a CPU set filter for the affinity scheduler, for example (to use only
CPUs 1, 2-20):

	optimize affinity filter [1,2-20]

If affinity is already enabled, will cause reassignment of affinity for all
running VMs to match the new filter.

To clear a CPU set filter:

	clear optimize affinity filter

See note above about reassigning affinity.

To view current CPU affinity mappings (by PID):

	optimize affinity

To disable all optimizations, use "clear optimize".

Note: affinity and hugepages can be selectively enabled in particular
namespaces. KSM affects VMs across all namespaces.
		'''
		# optimize
		if True:
			return self._run("optimize")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def optimize_affinity(self,true_or_false=None,):
		'''
Variants:
	optimize affinity <true,false>
	optimize affinity

Enable or disable several virtualization optimizations, including Kernel
Samepage Merging, CPU affinity for VMs, and the use of hugepages.

To enable/disable Kernel Samepage Merging (KSM):

	optimize ksm [true,false]

To enable hugepage support for future VM launches:

	optimize hugepages </path/to/hugepages_mount>

To disable hugepage support:

	clear optimize hugepages

To enable/disable CPU affinity support for VMs in the namespace:

	optimize affinity [true,false]

To set a CPU set filter for the affinity scheduler, for example (to use only
CPUs 1, 2-20):

	optimize affinity filter [1,2-20]

If affinity is already enabled, will cause reassignment of affinity for all
running VMs to match the new filter.

To clear a CPU set filter:

	clear optimize affinity filter

See note above about reassigning affinity.

To view current CPU affinity mappings (by PID):

	optimize affinity

To disable all optimizations, use "clear optimize".

Note: affinity and hugepages can be selectively enabled in particular
namespaces. KSM affects VMs across all namespaces.
		'''
		# optimize affinity <true,false>
		if true_or_false != None:
			# Validate that choice was valid for true_or_false
			if true_or_false not in ["true","false",]:
				raise ValueError("invalid value for true_or_false")
			return self._run("optimize", "affinity", true_or_false)
	
		# optimize affinity
		if True:
			return self._run("optimize", "affinity")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def optimize_affinity_filter(self,filter,):
		'''
Variants:
	optimize affinity filter <filter>

Enable or disable several virtualization optimizations, including Kernel
Samepage Merging, CPU affinity for VMs, and the use of hugepages.

To enable/disable Kernel Samepage Merging (KSM):

	optimize ksm [true,false]

To enable hugepage support for future VM launches:

	optimize hugepages </path/to/hugepages_mount>

To disable hugepage support:

	clear optimize hugepages

To enable/disable CPU affinity support for VMs in the namespace:

	optimize affinity [true,false]

To set a CPU set filter for the affinity scheduler, for example (to use only
CPUs 1, 2-20):

	optimize affinity filter [1,2-20]

If affinity is already enabled, will cause reassignment of affinity for all
running VMs to match the new filter.

To clear a CPU set filter:

	clear optimize affinity filter

See note above about reassigning affinity.

To view current CPU affinity mappings (by PID):

	optimize affinity

To disable all optimizations, use "clear optimize".

Note: affinity and hugepages can be selectively enabled in particular
namespaces. KSM affects VMs across all namespaces.
		'''
		# optimize affinity filter <filter>
		if filter != None:
			return self._run("optimize", "affinity", "filter", filter)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def optimize_hugepages(self,path=None,):
		'''
Variants:
	optimize hugepages <path>
	optimize hugepages

Enable or disable several virtualization optimizations, including Kernel
Samepage Merging, CPU affinity for VMs, and the use of hugepages.

To enable/disable Kernel Samepage Merging (KSM):

	optimize ksm [true,false]

To enable hugepage support for future VM launches:

	optimize hugepages </path/to/hugepages_mount>

To disable hugepage support:

	clear optimize hugepages

To enable/disable CPU affinity support for VMs in the namespace:

	optimize affinity [true,false]

To set a CPU set filter for the affinity scheduler, for example (to use only
CPUs 1, 2-20):

	optimize affinity filter [1,2-20]

If affinity is already enabled, will cause reassignment of affinity for all
running VMs to match the new filter.

To clear a CPU set filter:

	clear optimize affinity filter

See note above about reassigning affinity.

To view current CPU affinity mappings (by PID):

	optimize affinity

To disable all optimizations, use "clear optimize".

Note: affinity and hugepages can be selectively enabled in particular
namespaces. KSM affects VMs across all namespaces.
		'''
		# optimize hugepages <path>
		if path != None:
			return self._run("optimize", "hugepages", path)
	
		# optimize hugepages
		if True:
			return self._run("optimize", "hugepages")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def optimize_ksm(self,true_or_false=None,):
		'''
Variants:
	optimize ksm <true,false>
	optimize ksm

Enable or disable several virtualization optimizations, including Kernel
Samepage Merging, CPU affinity for VMs, and the use of hugepages.

To enable/disable Kernel Samepage Merging (KSM):

	optimize ksm [true,false]

To enable hugepage support for future VM launches:

	optimize hugepages </path/to/hugepages_mount>

To disable hugepage support:

	clear optimize hugepages

To enable/disable CPU affinity support for VMs in the namespace:

	optimize affinity [true,false]

To set a CPU set filter for the affinity scheduler, for example (to use only
CPUs 1, 2-20):

	optimize affinity filter [1,2-20]

If affinity is already enabled, will cause reassignment of affinity for all
running VMs to match the new filter.

To clear a CPU set filter:

	clear optimize affinity filter

See note above about reassigning affinity.

To view current CPU affinity mappings (by PID):

	optimize affinity

To disable all optimizations, use "clear optimize".

Note: affinity and hugepages can be selectively enabled in particular
namespaces. KSM affects VMs across all namespaces.
		'''
		# optimize ksm <true,false>
		if true_or_false != None:
			# Validate that choice was valid for true_or_false
			if true_or_false not in ["true","false",]:
				raise ValueError("invalid value for true_or_false")
			return self._run("optimize", "ksm", true_or_false)
	
		# optimize ksm
		if True:
			return self._run("optimize", "ksm")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def pipe(self,pipe=None,data=None,):
		'''
Variants:
	pipe <pipe> <data>
	pipe

Interact with named pipes. To write to a pipe, simply invoke the pipe API with
the pipe name and value:

	pipe foo Hello pipes!

Pipes have several message delivery modes. Based on the mode, messages written
to a pipe will be delivered to one or more readers. Mode "all" copies messages
to all readers, "round-robin" chooses a single reader, in-order, and "random"
selects a random reader.

Pipes can also have "vias", programs through which all written data is passed
before being sent to readers. Unlike pipelines, vias are run for every reader.
This allows for mutating data on a per-reader basis with a single write. For
example, to send a unique floating-point value on a normal distribution with a
written mean to all readers:

	pipe foo via normal -stddev 5.0
	pipe foo 1.5

Pipes in other namespaces can be referenced with the syntax <namespace>//<pipe>.
		'''
		# pipe <pipe> <data>
		if pipe != None and data != None:
			return self._run("pipe", pipe, data)
	
		# pipe
		if True:
			return self._run("pipe")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def pipe_log(self,pipe,true_or_false,):
		'''
Variants:
	pipe <pipe> log <true,false>

Interact with named pipes. To write to a pipe, simply invoke the pipe API with
the pipe name and value:

	pipe foo Hello pipes!

Pipes have several message delivery modes. Based on the mode, messages written
to a pipe will be delivered to one or more readers. Mode "all" copies messages
to all readers, "round-robin" chooses a single reader, in-order, and "random"
selects a random reader.

Pipes can also have "vias", programs through which all written data is passed
before being sent to readers. Unlike pipelines, vias are run for every reader.
This allows for mutating data on a per-reader basis with a single write. For
example, to send a unique floating-point value on a normal distribution with a
written mean to all readers:

	pipe foo via normal -stddev 5.0
	pipe foo 1.5

Pipes in other namespaces can be referenced with the syntax <namespace>//<pipe>.
		'''
		# pipe <pipe> log <true,false>
		if pipe != None and true_or_false != None:
			# Validate that choice was valid for true_or_false
			if true_or_false not in ["true","false",]:
				raise ValueError("invalid value for true_or_false")
			return self._run("pipe", pipe, "log", true_or_false)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def pipe_mode(self,pipe,all_or_round_robin_or_random,):
		'''
Variants:
	pipe <pipe> mode <all,round-robin,random>

Interact with named pipes. To write to a pipe, simply invoke the pipe API with
the pipe name and value:

	pipe foo Hello pipes!

Pipes have several message delivery modes. Based on the mode, messages written
to a pipe will be delivered to one or more readers. Mode "all" copies messages
to all readers, "round-robin" chooses a single reader, in-order, and "random"
selects a random reader.

Pipes can also have "vias", programs through which all written data is passed
before being sent to readers. Unlike pipelines, vias are run for every reader.
This allows for mutating data on a per-reader basis with a single write. For
example, to send a unique floating-point value on a normal distribution with a
written mean to all readers:

	pipe foo via normal -stddev 5.0
	pipe foo 1.5

Pipes in other namespaces can be referenced with the syntax <namespace>//<pipe>.
		'''
		# pipe <pipe> mode <all,round-robin,random>
		if pipe != None and all_or_round_robin_or_random != None:
			# Validate that choice was valid for all_or_round_robin_or_random
			if all_or_round_robin_or_random not in ["all","round-robin","random",]:
				raise ValueError("invalid value for all_or_round_robin_or_random")
			return self._run("pipe", pipe, "mode", all_or_round_robin_or_random)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def pipe_via(self,pipe,command,):
		'''
Variants:
	pipe <pipe> via <command>...


		'''
		# pipe <pipe> via <command>...
		if pipe != None and command != None:
			return self._run("pipe", pipe, "via", command)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def plumb(self,src=None,dst=None,):
		'''
Variants:
	plumb <src> <dst>...
	plumb

Create pipelines composed of named pipes and external programs. Pipelines pass
data on standard I/O, with messages split on newlines. Pipelines are
constructed similar to that of UNIX pipelines. For example, to pipeline named
pipe "foo" through "sed" and into another pipe "bar":

	plumb foo "sed -u s/foo/moo/" bar

When specifying pipelines, strings that are not found in $PATH are considered
named pipes.

Pipelines can be composed into larger, nonlinear pipelines. For example, to
create a simple tree rooted at A with leaves B and C, simply specify multiple
pipelines:

	plumb a b
	plumb a c
		'''
		# plumb <src> <dst>...
		if src != None and dst != None:
			return self._run("plumb", src, dst)
	
		# plumb
		if True:
			return self._run("plumb")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def qos_add_delay(self,vm,interface,duration,):
		'''
Variants:
	qos add <vm target> <interface> delay <duration>

Add quality-of-service (qos) constraints on mega interfaces to emulate real
networks. Currently only applies qos constraints on the egress side / transmit
direction. Qos constraints can be stacked with multiple calls to <add>, and
must be specified explicitly. Any existing constraints will be overwritten by
additional calls to <add>. VM can be specified with the same target syntax as
the "vm start" api.

Note that qos is namespace aware, and any qos commands will be matched to
target vms within the currently active namespace.

qos constraints include:

- loss		: packets will be randomly dropped with a specified probability
- delay		: delay packets for specified unit of time (ms, ns, etc)
- rate		: impose a maximum bandwidth on an interface in kbit, mbit, or gbit

Note: due to limitations of the underlying tool, "tc", you can only add rate or
loss/delay to a VM. Enabling loss or delay will disable rate and vice versa.

Note: qos applies only to traffic received by the VM (which is "egress" traffic
on the mega_tap interface on the host) -- traffic sent by the VM ("ingress" on
the mega_tap interface on the host) is not policed to the desired rate.

Examples:

	Randomly drop packets on the 0th interface for vms foo0, 1, and 2 with
	probability 25%

	qos add foo[0-2] 0 loss 25

	Add a 100ms delay to every packet on the 0th interface for vm foo and bar

	qos add foo,bar 0 delay 100ms

	Rate limit the 0th interface on all vms in the active namespace to 1mbit/s

	qos add all 0 rate 1 mbit

To clear active qos settings, use:

	clear qos <vm> <interface|all>

Example:

	clear qos foo all
		'''
		# qos add <vm target> <interface> delay <duration>
		if vm != None and interface != None and duration != None:
			return self._run("qos", "add", vm, interface, "delay", duration)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def qos_add_loss(self,vm,interface,percent,):
		'''
Variants:
	qos add <vm target> <interface> loss <percent>

Add quality-of-service (qos) constraints on mega interfaces to emulate real
networks. Currently only applies qos constraints on the egress side / transmit
direction. Qos constraints can be stacked with multiple calls to <add>, and
must be specified explicitly. Any existing constraints will be overwritten by
additional calls to <add>. VM can be specified with the same target syntax as
the "vm start" api.

Note that qos is namespace aware, and any qos commands will be matched to
target vms within the currently active namespace.

qos constraints include:

- loss		: packets will be randomly dropped with a specified probability
- delay		: delay packets for specified unit of time (ms, ns, etc)
- rate		: impose a maximum bandwidth on an interface in kbit, mbit, or gbit

Note: due to limitations of the underlying tool, "tc", you can only add rate or
loss/delay to a VM. Enabling loss or delay will disable rate and vice versa.

Note: qos applies only to traffic received by the VM (which is "egress" traffic
on the mega_tap interface on the host) -- traffic sent by the VM ("ingress" on
the mega_tap interface on the host) is not policed to the desired rate.

Examples:

	Randomly drop packets on the 0th interface for vms foo0, 1, and 2 with
	probability 25%

	qos add foo[0-2] 0 loss 25

	Add a 100ms delay to every packet on the 0th interface for vm foo and bar

	qos add foo,bar 0 delay 100ms

	Rate limit the 0th interface on all vms in the active namespace to 1mbit/s

	qos add all 0 rate 1 mbit

To clear active qos settings, use:

	clear qos <vm> <interface|all>

Example:

	clear qos foo all
		'''
		# qos add <vm target> <interface> loss <percent>
		if vm != None and interface != None and percent != None:
			return self._run("qos", "add", vm, interface, "loss", percent)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def qos_add_rate(self,vm,interface,bw,kbit_or_mbit_or_gbit,):
		'''
Variants:
	qos add <vm target> <interface> rate <bw> <kbit,mbit,gbit>

Add quality-of-service (qos) constraints on mega interfaces to emulate real
networks. Currently only applies qos constraints on the egress side / transmit
direction. Qos constraints can be stacked with multiple calls to <add>, and
must be specified explicitly. Any existing constraints will be overwritten by
additional calls to <add>. VM can be specified with the same target syntax as
the "vm start" api.

Note that qos is namespace aware, and any qos commands will be matched to
target vms within the currently active namespace.

qos constraints include:

- loss		: packets will be randomly dropped with a specified probability
- delay		: delay packets for specified unit of time (ms, ns, etc)
- rate		: impose a maximum bandwidth on an interface in kbit, mbit, or gbit

Note: due to limitations of the underlying tool, "tc", you can only add rate or
loss/delay to a VM. Enabling loss or delay will disable rate and vice versa.

Note: qos applies only to traffic received by the VM (which is "egress" traffic
on the mega_tap interface on the host) -- traffic sent by the VM ("ingress" on
the mega_tap interface on the host) is not policed to the desired rate.

Examples:

	Randomly drop packets on the 0th interface for vms foo0, 1, and 2 with
	probability 25%

	qos add foo[0-2] 0 loss 25

	Add a 100ms delay to every packet on the 0th interface for vm foo and bar

	qos add foo,bar 0 delay 100ms

	Rate limit the 0th interface on all vms in the active namespace to 1mbit/s

	qos add all 0 rate 1 mbit

To clear active qos settings, use:

	clear qos <vm> <interface|all>

Example:

	clear qos foo all
		'''
		# qos add <vm target> <interface> rate <bw> <kbit,mbit,gbit>
		if vm != None and interface != None and bw != None and kbit_or_mbit_or_gbit != None:
			# Validate that choice was valid for kbit_or_mbit_or_gbit
			if kbit_or_mbit_or_gbit not in ["kbit","mbit","gbit",]:
				raise ValueError("invalid value for kbit_or_mbit_or_gbit")
			return self._run("qos", "add", vm, interface, "rate", bw, kbit_or_mbit_or_gbit)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def quit(self,delay=None,):
		'''
Variants:
	quit <delay>
	quit

Quit minimega. An optional integer argument X allows deferring the quit call
for X seconds. This is useful for telling a mesh of minimega nodes to quit.

quit will not return a response to the cli, control socket, or meshage, it will
simply exit. meshage connected nodes catch this and will remove the quit node
from the mesh. External tools interfacing minimega must check for EOF on stdout
or the control socket as an indication that minimega has quit.
		'''
		# quit <delay>
		if delay != None:
			return self._run("quit", delay)
	
		# quit
		if True:
			return self._run("quit")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def read(self,file,check=None,):
		'''
Variants:
	read <file> <check,>
	read <file>

Read a command file and execute it. This has the same behavior as if you typed
the file in manually. read stops if it reads an invalid command. read does not
stop if a command returns an error. Nested reads are not permitted.

Because reading and executing long files can take a while, the read command
releases the command lock that it holds so commands from other clients
(including miniweb) can be interleaved. To prevent issues with another script
changing the namespace and commands being run in a different namespace than
originally intended, read records the active namespace when it starts and
prepends that namespace to all commands that it reads from the file. If it
reads a command that would change the active namespace, read updates its state
so that the new namespace is prepended instead.

If the optional argument check is specified then read doesn't execute any of
the commands in the file. Instead, it checks that all the commands are
syntactically valid. This can identify mistyped commands in scripts before you
read them. It cannot check for semantic errors (e.g. killing a non-existent
VM). The check stops at the first invalid command.
		'''
		# read <file> <check,>
		if file != None and check != None:
			return self._run("read", file, check)
	
		# read <file>
		if file != None:
			return self._run("read", file)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router(self,vm,):
		'''
Variants:
	router <vm>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm>
		if vm != None:
			return self._run("router", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_commit(self,vm,):
		'''
Variants:
	router <vm> commit

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> commit
		if vm != None:
			return self._run("router", vm, "commit")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_dhcp_dns(self,vm,listen,address,):
		'''
Variants:
	router <vm> dhcp <listen address> dns <address>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> dhcp <listen address> dns <address>
		if vm != None and listen != None and address != None:
			return self._run("router", vm, "dhcp", listen, "dns", address)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_dhcp_range(self,vm,listen,low,high,):
		'''
Variants:
	router <vm> dhcp <listen address> range <low address> <high address>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> dhcp <listen address> range <low address> <high address>
		if vm != None and listen != None and low != None and high != None:
			return self._run("router", vm, "dhcp", listen, "range", low, high)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_dhcp_router(self,vm,listen,router,):
		'''
Variants:
	router <vm> dhcp <listen address> router <router address>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> dhcp <listen address> router <router address>
		if vm != None and listen != None and router != None:
			return self._run("router", vm, "dhcp", listen, "router", router)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_dhcp_static(self,vm,listen,mac,ip,):
		'''
Variants:
	router <vm> dhcp <listen address> static <mac> <ip>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> dhcp <listen address> static <mac> <ip>
		if vm != None and listen != None and mac != None and ip != None:
			return self._run("router", vm, "dhcp", listen, "static", mac, ip)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_dns(self,vm,ip,hostname,):
		'''
Variants:
	router <vm> dns <ip> <hostname>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> dns <ip> <hostname>
		if vm != None and ip != None and hostname != None:
			return self._run("router", vm, "dns", ip, hostname)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_gw(self,vm,gw,):
		'''
Variants:
	router <vm> gw <gw>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> gw <gw>
		if vm != None and gw != None:
			return self._run("router", vm, "gw", gw)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_interface(self,vm,network,IPv4_MASK,lo=None,):
		'''
Variants:
	router <vm> interface <network> <IPv4/MASK or IPv6/MASK or dhcp> <lo,>
	router <vm> interface <network> <IPv4/MASK or IPv6/MASK or dhcp>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> interface <network> <IPv4/MASK or IPv6/MASK or dhcp> <lo,>
		if vm != None and network != None and IPv4_MASK != None and lo != None:
			return self._run("router", vm, "interface", network, IPv4_MASK, lo)
	
		# router <vm> interface <network> <IPv4/MASK or IPv6/MASK or dhcp>
		if vm != None and network != None and IPv4_MASK != None:
			return self._run("router", vm, "interface", network, IPv4_MASK)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_log_level(self,vm,fatal_or_error_or_warn_or_info_or_debug,):
		'''
Variants:
	router <vm> log level <fatal,error,warn,info,debug>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> log level <fatal,error,warn,info,debug>
		if vm != None and fatal_or_error_or_warn_or_info_or_debug != None:
			# Validate that choice was valid for fatal_or_error_or_warn_or_info_or_debug
			if fatal_or_error_or_warn_or_info_or_debug not in ["fatal","error","warn","info","debug",]:
				raise ValueError("invalid value for fatal_or_error_or_warn_or_info_or_debug")
			return self._run("router", vm, "log", "level", fatal_or_error_or_warn_or_info_or_debug)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_ra(self,vm,subnet,):
		'''
Variants:
	router <vm> ra <subnet>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> ra <subnet>
		if vm != None and subnet != None:
			return self._run("router", vm, "ra", subnet)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_rid(self,vm,id,):
		'''
Variants:
	router <vm> rid <id>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> rid <id>
		if vm != None and id != None:
			return self._run("router", vm, "rid", id)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_route_bgp(self,vm,processname,local_or_neighbor,IPv4,asnumber,):
		'''
Variants:
	router <vm> route bgp <processname> <local,neighbor> <IPv4> <asnumber>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> route bgp <processname> <local,neighbor> <IPv4> <asnumber>
		if vm != None and processname != None and local_or_neighbor != None and IPv4 != None and asnumber != None:
			# Validate that choice was valid for local_or_neighbor
			if local_or_neighbor not in ["local","neighbor",]:
				raise ValueError("invalid value for local_or_neighbor")
			return self._run("router", vm, "route", "bgp", processname, local_or_neighbor, IPv4, asnumber)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_route_bgp_export(self,vm,processname,all_or_filter,filtername,):
		'''
Variants:
	router <vm> route bgp <processname> export <all,filter> <filtername>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> route bgp <processname> export <all,filter> <filtername>
		if vm != None and processname != None and all_or_filter != None and filtername != None:
			# Validate that choice was valid for all_or_filter
			if all_or_filter not in ["all","filter",]:
				raise ValueError("invalid value for all_or_filter")
			return self._run("router", vm, "route", "bgp", processname, "export", all_or_filter, filtername)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_route_bgp_rrclient(self,vm,processname,):
		'''
Variants:
	router <vm> route bgp <processname> rrclient

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> route bgp <processname> rrclient
		if vm != None and processname != None:
			return self._run("router", vm, "route", "bgp", processname, "rrclient")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_route_ospf(self,vm,area,network,option=None,value=None,):
		'''
Variants:
	router <vm> route ospf <area> <network> <option> <value>
	router <vm> route ospf <area> <network>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> route ospf <area> <network> <option> <value>
		if vm != None and area != None and network != None and option != None and value != None:
			return self._run("router", vm, "route", "ospf", area, network, option, value)
	
		# router <vm> route ospf <area> <network>
		if vm != None and area != None and network != None:
			return self._run("router", vm, "route", "ospf", area, network)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_route_ospf_export(self,vm,area,Ipv4_Mask,):
		'''
Variants:
	router <vm> route ospf <area> export <Ipv4/Mask or staticroutename>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> route ospf <area> export <Ipv4/Mask or staticroutename>
		if vm != None and area != None and Ipv4_Mask != None:
			return self._run("router", vm, "route", "ospf", area, "export", Ipv4_Mask)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_route_static(self,vm,network,next_hop,staticroutename=None,):
		'''
Variants:
	router <vm> route static <network> <next-hop> <staticroutename>
	router <vm> route static <network> <next-hop>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> route static <network> <next-hop> <staticroutename>
		if vm != None and network != None and next_hop != None and staticroutename != None:
			return self._run("router", vm, "route", "static", network, next_hop, staticroutename)
	
		# router <vm> route static <network> <next-hop>
		if vm != None and network != None and next_hop != None:
			return self._run("router", vm, "route", "static", network, next_hop)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def router_upstream(self,vm,ip,):
		'''
Variants:
	router <vm> upstream <ip>

Configure running minirouter VMs running minirouter and miniccc.

Routers are configured by specifying or updating a configuration, and then
applying that configuration with a commit command. For example, to configure a
router on a running VM named 'foo' to serve DHCP on 10.0.0.0/24 with a range of
IPs:

	router foo dhcp 10.0.0.0 range 10.0.0.100 10.0.0.200
	router foo commit

router takes a number of subcommands:

- 'log': Change the log level of the minirouter tool on the VM.

- 'interface': Set IPv4 or IPv6 addresses, or configure an interface to assign
  using DHCP. The interface field is an integer index of the interface defined
  with 'vm config net'. You could also specify if that interface will be a
  loopback interface For example, to configure the second interface of the
  router with a static IP and a loopback witha  different IP:

	vm config net 100 200
	# ...
	router foo interface 1 10.0.0.1/24
	router foo interface 2 11.0.0.1/32 lo

- 'dhcp': Configure one or more DHCP servers on the router. The API allows you
  to set several options including static IP assignments and the default route
  and DNS server. For example, to serve a range of IPs, with 2 static IPs
  explicitly called out on router with IP 10.0.0.1:

	router vm foo dhcp 10.0.0.0 range 10.0.0.2 10.0.0.254
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:55 10.0.0.10
	router vm foo dhcp 10.0.0.0 static 00:11:22:33:44:56 10.0.0.11

- 'dns': Set DNS records for IPv4 or IPv6 hosts.

- 'upstream': Set upstream server for DNS.

- 'gw': Set default gateway which will be used if there is no matching route.

- 'ra': Enable neighbor discovery protocol router advertisements for a given
  subnet.

- 'route': Set static, OSPF, or BGP routes. Static routes include a subnet,
  next-hop, and optionally a name for this router. For example to specify a
  static route(s):

    router foo route static 0.0.0.0/0 10.0.0.1 default-route

  OSPF routes include an area and a network index corresponding to the
  interface described in 'vm config net'. You can also specify what networks
  to advertise using the export command.

  For example, to enable OSPF on area 0 for both interfaces of a router:

	vm config net 100 200
	# ...
	router foo route ospf 0 0
	router foo route ospf 0 1

  For example, to advertise specific networks, advertise a static route or
  use a static route as a filter:

    router foo route static 11.0.0.0/24 0 bar-route
	router foo route static 12.0.0.0/24 0 bar-route
	router foo route ospf 0 export 10.0.0.0/24
	router foo route ospf 0 export default-route
	router foo route ospf 0 export bar-route

  To configure BGP must specify the process name for the specific bgp context, local ip address and AS,
  Neighbor ip address and AS, and what networks need to be advertised

  For example, local router is in AS 100 with an ip 10.0.0.1 and bgp peer is in AS 200 with an ip of 20.0.0.1
  and you want to advterise network 10.0.0.0/24:

    router foo route static 10.0.0.0/24 0 foo_out
    router foo bgp bar local 10.0.0.1 100
	router foo bgp bar neighbor 20.0.0.1 200
	router foo bgp bar export filter foo_out

  You can set up route reflection for BGP by ussing the rrclient command for that process.
  By using the command it indicates that the peer is a bgp client:

    router foo bgp bar rrclient

- 'rid': Sets the 32 bit router ID for the router. Typically this ID is unqiue
  across the orginizations network and is used for various routing protocols ie OSPF

    router foo rid 1.1.1.1
		'''
		# router <vm> upstream <ip>
		if vm != None and ip != None:
			return self._run("router", vm, "upstream", ip)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def shell(self,command,):
		'''
Variants:
	shell <command>...

Execute a command under the credentials of the running user.

Commands run until they complete or error, so take care not to execute a command
that does not return.
		'''
		# shell <command>...
		if command != None:
			return self._run("shell", command)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def tap(self,):
		'''
Variants:
	tap

Control host taps on a named vlan for communicating between a host and any VMs
on that vlan.

Calling tap with no arguments will list all created taps.

To create a tap on a particular vlan, invoke tap with the create command:

	tap create <vlan>

For example, to create a host tap with ip and netmask 10.0.0.1/24 on VLAN 5:

	tap create 5 ip 10.0.0.1/24

Optionally, you can specify the bridge to create the host tap on:

	tap create <vlan> bridge <bridge> ip <ip>

You can also optionally specify the tap name, otherwise the tap will be in the
form of mega_tapX.

Additionally, you can bring the tap up with DHCP by using "dhcp" instead of a
ip/netmask:

	tap create 5 dhcp

Tap mirror mirrors packets that traverse the source tap to the destination tap.
Both taps should already exist. You can use taps for VMs from "vm info" or host
taps. For example, to mirror traffic that traverse mega_tapX to mega_tapY on
the default bridge:

	tap mirror mega_tapX mega_tapY

Mirroring is also supported via vm names/interface indices. The VM interfaces
should already be on the same bridge. VMs must be colocated.

To delete a host tap, use the delete command and tap name from the tap list:

	tap delete <id>

To delete all host taps, use id all, or 'clear tap':

	tap delete all

Note: taps created while a namespace is active belong to that namespace and
will only be listed when that namespace is active (or no namespace is active).
Similarly, delete only applies to the taps in the active namespace. Unlike the
"vlans" API, taps with the same name cannot exist in different namespaces.
		'''
		# tap
		if True:
			return self._run("tap")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def tap_create(self,vlan,):
		'''
Variants:
	tap create <vlan>

Control host taps on a named vlan for communicating between a host and any VMs
on that vlan.

Calling tap with no arguments will list all created taps.

To create a tap on a particular vlan, invoke tap with the create command:

	tap create <vlan>

For example, to create a host tap with ip and netmask 10.0.0.1/24 on VLAN 5:

	tap create 5 ip 10.0.0.1/24

Optionally, you can specify the bridge to create the host tap on:

	tap create <vlan> bridge <bridge> ip <ip>

You can also optionally specify the tap name, otherwise the tap will be in the
form of mega_tapX.

Additionally, you can bring the tap up with DHCP by using "dhcp" instead of a
ip/netmask:

	tap create 5 dhcp

Tap mirror mirrors packets that traverse the source tap to the destination tap.
Both taps should already exist. You can use taps for VMs from "vm info" or host
taps. For example, to mirror traffic that traverse mega_tapX to mega_tapY on
the default bridge:

	tap mirror mega_tapX mega_tapY

Mirroring is also supported via vm names/interface indices. The VM interfaces
should already be on the same bridge. VMs must be colocated.

To delete a host tap, use the delete command and tap name from the tap list:

	tap delete <id>

To delete all host taps, use id all, or 'clear tap':

	tap delete all

Note: taps created while a namespace is active belong to that namespace and
will only be listed when that namespace is active (or no namespace is active).
Similarly, delete only applies to the taps in the active namespace. Unlike the
"vlans" API, taps with the same name cannot exist in different namespaces.
		'''
		# tap create <vlan>
		if vlan != None:
			return self._run("tap", "create", vlan)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def tap_create_bridge(self,vlan,bridge,):
		'''
Variants:
	tap create <vlan> bridge <bridge>

Control host taps on a named vlan for communicating between a host and any VMs
on that vlan.

Calling tap with no arguments will list all created taps.

To create a tap on a particular vlan, invoke tap with the create command:

	tap create <vlan>

For example, to create a host tap with ip and netmask 10.0.0.1/24 on VLAN 5:

	tap create 5 ip 10.0.0.1/24

Optionally, you can specify the bridge to create the host tap on:

	tap create <vlan> bridge <bridge> ip <ip>

You can also optionally specify the tap name, otherwise the tap will be in the
form of mega_tapX.

Additionally, you can bring the tap up with DHCP by using "dhcp" instead of a
ip/netmask:

	tap create 5 dhcp

Tap mirror mirrors packets that traverse the source tap to the destination tap.
Both taps should already exist. You can use taps for VMs from "vm info" or host
taps. For example, to mirror traffic that traverse mega_tapX to mega_tapY on
the default bridge:

	tap mirror mega_tapX mega_tapY

Mirroring is also supported via vm names/interface indices. The VM interfaces
should already be on the same bridge. VMs must be colocated.

To delete a host tap, use the delete command and tap name from the tap list:

	tap delete <id>

To delete all host taps, use id all, or 'clear tap':

	tap delete all

Note: taps created while a namespace is active belong to that namespace and
will only be listed when that namespace is active (or no namespace is active).
Similarly, delete only applies to the taps in the active namespace. Unlike the
"vlans" API, taps with the same name cannot exist in different namespaces.
		'''
		# tap create <vlan> bridge <bridge>
		if vlan != None and bridge != None:
			return self._run("tap", "create", vlan, "bridge", bridge)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def tap_create_bridge_dhcp(self,vlan,bridge,tap=None,):
		'''
Variants:
	tap create <vlan> bridge <bridge> dhcp <tap name>
	tap create <vlan> bridge <bridge> dhcp

Control host taps on a named vlan for communicating between a host and any VMs
on that vlan.

Calling tap with no arguments will list all created taps.

To create a tap on a particular vlan, invoke tap with the create command:

	tap create <vlan>

For example, to create a host tap with ip and netmask 10.0.0.1/24 on VLAN 5:

	tap create 5 ip 10.0.0.1/24

Optionally, you can specify the bridge to create the host tap on:

	tap create <vlan> bridge <bridge> ip <ip>

You can also optionally specify the tap name, otherwise the tap will be in the
form of mega_tapX.

Additionally, you can bring the tap up with DHCP by using "dhcp" instead of a
ip/netmask:

	tap create 5 dhcp

Tap mirror mirrors packets that traverse the source tap to the destination tap.
Both taps should already exist. You can use taps for VMs from "vm info" or host
taps. For example, to mirror traffic that traverse mega_tapX to mega_tapY on
the default bridge:

	tap mirror mega_tapX mega_tapY

Mirroring is also supported via vm names/interface indices. The VM interfaces
should already be on the same bridge. VMs must be colocated.

To delete a host tap, use the delete command and tap name from the tap list:

	tap delete <id>

To delete all host taps, use id all, or 'clear tap':

	tap delete all

Note: taps created while a namespace is active belong to that namespace and
will only be listed when that namespace is active (or no namespace is active).
Similarly, delete only applies to the taps in the active namespace. Unlike the
"vlans" API, taps with the same name cannot exist in different namespaces.
		'''
		# tap create <vlan> bridge <bridge> dhcp <tap name>
		if vlan != None and bridge != None and tap != None:
			return self._run("tap", "create", vlan, "bridge", bridge, "dhcp", tap)
	
		# tap create <vlan> bridge <bridge> dhcp
		if vlan != None and bridge != None:
			return self._run("tap", "create", vlan, "bridge", bridge, "dhcp")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def tap_create_bridge_ip(self,vlan,bridge,ip,tap=None,):
		'''
Variants:
	tap create <vlan> bridge <bridge> ip <ip> <tap name>
	tap create <vlan> bridge <bridge> ip <ip>

Control host taps on a named vlan for communicating between a host and any VMs
on that vlan.

Calling tap with no arguments will list all created taps.

To create a tap on a particular vlan, invoke tap with the create command:

	tap create <vlan>

For example, to create a host tap with ip and netmask 10.0.0.1/24 on VLAN 5:

	tap create 5 ip 10.0.0.1/24

Optionally, you can specify the bridge to create the host tap on:

	tap create <vlan> bridge <bridge> ip <ip>

You can also optionally specify the tap name, otherwise the tap will be in the
form of mega_tapX.

Additionally, you can bring the tap up with DHCP by using "dhcp" instead of a
ip/netmask:

	tap create 5 dhcp

Tap mirror mirrors packets that traverse the source tap to the destination tap.
Both taps should already exist. You can use taps for VMs from "vm info" or host
taps. For example, to mirror traffic that traverse mega_tapX to mega_tapY on
the default bridge:

	tap mirror mega_tapX mega_tapY

Mirroring is also supported via vm names/interface indices. The VM interfaces
should already be on the same bridge. VMs must be colocated.

To delete a host tap, use the delete command and tap name from the tap list:

	tap delete <id>

To delete all host taps, use id all, or 'clear tap':

	tap delete all

Note: taps created while a namespace is active belong to that namespace and
will only be listed when that namespace is active (or no namespace is active).
Similarly, delete only applies to the taps in the active namespace. Unlike the
"vlans" API, taps with the same name cannot exist in different namespaces.
		'''
		# tap create <vlan> bridge <bridge> ip <ip> <tap name>
		if vlan != None and bridge != None and ip != None and tap != None:
			return self._run("tap", "create", vlan, "bridge", bridge, "ip", ip, tap)
	
		# tap create <vlan> bridge <bridge> ip <ip>
		if vlan != None and bridge != None and ip != None:
			return self._run("tap", "create", vlan, "bridge", bridge, "ip", ip)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def tap_create_bridge_name(self,vlan,bridge,tap=None,):
		'''
Variants:
	tap create <vlan> bridge <bridge> name <tap name>
	tap create <vlan> bridge <bridge> name

Control host taps on a named vlan for communicating between a host and any VMs
on that vlan.

Calling tap with no arguments will list all created taps.

To create a tap on a particular vlan, invoke tap with the create command:

	tap create <vlan>

For example, to create a host tap with ip and netmask 10.0.0.1/24 on VLAN 5:

	tap create 5 ip 10.0.0.1/24

Optionally, you can specify the bridge to create the host tap on:

	tap create <vlan> bridge <bridge> ip <ip>

You can also optionally specify the tap name, otherwise the tap will be in the
form of mega_tapX.

Additionally, you can bring the tap up with DHCP by using "dhcp" instead of a
ip/netmask:

	tap create 5 dhcp

Tap mirror mirrors packets that traverse the source tap to the destination tap.
Both taps should already exist. You can use taps for VMs from "vm info" or host
taps. For example, to mirror traffic that traverse mega_tapX to mega_tapY on
the default bridge:

	tap mirror mega_tapX mega_tapY

Mirroring is also supported via vm names/interface indices. The VM interfaces
should already be on the same bridge. VMs must be colocated.

To delete a host tap, use the delete command and tap name from the tap list:

	tap delete <id>

To delete all host taps, use id all, or 'clear tap':

	tap delete all

Note: taps created while a namespace is active belong to that namespace and
will only be listed when that namespace is active (or no namespace is active).
Similarly, delete only applies to the taps in the active namespace. Unlike the
"vlans" API, taps with the same name cannot exist in different namespaces.
		'''
		# tap create <vlan> bridge <bridge> name <tap name>
		if vlan != None and bridge != None and tap != None:
			return self._run("tap", "create", vlan, "bridge", bridge, "name", tap)
	
		# tap create <vlan> bridge <bridge> name
		if vlan != None and bridge != None:
			return self._run("tap", "create", vlan, "bridge", bridge, "name")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def tap_create_dhcp(self,vlan,tap=None,):
		'''
Variants:
	tap create <vlan> dhcp <tap name>
	tap create <vlan> dhcp

Control host taps on a named vlan for communicating between a host and any VMs
on that vlan.

Calling tap with no arguments will list all created taps.

To create a tap on a particular vlan, invoke tap with the create command:

	tap create <vlan>

For example, to create a host tap with ip and netmask 10.0.0.1/24 on VLAN 5:

	tap create 5 ip 10.0.0.1/24

Optionally, you can specify the bridge to create the host tap on:

	tap create <vlan> bridge <bridge> ip <ip>

You can also optionally specify the tap name, otherwise the tap will be in the
form of mega_tapX.

Additionally, you can bring the tap up with DHCP by using "dhcp" instead of a
ip/netmask:

	tap create 5 dhcp

Tap mirror mirrors packets that traverse the source tap to the destination tap.
Both taps should already exist. You can use taps for VMs from "vm info" or host
taps. For example, to mirror traffic that traverse mega_tapX to mega_tapY on
the default bridge:

	tap mirror mega_tapX mega_tapY

Mirroring is also supported via vm names/interface indices. The VM interfaces
should already be on the same bridge. VMs must be colocated.

To delete a host tap, use the delete command and tap name from the tap list:

	tap delete <id>

To delete all host taps, use id all, or 'clear tap':

	tap delete all

Note: taps created while a namespace is active belong to that namespace and
will only be listed when that namespace is active (or no namespace is active).
Similarly, delete only applies to the taps in the active namespace. Unlike the
"vlans" API, taps with the same name cannot exist in different namespaces.
		'''
		# tap create <vlan> dhcp <tap name>
		if vlan != None and tap != None:
			return self._run("tap", "create", vlan, "dhcp", tap)
	
		# tap create <vlan> dhcp
		if vlan != None:
			return self._run("tap", "create", vlan, "dhcp")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def tap_create_ip(self,vlan,ip,tap=None,):
		'''
Variants:
	tap create <vlan> ip <ip> <tap name>
	tap create <vlan> ip <ip>

Control host taps on a named vlan for communicating between a host and any VMs
on that vlan.

Calling tap with no arguments will list all created taps.

To create a tap on a particular vlan, invoke tap with the create command:

	tap create <vlan>

For example, to create a host tap with ip and netmask 10.0.0.1/24 on VLAN 5:

	tap create 5 ip 10.0.0.1/24

Optionally, you can specify the bridge to create the host tap on:

	tap create <vlan> bridge <bridge> ip <ip>

You can also optionally specify the tap name, otherwise the tap will be in the
form of mega_tapX.

Additionally, you can bring the tap up with DHCP by using "dhcp" instead of a
ip/netmask:

	tap create 5 dhcp

Tap mirror mirrors packets that traverse the source tap to the destination tap.
Both taps should already exist. You can use taps for VMs from "vm info" or host
taps. For example, to mirror traffic that traverse mega_tapX to mega_tapY on
the default bridge:

	tap mirror mega_tapX mega_tapY

Mirroring is also supported via vm names/interface indices. The VM interfaces
should already be on the same bridge. VMs must be colocated.

To delete a host tap, use the delete command and tap name from the tap list:

	tap delete <id>

To delete all host taps, use id all, or 'clear tap':

	tap delete all

Note: taps created while a namespace is active belong to that namespace and
will only be listed when that namespace is active (or no namespace is active).
Similarly, delete only applies to the taps in the active namespace. Unlike the
"vlans" API, taps with the same name cannot exist in different namespaces.
		'''
		# tap create <vlan> ip <ip> <tap name>
		if vlan != None and ip != None and tap != None:
			return self._run("tap", "create", vlan, "ip", ip, tap)
	
		# tap create <vlan> ip <ip>
		if vlan != None and ip != None:
			return self._run("tap", "create", vlan, "ip", ip)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def tap_create_name(self,vlan,tap,):
		'''
Variants:
	tap create <vlan> name <tap name>

Control host taps on a named vlan for communicating between a host and any VMs
on that vlan.

Calling tap with no arguments will list all created taps.

To create a tap on a particular vlan, invoke tap with the create command:

	tap create <vlan>

For example, to create a host tap with ip and netmask 10.0.0.1/24 on VLAN 5:

	tap create 5 ip 10.0.0.1/24

Optionally, you can specify the bridge to create the host tap on:

	tap create <vlan> bridge <bridge> ip <ip>

You can also optionally specify the tap name, otherwise the tap will be in the
form of mega_tapX.

Additionally, you can bring the tap up with DHCP by using "dhcp" instead of a
ip/netmask:

	tap create 5 dhcp

Tap mirror mirrors packets that traverse the source tap to the destination tap.
Both taps should already exist. You can use taps for VMs from "vm info" or host
taps. For example, to mirror traffic that traverse mega_tapX to mega_tapY on
the default bridge:

	tap mirror mega_tapX mega_tapY

Mirroring is also supported via vm names/interface indices. The VM interfaces
should already be on the same bridge. VMs must be colocated.

To delete a host tap, use the delete command and tap name from the tap list:

	tap delete <id>

To delete all host taps, use id all, or 'clear tap':

	tap delete all

Note: taps created while a namespace is active belong to that namespace and
will only be listed when that namespace is active (or no namespace is active).
Similarly, delete only applies to the taps in the active namespace. Unlike the
"vlans" API, taps with the same name cannot exist in different namespaces.
		'''
		# tap create <vlan> name <tap name>
		if vlan != None and tap != None:
			return self._run("tap", "create", vlan, "name", tap)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def tap_delete(self,tap,):
		'''
Variants:
	tap delete <tap name or all>

Control host taps on a named vlan for communicating between a host and any VMs
on that vlan.

Calling tap with no arguments will list all created taps.

To create a tap on a particular vlan, invoke tap with the create command:

	tap create <vlan>

For example, to create a host tap with ip and netmask 10.0.0.1/24 on VLAN 5:

	tap create 5 ip 10.0.0.1/24

Optionally, you can specify the bridge to create the host tap on:

	tap create <vlan> bridge <bridge> ip <ip>

You can also optionally specify the tap name, otherwise the tap will be in the
form of mega_tapX.

Additionally, you can bring the tap up with DHCP by using "dhcp" instead of a
ip/netmask:

	tap create 5 dhcp

Tap mirror mirrors packets that traverse the source tap to the destination tap.
Both taps should already exist. You can use taps for VMs from "vm info" or host
taps. For example, to mirror traffic that traverse mega_tapX to mega_tapY on
the default bridge:

	tap mirror mega_tapX mega_tapY

Mirroring is also supported via vm names/interface indices. The VM interfaces
should already be on the same bridge. VMs must be colocated.

To delete a host tap, use the delete command and tap name from the tap list:

	tap delete <id>

To delete all host taps, use id all, or 'clear tap':

	tap delete all

Note: taps created while a namespace is active belong to that namespace and
will only be listed when that namespace is active (or no namespace is active).
Similarly, delete only applies to the taps in the active namespace. Unlike the
"vlans" API, taps with the same name cannot exist in different namespaces.
		'''
		# tap delete <tap name or all>
		if tap != None:
			return self._run("tap", "delete", tap)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def tap_mirror(self,src=None,dst=None,bridge=None,vm=None,interface=None,vm2=None,interface2=None,):
		'''
Variants:
	tap mirror <vm name> <interface index> <vm2 name> <interface2 index>
	tap mirror <src name> <dst name> <bridge>
	tap mirror <src name> <dst name>

Control host taps on a named vlan for communicating between a host and any VMs
on that vlan.

Calling tap with no arguments will list all created taps.

To create a tap on a particular vlan, invoke tap with the create command:

	tap create <vlan>

For example, to create a host tap with ip and netmask 10.0.0.1/24 on VLAN 5:

	tap create 5 ip 10.0.0.1/24

Optionally, you can specify the bridge to create the host tap on:

	tap create <vlan> bridge <bridge> ip <ip>

You can also optionally specify the tap name, otherwise the tap will be in the
form of mega_tapX.

Additionally, you can bring the tap up with DHCP by using "dhcp" instead of a
ip/netmask:

	tap create 5 dhcp

Tap mirror mirrors packets that traverse the source tap to the destination tap.
Both taps should already exist. You can use taps for VMs from "vm info" or host
taps. For example, to mirror traffic that traverse mega_tapX to mega_tapY on
the default bridge:

	tap mirror mega_tapX mega_tapY

Mirroring is also supported via vm names/interface indices. The VM interfaces
should already be on the same bridge. VMs must be colocated.

To delete a host tap, use the delete command and tap name from the tap list:

	tap delete <id>

To delete all host taps, use id all, or 'clear tap':

	tap delete all

Note: taps created while a namespace is active belong to that namespace and
will only be listed when that namespace is active (or no namespace is active).
Similarly, delete only applies to the taps in the active namespace. Unlike the
"vlans" API, taps with the same name cannot exist in different namespaces.
		'''
		# tap mirror <vm name> <interface index> <vm2 name> <interface2 index>
		if vm != None and interface != None and vm2 != None and interface2 != None:
			return self._run("tap", "mirror", vm, interface, vm2, interface2)
	
		# tap mirror <src name> <dst name> <bridge>
		if src != None and dst != None and bridge != None:
			return self._run("tap", "mirror", src, dst, bridge)
	
		# tap mirror <src name> <dst name>
		if src != None and dst != None:
			return self._run("tap", "mirror", src, dst)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def version(self,):
		'''
Variants:
	version

display the minimega version
		'''
		# version
		if True:
			return self._run("version")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def viz(self,filename,):
		'''
Variants:
	viz <filename>

Output the current experiment topology as a graphviz readable 'dot' file.
		'''
		# viz <filename>
		if filename != None:
			return self._run("viz", filename)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vlans(self,):
		'''
Variants:
	vlans

Display information about allocated VLANs. With no arguments, prints out the
known VLAN aliases. The following subcommands are supported:

range		- view or set the VLAN range
add   		- add an alias
blacklist 	- view or create blacklisted VLAN

Note: this command is namespace aware so, for example, adding a range applies
to all *new* VLAN aliases in the current namespace.
		'''
		# vlans
		if True:
			return self._run("vlans")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vlans_add(self,alias,vlan,):
		'''
Variants:
	vlans add <alias> <vlan>

Display information about allocated VLANs. With no arguments, prints out the
known VLAN aliases. The following subcommands are supported:

range		- view or set the VLAN range
add   		- add an alias
blacklist 	- view or create blacklisted VLAN

Note: this command is namespace aware so, for example, adding a range applies
to all *new* VLAN aliases in the current namespace.
		'''
		# vlans add <alias> <vlan>
		if alias != None and vlan != None:
			return self._run("vlans", "add", alias, vlan)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vlans_blacklist(self,vlan=None,):
		'''
Variants:
	vlans blacklist <vlan>
	vlans blacklist

Display information about allocated VLANs. With no arguments, prints out the
known VLAN aliases. The following subcommands are supported:

range		- view or set the VLAN range
add   		- add an alias
blacklist 	- view or create blacklisted VLAN

Note: this command is namespace aware so, for example, adding a range applies
to all *new* VLAN aliases in the current namespace.
		'''
		# vlans blacklist <vlan>
		if vlan != None:
			return self._run("vlans", "blacklist", vlan)
	
		# vlans blacklist
		if True:
			return self._run("vlans", "blacklist")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vlans_range(self,min=None,max=None,):
		'''
Variants:
	vlans range <min> <max>
	vlans range

Display information about allocated VLANs. With no arguments, prints out the
known VLAN aliases. The following subcommands are supported:

range		- view or set the VLAN range
add   		- add an alias
blacklist 	- view or create blacklisted VLAN

Note: this command is namespace aware so, for example, adding a range applies
to all *new* VLAN aliases in the current namespace.
		'''
		# vlans range <min> <max>
		if min != None and max != None:
			return self._run("vlans", "range", min, max)
	
		# vlans range
		if True:
			return self._run("vlans", "range")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_cdrom_change(self,vm,path,force=None,):
		'''
Variants:
	vm cdrom change <vm target> <path> <force,>
	vm cdrom change <vm target> <path>

Eject or change an active VM's cdrom image.

Eject VM 0's cdrom:

        vm cdrom eject 0

Eject all VM cdroms:

        vm cdrom eject all

If the cdrom is "locked" by the guest, the force option can be used to override
the lock:

        vm cdrom eject 0 force

Change a VM to use a new ISO:

        vm cdrom change 0 /tmp/debian.iso

"vm cdrom change" ejects the current ISO, if there is one.

See "vm start" for a full description of allowable targets.
		'''
		# vm cdrom change <vm target> <path> <force,>
		if vm != None and path != None and force != None:
			return self._run("vm", "cdrom", "change", vm, path, force)
	
		# vm cdrom change <vm target> <path>
		if vm != None and path != None:
			return self._run("vm", "cdrom", "change", vm, path)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_cdrom_eject(self,vm,force=None,):
		'''
Variants:
	vm cdrom eject <vm target> <force,>
	vm cdrom eject <vm target>

Eject or change an active VM's cdrom image.

Eject VM 0's cdrom:

        vm cdrom eject 0

Eject all VM cdroms:

        vm cdrom eject all

If the cdrom is "locked" by the guest, the force option can be used to override
the lock:

        vm cdrom eject 0 force

Change a VM to use a new ISO:

        vm cdrom change 0 /tmp/debian.iso

"vm cdrom change" ejects the current ISO, if there is one.

See "vm start" for a full description of allowable targets.
		'''
		# vm cdrom eject <vm target> <force,>
		if vm != None and force != None:
			return self._run("vm", "cdrom", "eject", vm, force)
	
		# vm cdrom eject <vm target>
		if vm != None:
			return self._run("vm", "cdrom", "eject", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config(self,):
		'''
Variants:
	vm config

Display, save, or restore the current VM configuration. Note that saving and
restoring configuration applies to all VM configurations including KVM-based VM
configurations.

To display the current configuration, call vm config with no arguments.

List the current saved configurations with 'vm config restore'.

To save a configuration:

	vm config save <config name>

To restore a configuration:

	vm config restore <config name>

To clone the configuration of an existing VM:

	vm config clone <vm name>

Clone reparses the original network "vm config net". If the cloned VM was
configured with a static MAC, the VM config will not be launchable. Clone also
clears the UUID.

Calling clear vm config will clear all VM configuration options, but will not
remove saved configurations.
		'''
		# vm config
		if True:
			return self._run("vm", "config")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_append(self,value=None,):
		'''
Variants:
	vm config append <value>...
	vm config append

Add an append string to a kernel set with vm kernel. Setting vm append
without using vm kernel will result in an error.

For example, to set a static IP for a linux VM:

	vm config append ip=10.0.0.5 gateway=10.0.0.1 netmask=255.255.255.0 dns=10.10.10.10

Note: this configuration only applies to KVM-based VMs.
		'''
		# vm config append <value>...
		if value != None:
			return self._run("vm", "config", "append", value)
	
		# vm config append
		if True:
			return self._run("vm", "config", "append")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_backchannel(self,true_or_false=None,):
		'''
Variants:
	vm config backchannel <true,false>
	vm config backchannel

Enable/disable serial command and control layer for this VM.

Default: true
		'''
		# vm config backchannel <true,false>
		if true_or_false != None:
			# Validate that choice was valid for true_or_false
			if true_or_false not in ["true","false",]:
				raise ValueError("invalid value for true_or_false")
			return self._run("vm", "config", "backchannel", true_or_false)
	
		# vm config backchannel
		if True:
			return self._run("vm", "config", "backchannel")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_cdrom(self,value=None,):
		'''
Variants:
	vm config cdrom <value>
	vm config cdrom

Attach a cdrom to a VM. When using a cdrom, it will automatically be set
to be the boot device.

Note: this configuration only applies to KVM-based VMs.
		'''
		# vm config cdrom <value>
		if value != None:
			return self._run("vm", "config", "cdrom", value)
	
		# vm config cdrom
		if True:
			return self._run("vm", "config", "cdrom")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_clone(self,vm,):
		'''
Variants:
	vm config clone <vm name>

Display, save, or restore the current VM configuration. Note that saving and
restoring configuration applies to all VM configurations including KVM-based VM
configurations.

To display the current configuration, call vm config with no arguments.

List the current saved configurations with 'vm config restore'.

To save a configuration:

	vm config save <config name>

To restore a configuration:

	vm config restore <config name>

To clone the configuration of an existing VM:

	vm config clone <vm name>

Clone reparses the original network "vm config net". If the cloned VM was
configured with a static MAC, the VM config will not be launchable. Clone also
clears the UUID.

Calling clear vm config will clear all VM configuration options, but will not
remove saved configurations.
		'''
		# vm config clone <vm name>
		if vm != None:
			return self._run("vm", "config", "clone", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_colocate(self,value=None,):
		'''
Variants:
	vm config colocate <value>
	vm config colocate

Colocate this VM with another VM that has already been launched or is
queued for launching.

Note: Cannot specify Colocate and Schedule in the same
		'''
		# vm config colocate <value>
		if value != None:
			return self._run("vm", "config", "colocate", value)
	
		# vm config colocate
		if True:
			return self._run("vm", "config", "colocate")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_cores(self,value=None,):
		'''
Variants:
	vm config cores <value>
	vm config cores

Set the number of CPU cores per socket. If unspecified, QEMU will
calculate missing values based on vCPUs, sockets, and threads.
		'''
		# vm config cores <value>
		if value != None:
			return self._run("vm", "config", "cores", value)
	
		# vm config cores
		if True:
			return self._run("vm", "config", "cores")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_coschedule(self,value=None,):
		'''
Variants:
	vm config coschedule <value>
	vm config coschedule

Set a limit on the number of VMs that should be scheduled on the same
host as the VM. A limit of zero means that the VM should be scheduled by
itself. A limit of -1 means that there is no limit. This is only used
when launching VMs in a namespace.

Default: -1
		'''
		# vm config coschedule <value>
		if value != None:
			return self._run("vm", "config", "coschedule", value)
	
		# vm config coschedule
		if True:
			return self._run("vm", "config", "coschedule")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_cpu(self,value=None,):
		'''
Variants:
	vm config cpu <value>
	vm config cpu

Set the virtual CPU architecture.

By default, set to 'host' which matches the host CPU. See 'qemu -cpu
help' for a list of supported CPUs.

The accepted values for this configuration depend on the QEMU binary
name specified by 'vm config qemu'.

Note: this configuration only applies to KVM-based VMs.

Default: "host"
		'''
		# vm config cpu <value>
		if value != None:
			return self._run("vm", "config", "cpu", value)
	
		# vm config cpu
		if True:
			return self._run("vm", "config", "cpu")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_disks(self,diskspec=None,):
		'''
Variants:
	vm config disks <diskspec>...
	vm config disks

Specify one or more disks to be connected to a VM. Any disk image supported by QEMU is a valid parameter.

Optionally, you may specify the drive interface for QEMU to use. By default,
"ide" is used. Supported interfaces are "ahci", "ide", "scsi", "sd", "mtd",
"floppy", "pflash", and "virtio".

Optionally, you may specify the cache mode to be used by the drive. By default,
"unsafe" is used for vms launched in snapshot mode, and "writeback" is used
otherwise. Supported cache modes are "none", "writeback", "unsafe",
"directsync", and "writethrough".

Note: although disk snapshot image files are saved in the temporary vm instance
paths, they may not be usable if the "unsafe" cache mode is used, as all flush
commands from the guest are ignored in that cache mode. For example, even if
you shut down the guest cleanly, there may still be data not yet written to the
snapshot image file. If you wish to copy and use the snapshot image file
cleanly, you can flush the disk cache manually via the QMP command socket, or
specify a different cache mode such as "writeback".

The order is:

	<path>,<interface>,<cache mode>

Examples:

To attach a disk with the default interface and cache mode:

	vm config disk linux_disk.qcow2

To attach 2 disks using the "ide" interface for the first disk and default
interface for the second disk:

	vm config disk linux_disk.qcow2,ide storage_disk.qcow2

To attach a disk using the "ide" interface with the "unsafe" cache mode:

	vm config disk linux_disk.qcow2,ide,unsafe

Disk images launched in snapshot mode may safely be used for multiple VMs.

Calling vm config disks with no arguments prints the current configuration.

Note: this configuration only applies to KVM-based VMs.
		'''
		# vm config disks <diskspec>...
		if diskspec != None:
			return self._run("vm", "config", "disks", diskspec)
	
		# vm config disks
		if True:
			return self._run("vm", "config", "disks")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_fifos(self,value=None,):
		'''
Variants:
	vm config fifos <value>
	vm config fifos

Set the number of named pipes to include in the container for
container-host communication. Named pipes will appear on the host in the
instance directory for the container as fifoN, and on the container as
/dev/fifos/fifoN.

Fifos are created using mkfifo() and have all of the same usage
constraints.

Note: this configuration only applies to containers.
		'''
		# vm config fifos <value>
		if value != None:
			return self._run("vm", "config", "fifos", value)
	
		# vm config fifos
		if True:
			return self._run("vm", "config", "fifos")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_filesystem(self,value=None,):
		'''
Variants:
	vm config filesystem <value>
	vm config filesystem

Configure the filesystem to use for launching a container. This should
be a root filesystem for a linux distribution (containing /dev, /proc,
/sys, etc.)

Note: this configuration only applies to containers and must be specified.
		'''
		# vm config filesystem <value>
		if value != None:
			return self._run("vm", "config", "filesystem", value)
	
		# vm config filesystem
		if True:
			return self._run("vm", "config", "filesystem")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_hostname(self,value=None,):
		'''
Variants:
	vm config hostname <value>
	vm config hostname

Set a hostname for a container before launching the init program. If not
set, the hostname will be the VM name. The hostname can also be set by
the init program or other root process in the container.

Note: this configuration only applies to containers.
		'''
		# vm config hostname <value>
		if value != None:
			return self._run("vm", "config", "hostname", value)
	
		# vm config hostname
		if True:
			return self._run("vm", "config", "hostname")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_init(self,value=None,):
		'''
Variants:
	vm config init <value>...
	vm config init

Set the init program and args to exec into upon container launch. This
will be PID 1 in the container.

Note: this configuration only applies to containers.

Default: "/init"
		'''
		# vm config init <value>...
		if value != None:
			return self._run("vm", "config", "init", value)
	
		# vm config init
		if True:
			return self._run("vm", "config", "init")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_initrd(self,value=None,):
		'''
Variants:
	vm config initrd <value>
	vm config initrd

Attach an initrd image to a VM. Passed along with the kernel image at
boot time.

Note: this configuration only applies to KVM-based VMs.
		'''
		# vm config initrd <value>
		if value != None:
			return self._run("vm", "config", "initrd", value)
	
		# vm config initrd
		if True:
			return self._run("vm", "config", "initrd")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_kernel(self,value=None,):
		'''
Variants:
	vm config kernel <value>
	vm config kernel

Attach a kernel image to a VM. If set, QEMU will boot from this image
instead of any disk image.

Note: this configuration only applies to KVM-based VMs.
		'''
		# vm config kernel <value>
		if value != None:
			return self._run("vm", "config", "kernel", value)
	
		# vm config kernel
		if True:
			return self._run("vm", "config", "kernel")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_machine(self,value=None,):
		'''
Variants:
	vm config machine <value>
	vm config machine

Specify the machine type. See 'qemu -M help' for a list supported
machine types.

The accepted values for this configuration depend on the QEMU binary
name specified by 'vm config qemu'.

Note: this configuration only applies to KVM-based VMs.
		'''
		# vm config machine <value>
		if value != None:
			return self._run("vm", "config", "machine", value)
	
		# vm config machine
		if True:
			return self._run("vm", "config", "machine")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_memory(self,value=None,):
		'''
Variants:
	vm config memory <value>
	vm config memory

Configures the amount of physical memory to allocate (in megabytes).

Default: 2048
		'''
		# vm config memory <value>
		if value != None:
			return self._run("vm", "config", "memory", value)
	
		# vm config memory
		if True:
			return self._run("vm", "config", "memory")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_migrate(self,value=None,):
		'''
Variants:
	vm config migrate <value>
	vm config migrate

Assign a migration image, generated by a previously saved VM to boot
with. By default, images are read from the files directory as specified
with -filepath. This can be overriden by using an absolute path.
Migration images should be booted with a kernel/initrd, disk, or cdrom.
Use 'vm migrate' to generate migration images from running VMs.

Note: this configuration only applies to KVM-based VMs.
		'''
		# vm config migrate <value>
		if value != None:
			return self._run("vm", "config", "migrate", value)
	
		# vm config migrate
		if True:
			return self._run("vm", "config", "migrate")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_networks(self,netspec=None,):
		'''
Variants:
	vm config networks <netspec>...
	vm config networks

Specify the network(s) that the VM is a member of by VLAN. A corresponding VLAN
will be created for each network. Optionally, you may specify the bridge the
interface will be connected on. If the bridge name is omitted, minimega will
use the default "mega_bridge".

You can also optionally specify the MAC address of the interface to connect to
that network. If not specifed, the MAC address will be randomly generated.

Finally, you can also optionally specify a network device for qemu to use
(which is ignored by containers). By default, "e1000" is used. To see a list of
valid network devices, from run "qemu-kvm -device help".

The order is:

	<bridge>,<VLAN>,<MAC>,<driver>

Examples:

To connect a VM to VLANs 1 and 5:

	vm config net 1 5

To connect a VM to VLANs 100, 101, and 102 with specific mac addresses:

	vm config net 100,00:00:00:00:00:00 101,00:00:00:00:01:00 102,00:00:00:00:02:00

To connect a VM to VLAN 1 on bridge0 and VLAN 2 on bridge1:

	vm config net bridge0,1 bridge1,2

To connect a VM to VLAN 100 on bridge0 with a specific mac:

	vm config net bridge0,100,00:11:22:33:44:55

To specify a specific driver, such as i82559c:

	vm config net 100,i82559c

If you prefer, you can also use aliases for VLANs:

	vm config net DMZ CORE

These aliases will be allocated from the pool of available VLANs and is
namespace-aware (i.e. 'DMZ' in namespace 'foo' will be a different VLAN than
'DMZ' in namespace 'bar'). Internally, this is implemented by concatenating the
namespace name with the VLAN alias (e.g. 'DMZ' in namespace 'foo' becomes
'foo//DMZ'). If you wish to connect VLANs in different namespaces, you may
use/abuse this implementation detail:

	namespace bar
	vm config net foo//DMZ

Calling vm config net with no arguments prints the current configuration.
		'''
		# vm config networks <netspec>...
		if netspec != None:
			return self._run("vm", "config", "networks", netspec)
	
		# vm config networks
		if True:
			return self._run("vm", "config", "networks")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_preinit(self,value=None,):
		'''
Variants:
	vm config preinit <value>
	vm config preinit

Containers start in a highly restricted environment. vm config preinit
allows running processes before isolation mechanisms are enabled. This
occurs when the vm is launched and before the vm is put in the building
state. preinit processes must finish before the vm will be allowed to
start.

Specifically, the preinit command will be run after entering namespaces,
and mounting dependent filesystems, but before cgroups and root
capabilities are set, and before entering the chroot. This means that
the preinit command is run as root and can control the host.

For example, to run a script that enables ip forwarding, which is not
allowed during runtime because /proc is mounted read-only, add a preinit
script:

	vm config preinit enable_ip_forwarding.sh

Note: this configuration only applies to containers.
		'''
		# vm config preinit <value>
		if value != None:
			return self._run("vm", "config", "preinit", value)
	
		# vm config preinit
		if True:
			return self._run("vm", "config", "preinit")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_qemu(self,value=None,):
		'''
Variants:
	vm config qemu <value>
	vm config qemu

Set the QEMU binary name to invoke. Relative paths are ok.

Note: this configuration only applies to KVM-based VMs.

Default: "kvm"
		'''
		# vm config qemu <value>
		if value != None:
			return self._run("vm", "config", "qemu", value)
	
		# vm config qemu
		if True:
			return self._run("vm", "config", "qemu")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_qemu_append(self,value=None,):
		'''
Variants:
	vm config qemu-append <value>...
	vm config qemu-append

Add additional arguments to be passed to the QEMU instance. For example:

	vm config qemu-append -serial tcp:localhost:4001

Note: this configuration only applies to KVM-based VMs.
		'''
		# vm config qemu-append <value>...
		if value != None:
			return self._run("vm", "config", "qemu-append", value)
	
		# vm config qemu-append
		if True:
			return self._run("vm", "config", "qemu-append")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_qemu_override(self,match=None,replacement=None,):
		'''
Variants:
	vm config qemu-override <match> <replacement>
	vm config qemu-override

Override parts of the QEMU launch string by supplying a string to match, and a
replacement string. Overrides are applied in the order that they are defined
and do not replace earlier overrides -- if more than override share the same
"match" will later overrides will be applied to the overridden launch string.

Note: this configuration only applies to KVM-based VMs.
		'''
		# vm config qemu-override <match> <replacement>
		if match != None and replacement != None:
			return self._run("vm", "config", "qemu-override", match, replacement)
	
		# vm config qemu-override
		if True:
			return self._run("vm", "config", "qemu-override")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_restore(self,name=None,):
		'''
Variants:
	vm config restore <name>
	vm config restore

Display, save, or restore the current VM configuration. Note that saving and
restoring configuration applies to all VM configurations including KVM-based VM
configurations.

To display the current configuration, call vm config with no arguments.

List the current saved configurations with 'vm config restore'.

To save a configuration:

	vm config save <config name>

To restore a configuration:

	vm config restore <config name>

To clone the configuration of an existing VM:

	vm config clone <vm name>

Clone reparses the original network "vm config net". If the cloned VM was
configured with a static MAC, the VM config will not be launchable. Clone also
clears the UUID.

Calling clear vm config will clear all VM configuration options, but will not
remove saved configurations.
		'''
		# vm config restore <name>
		if name != None:
			return self._run("vm", "config", "restore", name)
	
		# vm config restore
		if True:
			return self._run("vm", "config", "restore")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_save(self,name,):
		'''
Variants:
	vm config save <name>

Display, save, or restore the current VM configuration. Note that saving and
restoring configuration applies to all VM configurations including KVM-based VM
configurations.

To display the current configuration, call vm config with no arguments.

List the current saved configurations with 'vm config restore'.

To save a configuration:

	vm config save <config name>

To restore a configuration:

	vm config restore <config name>

To clone the configuration of an existing VM:

	vm config clone <vm name>

Clone reparses the original network "vm config net". If the cloned VM was
configured with a static MAC, the VM config will not be launchable. Clone also
clears the UUID.

Calling clear vm config will clear all VM configuration options, but will not
remove saved configurations.
		'''
		# vm config save <name>
		if name != None:
			return self._run("vm", "config", "save", name)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_schedule(self,value=None,):
		'''
Variants:
	vm config schedule <value>
	vm config schedule

Set a host where the VM should be scheduled.

Note: Cannot specify Schedule and Colocate in the same config.
		'''
		# vm config schedule <value>
		if value != None:
			return self._run("vm", "config", "schedule", value)
	
		# vm config schedule
		if True:
			return self._run("vm", "config", "schedule")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_serial_ports(self,value=None,):
		'''
Variants:
	vm config serial-ports <value>
	vm config serial-ports

Specify the serial ports that will be created for the VM to use. Serial
ports specified will be mapped to the VM's /dev/ttySX device, where X
refers to the connected unix socket on the host at
$minimega_runtime/<vm_id>/serialX.

Examples:

To display current serial ports:
  vm config serial-ports

To create three serial ports:
  vm config serial-ports 3

Note: Whereas modern versions of Windows support up to 256 COM ports,
Linux typically only supports up to four serial devices. To use more,
make sure to pass "8250.n_uarts = 4" to the guest Linux kernel at boot.
Replace 4 with another number.
		'''
		# vm config serial-ports <value>
		if value != None:
			return self._run("vm", "config", "serial-ports", value)
	
		# vm config serial-ports
		if True:
			return self._run("vm", "config", "serial-ports")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_snapshot(self,true_or_false=None,):
		'''
Variants:
	vm config snapshot <true,false>
	vm config snapshot

Enable or disable snapshot mode for disk images and container
filesystems. When enabled, disks/filesystems will have temporary snapshots created
when run and changes will not be saved. This allows a single
disk/filesystem to be used for many VMs.

Default: true
		'''
		# vm config snapshot <true,false>
		if true_or_false != None:
			# Validate that choice was valid for true_or_false
			if true_or_false not in ["true","false",]:
				raise ValueError("invalid value for true_or_false")
			return self._run("vm", "config", "snapshot", true_or_false)
	
		# vm config snapshot
		if True:
			return self._run("vm", "config", "snapshot")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_sockets(self,value=None,):
		'''
Variants:
	vm config sockets <value>
	vm config sockets

Set the number of CPU sockets. If unspecified, QEMU will calculate
missing values based on vCPUs, cores, and threads.
		'''
		# vm config sockets <value>
		if value != None:
			return self._run("vm", "config", "sockets", value)
	
		# vm config sockets
		if True:
			return self._run("vm", "config", "sockets")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_tags(self,key=None,value=None,):
		'''
Variants:
	vm config tags <key> <value>
	vm config tags <key>
	vm config tags

Set tags in the same manner as "vm tag". These tags will apply to all
newly launched VMs.
		'''
		# vm config tags <key> <value>
		if key != None and value != None:
			return self._run("vm", "config", "tags", key, value)
	
		# vm config tags <key>
		if key != None:
			return self._run("vm", "config", "tags", key)
	
		# vm config tags
		if True:
			return self._run("vm", "config", "tags")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_threads(self,value=None,):
		'''
Variants:
	vm config threads <value>
	vm config threads

Set the number of CPU threads per core. If unspecified, QEMU will
calculate missing values based on vCPUs, sockets, and cores.
		'''
		# vm config threads <value>
		if value != None:
			return self._run("vm", "config", "threads", value)
	
		# vm config threads
		if True:
			return self._run("vm", "config", "threads")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_uuid(self,value=None,):
		'''
Variants:
	vm config uuid <value>
	vm config uuid

Configures the UUID for a virtual machine. If not set, the VM will be
given a random one when it is launched.
		'''
		# vm config uuid <value>
		if value != None:
			return self._run("vm", "config", "uuid", value)
	
		# vm config uuid
		if True:
			return self._run("vm", "config", "uuid")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_vcpus(self,value=None,):
		'''
Variants:
	vm config vcpus <value>
	vm config vcpus

Configures the number of virtual CPUs to allocate for a VM.

Default: 1
		'''
		# vm config vcpus <value>
		if value != None:
			return self._run("vm", "config", "vcpus", value)
	
		# vm config vcpus
		if True:
			return self._run("vm", "config", "vcpus")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_vga(self,value=None,):
		'''
Variants:
	vm config vga <value>
	vm config vga

Specify the graphics card to emulate. "cirrus" or "std" should work with
most operating systems.

Default: "std"
		'''
		# vm config vga <value>
		if value != None:
			return self._run("vm", "config", "vga", value)
	
		# vm config vga
		if True:
			return self._run("vm", "config", "vga")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_virtio_ports(self,value=None,):
		'''
Variants:
	vm config virtio-ports <value>
	vm config virtio-ports

Specify the virtio-serial ports that will be created for the VM to use.
Virtio-serial ports specified will be mapped to the VM's
/dev/virtio-port/<portname> device, where <portname> refers to the
connected unix socket on the host at
$minimega_runtime/<vm_id>/virtio-serialX.

Examples:

To display current virtio-serial ports:
  vm config virtio-ports

To create three virtio-serial ports:
  vm config virtio-ports 3

To explicitly name the virtio-ports, pass a comma-separated list of names:

  vm config virtio-ports foo,bar

The ports (on the guest) will then be mapped to /dev/virtio-port/foo and
/dev/virtio-port/bar.
		'''
		# vm config virtio-ports <value>
		if value != None:
			return self._run("vm", "config", "virtio-ports", value)
	
		# vm config virtio-ports
		if True:
			return self._run("vm", "config", "virtio-ports")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_config_volume(self,key=None,value=None,):
		'''
Variants:
	vm config volume <key> <value>
	vm config volume <key>
	vm config volume

Attach one or more volumes to a container. These directories will be
mounted inside the container at the specified location.

For example, to mount /scratch/data to /data inside the container:

 vm config volume /data /scratch/data

Commands with the same <key> will overwrite previous volumes:

 vm config volume /data /scratch/data2
 vm config volume /data
 /scratch/data2

Note: this configuration only applies to containers.
		'''
		# vm config volume <key> <value>
		if key != None and value != None:
			return self._run("vm", "config", "volume", key, value)
	
		# vm config volume <key>
		if key != None:
			return self._run("vm", "config", "volume", key)
	
		# vm config volume
		if True:
			return self._run("vm", "config", "volume")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_flush(self,vm=None,):
		'''
Variants:
	vm flush <vm target>
	vm flush

Flush one or more virtual machines. Discard information about VMs that
have either quit or encountered an error. This will remove VMs with a state of
"quit" or "error" from vm info. Names of VMs that have been flushed may be
reused.

Note running without arguments results in the same behavior as using the "all"
target. See "vm start" for a full description of allowable targets.
		'''
		# vm flush <vm target>
		if vm != None:
			return self._run("vm", "flush", vm)
	
		# vm flush
		if True:
			return self._run("vm", "flush")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_hotplug(self,):
		'''
Variants:
	vm hotplug

Add and remove USB drives to a launched VM.

To view currently attached media, call vm hotplug with the 'show' argument and
a VM name. To add a device, use the 'add' argument followed by the VM
name, and the name of the file to add. For example, to add foo.img to VM foo:

	vm hotplug add foo foo.img

The add command will assign a disk ID, shown in "vm hotplug". The optional
parameter allows you to specify whether the drive will appear on the 1.1 or 2.0
USB bus. For USB 1.1:

	vm hotplug add foo foo.img 1.1

For USB 2.0:

	vm hotplug add foo foo.img 2.0

To remove media, use the 'remove' argument with the VM name and the disk ID.
For example, to remove the drive added above, named 0:

	vm hotplug remove foo 0

To remove all hotplug devices, use ID "all" for the disk ID.

See "vm start" for a full description of allowable targets.
		'''
		# vm hotplug
		if True:
			return self._run("vm", "hotplug")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_hotplug_add(self,vm,filename,version=None,):
		'''
Variants:
	vm hotplug add <vm target> <filename> <version>
	vm hotplug add <vm target> <filename>

Add and remove USB drives to a launched VM.

To view currently attached media, call vm hotplug with the 'show' argument and
a VM name. To add a device, use the 'add' argument followed by the VM
name, and the name of the file to add. For example, to add foo.img to VM foo:

	vm hotplug add foo foo.img

The add command will assign a disk ID, shown in "vm hotplug". The optional
parameter allows you to specify whether the drive will appear on the 1.1 or 2.0
USB bus. For USB 1.1:

	vm hotplug add foo foo.img 1.1

For USB 2.0:

	vm hotplug add foo foo.img 2.0

To remove media, use the 'remove' argument with the VM name and the disk ID.
For example, to remove the drive added above, named 0:

	vm hotplug remove foo 0

To remove all hotplug devices, use ID "all" for the disk ID.

See "vm start" for a full description of allowable targets.
		'''
		# vm hotplug add <vm target> <filename> <version>
		if vm != None and filename != None and version != None:
			return self._run("vm", "hotplug", "add", vm, filename, version)
	
		# vm hotplug add <vm target> <filename>
		if vm != None and filename != None:
			return self._run("vm", "hotplug", "add", vm, filename)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_hotplug_add_serial(self,vm,filename,serial,version=None,):
		'''
Variants:
	vm hotplug add <vm target> <filename> serial <serial> <version>
	vm hotplug add <vm target> <filename> serial <serial>

Add and remove USB drives to a launched VM.

To view currently attached media, call vm hotplug with the 'show' argument and
a VM name. To add a device, use the 'add' argument followed by the VM
name, and the name of the file to add. For example, to add foo.img to VM foo:

	vm hotplug add foo foo.img

The add command will assign a disk ID, shown in "vm hotplug". The optional
parameter allows you to specify whether the drive will appear on the 1.1 or 2.0
USB bus. For USB 1.1:

	vm hotplug add foo foo.img 1.1

For USB 2.0:

	vm hotplug add foo foo.img 2.0

To remove media, use the 'remove' argument with the VM name and the disk ID.
For example, to remove the drive added above, named 0:

	vm hotplug remove foo 0

To remove all hotplug devices, use ID "all" for the disk ID.

See "vm start" for a full description of allowable targets.
		'''
		# vm hotplug add <vm target> <filename> serial <serial> <version>
		if vm != None and filename != None and serial != None and version != None:
			return self._run("vm", "hotplug", "add", vm, filename, "serial", serial, version)
	
		# vm hotplug add <vm target> <filename> serial <serial>
		if vm != None and filename != None and serial != None:
			return self._run("vm", "hotplug", "add", vm, filename, "serial", serial)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_hotplug_remove(self,vm,disk,):
		'''
Variants:
	vm hotplug remove <vm target> <disk id or all>

Add and remove USB drives to a launched VM.

To view currently attached media, call vm hotplug with the 'show' argument and
a VM name. To add a device, use the 'add' argument followed by the VM
name, and the name of the file to add. For example, to add foo.img to VM foo:

	vm hotplug add foo foo.img

The add command will assign a disk ID, shown in "vm hotplug". The optional
parameter allows you to specify whether the drive will appear on the 1.1 or 2.0
USB bus. For USB 1.1:

	vm hotplug add foo foo.img 1.1

For USB 2.0:

	vm hotplug add foo foo.img 2.0

To remove media, use the 'remove' argument with the VM name and the disk ID.
For example, to remove the drive added above, named 0:

	vm hotplug remove foo 0

To remove all hotplug devices, use ID "all" for the disk ID.

See "vm start" for a full description of allowable targets.
		'''
		# vm hotplug remove <vm target> <disk id or all>
		if vm != None and disk != None:
			return self._run("vm", "hotplug", "remove", vm, disk)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_info(self,summary=None,):
		'''
Variants:
	vm info <summary,>
	vm info

Print information about VMs in tabular form. The .filter and .columns commands
can be used to subselect a set of rows and/or columns. See the help pages for
.filter and .columns, respectively, for their usage. Columns returned by VM
info include:

- id*        : the VM ID, as an integer
- name*      : the VM name, if it exists
- state*     : one of (building, running, paused, quit, error)
- uptime     : amount of time since the VM was launched
- namespace* : namespace the VM belongs to
- type*      : one of (kvm, container)
- uuid*      : QEMU system uuid
- cc_active* : indicates whether cc is connected
- vcpus      : the number of allocated CPUs
- memory     : allocated memory, in megabytes
- vlan*      : vlan, as an integer
- bridge     : bridge name
- tap        : tap name
- mac        : mac address
- ip         : IPv4 address
- ip6        : IPv6 address
- bandwidth  : stats regarding bandwidth usage
- qos        : quality-of-service contraints on network interfaces
- tags       : any additional information attached to the VM

Additional fields are available for KVM-based VMs:

- append        : kernel command line string
- cdrom         : cdrom image
- disk          : disk image
- kernel        : kernel image
- initrd        : initrd image
- migrate       : qemu migration image
- pid           : pid of qemu process
- serial        : number of serial ports
- virtio-serial : number of virtio ports
- vnc_port      : port for VNC shim

Additional fields are available for container-based VMs:

- filesystem   : root filesystem for the container
- hostname     : hostname of the container
- init	       : process to invoke as init
- preinit      : process to invoke at container launch before isolation
- pid          : pid of container's init process
- fifo         : number of fifo devices
- console_port : port for console shim

The optional summary flag limits the columns to those denoted with a '*'.

Examples:

Display a list of all IPs for all VMs:
	.columns ip,ip6 vm info

Display information about all VMs:
	vm info
		'''
		# vm info <summary,>
		if summary != None:
			return self._run("vm", "info", summary)
	
		# vm info
		if True:
			return self._run("vm", "info")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_kill(self,vm,):
		'''
Variants:
	vm kill <vm target>

Kill one or more running virtual machines. See "vm start" for a full
description of allowable targets.
		'''
		# vm kill <vm target>
		if vm != None:
			return self._run("vm", "kill", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_launch(self,):
		'''
Variants:
	vm launch

Launch virtual machines in a paused state, using the parameters defined leading
up to the launch command. Any changes to the VM parameters after launching will
have no effect on launched VMs.

When you launch a VM, you supply the type of VM in the launch command. The
supported VM types are:

- kvm : QEMU-based vms
- container: Linux containers

If you supply a name instead of a number of VMs, one VM with that name will be
launched. You may also supply a range expression to launch VMs with a specific
naming scheme:

	vm launch kvm foo[0-9]

Note: VM names cannot be integers or reserved words (e.g. "all").

Users may specify a saved config explicity rather than use the current one, for
example:

	vm config save endpoint
	[other commands]
	vm launch kvm 5 endpoint

If queueing is enabled (see "ns"), VMs will be queued for launching until "vm
launch" is called with no additional arguments. This allows the scheduler to
better allocate resources across the cluster.
		'''
		# vm launch
		if True:
			return self._run("vm", "launch")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_launch_container(self,name,config=None,):
		'''
Variants:
	vm launch container <name or count> <config>
	vm launch container <name or count>

Launch virtual machines in a paused state, using the parameters defined leading
up to the launch command. Any changes to the VM parameters after launching will
have no effect on launched VMs.

When you launch a VM, you supply the type of VM in the launch command. The
supported VM types are:

- kvm : QEMU-based vms
- container: Linux containers

If you supply a name instead of a number of VMs, one VM with that name will be
launched. You may also supply a range expression to launch VMs with a specific
naming scheme:

	vm launch kvm foo[0-9]

Note: VM names cannot be integers or reserved words (e.g. "all").

Users may specify a saved config explicity rather than use the current one, for
example:

	vm config save endpoint
	[other commands]
	vm launch kvm 5 endpoint

If queueing is enabled (see "ns"), VMs will be queued for launching until "vm
launch" is called with no additional arguments. This allows the scheduler to
better allocate resources across the cluster.
		'''
		# vm launch container <name or count> <config>
		if name != None and config != None:
			return self._run("vm", "launch", "container", name, config)
	
		# vm launch container <name or count>
		if name != None:
			return self._run("vm", "launch", "container", name)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_launch_kvm(self,name,config=None,):
		'''
Variants:
	vm launch kvm <name or count> <config>
	vm launch kvm <name or count>

Launch virtual machines in a paused state, using the parameters defined leading
up to the launch command. Any changes to the VM parameters after launching will
have no effect on launched VMs.

When you launch a VM, you supply the type of VM in the launch command. The
supported VM types are:

- kvm : QEMU-based vms
- container: Linux containers

If you supply a name instead of a number of VMs, one VM with that name will be
launched. You may also supply a range expression to launch VMs with a specific
naming scheme:

	vm launch kvm foo[0-9]

Note: VM names cannot be integers or reserved words (e.g. "all").

Users may specify a saved config explicity rather than use the current one, for
example:

	vm config save endpoint
	[other commands]
	vm launch kvm 5 endpoint

If queueing is enabled (see "ns"), VMs will be queued for launching until "vm
launch" is called with no additional arguments. This allows the scheduler to
better allocate resources across the cluster.
		'''
		# vm launch kvm <name or count> <config>
		if name != None and config != None:
			return self._run("vm", "launch", "kvm", name, config)
	
		# vm launch kvm <name or count>
		if name != None:
			return self._run("vm", "launch", "kvm", name)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_migrate(self,vm=None,filename=None,):
		'''
Variants:
	vm migrate <vm name> <filename>
	vm migrate

Migrate runtime state of a VM to disk, which can later be booted with vm config
migrate.

Migration files are written to the files directory as specified with -filepath.
On success, a call to migrate a VM will return immediately. You can check the
status of in-flight migrations by invoking vm migrate with no arguments.
		'''
		# vm migrate <vm name> <filename>
		if vm != None and filename != None:
			return self._run("vm", "migrate", vm, filename)
	
		# vm migrate
		if True:
			return self._run("vm", "migrate")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_net_add(self,vm,netspec=None,):
		'''
Variants:
	vm net add <vm target> <netspec>...
	vm net add <vm target>

Add, disconnect, or move existing network connections for one or more VMs. See "vm
start" for a full description of allowable targets.

To add a network connection, you can specify the same options as you do when you add
connections via vm config when launching VMs. See "vm config net" for more details.

You will need to specify the VLAN of which the interface is a member. Optionally, you may
specify the brige the interface will be connected on. You may also specify a MAC address for
the interface. Finally, you may also specify the network device for qemu to use. By default, 
"e1000" is used. The order is:

	<bridge>,<VLAN>,<MAC>,<driver>

So to add an interface to a vm called vm-0 that is a member of VLAN 100, with a specified MAC
address, you can use:

	vm net add vm-0 100,00:00:00:00:00:00

Network connections are indicated by their position in vm net (same order in vm
info) and are zero indexed. For example, to disconnect the first network
connection from a VM named vm-0:

	vm net disconnect vm-0 0

To disconnect the second interface:

	vm net disconnect vm-0 1

To move a connection, specify the interface number, the new VLAN tag and
optional bridge:

	vm net vm-0 0 100 mega_bridge

If the bridge name is omitted, the interface will be reconnected to the same
bridge that it is already on. If the interface is not connected to a bridge, it
will be connected to the default bridge, "mega_bridge".
		'''
		# vm net add <vm target> <netspec>...
		if vm != None and netspec != None:
			return self._run("vm", "net", "add", vm, netspec)
	
		# vm net add <vm target>
		if vm != None:
			return self._run("vm", "net", "add", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_net_connect(self,vm,tap,vlan,bridge=None,):
		'''
Variants:
	vm net connect <vm target> <tap position> <vlan> <bridge>
	vm net connect <vm target> <tap position> <vlan>

Add, disconnect, or move existing network connections for one or more VMs. See "vm
start" for a full description of allowable targets.

To add a network connection, you can specify the same options as you do when you add
connections via vm config when launching VMs. See "vm config net" for more details.

You will need to specify the VLAN of which the interface is a member. Optionally, you may
specify the brige the interface will be connected on. You may also specify a MAC address for
the interface. Finally, you may also specify the network device for qemu to use. By default, 
"e1000" is used. The order is:

	<bridge>,<VLAN>,<MAC>,<driver>

So to add an interface to a vm called vm-0 that is a member of VLAN 100, with a specified MAC
address, you can use:

	vm net add vm-0 100,00:00:00:00:00:00

Network connections are indicated by their position in vm net (same order in vm
info) and are zero indexed. For example, to disconnect the first network
connection from a VM named vm-0:

	vm net disconnect vm-0 0

To disconnect the second interface:

	vm net disconnect vm-0 1

To move a connection, specify the interface number, the new VLAN tag and
optional bridge:

	vm net vm-0 0 100 mega_bridge

If the bridge name is omitted, the interface will be reconnected to the same
bridge that it is already on. If the interface is not connected to a bridge, it
will be connected to the default bridge, "mega_bridge".
		'''
		# vm net connect <vm target> <tap position> <vlan> <bridge>
		if vm != None and tap != None and vlan != None and bridge != None:
			return self._run("vm", "net", "connect", vm, tap, vlan, bridge)
	
		# vm net connect <vm target> <tap position> <vlan>
		if vm != None and tap != None and vlan != None:
			return self._run("vm", "net", "connect", vm, tap, vlan)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_net_disconnect(self,vm,tap,):
		'''
Variants:
	vm net disconnect <vm target> <tap position>

Add, disconnect, or move existing network connections for one or more VMs. See "vm
start" for a full description of allowable targets.

To add a network connection, you can specify the same options as you do when you add
connections via vm config when launching VMs. See "vm config net" for more details.

You will need to specify the VLAN of which the interface is a member. Optionally, you may
specify the brige the interface will be connected on. You may also specify a MAC address for
the interface. Finally, you may also specify the network device for qemu to use. By default, 
"e1000" is used. The order is:

	<bridge>,<VLAN>,<MAC>,<driver>

So to add an interface to a vm called vm-0 that is a member of VLAN 100, with a specified MAC
address, you can use:

	vm net add vm-0 100,00:00:00:00:00:00

Network connections are indicated by their position in vm net (same order in vm
info) and are zero indexed. For example, to disconnect the first network
connection from a VM named vm-0:

	vm net disconnect vm-0 0

To disconnect the second interface:

	vm net disconnect vm-0 1

To move a connection, specify the interface number, the new VLAN tag and
optional bridge:

	vm net vm-0 0 100 mega_bridge

If the bridge name is omitted, the interface will be reconnected to the same
bridge that it is already on. If the interface is not connected to a bridge, it
will be connected to the default bridge, "mega_bridge".
		'''
		# vm net disconnect <vm target> <tap position>
		if vm != None and tap != None:
			return self._run("vm", "net", "disconnect", vm, tap)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_qmp(self,vm,qmp,):
		'''
Variants:
	vm qmp <vm name> <qmp command>

Issue a JSON-encoded QMP command. This is a convenience function for accessing
the QMP socket of a VM via minimega. vm qmp takes two arguments, a VM name,
and a JSON string, and returns the JSON encoded response. For example:

	vm qmp 0 '{ "execute": "query-status" }'
	{"return":{"running":false,"singlestep":false,"status":"prelaunch"}}
		'''
		# vm qmp <vm name> <qmp command>
		if vm != None and qmp != None:
			return self._run("vm", "qmp", vm, qmp)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_screenshot(self,vm,maximum=None,):
		'''
Variants:
	vm screenshot <vm name> <maximum dimension>
	vm screenshot <vm name>

Take a screenshot of the framebuffer of a running VM. The screenshot is saved
in PNG format as "screenshot.png" in the VM's runtime directory (by default
/tmp/minimega/<vm id>/screenshot.png).

An optional argument sets the maximum dimensions in pixels, while keeping the
aspect ratio. For example, to set either maximum dimension of the output image
to 100 pixels:

	vm screenshot foo 100

The screenshot can be saved elsewhere like this:

        vm screenshot foo file /tmp/foo.png

You can also specify the maximum dimension:

        vm screenshot foo file /tmp/foo.png 100
		'''
		# vm screenshot <vm name> <maximum dimension>
		if vm != None and maximum != None:
			return self._run("vm", "screenshot", vm, maximum)
	
		# vm screenshot <vm name>
		if vm != None:
			return self._run("vm", "screenshot", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_screenshot_file(self,vm,filename,maximum=None,):
		'''
Variants:
	vm screenshot <vm name> file <filename> <maximum dimension>
	vm screenshot <vm name> file <filename>

Take a screenshot of the framebuffer of a running VM. The screenshot is saved
in PNG format as "screenshot.png" in the VM's runtime directory (by default
/tmp/minimega/<vm id>/screenshot.png).

An optional argument sets the maximum dimensions in pixels, while keeping the
aspect ratio. For example, to set either maximum dimension of the output image
to 100 pixels:

	vm screenshot foo 100

The screenshot can be saved elsewhere like this:

        vm screenshot foo file /tmp/foo.png

You can also specify the maximum dimension:

        vm screenshot foo file /tmp/foo.png 100
		'''
		# vm screenshot <vm name> file <filename> <maximum dimension>
		if vm != None and filename != None and maximum != None:
			return self._run("vm", "screenshot", vm, "file", filename, maximum)
	
		# vm screenshot <vm name> file <filename>
		if vm != None and filename != None:
			return self._run("vm", "screenshot", vm, "file", filename)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_start(self,vm,):
		'''
Variants:
	vm start <vm target>

Start one or more paused virtual machines. VMs may be selected by name, range, or
wildcard. For example,

To start vm foo:

		vm start foo

To start vms foo and bar:

		vm start foo,bar

To start vms foo0, foo1, foo2, and foo5:

		vm start foo[0-2,5]

There is also a wildcard (all) which allows the user to specify all VMs:

		vm start all

Note that including the wildcard in a list of VMs results in the wildcard
behavior (although a message will be logged).

Calling "vm start" on a specific list of VMs will cause them to be started if
they are in the building, paused, quit, or error states. When used with the
wildcard, only vms in the building or paused state will be started.
		'''
		# vm start <vm target>
		if vm != None:
			return self._run("vm", "start", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_stop(self,vm,):
		'''
Variants:
	vm stop <vm target>

Stop one or more running virtual machines. See "vm start" for a full
description of allowable targets.

Calling stop will put VMs in a paused state. Use "vm start" to restart them.
		'''
		# vm stop <vm target>
		if vm != None:
			return self._run("vm", "stop", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_tag(self,vm,key=None,value=None,):
		'''
Variants:
	vm tag <vm target> <key> <value>
	vm tag <vm target> <key or all>
	vm tag <vm target>

Display or set a tag for one or more virtual machines. See "vm start" for a
full description of allowable targets.

Tags are key-value pairs. A VM can have any number of tags associated with it.
They can be used to attach additional information to a virtual machine, for
example specifying a VM "group", or the correct rendering color for some
external visualization tool.

To set a tag "foo" to "bar" for VM 2:

        vm tag 2 foo bar

To read a tag:

        vm tag <vm target> <key or all>
		'''
		# vm tag <vm target> <key> <value>
		if vm != None and key != None and value != None:
			return self._run("vm", "tag", vm, key, value)
	
		# vm tag <vm target> <key or all>
		if vm != None and key != None:
			return self._run("vm", "tag", vm, key)
	
		# vm tag <vm target>
		if vm != None:
			return self._run("vm", "tag", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vm_top(self,duration=None,):
		'''
Variants:
	vm top <duration>
	vm top

View system resource utilization per VM. This is measured from the host and may
differ from what is reported by the guest.

The optional duration specifies the length of the sampling window in seconds.
The command will block for at least this long while it measures usage. The
default duration is one second.

Returned columns include:
- name      : name of the VM
- namespace : namespace of the VM (when not in a namespace)
- virt      : virtual memory size (MB)
- res       : resident memory size (MB)
- shr       : shared memory size (MB)
- cpu       : host CPU usage (%)
- vcpu      : guest CPU usage (%) (KVM only)
- time      : total CPU time
- procs     : number of processes inspected (limited to 100)
- rx        : total received data rate (MB/s)
- tx        : total transmitted data rate (MB/s)
		'''
		# vm top <duration>
		if duration != None:
			return self._run("vm", "top", duration)
	
		# vm top
		if True:
			return self._run("vm", "top")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vnc(self,):
		'''
Variants:
	vnc

List all running vnc playback/recording instances. See "help vnc" for more information.
		'''
		# vnc
		if True:
			return self._run("vnc")
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vnc_continue(self,vm,):
		'''
Variants:
	vnc continue <vm target>

Playback and interact with a previously recorded vnc kb session file.

If play is selected, the specified file (created using vnc record) will be read
and processed as a sequence of time-stamped mouse/keyboard events to send to
the specified VM(s). See "vm start" for a full description of the allowable
targets. VMs without a valid playback that are part of the target will return a
"kb playback not found" error.

Playbacks can be paused with the pause command, and resumed using continue. The
step command will immediately move to the next event contained in the playback
file. Use the getstep command to view the current vnc event. Calling stop will
end a playback.

VNC playback also supports injecting mouse/keyboard events in the format found
in the playback file. Injected commands must omit the time delta as they are
sent immediately:

	vnc inject vm-0 PointerEvent,0,465,245

New playback files can be injected as well:

	vnc inject vm-0 LoadFile,foo.kb

Comments in the playback file are logged at the info level. An example is given
below.

#: This is an example of a vnc playback comment
		'''
		# vnc continue <vm target>
		if vm != None:
			return self._run("vnc", "continue", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vnc_getstep(self,vm,):
		'''
Variants:
	vnc getstep <vm target>

Playback and interact with a previously recorded vnc kb session file.

If play is selected, the specified file (created using vnc record) will be read
and processed as a sequence of time-stamped mouse/keyboard events to send to
the specified VM(s). See "vm start" for a full description of the allowable
targets. VMs without a valid playback that are part of the target will return a
"kb playback not found" error.

Playbacks can be paused with the pause command, and resumed using continue. The
step command will immediately move to the next event contained in the playback
file. Use the getstep command to view the current vnc event. Calling stop will
end a playback.

VNC playback also supports injecting mouse/keyboard events in the format found
in the playback file. Injected commands must omit the time delta as they are
sent immediately:

	vnc inject vm-0 PointerEvent,0,465,245

New playback files can be injected as well:

	vnc inject vm-0 LoadFile,foo.kb

Comments in the playback file are logged at the info level. An example is given
below.

#: This is an example of a vnc playback comment
		'''
		# vnc getstep <vm target>
		if vm != None:
			return self._run("vnc", "getstep", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vnc_inject(self,vm,cmd,):
		'''
Variants:
	vnc inject <vm target> <cmd>

Playback and interact with a previously recorded vnc kb session file.

If play is selected, the specified file (created using vnc record) will be read
and processed as a sequence of time-stamped mouse/keyboard events to send to
the specified VM(s). See "vm start" for a full description of the allowable
targets. VMs without a valid playback that are part of the target will return a
"kb playback not found" error.

Playbacks can be paused with the pause command, and resumed using continue. The
step command will immediately move to the next event contained in the playback
file. Use the getstep command to view the current vnc event. Calling stop will
end a playback.

VNC playback also supports injecting mouse/keyboard events in the format found
in the playback file. Injected commands must omit the time delta as they are
sent immediately:

	vnc inject vm-0 PointerEvent,0,465,245

New playback files can be injected as well:

	vnc inject vm-0 LoadFile,foo.kb

Comments in the playback file are logged at the info level. An example is given
below.

#: This is an example of a vnc playback comment
		'''
		# vnc inject <vm target> <cmd>
		if vm != None and cmd != None:
			return self._run("vnc", "inject", vm, cmd)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vnc_pause(self,vm,):
		'''
Variants:
	vnc pause <vm target>

Playback and interact with a previously recorded vnc kb session file.

If play is selected, the specified file (created using vnc record) will be read
and processed as a sequence of time-stamped mouse/keyboard events to send to
the specified VM(s). See "vm start" for a full description of the allowable
targets. VMs without a valid playback that are part of the target will return a
"kb playback not found" error.

Playbacks can be paused with the pause command, and resumed using continue. The
step command will immediately move to the next event contained in the playback
file. Use the getstep command to view the current vnc event. Calling stop will
end a playback.

VNC playback also supports injecting mouse/keyboard events in the format found
in the playback file. Injected commands must omit the time delta as they are
sent immediately:

	vnc inject vm-0 PointerEvent,0,465,245

New playback files can be injected as well:

	vnc inject vm-0 LoadFile,foo.kb

Comments in the playback file are logged at the info level. An example is given
below.

#: This is an example of a vnc playback comment
		'''
		# vnc pause <vm target>
		if vm != None:
			return self._run("vnc", "pause", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vnc_play(self,vm,filename,):
		'''
Variants:
	vnc play <vm target> <filename>

Playback and interact with a previously recorded vnc kb session file.

If play is selected, the specified file (created using vnc record) will be read
and processed as a sequence of time-stamped mouse/keyboard events to send to
the specified VM(s). See "vm start" for a full description of the allowable
targets. VMs without a valid playback that are part of the target will return a
"kb playback not found" error.

Playbacks can be paused with the pause command, and resumed using continue. The
step command will immediately move to the next event contained in the playback
file. Use the getstep command to view the current vnc event. Calling stop will
end a playback.

VNC playback also supports injecting mouse/keyboard events in the format found
in the playback file. Injected commands must omit the time delta as they are
sent immediately:

	vnc inject vm-0 PointerEvent,0,465,245

New playback files can be injected as well:

	vnc inject vm-0 LoadFile,foo.kb

Comments in the playback file are logged at the info level. An example is given
below.

#: This is an example of a vnc playback comment
		'''
		# vnc play <vm target> <filename>
		if vm != None and filename != None:
			return self._run("vnc", "play", vm, filename)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vnc_record(self,kb_or_fb,vm,filename,):
		'''
Variants:
	vnc record <kb,fb> <vm name> <filename>

Record keyboard and mouse events sent via the web interface to the
selected VM. Can also record the framebuffer for the specified VM so that a
user can watch a video of interactions with the VM.

If record is selected, a file will be created containing a record of mouse
and keyboard actions by the user or of the framebuffer for the VM.

Note: recordings are written to the host where the VM is running.
		'''
		# vnc record <kb,fb> <vm name> <filename>
		if kb_or_fb != None and vm != None and filename != None:
			# Validate that choice was valid for kb_or_fb
			if kb_or_fb not in ["kb","fb",]:
				raise ValueError("invalid value for kb_or_fb")
			return self._run("vnc", "record", kb_or_fb, vm, filename)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vnc_step(self,vm,):
		'''
Variants:
	vnc step <vm target>

Playback and interact with a previously recorded vnc kb session file.

If play is selected, the specified file (created using vnc record) will be read
and processed as a sequence of time-stamped mouse/keyboard events to send to
the specified VM(s). See "vm start" for a full description of the allowable
targets. VMs without a valid playback that are part of the target will return a
"kb playback not found" error.

Playbacks can be paused with the pause command, and resumed using continue. The
step command will immediately move to the next event contained in the playback
file. Use the getstep command to view the current vnc event. Calling stop will
end a playback.

VNC playback also supports injecting mouse/keyboard events in the format found
in the playback file. Injected commands must omit the time delta as they are
sent immediately:

	vnc inject vm-0 PointerEvent,0,465,245

New playback files can be injected as well:

	vnc inject vm-0 LoadFile,foo.kb

Comments in the playback file are logged at the info level. An example is given
below.

#: This is an example of a vnc playback comment
		'''
		# vnc step <vm target>
		if vm != None:
			return self._run("vnc", "step", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def vnc_stop(self,vm,kb_or_fb=None,):
		'''
Variants:
	vnc stop <kb,fb> <vm name>
	vnc stop <vm target>

Record keyboard and mouse events sent via the web interface to the
selected VM. Can also record the framebuffer for the specified VM so that a
user can watch a video of interactions with the VM.

If record is selected, a file will be created containing a record of mouse
and keyboard actions by the user or of the framebuffer for the VM.

Note: recordings are written to the host where the VM is running.
		'''
		# vnc stop <kb,fb> <vm name>
		if kb_or_fb != None and vm != None:
			# Validate that choice was valid for kb_or_fb
			if kb_or_fb not in ["kb","fb",]:
				raise ValueError("invalid value for kb_or_fb")
			return self._run("vnc", "stop", kb_or_fb, vm)
	
		# vnc stop <vm target>
		if vm != None:
			return self._run("vnc", "stop", vm)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
	def write(self,file,):
		'''
Variants:
	write <file>

Write the command history to file. This is useful for handcrafting configs on
the minimega command line and then saving them for later use.
		'''
		# write <file>
		if file != None:
			return self._run("write", file)
	

		# didn't match any variant
		raise ValueError("invalid argument combination")
	
