"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractAsyncToJSON = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
/**
 * combines the potentially paginated response from async Textract calls and stores as one combines JSON.
 *
 * This construct is not memory optimzed (yet) and will combine all JSON by loading them to memory.
 * Large responses could exceed the memory potentially, the memory size is set to Lambda max.
 *
 * Reduce the memory size to your needs if your processing does not yield large responses to save Lamda cost.
 *
 *
 * Input: "textract_result"."TextractTempOutputJsonPath"
 * Output: "TextractOutputJsonPath"
 *
 * Example (Python)
 * ```python
    textract_async_to_json = tcdk.TextractAsyncToJSON(
        self,
        "TextractAsyncToJSON2",
        s3_output_prefix=s3_output_prefix,
        s3_output_bucket=s3_output_bucket)
  ```
 */
class TextractAsyncToJSON extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var lambdaLogLevel = props.lambdaLogLevel === undefined ? 'DEBUG' : props.lambdaLogLevel;
        var lambdaTimeout = props.lambdaTimeout === undefined ? 900 : props.lambdaTimeout;
        var lambdaMemoryMB = props.lambdaMemoryMB === undefined ? 10240 : props.lambdaMemoryMB;
        var textractAPI = props.textractAPI === undefined ? 'GENERIC' : props.textractAPI;
        const asyncToJSONFunction = new lambda.DockerImageFunction(this, 'TextractAsyncToJSON', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/async_to_json/')),
            memorySize: lambdaMemoryMB,
            architecture: lambda.Architecture.X86_64,
            environment: {
                S3_OUTPUT_BUCKET: props.s3OutputBucket,
                S3_OUTPUT_PREFIX: props.s3OutputPrefix,
                LOG_LEVEL: lambdaLogLevel,
                TEXTRACT_API: textractAPI,
            },
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
        });
        asyncToJSONFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['s3:Get*', 's3:List*', 's3:Put*'],
            resources: ['*'],
        }));
        const asyncToJSON = new tasks.LambdaInvoke(this, id, {
            lambdaFunction: asyncToJSONFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(900),
            outputPath: '$.Payload',
        });
        this.startState = asyncToJSON;
        this.endStates = [asyncToJSON];
    }
}
exports.TextractAsyncToJSON = TextractAsyncToJSON;
_a = JSII_RTTI_SYMBOL_1;
TextractAsyncToJSON[_a] = { fqn: "amazon-textract-idp-cdk-constructs.TextractAsyncToJSON", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,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