import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
export interface TextractAsyncToJSONProps {
    readonly s3OutputBucket: string;
    /** The prefix to use for the output files */
    readonly s3OutputPrefix: string;
    /** memory of Lambda function (may need to increase for larger documents), set to 10240 (max) atm, decrease for smaller workloads */
    readonly lambdaMemoryMB?: number;
    /** memory of Lambda function (may need to increase for larger documents) */
    readonly lambdaTimeout?: number;
    /** log level for Lambda function, supports DEBUG|INFO|WARNING|ERROR|FATAL */
    readonly lambdaLogLevel?: 'DEBUG' | 'INFO' | 'WARNING' | 'ERROR' | 'FATAL';
    /** Which Textract API was used to create the OutputConfig?
     * GENERIC and LENDING are supported.
     *
     * @default - GENERIC */
    readonly textractAPI?: 'GENERIC' | 'LENDING';
}
/**
 * combines the potentially paginated response from async Textract calls and stores as one combines JSON.
 *
 * This construct is not memory optimzed (yet) and will combine all JSON by loading them to memory.
 * Large responses could exceed the memory potentially, the memory size is set to Lambda max.
 *
 * Reduce the memory size to your needs if your processing does not yield large responses to save Lamda cost.
 *
 *
 * Input: "textract_result"."TextractTempOutputJsonPath"
 * Output: "TextractOutputJsonPath"
 *
 * Example (Python)
 * ```python
    textract_async_to_json = tcdk.TextractAsyncToJSON(
        self,
        "TextractAsyncToJSON2",
        s3_output_prefix=s3_output_prefix,
        s3_output_bucket=s3_output_bucket)
  ```
 */
export declare class TextractAsyncToJSON extends sfn.StateMachineFragment {
    readonly startState: sfn.State;
    readonly endStates: sfn.INextable[];
    constructor(parent: Construct, id: string, props: TextractAsyncToJSONProps);
}
