"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RDSAuroraServerless = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
//import * as ec2 from 'aws-cdk-lib/aws-ec2';
//import { ISecurityGroup, IVpc } from 'aws-cdk-lib/aws-ec2';
const ec2 = require("aws-cdk-lib/aws-ec2");
const rds = require("aws-cdk-lib/aws-rds");
const constructs_1 = require("constructs");
const rdsServerlessInit_1 = require("./rdsServerlessInit");
class RDSAuroraServerless extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.lambdaSecurityGroup = new ec2.SecurityGroup(this, 'LambdaSG', { allowAllOutbound: true, vpc: props.vpc });
        this.auroraSecurityGroup = new ec2.SecurityGroup(this, 'Aurora', { allowAllOutbound: true, vpc: props.vpc });
        this.auroraSecurityGroup.addIngressRule(this.auroraSecurityGroup, ec2.Port.tcp(5432), 'fromSameSG');
        this.auroraSecurityGroup.addIngressRule(this.auroraSecurityGroup, ec2.Port.tcp(443), 'fromSameSG');
        this.auroraSecurityGroup.addIngressRule(this.lambdaSecurityGroup, ec2.Port.tcp(5432), 'LambdaIngreess');
        this.auroraSecurityGroup.addIngressRule(this.lambdaSecurityGroup, ec2.Port.tcp(443), 'LambdaIngreess');
        // AURORA
        this.dbCluster = new rds.ServerlessCluster(this, id + 'AuroraPSQL', {
            engine: rds.DatabaseClusterEngine.AURORA_POSTGRESQL,
            parameterGroup: rds.ParameterGroup.fromParameterGroupName(this, 'ParameterGroup', 'default.aurora-postgresql10'),
            vpc: props.vpc,
            securityGroups: [this.auroraSecurityGroup],
            enableDataApi: true,
        });
        const rdsServerlessInit = new rdsServerlessInit_1.RdsServerlessInit(this, 'RdsServerlessInit', {
            dbClusterSecretARN: this.dbCluster.secret.secretArn,
            dbClusterARN: this.dbCluster.clusterArn,
        });
        rdsServerlessInit.node.addDependency(this.dbCluster);
    }
}
exports.RDSAuroraServerless = RDSAuroraServerless;
_a = JSII_RTTI_SYMBOL_1;
RDSAuroraServerless[_a] = { fqn: "amazon-textract-idp-cdk-constructs.RDSAuroraServerless", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,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