import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { ILogGroup } from 'aws-cdk-lib/aws-logs';
import * as sqs from 'aws-cdk-lib/aws-sqs';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
export declare function validatePatternSupported(integrationPattern: sfn.IntegrationPattern, supportedPatterns: sfn.IntegrationPattern[]): void;
export declare function integrationResourceArn(service: string, api: string, integrationPattern?: sfn.IntegrationPattern): string;
export interface ComprehendGenericSyncSfnTaskProps extends sfn.TaskStateBaseProps {
    readonly comprehendClassifierArn: string;
    readonly lambdaLogLevel?: 'DEBUG' | 'INFO' | 'WARNING' | 'ERROR' | 'FATAL';
    /** Lambda Function Timeout in seconds, default 300 */
    readonly lambdaTimeout?: number;
    /** Memory allocated to Lambda function, default 512 */
    readonly lambdaMemory?: number;
    readonly workflowTracingEnabled?: boolean;
    /** how long can we wait for the process (default is 48 hours (60*48=2880)) */
    readonly textractStateMachineTimeoutMinutes?: number;
    /**
         * The JSON input for the execution, same as that of StartExecution.
         *
         * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
         *
         * @default - The state input (JSON path '$')
         */
    readonly input?: sfn.TaskInput;
    /**
            * The name of the execution, same as that of StartExecution.
            *
            * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
            *
            * @default - None
            */
    readonly name?: string;
    /**
            * Pass the execution ID from the context object to the execution input.
            * This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.
            *
            * If you set this property to `true`, the `input` property must be an object (provided by `sfn.TaskInput.fromObject`) or omitted entirely.
            *
            * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid
            *
            * @default - false
            */
    readonly associateWithParent?: boolean;
}
/**
 * Calls a Comprehend Classification endpoint and parses the result, filters on > 50 % confidence and sets the highest confidence score classification
 *
 * Input: "textract_result"."txt_output_location"
 * Output:  { "documentType": "AWS_PAYSTUBS" } (example will be at "classification"."documentType")
 *
 * Example (Python)
 * ```python
    comprehend_sync_task = tcdk.ComprehendGenericSyncSfnTask(
        self,
        "Classification",
        comprehend_classifier_arn=
        '<your comprehend classifier arn>',
        integration_pattern=sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
        lambda_log_level="DEBUG",
        timeout=Duration.hours(24),
        input=sfn.TaskInput.from_object({
            "Token":
            sfn.JsonPath.task_token,
            "ExecutionId":
            sfn.JsonPath.string_at('$$.Execution.Id'),
            "Payload":
            sfn.JsonPath.entire_payload,
        }),
        result_path="$.classification")
    ```
 */
export declare class ComprehendGenericSyncSfnTask extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    stateMachine: sfn.IStateMachine;
    putOnSQSLambdaLogGroup: ILogGroup;
    comprehendSyncLambdaLogGroup: ILogGroup;
    comprehendSyncSQS: sqs.IQueue;
    version: string;
    comprehendSyncCallFunction: lambda.IFunction;
    textractPutOnSQSFunction: lambda.IFunction;
    constructor(scope: Construct, id: string, props: ComprehendGenericSyncSfnTaskProps);
    /**
         * @internal
         */
    protected _renderTask(): any;
    /**
         * As StateMachineArn is extracted automatically from the state machine object included in the constructor,
         *
         * the scoped access policy should be generated accordingly.
         *
         * This means the action of StartExecution should be restricted on the given state machine, instead of being granted to all the resources (*).
         */
    private createScopedAccessPolicy;
}
