"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractConfiguration = void 0;
const path = require("path");
const cdk = require("aws-cdk-lib");
//import * as dynamodb from 'aws-cdk-lib/aws-dynamodb';
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const customResources = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * CloudFormation Custom Resources importing default configuration values from default_config.csv
 * into DynamoDB table.
 * Used by the Configuration Construct to configure Textrat features.
 * The DynamoDB table can be configured to your requirements.
 * The configuration has to match the manifest format.
 * Essentially the Configuration construct looks up the classification
 * and if a match is found in the DynamoDB table, configures the context
 * manifest object to include the configuration.
 *
 */
class TextractConfiguration extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.configurationInitFunction === undefined) {
            this.configurationInitFunction = new lambda.DockerImageFunction(this, id, {
                code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/cfn_custom_configurator_prefill/')),
                architecture: lambda.Architecture.X86_64,
                memorySize: 128,
                timeout: cdk.Duration.seconds(600),
                environment: {
                    LOG_LEVEL: 'DEBUG',
                    CONFIGURATION_TABLE: props.configuration_table,
                },
            });
        }
        else {
            this.configurationInitFunction = props.configurationInitFunction;
        }
        this.configurationInitFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['dynamodb:PutItem', 'dynamodb:GetItem'],
            resources: ['*'],
        }));
        const provider = new customResources.Provider(this, 'Provider', {
            onEventHandler: this.configurationInitFunction,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: props,
        });
        this.response = resource.getAtt('Response').toString();
    }
}
exports.TextractConfiguration = TextractConfiguration;
//# sourceMappingURL=data:application/json;base64,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