"""Mapping of GBD risk factors.

This code is automatically generated by gbd_mapping_generator/risk_builder.py

Any manual changes will be lost.
"""
from .base_template import Categories, Restrictions, Tmred
from .cause import causes
from .id import rei_id, scalar
from .risk_factor_template import RiskFactor, RiskFactors

risk_factors = RiskFactors(
    unsafe_water_sanitation_and_handwashing=RiskFactor(
        name='unsafe_water_sanitation_and_handwashing',
        kind='risk_factor',
        gbd_id=rei_id(82),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    unsafe_water_source=RiskFactor(
        name='unsafe_water_source',
        kind='risk_factor',
        gbd_id=rei_id(83),
        level=3,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.enteric_infections, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Unsafe water source, Unimproved & untreated',
            cat2='Unsafe water source, Unimproved & chlorinated',
            cat3='Unsafe water source, Unimproved & filtered',
            cat4='Unsafe water source, Improved & untreated',
            cat5='Unsafe water source, Improved & chlorinated',
            cat6='Unsafe water source, Improved & filtered',
            cat7='Unsafe water source, Piped & untreated',
            cat8='Unsafe water source, Piped & chlorinated',
            cat9='Unsafe water source, Piped & filtered',
            cat10='Unsafe water source, High quality piped & untreated',
            cat11='Unsafe water source, High quality piped & chlorinated',
            cat12='Unexposed',
        ),
    ),
    unsafe_sanitation=RiskFactor(
        name='unsafe_sanitation',
        kind='risk_factor',
        gbd_id=rei_id(84),
        level=3,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.enteric_infections, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Unsafe sanitation, Unimproved & untreated',
            cat2='Unsafe sanitation, Improved',
            cat3='Unexposed',
        ),
    ),
    air_pollution=RiskFactor(
        name='air_pollution',
        kind='risk_factor',
        gbd_id=rei_id(85),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.upper_respiratory_infections, causes.otitis_media, causes.meningitis, 
                         causes.encephalitis, causes.neonatal_disorders, causes.neonatal_preterm_birth, 
                         causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                         causes.neonatal_sepsis_and_other_neonatal_infections, 
                         causes.hemolytic_disease_and_other_neonatal_jaundice, causes.other_neonatal_disorders, 
                         causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.chronic_respiratory_diseases, causes.chronic_obstructive_pulmonary_disease, 
                         causes.asthma, causes.diabetes_mellitus, causes.other_non_communicable_diseases, 
                         causes.sense_organ_diseases, causes.cataract, causes.sudden_infant_death_syndrome, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, 
                         causes.other_infectious_diseases, causes.maternal_and_neonatal_disorders, 
                         causes.diabetes_and_kidney_diseases, causes.diabetes_mellitus_type_2, 
                         causes.blindness_and_vision_loss, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    ambient_particulate_matter_pollution=RiskFactor(
        name='ambient_particulate_matter_pollution',
        kind='risk_factor',
        gbd_id=rei_id(86),
        level=4,
        most_detailed=True,
        distribution='custom',
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.upper_respiratory_infections, causes.otitis_media, causes.meningitis, 
                         causes.encephalitis, causes.neonatal_disorders, causes.neonatal_preterm_birth, 
                         causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                         causes.neonatal_sepsis_and_other_neonatal_infections, 
                         causes.hemolytic_disease_and_other_neonatal_jaundice, causes.other_neonatal_disorders, 
                         causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.chronic_respiratory_diseases, causes.chronic_obstructive_pulmonary_disease, 
                         causes.diabetes_mellitus, causes.other_non_communicable_diseases, 
                         causes.sudden_infant_death_syndrome, causes.respiratory_infections_and_tuberculosis, 
                         causes.enteric_infections, causes.other_infectious_diseases, 
                         causes.maternal_and_neonatal_disorders, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    household_air_pollution_from_solid_fuels=RiskFactor(
        name='household_air_pollution_from_solid_fuels',
        kind='risk_factor',
        gbd_id=rei_id(87),
        level=4,
        most_detailed=True,
        distribution='dichotomous',
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.upper_respiratory_infections, causes.otitis_media, causes.meningitis, 
                         causes.encephalitis, causes.neonatal_disorders, causes.neonatal_preterm_birth, 
                         causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                         causes.neonatal_sepsis_and_other_neonatal_infections, 
                         causes.hemolytic_disease_and_other_neonatal_jaundice, causes.other_neonatal_disorders, 
                         causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.chronic_respiratory_diseases, causes.chronic_obstructive_pulmonary_disease, 
                         causes.diabetes_mellitus, causes.other_non_communicable_diseases, 
                         causes.sense_organ_diseases, causes.cataract, causes.sudden_infant_death_syndrome, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, 
                         causes.other_infectious_diseases, causes.maternal_and_neonatal_disorders, 
                         causes.diabetes_and_kidney_diseases, causes.diabetes_mellitus_type_2, 
                         causes.blindness_and_vision_loss, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Exposed',
            cat2='Unexposed',
        ),
    ),
    ambient_ozone_pollution=RiskFactor(
        name='ambient_ozone_pollution',
        kind='risk_factor',
        gbd_id=rei_id(88),
        level=3,
        most_detailed=True,
        distribution='custom',
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=True,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.chronic_respiratory_diseases, 
                         causes.chronic_obstructive_pulmonary_disease, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(30),
            max=scalar(50),
            inverted=True,
        ),
        relative_risk_scalar=scalar(1),
    ),
    other_environmental_risks=RiskFactor(
        name='other_environmental_risks',
        kind='risk_factor',
        gbd_id=rei_id(89),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.atrial_fibrillation_and_flutter, 
                         causes.aortic_aneurysm, causes.lower_extremity_peripheral_arterial_disease, 
                         causes.mental_disorders, causes.idiopathic_developmental_intellectual_disability, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.diabetes_and_kidney_diseases, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    residential_radon=RiskFactor(
        name='residential_radon',
        kind='risk_factor',
        gbd_id=rei_id(90),
        level=3,
        most_detailed=True,
        distribution='lognormal',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=7.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(0),
            max=scalar(0),
            inverted=False,
        ),
        relative_risk_scalar=scalar(1),
    ),
    lead_exposure=RiskFactor(
        name='lead_exposure',
        kind='risk_factor',
        gbd_id=rei_id(91),
        level=3,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.atrial_fibrillation_and_flutter, 
                         causes.aortic_aneurysm, causes.lower_extremity_peripheral_arterial_disease, 
                         causes.mental_disorders, causes.idiopathic_developmental_intellectual_disability, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.diabetes_and_kidney_diseases, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    child_and_maternal_malnutrition=RiskFactor(
        name='child_and_maternal_malnutrition',
        kind='risk_factor',
        gbd_id=rei_id(92),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.upper_respiratory_infections, causes.otitis_media, causes.meningitis, 
                         causes.encephalitis, causes.measles, causes.neglected_tropical_diseases_and_malaria, 
                         causes.malaria, causes.maternal_disorders, causes.maternal_hemorrhage, 
                         causes.maternal_sepsis_and_other_maternal_infections, 
                         causes.maternal_hypertensive_disorders, 
                         causes.maternal_obstructed_labor_and_uterine_rupture, causes.ectopic_pregnancy, 
                         causes.indirect_maternal_deaths, causes.late_maternal_deaths, 
                         causes.other_direct_maternal_disorders, causes.neonatal_disorders, 
                         causes.neonatal_preterm_birth, 
                         causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                         causes.neonatal_sepsis_and_other_neonatal_infections, 
                         causes.hemolytic_disease_and_other_neonatal_jaundice, causes.other_neonatal_disorders, 
                         causes.nutritional_deficiencies, causes.protein_energy_malnutrition, 
                         causes.vitamin_a_deficiency, causes.dietary_iron_deficiency, 
                         causes.non_communicable_diseases, causes.other_non_communicable_diseases, 
                         causes.sudden_infant_death_syndrome, causes.maternal_deaths_aggravated_by_hiv_aids, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, 
                         causes.other_infectious_diseases, causes.maternal_and_neonatal_disorders, 
                         causes.maternal_abortion_and_miscarriage, ),
        population_attributable_fraction_of_one_causes=(causes.neonatal_preterm_birth, 
                                                        causes.protein_energy_malnutrition, 
                                                        causes.vitamin_a_deficiency, causes.dietary_iron_deficiency, ),
    ),
    suboptimal_breastfeeding=RiskFactor(
        name='suboptimal_breastfeeding',
        kind='risk_factor',
        gbd_id=rei_id(93),
        level=3,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=3.0,
            yll_age_group_id_end=34.0,
            yld_age_group_id_start=3.0,
            yld_age_group_id_end=34.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    child_underweight=RiskFactor(
        name='child_underweight',
        kind='risk_factor',
        gbd_id=rei_id(94),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=388.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, causes.measles, 
                         causes.neglected_tropical_diseases_and_malaria, causes.malaria, 
                         causes.nutritional_deficiencies, causes.protein_energy_malnutrition, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, 
                         causes.other_infectious_diseases, ),
        population_attributable_fraction_of_one_causes=(causes.protein_energy_malnutrition, ),
        categories=Categories(
            cat1='Severe Underweight, < -3 SD (post-ensemble)',
            cat2='Underweight Between -3 SD and -2 SD (post-ensemble)',
            cat3='Underweight Between -2 SD and -1 SD (post-ensemble)',
            cat4='Unexposed',
        ),
    ),
    iron_deficiency=RiskFactor(
        name='iron_deficiency',
        kind='risk_factor',
        gbd_id=rei_id(95),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7.0,
            yll_age_group_id_end=15.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.maternal_disorders, causes.maternal_hemorrhage, 
                         causes.maternal_sepsis_and_other_maternal_infections, 
                         causes.maternal_hypertensive_disorders, 
                         causes.maternal_obstructed_labor_and_uterine_rupture, causes.ectopic_pregnancy, 
                         causes.indirect_maternal_deaths, causes.late_maternal_deaths, 
                         causes.other_direct_maternal_disorders, causes.nutritional_deficiencies, 
                         causes.dietary_iron_deficiency, causes.maternal_deaths_aggravated_by_hiv_aids, 
                         causes.maternal_and_neonatal_disorders, causes.maternal_abortion_and_miscarriage, ),
        population_attributable_fraction_of_one_causes=(causes.dietary_iron_deficiency, ),
        tmred=Tmred(
            distribution='draws',
            inverted=True,
        ),
        relative_risk_scalar=scalar(10),
    ),
    vitamin_a_deficiency=RiskFactor(
        name='vitamin_a_deficiency',
        kind='risk_factor',
        gbd_id=rei_id(96),
        level=3,
        most_detailed=True,
        distribution='dichotomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=388.0,
            yll_age_group_id_end=34.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.measles, causes.nutritional_deficiencies, 
                         causes.vitamin_a_deficiency, causes.enteric_infections, causes.other_infectious_diseases, ),
        population_attributable_fraction_of_one_causes=(causes.vitamin_a_deficiency, ),
        categories=Categories(
            cat1='Exposed',
            cat2='Unexposed',
        ),
    ),
    zinc_deficiency=RiskFactor(
        name='zinc_deficiency',
        kind='risk_factor',
        gbd_id=rei_id(97),
        level=3,
        most_detailed=True,
        distribution='dichotomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=238.0,
            yll_age_group_id_end=34.0,
            yld_age_group_id_start=238.0,
            yld_age_group_id_end=34.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.enteric_infections, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Exposed',
            cat2='Unexposed',
        ),
    ),
    tobacco=RiskFactor(
        name='tobacco',
        kind='risk_factor',
        gbd_id=rei_id(98),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.lower_respiratory_infections, causes.otitis_media, 
                         causes.non_communicable_diseases, causes.neoplasms, causes.esophageal_cancer, 
                         causes.stomach_cancer, causes.liver_cancer, causes.liver_cancer_due_to_hepatitis_b, 
                         causes.liver_cancer_due_to_hepatitis_c, causes.liver_cancer_due_to_alcohol_use, 
                         causes.liver_cancer_due_to_other_causes, causes.larynx_cancer, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.breast_cancer, causes.cervical_cancer, 
                         causes.prostate_cancer, causes.colon_and_rectum_cancer, causes.lip_and_oral_cavity_cancer, 
                         causes.nasopharynx_cancer, causes.other_pharynx_cancer, causes.pancreatic_cancer, 
                         causes.kidney_cancer, causes.bladder_cancer, causes.leukemia, 
                         causes.cardiovascular_diseases, causes.ischemic_heart_disease, causes.stroke, 
                         causes.ischemic_stroke, causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.atrial_fibrillation_and_flutter, causes.aortic_aneurysm, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.chronic_respiratory_diseases, 
                         causes.chronic_obstructive_pulmonary_disease, causes.asthma, causes.digestive_diseases, 
                         causes.peptic_ulcer_disease, causes.gallbladder_and_biliary_diseases, 
                         causes.neurological_disorders, causes.alzheimers_disease_and_other_dementias, 
                         causes.parkinsons_disease, causes.multiple_sclerosis, causes.diabetes_mellitus, 
                         causes.musculoskeletal_disorders, causes.rheumatoid_arthritis, causes.low_back_pain, 
                         causes.sense_organ_diseases, causes.cataract, causes.age_related_macular_degeneration, 
                         causes.injuries, causes.transport_injuries, causes.road_injuries, 
                         causes.pedestrian_road_injuries, causes.cyclist_road_injuries, 
                         causes.motorcyclist_road_injuries, causes.motor_vehicle_road_injuries, 
                         causes.other_road_injuries, causes.other_transport_injuries, causes.unintentional_injuries, 
                         causes.falls, causes.exposure_to_mechanical_forces, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.non_venomous_animal_contact, causes.self_harm_and_interpersonal_violence, 
                         causes.interpersonal_violence, causes.physical_violence_by_other_means, 
                         causes.acute_lymphoid_leukemia, causes.chronic_lymphoid_leukemia, 
                         causes.acute_myeloid_leukemia, causes.chronic_myeloid_leukemia, 
                         causes.drug_susceptible_tuberculosis, causes.other_leukemia, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, causes.latent_tuberculosis_infection, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, causes.blindness_and_vision_loss, 
                         causes.upper_digestive_system_diseases, causes.liver_cancer_due_to_nash, 
                         causes.total_burden_related_to_hepatitis_b, causes.total_burden_related_to_hepatitis_c, 
                         causes.total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld, 
                         causes.total_cancers, causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    smoking=RiskFactor(
        name='smoking',
        kind='risk_factor',
        gbd_id=rei_id(99),
        level=3,
        most_detailed=True,
        distribution='custom',
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=11.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=11.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.lower_respiratory_infections, causes.non_communicable_diseases, 
                         causes.neoplasms, causes.esophageal_cancer, causes.stomach_cancer, causes.liver_cancer, 
                         causes.liver_cancer_due_to_hepatitis_b, causes.liver_cancer_due_to_hepatitis_c, 
                         causes.liver_cancer_due_to_alcohol_use, causes.liver_cancer_due_to_other_causes, 
                         causes.larynx_cancer, causes.tracheal_bronchus_and_lung_cancer, causes.breast_cancer, 
                         causes.cervical_cancer, causes.prostate_cancer, causes.colon_and_rectum_cancer, 
                         causes.lip_and_oral_cavity_cancer, causes.nasopharynx_cancer, causes.other_pharynx_cancer, 
                         causes.pancreatic_cancer, causes.kidney_cancer, causes.bladder_cancer, causes.leukemia, 
                         causes.cardiovascular_diseases, causes.ischemic_heart_disease, causes.stroke, 
                         causes.ischemic_stroke, causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.atrial_fibrillation_and_flutter, causes.aortic_aneurysm, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.chronic_respiratory_diseases, 
                         causes.chronic_obstructive_pulmonary_disease, causes.asthma, causes.digestive_diseases, 
                         causes.peptic_ulcer_disease, causes.gallbladder_and_biliary_diseases, 
                         causes.neurological_disorders, causes.alzheimers_disease_and_other_dementias, 
                         causes.parkinsons_disease, causes.multiple_sclerosis, causes.diabetes_mellitus, 
                         causes.musculoskeletal_disorders, causes.rheumatoid_arthritis, causes.low_back_pain, 
                         causes.sense_organ_diseases, causes.cataract, causes.age_related_macular_degeneration, 
                         causes.injuries, causes.transport_injuries, causes.road_injuries, 
                         causes.pedestrian_road_injuries, causes.cyclist_road_injuries, 
                         causes.motorcyclist_road_injuries, causes.motor_vehicle_road_injuries, 
                         causes.other_road_injuries, causes.other_transport_injuries, causes.unintentional_injuries, 
                         causes.falls, causes.exposure_to_mechanical_forces, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.non_venomous_animal_contact, causes.self_harm_and_interpersonal_violence, 
                         causes.interpersonal_violence, causes.physical_violence_by_other_means, 
                         causes.acute_lymphoid_leukemia, causes.chronic_lymphoid_leukemia, 
                         causes.acute_myeloid_leukemia, causes.chronic_myeloid_leukemia, 
                         causes.drug_susceptible_tuberculosis, causes.other_leukemia, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, causes.latent_tuberculosis_infection, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, causes.blindness_and_vision_loss, 
                         causes.upper_digestive_system_diseases, causes.liver_cancer_due_to_nash, 
                         causes.total_burden_related_to_hepatitis_b, causes.total_burden_related_to_hepatitis_c, 
                         causes.total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld, 
                         causes.total_cancers, causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Prevalence of Current Any Smokers',
            cat2='Prevalence of Former Any Smokers',
        ),
        relative_risk_scalar=scalar(1),
    ),
    secondhand_smoke=RiskFactor(
        name='secondhand_smoke',
        kind='risk_factor',
        gbd_id=rei_id(100),
        level=3,
        most_detailed=True,
        distribution='dichotomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.lower_respiratory_infections, causes.otitis_media, causes.non_communicable_diseases, 
                         causes.neoplasms, causes.tracheal_bronchus_and_lung_cancer, causes.breast_cancer, 
                         causes.cardiovascular_diseases, causes.ischemic_heart_disease, causes.stroke, 
                         causes.ischemic_stroke, causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.chronic_respiratory_diseases, causes.chronic_obstructive_pulmonary_disease, 
                         causes.diabetes_mellitus, causes.respiratory_infections_and_tuberculosis, 
                         causes.diabetes_and_kidney_diseases, causes.diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Exposed',
            cat2='Unexposed',
        ),
    ),
    high_alcohol_use=RiskFactor(
        name='high_alcohol_use',
        kind='risk_factor',
        gbd_id=rei_id(102),
        level=2,
        most_detailed=True,
        distribution='custom',
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.esophageal_cancer, causes.liver_cancer, causes.liver_cancer_due_to_hepatitis_b, 
                         causes.liver_cancer_due_to_hepatitis_c, causes.liver_cancer_due_to_alcohol_use, 
                         causes.liver_cancer_due_to_other_causes, causes.larynx_cancer, causes.breast_cancer, 
                         causes.colon_and_rectum_cancer, causes.lip_and_oral_cavity_cancer, 
                         causes.nasopharynx_cancer, causes.other_pharynx_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.hypertensive_heart_disease, 
                         causes.cardiomyopathy_and_myocarditis, causes.atrial_fibrillation_and_flutter, 
                         causes.cirrhosis_and_other_chronic_liver_diseases, 
                         causes.chronic_hepatitis_b_including_cirrhosis, 
                         causes.chronic_hepatitis_c_including_cirrhosis, causes.cirrhosis_due_to_alcohol, 
                         causes.cirrhosis_due_to_other_causes, causes.digestive_diseases, causes.pancreatitis, 
                         causes.neurological_disorders, causes.idiopathic_epilepsy, causes.alcohol_use_disorders, 
                         causes.diabetes_mellitus, causes.injuries, causes.transport_injuries, causes.road_injuries, 
                         causes.pedestrian_road_injuries, causes.cyclist_road_injuries, 
                         causes.motorcyclist_road_injuries, causes.motor_vehicle_road_injuries, 
                         causes.other_road_injuries, causes.other_transport_injuries, causes.unintentional_injuries, 
                         causes.falls, causes.drowning, causes.fire_heat_and_hot_substances, causes.poisonings, 
                         causes.poisoning_by_carbon_monoxide, causes.poisoning_by_other_means, 
                         causes.exposure_to_mechanical_forces, causes.unintentional_firearm_injuries, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.venomous_animal_contact, causes.non_venomous_animal_contact, 
                         causes.other_unintentional_injuries_internal, causes.self_harm_and_interpersonal_violence, 
                         causes.self_harm, causes.self_harm_by_firearm, causes.self_harm_by_other_specified_means, 
                         causes.interpersonal_violence, causes.physical_violence_by_firearm, 
                         causes.physical_violence_by_sharp_object, causes.physical_violence_by_other_means, 
                         causes.environmental_heat_and_cold_exposure, causes.drug_susceptible_tuberculosis, 
                         causes.alcoholic_cardiomyopathy, causes.sexual_violence, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, causes.latent_tuberculosis_infection, 
                         causes.respiratory_infections_and_tuberculosis, 
                         causes.nonalcoholic_fatty_liver_disease_including_cirrhosis, causes.substance_use_disorders, 
                         causes.diabetes_and_kidney_diseases, causes.diabetes_mellitus_type_2, 
                         causes.liver_cancer_due_to_nash, causes.total_burden_related_to_hepatitis_b, 
                         causes.total_burden_related_to_hepatitis_c, 
                         causes.total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld, 
                         causes.total_cancers, causes.other_unintentional_injuries, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.liver_cancer_due_to_alcohol_use, 
                                                        causes.cirrhosis_due_to_alcohol, 
                                                        causes.alcohol_use_disorders, 
                                                        causes.alcoholic_cardiomyopathy, ),
    ),
    drug_use=RiskFactor(
        name='drug_use',
        kind='risk_factor',
        gbd_id=rei_id(103),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=7.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.hiv_aids, causes.hiv_aids_resulting_in_other_diseases, causes.acute_hepatitis, 
                         causes.acute_hepatitis_b, causes.acute_hepatitis_c, causes.non_communicable_diseases, 
                         causes.neoplasms, causes.liver_cancer, causes.liver_cancer_due_to_hepatitis_b, 
                         causes.liver_cancer_due_to_hepatitis_c, causes.cirrhosis_and_other_chronic_liver_diseases, 
                         causes.chronic_hepatitis_b_including_cirrhosis, 
                         causes.chronic_hepatitis_c_including_cirrhosis, causes.digestive_diseases, 
                         causes.drug_use_disorders, causes.opioid_use_disorders, causes.cocaine_use_disorders, 
                         causes.amphetamine_use_disorders, causes.cannabis_use_disorders, 
                         causes.other_drug_use_disorders, causes.injuries, 
                         causes.self_harm_and_interpersonal_violence, causes.self_harm, causes.self_harm_by_firearm, 
                         causes.self_harm_by_other_specified_means, causes.hiv_aids_drug_susceptible_tuberculosis, 
                         causes.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.hiv_aids_extensively_drug_resistant_tuberculosis, 
                         causes.hiv_aids_and_sexually_transmitted_infections, causes.other_infectious_diseases, 
                         causes.substance_use_disorders, causes.total_burden_related_to_hepatitis_b, 
                         causes.total_burden_related_to_hepatitis_c, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.drug_use_disorders, causes.opioid_use_disorders, 
                                                        causes.cocaine_use_disorders, 
                                                        causes.amphetamine_use_disorders, 
                                                        causes.cannabis_use_disorders, 
                                                        causes.other_drug_use_disorders, ),
    ),
    metabolic_risks=RiskFactor(
        name='metabolic_risks',
        kind='risk_factor',
        gbd_id=rei_id(104),
        level=1,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.liver_cancer, causes.liver_cancer_due_to_hepatitis_b, 
                         causes.liver_cancer_due_to_hepatitis_c, causes.liver_cancer_due_to_alcohol_use, 
                         causes.liver_cancer_due_to_other_causes, causes.tracheal_bronchus_and_lung_cancer, 
                         causes.breast_cancer, causes.uterine_cancer, causes.colon_and_rectum_cancer, 
                         causes.gallbladder_and_biliary_tract_cancer, causes.pancreatic_cancer, 
                         causes.ovarian_cancer, causes.kidney_cancer, causes.bladder_cancer, causes.thyroid_cancer, 
                         causes.non_hodgkin_lymphoma, causes.multiple_myeloma, causes.leukemia, 
                         causes.cardiovascular_diseases, causes.ischemic_heart_disease, causes.stroke, 
                         causes.ischemic_stroke, causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.atrial_fibrillation_and_flutter, 
                         causes.aortic_aneurysm, causes.lower_extremity_peripheral_arterial_disease, 
                         causes.chronic_respiratory_diseases, causes.asthma, causes.digestive_diseases, 
                         causes.gallbladder_and_biliary_diseases, causes.neurological_disorders, 
                         causes.alzheimers_disease_and_other_dementias, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.musculoskeletal_disorders, causes.osteoarthritis, causes.low_back_pain, causes.gout, 
                         causes.sense_organ_diseases, causes.glaucoma, causes.cataract, causes.injuries, 
                         causes.transport_injuries, causes.road_injuries, causes.pedestrian_road_injuries, 
                         causes.cyclist_road_injuries, causes.motorcyclist_road_injuries, 
                         causes.motor_vehicle_road_injuries, causes.other_road_injuries, 
                         causes.other_transport_injuries, causes.unintentional_injuries, causes.falls, 
                         causes.exposure_to_mechanical_forces, causes.other_exposure_to_mechanical_forces, 
                         causes.animal_contact, causes.non_venomous_animal_contact, 
                         causes.self_harm_and_interpersonal_violence, causes.interpersonal_violence, 
                         causes.physical_violence_by_other_means, causes.acute_lymphoid_leukemia, 
                         causes.chronic_lymphoid_leukemia, causes.acute_myeloid_leukemia, 
                         causes.chronic_myeloid_leukemia, causes.drug_susceptible_tuberculosis, 
                         causes.other_leukemia, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, causes.latent_tuberculosis_infection, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_1, causes.diabetes_mellitus_type_2, 
                         causes.blindness_and_vision_loss, causes.liver_cancer_due_to_nash, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.burkitt_lymphoma, 
                         causes.other_non_hodgkin_lymphoma, causes.osteoarthritis_hip, causes.osteoarthritis_knee, 
                         causes.total_burden_related_to_hepatitis_b, causes.total_burden_related_to_hepatitis_c, 
                         causes.total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld, 
                         causes.total_cancers, causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.hypertensive_heart_disease, causes.diabetes_mellitus, 
                                                        causes.chronic_kidney_disease, 
                                                        causes.chronic_kidney_disease_due_to_hypertension, 
                                                        causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                                                        causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                                                        causes.diabetes_mellitus_type_1, 
                                                        causes.diabetes_mellitus_type_2, 
                                                        causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1, 
                                                        causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, ),
    ),
    high_fasting_plasma_glucose=RiskFactor(
        name='high_fasting_plasma_glucose',
        kind='risk_factor',
        gbd_id=rei_id(105),
        level=2,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.liver_cancer, causes.liver_cancer_due_to_other_causes, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.breast_cancer, 
                         causes.colon_and_rectum_cancer, causes.pancreatic_cancer, causes.bladder_cancer, 
                         causes.cardiovascular_diseases, causes.ischemic_heart_disease, causes.stroke, 
                         causes.ischemic_stroke, causes.intracerebral_hemorrhage, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.neurological_disorders, 
                         causes.alzheimers_disease_and_other_dementias, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.sense_organ_diseases, causes.glaucoma, causes.cataract, 
                         causes.drug_susceptible_tuberculosis, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, causes.latent_tuberculosis_infection, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_1, causes.diabetes_mellitus_type_2, 
                         causes.blindness_and_vision_loss, causes.liver_cancer_due_to_nash, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, 
                         causes.total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld, 
                         causes.total_cancers, causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.diabetes_mellitus, causes.diabetes_mellitus_type_1, 
                                                        causes.diabetes_mellitus_type_2, ),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(4.88488),
            max=scalar(5.301205),
            inverted=False,
        ),
        relative_risk_scalar=scalar(1),
    ),
    high_systolic_blood_pressure=RiskFactor(
        name='high_systolic_blood_pressure',
        kind='risk_factor',
        gbd_id=rei_id(107),
        level=2,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.atrial_fibrillation_and_flutter, 
                         causes.aortic_aneurysm, causes.lower_extremity_peripheral_arterial_disease, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.diabetes_and_kidney_diseases, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, ),
        population_attributable_fraction_of_one_causes=(causes.hypertensive_heart_disease, ),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(105),
            max=scalar(115),
            inverted=False,
        ),
        relative_risk_scalar=scalar(10),
    ),
    high_body_mass_index=RiskFactor(
        name='high_body_mass_index',
        kind='risk_factor',
        gbd_id=rei_id(108),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=238.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=238.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.liver_cancer, causes.liver_cancer_due_to_hepatitis_b, 
                         causes.liver_cancer_due_to_hepatitis_c, causes.liver_cancer_due_to_alcohol_use, 
                         causes.liver_cancer_due_to_other_causes, causes.breast_cancer, causes.uterine_cancer, 
                         causes.colon_and_rectum_cancer, causes.gallbladder_and_biliary_tract_cancer, 
                         causes.pancreatic_cancer, causes.ovarian_cancer, causes.kidney_cancer, 
                         causes.thyroid_cancer, causes.non_hodgkin_lymphoma, causes.multiple_myeloma, 
                         causes.leukemia, causes.cardiovascular_diseases, causes.ischemic_heart_disease, 
                         causes.stroke, causes.ischemic_stroke, causes.intracerebral_hemorrhage, 
                         causes.subarachnoid_hemorrhage, causes.hypertensive_heart_disease, 
                         causes.atrial_fibrillation_and_flutter, causes.aortic_aneurysm, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.chronic_respiratory_diseases, 
                         causes.asthma, causes.digestive_diseases, causes.gallbladder_and_biliary_diseases, 
                         causes.neurological_disorders, causes.alzheimers_disease_and_other_dementias, 
                         causes.diabetes_mellitus, causes.chronic_kidney_disease, 
                         causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.musculoskeletal_disorders, causes.osteoarthritis, causes.low_back_pain, causes.gout, 
                         causes.sense_organ_diseases, causes.cataract, causes.acute_lymphoid_leukemia, 
                         causes.chronic_lymphoid_leukemia, causes.acute_myeloid_leukemia, 
                         causes.chronic_myeloid_leukemia, causes.drug_susceptible_tuberculosis, 
                         causes.other_leukemia, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, causes.blindness_and_vision_loss, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.burkitt_lymphoma, 
                         causes.other_non_hodgkin_lymphoma, causes.osteoarthritis_hip, causes.osteoarthritis_knee, 
                         causes.total_burden_related_to_hepatitis_b, causes.total_burden_related_to_hepatitis_c, 
                         causes.total_cancers, causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    low_bone_mineral_density=RiskFactor(
        name='low_bone_mineral_density',
        kind='risk_factor',
        gbd_id=rei_id(109),
        level=2,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=13.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=13.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.injuries, causes.transport_injuries, causes.road_injuries, 
                         causes.pedestrian_road_injuries, causes.cyclist_road_injuries, 
                         causes.motorcyclist_road_injuries, causes.motor_vehicle_road_injuries, 
                         causes.other_road_injuries, causes.other_transport_injuries, causes.unintentional_injuries, 
                         causes.falls, causes.exposure_to_mechanical_forces, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.non_venomous_animal_contact, causes.self_harm_and_interpersonal_violence, 
                         causes.interpersonal_violence, causes.physical_violence_by_other_means, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(1),
            max=scalar(1.3),
            inverted=True,
        ),
        relative_risk_scalar=scalar(0.1),
    ),
    dietary_risks=RiskFactor(
        name='dietary_risks',
        kind='risk_factor',
        gbd_id=rei_id(110),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.esophageal_cancer, causes.stomach_cancer, causes.tracheal_bronchus_and_lung_cancer, 
                         causes.breast_cancer, causes.prostate_cancer, causes.colon_and_rectum_cancer, 
                         causes.cardiovascular_diseases, causes.ischemic_heart_disease, causes.stroke, 
                         causes.ischemic_stroke, causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.atrial_fibrillation_and_flutter, 
                         causes.aortic_aneurysm, causes.lower_extremity_peripheral_arterial_disease, 
                         causes.diabetes_mellitus, causes.chronic_kidney_disease, 
                         causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.drug_susceptible_tuberculosis, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    diet_low_in_fruits=RiskFactor(
        name='diet_low_in_fruits',
        kind='risk_factor',
        gbd_id=rei_id(111),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.aortic_aneurysm, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.drug_susceptible_tuberculosis, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(310),
            max=scalar(340),
            inverted=True,
        ),
        relative_risk_scalar=scalar(100),
    ),
    diet_low_in_vegetables=RiskFactor(
        name='diet_low_in_vegetables',
        kind='risk_factor',
        gbd_id=rei_id(112),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.esophageal_cancer, causes.cardiovascular_diseases, causes.ischemic_heart_disease, 
                         causes.stroke, causes.ischemic_stroke, causes.intracerebral_hemorrhage, 
                         causes.subarachnoid_hemorrhage, causes.hypertensive_heart_disease, causes.aortic_aneurysm, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.drug_susceptible_tuberculosis, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(280),
            max=scalar(320),
            inverted=True,
        ),
        relative_risk_scalar=scalar(100),
    ),
    diet_low_in_whole_grains=RiskFactor(
        name='diet_low_in_whole_grains',
        kind='risk_factor',
        gbd_id=rei_id(113),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.colon_and_rectum_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.drug_susceptible_tuberculosis, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(140),
            max=scalar(160),
            inverted=True,
        ),
        relative_risk_scalar=scalar(50),
    ),
    diet_low_in_nuts_and_seeds=RiskFactor(
        name='diet_low_in_nuts_and_seeds',
        kind='risk_factor',
        gbd_id=rei_id(114),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(10),
            max=scalar(19),
            inverted=True,
        ),
        relative_risk_scalar=scalar(4.05),
    ),
    diet_low_in_milk=RiskFactor(
        name='diet_low_in_milk',
        kind='risk_factor',
        gbd_id=rei_id(115),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.prostate_cancer, causes.colon_and_rectum_cancer, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(360),
            max=scalar(500),
            inverted=True,
        ),
        relative_risk_scalar=scalar(226.8),
    ),
    diet_high_in_red_meat=RiskFactor(
        name='diet_high_in_red_meat',
        kind='risk_factor',
        gbd_id=rei_id(116),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.breast_cancer, causes.colon_and_rectum_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.drug_susceptible_tuberculosis, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(0),
            max=scalar(0),
            inverted=False,
        ),
        relative_risk_scalar=scalar(100),
    ),
    diet_high_in_processed_meat=RiskFactor(
        name='diet_high_in_processed_meat',
        kind='risk_factor',
        gbd_id=rei_id(117),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.colon_and_rectum_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.drug_susceptible_tuberculosis, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(0),
            max=scalar(0),
            inverted=False,
        ),
        relative_risk_scalar=scalar(50),
    ),
    diet_high_in_sugar_sweetened_beverages=RiskFactor(
        name='diet_high_in_sugar_sweetened_beverages',
        kind='risk_factor',
        gbd_id=rei_id(118),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.drug_susceptible_tuberculosis, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(0),
            max=scalar(0),
            inverted=False,
        ),
        relative_risk_scalar=scalar(226.8),
    ),
    diet_low_in_fiber=RiskFactor(
        name='diet_low_in_fiber',
        kind='risk_factor',
        gbd_id=rei_id(119),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.colon_and_rectum_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, causes.diabetes_mellitus, 
                         causes.diabetes_and_kidney_diseases, causes.diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(21),
            max=scalar(22),
            inverted=True,
        ),
        relative_risk_scalar=scalar(20),
    ),
    diet_low_in_seafood_omega_3_fatty_acids=RiskFactor(
        name='diet_low_in_seafood_omega_3_fatty_acids',
        kind='risk_factor',
        gbd_id=rei_id(121),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(0.43),
            max=scalar(0.47),
            inverted=True,
        ),
        relative_risk_scalar=scalar(100),
    ),
    diet_low_in_omega_6_polyunsaturated_fatty_acids=RiskFactor(
        name='diet_low_in_omega_6_polyunsaturated_fatty_acids',
        kind='risk_factor',
        gbd_id=rei_id(122),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(0.07),
            max=scalar(0.09),
            inverted=True,
        ),
        relative_risk_scalar=scalar(0.05),
    ),
    diet_high_in_trans_fatty_acids=RiskFactor(
        name='diet_high_in_trans_fatty_acids',
        kind='risk_factor',
        gbd_id=rei_id(123),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(0.00538),
            max=scalar(0.00735),
            inverted=False,
        ),
        relative_risk_scalar=scalar(0.02),
    ),
    diet_high_in_sodium=RiskFactor(
        name='diet_high_in_sodium',
        kind='risk_factor',
        gbd_id=rei_id(124),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.stomach_cancer, causes.cardiovascular_diseases, causes.ischemic_heart_disease, 
                         causes.stroke, causes.ischemic_stroke, causes.intracerebral_hemorrhage, 
                         causes.subarachnoid_hemorrhage, causes.hypertensive_heart_disease, 
                         causes.atrial_fibrillation_and_flutter, causes.aortic_aneurysm, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.chronic_kidney_disease, 
                         causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.diabetes_and_kidney_diseases, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(1),
            max=scalar(5),
            inverted=False,
        ),
        relative_risk_scalar=scalar(1),
    ),
    low_physical_activity=RiskFactor(
        name='low_physical_activity',
        kind='risk_factor',
        gbd_id=rei_id(125),
        level=2,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.breast_cancer, causes.colon_and_rectum_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.drug_susceptible_tuberculosis, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(3600),
            max=scalar(4400),
            inverted=True,
        ),
        relative_risk_scalar=scalar(600),
    ),
    occupational_risks=RiskFactor(
        name='occupational_risks',
        kind='risk_factor',
        gbd_id=rei_id(126),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, causes.larynx_cancer, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.nasopharynx_cancer, causes.ovarian_cancer, 
                         causes.kidney_cancer, causes.mesothelioma, causes.leukemia, 
                         causes.chronic_respiratory_diseases, causes.chronic_obstructive_pulmonary_disease, 
                         causes.pneumoconiosis, causes.silicosis, causes.asbestosis, 
                         causes.coal_workers_pneumoconiosis, causes.other_pneumoconiosis, causes.asthma, 
                         causes.musculoskeletal_disorders, causes.low_back_pain, causes.sense_organ_diseases, 
                         causes.age_related_and_other_hearing_loss, causes.injuries, causes.transport_injuries, 
                         causes.road_injuries, causes.pedestrian_road_injuries, causes.cyclist_road_injuries, 
                         causes.motorcyclist_road_injuries, causes.motor_vehicle_road_injuries, 
                         causes.other_road_injuries, causes.other_transport_injuries, causes.unintentional_injuries, 
                         causes.falls, causes.drowning, causes.fire_heat_and_hot_substances, causes.poisonings, 
                         causes.poisoning_by_carbon_monoxide, causes.poisoning_by_other_means, 
                         causes.exposure_to_mechanical_forces, causes.unintentional_firearm_injuries, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.venomous_animal_contact, causes.non_venomous_animal_contact, causes.foreign_body, 
                         causes.pulmonary_aspiration_and_foreign_body_in_airway, 
                         causes.foreign_body_in_other_body_part, causes.other_unintentional_injuries_internal, 
                         causes.acute_lymphoid_leukemia, causes.chronic_lymphoid_leukemia, 
                         causes.acute_myeloid_leukemia, causes.chronic_myeloid_leukemia, causes.other_leukemia, 
                         causes.total_cancers, causes.other_unintentional_injuries, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.pneumoconiosis, causes.silicosis, causes.asbestosis, 
                                                        causes.coal_workers_pneumoconiosis, 
                                                        causes.other_pneumoconiosis, ),
    ),
    occupational_carcinogens=RiskFactor(
        name='occupational_carcinogens',
        kind='risk_factor',
        gbd_id=rei_id(127),
        level=3,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, causes.larynx_cancer, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.nasopharynx_cancer, causes.ovarian_cancer, 
                         causes.kidney_cancer, causes.mesothelioma, causes.leukemia, 
                         causes.chronic_respiratory_diseases, causes.pneumoconiosis, causes.silicosis, 
                         causes.asbestosis, causes.acute_lymphoid_leukemia, causes.chronic_lymphoid_leukemia, 
                         causes.acute_myeloid_leukemia, causes.chronic_myeloid_leukemia, causes.other_leukemia, 
                         causes.total_cancers, causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.silicosis, causes.asbestosis, ),
    ),
    occupational_asthmagens=RiskFactor(
        name='occupational_asthmagens',
        kind='risk_factor',
        gbd_id=rei_id(128),
        level=3,
        most_detailed=True,
        distribution='unordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=30.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=30.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.chronic_respiratory_diseases, 
                         causes.asthma, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational asthmagens, Admin',
            cat2='Occupational asthmagens, Technical',
            cat3='Occupational asthmagens, Sales',
            cat4='Occupational asthmagens, Agriculture',
            cat5='Occupational asthmagens, Mining',
            cat6='Occupational asthmagens, Transport',
            cat7='Occupational asthmagens, Manufact',
            cat8='Occupational asthmagens, Services',
        ),
    ),
    occupational_particulate_matter_gases_and_fumes=RiskFactor(
        name='occupational_particulate_matter_gases_and_fumes',
        kind='risk_factor',
        gbd_id=rei_id(129),
        level=3,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.chronic_respiratory_diseases, 
                         causes.chronic_obstructive_pulmonary_disease, causes.pneumoconiosis, 
                         causes.coal_workers_pneumoconiosis, causes.other_pneumoconiosis, ),
        population_attributable_fraction_of_one_causes=(causes.coal_workers_pneumoconiosis, 
                                                        causes.other_pneumoconiosis, ),
        categories=Categories(
            cat1='Occupational particulate matter, gases, and fumes, High exposure',
            cat2='Occupational particulate matter, gases, and fumes, Low exposure',
            cat3='Unexposed',
        ),
    ),
    occupational_noise=RiskFactor(
        name='occupational_noise',
        kind='risk_factor',
        gbd_id=rei_id(130),
        level=3,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.sense_organ_diseases, 
                         causes.age_related_and_other_hearing_loss, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational noise, High exposure (>90dB)',
            cat2='Occupational noise, Low exposure (85-90dB)',
            cat3='Unexposed',
        ),
    ),
    occupational_injuries=RiskFactor(
        name='occupational_injuries',
        kind='risk_factor',
        gbd_id=rei_id(131),
        level=3,
        most_detailed=True,
        distribution=None,
        population_attributable_fraction_calculation_type='direct',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=30.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=30.0,
        ),
        affected_causes=(causes.all_causes, causes.injuries, causes.transport_injuries, causes.road_injuries, 
                         causes.pedestrian_road_injuries, causes.cyclist_road_injuries, 
                         causes.motorcyclist_road_injuries, causes.motor_vehicle_road_injuries, 
                         causes.other_road_injuries, causes.other_transport_injuries, causes.unintentional_injuries, 
                         causes.falls, causes.drowning, causes.fire_heat_and_hot_substances, causes.poisonings, 
                         causes.poisoning_by_carbon_monoxide, causes.poisoning_by_other_means, 
                         causes.exposure_to_mechanical_forces, causes.unintentional_firearm_injuries, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.venomous_animal_contact, causes.non_venomous_animal_contact, causes.foreign_body, 
                         causes.pulmonary_aspiration_and_foreign_body_in_airway, 
                         causes.foreign_body_in_other_body_part, causes.other_unintentional_injuries_internal, 
                         causes.other_unintentional_injuries, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    occupational_ergonomic_factors=RiskFactor(
        name='occupational_ergonomic_factors',
        kind='risk_factor',
        gbd_id=rei_id(132),
        level=3,
        most_detailed=True,
        distribution='unordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=30.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.musculoskeletal_disorders, 
                         causes.low_back_pain, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational ergonomic factors, Professional, technical and related workers',
            cat2='Occupational ergonomic factors, Administrative and managerial workers',
            cat3='Occupational ergonomic factors, Clerical and related workers',
            cat4='Occupational ergonomic factors, Sales workers',
            cat5='Occupational ergonomic factors, Service workers',
            cat6='Occupational ergonomic factors, Agriculture, animal husbandry and forestry workers, fishermen and hunters',
            cat7='Occupational ergonomic factors, Production and related workers, transport equipment operators and labourers',
            cat8='Unexposed',
        ),
    ),
    childhood_sexual_abuse=RiskFactor(
        name='childhood_sexual_abuse',
        kind='risk_factor',
        gbd_id=rei_id(134),
        level=3,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.mental_disorders, 
                         causes.alcohol_use_disorders, causes.depressive_disorders, causes.major_depressive_disorder, 
                         causes.substance_use_disorders, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Female childhood sexual abuse',
        ),
    ),
    intimate_partner_violence=RiskFactor(
        name='intimate_partner_violence',
        kind='risk_factor',
        gbd_id=rei_id(135),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.hiv_aids, causes.hiv_aids_resulting_in_other_diseases, 
                         causes.non_communicable_diseases, causes.mental_disorders, causes.depressive_disorders, 
                         causes.major_depressive_disorder, causes.injuries, 
                         causes.self_harm_and_interpersonal_violence, causes.interpersonal_violence, 
                         causes.physical_violence_by_firearm, causes.physical_violence_by_sharp_object, 
                         causes.physical_violence_by_other_means, causes.sexual_violence, 
                         causes.hiv_aids_drug_susceptible_tuberculosis, 
                         causes.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.hiv_aids_extensively_drug_resistant_tuberculosis, 
                         causes.hiv_aids_and_sexually_transmitted_infections, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    non_exclusive_breastfeeding=RiskFactor(
        name='non_exclusive_breastfeeding',
        kind='risk_factor',
        gbd_id=rei_id(136),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=3.0,
            yll_age_group_id_end=388.0,
            yld_age_group_id_start=3.0,
            yld_age_group_id_end=388.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Non-exclusive breastfeeding, None',
            cat2='Non-exclusive breastfeeding, Partial',
            cat3='Non-exclusive breastfeeding, Predominant',
            cat4='Unexposed',
        ),
    ),
    discontinued_breastfeeding=RiskFactor(
        name='discontinued_breastfeeding',
        kind='risk_factor',
        gbd_id=rei_id(137),
        level=4,
        most_detailed=True,
        distribution='dichotomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=238.0,
            yll_age_group_id_end=389.0,
            yld_age_group_id_start=238.0,
            yld_age_group_id_end=389.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.enteric_infections, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Exposed',
            cat2='Unexposed',
        ),
    ),
    injected_drug_use=RiskFactor(
        name='injected_drug_use',
        kind='risk_factor',
        gbd_id=rei_id(138),
        level=3,
        most_detailed=True,
        distribution=None,
        population_attributable_fraction_calculation_type='direct',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=7.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.hiv_aids, causes.hiv_aids_resulting_in_other_diseases, causes.acute_hepatitis, 
                         causes.acute_hepatitis_b, causes.acute_hepatitis_c, causes.non_communicable_diseases, 
                         causes.neoplasms, causes.liver_cancer, causes.liver_cancer_due_to_hepatitis_b, 
                         causes.liver_cancer_due_to_hepatitis_c, causes.cirrhosis_and_other_chronic_liver_diseases, 
                         causes.chronic_hepatitis_b_including_cirrhosis, 
                         causes.chronic_hepatitis_c_including_cirrhosis, causes.digestive_diseases, 
                         causes.drug_use_disorders, causes.opioid_use_disorders, causes.cocaine_use_disorders, 
                         causes.amphetamine_use_disorders, causes.cannabis_use_disorders, 
                         causes.other_drug_use_disorders, causes.hiv_aids_drug_susceptible_tuberculosis, 
                         causes.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.hiv_aids_extensively_drug_resistant_tuberculosis, 
                         causes.hiv_aids_and_sexually_transmitted_infections, causes.other_infectious_diseases, 
                         causes.substance_use_disorders, causes.total_burden_related_to_hepatitis_b, 
                         causes.total_burden_related_to_hepatitis_c, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.drug_use_disorders, causes.opioid_use_disorders, 
                                                        causes.cocaine_use_disorders, 
                                                        causes.amphetamine_use_disorders, 
                                                        causes.cannabis_use_disorders, 
                                                        causes.other_drug_use_disorders, ),
    ),
    drug_dependence=RiskFactor(
        name='drug_dependence',
        kind='risk_factor',
        gbd_id=rei_id(140),
        level=3,
        most_detailed=True,
        distribution='custom',
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=7.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.injuries, causes.self_harm_and_interpersonal_violence, 
                         causes.self_harm, causes.self_harm_by_firearm, causes.self_harm_by_other_specified_means, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    diet_low_in_calcium=RiskFactor(
        name='diet_low_in_calcium',
        kind='risk_factor',
        gbd_id=rei_id(147),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.prostate_cancer, causes.colon_and_rectum_cancer, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(1.06),
            max=scalar(1.1),
            inverted=True,
        ),
        relative_risk_scalar=scalar(1),
    ),
    occupational_exposure_to_asbestos=RiskFactor(
        name='occupational_exposure_to_asbestos',
        kind='risk_factor',
        gbd_id=rei_id(150),
        level=4,
        most_detailed=True,
        distribution='dichotomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, causes.larynx_cancer, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.ovarian_cancer, causes.mesothelioma, 
                         causes.chronic_respiratory_diseases, causes.pneumoconiosis, causes.asbestosis, 
                         causes.total_cancers, causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.asbestosis, ),
        categories=Categories(
            cat1='Exposed',
            cat2='Unexposed',
        ),
    ),
    occupational_exposure_to_arsenic=RiskFactor(
        name='occupational_exposure_to_arsenic',
        kind='risk_factor',
        gbd_id=rei_id(151),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational exposure to arsenic, High exposure',
            cat2='Occupational exposure to arsenic, Low exposure',
            cat3='Unexposed',
        ),
    ),
    occupational_exposure_to_benzene=RiskFactor(
        name='occupational_exposure_to_benzene',
        kind='risk_factor',
        gbd_id=rei_id(152),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=20.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=20.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, causes.leukemia, 
                         causes.acute_lymphoid_leukemia, causes.chronic_lymphoid_leukemia, 
                         causes.acute_myeloid_leukemia, causes.chronic_myeloid_leukemia, causes.other_leukemia, 
                         causes.total_cancers, causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational exposure to benzene, High exposure',
            cat2='Occupational exposure to benzene, Low exposure',
            cat3='Unexposed',
        ),
    ),
    occupational_exposure_to_beryllium=RiskFactor(
        name='occupational_exposure_to_beryllium',
        kind='risk_factor',
        gbd_id=rei_id(153),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational exposure to beryllium, High exposure',
            cat2='Occupational exposure to beryllium, Low exposure',
            cat3='Unexposed',
        ),
    ),
    occupational_exposure_to_cadmium=RiskFactor(
        name='occupational_exposure_to_cadmium',
        kind='risk_factor',
        gbd_id=rei_id(154),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational exposure to cadmium, High exposure',
            cat2='Occupational exposure to cadmium, Low exposure',
            cat3='Unexposed',
        ),
    ),
    occupational_exposure_to_chromium=RiskFactor(
        name='occupational_exposure_to_chromium',
        kind='risk_factor',
        gbd_id=rei_id(155),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational exposure to chromium, High exposure',
            cat2='Occupational exposure to chromium, Low exposure',
            cat3='Unexposed',
        ),
    ),
    occupational_exposure_to_diesel_engine_exhaust=RiskFactor(
        name='occupational_exposure_to_diesel_engine_exhaust',
        kind='risk_factor',
        gbd_id=rei_id(156),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational exposure to diesel engine exhaust, High exposure',
            cat2='Occupational exposure to diesel engine exhaust, Low exposure',
            cat3='Unexposed',
        ),
    ),
    occupational_exposure_to_formaldehyde=RiskFactor(
        name='occupational_exposure_to_formaldehyde',
        kind='risk_factor',
        gbd_id=rei_id(158),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=20.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=20.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.nasopharynx_cancer, causes.leukemia, causes.acute_lymphoid_leukemia, 
                         causes.chronic_lymphoid_leukemia, causes.acute_myeloid_leukemia, 
                         causes.chronic_myeloid_leukemia, causes.other_leukemia, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational exposure to formaldehyde, High exposure',
            cat2='Occupational exposure to formaldehyde, Low exposure',
            cat3='Unexposed',
        ),
    ),
    occupational_exposure_to_nickel=RiskFactor(
        name='occupational_exposure_to_nickel',
        kind='risk_factor',
        gbd_id=rei_id(159),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational exposure to nickel, High exposure',
            cat2='Occupational exposure to nickel, Low exposure',
            cat3='Unexposed',
        ),
    ),
    occupational_exposure_to_polycyclic_aromatic_hydrocarbons=RiskFactor(
        name='occupational_exposure_to_polycyclic_aromatic_hydrocarbons',
        kind='risk_factor',
        gbd_id=rei_id(160),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational exposure to polycyclic aromatic hydrocarbons, High exposure',
            cat2='Occupational exposure to polycyclic aromatic hydrocarbons, Low exposure',
            cat3='Unexposed',
        ),
    ),
    occupational_exposure_to_silica=RiskFactor(
        name='occupational_exposure_to_silica',
        kind='risk_factor',
        gbd_id=rei_id(161),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.chronic_respiratory_diseases, 
                         causes.pneumoconiosis, causes.silicosis, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.silicosis, ),
        categories=Categories(
            cat1='Occupational exposure to silica, High exposure',
            cat2='Occupational exposure to silica, Low exposure',
            cat3='Unexposed',
        ),
    ),
    occupational_exposure_to_sulfuric_acid=RiskFactor(
        name='occupational_exposure_to_sulfuric_acid',
        kind='risk_factor',
        gbd_id=rei_id(162),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, causes.larynx_cancer, 
                         causes.total_cancers, causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational exposure to sulfuric acid, High exposure',
            cat2='Occupational exposure to sulfuric acid, Low exposure',
            cat3='Unexposed',
        ),
    ),
    intimate_partner_violence_exposure_approach=RiskFactor(
        name='intimate_partner_violence_exposure_approach',
        kind='risk_factor',
        gbd_id=rei_id(167),
        level=3,
        most_detailed=True,
        distribution='dichotomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=15.0,
            yld_age_group_id_start=7.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.mental_disorders, 
                         causes.depressive_disorders, causes.major_depressive_disorder, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Exposed',
            cat2='Unexposed',
        ),
    ),
    intimate_partner_violence_direct_paf_approach=RiskFactor(
        name='intimate_partner_violence_direct_paf_approach',
        kind='risk_factor',
        gbd_id=rei_id(168),
        level=3,
        most_detailed=True,
        distribution=None,
        population_attributable_fraction_calculation_type='direct',
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.injuries, causes.self_harm_and_interpersonal_violence, 
                         causes.interpersonal_violence, causes.physical_violence_by_firearm, 
                         causes.physical_violence_by_sharp_object, causes.physical_violence_by_other_means, 
                         causes.sexual_violence, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    all_risk_factors=RiskFactor(
        name='all_risk_factors',
        kind='risk_factor',
        gbd_id=rei_id(169),
        level=0,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.hiv_aids, causes.hiv_aids_resulting_in_other_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.upper_respiratory_infections, causes.otitis_media, causes.meningitis, 
                         causes.encephalitis, causes.measles, causes.neglected_tropical_diseases_and_malaria, 
                         causes.malaria, causes.maternal_disorders, causes.maternal_hemorrhage, 
                         causes.maternal_sepsis_and_other_maternal_infections, 
                         causes.maternal_hypertensive_disorders, 
                         causes.maternal_obstructed_labor_and_uterine_rupture, causes.ectopic_pregnancy, 
                         causes.indirect_maternal_deaths, causes.late_maternal_deaths, 
                         causes.other_direct_maternal_disorders, causes.neonatal_disorders, 
                         causes.neonatal_preterm_birth, 
                         causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                         causes.neonatal_sepsis_and_other_neonatal_infections, 
                         causes.hemolytic_disease_and_other_neonatal_jaundice, causes.other_neonatal_disorders, 
                         causes.nutritional_deficiencies, causes.protein_energy_malnutrition, 
                         causes.vitamin_a_deficiency, causes.dietary_iron_deficiency, 
                         causes.sexually_transmitted_infections_excluding_hiv, causes.syphilis, 
                         causes.chlamydial_infection, causes.gonococcal_infection, causes.trichomoniasis, 
                         causes.genital_herpes, causes.other_sexually_transmitted_infections, causes.acute_hepatitis, 
                         causes.acute_hepatitis_b, causes.acute_hepatitis_c, causes.non_communicable_diseases, 
                         causes.neoplasms, causes.esophageal_cancer, causes.stomach_cancer, causes.liver_cancer, 
                         causes.liver_cancer_due_to_hepatitis_b, causes.liver_cancer_due_to_hepatitis_c, 
                         causes.liver_cancer_due_to_alcohol_use, causes.liver_cancer_due_to_other_causes, 
                         causes.larynx_cancer, causes.tracheal_bronchus_and_lung_cancer, causes.breast_cancer, 
                         causes.cervical_cancer, causes.uterine_cancer, causes.prostate_cancer, 
                         causes.colon_and_rectum_cancer, causes.lip_and_oral_cavity_cancer, 
                         causes.nasopharynx_cancer, causes.other_pharynx_cancer, 
                         causes.gallbladder_and_biliary_tract_cancer, causes.pancreatic_cancer, 
                         causes.ovarian_cancer, causes.kidney_cancer, causes.bladder_cancer, causes.thyroid_cancer, 
                         causes.mesothelioma, causes.non_hodgkin_lymphoma, causes.multiple_myeloma, causes.leukemia, 
                         causes.cardiovascular_diseases, causes.ischemic_heart_disease, causes.stroke, 
                         causes.ischemic_stroke, causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.cardiomyopathy_and_myocarditis, 
                         causes.atrial_fibrillation_and_flutter, causes.aortic_aneurysm, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.chronic_respiratory_diseases, 
                         causes.chronic_obstructive_pulmonary_disease, causes.pneumoconiosis, causes.silicosis, 
                         causes.asbestosis, causes.coal_workers_pneumoconiosis, causes.other_pneumoconiosis, 
                         causes.asthma, causes.cirrhosis_and_other_chronic_liver_diseases, 
                         causes.chronic_hepatitis_b_including_cirrhosis, 
                         causes.chronic_hepatitis_c_including_cirrhosis, causes.cirrhosis_due_to_alcohol, 
                         causes.cirrhosis_due_to_other_causes, causes.digestive_diseases, 
                         causes.peptic_ulcer_disease, causes.gallbladder_and_biliary_diseases, causes.pancreatitis, 
                         causes.neurological_disorders, causes.alzheimers_disease_and_other_dementias, 
                         causes.parkinsons_disease, causes.idiopathic_epilepsy, causes.multiple_sclerosis, 
                         causes.mental_disorders, causes.alcohol_use_disorders, causes.drug_use_disorders, 
                         causes.opioid_use_disorders, causes.cocaine_use_disorders, causes.amphetamine_use_disorders, 
                         causes.cannabis_use_disorders, causes.other_drug_use_disorders, causes.depressive_disorders, 
                         causes.major_depressive_disorder, causes.anxiety_disorders, 
                         causes.idiopathic_developmental_intellectual_disability, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.musculoskeletal_disorders, causes.rheumatoid_arthritis, causes.osteoarthritis, 
                         causes.low_back_pain, causes.gout, causes.other_non_communicable_diseases, 
                         causes.sense_organ_diseases, causes.glaucoma, causes.cataract, 
                         causes.age_related_macular_degeneration, causes.age_related_and_other_hearing_loss, 
                         causes.sudden_infant_death_syndrome, causes.injuries, causes.transport_injuries, 
                         causes.road_injuries, causes.pedestrian_road_injuries, causes.cyclist_road_injuries, 
                         causes.motorcyclist_road_injuries, causes.motor_vehicle_road_injuries, 
                         causes.other_road_injuries, causes.other_transport_injuries, causes.unintentional_injuries, 
                         causes.falls, causes.drowning, causes.fire_heat_and_hot_substances, causes.poisonings, 
                         causes.poisoning_by_carbon_monoxide, causes.poisoning_by_other_means, 
                         causes.exposure_to_mechanical_forces, causes.unintentional_firearm_injuries, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.venomous_animal_contact, causes.non_venomous_animal_contact, causes.foreign_body, 
                         causes.pulmonary_aspiration_and_foreign_body_in_airway, 
                         causes.foreign_body_in_other_body_part, causes.other_unintentional_injuries_internal, 
                         causes.self_harm_and_interpersonal_violence, causes.self_harm, causes.self_harm_by_firearm, 
                         causes.self_harm_by_other_specified_means, causes.interpersonal_violence, 
                         causes.physical_violence_by_firearm, causes.physical_violence_by_sharp_object, 
                         causes.physical_violence_by_other_means, causes.exposure_to_forces_of_nature, 
                         causes.maternal_deaths_aggravated_by_hiv_aids, causes.environmental_heat_and_cold_exposure, 
                         causes.acute_lymphoid_leukemia, causes.chronic_lymphoid_leukemia, 
                         causes.acute_myeloid_leukemia, causes.chronic_myeloid_leukemia, 
                         causes.drug_susceptible_tuberculosis, causes.alcoholic_cardiomyopathy, 
                         causes.sexual_violence, causes.myocarditis, causes.other_leukemia, 
                         causes.other_cardiomyopathy, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.hiv_aids_drug_susceptible_tuberculosis, 
                         causes.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.hiv_aids_extensively_drug_resistant_tuberculosis, 
                         causes.latent_tuberculosis_infection, causes.hiv_aids_and_sexually_transmitted_infections, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, 
                         causes.other_infectious_diseases, causes.maternal_and_neonatal_disorders, 
                         causes.nonalcoholic_fatty_liver_disease_including_cirrhosis, causes.substance_use_disorders, 
                         causes.diabetes_and_kidney_diseases, causes.diabetes_mellitus_type_1, 
                         causes.diabetes_mellitus_type_2, causes.blindness_and_vision_loss, 
                         causes.upper_digestive_system_diseases, causes.maternal_abortion_and_miscarriage, 
                         causes.liver_cancer_due_to_nash, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.burkitt_lymphoma, 
                         causes.other_non_hodgkin_lymphoma, causes.osteoarthritis_hip, causes.osteoarthritis_knee, 
                         causes.total_burden_related_to_hepatitis_b, causes.total_burden_related_to_hepatitis_c, 
                         causes.total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld, 
                         causes.total_cancers, causes.other_unintentional_injuries, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.neonatal_preterm_birth, 
                                                        causes.protein_energy_malnutrition, 
                                                        causes.vitamin_a_deficiency, causes.dietary_iron_deficiency, 
                                                        causes.sexually_transmitted_infections_excluding_hiv, 
                                                        causes.syphilis, causes.chlamydial_infection, 
                                                        causes.gonococcal_infection, causes.trichomoniasis, 
                                                        causes.genital_herpes, 
                                                        causes.other_sexually_transmitted_infections, 
                                                        causes.liver_cancer_due_to_alcohol_use, 
                                                        causes.cervical_cancer, causes.hypertensive_heart_disease, 
                                                        causes.pneumoconiosis, causes.silicosis, causes.asbestosis, 
                                                        causes.coal_workers_pneumoconiosis, 
                                                        causes.other_pneumoconiosis, causes.cirrhosis_due_to_alcohol, 
                                                        causes.alcohol_use_disorders, causes.drug_use_disorders, 
                                                        causes.opioid_use_disorders, causes.cocaine_use_disorders, 
                                                        causes.amphetamine_use_disorders, 
                                                        causes.cannabis_use_disorders, 
                                                        causes.other_drug_use_disorders, causes.diabetes_mellitus, 
                                                        causes.chronic_kidney_disease, 
                                                        causes.chronic_kidney_disease_due_to_hypertension, 
                                                        causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                                                        causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                                                        causes.alcoholic_cardiomyopathy, 
                                                        causes.substance_use_disorders, 
                                                        causes.diabetes_mellitus_type_1, 
                                                        causes.diabetes_mellitus_type_2, 
                                                        causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1, 
                                                        causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, ),
    ),
    unsafe_sex=RiskFactor(
        name='unsafe_sex',
        kind='risk_factor',
        gbd_id=rei_id(170),
        level=2,
        most_detailed=True,
        distribution=None,
        population_attributable_fraction_calculation_type='direct',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=7.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.hiv_aids, causes.hiv_aids_resulting_in_other_diseases, 
                         causes.sexually_transmitted_infections_excluding_hiv, causes.syphilis, 
                         causes.chlamydial_infection, causes.gonococcal_infection, causes.trichomoniasis, 
                         causes.genital_herpes, causes.other_sexually_transmitted_infections, 
                         causes.non_communicable_diseases, causes.neoplasms, causes.cervical_cancer, 
                         causes.hiv_aids_drug_susceptible_tuberculosis, 
                         causes.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.hiv_aids_extensively_drug_resistant_tuberculosis, 
                         causes.hiv_aids_and_sexually_transmitted_infections, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.sexually_transmitted_infections_excluding_hiv, 
                                                        causes.syphilis, causes.chlamydial_infection, 
                                                        causes.gonococcal_infection, causes.trichomoniasis, 
                                                        causes.genital_herpes, 
                                                        causes.other_sexually_transmitted_infections, 
                                                        causes.cervical_cancer, ),
    ),
    intimate_partner_violence_hiv_paf_approach=RiskFactor(
        name='intimate_partner_violence_hiv_paf_approach',
        kind='risk_factor',
        gbd_id=rei_id(201),
        level=3,
        most_detailed=True,
        distribution=None,
        population_attributable_fraction_calculation_type='direct',
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=8.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.hiv_aids, causes.hiv_aids_resulting_in_other_diseases, 
                         causes.hiv_aids_drug_susceptible_tuberculosis, 
                         causes.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.hiv_aids_extensively_drug_resistant_tuberculosis, 
                         causes.hiv_aids_and_sexually_transmitted_infections, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    environmental_occupational_risks=RiskFactor(
        name='environmental_occupational_risks',
        kind='risk_factor',
        gbd_id=rei_id(202),
        level=1,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.upper_respiratory_infections, causes.otitis_media, causes.meningitis, 
                         causes.encephalitis, causes.neonatal_disorders, causes.neonatal_preterm_birth, 
                         causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                         causes.neonatal_sepsis_and_other_neonatal_infections, 
                         causes.hemolytic_disease_and_other_neonatal_jaundice, causes.other_neonatal_disorders, 
                         causes.non_communicable_diseases, causes.neoplasms, causes.larynx_cancer, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.nasopharynx_cancer, causes.ovarian_cancer, 
                         causes.kidney_cancer, causes.mesothelioma, causes.leukemia, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.cardiomyopathy_and_myocarditis, 
                         causes.atrial_fibrillation_and_flutter, causes.aortic_aneurysm, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.chronic_respiratory_diseases, 
                         causes.chronic_obstructive_pulmonary_disease, causes.pneumoconiosis, causes.silicosis, 
                         causes.asbestosis, causes.coal_workers_pneumoconiosis, causes.other_pneumoconiosis, 
                         causes.asthma, causes.mental_disorders, 
                         causes.idiopathic_developmental_intellectual_disability, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.musculoskeletal_disorders, causes.low_back_pain, 
                         causes.other_non_communicable_diseases, causes.sense_organ_diseases, causes.cataract, 
                         causes.age_related_and_other_hearing_loss, causes.sudden_infant_death_syndrome, 
                         causes.injuries, causes.transport_injuries, causes.road_injuries, 
                         causes.pedestrian_road_injuries, causes.cyclist_road_injuries, 
                         causes.motorcyclist_road_injuries, causes.motor_vehicle_road_injuries, 
                         causes.other_road_injuries, causes.other_transport_injuries, causes.unintentional_injuries, 
                         causes.falls, causes.drowning, causes.fire_heat_and_hot_substances, causes.poisonings, 
                         causes.poisoning_by_carbon_monoxide, causes.poisoning_by_other_means, 
                         causes.exposure_to_mechanical_forces, causes.unintentional_firearm_injuries, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.venomous_animal_contact, causes.non_venomous_animal_contact, causes.foreign_body, 
                         causes.pulmonary_aspiration_and_foreign_body_in_airway, 
                         causes.foreign_body_in_other_body_part, causes.other_unintentional_injuries_internal, 
                         causes.self_harm_and_interpersonal_violence, causes.self_harm, causes.self_harm_by_firearm, 
                         causes.self_harm_by_other_specified_means, causes.interpersonal_violence, 
                         causes.physical_violence_by_firearm, causes.physical_violence_by_sharp_object, 
                         causes.physical_violence_by_other_means, causes.exposure_to_forces_of_nature, 
                         causes.acute_lymphoid_leukemia, causes.chronic_lymphoid_leukemia, 
                         causes.acute_myeloid_leukemia, causes.chronic_myeloid_leukemia, 
                         causes.alcoholic_cardiomyopathy, causes.myocarditis, causes.other_leukemia, 
                         causes.other_cardiomyopathy, causes.respiratory_infections_and_tuberculosis, 
                         causes.enteric_infections, causes.other_infectious_diseases, 
                         causes.maternal_and_neonatal_disorders, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_1, causes.diabetes_mellitus_type_2, 
                         causes.blindness_and_vision_loss, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.total_cancers, 
                         causes.other_unintentional_injuries, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.pneumoconiosis, causes.silicosis, causes.asbestosis, 
                                                        causes.coal_workers_pneumoconiosis, 
                                                        causes.other_pneumoconiosis, ),
    ),
    behavioral_risks=RiskFactor(
        name='behavioral_risks',
        kind='risk_factor',
        gbd_id=rei_id(203),
        level=1,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.hiv_aids, causes.hiv_aids_resulting_in_other_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.upper_respiratory_infections, causes.otitis_media, causes.meningitis, 
                         causes.encephalitis, causes.measles, causes.neglected_tropical_diseases_and_malaria, 
                         causes.malaria, causes.maternal_disorders, causes.maternal_hemorrhage, 
                         causes.maternal_sepsis_and_other_maternal_infections, 
                         causes.maternal_hypertensive_disorders, 
                         causes.maternal_obstructed_labor_and_uterine_rupture, causes.ectopic_pregnancy, 
                         causes.indirect_maternal_deaths, causes.late_maternal_deaths, 
                         causes.other_direct_maternal_disorders, causes.neonatal_disorders, 
                         causes.neonatal_preterm_birth, 
                         causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                         causes.neonatal_sepsis_and_other_neonatal_infections, 
                         causes.hemolytic_disease_and_other_neonatal_jaundice, causes.other_neonatal_disorders, 
                         causes.nutritional_deficiencies, causes.protein_energy_malnutrition, 
                         causes.vitamin_a_deficiency, causes.dietary_iron_deficiency, 
                         causes.sexually_transmitted_infections_excluding_hiv, causes.syphilis, 
                         causes.chlamydial_infection, causes.gonococcal_infection, causes.trichomoniasis, 
                         causes.genital_herpes, causes.other_sexually_transmitted_infections, causes.acute_hepatitis, 
                         causes.acute_hepatitis_b, causes.acute_hepatitis_c, causes.non_communicable_diseases, 
                         causes.neoplasms, causes.esophageal_cancer, causes.stomach_cancer, causes.liver_cancer, 
                         causes.liver_cancer_due_to_hepatitis_b, causes.liver_cancer_due_to_hepatitis_c, 
                         causes.liver_cancer_due_to_alcohol_use, causes.liver_cancer_due_to_other_causes, 
                         causes.larynx_cancer, causes.tracheal_bronchus_and_lung_cancer, causes.breast_cancer, 
                         causes.cervical_cancer, causes.prostate_cancer, causes.colon_and_rectum_cancer, 
                         causes.lip_and_oral_cavity_cancer, causes.nasopharynx_cancer, causes.other_pharynx_cancer, 
                         causes.pancreatic_cancer, causes.kidney_cancer, causes.bladder_cancer, causes.leukemia, 
                         causes.cardiovascular_diseases, causes.ischemic_heart_disease, causes.stroke, 
                         causes.ischemic_stroke, causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.cardiomyopathy_and_myocarditis, 
                         causes.atrial_fibrillation_and_flutter, causes.aortic_aneurysm, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.chronic_respiratory_diseases, 
                         causes.chronic_obstructive_pulmonary_disease, causes.asthma, 
                         causes.cirrhosis_and_other_chronic_liver_diseases, 
                         causes.chronic_hepatitis_b_including_cirrhosis, 
                         causes.chronic_hepatitis_c_including_cirrhosis, causes.cirrhosis_due_to_alcohol, 
                         causes.cirrhosis_due_to_other_causes, causes.digestive_diseases, 
                         causes.peptic_ulcer_disease, causes.gallbladder_and_biliary_diseases, causes.pancreatitis, 
                         causes.neurological_disorders, causes.alzheimers_disease_and_other_dementias, 
                         causes.parkinsons_disease, causes.idiopathic_epilepsy, causes.multiple_sclerosis, 
                         causes.mental_disorders, causes.alcohol_use_disorders, causes.drug_use_disorders, 
                         causes.opioid_use_disorders, causes.cocaine_use_disorders, causes.amphetamine_use_disorders, 
                         causes.cannabis_use_disorders, causes.other_drug_use_disorders, causes.depressive_disorders, 
                         causes.major_depressive_disorder, causes.anxiety_disorders, causes.diabetes_mellitus, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.musculoskeletal_disorders, causes.rheumatoid_arthritis, causes.low_back_pain, 
                         causes.other_non_communicable_diseases, causes.sense_organ_diseases, causes.cataract, 
                         causes.age_related_macular_degeneration, causes.sudden_infant_death_syndrome, 
                         causes.injuries, causes.transport_injuries, causes.road_injuries, 
                         causes.pedestrian_road_injuries, causes.cyclist_road_injuries, 
                         causes.motorcyclist_road_injuries, causes.motor_vehicle_road_injuries, 
                         causes.other_road_injuries, causes.other_transport_injuries, causes.unintentional_injuries, 
                         causes.falls, causes.drowning, causes.fire_heat_and_hot_substances, causes.poisonings, 
                         causes.poisoning_by_carbon_monoxide, causes.poisoning_by_other_means, 
                         causes.exposure_to_mechanical_forces, causes.unintentional_firearm_injuries, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.venomous_animal_contact, causes.non_venomous_animal_contact, 
                         causes.other_unintentional_injuries_internal, causes.self_harm_and_interpersonal_violence, 
                         causes.self_harm, causes.self_harm_by_firearm, causes.self_harm_by_other_specified_means, 
                         causes.interpersonal_violence, causes.physical_violence_by_firearm, 
                         causes.physical_violence_by_sharp_object, causes.physical_violence_by_other_means, 
                         causes.maternal_deaths_aggravated_by_hiv_aids, causes.environmental_heat_and_cold_exposure, 
                         causes.acute_lymphoid_leukemia, causes.chronic_lymphoid_leukemia, 
                         causes.acute_myeloid_leukemia, causes.chronic_myeloid_leukemia, 
                         causes.drug_susceptible_tuberculosis, causes.alcoholic_cardiomyopathy, 
                         causes.sexual_violence, causes.other_leukemia, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.hiv_aids_drug_susceptible_tuberculosis, 
                         causes.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.hiv_aids_extensively_drug_resistant_tuberculosis, 
                         causes.latent_tuberculosis_infection, causes.hiv_aids_and_sexually_transmitted_infections, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, 
                         causes.other_infectious_diseases, causes.maternal_and_neonatal_disorders, 
                         causes.nonalcoholic_fatty_liver_disease_including_cirrhosis, causes.substance_use_disorders, 
                         causes.diabetes_and_kidney_diseases, causes.diabetes_mellitus_type_2, 
                         causes.blindness_and_vision_loss, causes.upper_digestive_system_diseases, 
                         causes.maternal_abortion_and_miscarriage, causes.liver_cancer_due_to_nash, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, 
                         causes.total_burden_related_to_hepatitis_b, causes.total_burden_related_to_hepatitis_c, 
                         causes.total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld, 
                         causes.total_cancers, causes.other_unintentional_injuries, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(causes.neonatal_preterm_birth, 
                                                        causes.protein_energy_malnutrition, 
                                                        causes.vitamin_a_deficiency, causes.dietary_iron_deficiency, 
                                                        causes.sexually_transmitted_infections_excluding_hiv, 
                                                        causes.syphilis, causes.chlamydial_infection, 
                                                        causes.gonococcal_infection, causes.trichomoniasis, 
                                                        causes.genital_herpes, 
                                                        causes.other_sexually_transmitted_infections, 
                                                        causes.liver_cancer_due_to_alcohol_use, 
                                                        causes.cervical_cancer, causes.cirrhosis_due_to_alcohol, 
                                                        causes.alcohol_use_disorders, causes.drug_use_disorders, 
                                                        causes.opioid_use_disorders, causes.cocaine_use_disorders, 
                                                        causes.amphetamine_use_disorders, 
                                                        causes.cannabis_use_disorders, 
                                                        causes.other_drug_use_disorders, 
                                                        causes.alcoholic_cardiomyopathy, 
                                                        causes.substance_use_disorders, ),
    ),
    occupational_exposure_to_trichloroethylene=RiskFactor(
        name='occupational_exposure_to_trichloroethylene',
        kind='risk_factor',
        gbd_id=rei_id(237),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, causes.kidney_cancer, 
                         causes.total_cancers, causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Occupational exposure to trichloroethylene, High exposure',
            cat2='Occupational exposure to trichloroethylene, Low exposure',
            cat3='Unexposed',
        ),
    ),
    no_access_to_handwashing_facility=RiskFactor(
        name='no_access_to_handwashing_facility',
        kind='risk_factor',
        gbd_id=rei_id(238),
        level=3,
        most_detailed=True,
        distribution='dichotomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Exposed',
            cat2='Unexposed',
        ),
    ),
    child_growth_failure=RiskFactor(
        name='child_growth_failure',
        kind='risk_factor',
        gbd_id=rei_id(239),
        level=3,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=388.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, causes.measles, 
                         causes.neglected_tropical_diseases_and_malaria, causes.malaria, 
                         causes.nutritional_deficiencies, causes.protein_energy_malnutrition, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, 
                         causes.other_infectious_diseases, ),
        population_attributable_fraction_of_one_causes=(causes.protein_energy_malnutrition, ),
    ),
    child_wasting=RiskFactor(
        name='child_wasting',
        kind='risk_factor',
        gbd_id=rei_id(240),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=388.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, causes.measles, 
                         causes.neglected_tropical_diseases_and_malaria, causes.malaria, 
                         causes.nutritional_deficiencies, causes.protein_energy_malnutrition, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, 
                         causes.other_infectious_diseases, ),
        population_attributable_fraction_of_one_causes=(causes.protein_energy_malnutrition, ),
        categories=Categories(
            cat1='Severe Wasting, < -3 SD (post-ensemble)',
            cat2='Wasting Between -3 SD and -2 SD (post-ensemble)',
            cat3='Wasting Between -2 SD and -1 SD (post-ensemble)',
            cat4='Unexposed',
        ),
    ),
    child_stunting=RiskFactor(
        name='child_stunting',
        kind='risk_factor',
        gbd_id=rei_id(241),
        level=4,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=388.0,
            yll_age_group_id_end=34.0,
            yld_age_group_id_start=388.0,
            yld_age_group_id_end=34.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, causes.measles, 
                         causes.neglected_tropical_diseases_and_malaria, causes.malaria, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, 
                         causes.other_infectious_diseases, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Severe Stunting, < -3 SD (post-ensemble)',
            cat2='Stunting Between -3 SD and -2 SD (post-ensemble)',
            cat3='Stunting Between -2 SD and -1 SD (post-ensemble)',
            cat4='Unexposed',
        ),
    ),
    lead_exposure_in_blood=RiskFactor(
        name='lead_exposure_in_blood',
        kind='risk_factor',
        gbd_id=rei_id(242),
        level=4,
        most_detailed=True,
        distribution='custom',
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.mental_disorders, 
                         causes.idiopathic_developmental_intellectual_disability, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    lead_exposure_in_bone=RiskFactor(
        name='lead_exposure_in_bone',
        kind='risk_factor',
        gbd_id=rei_id(243),
        level=4,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.atrial_fibrillation_and_flutter, 
                         causes.aortic_aneurysm, causes.lower_extremity_peripheral_arterial_disease, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.diabetes_and_kidney_diseases, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(0),
            max=scalar(20),
            inverted=False,
        ),
        relative_risk_scalar=scalar(10),
    ),
    childhood_sexual_abuse_against_females=RiskFactor(
        name='childhood_sexual_abuse_against_females',
        kind='risk_factor',
        gbd_id=rei_id(244),
        level=4,
        most_detailed=True,
        distribution='dichotomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.mental_disorders, 
                         causes.alcohol_use_disorders, causes.depressive_disorders, causes.major_depressive_disorder, 
                         causes.substance_use_disorders, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Exposed',
            cat2='Unexposed',
        ),
    ),
    childhood_sexual_abuse_against_males=RiskFactor(
        name='childhood_sexual_abuse_against_males',
        kind='risk_factor',
        gbd_id=rei_id(245),
        level=4,
        most_detailed=True,
        distribution='dichotomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=True,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.mental_disorders, 
                         causes.alcohol_use_disorders, causes.depressive_disorders, causes.major_depressive_disorder, 
                         causes.substance_use_disorders, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Exposed',
            cat2='Unexposed',
        ),
    ),
    non_optimal_temperature=RiskFactor(
        name='non_optimal_temperature',
        kind='risk_factor',
        gbd_id=rei_id(331),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.lower_respiratory_infections, causes.non_communicable_diseases, 
                         causes.cardiovascular_diseases, causes.ischemic_heart_disease, causes.stroke, 
                         causes.ischemic_stroke, causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.cardiomyopathy_and_myocarditis, 
                         causes.chronic_respiratory_diseases, causes.chronic_obstructive_pulmonary_disease, 
                         causes.diabetes_mellitus, causes.chronic_kidney_disease, 
                         causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, causes.injuries, 
                         causes.transport_injuries, causes.road_injuries, causes.pedestrian_road_injuries, 
                         causes.cyclist_road_injuries, causes.motorcyclist_road_injuries, 
                         causes.motor_vehicle_road_injuries, causes.other_road_injuries, 
                         causes.other_transport_injuries, causes.unintentional_injuries, causes.drowning, 
                         causes.exposure_to_mechanical_forces, causes.unintentional_firearm_injuries, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.venomous_animal_contact, causes.non_venomous_animal_contact, 
                         causes.other_unintentional_injuries_internal, causes.self_harm_and_interpersonal_violence, 
                         causes.self_harm, causes.self_harm_by_firearm, causes.self_harm_by_other_specified_means, 
                         causes.interpersonal_violence, causes.physical_violence_by_firearm, 
                         causes.physical_violence_by_sharp_object, causes.physical_violence_by_other_means, 
                         causes.exposure_to_forces_of_nature, causes.alcoholic_cardiomyopathy, causes.myocarditis, 
                         causes.other_cardiomyopathy, causes.respiratory_infections_and_tuberculosis, 
                         causes.diabetes_and_kidney_diseases, causes.diabetes_mellitus_type_1, 
                         causes.diabetes_mellitus_type_2, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, 
                         causes.other_unintentional_injuries, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    chewing_tobacco=RiskFactor(
        name='chewing_tobacco',
        kind='risk_factor',
        gbd_id=rei_id(332),
        level=3,
        most_detailed=True,
        distribution='dichotomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=11.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=11.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.esophageal_cancer, causes.lip_and_oral_cavity_cancer, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Exposed',
            cat2='Unexposed',
        ),
    ),
    diet_low_in_legumes=RiskFactor(
        name='diet_low_in_legumes',
        kind='risk_factor',
        gbd_id=rei_id(333),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(90),
            max=scalar(100),
            inverted=True,
        ),
        relative_risk_scalar=scalar(50),
    ),
    short_gestation=RiskFactor(
        name='short_gestation',
        kind='risk_factor',
        gbd_id=rei_id(334),
        level=4,
        most_detailed=True,
        distribution=None,
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=34.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.upper_respiratory_infections, causes.otitis_media, causes.meningitis, 
                         causes.encephalitis, causes.neonatal_disorders, causes.neonatal_preterm_birth, 
                         causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                         causes.neonatal_sepsis_and_other_neonatal_infections, 
                         causes.hemolytic_disease_and_other_neonatal_jaundice, causes.other_neonatal_disorders, 
                         causes.non_communicable_diseases, causes.other_non_communicable_diseases, 
                         causes.sudden_infant_death_syndrome, causes.respiratory_infections_and_tuberculosis, 
                         causes.enteric_infections, causes.other_infectious_diseases, 
                         causes.maternal_and_neonatal_disorders, ),
        population_attributable_fraction_of_one_causes=(causes.neonatal_preterm_birth, ),
    ),
    low_birth_weight=RiskFactor(
        name='low_birth_weight',
        kind='risk_factor',
        gbd_id=rei_id(335),
        level=4,
        most_detailed=True,
        distribution=None,
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=34.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.upper_respiratory_infections, causes.otitis_media, causes.meningitis, 
                         causes.encephalitis, causes.neonatal_disorders, causes.neonatal_preterm_birth, 
                         causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                         causes.neonatal_sepsis_and_other_neonatal_infections, 
                         causes.hemolytic_disease_and_other_neonatal_jaundice, causes.other_neonatal_disorders, 
                         causes.non_communicable_diseases, causes.other_non_communicable_diseases, 
                         causes.sudden_infant_death_syndrome, causes.respiratory_infections_and_tuberculosis, 
                         causes.enteric_infections, causes.other_infectious_diseases, 
                         causes.maternal_and_neonatal_disorders, ),
        population_attributable_fraction_of_one_causes=(causes.neonatal_preterm_birth, ),
    ),
    high_temperature=RiskFactor(
        name='high_temperature',
        kind='risk_factor',
        gbd_id=rei_id(337),
        level=3,
        most_detailed=True,
        distribution='custom',
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.lower_respiratory_infections, causes.non_communicable_diseases, 
                         causes.cardiovascular_diseases, causes.ischemic_heart_disease, causes.stroke, 
                         causes.ischemic_stroke, causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.cardiomyopathy_and_myocarditis, 
                         causes.chronic_respiratory_diseases, causes.chronic_obstructive_pulmonary_disease, 
                         causes.diabetes_mellitus, causes.chronic_kidney_disease, 
                         causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, causes.injuries, 
                         causes.transport_injuries, causes.road_injuries, causes.pedestrian_road_injuries, 
                         causes.cyclist_road_injuries, causes.motorcyclist_road_injuries, 
                         causes.motor_vehicle_road_injuries, causes.other_road_injuries, 
                         causes.other_transport_injuries, causes.unintentional_injuries, causes.drowning, 
                         causes.exposure_to_mechanical_forces, causes.unintentional_firearm_injuries, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.venomous_animal_contact, causes.non_venomous_animal_contact, 
                         causes.other_unintentional_injuries_internal, causes.self_harm_and_interpersonal_violence, 
                         causes.self_harm, causes.self_harm_by_firearm, causes.self_harm_by_other_specified_means, 
                         causes.interpersonal_violence, causes.physical_violence_by_firearm, 
                         causes.physical_violence_by_sharp_object, causes.physical_violence_by_other_means, 
                         causes.exposure_to_forces_of_nature, causes.alcoholic_cardiomyopathy, causes.myocarditis, 
                         causes.other_cardiomyopathy, causes.respiratory_infections_and_tuberculosis, 
                         causes.diabetes_and_kidney_diseases, causes.diabetes_mellitus_type_1, 
                         causes.diabetes_mellitus_type_2, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, 
                         causes.other_unintentional_injuries, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    low_temperature=RiskFactor(
        name='low_temperature',
        kind='risk_factor',
        gbd_id=rei_id(338),
        level=3,
        most_detailed=True,
        distribution='custom',
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.lower_respiratory_infections, causes.non_communicable_diseases, 
                         causes.cardiovascular_diseases, causes.ischemic_heart_disease, causes.stroke, 
                         causes.ischemic_stroke, causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.hypertensive_heart_disease, causes.cardiomyopathy_and_myocarditis, 
                         causes.chronic_respiratory_diseases, causes.chronic_obstructive_pulmonary_disease, 
                         causes.diabetes_mellitus, causes.chronic_kidney_disease, 
                         causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, causes.injuries, 
                         causes.transport_injuries, causes.road_injuries, causes.pedestrian_road_injuries, 
                         causes.cyclist_road_injuries, causes.motorcyclist_road_injuries, 
                         causes.motor_vehicle_road_injuries, causes.other_road_injuries, 
                         causes.other_transport_injuries, causes.unintentional_injuries, causes.drowning, 
                         causes.exposure_to_mechanical_forces, causes.unintentional_firearm_injuries, 
                         causes.other_exposure_to_mechanical_forces, causes.animal_contact, 
                         causes.venomous_animal_contact, causes.non_venomous_animal_contact, 
                         causes.other_unintentional_injuries_internal, causes.self_harm_and_interpersonal_violence, 
                         causes.self_harm, causes.self_harm_by_firearm, causes.self_harm_by_other_specified_means, 
                         causes.interpersonal_violence, causes.physical_violence_by_firearm, 
                         causes.physical_violence_by_sharp_object, causes.physical_violence_by_other_means, 
                         causes.exposure_to_forces_of_nature, causes.alcoholic_cardiomyopathy, causes.myocarditis, 
                         causes.other_cardiomyopathy, causes.respiratory_infections_and_tuberculosis, 
                         causes.diabetes_and_kidney_diseases, causes.diabetes_mellitus_type_1, 
                         causes.diabetes_mellitus_type_2, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, 
                         causes.other_unintentional_injuries, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    low_birth_weight_and_short_gestation=RiskFactor(
        name='low_birth_weight_and_short_gestation',
        kind='risk_factor',
        gbd_id=rei_id(339),
        level=3,
        most_detailed=False,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=34.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.upper_respiratory_infections, causes.otitis_media, causes.meningitis, 
                         causes.encephalitis, causes.neonatal_disorders, causes.neonatal_preterm_birth, 
                         causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                         causes.neonatal_sepsis_and_other_neonatal_infections, 
                         causes.hemolytic_disease_and_other_neonatal_jaundice, causes.other_neonatal_disorders, 
                         causes.non_communicable_diseases, causes.other_non_communicable_diseases, 
                         causes.sudden_infant_death_syndrome, causes.respiratory_infections_and_tuberculosis, 
                         causes.enteric_infections, causes.other_infectious_diseases, 
                         causes.maternal_and_neonatal_disorders, ),
        population_attributable_fraction_of_one_causes=(causes.neonatal_preterm_birth, ),
        categories=Categories(
            cat2='Neonatal preterm and LBWSG (estimation years) - [0, 24) wks, [0, 500) g',
            cat8='Neonatal preterm and LBWSG (estimation years) - [0, 24) wks, [500, 1000) g',
            cat10='Neonatal preterm and LBWSG (estimation years) - [24, 26) wks, [500, 1000) g',
            cat11='Neonatal preterm and LBWSG (estimation years) - [26, 28) wks, [500, 1000) g',
            cat14='Neonatal preterm and LBWSG (estimation years) - [30, 32) wks, [500, 1000) g',
            cat15='Neonatal preterm and LBWSG (estimation years) - [28, 30) wks, [500, 1000) g',
            cat17='Neonatal preterm and LBWSG (estimation years) - [26, 28) wks, [1000, 1500) g',
            cat19='Neonatal preterm and LBWSG (estimation years) - [34, 36) wks, [1000, 1500) g',
            cat20='Neonatal preterm and LBWSG (estimation years) - [28, 30) wks, [1500, 2000) g',
            cat21='Neonatal preterm and LBWSG (estimation years) - [28, 30) wks, [1000, 1500) g',
            cat22='Neonatal preterm and LBWSG (estimation years) - [32, 34) wks, [1000, 1500) g',
            cat23='Neonatal preterm and LBWSG (estimation years) - [30, 32) wks, [1000, 1500) g',
            cat24='Neonatal preterm and LBWSG (estimation years) - [37, 38) wks, [1500, 2000) g',
            cat25='Neonatal preterm and LBWSG (estimation years) - [36, 37) wks, [1500, 2000) g',
            cat26='Neonatal preterm and LBWSG (estimation years) - [30, 32) wks, [2000, 2500) g',
            cat27='Neonatal preterm and LBWSG (estimation years) - [30, 32) wks, [1500, 2000) g',
            cat28='Neonatal preterm and LBWSG (estimation years) - [34, 36) wks, [1500, 2000) g',
            cat29='Neonatal preterm and LBWSG (estimation years) - [32, 34) wks, [1500, 2000) g',
            cat30='Neonatal preterm and LBWSG (estimation years) - [32, 34) wks, [2000, 2500) g',
            cat31='Neonatal preterm and LBWSG (estimation years) - [40, 42+] wks, [2000, 2500) g',
            cat32='Neonatal preterm and LBWSG (estimation years) - [38, 40) wks, [2000, 2500) g',
            cat33='Neonatal preterm and LBWSG (estimation years) - [32, 34) wks, [2500, 3000) g',
            cat34='Neonatal preterm and LBWSG (estimation years) - [34, 36) wks, [2000, 2500) g',
            cat35='Neonatal preterm and LBWSG (estimation years) - [37, 38) wks, [2000, 2500) g',
            cat36='Neonatal preterm and LBWSG (estimation years) - [36, 37) wks, [2000, 2500) g',
            cat37='Neonatal preterm and LBWSG (estimation years) - [34, 36) wks, [2500, 3000) g',
            cat38='Neonatal preterm and LBWSG (estimation years) - [34, 36) wks, [4000, 9999] g',
            cat39='Neonatal preterm and LBWSG (estimation years) - [34, 36) wks, [3000, 3500) g',
            cat40='Neonatal preterm and LBWSG (estimation years) - [36, 37) wks, [2500, 3000) g',
            cat41='Neonatal preterm and LBWSG (estimation years) - [34, 36) wks, [3500, 4000) g',
            cat42='Neonatal preterm and LBWSG (estimation years) - [37, 38) wks, [2500, 3000) g',
            cat43='Neonatal preterm and LBWSG (estimation years) - [40, 42+] wks, [2500, 3000) g',
            cat44='Neonatal preterm and LBWSG (estimation years) - [38, 40) wks, [2500, 3000) g',
            cat45='Neonatal preterm and LBWSG (estimation years) - [36, 37) wks, [3000, 3500) g',
            cat46='Neonatal preterm and LBWSG (estimation years) - [36, 37) wks, [4000, 9999] g',
            cat47='Neonatal preterm and LBWSG (estimation years) - [36, 37) wks, [3500, 4000) g',
            cat48='Neonatal preterm and LBWSG (estimation years) - [37, 38) wks, [3000, 3500) g',
            cat49='Neonatal preterm and LBWSG (estimation years) - [37, 38) wks, [4000, 9999] g',
            cat50='Neonatal preterm and LBWSG (estimation years) - [37, 38) wks, [3500, 4000) g',
            cat51='Neonatal preterm and LBWSG (estimation years) - [40, 42+] wks, [3000, 3500) g',
            cat52='Neonatal preterm and LBWSG (estimation years) - [38, 40) wks, [3000, 3500) g',
            cat53='Neonatal preterm and LBWSG (estimation years) - [38, 40) wks, [4000, 9999] g',
            cat54='Neonatal preterm and LBWSG (estimation years) - [38, 40) wks, [3500, 4000) g',
            cat55='Neonatal preterm and LBWSG (estimation years) - [40, 42+] wks, [3500, 4000) g',
            cat56='Neonatal preterm and LBWSG (estimation years) - [40, 42+] wks, [4000, 9999] g',
            cat80='Neonatal preterm and LBWSG (estimation years) - [28, 30) wks, [2000, 2500) g',
            cat81='Neonatal preterm and LBWSG (estimation years) - [28, 30) wks, [2500, 3000) g',
            cat82='Neonatal preterm and LBWSG (estimation years) - [28, 30) wks, [3000, 3500) g',
            cat88='Neonatal preterm and LBWSG (estimation years) - [30, 32) wks, [2500, 3000) g',
            cat89='Neonatal preterm and LBWSG (estimation years) - [30, 32) wks, [3000, 3500) g',
            cat90='Neonatal preterm and LBWSG (estimation years) - [30, 32) wks, [3500, 4000) g',
            cat95='Neonatal preterm and LBWSG (estimation years) - [32, 34) wks, [3000, 3500) g',
            cat96='Neonatal preterm and LBWSG (estimation years) - [32, 34) wks, [3500, 4000) g',
            cat106='Neonatal preterm and LBWSG (estimation years) - [36, 37) wks, [1000, 1500) g',
            cat116='Neonatal preterm and LBWSG (estimation years) - [38, 40) wks, [1000, 1500) g',
            cat117='Neonatal preterm and LBWSG (estimation years) - [38, 40) wks, [1500, 2000) g',
            cat123='Neonatal preterm and LBWSG (estimation years) - [40, 42+] wks, [1500, 2000) g',
            cat124='Neonatal preterm and LBWSG (estimation years) - [37, 38) wks, [1000, 1500) g',
        ),
    ),
    kidney_dysfunction=RiskFactor(
        name='kidney_dysfunction',
        kind='risk_factor',
        gbd_id=rei_id(341),
        level=2,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=388.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.lower_extremity_peripheral_arterial_disease, 
                         causes.chronic_kidney_disease, causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.musculoskeletal_disorders, causes.gout, causes.diabetes_and_kidney_diseases, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, ),
        population_attributable_fraction_of_one_causes=(causes.chronic_kidney_disease, 
                                                        causes.chronic_kidney_disease_due_to_hypertension, 
                                                        causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                                                        causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                                                        causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1, 
                                                        causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, ),
        categories=Categories(
            cat1='Stage V chronic kidney disease annual exposure',
            cat2='Stage IV chronic kidney disease annual exposure',
            cat3='Stage III chronic kidney disease annual exposure',
            cat4='Albuminuria annual exposure',
            cat5='Unexposed',
        ),
    ),
    bullying_victimization=RiskFactor(
        name='bullying_victimization',
        kind='risk_factor',
        gbd_id=rei_id(363),
        level=3,
        most_detailed=True,
        distribution='custom',
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yld_age_group_id_start=6.0,
            yld_age_group_id_end=13.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.mental_disorders, 
                         causes.depressive_disorders, causes.major_depressive_disorder, causes.anxiety_disorders, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    high_ldl_cholesterol=RiskFactor(
        name='high_ldl_cholesterol',
        kind='risk_factor',
        gbd_id=rei_id(367),
        level=2,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=10.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=10.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(0.9),
            max=scalar(1.4),
            inverted=False,
        ),
        relative_risk_scalar=scalar(1),
    ),
    high_body_mass_index_in_adults=RiskFactor(
        name='high_body_mass_index_in_adults',
        kind='risk_factor',
        gbd_id=rei_id(370),
        level=3,
        most_detailed=True,
        distribution='ensemble',
        population_attributable_fraction_calculation_type='continuous',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=9.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.tuberculosis, causes.non_communicable_diseases, causes.neoplasms, 
                         causes.liver_cancer, causes.liver_cancer_due_to_hepatitis_b, 
                         causes.liver_cancer_due_to_hepatitis_c, causes.liver_cancer_due_to_alcohol_use, 
                         causes.liver_cancer_due_to_other_causes, causes.breast_cancer, causes.uterine_cancer, 
                         causes.colon_and_rectum_cancer, causes.gallbladder_and_biliary_tract_cancer, 
                         causes.pancreatic_cancer, causes.ovarian_cancer, causes.kidney_cancer, 
                         causes.thyroid_cancer, causes.non_hodgkin_lymphoma, causes.multiple_myeloma, 
                         causes.leukemia, causes.cardiovascular_diseases, causes.ischemic_heart_disease, 
                         causes.stroke, causes.ischemic_stroke, causes.intracerebral_hemorrhage, 
                         causes.subarachnoid_hemorrhage, causes.hypertensive_heart_disease, 
                         causes.atrial_fibrillation_and_flutter, causes.aortic_aneurysm, 
                         causes.lower_extremity_peripheral_arterial_disease, causes.chronic_respiratory_diseases, 
                         causes.asthma, causes.digestive_diseases, causes.gallbladder_and_biliary_diseases, 
                         causes.neurological_disorders, causes.alzheimers_disease_and_other_dementias, 
                         causes.diabetes_mellitus, causes.chronic_kidney_disease, 
                         causes.chronic_kidney_disease_due_to_hypertension, 
                         causes.chronic_kidney_disease_due_to_glomerulonephritis, 
                         causes.chronic_kidney_disease_due_to_other_and_unspecified_causes, 
                         causes.musculoskeletal_disorders, causes.osteoarthritis, causes.low_back_pain, causes.gout, 
                         causes.sense_organ_diseases, causes.cataract, causes.acute_lymphoid_leukemia, 
                         causes.chronic_lymphoid_leukemia, causes.acute_myeloid_leukemia, 
                         causes.chronic_myeloid_leukemia, causes.drug_susceptible_tuberculosis, 
                         causes.other_leukemia, 
                         causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, 
                         causes.extensively_drug_resistant_tuberculosis, 
                         causes.respiratory_infections_and_tuberculosis, causes.diabetes_and_kidney_diseases, 
                         causes.diabetes_mellitus_type_2, causes.blindness_and_vision_loss, 
                         causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, causes.burkitt_lymphoma, 
                         causes.other_non_hodgkin_lymphoma, causes.osteoarthritis_hip, causes.osteoarthritis_knee, 
                         causes.total_burden_related_to_hepatitis_b, causes.total_burden_related_to_hepatitis_c, 
                         causes.total_cancers, causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        tmred=Tmred(
            distribution='uniform',
            min=scalar(20),
            max=scalar(22.5),
            inverted=False,
        ),
        relative_risk_scalar=scalar(5),
    ),
    high_body_mass_index_in_children=RiskFactor(
        name='high_body_mass_index_in_children',
        kind='risk_factor',
        gbd_id=rei_id(371),
        level=3,
        most_detailed=True,
        distribution='ordered_polytomous',
        population_attributable_fraction_calculation_type='categorical',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=238.0,
            yll_age_group_id_end=8.0,
            yld_age_group_id_start=238.0,
            yld_age_group_id_end=8.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.chronic_respiratory_diseases, 
                         causes.asthma, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat1='Prevalence of obesity (Children)',
            cat2='Prevalence of overweight only (Children)',
            cat3='Unexposed',
        ),
    ),
    particulate_matter_pollution=RiskFactor(
        name='particulate_matter_pollution',
        kind='risk_factor',
        gbd_id=rei_id(380),
        level=3,
        most_detailed=False,
        distribution='custom',
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.communicable_maternal_neonatal_and_nutritional_diseases, 
                         causes.diarrheal_diseases, causes.lower_respiratory_infections, 
                         causes.upper_respiratory_infections, causes.otitis_media, causes.meningitis, 
                         causes.encephalitis, causes.neonatal_disorders, causes.neonatal_preterm_birth, 
                         causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                         causes.neonatal_sepsis_and_other_neonatal_infections, 
                         causes.hemolytic_disease_and_other_neonatal_jaundice, causes.other_neonatal_disorders, 
                         causes.non_communicable_diseases, causes.neoplasms, 
                         causes.tracheal_bronchus_and_lung_cancer, causes.cardiovascular_diseases, 
                         causes.ischemic_heart_disease, causes.stroke, causes.ischemic_stroke, 
                         causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, 
                         causes.chronic_respiratory_diseases, causes.chronic_obstructive_pulmonary_disease, 
                         causes.diabetes_mellitus, causes.other_non_communicable_diseases, 
                         causes.sense_organ_diseases, causes.cataract, causes.sudden_infant_death_syndrome, 
                         causes.respiratory_infections_and_tuberculosis, causes.enteric_infections, 
                         causes.other_infectious_diseases, causes.maternal_and_neonatal_disorders, 
                         causes.diabetes_and_kidney_diseases, causes.diabetes_mellitus_type_2, 
                         causes.blindness_and_vision_loss, causes.total_cancers, 
                         causes.total_cancers_excluding_non_melanoma_skin_cancer, ),
        population_attributable_fraction_of_one_causes=(),
        categories=Categories(
            cat2='Particulate matter pollution shifted birth prevalence - [0, 24) wks, [0, 500) g',
            cat8='Particulate matter pollution shifted birth prevalence - [0, 24) wks, [500, 1000) g',
            cat10='Particulate matter pollution shifted birth prevalence - [24, 26) wks, [500, 1000) g',
            cat11='Particulate matter pollution shifted birth prevalence - [26, 28) wks, [500, 1000) g',
            cat14='Particulate matter pollution shifted birth prevalence - [30, 32) wks, [500, 1000) g',
            cat15='Particulate matter pollution shifted birth prevalence - [28, 30) wks, [500, 1000) g',
            cat17='Particulate matter pollution shifted birth prevalence - [26, 28) wks, [1000, 1500) g',
            cat19='Particulate matter pollution shifted birth prevalence - [34, 36) wks, [1000, 1500) g',
            cat20='Particulate matter pollution shifted birth prevalence - [28, 30) wks, [1500, 2000) g',
            cat21='Particulate matter pollution shifted birth prevalence - [28, 30) wks, [1000, 1500) g',
            cat22='Particulate matter pollution shifted birth prevalence - [32, 34) wks, [1000, 1500) g',
            cat23='Particulate matter pollution shifted birth prevalence - [30, 32) wks, [1000, 1500) g',
            cat24='Particulate matter pollution shifted birth prevalence - [37, 38) wks, [1500, 2000) g',
            cat25='Particulate matter pollution shifted birth prevalence - [36, 37) wks, [1500, 2000) g',
            cat26='Particulate matter pollution shifted birth prevalence - [30, 32) wks, [2000, 2500) g',
            cat27='Particulate matter pollution shifted birth prevalence - [30, 32) wks, [1500, 2000) g',
            cat28='Particulate matter pollution shifted birth prevalence - [34, 36) wks, [1500, 2000) g',
            cat29='Particulate matter pollution shifted birth prevalence - [32, 34) wks, [1500, 2000) g',
            cat30='Particulate matter pollution shifted birth prevalence - [32, 34) wks, [2000, 2500) g',
            cat31='Particulate matter pollution shifted birth prevalence - [40, 42+] wks, [2000, 2500) g',
            cat32='Particulate matter pollution shifted birth prevalence - [38, 40) wks, [2000, 2500) g',
            cat33='Particulate matter pollution shifted birth prevalence - [32, 34) wks, [2500, 3000) g',
            cat34='Particulate matter pollution shifted birth prevalence - [34, 36) wks, [2000, 2500) g',
            cat35='Particulate matter pollution shifted birth prevalence - [37, 38) wks, [2000, 2500) g',
            cat36='Particulate matter pollution shifted birth prevalence - [36, 37) wks, [2000, 2500) g',
            cat37='Particulate matter pollution shifted birth prevalence - [34, 36) wks, [2500, 3000) g',
            cat38='Particulate matter pollution shifted birth prevalence - [34, 36) wks, [4000, 9999] g',
            cat39='Particulate matter pollution shifted birth prevalence - [34, 36) wks, [3000, 3500) g',
            cat40='Particulate matter pollution shifted birth prevalence - [36, 37) wks, [2500, 3000) g',
            cat41='Particulate matter pollution shifted birth prevalence - [34, 36) wks, [3500, 4000) g',
            cat42='Particulate matter pollution shifted birth prevalence - [37, 38) wks, [2500, 3000) g',
            cat43='Particulate matter pollution shifted birth prevalence - [40, 42+] wks, [2500, 3000) g',
            cat44='Particulate matter pollution shifted birth prevalence - [38, 40) wks, [2500, 3000) g',
            cat45='Particulate matter pollution shifted birth prevalence - [36, 37) wks, [3000, 3500) g',
            cat46='Particulate matter pollution shifted birth prevalence - [36, 37) wks, [4000, 9999] g',
            cat47='Particulate matter pollution shifted birth prevalence - [36, 37) wks, [3500, 4000) g',
            cat48='Particulate matter pollution shifted birth prevalence - [37, 38) wks, [3000, 3500) g',
            cat49='Particulate matter pollution shifted birth prevalence - [37, 38) wks, [4000, 9999] g',
            cat50='Particulate matter pollution shifted birth prevalence - [37, 38) wks, [3500, 4000) g',
            cat51='Particulate matter pollution shifted birth prevalence - [40, 42+] wks, [3000, 3500) g',
            cat52='Particulate matter pollution shifted birth prevalence - [38, 40) wks, [3000, 3500) g',
            cat53='Particulate matter pollution shifted birth prevalence - [38, 40) wks, [4000, 9999] g',
            cat54='Particulate matter pollution shifted birth prevalence - [38, 40) wks, [3500, 4000) g',
            cat55='Particulate matter pollution shifted birth prevalence - [40, 42+] wks, [3500, 4000) g',
            cat56='Particulate matter pollution shifted birth prevalence - [40, 42+] wks, [4000, 9999] g',
            cat80='Particulate matter pollution shifted birth prevalence - [28, 30) wks, [2000, 2500) g',
            cat81='Particulate matter pollution shifted birth prevalence - [28, 30) wks, [2500, 3000) g',
            cat82='Particulate matter pollution shifted birth prevalence - [28, 30) wks, [3000, 3500) g',
            cat88='Particulate matter pollution shifted birth prevalence - [30, 32) wks, [2500, 3000) g',
            cat89='Particulate matter pollution shifted birth prevalence - [30, 32) wks, [3000, 3500) g',
            cat90='Particulate matter pollution shifted birth prevalence - [30, 32) wks, [3500, 4000) g',
            cat95='Particulate matter pollution shifted birth prevalence - [32, 34) wks, [3000, 3500) g',
            cat96='Particulate matter pollution shifted birth prevalence - [32, 34) wks, [3500, 4000) g',
            cat106='Particulate matter pollution shifted birth prevalence - [36, 37) wks, [1000, 1500) g',
            cat116='Particulate matter pollution shifted birth prevalence - [38, 40) wks, [1000, 1500) g',
            cat117='Particulate matter pollution shifted birth prevalence - [38, 40) wks, [1500, 2000) g',
            cat123='Particulate matter pollution shifted birth prevalence - [40, 42+] wks, [1500, 2000) g',
            cat124='Particulate matter pollution shifted birth prevalence - [37, 38) wks, [1000, 1500) g',
        ),
    ),
    childhood_sexual_abuse_and_bullying=RiskFactor(
        name='childhood_sexual_abuse_and_bullying',
        kind='risk_factor',
        gbd_id=rei_id(381),
        level=2,
        most_detailed=False,
        distribution=None,
        population_attributable_fraction_calculation_type='aggregation',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8.0,
            yll_age_group_id_end=235.0,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=235.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.mental_disorders, 
                         causes.alcohol_use_disorders, causes.depressive_disorders, causes.major_depressive_disorder, 
                         causes.anxiety_disorders, causes.substance_use_disorders, ),
        population_attributable_fraction_of_one_causes=(),
    ),
    nitrogen_dioxide_pollution=RiskFactor(
        name='nitrogen_dioxide_pollution',
        kind='risk_factor',
        gbd_id=rei_id(404),
        level=3,
        most_detailed=True,
        distribution=None,
        population_attributable_fraction_calculation_type='custom',
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yld_age_group_id_start=2.0,
            yld_age_group_id_end=8.0,
        ),
        affected_causes=(causes.all_causes, causes.non_communicable_diseases, causes.chronic_respiratory_diseases, 
                         causes.asthma, ),
        population_attributable_fraction_of_one_causes=(),
    ),
)
risk_factors.unsafe_water_sanitation_and_handwashing.parent = risk_factors.environmental_occupational_risks
risk_factors.unsafe_water_sanitation_and_handwashing.sub_risk_factors = (risk_factors.unsafe_water_source,
                                                                         risk_factors.unsafe_sanitation,
                                                                         risk_factors.no_access_to_handwashing_facility,
                                                                         )

risk_factors.unsafe_water_source.parent = risk_factors.unsafe_water_sanitation_and_handwashing

risk_factors.unsafe_sanitation.parent = risk_factors.unsafe_water_sanitation_and_handwashing

risk_factors.air_pollution.parent = risk_factors.environmental_occupational_risks
risk_factors.air_pollution.sub_risk_factors = (risk_factors.ambient_ozone_pollution,
                                               risk_factors.particulate_matter_pollution,
                                               risk_factors.nitrogen_dioxide_pollution, )

risk_factors.ambient_particulate_matter_pollution.parent = risk_factors.particulate_matter_pollution

risk_factors.household_air_pollution_from_solid_fuels.parent = risk_factors.particulate_matter_pollution

risk_factors.ambient_ozone_pollution.parent = risk_factors.air_pollution

risk_factors.other_environmental_risks.parent = risk_factors.environmental_occupational_risks
risk_factors.other_environmental_risks.sub_risk_factors = (risk_factors.residential_radon, risk_factors.lead_exposure,
                                                           )

risk_factors.residential_radon.parent = risk_factors.other_environmental_risks

risk_factors.lead_exposure.parent = risk_factors.other_environmental_risks
risk_factors.lead_exposure.sub_risk_factors = (risk_factors.lead_exposure_in_blood, risk_factors.lead_exposure_in_bone,
                                               )

risk_factors.child_and_maternal_malnutrition.parent = risk_factors.behavioral_risks
risk_factors.child_and_maternal_malnutrition.sub_risk_factors = (risk_factors.suboptimal_breastfeeding,
                                                                 risk_factors.iron_deficiency,
                                                                 risk_factors.vitamin_a_deficiency,
                                                                 risk_factors.zinc_deficiency,
                                                                 risk_factors.child_growth_failure,
                                                                 risk_factors.low_birth_weight_and_short_gestation, )

risk_factors.suboptimal_breastfeeding.parent = risk_factors.child_and_maternal_malnutrition
risk_factors.suboptimal_breastfeeding.sub_risk_factors = (risk_factors.non_exclusive_breastfeeding,
                                                          risk_factors.discontinued_breastfeeding, )

risk_factors.child_underweight.parent = risk_factors.child_growth_failure

risk_factors.iron_deficiency.parent = risk_factors.child_and_maternal_malnutrition

risk_factors.vitamin_a_deficiency.parent = risk_factors.child_and_maternal_malnutrition

risk_factors.zinc_deficiency.parent = risk_factors.child_and_maternal_malnutrition

risk_factors.tobacco.parent = risk_factors.behavioral_risks
risk_factors.tobacco.sub_risk_factors = (risk_factors.smoking, risk_factors.secondhand_smoke,
                                         risk_factors.chewing_tobacco, )

risk_factors.smoking.parent = risk_factors.tobacco
risk_factors.smoking.affected_risk_factors = (risk_factors.high_fasting_plasma_glucose, )

risk_factors.secondhand_smoke.parent = risk_factors.tobacco

risk_factors.high_alcohol_use.parent = risk_factors.behavioral_risks

risk_factors.drug_use.parent = risk_factors.behavioral_risks
risk_factors.drug_use.sub_risk_factors = (risk_factors.injected_drug_use, risk_factors.drug_dependence, )

risk_factors.metabolic_risks.parent = risk_factors.all_risk_factors
risk_factors.metabolic_risks.sub_risk_factors = (risk_factors.high_fasting_plasma_glucose,
                                                 risk_factors.high_systolic_blood_pressure,
                                                 risk_factors.high_body_mass_index,
                                                 risk_factors.low_bone_mineral_density,
                                                 risk_factors.kidney_dysfunction, risk_factors.high_ldl_cholesterol, )

risk_factors.high_fasting_plasma_glucose.parent = risk_factors.metabolic_risks
risk_factors.high_fasting_plasma_glucose.affected_risk_factors = (risk_factors.high_ldl_cholesterol, )

risk_factors.high_systolic_blood_pressure.parent = risk_factors.metabolic_risks

risk_factors.high_body_mass_index.parent = risk_factors.metabolic_risks
risk_factors.high_body_mass_index.sub_risk_factors = (risk_factors.high_body_mass_index_in_adults,
                                                      risk_factors.high_body_mass_index_in_children, )

risk_factors.low_bone_mineral_density.parent = risk_factors.metabolic_risks

risk_factors.dietary_risks.parent = risk_factors.behavioral_risks
risk_factors.dietary_risks.sub_risk_factors = (risk_factors.diet_low_in_fruits, risk_factors.diet_low_in_vegetables,
                                               risk_factors.diet_low_in_whole_grains,
                                               risk_factors.diet_low_in_nuts_and_seeds, risk_factors.diet_low_in_milk,
                                               risk_factors.diet_high_in_red_meat,
                                               risk_factors.diet_high_in_processed_meat,
                                               risk_factors.diet_high_in_sugar_sweetened_beverages,
                                               risk_factors.diet_low_in_fiber,
                                               risk_factors.diet_low_in_seafood_omega_3_fatty_acids,
                                               risk_factors.diet_low_in_omega_6_polyunsaturated_fatty_acids,
                                               risk_factors.diet_high_in_trans_fatty_acids,
                                               risk_factors.diet_high_in_sodium, risk_factors.diet_low_in_calcium,
                                               risk_factors.diet_low_in_legumes, )

risk_factors.diet_low_in_fruits.parent = risk_factors.dietary_risks
risk_factors.diet_low_in_fruits.affected_risk_factors = (risk_factors.high_fasting_plasma_glucose,
                                                         risk_factors.high_systolic_blood_pressure,
                                                         risk_factors.high_ldl_cholesterol, )

risk_factors.diet_low_in_vegetables.parent = risk_factors.dietary_risks
risk_factors.diet_low_in_vegetables.affected_risk_factors = (risk_factors.high_fasting_plasma_glucose,
                                                             risk_factors.high_systolic_blood_pressure,
                                                             risk_factors.high_ldl_cholesterol, )

risk_factors.diet_low_in_whole_grains.parent = risk_factors.dietary_risks
risk_factors.diet_low_in_whole_grains.affected_risk_factors = (risk_factors.high_fasting_plasma_glucose,
                                                               risk_factors.high_ldl_cholesterol, )

risk_factors.diet_low_in_nuts_and_seeds.parent = risk_factors.dietary_risks
risk_factors.diet_low_in_nuts_and_seeds.affected_risk_factors = (risk_factors.high_ldl_cholesterol, )

risk_factors.diet_low_in_milk.parent = risk_factors.dietary_risks
risk_factors.diet_low_in_milk.affected_risk_factors = (risk_factors.diet_low_in_calcium, )

risk_factors.diet_high_in_red_meat.parent = risk_factors.dietary_risks
risk_factors.diet_high_in_red_meat.affected_risk_factors = (risk_factors.high_fasting_plasma_glucose, )

risk_factors.diet_high_in_processed_meat.parent = risk_factors.dietary_risks
risk_factors.diet_high_in_processed_meat.affected_risk_factors = (risk_factors.high_fasting_plasma_glucose, )

risk_factors.diet_high_in_sugar_sweetened_beverages.parent = risk_factors.dietary_risks
risk_factors.diet_high_in_sugar_sweetened_beverages.affected_risk_factors = (risk_factors.high_fasting_plasma_glucose,
                                                                             )

risk_factors.diet_low_in_fiber.parent = risk_factors.dietary_risks

risk_factors.diet_low_in_seafood_omega_3_fatty_acids.parent = risk_factors.dietary_risks

risk_factors.diet_low_in_omega_6_polyunsaturated_fatty_acids.parent = risk_factors.dietary_risks
risk_factors.diet_low_in_omega_6_polyunsaturated_fatty_acids.affected_risk_factors = (risk_factors.high_ldl_cholesterol,
                                                                                      )

risk_factors.diet_high_in_trans_fatty_acids.parent = risk_factors.dietary_risks
risk_factors.diet_high_in_trans_fatty_acids.affected_risk_factors = (risk_factors.high_ldl_cholesterol, )

risk_factors.diet_high_in_sodium.parent = risk_factors.dietary_risks
risk_factors.diet_high_in_sodium.affected_risk_factors = (risk_factors.high_systolic_blood_pressure, )

risk_factors.low_physical_activity.parent = risk_factors.behavioral_risks
risk_factors.low_physical_activity.affected_risk_factors = (risk_factors.high_fasting_plasma_glucose, )

risk_factors.occupational_risks.parent = risk_factors.environmental_occupational_risks
risk_factors.occupational_risks.sub_risk_factors = (risk_factors.occupational_carcinogens,
                                                    risk_factors.occupational_asthmagens,
                                                    risk_factors.occupational_particulate_matter_gases_and_fumes,
                                                    risk_factors.occupational_noise,
                                                    risk_factors.occupational_injuries,
                                                    risk_factors.occupational_ergonomic_factors, )

risk_factors.occupational_carcinogens.parent = risk_factors.occupational_risks
risk_factors.occupational_carcinogens.sub_risk_factors = (risk_factors.occupational_exposure_to_asbestos,
                                                          risk_factors.occupational_exposure_to_arsenic,
                                                          risk_factors.occupational_exposure_to_benzene,
                                                          risk_factors.occupational_exposure_to_beryllium,
                                                          risk_factors.occupational_exposure_to_cadmium,
                                                          risk_factors.occupational_exposure_to_chromium,
                                                          risk_factors.occupational_exposure_to_diesel_engine_exhaust,
                                                          risk_factors.occupational_exposure_to_formaldehyde,
                                                          risk_factors.occupational_exposure_to_nickel,
                                                          risk_factors.occupational_exposure_to_polycyclic_aromatic_hydrocarbons,
                                                          risk_factors.occupational_exposure_to_silica,
                                                          risk_factors.occupational_exposure_to_sulfuric_acid,
                                                          risk_factors.occupational_exposure_to_trichloroethylene, )

risk_factors.occupational_asthmagens.parent = risk_factors.occupational_risks

risk_factors.occupational_particulate_matter_gases_and_fumes.parent = risk_factors.occupational_risks

risk_factors.occupational_noise.parent = risk_factors.occupational_risks

risk_factors.occupational_injuries.parent = risk_factors.occupational_risks

risk_factors.occupational_ergonomic_factors.parent = risk_factors.occupational_risks

risk_factors.childhood_sexual_abuse.parent = risk_factors.childhood_sexual_abuse_and_bullying
risk_factors.childhood_sexual_abuse.sub_risk_factors = (risk_factors.childhood_sexual_abuse_against_females,
                                                        risk_factors.childhood_sexual_abuse_against_males, )

risk_factors.intimate_partner_violence.parent = risk_factors.behavioral_risks
risk_factors.intimate_partner_violence.sub_risk_factors = (risk_factors.intimate_partner_violence_exposure_approach,
                                                           risk_factors.intimate_partner_violence_direct_paf_approach,
                                                           risk_factors.intimate_partner_violence_hiv_paf_approach, )

risk_factors.non_exclusive_breastfeeding.parent = risk_factors.suboptimal_breastfeeding

risk_factors.discontinued_breastfeeding.parent = risk_factors.suboptimal_breastfeeding

risk_factors.injected_drug_use.parent = risk_factors.drug_use

risk_factors.drug_dependence.parent = risk_factors.drug_use

risk_factors.diet_low_in_calcium.parent = risk_factors.dietary_risks

risk_factors.occupational_exposure_to_asbestos.parent = risk_factors.occupational_carcinogens

risk_factors.occupational_exposure_to_arsenic.parent = risk_factors.occupational_carcinogens

risk_factors.occupational_exposure_to_benzene.parent = risk_factors.occupational_carcinogens

risk_factors.occupational_exposure_to_beryllium.parent = risk_factors.occupational_carcinogens

risk_factors.occupational_exposure_to_cadmium.parent = risk_factors.occupational_carcinogens

risk_factors.occupational_exposure_to_chromium.parent = risk_factors.occupational_carcinogens

risk_factors.occupational_exposure_to_diesel_engine_exhaust.parent = risk_factors.occupational_carcinogens

risk_factors.occupational_exposure_to_formaldehyde.parent = risk_factors.occupational_carcinogens

risk_factors.occupational_exposure_to_nickel.parent = risk_factors.occupational_carcinogens

risk_factors.occupational_exposure_to_polycyclic_aromatic_hydrocarbons.parent = risk_factors.occupational_carcinogens

risk_factors.occupational_exposure_to_silica.parent = risk_factors.occupational_carcinogens

risk_factors.occupational_exposure_to_sulfuric_acid.parent = risk_factors.occupational_carcinogens

risk_factors.intimate_partner_violence_exposure_approach.parent = risk_factors.intimate_partner_violence

risk_factors.intimate_partner_violence_direct_paf_approach.parent = risk_factors.intimate_partner_violence

risk_factors.unsafe_sex.parent = risk_factors.behavioral_risks

risk_factors.intimate_partner_violence_hiv_paf_approach.parent = risk_factors.intimate_partner_violence

risk_factors.environmental_occupational_risks.parent = risk_factors.all_risk_factors
risk_factors.environmental_occupational_risks.sub_risk_factors = (risk_factors.unsafe_water_sanitation_and_handwashing,
                                                                  risk_factors.air_pollution,
                                                                  risk_factors.other_environmental_risks,
                                                                  risk_factors.occupational_risks,
                                                                  risk_factors.non_optimal_temperature, )

risk_factors.behavioral_risks.parent = risk_factors.all_risk_factors
risk_factors.behavioral_risks.sub_risk_factors = (risk_factors.child_and_maternal_malnutrition, risk_factors.tobacco,
                                                  risk_factors.high_alcohol_use, risk_factors.drug_use,
                                                  risk_factors.dietary_risks, risk_factors.low_physical_activity,
                                                  risk_factors.intimate_partner_violence, risk_factors.unsafe_sex,
                                                  risk_factors.childhood_sexual_abuse_and_bullying, )

risk_factors.occupational_exposure_to_trichloroethylene.parent = risk_factors.occupational_carcinogens

risk_factors.no_access_to_handwashing_facility.parent = risk_factors.unsafe_water_sanitation_and_handwashing

risk_factors.child_growth_failure.parent = risk_factors.child_and_maternal_malnutrition
risk_factors.child_growth_failure.sub_risk_factors = (risk_factors.child_underweight, risk_factors.child_wasting,
                                                      risk_factors.child_stunting, )

risk_factors.child_wasting.parent = risk_factors.child_growth_failure

risk_factors.child_stunting.parent = risk_factors.child_growth_failure

risk_factors.lead_exposure_in_blood.parent = risk_factors.lead_exposure

risk_factors.lead_exposure_in_bone.parent = risk_factors.lead_exposure
risk_factors.lead_exposure_in_bone.affected_risk_factors = (risk_factors.high_systolic_blood_pressure, )

risk_factors.childhood_sexual_abuse_against_females.parent = risk_factors.childhood_sexual_abuse
risk_factors.childhood_sexual_abuse_against_females.affected_risk_factors = (risk_factors.high_alcohol_use, )

risk_factors.childhood_sexual_abuse_against_males.parent = risk_factors.childhood_sexual_abuse
risk_factors.childhood_sexual_abuse_against_males.affected_risk_factors = (risk_factors.high_alcohol_use, )

risk_factors.non_optimal_temperature.parent = risk_factors.environmental_occupational_risks
risk_factors.non_optimal_temperature.sub_risk_factors = (risk_factors.high_temperature, risk_factors.low_temperature,
                                                         )

risk_factors.chewing_tobacco.parent = risk_factors.tobacco

risk_factors.diet_low_in_legumes.parent = risk_factors.dietary_risks

risk_factors.short_gestation.parent = risk_factors.low_birth_weight_and_short_gestation

risk_factors.low_birth_weight.parent = risk_factors.low_birth_weight_and_short_gestation

risk_factors.high_temperature.parent = risk_factors.non_optimal_temperature

risk_factors.low_temperature.parent = risk_factors.non_optimal_temperature

risk_factors.low_birth_weight_and_short_gestation.parent = risk_factors.child_and_maternal_malnutrition
risk_factors.low_birth_weight_and_short_gestation.sub_risk_factors = (risk_factors.short_gestation,
                                                                      risk_factors.low_birth_weight, )

risk_factors.kidney_dysfunction.parent = risk_factors.metabolic_risks

risk_factors.bullying_victimization.parent = risk_factors.childhood_sexual_abuse_and_bullying

risk_factors.high_ldl_cholesterol.parent = risk_factors.metabolic_risks

risk_factors.high_body_mass_index_in_adults.parent = risk_factors.high_body_mass_index
risk_factors.high_body_mass_index_in_adults.affected_risk_factors = (risk_factors.high_fasting_plasma_glucose,
                                                                     risk_factors.high_systolic_blood_pressure,
                                                                     risk_factors.high_ldl_cholesterol, )

risk_factors.high_body_mass_index_in_children.parent = risk_factors.high_body_mass_index

risk_factors.particulate_matter_pollution.parent = risk_factors.air_pollution
risk_factors.particulate_matter_pollution.sub_risk_factors = (risk_factors.ambient_particulate_matter_pollution,
                                                              risk_factors.household_air_pollution_from_solid_fuels, )

risk_factors.childhood_sexual_abuse_and_bullying.parent = risk_factors.behavioral_risks
risk_factors.childhood_sexual_abuse_and_bullying.sub_risk_factors = (risk_factors.childhood_sexual_abuse,
                                                                     risk_factors.bullying_victimization, )

risk_factors.nitrogen_dioxide_pollution.parent = risk_factors.air_pollution

