"""Mapping templates for GBD etiologies.

This code is automatically generated by gbd_mapping_generator/etiology_builder.py

Any manual changes will be lost.
"""
from .base_template import GbdRecord, ModelableEntity
from .id import rei_id


class Etiology(ModelableEntity):
    """Container for etiology GBD ids and metadata."""
    __slots__ = ('name', 'kind', 'gbd_id', )

    def __init__(self,
                 name: str,
                 kind: str,
                 gbd_id: rei_id | None, ):
        super().__init__(name=name,
                         kind=kind,
                         gbd_id=gbd_id)
        self.name = name
        self.kind = kind
        self.gbd_id = gbd_id


class Etiologies(GbdRecord):
    """Container for GBD etiologies."""
    __slots__ = ('cholera', 'non_typhoidal_salmonella', 'shigella', 'enteropathogenic_e_coli',
                 'enterotoxigenic_e_coli', 'campylobacter', 'entamoeba', 'cryptosporidium', 'rotavirus', 'aeromonas',
                 'clostridium_difficile', 'norovirus', 'adenovirus', 'influenza', 'respiratory_syncytial_virus',
                 'group_b_streptococcus', 'acinetobacter_baumannii', 'chlamydia_spp', 'enterobacter_spp',
                 'escherichia_coli', 'fungus', 'haemophilus_influenzae', 'klebsiella_pneumoniae', 'legionella_spp',
                 'listeria_monocytogenes', 'mycoplasma', 'other_bacterial_pathogen', 'other_viral_etiologies_of_lri',
                 'polymicrobial', 'pseudomonas_aeruginosa', 'staphylococcus_aureus',
                 'viral_etiologies_of_meningitis', 'streptococcus_pneumoniae', 'neisseria_meningitidis', )

    def __init__(self,
                 cholera: Etiology,
                 non_typhoidal_salmonella: Etiology,
                 shigella: Etiology,
                 enteropathogenic_e_coli: Etiology,
                 enterotoxigenic_e_coli: Etiology,
                 campylobacter: Etiology,
                 entamoeba: Etiology,
                 cryptosporidium: Etiology,
                 rotavirus: Etiology,
                 aeromonas: Etiology,
                 clostridium_difficile: Etiology,
                 norovirus: Etiology,
                 adenovirus: Etiology,
                 influenza: Etiology,
                 respiratory_syncytial_virus: Etiology,
                 group_b_streptococcus: Etiology,
                 acinetobacter_baumannii: Etiology,
                 chlamydia_spp: Etiology,
                 enterobacter_spp: Etiology,
                 escherichia_coli: Etiology,
                 fungus: Etiology,
                 haemophilus_influenzae: Etiology,
                 klebsiella_pneumoniae: Etiology,
                 legionella_spp: Etiology,
                 listeria_monocytogenes: Etiology,
                 mycoplasma: Etiology,
                 other_bacterial_pathogen: Etiology,
                 other_viral_etiologies_of_lri: Etiology,
                 polymicrobial: Etiology,
                 pseudomonas_aeruginosa: Etiology,
                 staphylococcus_aureus: Etiology,
                 viral_etiologies_of_meningitis: Etiology,
                 streptococcus_pneumoniae: Etiology,
                 neisseria_meningitidis: Etiology, ):
        super().__init__()
        self.cholera = cholera
        self.non_typhoidal_salmonella = non_typhoidal_salmonella
        self.shigella = shigella
        self.enteropathogenic_e_coli = enteropathogenic_e_coli
        self.enterotoxigenic_e_coli = enterotoxigenic_e_coli
        self.campylobacter = campylobacter
        self.entamoeba = entamoeba
        self.cryptosporidium = cryptosporidium
        self.rotavirus = rotavirus
        self.aeromonas = aeromonas
        self.clostridium_difficile = clostridium_difficile
        self.norovirus = norovirus
        self.adenovirus = adenovirus
        self.influenza = influenza
        self.respiratory_syncytial_virus = respiratory_syncytial_virus
        self.group_b_streptococcus = group_b_streptococcus
        self.acinetobacter_baumannii = acinetobacter_baumannii
        self.chlamydia_spp = chlamydia_spp
        self.enterobacter_spp = enterobacter_spp
        self.escherichia_coli = escherichia_coli
        self.fungus = fungus
        self.haemophilus_influenzae = haemophilus_influenzae
        self.klebsiella_pneumoniae = klebsiella_pneumoniae
        self.legionella_spp = legionella_spp
        self.listeria_monocytogenes = listeria_monocytogenes
        self.mycoplasma = mycoplasma
        self.other_bacterial_pathogen = other_bacterial_pathogen
        self.other_viral_etiologies_of_lri = other_viral_etiologies_of_lri
        self.polymicrobial = polymicrobial
        self.pseudomonas_aeruginosa = pseudomonas_aeruginosa
        self.staphylococcus_aureus = staphylococcus_aureus
        self.viral_etiologies_of_meningitis = viral_etiologies_of_meningitis
        self.streptococcus_pneumoniae = streptococcus_pneumoniae
        self.neisseria_meningitidis = neisseria_meningitidis
