# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AvailableTimeOffRange(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AvailableTimeOffRange - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'time_off_limit': 'TimeOffLimitReference',
            'start_date': 'date',
            'granularity': 'str',
            'available_minutes_per_interval': 'list[int]',
            'waitlisted_requests_per_interval': 'list[int]',
            'waitlist_enabled': 'bool'
        }

        self.attribute_map = {
            'time_off_limit': 'timeOffLimit',
            'start_date': 'startDate',
            'granularity': 'granularity',
            'available_minutes_per_interval': 'availableMinutesPerInterval',
            'waitlisted_requests_per_interval': 'waitlistedRequestsPerInterval',
            'waitlist_enabled': 'waitlistEnabled'
        }

        self._time_off_limit = None
        self._start_date = None
        self._granularity = None
        self._available_minutes_per_interval = None
        self._waitlisted_requests_per_interval = None
        self._waitlist_enabled = None

    @property
    def time_off_limit(self):
        """
        Gets the time_off_limit of this AvailableTimeOffRange.
        The time off limit

        :return: The time_off_limit of this AvailableTimeOffRange.
        :rtype: TimeOffLimitReference
        """
        return self._time_off_limit

    @time_off_limit.setter
    def time_off_limit(self, time_off_limit):
        """
        Sets the time_off_limit of this AvailableTimeOffRange.
        The time off limit

        :param time_off_limit: The time_off_limit of this AvailableTimeOffRange.
        :type: TimeOffLimitReference
        """
        
        self._time_off_limit = time_off_limit

    @property
    def start_date(self):
        """
        Gets the start_date of this AvailableTimeOffRange.
        Start date of the requested date range. The end date is determined by the size of interval list. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The start_date of this AvailableTimeOffRange.
        :rtype: date
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this AvailableTimeOffRange.
        Start date of the requested date range. The end date is determined by the size of interval list. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param start_date: The start_date of this AvailableTimeOffRange.
        :type: date
        """
        
        self._start_date = start_date

    @property
    def granularity(self):
        """
        Gets the granularity of this AvailableTimeOffRange.
        Granularity choice for time off limit

        :return: The granularity of this AvailableTimeOffRange.
        :rtype: str
        """
        return self._granularity

    @granularity.setter
    def granularity(self, granularity):
        """
        Sets the granularity of this AvailableTimeOffRange.
        Granularity choice for time off limit

        :param granularity: The granularity of this AvailableTimeOffRange.
        :type: str
        """
        allowed_values = ["Daily"]
        if granularity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for granularity -> " + granularity)
            self._granularity = "outdated_sdk_version"
        else:
            self._granularity = granularity

    @property
    def available_minutes_per_interval(self):
        """
        Gets the available_minutes_per_interval of this AvailableTimeOffRange.
        The list of available time off values in minutes per granularity interval

        :return: The available_minutes_per_interval of this AvailableTimeOffRange.
        :rtype: list[int]
        """
        return self._available_minutes_per_interval

    @available_minutes_per_interval.setter
    def available_minutes_per_interval(self, available_minutes_per_interval):
        """
        Sets the available_minutes_per_interval of this AvailableTimeOffRange.
        The list of available time off values in minutes per granularity interval

        :param available_minutes_per_interval: The available_minutes_per_interval of this AvailableTimeOffRange.
        :type: list[int]
        """
        
        self._available_minutes_per_interval = available_minutes_per_interval

    @property
    def waitlisted_requests_per_interval(self):
        """
        Gets the waitlisted_requests_per_interval of this AvailableTimeOffRange.
        The current number of waitlisted time off requests for every interval per granularity

        :return: The waitlisted_requests_per_interval of this AvailableTimeOffRange.
        :rtype: list[int]
        """
        return self._waitlisted_requests_per_interval

    @waitlisted_requests_per_interval.setter
    def waitlisted_requests_per_interval(self, waitlisted_requests_per_interval):
        """
        Sets the waitlisted_requests_per_interval of this AvailableTimeOffRange.
        The current number of waitlisted time off requests for every interval per granularity

        :param waitlisted_requests_per_interval: The waitlisted_requests_per_interval of this AvailableTimeOffRange.
        :type: list[int]
        """
        
        self._waitlisted_requests_per_interval = waitlisted_requests_per_interval

    @property
    def waitlist_enabled(self):
        """
        Gets the waitlist_enabled of this AvailableTimeOffRange.
        Whether the time off request can be waitlisted

        :return: The waitlist_enabled of this AvailableTimeOffRange.
        :rtype: bool
        """
        return self._waitlist_enabled

    @waitlist_enabled.setter
    def waitlist_enabled(self, waitlist_enabled):
        """
        Sets the waitlist_enabled of this AvailableTimeOffRange.
        Whether the time off request can be waitlisted

        :param waitlist_enabled: The waitlist_enabled of this AvailableTimeOffRange.
        :type: bool
        """
        
        self._waitlist_enabled = waitlist_enabled

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

