"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViaServicePrincipal = void 0;
const iam = require("@aws-cdk/aws-iam");
/**
 * A principal to allow access to a key if it's being used through another AWS service.
 */
class ViaServicePrincipal extends iam.PrincipalBase {
    /**
     *
     */
    constructor(serviceName, basePrincipal) {
        super();
        this.serviceName = serviceName;
        this.basePrincipal = basePrincipal ? basePrincipal : new iam.AnyPrincipal();
    }
    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    get policyFragment() {
        // Make a copy of the base policyFragment to add a condition to it
        const base = this.basePrincipal.policyFragment;
        const conditions = Object.assign({}, base.conditions);
        if (conditions.StringEquals) {
            conditions.StringEquals = Object.assign({ 'kms:ViaService': this.serviceName }, conditions.StringEquals);
        }
        else {
            conditions.StringEquals = { 'kms:ViaService': this.serviceName };
        }
        return { principalJson: base.principalJson, conditions };
    }
}
exports.ViaServicePrincipal = ViaServicePrincipal;
//# sourceMappingURL=data:application/json;base64,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