"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = exports.IntegTestCaseStack = exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
const core_1 = require("aws-cdk-lib/core");
const constructs_1 = require("constructs");
const deploy_assert_1 = require("./assertions/private/deploy-assert");
const manifest_synthesizer_1 = require("./manifest-synthesizer");
const TEST_CASE_STACK_SYMBOL = Symbol.for('@aws-cdk/integ-tests.IntegTestCaseStack');
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 *
 * It is recommended that you use the IntegTest construct since that will create
 * a default IntegTestCase
 */
class IntegTestCase extends constructs_1.Construct {
    props;
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCase", version: "2.230.0-alpha.0" };
    /**
     * Make assertions on resources in this test case
     */
    assertions;
    _assert;
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCase);
            }
            throw error;
        }
        this._assert = new deploy_assert_1.DeployAssert(this, { stack: props.assertionStack });
        this.assertions = this._assert;
    }
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest() {
        return {
            version: cloud_assembly_schema_1.Manifest.version(),
            testCases: { [this.node.path]: this.toTestCase(this.props) },
        };
    }
    toTestCase(props) {
        return {
            ...props,
            assertionStack: this._assert.scope.node.path,
            assertionStackName: this._assert.scope.stackName,
            stacks: props.stacks.map(s => s.node.path),
        };
    }
}
exports.IntegTestCase = IntegTestCase;
/**
 * An integration test case stack. Allows the definition of test properties
 * that should apply to this stack.
 *
 * This should be used if there are multiple stacks in the integration test
 * and it is necessary to specify different test case option for each. Otherwise
 * normal stacks should be added to IntegTest
 */
class IntegTestCaseStack extends core_1.Stack {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCaseStack", version: "2.230.0-alpha.0" };
    /**
     * Returns whether the construct is a IntegTestCaseStack
     */
    static isIntegTestCaseStack(x) {
        return x !== null && typeof (x) === 'object' && TEST_CASE_STACK_SYMBOL in x;
    }
    /**
     * Make assertions on resources in this test case
     */
    assertions;
    /**
     * The underlying IntegTestCase that is created
     * @internal
     */
    _testCase;
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseStackProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCaseStack);
            }
            throw error;
        }
        Object.defineProperty(this, TEST_CASE_STACK_SYMBOL, { value: true });
        // TODO: should we only have a single DeployAssert per test?
        this.assertions = new deploy_assert_1.DeployAssert(this);
        this._testCase = new IntegTestCase(this, `${id}TestCase`, {
            ...props,
            stacks: [this],
        });
    }
}
exports.IntegTestCaseStack = IntegTestCaseStack;
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
class IntegTest extends constructs_1.Construct {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTest", version: "2.230.0-alpha.0" };
    /**
     * Make assertions on resources in this test case
     */
    assertions;
    testCases;
    enableLookups;
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTest);
            }
            throw error;
        }
        this.enableLookups = props.enableLookups;
        const defaultTestCase = new IntegTestCase(this, 'DefaultTest', {
            stacks: props.testCases.filter(stack => !IntegTestCaseStack.isIntegTestCaseStack(stack)),
            hooks: props.hooks,
            regions: props.regions,
            diffAssets: props.diffAssets,
            allowDestroy: props.allowDestroy,
            cdkCommandOptions: props.cdkCommandOptions,
            stackUpdateWorkflow: props.stackUpdateWorkflow,
            assertionStack: props.assertionStack,
        });
        this.assertions = defaultTestCase.assertions;
        this.testCases = [
            defaultTestCase,
            ...props.testCases
                .filter(stack => IntegTestCaseStack.isIntegTestCaseStack(stack))
                .map(stack => stack._testCase),
        ];
        this.node.addValidation({
            validate: () => {
                (0, core_1.attachCustomSynthesis)(this, {
                    onSynthesize: (session) => {
                        const synthesizer = new manifest_synthesizer_1.IntegManifestSynthesizer(this.testCases, this.enableLookups);
                        synthesizer.synthesize(session);
                    },
                });
                return [];
            },
        });
    }
}
exports.IntegTest = IntegTest;
//# sourceMappingURL=data:application/json;base64,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