"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegManifestWriter = void 0;
const fs = require("fs");
const path = require("path");
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
class IntegManifestWriter {
    static DEFAULT_FILENAME = 'integ.json';
    static write(manifest, filePath) {
        cloud_assembly_schema_1.Manifest.saveIntegManifest(manifest, getFinalLocation(filePath));
    }
}
exports.IntegManifestWriter = IntegManifestWriter;
function getFinalLocation(filePath) {
    try {
        const st = fs.statSync(filePath);
        return st.isDirectory()
            ? path.join(filePath, IntegManifestWriter.DEFAULT_FILENAME)
            : filePath;
    }
    catch (e) {
        if (e.code === 'ENOENT') {
            return filePath;
        }
        throw new Error(`Cannot write integ manifest to '${filePath}': ${e.message}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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