"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegManifestSynthesizer = void 0;
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
const manifest_writer_1 = require("./manifest-writer");
const emptyManifest = {
    version: '',
    testCases: {},
};
class IntegManifestSynthesizer {
    testCases;
    enableLookups;
    constructor(testCases, enableLookups) {
        this.testCases = testCases;
        this.enableLookups = enableLookups;
    }
    synthesize(session) {
        const manifest = {
            enableLookups: this.enableLookups,
            ...this.testCases
                .map(tc => tc.manifest)
                .reduce(mergeManifests, emptyManifest),
        };
        const snapshotDir = session.assembly.outdir;
        manifest_writer_1.IntegManifestWriter.write(manifest, snapshotDir);
    }
}
exports.IntegManifestSynthesizer = IntegManifestSynthesizer;
function mergeManifests(m1, m2) {
    return {
        version: cloud_assembly_schema_1.Manifest.version(),
        testCases: { ...m1.testCases, ...m2.testCases },
    };
}
//# sourceMappingURL=data:application/json;base64,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