"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpHandler = void 0;
/* eslint-disable no-console */
// eslint-disable-next-line import/no-extraneous-dependencies
const node_fetch_1 = require("node-fetch");
// TODO: can use builtin fetch on node18
const aws_custom_resource_sdk_adapter_1 = require("@aws-cdk/aws-custom-resource-sdk-adapter");
const base_1 = require("./base");
const utils_1 = require("./utils");
class HttpHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        console.log('request', request);
        const response = await (0, node_fetch_1.default)(request.parameters.url, request.parameters.fetchOptions);
        const result = {
            ok: response.ok,
            status: response.status,
            statusText: response.statusText,
            headers: response.headers.raw(),
        };
        result.body = await response.text();
        try {
            result.body = JSON.parse(result.body);
        }
        catch (e) {
            // Okay
        }
        let resp;
        if (request.flattenResponse === 'true') {
            // Flatten and explode JSON fields
            resp = (0, aws_custom_resource_sdk_adapter_1.flatten)((0, utils_1.deepParseJson)({ apiCallResponse: result }));
        }
        else {
            // Otherwise just return the response as-is, without exploding JSON fields
            resp = { apiCallResponse: result };
        }
        console.log(`Returning result ${JSON.stringify(resp)}`);
        return resp;
    }
}
exports.HttpHandler = HttpHandler;
//# sourceMappingURL=data:application/json;base64,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