"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssertionHandler = void 0;
/* eslint-disable no-console */
// eslint-disable-next-line import/no-extraneous-dependencies
const helpers_internal_1 = require("aws-cdk-lib/assertions/lib/helpers-internal");
const base_1 = require("./base");
class AssertionHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        let actual = decodeCall(request.actual);
        const expected = decodeCall(request.expected);
        let result;
        const matcher = new MatchCreator(expected).getMatcher();
        console.log(`Testing equality between ${JSON.stringify(request.actual)} and ${JSON.stringify(request.expected)}`);
        const matchResult = matcher.test(actual);
        matchResult.finished();
        if (matchResult.hasFailed()) {
            result = {
                failed: true,
                assertion: JSON.stringify({
                    status: 'fail',
                    message: matchResult.renderMismatch(),
                }),
            };
            if (request.failDeployment) {
                throw new Error(result.assertion);
            }
        }
        else {
            result = {
                assertion: JSON.stringify({
                    status: 'success',
                }),
            };
        }
        return result;
    }
}
exports.AssertionHandler = AssertionHandler;
class MatchCreator {
    parsedObj;
    constructor(obj) {
        this.parsedObj = {
            matcher: obj,
        };
    }
    /**
     * Return a Matcher that can be tested against the actual results.
     * This will convert the encoded matchers into their corresponding
     * assertions matcher.
     *
     * For example:
     *
     * ExpectedResult.objectLike({
     *   Messages: [{
     *     Body: Match.objectLike({
     *       Elements: Match.arrayWith([{ Asdf: 3 }]),
     *       Payload: Match.serializedJson({ key: 'value' }),
     *     }),
     *   }],
     * });
     *
     * Will be encoded as:
     * {
     *   $ObjectLike: {
     *     Messages: [{
     *       Body: {
     *         $ObjectLike: {
     *           Elements: {
     *             $ArrayWith: [{ Asdf: 3 }],
     *           },
     *           Payload: {
     *             $SerializedJson: { key: 'value' }
     *           }
     *         },
     *       },
     *     }],
     *   },
     * }
     *
     * Which can then be parsed by this function. For each key (recursively)
     * the parser will check if the value has one of the encoded matchers as a key
     * and if so, it will set the value as the Matcher. So,
     *
     * {
     *   Body: {
     *     $ObjectLike: {
     *       Elements: {
     *         $ArrayWith: [{ Asdf: 3 }],
     *       },
     *       Payload: {
     *         $SerializedJson: { key: 'value' }
     *       }
     *     },
     *   },
     * }
     *
     * Will be converted to
     * {
     *   Body: Match.objectLike({
     *     Elements: Match.arrayWith([{ Asdf: 3 }]),
     *     Payload: Match.serializedJson({ key: 'value' }),
     *   }),
     * }
     */
    getMatcher() {
        try {
            const final = JSON.parse(JSON.stringify(this.parsedObj), function (_k, v) {
                const nested = Object.keys(v)[0];
                switch (nested) {
                    case '$ArrayWith':
                        return helpers_internal_1.Match.arrayWith(v[nested]);
                    case '$ObjectLike':
                        return helpers_internal_1.Match.objectLike(v[nested]);
                    case '$StringLike':
                        return helpers_internal_1.Match.stringLikeRegexp(v[nested]);
                    case '$SerializedJson':
                        return helpers_internal_1.Match.serializedJson(v[nested]);
                    default:
                        return v;
                }
            });
            if (helpers_internal_1.Matcher.isMatcher(final.matcher)) {
                return final.matcher;
            }
            return helpers_internal_1.Match.exact(final.matcher);
        }
        catch {
            return helpers_internal_1.Match.exact(this.parsedObj.matcher);
        }
    }
}
function decodeCall(call) {
    if (!call) {
        return undefined;
    }
    try {
        const parsed = JSON.parse(call);
        return parsed;
    }
    catch {
        return call;
    }
}
//# sourceMappingURL=data:application/json;base64,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