"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApiCall = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const api_call_base_1 = require("./api-call-base");
const providers_1 = require("./providers");
const waiter_state_machine_1 = require("./waiter-state-machine");
/**
 * Construct that creates a custom resource that will perform
 * an HTTP API Call
 */
class HttpApiCall extends api_call_base_1.ApiCallBase {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/integ-tests-alpha.HttpApiCall", version: "2.230.0-alpha.0" };
    apiCallResource;
    provider;
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_HttpCallProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpApiCall);
            }
            throw error;
        }
        let name = '';
        if (!aws_cdk_lib_1.Token.isUnresolved(props.url)) {
            const url = new URL(props.url);
            name = `${url.hostname}${url.pathname}`.replace(/\/|\.|:/g, '');
        }
        this.provider = new providers_1.AssertionsProvider(this, 'HttpProvider');
        this.apiCallResource = new aws_cdk_lib_1.CustomResource(this, 'Default', {
            serviceToken: this.provider.serviceToken,
            properties: {
                parameters: props,
                expected: aws_cdk_lib_1.Lazy.any({ produce: () => this.expectedResult }),
                stateMachineArn: aws_cdk_lib_1.Lazy.string({ produce: () => this.stateMachineArn }),
                flattenResponse: aws_cdk_lib_1.Lazy.string({ produce: () => this.flattenResponse }),
                salt: Date.now().toString(),
            },
            resourceType: `${providers_1.HTTP_RESOURCE_TYPE}${name}`.substring(0, 60),
        });
        // Needed so that all the policies set up by the provider should be available before the custom resource is provisioned.
        this.apiCallResource.node.addDependency(this.provider);
        aws_cdk_lib_1.Aspects.of(this).add({
            visit(node) {
                if (node instanceof HttpApiCall) {
                    if (node.expectedResult) {
                        const result = node.apiCallResource.getAttString('assertion');
                        new aws_cdk_lib_1.CfnOutput(node, 'AssertionResults', {
                            value: result,
                        }).overrideLogicalId(`AssertionResults${id.replace(/[\W_]+/g, '')}`);
                    }
                }
            },
        }, { priority: aws_cdk_lib_1.AspectPriority.MUTATING });
    }
    assertAtPath(_path, _expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(_expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.assertAtPath);
            }
            throw error;
        }
        return this;
    }
    waitForAssertions(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_WaiterStateMachineOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.waitForAssertions);
            }
            throw error;
        }
        const waiter = new waiter_state_machine_1.WaiterStateMachine(this, 'WaitFor', {
            ...options,
        });
        this.stateMachineArn = waiter.stateMachineArn;
        this.provider.addPolicyStatementFromSdkCall('states', 'StartExecution');
        return this;
    }
}
exports.HttpApiCall = HttpApiCall;
//# sourceMappingURL=data:application/json;base64,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