import { CustomResource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { ApiCallBase, IApiCall } from './api-call-base';
import { ExpectedResult } from './common';
import { AssertionsProvider, HttpRequestParameters } from './providers';
import { WaiterStateMachineOptions } from './waiter-state-machine';
/**
 * Options for creating an HttpApiCall provider
 */
export interface HttpCallProps extends HttpRequestParameters {
}
/**
 * Construct that creates a custom resource that will perform
 * an HTTP API Call
 */
export declare class HttpApiCall extends ApiCallBase {
    protected readonly apiCallResource: CustomResource;
    readonly provider: AssertionsProvider;
    constructor(scope: Construct, id: string, props: HttpCallProps);
    assertAtPath(_path: string, _expected: ExpectedResult): IApiCall;
    waitForAssertions(options?: WaiterStateMachineOptions | undefined): IApiCall;
}
