"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpectedResult = exports.ActualResult = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents the "actual" results to compare
 */
class ActualResult {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/integ-tests-alpha.ActualResult", version: "2.230.0-alpha.0" };
    /**
     * Get the actual results from a CustomResource
     */
    static fromCustomResource(customResource, attribute) {
        return {
            result: customResource.getAttString(attribute),
        };
    }
    /**
     * Get the actual results from a AwsApiCall
     */
    static fromAwsApiCall(query, attribute) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IApiCall(query);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAwsApiCall);
            }
            throw error;
        }
        return {
            result: query.getAttString(attribute),
        };
    }
}
exports.ActualResult = ActualResult;
/**
 * Represents the "expected" results to compare
 */
class ExpectedResult {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/integ-tests-alpha.ExpectedResult", version: "2.230.0-alpha.0" };
    /**
     * The actual results must match exactly. Missing data
     * will result in a failure
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * };
     * // pass
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * })
     *
     * // fail
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     * });
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.assertions.Match.html#static-exactpattern
     */
    static exact(expected) {
        return {
            result: JSON.stringify({
                $Exact: expected,
            }),
        };
    }
    /**
     * The expected results must be a subset of the
     * actual results.
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     *   objectParam: { prop1: 'value', prop2: 'value' },
     * };
     * // pass
     * ExpectedResult.objectLike({
     *   stringParam: 'hello',
     *   objectParam: { prop1: 'value' },
     * });
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.assertions.Match.html#static-objectwbrlikepattern
     */
    static objectLike(expected) {
        return {
            result: JSON.stringify({
                $ObjectLike: expected,
            }),
        };
    }
    /**
     * The actual results must be a list and must contain
     * an item with the expected results.
     *
     * @example
     * // actual results
     * const actual = [
     *   {
     *     stringParam: 'hello',
     *   },
     *   {
     *     stringParam: 'world',
     *   },
     * ];
     * // pass
     * ExpectedResult.arrayWith([
     *   {
     *     stringParam: 'hello',
     *   },
     * ]);
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.assertions.Match.html#static-arraywbrwithpattern
     */
    static arrayWith(expected) {
        return {
            result: JSON.stringify({
                $ArrayWith: expected,
            }),
        };
    }
    /**
     * Actual results is a string that matches
     * the Expected result regex
     *
     * @example
     * // actual results
     * const actual = 'some string value';
     *
     * // pass
     * ExpectedResult.stringLikeRegexp('value');
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.assertions.Match.html#static-stringwbrlikewbrregexppattern
     */
    static stringLikeRegexp(expected) {
        return {
            result: JSON.stringify({
                $StringLike: expected,
            }),
        };
    }
}
exports.ExpectedResult = ExpectedResult;
//# sourceMappingURL=data:application/json;base64,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