"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiCallBase = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
/**
 * Base class for an ApiCall
 */
class ApiCallBase extends constructs_1.Construct {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/integ-tests-alpha.ApiCallBase", version: "2.230.0-alpha.0" };
    expectedResult;
    flattenResponse = 'false';
    stateMachineArn;
    outputPaths;
    constructor(scope, id) {
        super(scope, id);
    }
    getAtt(attributeName) {
        (this.outputPaths ??= []).push(attributeName);
        this.flattenResponse = 'true';
        return this.apiCallResource.getAtt(`apiCallResponse.${attributeName}`);
    }
    getAttString(attributeName) {
        (this.outputPaths ??= []).push(attributeName);
        this.flattenResponse = 'true';
        return this.apiCallResource.getAttString(`apiCallResponse.${attributeName}`);
    }
    expect(expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.expect);
            }
            throw error;
        }
        this.expectedResult = expected.result;
        return this;
    }
    next(next) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IApiCall(next);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.next);
            }
            throw error;
        }
        next.node.addDependency(this);
        return next;
    }
}
exports.ApiCallBase = ApiCallBase;
//# sourceMappingURL=data:application/json;base64,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