# coding: utf-8

_PTG_IRREPS_DB = \
{'C1': {'class_names': ['1+'],
        'class_range': [(0, 1)],
        'irreps': {'A': {'dim': 1, 'matrices': [[[1.0]]]}},
        'nclass': 1,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]]]},
 'C2': {'class_names': ['1+', '2+'],
        'class_range': [(0, 1), (1, 2)],
        'irreps': {'A': {'dim': 1, 'matrices': [[[1.0]], [[1.0]]]},
                   'B': {'dim': 1, 'matrices': [[[1.0]], [[-1.0]]]}},
        'nclass': 2,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, 1, 0], [0, 0, -1]]]},
 'C2h': {'class_names': ['1+', '2+', '-2-', '-2+'],
         'class_range': [(0, 1), (1, 2), (2, 3), (3, 4)],
         'irreps': {'Ag': {'dim': 1,
                           'matrices': [[[1.0]], [[1.0]], [[1.0]], [[1.0]]]},
                    'Au': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'Bg': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[-1.0]]]},
                    'Bu': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]]]}},
         'nclass': 4,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, 1, 0], [0, 0, -1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, -1]],
                       [[1, 0, 0], [0, -1, 0], [0, 0, 1]]]},
 'C2v': {'class_names': ['1+', '2+', '-2+', '-2+'],
         'class_range': [(0, 1), (1, 2), (2, 3), (3, 4)],
         'irreps': {'A1': {'dim': 1,
                           'matrices': [[[1.0]], [[1.0]], [[1.0]], [[1.0]]]},
                    'A2': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'B1': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[-1.0]]]},
                    'B2': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]]]}},
         'nclass': 4,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, 1, 0], [0, 0, 1]]]},
 'C3': {'class_names': ['1+', '3+', '3+'],
        'class_range': [(0, 1), (1, 2), (2, 3)],
        'irreps': {'A': {'dim': 1, 'matrices': [[[1.0]], [[1.0]], [[1.0]]]},
                   'E1': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[(-0.5+0.86603j)]],
                                       [[(-0.5-0.86603j)]]]},
                   'E2': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[(-0.5-0.86603j)]],
                                       [[(-0.5+0.86603j)]]]}},
        'nclass': 3,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                      [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]]]},
 'C3h': {'class_names': ['1+', '3+', '3+', '-2+', '-6+', '-6+'],
         'class_range': [(0, 1), (1, 2), (2, 3), (3, 4), (4, 5), (5, 6)],
         'irreps': {"A'": {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    "A''": {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    "E''1": {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[(-0.5+0.86603j)]],
                                          [[(-0.5-0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5-0.86603j)]],
                                          [[(0.5+0.86603j)]]]},
                    "E''2": {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[(-0.5-0.86603j)]],
                                          [[(-0.5+0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5+0.86603j)]],
                                          [[(0.5-0.86603j)]]]},
                    "E'1": {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[(-0.5+0.86603j)]],
                                         [[(-0.5-0.86603j)]],
                                         [[1.0]],
                                         [[(-0.5+0.86603j)]],
                                         [[(-0.5-0.86603j)]]]},
                    "E'2": {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[(-0.5-0.86603j)]],
                                         [[(-0.5+0.86603j)]],
                                         [[1.0]],
                                         [[(-0.5-0.86603j)]],
                                         [[(-0.5+0.86603j)]]]}},
         'nclass': 6,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[1, 0, 0], [0, 1, 0], [0, 0, -1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, -1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, -1]]]},
 'C3i': {'class_names': ['1+', '3+', '3+', '-2-', '-6-', '-6-'],
         'class_range': [(0, 1), (1, 2), (2, 3), (3, 4), (4, 5), (5, 6)],
         'irreps': {'Ag': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'Au': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'Eg1': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[(-0.5+0.86603j)]],
                                         [[(-0.5-0.86603j)]],
                                         [[1.0]],
                                         [[(-0.5+0.86603j)]],
                                         [[(-0.5-0.86603j)]]]},
                    'Eg2': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[(-0.5-0.86603j)]],
                                         [[(-0.5+0.86603j)]],
                                         [[1.0]],
                                         [[(-0.5-0.86603j)]],
                                         [[(-0.5+0.86603j)]]]},
                    'Eu1': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[(-0.5+0.86603j)]],
                                         [[(-0.5-0.86603j)]],
                                         [[-1.0]],
                                         [[(0.5-0.86603j)]],
                                         [[(0.5+0.86603j)]]]},
                    'Eu2': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[(-0.5-0.86603j)]],
                                         [[(-0.5+0.86603j)]],
                                         [[-1.0]],
                                         [[(0.5+0.86603j)]],
                                         [[(0.5-0.86603j)]]]}},
         'nclass': 6,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, -1]],
                       [[0, 1, 0], [-1, 1, 0], [0, 0, -1]],
                       [[1, -1, 0], [1, 0, 0], [0, 0, -1]]]},
 'C3v': {'class_names': ['1+', '3+', '-2+'],
         'class_range': [(0, 1), (1, 3), (3, 6)],
         'irreps': {'A1': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'A2': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'E': {'dim': 2,
                          'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]]]}},
         'nclass': 3,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[0, -1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[-1, 1, 0], [0, 1, 0], [0, 0, 1]],
                       [[1, 0, 0], [1, -1, 0], [0, 0, 1]]]},
 'C4': {'class_names': ['1+', '2+', '4+', '4+'],
        'class_range': [(0, 1), (1, 2), (2, 3), (3, 4)],
        'irreps': {'A': {'dim': 1,
                         'matrices': [[[1.0]], [[1.0]], [[1.0]], [[1.0]]]},
                   'B': {'dim': 1,
                         'matrices': [[[1.0]], [[1.0]], [[-1.0]], [[-1.0]]]},
                   'E1': {'dim': 1,
                          'matrices': [[[1.0]], [[-1.0]], [[1j]], [[-1j]]]},
                   'E2': {'dim': 1,
                          'matrices': [[[1.0]], [[-1.0]], [[-1j]], [[1j]]]}},
        'nclass': 4,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                      [[0, -1, 0], [1, 0, 0], [0, 0, 1]],
                      [[0, 1, 0], [-1, 0, 0], [0, 0, 1]]]},
 'C4h': {'class_names': ['1+', '2+', '4+', '4+', '-2-', '-2+', '-4+', '-4+'],
         'class_range': [(0, 1),
                         (1, 2),
                         (2, 3),
                         (3, 4),
                         (4, 5),
                         (5, 6),
                         (6, 7),
                         (7, 8)],
         'irreps': {'Ag': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'Au': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'Bg': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'Bu': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'Eg1': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[-1.0]],
                                         [[1j]],
                                         [[-1j]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[1j]],
                                         [[-1j]]]},
                    'Eg2': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[-1.0]],
                                         [[-1j]],
                                         [[1j]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1j]],
                                         [[1j]]]},
                    'Eu1': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[-1.0]],
                                         [[1j]],
                                         [[-1j]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[-1j]],
                                         [[1j]]]},
                    'Eu2': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[-1.0]],
                                         [[-1j]],
                                         [[1j]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1j]],
                                         [[-1j]]]}},
         'nclass': 8,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[0, -1, 0], [1, 0, 0], [0, 0, 1]],
                       [[0, 1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, -1]],
                       [[1, 0, 0], [0, 1, 0], [0, 0, -1]],
                       [[0, 1, 0], [-1, 0, 0], [0, 0, -1]],
                       [[0, -1, 0], [1, 0, 0], [0, 0, -1]]]},
 'C4v': {'class_names': ['1+', '2+', '4+', '-2+', '-2+'],
         'class_range': [(0, 1), (1, 2), (2, 4), (4, 6), (6, 8)],
         'irreps': {'A1': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'A2': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'B1': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'B2': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'E': {'dim': 2,
                          'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                       [[-1.0, 0.0], [0.0, -1.0]],
                                       [[1j, 0j], [0j, (-0-1j)]],
                                       [[(-0-1j), 0j], [0j, 1j]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0.0, -1.0], [-1.0, 0.0]],
                                       [[0j, (-0-1j)], [1j, 0j]],
                                       [[0j, 1j], [(-0-1j), 0j]]]}},
         'nclass': 5,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[0, -1, 0], [1, 0, 0], [0, 0, 1]],
                       [[0, 1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[0, -1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[0, 1, 0], [1, 0, 0], [0, 0, 1]]]},
 'C6': {'class_names': ['1+', '3+', '3+', '2+', '6+', '6+'],
        'class_range': [(0, 1), (1, 2), (2, 3), (3, 4), (4, 5), (5, 6)],
        'irreps': {'A': {'dim': 1,
                         'matrices': [[[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]]]},
                   'B': {'dim': 1,
                         'matrices': [[[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[-1.0]],
                                      [[-1.0]],
                                      [[-1.0]]]},
                   'E11': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[-1.0]],
                                        [[(0.5-0.86603j)]],
                                        [[(0.5+0.86603j)]]]},
                   'E12': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[-1.0]],
                                        [[(0.5+0.86603j)]],
                                        [[(0.5-0.86603j)]]]},
                   'E21': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[1.0]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5+0.86603j)]]]},
                   'E22': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[1.0]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5-0.86603j)]]]}},
        'nclass': 6,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                      [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                      [[0, 1, 0], [-1, 1, 0], [0, 0, 1]],
                      [[1, -1, 0], [1, 0, 0], [0, 0, 1]]]},
 'C6h': {'class_names': ['1+',
                         '3+',
                         '3+',
                         '2+',
                         '6+',
                         '6+',
                         '-2-',
                         '-6-',
                         '-6-',
                         '-2+',
                         '-6+',
                         '-6+'],
         'class_range': [(0, 1),
                         (1, 2),
                         (2, 3),
                         (3, 4),
                         (4, 5),
                         (5, 6),
                         (6, 7),
                         (7, 8),
                         (8, 9),
                         (9, 10),
                         (10, 11),
                         (11, 12)],
         'irreps': {'Ag': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'Au': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'Bg': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'Bu': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'E1g1': {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[(-0.5+0.86603j)]],
                                          [[(-0.5-0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5-0.86603j)]],
                                          [[(0.5+0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5+0.86603j)]],
                                          [[(-0.5-0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5-0.86603j)]],
                                          [[(0.5+0.86603j)]]]},
                    'E1g2': {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[(-0.5-0.86603j)]],
                                          [[(-0.5+0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5+0.86603j)]],
                                          [[(0.5-0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5-0.86603j)]],
                                          [[(-0.5+0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5+0.86603j)]],
                                          [[(0.5-0.86603j)]]]},
                    'E1u1': {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[(-0.5+0.86603j)]],
                                          [[(-0.5-0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5-0.86603j)]],
                                          [[(0.5+0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5-0.86603j)]],
                                          [[(0.5+0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5+0.86603j)]],
                                          [[(-0.5-0.86603j)]]]},
                    'E1u2': {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[(-0.5-0.86603j)]],
                                          [[(-0.5+0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5+0.86603j)]],
                                          [[(0.5-0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5+0.86603j)]],
                                          [[(0.5-0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5-0.86603j)]],
                                          [[(-0.5+0.86603j)]]]},
                    'E2g1': {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[(-0.5-0.86603j)]],
                                          [[(-0.5+0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5-0.86603j)]],
                                          [[(-0.5+0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5-0.86603j)]],
                                          [[(-0.5+0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5-0.86603j)]],
                                          [[(-0.5+0.86603j)]]]},
                    'E2g2': {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[(-0.5+0.86603j)]],
                                          [[(-0.5-0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5+0.86603j)]],
                                          [[(-0.5-0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5+0.86603j)]],
                                          [[(-0.5-0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5+0.86603j)]],
                                          [[(-0.5-0.86603j)]]]},
                    'E2u1': {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[(-0.5-0.86603j)]],
                                          [[(-0.5+0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5-0.86603j)]],
                                          [[(-0.5+0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5+0.86603j)]],
                                          [[(0.5-0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5+0.86603j)]],
                                          [[(0.5-0.86603j)]]]},
                    'E2u2': {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[(-0.5+0.86603j)]],
                                          [[(-0.5-0.86603j)]],
                                          [[1.0]],
                                          [[(-0.5+0.86603j)]],
                                          [[(-0.5-0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5-0.86603j)]],
                                          [[(0.5+0.86603j)]],
                                          [[-1.0]],
                                          [[(0.5-0.86603j)]],
                                          [[(0.5+0.86603j)]]]}},
         'nclass': 12,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[0, 1, 0], [-1, 1, 0], [0, 0, 1]],
                       [[1, -1, 0], [1, 0, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, -1]],
                       [[0, 1, 0], [-1, 1, 0], [0, 0, -1]],
                       [[1, -1, 0], [1, 0, 0], [0, 0, -1]],
                       [[1, 0, 0], [0, 1, 0], [0, 0, -1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, -1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, -1]]]},
 'C6v': {'class_names': ['1+', '3+', '2+', '6+', '-2+', '-2+'],
         'class_range': [(0, 1), (1, 3), (3, 4), (4, 6), (6, 9), (9, 12)],
         'irreps': {'A1': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'A2': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'B1': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'B2': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'E1': {'dim': 2,
                           'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                        [[(-0.5+0.86603j), 0j],
                                         [0j, (-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j), 0j],
                                         [0j, (-0.5+0.86603j)]],
                                        [[-1.0, 0.0], [0.0, -1.0]],
                                        [[(0.5-0.86603j), 0j],
                                         [0j, (0.5+0.86603j)]],
                                        [[(0.5+0.86603j), 0j],
                                         [0j, (0.5-0.86603j)]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0j, (-0.5-0.86603j)],
                                         [(-0.5+0.86603j), 0j]],
                                        [[0j, (-0.5+0.86603j)],
                                         [(-0.5-0.86603j), 0j]],
                                        [[0.0, -1.0], [-1.0, 0.0]],
                                        [[0j, (0.5+0.86603j)],
                                         [(0.5-0.86603j), 0j]],
                                        [[0j, (0.5-0.86603j)],
                                         [(0.5+0.86603j), 0j]]]},
                    'E2': {'dim': 2,
                           'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                        [[(-0.5+0.86603j), 0j],
                                         [0j, (-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j), 0j],
                                         [0j, (-0.5+0.86603j)]],
                                        [[1.0, 0.0], [0.0, 1.0]],
                                        [[(-0.5+0.86603j), 0j],
                                         [0j, (-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j), 0j],
                                         [0j, (-0.5+0.86603j)]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0j, (-0.5-0.86603j)],
                                         [(-0.5+0.86603j), 0j]],
                                        [[0j, (-0.5+0.86603j)],
                                         [(-0.5-0.86603j), 0j]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0j, (-0.5-0.86603j)],
                                         [(-0.5+0.86603j), 0j]],
                                        [[0j, (-0.5+0.86603j)],
                                         [(-0.5-0.86603j), 0j]]]}},
         'nclass': 6,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[0, 1, 0], [-1, 1, 0], [0, 0, 1]],
                       [[1, -1, 0], [1, 0, 0], [0, 0, 1]],
                       [[0, -1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[-1, 1, 0], [0, 1, 0], [0, 0, 1]],
                       [[1, 0, 0], [1, -1, 0], [0, 0, 1]],
                       [[0, 1, 0], [1, 0, 0], [0, 0, 1]],
                       [[1, -1, 0], [0, -1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [-1, 1, 0], [0, 0, 1]]]},
 'Ci': {'class_names': ['1+', '-2-'],
        'class_range': [(0, 1), (1, 2)],
        'irreps': {'Ag': {'dim': 1, 'matrices': [[[1.0]], [[1.0]]]},
                   'Au': {'dim': 1, 'matrices': [[[1.0]], [[-1.0]]]}},
        'nclass': 2,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, -1]]]},
 'Cs': {'class_names': ['1+', '-2+'],
        'class_range': [(0, 1), (1, 2)],
        'irreps': {"A'": {'dim': 1, 'matrices': [[[1.0]], [[1.0]]]},
                   "A''": {'dim': 1, 'matrices': [[[1.0]], [[-1.0]]]}},
        'nclass': 2,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[1, 0, 0], [0, -1, 0], [0, 0, 1]]]},
 'D2': {'class_names': ['1+', '2+', '2+', '2+'],
        'class_range': [(0, 1), (1, 2), (2, 3), (3, 4)],
        'irreps': {'A': {'dim': 1,
                         'matrices': [[[1.0]], [[1.0]], [[1.0]], [[1.0]]]},
                   'B1': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]]]},
                   'B2': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[-1.0]],
                                       [[1.0]],
                                       [[-1.0]]]},
                   'B3': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[1.0]]]}},
        'nclass': 4,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, 1, 0], [0, 0, -1]],
                      [[1, 0, 0], [0, -1, 0], [0, 0, -1]]]},
 'D2d': {'class_names': ['1+', '2+', '-4+', '2+', '-2+'],
         'class_range': [(0, 1), (1, 2), (2, 4), (4, 6), (6, 8)],
         'irreps': {'A1': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'A2': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'B1': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'B2': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'E': {'dim': 2,
                          'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                       [[-1.0, 0.0], [0.0, -1.0]],
                                       [[1j, 0j], [0j, (-0-1j)]],
                                       [[(-0-1j), 0j], [0j, 1j]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0.0, -1.0], [-1.0, 0.0]],
                                       [[0j, (-0-1j)], [1j, 0j]],
                                       [[0j, 1j], [(-0-1j), 0j]]]}},
         'nclass': 5,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[0, 1, 0], [-1, 0, 0], [0, 0, -1]],
                       [[0, -1, 0], [1, 0, 0], [0, 0, -1]],
                       [[-1, 0, 0], [0, 1, 0], [0, 0, -1]],
                       [[1, 0, 0], [0, -1, 0], [0, 0, -1]],
                       [[0, -1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[0, 1, 0], [1, 0, 0], [0, 0, 1]]]},
 'D2h': {'class_names': ['1+', '2+', '2+', '2+', '-2-', '-2+', '-2+', '-2+'],
         'class_range': [(0, 1),
                         (1, 2),
                         (2, 3),
                         (3, 4),
                         (4, 5),
                         (5, 6),
                         (6, 7),
                         (7, 8)],
         'irreps': {'Ag': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                    'Au': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                    'B1g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    'B1u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    'B2g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[-1.0]]]},
                    'B2u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[1.0]]]},
                    'B3g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]]]},
                    'B3u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]]]}},
         'nclass': 8,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, 1, 0], [0, 0, -1]],
                       [[1, 0, 0], [0, -1, 0], [0, 0, -1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, -1]],
                       [[1, 0, 0], [0, 1, 0], [0, 0, -1]],
                       [[1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, 1, 0], [0, 0, 1]]]},
 'D3': {'class_names': ['1+', '3+', '2+'],
        'class_range': [(0, 1), (1, 3), (3, 6)],
        'irreps': {'A1': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]]]},
                   'A2': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]]]},
                   'E': {'dim': 2,
                         'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                      [[(-0.5+0.86603j), 0j],
                                       [0j, (-0.5-0.86603j)]],
                                      [[(-0.5-0.86603j), 0j],
                                       [0j, (-0.5+0.86603j)]],
                                      [[0.0, 1.0], [1.0, 0.0]],
                                      [[0j, (-0.5-0.86603j)],
                                       [(-0.5+0.86603j), 0j]],
                                      [[0j, (-0.5+0.86603j)],
                                       [(-0.5-0.86603j), 0j]]]}},
        'nclass': 3,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                      [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]],
                      [[0, -1, 0], [-1, 0, 0], [0, 0, -1]],
                      [[-1, 1, 0], [0, 1, 0], [0, 0, -1]],
                      [[1, 0, 0], [1, -1, 0], [0, 0, -1]]]},
 'D3d': {'class_names': ['1+', '3+', '2+', '-2-', '-6-', '-2+'],
         'class_range': [(0, 1), (1, 3), (3, 6), (6, 7), (7, 9), (9, 12)],
         'irreps': {'A1g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    'A1u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    'A2g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    'A2u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    'Eg': {'dim': 2,
                           'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                        [[(-0.5+0.86603j), 0j],
                                         [0j, (-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j), 0j],
                                         [0j, (-0.5+0.86603j)]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0j, (-0.5-0.86603j)],
                                         [(-0.5+0.86603j), 0j]],
                                        [[0j, (-0.5+0.86603j)],
                                         [(-0.5-0.86603j), 0j]],
                                        [[1.0, 0.0], [0.0, 1.0]],
                                        [[(-0.5+0.86603j), 0j],
                                         [0j, (-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j), 0j],
                                         [0j, (-0.5+0.86603j)]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0j, (-0.5-0.86603j)],
                                         [(-0.5+0.86603j), 0j]],
                                        [[0j, (-0.5+0.86603j)],
                                         [(-0.5-0.86603j), 0j]]]},
                    'Eu': {'dim': 2,
                           'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                        [[(-0.5+0.86603j), 0j],
                                         [0j, (-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j), 0j],
                                         [0j, (-0.5+0.86603j)]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0j, (-0.5-0.86603j)],
                                         [(-0.5+0.86603j), 0j]],
                                        [[0j, (-0.5+0.86603j)],
                                         [(-0.5-0.86603j), 0j]],
                                        [[-1.0, 0.0], [0.0, -1.0]],
                                        [[(0.5-0.86603j), 0j],
                                         [0j, (0.5+0.86603j)]],
                                        [[(0.5+0.86603j), 0j],
                                         [0j, (0.5-0.86603j)]],
                                        [[0.0, -1.0], [-1.0, 0.0]],
                                        [[0j, (0.5+0.86603j)],
                                         [(0.5-0.86603j), 0j]],
                                        [[0j, (0.5-0.86603j)],
                                         [(0.5+0.86603j), 0j]]]}},
         'nclass': 6,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[0, -1, 0], [-1, 0, 0], [0, 0, -1]],
                       [[-1, 1, 0], [0, 1, 0], [0, 0, -1]],
                       [[1, 0, 0], [1, -1, 0], [0, 0, -1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, -1]],
                       [[0, 1, 0], [-1, 1, 0], [0, 0, -1]],
                       [[1, -1, 0], [1, 0, 0], [0, 0, -1]],
                       [[0, 1, 0], [1, 0, 0], [0, 0, 1]],
                       [[1, -1, 0], [0, -1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [-1, 1, 0], [0, 0, 1]]]},
 'D3h': {'class_names': ['1+', '3+', '-2+', '-6+', '2+', '-2+'],
         'class_range': [(0, 1), (1, 3), (3, 4), (4, 6), (6, 9), (9, 12)],
         'irreps': {"A''1": {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[1.0]],
                                          [[1.0]],
                                          [[-1.0]],
                                          [[-1.0]],
                                          [[-1.0]],
                                          [[1.0]],
                                          [[1.0]],
                                          [[1.0]],
                                          [[-1.0]],
                                          [[-1.0]],
                                          [[-1.0]]]},
                    "A''2": {'dim': 1,
                             'matrices': [[[1.0]],
                                          [[1.0]],
                                          [[1.0]],
                                          [[-1.0]],
                                          [[-1.0]],
                                          [[-1.0]],
                                          [[-1.0]],
                                          [[-1.0]],
                                          [[-1.0]],
                                          [[1.0]],
                                          [[1.0]],
                                          [[1.0]]]},
                    "A'1": {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    "A'2": {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    "E'": {'dim': 2,
                           'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                        [[(-0.5+0.86603j), 0j],
                                         [0j, (-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j), 0j],
                                         [0j, (-0.5+0.86603j)]],
                                        [[1.0, 0.0], [0.0, 1.0]],
                                        [[(-0.5+0.86603j), 0j],
                                         [0j, (-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j), 0j],
                                         [0j, (-0.5+0.86603j)]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0j, (-0.5-0.86603j)],
                                         [(-0.5+0.86603j), 0j]],
                                        [[0j, (-0.5+0.86603j)],
                                         [(-0.5-0.86603j), 0j]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0j, (-0.5-0.86603j)],
                                         [(-0.5+0.86603j), 0j]],
                                        [[0j, (-0.5+0.86603j)],
                                         [(-0.5-0.86603j), 0j]]]},
                    "E''": {'dim': 2,
                            'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                         [[(-0.5+0.86603j), 0j],
                                          [0j, (-0.5-0.86603j)]],
                                         [[(-0.5-0.86603j), 0j],
                                          [0j, (-0.5+0.86603j)]],
                                         [[-1.0, 0.0], [0.0, -1.0]],
                                         [[(0.5-0.86603j), 0j],
                                          [0j, (0.5+0.86603j)]],
                                         [[(0.5+0.86603j), 0j],
                                          [0j, (0.5-0.86603j)]],
                                         [[0.0, 1.0], [1.0, 0.0]],
                                         [[0j, (-0.5-0.86603j)],
                                          [(-0.5+0.86603j), 0j]],
                                         [[0j, (-0.5+0.86603j)],
                                          [(-0.5-0.86603j), 0j]],
                                         [[0.0, -1.0], [-1.0, 0.0]],
                                         [[0j, (0.5+0.86603j)],
                                          [(0.5-0.86603j), 0j]],
                                         [[0j, (0.5-0.86603j)],
                                          [(0.5+0.86603j), 0j]]]}},
         'nclass': 6,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[1, 0, 0], [0, 1, 0], [0, 0, -1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, -1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, -1]],
                       [[0, 1, 0], [1, 0, 0], [0, 0, -1]],
                       [[1, -1, 0], [0, -1, 0], [0, 0, -1]],
                       [[-1, 0, 0], [-1, 1, 0], [0, 0, -1]],
                       [[0, 1, 0], [1, 0, 0], [0, 0, 1]],
                       [[1, -1, 0], [0, -1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [-1, 1, 0], [0, 0, 1]]]},
 'D4': {'class_names': ['1+', '2+', '4+', '2+', '2+'],
        'class_range': [(0, 1), (1, 2), (2, 4), (4, 6), (6, 8)],
        'irreps': {'A1': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]]]},
                   'A2': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]]]},
                   'B1': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]]]},
                   'B2': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[1.0]],
                                       [[1.0]]]},
                   'E': {'dim': 2,
                         'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                      [[-1.0, 0.0], [0.0, -1.0]],
                                      [[1j, 0j], [0j, (-0-1j)]],
                                      [[(-0-1j), 0j], [0j, 1j]],
                                      [[0.0, 1.0], [1.0, 0.0]],
                                      [[0.0, -1.0], [-1.0, 0.0]],
                                      [[0j, (-0-1j)], [1j, 0j]],
                                      [[0j, 1j], [(-0-1j), 0j]]]}},
        'nclass': 5,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                      [[0, -1, 0], [1, 0, 0], [0, 0, 1]],
                      [[0, 1, 0], [-1, 0, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, 1, 0], [0, 0, -1]],
                      [[1, 0, 0], [0, -1, 0], [0, 0, -1]],
                      [[0, 1, 0], [1, 0, 0], [0, 0, -1]],
                      [[0, -1, 0], [-1, 0, 0], [0, 0, -1]]]},
 'D4h': {'class_names': ['1+',
                         '2+',
                         '4+',
                         '2+',
                         '2+',
                         '-2-',
                         '-2+',
                         '-4+',
                         '-2+',
                         '-2+'],
         'class_range': [(0, 1),
                         (1, 2),
                         (2, 4),
                         (4, 6),
                         (6, 8),
                         (8, 9),
                         (9, 10),
                         (10, 12),
                         (12, 14),
                         (14, 16)],
         'irreps': {'A1g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    'A1u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    'A2g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    'A2u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    'B1g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    'B1u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    'B2g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    'B2u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    'Eg': {'dim': 2,
                           'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                        [[-1.0, 0.0], [0.0, -1.0]],
                                        [[1j, 0j], [0j, (-0-1j)]],
                                        [[(-0-1j), 0j], [0j, 1j]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0.0, -1.0], [-1.0, 0.0]],
                                        [[0j, (-0-1j)], [1j, 0j]],
                                        [[0j, 1j], [(-0-1j), 0j]],
                                        [[1.0, 0.0], [0.0, 1.0]],
                                        [[-1.0, 0.0], [0.0, -1.0]],
                                        [[1j, 0j], [0j, (-0-1j)]],
                                        [[(-0-1j), 0j], [0j, 1j]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0.0, -1.0], [-1.0, 0.0]],
                                        [[0j, (-0-1j)], [1j, 0j]],
                                        [[0j, 1j], [(-0-1j), 0j]]]},
                    'Eu': {'dim': 2,
                           'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                        [[-1.0, 0.0], [0.0, -1.0]],
                                        [[1j, 0j], [0j, (-0-1j)]],
                                        [[(-0-1j), 0j], [0j, 1j]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0.0, -1.0], [-1.0, 0.0]],
                                        [[0j, (-0-1j)], [1j, 0j]],
                                        [[0j, 1j], [(-0-1j), 0j]],
                                        [[-1.0, 0.0], [0.0, -1.0]],
                                        [[1.0, 0.0], [0.0, 1.0]],
                                        [[(-0-1j), 0j], [0j, 1j]],
                                        [[1j, 0j], [0j, (-0-1j)]],
                                        [[0.0, -1.0], [-1.0, 0.0]],
                                        [[0.0, 1.0], [1.0, 0.0]],
                                        [[0j, 1j], [(-0-1j), 0j]],
                                        [[0j, (-0-1j)], [1j, 0j]]]}},
         'nclass': 10,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[0, -1, 0], [1, 0, 0], [0, 0, 1]],
                       [[0, 1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, 1, 0], [0, 0, -1]],
                       [[1, 0, 0], [0, -1, 0], [0, 0, -1]],
                       [[0, 1, 0], [1, 0, 0], [0, 0, -1]],
                       [[0, -1, 0], [-1, 0, 0], [0, 0, -1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, -1]],
                       [[1, 0, 0], [0, 1, 0], [0, 0, -1]],
                       [[0, 1, 0], [-1, 0, 0], [0, 0, -1]],
                       [[0, -1, 0], [1, 0, 0], [0, 0, -1]],
                       [[1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[0, -1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[0, 1, 0], [1, 0, 0], [0, 0, 1]]]},
 'D6': {'class_names': ['1+', '3+', '2+', '6+', '2+', '2+'],
        'class_range': [(0, 1), (1, 3), (3, 4), (4, 6), (6, 9), (9, 12)],
        'irreps': {'A1': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]]]},
                   'A2': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]]]},
                   'B1': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]]]},
                   'B2': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]]]},
                   'E1': {'dim': 2,
                          'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[-1.0, 0.0], [0.0, -1.0]],
                                       [[(0.5-0.86603j), 0j],
                                        [0j, (0.5+0.86603j)]],
                                       [[(0.5+0.86603j), 0j],
                                        [0j, (0.5-0.86603j)]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[0.0, -1.0], [-1.0, 0.0]],
                                       [[0j, (0.5+0.86603j)],
                                        [(0.5-0.86603j), 0j]],
                                       [[0j, (0.5-0.86603j)],
                                        [(0.5+0.86603j), 0j]]]},
                   'E2': {'dim': 2,
                          'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[1.0, 0.0], [0.0, 1.0]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]]]}},
        'nclass': 6,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                      [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                      [[0, 1, 0], [-1, 1, 0], [0, 0, 1]],
                      [[1, -1, 0], [1, 0, 0], [0, 0, 1]],
                      [[0, 1, 0], [1, 0, 0], [0, 0, -1]],
                      [[1, -1, 0], [0, -1, 0], [0, 0, -1]],
                      [[-1, 0, 0], [-1, 1, 0], [0, 0, -1]],
                      [[0, -1, 0], [-1, 0, 0], [0, 0, -1]],
                      [[-1, 1, 0], [0, 1, 0], [0, 0, -1]],
                      [[1, 0, 0], [1, -1, 0], [0, 0, -1]]]},
 'D6h': {'class_names': ['1+',
                         '3+',
                         '2+',
                         '6+',
                         '2+',
                         '2+',
                         '-2-',
                         '-6-',
                         '-2+',
                         '-6+',
                         '-2+',
                         '-2+'],
         'class_range': [(0, 1),
                         (1, 3),
                         (3, 4),
                         (4, 6),
                         (6, 9),
                         (9, 12),
                         (12, 13),
                         (13, 15),
                         (15, 16),
                         (16, 18),
                         (18, 21),
                         (21, 24)],
         'irreps': {'A1g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    'A1u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    'A2g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    'A2u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    'B1g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    'B1u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    'B2g': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]]]},
                    'B2u': {'dim': 1,
                            'matrices': [[[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[1.0]],
                                         [[-1.0]],
                                         [[-1.0]],
                                         [[-1.0]]]},
                    'E1g': {'dim': 2,
                            'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                         [[(-0.5+0.86603j), 0j],
                                          [0j, (-0.5-0.86603j)]],
                                         [[(-0.5-0.86603j), 0j],
                                          [0j, (-0.5+0.86603j)]],
                                         [[-1.0, 0.0], [0.0, -1.0]],
                                         [[(0.5-0.86603j), 0j],
                                          [0j, (0.5+0.86603j)]],
                                         [[(0.5+0.86603j), 0j],
                                          [0j, (0.5-0.86603j)]],
                                         [[0.0, 1.0], [1.0, 0.0]],
                                         [[0j, (-0.5-0.86603j)],
                                          [(-0.5+0.86603j), 0j]],
                                         [[0j, (-0.5+0.86603j)],
                                          [(-0.5-0.86603j), 0j]],
                                         [[0.0, -1.0], [-1.0, 0.0]],
                                         [[0j, (0.5+0.86603j)],
                                          [(0.5-0.86603j), 0j]],
                                         [[0j, (0.5-0.86603j)],
                                          [(0.5+0.86603j), 0j]],
                                         [[1.0, 0.0], [0.0, 1.0]],
                                         [[(-0.5+0.86603j), 0j],
                                          [0j, (-0.5-0.86603j)]],
                                         [[(-0.5-0.86603j), 0j],
                                          [0j, (-0.5+0.86603j)]],
                                         [[-1.0, 0.0], [0.0, -1.0]],
                                         [[(0.5-0.86603j), 0j],
                                          [0j, (0.5+0.86603j)]],
                                         [[(0.5+0.86603j), 0j],
                                          [0j, (0.5-0.86603j)]],
                                         [[0.0, 1.0], [1.0, 0.0]],
                                         [[0j, (-0.5-0.86603j)],
                                          [(-0.5+0.86603j), 0j]],
                                         [[0j, (-0.5+0.86603j)],
                                          [(-0.5-0.86603j), 0j]],
                                         [[0.0, -1.0], [-1.0, 0.0]],
                                         [[0j, (0.5+0.86603j)],
                                          [(0.5-0.86603j), 0j]],
                                         [[0j, (0.5-0.86603j)],
                                          [(0.5+0.86603j), 0j]]]},
                    'E1u': {'dim': 2,
                            'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                         [[(-0.5+0.86603j), 0j],
                                          [0j, (-0.5-0.86603j)]],
                                         [[(-0.5-0.86603j), 0j],
                                          [0j, (-0.5+0.86603j)]],
                                         [[-1.0, 0.0], [0.0, -1.0]],
                                         [[(0.5-0.86603j), 0j],
                                          [0j, (0.5+0.86603j)]],
                                         [[(0.5+0.86603j), 0j],
                                          [0j, (0.5-0.86603j)]],
                                         [[0.0, 1.0], [1.0, 0.0]],
                                         [[0j, (-0.5-0.86603j)],
                                          [(-0.5+0.86603j), 0j]],
                                         [[0j, (-0.5+0.86603j)],
                                          [(-0.5-0.86603j), 0j]],
                                         [[0.0, -1.0], [-1.0, 0.0]],
                                         [[0j, (0.5+0.86603j)],
                                          [(0.5-0.86603j), 0j]],
                                         [[0j, (0.5-0.86603j)],
                                          [(0.5+0.86603j), 0j]],
                                         [[-1.0, 0.0], [0.0, -1.0]],
                                         [[(0.5-0.86603j), 0j],
                                          [0j, (0.5+0.86603j)]],
                                         [[(0.5+0.86603j), 0j],
                                          [0j, (0.5-0.86603j)]],
                                         [[1.0, 0.0], [0.0, 1.0]],
                                         [[(-0.5+0.86603j), 0j],
                                          [0j, (-0.5-0.86603j)]],
                                         [[(-0.5-0.86603j), 0j],
                                          [0j, (-0.5+0.86603j)]],
                                         [[0.0, -1.0], [-1.0, 0.0]],
                                         [[0j, (0.5+0.86603j)],
                                          [(0.5-0.86603j), 0j]],
                                         [[0j, (0.5-0.86603j)],
                                          [(0.5+0.86603j), 0j]],
                                         [[0.0, 1.0], [1.0, 0.0]],
                                         [[0j, (-0.5-0.86603j)],
                                          [(-0.5+0.86603j), 0j]],
                                         [[0j, (-0.5+0.86603j)],
                                          [(-0.5-0.86603j), 0j]]]},
                    'E2g': {'dim': 2,
                            'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                         [[(-0.5+0.86603j), 0j],
                                          [0j, (-0.5-0.86603j)]],
                                         [[(-0.5-0.86603j), 0j],
                                          [0j, (-0.5+0.86603j)]],
                                         [[1.0, 0.0], [0.0, 1.0]],
                                         [[(-0.5+0.86603j), 0j],
                                          [0j, (-0.5-0.86603j)]],
                                         [[(-0.5-0.86603j), 0j],
                                          [0j, (-0.5+0.86603j)]],
                                         [[0.0, 1.0], [1.0, 0.0]],
                                         [[0j, (-0.5-0.86603j)],
                                          [(-0.5+0.86603j), 0j]],
                                         [[0j, (-0.5+0.86603j)],
                                          [(-0.5-0.86603j), 0j]],
                                         [[0.0, 1.0], [1.0, 0.0]],
                                         [[0j, (-0.5-0.86603j)],
                                          [(-0.5+0.86603j), 0j]],
                                         [[0j, (-0.5+0.86603j)],
                                          [(-0.5-0.86603j), 0j]],
                                         [[1.0, 0.0], [0.0, 1.0]],
                                         [[(-0.5+0.86603j), 0j],
                                          [0j, (-0.5-0.86603j)]],
                                         [[(-0.5-0.86603j), 0j],
                                          [0j, (-0.5+0.86603j)]],
                                         [[1.0, 0.0], [0.0, 1.0]],
                                         [[(-0.5+0.86603j), 0j],
                                          [0j, (-0.5-0.86603j)]],
                                         [[(-0.5-0.86603j), 0j],
                                          [0j, (-0.5+0.86603j)]],
                                         [[0.0, 1.0], [1.0, 0.0]],
                                         [[0j, (-0.5-0.86603j)],
                                          [(-0.5+0.86603j), 0j]],
                                         [[0j, (-0.5+0.86603j)],
                                          [(-0.5-0.86603j), 0j]],
                                         [[0.0, 1.0], [1.0, 0.0]],
                                         [[0j, (-0.5-0.86603j)],
                                          [(-0.5+0.86603j), 0j]],
                                         [[0j, (-0.5+0.86603j)],
                                          [(-0.5-0.86603j), 0j]]]},
                    'E2u': {'dim': 2,
                            'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                         [[(-0.5+0.86603j), 0j],
                                          [0j, (-0.5-0.86603j)]],
                                         [[(-0.5-0.86603j), 0j],
                                          [0j, (-0.5+0.86603j)]],
                                         [[1.0, 0.0], [0.0, 1.0]],
                                         [[(-0.5+0.86603j), 0j],
                                          [0j, (-0.5-0.86603j)]],
                                         [[(-0.5-0.86603j), 0j],
                                          [0j, (-0.5+0.86603j)]],
                                         [[0.0, 1.0], [1.0, 0.0]],
                                         [[0j, (-0.5-0.86603j)],
                                          [(-0.5+0.86603j), 0j]],
                                         [[0j, (-0.5+0.86603j)],
                                          [(-0.5-0.86603j), 0j]],
                                         [[0.0, 1.0], [1.0, 0.0]],
                                         [[0j, (-0.5-0.86603j)],
                                          [(-0.5+0.86603j), 0j]],
                                         [[0j, (-0.5+0.86603j)],
                                          [(-0.5-0.86603j), 0j]],
                                         [[-1.0, 0.0], [0.0, -1.0]],
                                         [[(0.5-0.86603j), 0j],
                                          [0j, (0.5+0.86603j)]],
                                         [[(0.5+0.86603j), 0j],
                                          [0j, (0.5-0.86603j)]],
                                         [[-1.0, 0.0], [0.0, -1.0]],
                                         [[(0.5-0.86603j), 0j],
                                          [0j, (0.5+0.86603j)]],
                                         [[(0.5+0.86603j), 0j],
                                          [0j, (0.5-0.86603j)]],
                                         [[0.0, -1.0], [-1.0, 0.0]],
                                         [[0j, (0.5+0.86603j)],
                                          [(0.5-0.86603j), 0j]],
                                         [[0j, (0.5-0.86603j)],
                                          [(0.5+0.86603j), 0j]],
                                         [[0.0, -1.0], [-1.0, 0.0]],
                                         [[0j, (0.5+0.86603j)],
                                          [(0.5-0.86603j), 0j]],
                                         [[0j, (0.5-0.86603j)],
                                          [(0.5+0.86603j), 0j]]]}},
         'nclass': 12,
         'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, 1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                       [[0, 1, 0], [-1, 1, 0], [0, 0, 1]],
                       [[1, -1, 0], [1, 0, 0], [0, 0, 1]],
                       [[0, 1, 0], [1, 0, 0], [0, 0, -1]],
                       [[1, -1, 0], [0, -1, 0], [0, 0, -1]],
                       [[-1, 0, 0], [-1, 1, 0], [0, 0, -1]],
                       [[0, -1, 0], [-1, 0, 0], [0, 0, -1]],
                       [[-1, 1, 0], [0, 1, 0], [0, 0, -1]],
                       [[1, 0, 0], [1, -1, 0], [0, 0, -1]],
                       [[-1, 0, 0], [0, -1, 0], [0, 0, -1]],
                       [[0, 1, 0], [-1, 1, 0], [0, 0, -1]],
                       [[1, -1, 0], [1, 0, 0], [0, 0, -1]],
                       [[1, 0, 0], [0, 1, 0], [0, 0, -1]],
                       [[0, -1, 0], [1, -1, 0], [0, 0, -1]],
                       [[-1, 1, 0], [-1, 0, 0], [0, 0, -1]],
                       [[0, -1, 0], [-1, 0, 0], [0, 0, 1]],
                       [[-1, 1, 0], [0, 1, 0], [0, 0, 1]],
                       [[1, 0, 0], [1, -1, 0], [0, 0, 1]],
                       [[0, 1, 0], [1, 0, 0], [0, 0, 1]],
                       [[1, -1, 0], [0, -1, 0], [0, 0, 1]],
                       [[-1, 0, 0], [-1, 1, 0], [0, 0, 1]]]},
 'O': {'class_names': ['1+', '2+', '3+', '2+', '4+'],
       'class_range': [(0, 1), (1, 4), (4, 12), (12, 18), (18, 24)],
       'irreps': {'A1': {'dim': 1,
                         'matrices': [[[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]]]},
                  'A2': {'dim': 1,
                         'matrices': [[[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[-1.0]],
                                      [[-1.0]],
                                      [[-1.0]],
                                      [[-1.0]],
                                      [[-1.0]],
                                      [[-1.0]],
                                      [[-1.0]],
                                      [[-1.0]],
                                      [[-1.0]],
                                      [[-1.0]],
                                      [[-1.0]],
                                      [[-1.0]]]},
                  'E': {'dim': 2,
                        'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                     [[1.0, 0.0], [0.0, 1.0]],
                                     [[1.0, 0.0], [0.0, 1.0]],
                                     [[1.0, 0.0], [0.0, 1.0]],
                                     [[(-0.5+0.86603j), 0j],
                                      [0j, (-0.5-0.86603j)]],
                                     [[(-0.5+0.86603j), 0j],
                                      [0j, (-0.5-0.86603j)]],
                                     [[(-0.5+0.86603j), 0j],
                                      [0j, (-0.5-0.86603j)]],
                                     [[(-0.5+0.86603j), 0j],
                                      [0j, (-0.5-0.86603j)]],
                                     [[(-0.5-0.86603j), 0j],
                                      [0j, (-0.5+0.86603j)]],
                                     [[(-0.5-0.86603j), 0j],
                                      [0j, (-0.5+0.86603j)]],
                                     [[(-0.5-0.86603j), 0j],
                                      [0j, (-0.5+0.86603j)]],
                                     [[(-0.5-0.86603j), 0j],
                                      [0j, (-0.5+0.86603j)]],
                                     [[0.0, 1.0], [1.0, 0.0]],
                                     [[0.0, 1.0], [1.0, 0.0]],
                                     [[0j, (-0.5-0.86603j)],
                                      [(-0.5+0.86603j), 0j]],
                                     [[0j, (-0.5-0.86603j)],
                                      [(-0.5+0.86603j), 0j]],
                                     [[0j, (-0.5+0.86603j)],
                                      [(-0.5-0.86603j), 0j]],
                                     [[0j, (-0.5+0.86603j)],
                                      [(-0.5-0.86603j), 0j]],
                                     [[0.0, 1.0], [1.0, 0.0]],
                                     [[0.0, 1.0], [1.0, 0.0]],
                                     [[0j, (-0.5-0.86603j)],
                                      [(-0.5+0.86603j), 0j]],
                                     [[0j, (-0.5-0.86603j)],
                                      [(-0.5+0.86603j), 0j]],
                                     [[0j, (-0.5+0.86603j)],
                                      [(-0.5-0.86603j), 0j]],
                                     [[0j, (-0.5+0.86603j)],
                                      [(-0.5-0.86603j), 0j]]]},
                  'T1': {'dim': 3,
                         'matrices': [[[1.0, 0.0, 0.0],
                                       [0.0, 1.0, 0.0],
                                       [0.0, 0.0, 1.0]],
                                      [[1.0, 0.0, 0.0],
                                       [0.0, -1.0, 0.0],
                                       [0.0, 0.0, -1.0]],
                                      [[-1.0, 0.0, 0.0],
                                       [0.0, 1.0, 0.0],
                                       [0.0, 0.0, -1.0]],
                                      [[-1.0, 0.0, 0.0],
                                       [0.0, -1.0, 0.0],
                                       [0.0, 0.0, 1.0]],
                                      [[0.0, 0.0, 1.0],
                                       [1.0, 0.0, 0.0],
                                       [0.0, 1.0, 0.0]],
                                      [[0.0, 0.0, -1.0],
                                       [1.0, 0.0, 0.0],
                                       [0.0, -1.0, 0.0]],
                                      [[0.0, 0.0, -1.0],
                                       [-1.0, 0.0, 0.0],
                                       [0.0, 1.0, 0.0]],
                                      [[0.0, 0.0, 1.0],
                                       [-1.0, 0.0, 0.0],
                                       [0.0, -1.0, 0.0]],
                                      [[0.0, 1.0, 0.0],
                                       [0.0, 0.0, 1.0],
                                       [1.0, 0.0, 0.0]],
                                      [[0.0, -1.0, 0.0],
                                       [0.0, 0.0, -1.0],
                                       [1.0, 0.0, 0.0]],
                                      [[0.0, 1.0, 0.0],
                                       [0.0, 0.0, -1.0],
                                       [-1.0, 0.0, 0.0]],
                                      [[0.0, -1.0, 0.0],
                                       [0.0, 0.0, 1.0],
                                       [-1.0, 0.0, 0.0]],
                                      [[-1.0, 0.0, 0.0],
                                       [0.0, 0.0, 1.0],
                                       [0.0, 1.0, 0.0]],
                                      [[-1.0, 0.0, 0.0],
                                       [0.0, 0.0, -1.0],
                                       [0.0, -1.0, 0.0]],
                                      [[0.0, 0.0, 1.0],
                                       [0.0, -1.0, 0.0],
                                       [1.0, 0.0, 0.0]],
                                      [[0.0, 0.0, -1.0],
                                       [0.0, -1.0, 0.0],
                                       [-1.0, 0.0, 0.0]],
                                      [[0.0, 1.0, 0.0],
                                       [1.0, 0.0, 0.0],
                                       [0.0, 0.0, -1.0]],
                                      [[0.0, -1.0, 0.0],
                                       [-1.0, 0.0, 0.0],
                                       [0.0, 0.0, -1.0]],
                                      [[1.0, 0.0, 0.0],
                                       [0.0, 0.0, -1.0],
                                       [0.0, 1.0, 0.0]],
                                      [[1.0, 0.0, 0.0],
                                       [0.0, 0.0, 1.0],
                                       [0.0, -1.0, 0.0]],
                                      [[0.0, 0.0, -1.0],
                                       [0.0, 1.0, 0.0],
                                       [1.0, 0.0, 0.0]],
                                      [[0.0, 0.0, 1.0],
                                       [0.0, 1.0, 0.0],
                                       [-1.0, 0.0, 0.0]],
                                      [[0.0, -1.0, 0.0],
                                       [1.0, 0.0, 0.0],
                                       [0.0, 0.0, 1.0]],
                                      [[0.0, 1.0, 0.0],
                                       [-1.0, 0.0, 0.0],
                                       [0.0, 0.0, 1.0]]]},
                  'T2': {'dim': 3,
                         'matrices': [[[1.0, 0.0, 0.0],
                                       [0.0, 1.0, 0.0],
                                       [0.0, 0.0, 1.0]],
                                      [[1.0, 0.0, 0.0],
                                       [0.0, -1.0, 0.0],
                                       [0.0, 0.0, -1.0]],
                                      [[-1.0, 0.0, 0.0],
                                       [0.0, 1.0, 0.0],
                                       [0.0, 0.0, -1.0]],
                                      [[-1.0, 0.0, 0.0],
                                       [0.0, -1.0, 0.0],
                                       [0.0, 0.0, 1.0]],
                                      [[0.0, 0.0, 1.0],
                                       [1.0, 0.0, 0.0],
                                       [0.0, 1.0, 0.0]],
                                      [[0.0, 0.0, -1.0],
                                       [1.0, 0.0, 0.0],
                                       [0.0, -1.0, 0.0]],
                                      [[0.0, 0.0, -1.0],
                                       [-1.0, 0.0, 0.0],
                                       [0.0, 1.0, 0.0]],
                                      [[0.0, 0.0, 1.0],
                                       [-1.0, 0.0, 0.0],
                                       [0.0, -1.0, 0.0]],
                                      [[0.0, 1.0, 0.0],
                                       [0.0, 0.0, 1.0],
                                       [1.0, 0.0, 0.0]],
                                      [[0.0, -1.0, 0.0],
                                       [0.0, 0.0, -1.0],
                                       [1.0, 0.0, 0.0]],
                                      [[0.0, 1.0, 0.0],
                                       [0.0, 0.0, -1.0],
                                       [-1.0, 0.0, 0.0]],
                                      [[0.0, -1.0, 0.0],
                                       [0.0, 0.0, 1.0],
                                       [-1.0, 0.0, 0.0]],
                                      [[1.0, 0.0, 0.0],
                                       [0.0, 0.0, -1.0],
                                       [0.0, -1.0, 0.0]],
                                      [[1.0, 0.0, 0.0],
                                       [0.0, 0.0, 1.0],
                                       [0.0, 1.0, 0.0]],
                                      [[0.0, 0.0, -1.0],
                                       [0.0, 1.0, 0.0],
                                       [-1.0, 0.0, 0.0]],
                                      [[0.0, 0.0, 1.0],
                                       [0.0, 1.0, 0.0],
                                       [1.0, 0.0, 0.0]],
                                      [[0.0, -1.0, 0.0],
                                       [-1.0, 0.0, 0.0],
                                       [0.0, 0.0, 1.0]],
                                      [[0.0, 1.0, 0.0],
                                       [1.0, 0.0, 0.0],
                                       [0.0, 0.0, 1.0]],
                                      [[-1.0, 0.0, 0.0],
                                       [0.0, 0.0, 1.0],
                                       [0.0, -1.0, 0.0]],
                                      [[-1.0, 0.0, 0.0],
                                       [0.0, 0.0, -1.0],
                                       [0.0, 1.0, 0.0]],
                                      [[0.0, 0.0, 1.0],
                                       [0.0, -1.0, 0.0],
                                       [-1.0, 0.0, 0.0]],
                                      [[0.0, 0.0, -1.0],
                                       [0.0, -1.0, 0.0],
                                       [1.0, 0.0, 0.0]],
                                      [[0.0, 1.0, 0.0],
                                       [-1.0, 0.0, 0.0],
                                       [0.0, 0.0, -1.0]],
                                      [[0.0, -1.0, 0.0],
                                       [1.0, 0.0, 0.0],
                                       [0.0, 0.0, -1.0]]]}},
       'nclass': 5,
       'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                     [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                     [[1, 0, 0], [0, -1, 0], [0, 0, -1]],
                     [[-1, 0, 0], [0, 1, 0], [0, 0, -1]],
                     [[0, 0, 1], [1, 0, 0], [0, 1, 0]],
                     [[0, 0, 1], [-1, 0, 0], [0, -1, 0]],
                     [[0, 0, -1], [1, 0, 0], [0, -1, 0]],
                     [[0, 0, -1], [-1, 0, 0], [0, 1, 0]],
                     [[0, 1, 0], [0, 0, 1], [1, 0, 0]],
                     [[0, -1, 0], [0, 0, 1], [-1, 0, 0]],
                     [[0, -1, 0], [0, 0, -1], [1, 0, 0]],
                     [[0, 1, 0], [0, 0, -1], [-1, 0, 0]],
                     [[0, 1, 0], [1, 0, 0], [0, 0, -1]],
                     [[0, -1, 0], [-1, 0, 0], [0, 0, -1]],
                     [[-1, 0, 0], [0, 0, 1], [0, 1, 0]],
                     [[-1, 0, 0], [0, 0, -1], [0, -1, 0]],
                     [[0, 0, 1], [0, -1, 0], [1, 0, 0]],
                     [[0, 0, -1], [0, -1, 0], [-1, 0, 0]],
                     [[0, -1, 0], [1, 0, 0], [0, 0, 1]],
                     [[0, 1, 0], [-1, 0, 0], [0, 0, 1]],
                     [[1, 0, 0], [0, 0, 1], [0, -1, 0]],
                     [[1, 0, 0], [0, 0, -1], [0, 1, 0]],
                     [[0, 0, 1], [0, 1, 0], [-1, 0, 0]],
                     [[0, 0, -1], [0, 1, 0], [1, 0, 0]]]},
 'Oh': {'class_names': ['1+',
                        '2+',
                        '3+',
                        '2+',
                        '4+',
                        '-2-',
                        '-2+',
                        '-6-',
                        '-2+',
                        '-4+'],
        'class_range': [(0, 1),
                        (1, 4),
                        (4, 12),
                        (12, 18),
                        (18, 24),
                        (24, 25),
                        (25, 28),
                        (28, 36),
                        (36, 42),
                        (42, 48)],
        'irreps': {'A1g': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                   'A1u': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                   'A2g': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]]]},
                   'A2u': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]]]},
                   'Eg': {'dim': 2,
                          'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                       [[1.0, 0.0], [0.0, 1.0]],
                                       [[1.0, 0.0], [0.0, 1.0]],
                                       [[1.0, 0.0], [0.0, 1.0]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[1.0, 0.0], [0.0, 1.0]],
                                       [[1.0, 0.0], [0.0, 1.0]],
                                       [[1.0, 0.0], [0.0, 1.0]],
                                       [[1.0, 0.0], [0.0, 1.0]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]]]},
                   'Eu': {'dim': 2,
                          'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                       [[1.0, 0.0], [0.0, 1.0]],
                                       [[1.0, 0.0], [0.0, 1.0]],
                                       [[1.0, 0.0], [0.0, 1.0]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5+0.86603j), 0j],
                                        [0j, (-0.5-0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[(-0.5-0.86603j), 0j],
                                        [0j, (-0.5+0.86603j)]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0.0, 1.0], [1.0, 0.0]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5-0.86603j)],
                                        [(-0.5+0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[0j, (-0.5+0.86603j)],
                                        [(-0.5-0.86603j), 0j]],
                                       [[-1.0, 0.0], [0.0, -1.0]],
                                       [[-1.0, 0.0], [0.0, -1.0]],
                                       [[-1.0, 0.0], [0.0, -1.0]],
                                       [[-1.0, 0.0], [0.0, -1.0]],
                                       [[(0.5-0.86603j), 0j],
                                        [0j, (0.5+0.86603j)]],
                                       [[(0.5-0.86603j), 0j],
                                        [0j, (0.5+0.86603j)]],
                                       [[(0.5-0.86603j), 0j],
                                        [0j, (0.5+0.86603j)]],
                                       [[(0.5-0.86603j), 0j],
                                        [0j, (0.5+0.86603j)]],
                                       [[(0.5+0.86603j), 0j],
                                        [0j, (0.5-0.86603j)]],
                                       [[(0.5+0.86603j), 0j],
                                        [0j, (0.5-0.86603j)]],
                                       [[(0.5+0.86603j), 0j],
                                        [0j, (0.5-0.86603j)]],
                                       [[(0.5+0.86603j), 0j],
                                        [0j, (0.5-0.86603j)]],
                                       [[0.0, -1.0], [-1.0, 0.0]],
                                       [[0.0, -1.0], [-1.0, 0.0]],
                                       [[0j, (0.5+0.86603j)],
                                        [(0.5-0.86603j), 0j]],
                                       [[0j, (0.5+0.86603j)],
                                        [(0.5-0.86603j), 0j]],
                                       [[0j, (0.5-0.86603j)],
                                        [(0.5+0.86603j), 0j]],
                                       [[0j, (0.5-0.86603j)],
                                        [(0.5+0.86603j), 0j]],
                                       [[0.0, -1.0], [-1.0, 0.0]],
                                       [[0.0, -1.0], [-1.0, 0.0]],
                                       [[0j, (0.5+0.86603j)],
                                        [(0.5-0.86603j), 0j]],
                                       [[0j, (0.5+0.86603j)],
                                        [(0.5-0.86603j), 0j]],
                                       [[0j, (0.5-0.86603j)],
                                        [(0.5+0.86603j), 0j]],
                                       [[0j, (0.5-0.86603j)],
                                        [(0.5+0.86603j), 0j]]]},
                   'T1g': {'dim': 3,
                           'matrices': [[[1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]]]},
                   'T1u': {'dim': 3,
                           'matrices': [[[1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]]]},
                   'T2g': {'dim': 3,
                           'matrices': [[[1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]]]},
                   'T2u': {'dim': 3,
                           'matrices': [[[1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 1.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [1.0, 0.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[0.0, -1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0]],
                                        [[1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0],
                                         [0.0, -1.0, 0.0]],
                                        [[0.0, 0.0, -1.0],
                                         [0.0, 1.0, 0.0],
                                         [1.0, 0.0, 0.0]],
                                        [[0.0, 0.0, 1.0],
                                         [0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0]],
                                        [[0.0, -1.0, 0.0],
                                         [1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]],
                                        [[0.0, 1.0, 0.0],
                                         [-1.0, 0.0, 0.0],
                                         [0.0, 0.0, 1.0]]]}},
        'nclass': 10,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                      [[1, 0, 0], [0, -1, 0], [0, 0, -1]],
                      [[-1, 0, 0], [0, 1, 0], [0, 0, -1]],
                      [[0, 0, 1], [1, 0, 0], [0, 1, 0]],
                      [[0, 0, 1], [-1, 0, 0], [0, -1, 0]],
                      [[0, 0, -1], [1, 0, 0], [0, -1, 0]],
                      [[0, 0, -1], [-1, 0, 0], [0, 1, 0]],
                      [[0, 1, 0], [0, 0, 1], [1, 0, 0]],
                      [[0, -1, 0], [0, 0, 1], [-1, 0, 0]],
                      [[0, -1, 0], [0, 0, -1], [1, 0, 0]],
                      [[0, 1, 0], [0, 0, -1], [-1, 0, 0]],
                      [[0, 1, 0], [1, 0, 0], [0, 0, -1]],
                      [[0, -1, 0], [-1, 0, 0], [0, 0, -1]],
                      [[-1, 0, 0], [0, 0, 1], [0, 1, 0]],
                      [[-1, 0, 0], [0, 0, -1], [0, -1, 0]],
                      [[0, 0, 1], [0, -1, 0], [1, 0, 0]],
                      [[0, 0, -1], [0, -1, 0], [-1, 0, 0]],
                      [[0, -1, 0], [1, 0, 0], [0, 0, 1]],
                      [[0, 1, 0], [-1, 0, 0], [0, 0, 1]],
                      [[1, 0, 0], [0, 0, 1], [0, -1, 0]],
                      [[1, 0, 0], [0, 0, -1], [0, 1, 0]],
                      [[0, 0, 1], [0, 1, 0], [-1, 0, 0]],
                      [[0, 0, -1], [0, 1, 0], [1, 0, 0]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, -1]],
                      [[1, 0, 0], [0, 1, 0], [0, 0, -1]],
                      [[-1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[1, 0, 0], [0, -1, 0], [0, 0, 1]],
                      [[0, 0, -1], [-1, 0, 0], [0, -1, 0]],
                      [[0, 0, -1], [1, 0, 0], [0, 1, 0]],
                      [[0, 0, 1], [-1, 0, 0], [0, 1, 0]],
                      [[0, 0, 1], [1, 0, 0], [0, -1, 0]],
                      [[0, -1, 0], [0, 0, -1], [-1, 0, 0]],
                      [[0, 1, 0], [0, 0, -1], [1, 0, 0]],
                      [[0, 1, 0], [0, 0, 1], [-1, 0, 0]],
                      [[0, -1, 0], [0, 0, 1], [1, 0, 0]],
                      [[0, -1, 0], [-1, 0, 0], [0, 0, 1]],
                      [[0, 1, 0], [1, 0, 0], [0, 0, 1]],
                      [[1, 0, 0], [0, 0, -1], [0, -1, 0]],
                      [[1, 0, 0], [0, 0, 1], [0, 1, 0]],
                      [[0, 0, -1], [0, 1, 0], [-1, 0, 0]],
                      [[0, 0, 1], [0, 1, 0], [1, 0, 0]],
                      [[0, 1, 0], [-1, 0, 0], [0, 0, -1]],
                      [[0, -1, 0], [1, 0, 0], [0, 0, -1]],
                      [[-1, 0, 0], [0, 0, -1], [0, 1, 0]],
                      [[-1, 0, 0], [0, 0, 1], [0, -1, 0]],
                      [[0, 0, -1], [0, -1, 0], [1, 0, 0]],
                      [[0, 0, 1], [0, -1, 0], [-1, 0, 0]]]},
 'S4': {'class_names': ['1+', '2+', '-4+', '-4+'],
        'class_range': [(0, 1), (1, 2), (2, 3), (3, 4)],
        'irreps': {'A': {'dim': 1,
                         'matrices': [[[1.0]], [[1.0]], [[1.0]], [[1.0]]]},
                   'B': {'dim': 1,
                         'matrices': [[[1.0]], [[1.0]], [[-1.0]], [[-1.0]]]},
                   'E1': {'dim': 1,
                          'matrices': [[[1.0]], [[-1.0]], [[1j]], [[-1j]]]},
                   'E2': {'dim': 1,
                          'matrices': [[[1.0]], [[-1.0]], [[-1j]], [[1j]]]}},
        'nclass': 4,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                      [[0, 1, 0], [-1, 0, 0], [0, 0, -1]],
                      [[0, -1, 0], [1, 0, 0], [0, 0, -1]]]},
 'T': {'class_names': ['1+', '2+', '3+', '3+'],
       'class_range': [(0, 1), (1, 4), (4, 8), (8, 12)],
       'irreps': {'A': {'dim': 1,
                        'matrices': [[[1.0]],
                                     [[1.0]],
                                     [[1.0]],
                                     [[1.0]],
                                     [[1.0]],
                                     [[1.0]],
                                     [[1.0]],
                                     [[1.0]],
                                     [[1.0]],
                                     [[1.0]],
                                     [[1.0]],
                                     [[1.0]]]},
                  'E1': {'dim': 1,
                         'matrices': [[[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[(-0.5+0.86603j)]],
                                      [[(-0.5+0.86603j)]],
                                      [[(-0.5+0.86603j)]],
                                      [[(-0.5+0.86603j)]],
                                      [[(-0.5-0.86603j)]],
                                      [[(-0.5-0.86603j)]],
                                      [[(-0.5-0.86603j)]],
                                      [[(-0.5-0.86603j)]]]},
                  'E2': {'dim': 1,
                         'matrices': [[[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[1.0]],
                                      [[(-0.5-0.86603j)]],
                                      [[(-0.5-0.86603j)]],
                                      [[(-0.5-0.86603j)]],
                                      [[(-0.5-0.86603j)]],
                                      [[(-0.5+0.86603j)]],
                                      [[(-0.5+0.86603j)]],
                                      [[(-0.5+0.86603j)]],
                                      [[(-0.5+0.86603j)]]]},
                  'T': {'dim': 3,
                        'matrices': [[[1.0, 0.0, 0.0],
                                      [0.0, 1.0, 0.0],
                                      [0.0, 0.0, 1.0]],
                                     [[1.0, 0.0, 0.0],
                                      [0.0, -1.0, 0.0],
                                      [0.0, 0.0, -1.0]],
                                     [[-1.0, 0.0, 0.0],
                                      [0.0, -1.0, 0.0],
                                      [0.0, 0.0, 1.0]],
                                     [[-1.0, 0.0, 0.0],
                                      [0.0, 1.0, 0.0],
                                      [0.0, 0.0, -1.0]],
                                     [[0.0, 0.0, 1.0],
                                      [1.0, 0.0, 0.0],
                                      [0.0, 1.0, 0.0]],
                                     [[0.0, 0.0, -1.0],
                                      [1.0, 0.0, 0.0],
                                      [0.0, -1.0, 0.0]],
                                     [[0.0, 0.0, 1.0],
                                      [-1.0, 0.0, 0.0],
                                      [0.0, -1.0, 0.0]],
                                     [[0.0, 0.0, -1.0],
                                      [-1.0, 0.0, 0.0],
                                      [0.0, 1.0, 0.0]],
                                     [[0.0, 1.0, 0.0],
                                      [0.0, 0.0, 1.0],
                                      [1.0, 0.0, 0.0]],
                                     [[0.0, -1.0, 0.0],
                                      [0.0, 0.0, -1.0],
                                      [1.0, 0.0, 0.0]],
                                     [[0.0, -1.0, 0.0],
                                      [0.0, 0.0, 1.0],
                                      [-1.0, 0.0, 0.0]],
                                     [[0.0, 1.0, 0.0],
                                      [0.0, 0.0, -1.0],
                                      [-1.0, 0.0, 0.0]]]}},
       'nclass': 4,
       'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                     [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                     [[-1, 0, 0], [0, 1, 0], [0, 0, -1]],
                     [[1, 0, 0], [0, -1, 0], [0, 0, -1]],
                     [[0, 0, 1], [1, 0, 0], [0, 1, 0]],
                     [[0, 0, 1], [-1, 0, 0], [0, -1, 0]],
                     [[0, 0, -1], [-1, 0, 0], [0, 1, 0]],
                     [[0, 0, -1], [1, 0, 0], [0, -1, 0]],
                     [[0, 1, 0], [0, 0, 1], [1, 0, 0]],
                     [[0, -1, 0], [0, 0, 1], [-1, 0, 0]],
                     [[0, 1, 0], [0, 0, -1], [-1, 0, 0]],
                     [[0, -1, 0], [0, 0, -1], [1, 0, 0]]]},
 'Td': {'class_names': ['1+', '2+', '3+', '-2+', '-4+'],
        'class_range': [(0, 1), (1, 4), (4, 12), (12, 18), (18, 24)],
        'irreps': {'A1': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]]]},
                   'A2': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]]]},
                   'E': {'dim': 2,
                         'matrices': [[[1.0, 0.0], [0.0, 1.0]],
                                      [[1.0, 0.0], [0.0, 1.0]],
                                      [[1.0, 0.0], [0.0, 1.0]],
                                      [[1.0, 0.0], [0.0, 1.0]],
                                      [[(-0.5+0.86603j), 0j],
                                       [0j, (-0.5-0.86603j)]],
                                      [[(-0.5+0.86603j), 0j],
                                       [0j, (-0.5-0.86603j)]],
                                      [[(-0.5+0.86603j), 0j],
                                       [0j, (-0.5-0.86603j)]],
                                      [[(-0.5+0.86603j), 0j],
                                       [0j, (-0.5-0.86603j)]],
                                      [[(-0.5-0.86603j), 0j],
                                       [0j, (-0.5+0.86603j)]],
                                      [[(-0.5-0.86603j), 0j],
                                       [0j, (-0.5+0.86603j)]],
                                      [[(-0.5-0.86603j), 0j],
                                       [0j, (-0.5+0.86603j)]],
                                      [[(-0.5-0.86603j), 0j],
                                       [0j, (-0.5+0.86603j)]],
                                      [[0.0, 1.0], [1.0, 0.0]],
                                      [[0.0, 1.0], [1.0, 0.0]],
                                      [[0j, (-0.5-0.86603j)],
                                       [(-0.5+0.86603j), 0j]],
                                      [[0j, (-0.5-0.86603j)],
                                       [(-0.5+0.86603j), 0j]],
                                      [[0j, (-0.5+0.86603j)],
                                       [(-0.5-0.86603j), 0j]],
                                      [[0j, (-0.5+0.86603j)],
                                       [(-0.5-0.86603j), 0j]],
                                      [[0.0, 1.0], [1.0, 0.0]],
                                      [[0.0, 1.0], [1.0, 0.0]],
                                      [[0j, (-0.5-0.86603j)],
                                       [(-0.5+0.86603j), 0j]],
                                      [[0j, (-0.5-0.86603j)],
                                       [(-0.5+0.86603j), 0j]],
                                      [[0j, (-0.5+0.86603j)],
                                       [(-0.5-0.86603j), 0j]],
                                      [[0j, (-0.5+0.86603j)],
                                       [(-0.5-0.86603j), 0j]]]},
                   'T1': {'dim': 3,
                          'matrices': [[[1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [0.0, -1.0, 0.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [0.0, -1.0, 0.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[0.0, 0.0, 1.0],
                                        [0.0, -1.0, 0.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[0.0, 1.0, 0.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [0.0, -1.0, 0.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 0.0, 1.0],
                                        [0.0, 1.0, 0.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [0.0, 1.0, 0.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[0.0, -1.0, 0.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, 0.0, 1.0]]]},
                   'T2': {'dim': 3,
                          'matrices': [[[1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [0.0, 1.0, 0.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 0.0, 1.0],
                                        [0.0, 1.0, 0.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [0.0, 1.0, 0.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[0.0, -1.0, 0.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [0.0, 1.0, 0.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [0.0, -1.0, 0.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, 0.0, 1.0],
                                        [0.0, -1.0, 0.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[0.0, 1.0, 0.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, 0.0, -1.0]]]}},
        'nclass': 5,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                      [[1, 0, 0], [0, -1, 0], [0, 0, -1]],
                      [[-1, 0, 0], [0, 1, 0], [0, 0, -1]],
                      [[0, 0, 1], [1, 0, 0], [0, 1, 0]],
                      [[0, 0, 1], [-1, 0, 0], [0, -1, 0]],
                      [[0, 0, -1], [1, 0, 0], [0, -1, 0]],
                      [[0, 0, -1], [-1, 0, 0], [0, 1, 0]],
                      [[0, 1, 0], [0, 0, 1], [1, 0, 0]],
                      [[0, -1, 0], [0, 0, 1], [-1, 0, 0]],
                      [[0, -1, 0], [0, 0, -1], [1, 0, 0]],
                      [[0, 1, 0], [0, 0, -1], [-1, 0, 0]],
                      [[0, 1, 0], [1, 0, 0], [0, 0, 1]],
                      [[0, -1, 0], [-1, 0, 0], [0, 0, 1]],
                      [[1, 0, 0], [0, 0, 1], [0, 1, 0]],
                      [[1, 0, 0], [0, 0, -1], [0, -1, 0]],
                      [[0, 0, 1], [0, 1, 0], [1, 0, 0]],
                      [[0, 0, -1], [0, 1, 0], [-1, 0, 0]],
                      [[0, -1, 0], [1, 0, 0], [0, 0, -1]],
                      [[0, 1, 0], [-1, 0, 0], [0, 0, -1]],
                      [[-1, 0, 0], [0, 0, 1], [0, -1, 0]],
                      [[-1, 0, 0], [0, 0, -1], [0, 1, 0]],
                      [[0, 0, 1], [0, -1, 0], [-1, 0, 0]],
                      [[0, 0, -1], [0, -1, 0], [1, 0, 0]]]},
 'Th': {'class_names': ['1+', '2+', '3+', '3+', '-2-', '-2+', '-6-', '-6-'],
        'class_range': [(0, 1),
                        (1, 4),
                        (4, 8),
                        (8, 12),
                        (12, 13),
                        (13, 16),
                        (16, 20),
                        (20, 24)],
        'irreps': {'Ag': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]]]},
                   'Au': {'dim': 1,
                          'matrices': [[[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]],
                                       [[-1.0]]]},
                   'Eg1': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]]]},
                   'Eg2': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]]]},
                   'Eu1': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[(0.5-0.86603j)]],
                                        [[(0.5-0.86603j)]],
                                        [[(0.5-0.86603j)]],
                                        [[(0.5-0.86603j)]],
                                        [[(0.5+0.86603j)]],
                                        [[(0.5+0.86603j)]],
                                        [[(0.5+0.86603j)]],
                                        [[(0.5+0.86603j)]]]},
                   'Eu2': {'dim': 1,
                           'matrices': [[[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[1.0]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5-0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[(-0.5+0.86603j)]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[-1.0]],
                                        [[(0.5+0.86603j)]],
                                        [[(0.5+0.86603j)]],
                                        [[(0.5+0.86603j)]],
                                        [[(0.5+0.86603j)]],
                                        [[(0.5-0.86603j)]],
                                        [[(0.5-0.86603j)]],
                                        [[(0.5-0.86603j)]],
                                        [[(0.5-0.86603j)]]]},
                   'Tg': {'dim': 3,
                          'matrices': [[[1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0]]]},
                   'Tu': {'dim': 3,
                          'matrices': [[[1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0]],
                                       [[1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0]],
                                       [[0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, 1.0, 0.0]],
                                       [[0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0],
                                        [0.0, -1.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [-1.0, 0.0, 0.0]],
                                       [[0.0, 1.0, 0.0],
                                        [0.0, 0.0, -1.0],
                                        [1.0, 0.0, 0.0]],
                                       [[0.0, -1.0, 0.0],
                                        [0.0, 0.0, 1.0],
                                        [1.0, 0.0, 0.0]]]}},
        'nclass': 8,
        'rotations': [[[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, 1, 0], [0, 0, -1]],
                      [[1, 0, 0], [0, -1, 0], [0, 0, -1]],
                      [[0, 0, 1], [1, 0, 0], [0, 1, 0]],
                      [[0, 0, 1], [-1, 0, 0], [0, -1, 0]],
                      [[0, 0, -1], [-1, 0, 0], [0, 1, 0]],
                      [[0, 0, -1], [1, 0, 0], [0, -1, 0]],
                      [[0, 1, 0], [0, 0, 1], [1, 0, 0]],
                      [[0, -1, 0], [0, 0, 1], [-1, 0, 0]],
                      [[0, 1, 0], [0, 0, -1], [-1, 0, 0]],
                      [[0, -1, 0], [0, 0, -1], [1, 0, 0]],
                      [[-1, 0, 0], [0, -1, 0], [0, 0, -1]],
                      [[1, 0, 0], [0, 1, 0], [0, 0, -1]],
                      [[1, 0, 0], [0, -1, 0], [0, 0, 1]],
                      [[-1, 0, 0], [0, 1, 0], [0, 0, 1]],
                      [[0, 0, -1], [-1, 0, 0], [0, -1, 0]],
                      [[0, 0, -1], [1, 0, 0], [0, 1, 0]],
                      [[0, 0, 1], [1, 0, 0], [0, -1, 0]],
                      [[0, 0, 1], [-1, 0, 0], [0, 1, 0]],
                      [[0, -1, 0], [0, 0, -1], [-1, 0, 0]],
                      [[0, 1, 0], [0, 0, -1], [1, 0, 0]],
                      [[0, -1, 0], [0, 0, 1], [1, 0, 0]],
                      [[0, 1, 0], [0, 0, 1], [-1, 0, 0]]]}}
