"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("assert");
const lib_1 = require("../lib");
test.each([
    [lib_1.Weekday.SUNDAY, 0, 0, '0:00:00'],
    [lib_1.Weekday.SATURDAY, 0, 0, '6:00:00'],
    [lib_1.Weekday.SUNDAY, 24, 0, '0:24:00'],
    [lib_1.Weekday.SUNDAY, 0, 59, '0:00:59'],
])('valid maintenance time %s:%d:%d returns %s', (day, hour, minute, expected) => {
    assert_1.strictEqual(new lib_1.LustreMaintenanceTime({ day, hour, minute }).toTimestamp(), expected);
});
test.each([
    [lib_1.Weekday.TUESDAY, -1, 0],
    [lib_1.Weekday.TUESDAY, 25, 0],
    [lib_1.Weekday.TUESDAY, 1.2, 0],
])('invalid maintenance time hour %s:%d:%d', (day, hour, minute) => {
    expect(() => {
        new lib_1.LustreMaintenanceTime({ day, hour, minute });
    }).toThrowError('Maintenance time hour must be an integer between 0 and 24');
});
test.each([
    [lib_1.Weekday.TUESDAY, 0, -1],
    [lib_1.Weekday.TUESDAY, 0, 60],
    [lib_1.Weekday.TUESDAY, 0, 1.2],
])('invalid maintenance time minute %s:%d:%d', (day, hour, minute) => {
    expect(() => {
        new lib_1.LustreMaintenanceTime({ day, hour, minute });
    }).toThrowError('Maintenance time minute must be an integer between 0 and 59');
});
//# sourceMappingURL=data:application/json;base64,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