# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import unittest

import swagger_client
from swagger_client.api.events_api import EventsApi  # noqa: E501
from swagger_client.rest import ApiException


class TestEventsApi(unittest.TestCase):
    """EventsApi unit test stubs"""

    def setUp(self):
        self.api = EventsApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_create_registered_event(self):
        """Test case for create_registered_event

        CreateRegisteredEvent  # noqa: E501
        """
        pass

    def test_delete_registered_event(self):
        """Test case for delete_registered_event

        DeleteRegisteredEvent  # noqa: E501
        """
        pass

    def test_list_registered_events(self):
        """Test case for list_registered_events

        ListRegisteredEvents  # noqa: E501
        """
        pass

    def test_retrieve_registered_event(self):
        """Test case for retrieve_registered_event

        RetrieveRegisteredEvent  # noqa: E501
        """
        pass

    def test_update_registered_event(self):
        """Test case for update_registered_event

        UpdateRegisteredEvent  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
