# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class DataTypeMappingsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_transformation(self, body, container_id, data_source_id, mapping_id, **kwargs):  # noqa: E501
        """CreateTransformation  # noqa: E501

        Create a transformation for the type mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_transformation(body, container_id, data_source_id, mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateTypeMappingTransformationsRequest body: (required)
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :return: CreateTransformationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_transformation_with_http_info(body, container_id, data_source_id, mapping_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_transformation_with_http_info(body, container_id, data_source_id, mapping_id, **kwargs)  # noqa: E501
            return data

    def create_transformation_with_http_info(self, body, container_id, data_source_id, mapping_id, **kwargs):  # noqa: E501
        """CreateTransformation  # noqa: E501

        Create a transformation for the type mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_transformation_with_http_info(body, container_id, data_source_id, mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateTypeMappingTransformationsRequest body: (required)
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :return: CreateTransformationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'container_id', 'data_source_id', 'mapping_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_transformation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_transformation`")  # noqa: E501
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `create_transformation`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `create_transformation`")  # noqa: E501
        # verify the required parameter 'mapping_id' is set
        if ('mapping_id' not in params or
                params['mapping_id'] is None):
            raise ValueError("Missing the required parameter `mapping_id` when calling `create_transformation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501
        if 'mapping_id' in params:
            path_params['mapping_id'] = params['mapping_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateTransformationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_data_type_mapping(self, container_id, data_source_id, mapping_id, **kwargs):  # noqa: E501
        """DeleteDataTypeMapping  # noqa: E501

        Permanently remove data type mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data_type_mapping(container_id, data_source_id, mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :return: Generic200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_data_type_mapping_with_http_info(container_id, data_source_id, mapping_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_data_type_mapping_with_http_info(container_id, data_source_id, mapping_id, **kwargs)  # noqa: E501
            return data

    def delete_data_type_mapping_with_http_info(self, container_id, data_source_id, mapping_id, **kwargs):  # noqa: E501
        """DeleteDataTypeMapping  # noqa: E501

        Permanently remove data type mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data_type_mapping_with_http_info(container_id, data_source_id, mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :return: Generic200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'data_source_id', 'mapping_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_type_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `delete_data_type_mapping`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `delete_data_type_mapping`")  # noqa: E501
        # verify the required parameter 'mapping_id' is set
        if ('mapping_id' not in params or
                params['mapping_id'] is None):
            raise ValueError("Missing the required parameter `mapping_id` when calling `delete_data_type_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501
        if 'mapping_id' in params:
            path_params['mapping_id'] = params['mapping_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Generic200Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_transformation(self, container_id, data_source_id, mapping_id, transformation_id, **kwargs):  # noqa: E501
        """DeleteTransformation  # noqa: E501

        Delete a transformation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_transformation(container_id, data_source_id, mapping_id, transformation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :param str transformation_id: (required)
        :return: Generic200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_transformation_with_http_info(container_id, data_source_id, mapping_id, transformation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_transformation_with_http_info(container_id, data_source_id, mapping_id, transformation_id, **kwargs)  # noqa: E501
            return data

    def delete_transformation_with_http_info(self, container_id, data_source_id, mapping_id, transformation_id, **kwargs):  # noqa: E501
        """DeleteTransformation  # noqa: E501

        Delete a transformation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_transformation_with_http_info(container_id, data_source_id, mapping_id, transformation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :param str transformation_id: (required)
        :return: Generic200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'data_source_id', 'mapping_id', 'transformation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transformation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `delete_transformation`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `delete_transformation`")  # noqa: E501
        # verify the required parameter 'mapping_id' is set
        if ('mapping_id' not in params or
                params['mapping_id'] is None):
            raise ValueError("Missing the required parameter `mapping_id` when calling `delete_transformation`")  # noqa: E501
        # verify the required parameter 'transformation_id' is set
        if ('transformation_id' not in params or
                params['transformation_id'] is None):
            raise ValueError("Missing the required parameter `transformation_id` when calling `delete_transformation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501
        if 'mapping_id' in params:
            path_params['mapping_id'] = params['mapping_id']  # noqa: E501
        if 'transformation_id' in params:
            path_params['transformation_id'] = params['transformation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations/{transformation_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Generic200Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_type_mappings(self, container_id, data_source_id, **kwargs):  # noqa: E501
        """ExportTypeMappings  # noqa: E501

        Export type mappings for a datasource. Providing a JSON body is optional. If provided, the mapping_ids may be specified to indicate certain type mapping IDs to return. Additionally, a target data source may be provided to which the mappings will be copied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_type_mappings(container_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param TypeMappingExportPayload body:
        :return: list[TypeMapping]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_type_mappings_with_http_info(container_id, data_source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_type_mappings_with_http_info(container_id, data_source_id, **kwargs)  # noqa: E501
            return data

    def export_type_mappings_with_http_info(self, container_id, data_source_id, **kwargs):  # noqa: E501
        """ExportTypeMappings  # noqa: E501

        Export type mappings for a datasource. Providing a JSON body is optional. If provided, the mapping_ids may be specified to indicate certain type mapping IDs to return. Additionally, a target data source may be provided to which the mappings will be copied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_type_mappings_with_http_info(container_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param TypeMappingExportPayload body:
        :return: list[TypeMapping]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'data_source_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_type_mappings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `export_type_mappings`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `export_type_mappings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/datasources/{data_source_id}/mappings/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TypeMapping]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_data_type_mappings(self, container_id, data_source_id, **kwargs):  # noqa: E501
        """ImportDataTypeMappings  # noqa: E501

        Import type mappings for a datasource. Accepts either a JSON body or actual JSON file. The payload should be an array of type mapping classes, previously generated using the export route.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_data_type_mappings(container_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str file:
        :return: list[GetDataTypeMappingResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_data_type_mappings_with_http_info(container_id, data_source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.import_data_type_mappings_with_http_info(container_id, data_source_id, **kwargs)  # noqa: E501
            return data

    def import_data_type_mappings_with_http_info(self, container_id, data_source_id, **kwargs):  # noqa: E501
        """ImportDataTypeMappings  # noqa: E501

        Import type mappings for a datasource. Accepts either a JSON body or actual JSON file. The payload should be an array of type mapping classes, previously generated using the export route.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_data_type_mappings_with_http_info(container_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str file:
        :return: list[GetDataTypeMappingResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'data_source_id', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_data_type_mappings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `import_data_type_mappings`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `import_data_type_mappings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            form_params.append(('file', params['file']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/datasources/{data_source_id}/mappings/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GetDataTypeMappingResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_data_type_mappings(self, container_id, data_source_id, **kwargs):  # noqa: E501
        """ListDataTypeMappings  # noqa: E501

        Lists data type mappings for the data source  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_type_mappings(container_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param int limit:
        :param int offset:
        :param bool needs_transformations: boolean indicating if the return should consist of only mappings that need transformations
        :param bool count: boolean indicating if the return value should be a count only
        :param str sort_by: column to sort results by
        :param bool sort_desc: boolean indicating if results should be in descending order
        :param str resulting_metatype_name: if supplied, filters returned transformations by those that produce the resulting metatype
        :param str resulting_metatype_relationship_name: if supplied, filters returned transformations by those that produce the resulting metatype relationship
        :return: ListDataTypeMappingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_data_type_mappings_with_http_info(container_id, data_source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_data_type_mappings_with_http_info(container_id, data_source_id, **kwargs)  # noqa: E501
            return data

    def list_data_type_mappings_with_http_info(self, container_id, data_source_id, **kwargs):  # noqa: E501
        """ListDataTypeMappings  # noqa: E501

        Lists data type mappings for the data source  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_type_mappings_with_http_info(container_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param int limit:
        :param int offset:
        :param bool needs_transformations: boolean indicating if the return should consist of only mappings that need transformations
        :param bool count: boolean indicating if the return value should be a count only
        :param str sort_by: column to sort results by
        :param bool sort_desc: boolean indicating if results should be in descending order
        :param str resulting_metatype_name: if supplied, filters returned transformations by those that produce the resulting metatype
        :param str resulting_metatype_relationship_name: if supplied, filters returned transformations by those that produce the resulting metatype relationship
        :return: ListDataTypeMappingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'data_source_id', 'limit', 'offset', 'needs_transformations', 'count', 'sort_by', 'sort_desc', 'resulting_metatype_name', 'resulting_metatype_relationship_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_type_mappings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `list_data_type_mappings`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `list_data_type_mappings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'needs_transformations' in params:
            query_params.append(('needsTransformations', params['needs_transformations']))  # noqa: E501
        if 'count' in params:
            query_params.append(('count', params['count']))  # noqa: E501
        if 'sort_by' in params:
            query_params.append(('sortBy', params['sort_by']))  # noqa: E501
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))  # noqa: E501
        if 'resulting_metatype_name' in params:
            query_params.append(('resultingMetatypeName', params['resulting_metatype_name']))  # noqa: E501
        if 'resulting_metatype_relationship_name' in params:
            query_params.append(('resultingMetatypeRelationshipName', params['resulting_metatype_relationship_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/datasources/{data_source_id}/mappings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListDataTypeMappingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_transformations(self, container_id, data_source_id, mapping_id, **kwargs):  # noqa: E501
        """ListTransformations  # noqa: E501

        List transformations for a type mapping from storage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_transformations(container_id, data_source_id, mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :return: ListTransformationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_transformations_with_http_info(container_id, data_source_id, mapping_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_transformations_with_http_info(container_id, data_source_id, mapping_id, **kwargs)  # noqa: E501
            return data

    def list_transformations_with_http_info(self, container_id, data_source_id, mapping_id, **kwargs):  # noqa: E501
        """ListTransformations  # noqa: E501

        List transformations for a type mapping from storage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_transformations_with_http_info(container_id, data_source_id, mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :return: ListTransformationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'data_source_id', 'mapping_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transformations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `list_transformations`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `list_transformations`")  # noqa: E501
        # verify the required parameter 'mapping_id' is set
        if ('mapping_id' not in params or
                params['mapping_id'] is None):
            raise ValueError("Missing the required parameter `mapping_id` when calling `list_transformations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501
        if 'mapping_id' in params:
            path_params['mapping_id'] = params['mapping_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListTransformationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_data_type_mapping(self, container_id, data_source_id, mapping_id, **kwargs):  # noqa: E501
        """RetrieveDataTypeMapping  # noqa: E501

        Retrieve a data type mapping  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_data_type_mapping(container_id, data_source_id, mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :return: GetDataTypeMappingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_data_type_mapping_with_http_info(container_id, data_source_id, mapping_id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_data_type_mapping_with_http_info(container_id, data_source_id, mapping_id, **kwargs)  # noqa: E501
            return data

    def retrieve_data_type_mapping_with_http_info(self, container_id, data_source_id, mapping_id, **kwargs):  # noqa: E501
        """RetrieveDataTypeMapping  # noqa: E501

        Retrieve a data type mapping  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_data_type_mapping_with_http_info(container_id, data_source_id, mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :return: GetDataTypeMappingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'data_source_id', 'mapping_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_data_type_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `retrieve_data_type_mapping`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `retrieve_data_type_mapping`")  # noqa: E501
        # verify the required parameter 'mapping_id' is set
        if ('mapping_id' not in params or
                params['mapping_id'] is None):
            raise ValueError("Missing the required parameter `mapping_id` when calling `retrieve_data_type_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501
        if 'mapping_id' in params:
            path_params['mapping_id'] = params['mapping_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDataTypeMappingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_data_type_mapping(self, container_id, data_source_id, mapping_id, **kwargs):  # noqa: E501
        """UpdateDataTypeMapping  # noqa: E501

        Updates a data type mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data_type_mapping(container_id, data_source_id, mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :param TypeMapping body:
        :return: UpdateDataTypeMappingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_data_type_mapping_with_http_info(container_id, data_source_id, mapping_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_data_type_mapping_with_http_info(container_id, data_source_id, mapping_id, **kwargs)  # noqa: E501
            return data

    def update_data_type_mapping_with_http_info(self, container_id, data_source_id, mapping_id, **kwargs):  # noqa: E501
        """UpdateDataTypeMapping  # noqa: E501

        Updates a data type mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data_type_mapping_with_http_info(container_id, data_source_id, mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :param TypeMapping body:
        :return: UpdateDataTypeMappingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'data_source_id', 'mapping_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data_type_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `update_data_type_mapping`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `update_data_type_mapping`")  # noqa: E501
        # verify the required parameter 'mapping_id' is set
        if ('mapping_id' not in params or
                params['mapping_id'] is None):
            raise ValueError("Missing the required parameter `mapping_id` when calling `update_data_type_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501
        if 'mapping_id' in params:
            path_params['mapping_id'] = params['mapping_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateDataTypeMappingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_transformation(self, body, container_id, data_source_id, mapping_id, transformation_id, **kwargs):  # noqa: E501
        """UpdateTransformation  # noqa: E501

        Update a transformation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transformation(body, container_id, data_source_id, mapping_id, transformation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateTypeMappingTransformationsRequest body: (required)
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :param str transformation_id: (required)
        :return: UpdateTransformationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_transformation_with_http_info(body, container_id, data_source_id, mapping_id, transformation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_transformation_with_http_info(body, container_id, data_source_id, mapping_id, transformation_id, **kwargs)  # noqa: E501
            return data

    def update_transformation_with_http_info(self, body, container_id, data_source_id, mapping_id, transformation_id, **kwargs):  # noqa: E501
        """UpdateTransformation  # noqa: E501

        Update a transformation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transformation_with_http_info(body, container_id, data_source_id, mapping_id, transformation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateTypeMappingTransformationsRequest body: (required)
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param str mapping_id: (required)
        :param str transformation_id: (required)
        :return: UpdateTransformationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'container_id', 'data_source_id', 'mapping_id', 'transformation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_transformation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_transformation`")  # noqa: E501
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `update_transformation`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `update_transformation`")  # noqa: E501
        # verify the required parameter 'mapping_id' is set
        if ('mapping_id' not in params or
                params['mapping_id'] is None):
            raise ValueError("Missing the required parameter `mapping_id` when calling `update_transformation`")  # noqa: E501
        # verify the required parameter 'transformation_id' is set
        if ('transformation_id' not in params or
                params['transformation_id'] is None):
            raise ValueError("Missing the required parameter `transformation_id` when calling `update_transformation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501
        if 'mapping_id' in params:
            path_params['mapping_id'] = params['mapping_id']  # noqa: E501
        if 'transformation_id' in params:
            path_params['transformation_id'] = params['transformation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations/{transformation_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateTransformationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
