# Deep Lynx Python SDK
This is an SDK for the [Deep Lynx](https://github.com/idaholab/Deep-Lynx) data warehouse that supports Python projects. It is used for creating API requests and sending and receiving data from Deep Lynx. 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0
- Package version: 0.1.2
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Contributing

When running the swagger-codgen command to generate this code base, please supply the following language-specific options:  
`--additional-properties packageName=deep_lynx projectName=deep_lynx`

### Testing

Please provide the Deep Lynx API key and secret when performing testing. To do so, copy the `.env-sample` file and rename to `.env` and supply the needed values. Basic testing is currently performed within `test/test_create_manual_import.py`.   

## Requirements.

Python 2.7 or 3.4+

## Installation & Usage
### pip/poetry install

pip: `pip install deep_lynx`   
poetry: `poetry add deep_lynx`  

### GitHub

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import deep_lynx 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import deep_lynx
```

## Uploading this Distribution to PyPi  

Follow these steps for uploading the latest distribution to PyPI (requires maintainer access to the `deep_lynx` package). See the [official docs](https://packaging.python.org/tutorials/packaging-projects/#generating-distribution-archives) for more information.
- Ensure both the `build` and `twine` packages have been installed  
- Update `setup.py` and this README as necessary to update the `VERSION` and whatever other metadata adjustments are necessary  
- Run `python -m build` to generate the `dist/` directory with the source archive and built distribution files  
- Upload the archives to PyPI by running `python -m twine upload dist/*` and providing your PyPI user credentials  

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run something like the following example (Python 3):

```python
import deep_lynx
from deep_lynx.rest import ApiException
from pprint import pprint

# initialize an ApiClient for use with deep_lynx APIs
configuration = deep_lynx.configuration.Configuration()
configuration.host = 'http://localhost:8090'
apiClient = deep_lynx.ApiClient(configuration)

# authenticate via an API key and secret
authApi = deep_lynx.AuthenticationApi(apiClient)
apiKey = 'myKey'
apiSecret = 'mySecret'

token = authApi.retrieve_o_auth_token(x_api_key=apiKey, x_api_secret=apiSecret, x_api_expiry='1h')

# create a container
containerApi = deep_lynx.ContainersApi(apiClient)
container = containerApi.create_container(CreateContainerRequest(
    'myContainer', 'Container description', False
))
containerId = container.value[0].id

# create a data source
datasourcesApi = deep_lynx.DataSourcesApi(apiClient)

datasource = datasourcesApi.create_data_source(CreateDataSourceRequest(
    'sdk_test_source', 'standard', True
), containerId)
datasourceId = datasource.value.id

# create manual import
importResult = datasourcesApi.create_manual_import(
    {'test': 'test import'},
    containerId,
    datasourceId
)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8090* (or whatever your host and port is)

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**exchange_o_auth_token**](docs/AuthenticationApi.md#exchange_o_auth_token) | **POST** /oauth/exchange | ExchangeOAuthToken
*AuthenticationApi* | [**post_containers_container_id_metatypes_metatype_id**](docs/AuthenticationApi.md#post_containers_container_id_metatypes_metatype_id) | **POST** /containers/{container_id}/metatypes/{metatype_id} | post-containers-container_id-metatypes-metatype_id
*AuthenticationApi* | [**post_rsa_cancel**](docs/AuthenticationApi.md#post_rsa_cancel) | **POST** /rsa/cancel | post-rsa-cancel
*AuthenticationApi* | [**post_rsa_initialize**](docs/AuthenticationApi.md#post_rsa_initialize) | **POST** /rsa/initialize | post-rsa-initialize
*AuthenticationApi* | [**post_rsa_status**](docs/AuthenticationApi.md#post_rsa_status) | **POST** /rsa/status | post-rsa-status
*AuthenticationApi* | [**post_rsa_verify**](docs/AuthenticationApi.md#post_rsa_verify) | **POST** /rsa/verify | post-rsa-verify
*AuthenticationApi* | [**retrieve_o_auth_token**](docs/AuthenticationApi.md#retrieve_o_auth_token) | **GET** /oauth/token | RetrieveOAuthToken
*ContainersApi* | [**archive_container**](docs/ContainersApi.md#archive_container) | **DELETE** /containers/{container_id} | ArchiveContainer
*ContainersApi* | [**container_batch_update**](docs/ContainersApi.md#container_batch_update) | **PUT** /containers | ContainerBatchUpdate
*ContainersApi* | [**create_container**](docs/ContainersApi.md#create_container) | **POST** /containers | CreateContainer
*ContainersApi* | [**import_container**](docs/ContainersApi.md#import_container) | **POST** /containers/import | ImportContainer
*ContainersApi* | [**list_containers**](docs/ContainersApi.md#list_containers) | **GET** /containers | ListContainers
*ContainersApi* | [**repair_container_permissions**](docs/ContainersApi.md#repair_container_permissions) | **POST** /containers/{container_id}/permissions | RepairContainerPermissions
*ContainersApi* | [**retrieve_container**](docs/ContainersApi.md#retrieve_container) | **GET** /containers/{container_id} | RetrieveContainer
*ContainersApi* | [**set_container_active**](docs/ContainersApi.md#set_container_active) | **POST** /containers/{container_id}/active | SetContainerActive
*ContainersApi* | [**update_container**](docs/ContainersApi.md#update_container) | **PUT** /containers/{container_id} | UpdateContainer
*ContainersApi* | [**update_container_import**](docs/ContainersApi.md#update_container_import) | **PUT** /containers/import/{container_id} | UpdateContainerImport
*DataExportApi* | [**create_data_export**](docs/DataExportApi.md#create_data_export) | **POST** /containers/{container_id}/data/export | CreateDataExport
*DataExportApi* | [**delete_data_export**](docs/DataExportApi.md#delete_data_export) | **DELETE** /containers/{container_id}/data/export/{export_id} | DeleteDataExport
*DataExportApi* | [**list_data_exports**](docs/DataExportApi.md#list_data_exports) | **GET** /containers/{container_id}/data/export | ListDataExports
*DataExportApi* | [**retrieve_data_export**](docs/DataExportApi.md#retrieve_data_export) | **GET** /containers/{container_id}/data/export/{export_id} | RetrieveDataExport
*DataExportApi* | [**start_data_export**](docs/DataExportApi.md#start_data_export) | **POST** /containers/{container_id}/data/export/{export_id} | StartDataExport
*DataExportApi* | [**stop_data_export**](docs/DataExportApi.md#stop_data_export) | **PUT** /containers/{container_id}/data/export/{export_id} | StopDataExport
*DataQueryApi* | [**query_graph**](docs/DataQueryApi.md#query_graph) | **POST** /containers/{container_id}/query | QueryGraph
*DataSourcesApi* | [**archive_data_source**](docs/DataSourcesApi.md#archive_data_source) | **DELETE** /containers/{container_id}/import/datasources/{data_source_id} | ArchiveDataSource
*DataSourcesApi* | [**create_data_source**](docs/DataSourcesApi.md#create_data_source) | **POST** /containers/{container_id}/import/datasources | CreateDataSource
*DataSourcesApi* | [**create_manual_import**](docs/DataSourcesApi.md#create_manual_import) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/imports | CreateManualImport
*DataSourcesApi* | [**download_file**](docs/DataSourcesApi.md#download_file) | **GET** /containers/{container_id}/files/{file_id}/download | DownloadFile
*DataSourcesApi* | [**list_data_sources**](docs/DataSourcesApi.md#list_data_sources) | **GET** /containers/{container_id}/import/datasources | ListDataSources
*DataSourcesApi* | [**list_imports_for_data_source**](docs/DataSourcesApi.md#list_imports_for_data_source) | **GET** /containers/{container_id}/import/datasources/{data_source_id}/imports | ListImportsForDataSource
*DataSourcesApi* | [**retrieve_data_source**](docs/DataSourcesApi.md#retrieve_data_source) | **GET** /containers/{container_id}/import/datasources/{data_source_id} | RetrieveDataSource
*DataSourcesApi* | [**retrieve_file**](docs/DataSourcesApi.md#retrieve_file) | **GET** /containers/{container_id}/files/{file_id} | RetrieveFile
*DataSourcesApi* | [**set_data_source_active**](docs/DataSourcesApi.md#set_data_source_active) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/active | SetDataSourceActive
*DataSourcesApi* | [**set_data_source_configuration**](docs/DataSourcesApi.md#set_data_source_configuration) | **PUT** /containers/{container_id}/import/datasources/{data_source_id} | SetDataSourceConfiguration
*DataSourcesApi* | [**set_data_source_inactive**](docs/DataSourcesApi.md#set_data_source_inactive) | **DELETE** /containers/{container_id}/import/datasources/{data_source_id}/active | SetDataSourceInactive
*DataSourcesApi* | [**upload_file**](docs/DataSourcesApi.md#upload_file) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/files | UploadFile
*DataTypeMappingsApi* | [**create_transformation**](docs/DataTypeMappingsApi.md#create_transformation) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations | CreateTransformation
*DataTypeMappingsApi* | [**delete_data_type_mapping**](docs/DataTypeMappingsApi.md#delete_data_type_mapping) | **DELETE** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id} | DeleteDataTypeMapping
*DataTypeMappingsApi* | [**delete_transformation**](docs/DataTypeMappingsApi.md#delete_transformation) | **DELETE** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations/{transformation_id} | DeleteTransformation
*DataTypeMappingsApi* | [**export_type_mappings**](docs/DataTypeMappingsApi.md#export_type_mappings) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/mappings/export | ExportTypeMappings
*DataTypeMappingsApi* | [**import_data_type_mappings**](docs/DataTypeMappingsApi.md#import_data_type_mappings) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/mappings/import | ImportDataTypeMappings
*DataTypeMappingsApi* | [**list_data_type_mappings**](docs/DataTypeMappingsApi.md#list_data_type_mappings) | **GET** /containers/{container_id}/import/datasources/{data_source_id}/mappings | ListDataTypeMappings
*DataTypeMappingsApi* | [**list_transformations**](docs/DataTypeMappingsApi.md#list_transformations) | **GET** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations | ListTransformations
*DataTypeMappingsApi* | [**retrieve_data_type_mapping**](docs/DataTypeMappingsApi.md#retrieve_data_type_mapping) | **GET** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id} | RetrieveDataTypeMapping
*DataTypeMappingsApi* | [**update_data_type_mapping**](docs/DataTypeMappingsApi.md#update_data_type_mapping) | **PUT** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id} | UpdateDataTypeMapping
*DataTypeMappingsApi* | [**update_transformation**](docs/DataTypeMappingsApi.md#update_transformation) | **PUT** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations/{transformation_id} | UpdateTransformation
*EventsApi* | [**create_registered_event**](docs/EventsApi.md#create_registered_event) | **POST** /events | CreateRegisteredEvent
*EventsApi* | [**delete_registered_event**](docs/EventsApi.md#delete_registered_event) | **DELETE** /events/{event_id} | DeleteRegisteredEvent
*EventsApi* | [**list_registered_events**](docs/EventsApi.md#list_registered_events) | **GET** /events | ListRegisteredEvents
*EventsApi* | [**retrieve_registered_event**](docs/EventsApi.md#retrieve_registered_event) | **GET** /events/{event_id} | RetrieveRegisteredEvent
*EventsApi* | [**update_registered_event**](docs/EventsApi.md#update_registered_event) | **PUT** /events/{event_id} | UpdateRegisteredEvent
*GraphApi* | [**archive_edge**](docs/GraphApi.md#archive_edge) | **DELETE** /containers/{container_id}/graphs/edges/{edge_id} | ArchiveEdge
*GraphApi* | [**archive_node**](docs/GraphApi.md#archive_node) | **DELETE** /containers/{container_id}/graphs/nodes/{node_id} | ArchiveNode
*GraphApi* | [**attach_edge_file**](docs/GraphApi.md#attach_edge_file) | **PUT** /containers/{container_id}/graphs/edges/{edge_id}/files/{file_id} | AttachEdgeFile
*GraphApi* | [**attach_node_file**](docs/GraphApi.md#attach_node_file) | **PUT** /containers/{container_id}/graphs/nodes/{node_id}/files/{file_id} | AttachNodeFile
*GraphApi* | [**create_or_update_edges**](docs/GraphApi.md#create_or_update_edges) | **POST** /containers/{container_id}/graphs/edges | CreateOrUpdateEdges
*GraphApi* | [**create_or_update_nodes**](docs/GraphApi.md#create_or_update_nodes) | **POST** /containers/{container_id}/graphs/nodes | CreateOrUpdateNodes
*GraphApi* | [**delete_node_file**](docs/GraphApi.md#delete_node_file) | **DELETE** /containers/{container_id}/graphs/nodes/{node_id}/files/{file_id} | DeleteNodeFile
*GraphApi* | [**detach_node_file**](docs/GraphApi.md#detach_node_file) | **DELETE** /containers/{container_id}/graphs/edges/{edge_id}/files/{file_id} | DetachNodeFile
*GraphApi* | [**list_edge_files**](docs/GraphApi.md#list_edge_files) | **GET** /containers/{container_id}/graphs/edges/{edge_id}/files | ListEdgeFiles
*GraphApi* | [**list_edges**](docs/GraphApi.md#list_edges) | **GET** /containers/{container_id}/graphs/edges | ListEdges
*GraphApi* | [**list_node_files**](docs/GraphApi.md#list_node_files) | **GET** /containers/{container_id}/graphs/nodes/{node_id}/files | ListNodeFiles
*GraphApi* | [**list_nodes**](docs/GraphApi.md#list_nodes) | **GET** /containers/{container_id}/graphs/nodes | ListNodes
*GraphApi* | [**list_nodesby_metatype_id**](docs/GraphApi.md#list_nodesby_metatype_id) | **GET** /containers/{container_id}/graphs/nodes/metatype/{metatype_id} | ListNodesbyMetatypeID
*GraphApi* | [**retrieve_edge**](docs/GraphApi.md#retrieve_edge) | **GET** /containers/{container_id}/graphs/edges/{edge_id} | RetrieveEdge
*GraphApi* | [**retrieve_node**](docs/GraphApi.md#retrieve_node) | **GET** /containers/{container_id}/graphs/nodes/{node_id} | RetrieveNode
*ImportsApi* | [**add_data_to_import**](docs/ImportsApi.md#add_data_to_import) | **POST** /containers/{container_id}/datasources/{data_source_id}/imports/{import_id}/data | AddDataToImport
*ImportsApi* | [**create_import**](docs/ImportsApi.md#create_import) | **POST** /containers/{container_id}/datasources/{data_source_id}/imports | CreateImport
*ImportsApi* | [**delete_import**](docs/ImportsApi.md#delete_import) | **DELETE** /containers/{container_id}/import/imports/{import_id} | DeleteImport
*ImportsApi* | [**delete_import_data**](docs/ImportsApi.md#delete_import_data) | **DELETE** /containers/{container_id}/import/imports/{import_id}/data/{data_id} | DeleteImportData
*ImportsApi* | [**list_imports_data**](docs/ImportsApi.md#list_imports_data) | **GET** /containers/{container_id}/import/imports/{import_id}/data | ListImportsData
*ImportsApi* | [**retrieve_import_data**](docs/ImportsApi.md#retrieve_import_data) | **GET** /containers/{container_id}/import/imports/{import_id}/data/{data_id} | RetrieveImportData
*ImportsApi* | [**update_import_data**](docs/ImportsApi.md#update_import_data) | **PUT** /containers/{container_id}/import/imports/{import_id}/data/{data_id} | UpdateImportData
*MetatypeKeysApi* | [**archive_metatype_key**](docs/MetatypeKeysApi.md#archive_metatype_key) | **DELETE** /containers/{container_id}/metatypes/{metatype_id}/keys/{key_id} | ArchiveMetatypeKey
*MetatypeKeysApi* | [**create_metatype_key**](docs/MetatypeKeysApi.md#create_metatype_key) | **POST** /containers/{container_id}/metatypes/{metatype_id}/keys | CreateMetatypeKey
*MetatypeKeysApi* | [**list_metatypes_keys**](docs/MetatypeKeysApi.md#list_metatypes_keys) | **GET** /containers/{container_id}/metatypes/{metatype_id}/keys | ListMetatypesKeys
*MetatypeKeysApi* | [**retrieve_metatype_key**](docs/MetatypeKeysApi.md#retrieve_metatype_key) | **GET** /containers/{container_id}/metatypes/{metatype_id}/keys/{key_id} | RetrieveMetatypeKey
*MetatypeKeysApi* | [**update_metatype_key**](docs/MetatypeKeysApi.md#update_metatype_key) | **PUT** /containers/{container_id}/metatypes/{metatype_id}/keys/{key_id} | UpdateMetatypeKey
*MetatypeRelationshipKeysApi* | [**archive_metatype_relationship_key**](docs/MetatypeRelationshipKeysApi.md#archive_metatype_relationship_key) | **DELETE** /containers/{container_id}/metatype_relationships/{relationship_id}/keys/{key_id} | ArchiveMetatypeRelationshipKey
*MetatypeRelationshipKeysApi* | [**create_metatype_relationship_key**](docs/MetatypeRelationshipKeysApi.md#create_metatype_relationship_key) | **POST** /containers/{container_id}/metatype_relationships/{relationship_id}/keys | CreateMetatypeRelationshipKey
*MetatypeRelationshipKeysApi* | [**list_metatype_relationship_keys**](docs/MetatypeRelationshipKeysApi.md#list_metatype_relationship_keys) | **GET** /containers/{container_id}/metatype_relationships/{relationship_id}/keys | ListMetatypeRelationshipKeys
*MetatypeRelationshipKeysApi* | [**retrieve_metatype_relationship_key**](docs/MetatypeRelationshipKeysApi.md#retrieve_metatype_relationship_key) | **GET** /containers/{container_id}/metatype_relationships/{relationship_id}/keys/{key_id} | RetrieveMetatypeRelationshipKey
*MetatypeRelationshipKeysApi* | [**update_metatype_relationship_key**](docs/MetatypeRelationshipKeysApi.md#update_metatype_relationship_key) | **PUT** /containers/{container_id}/metatype_relationships/{relationship_id}/keys/{key_id} | UpdateMetatypeRelationshipKey
*MetatypeRelationshipPairsApi* | [**archive_metatype_relationship_pair**](docs/MetatypeRelationshipPairsApi.md#archive_metatype_relationship_pair) | **DELETE** /containers/{container_id}/metatype_relationship_pairs/{pair_id} | ArchiveMetatypeRelationshipPair
*MetatypeRelationshipPairsApi* | [**create_metatype_relationship_pair**](docs/MetatypeRelationshipPairsApi.md#create_metatype_relationship_pair) | **POST** /containers/{container_id}/metatype_relationship_pairs | CreateMetatypeRelationshipPair
*MetatypeRelationshipPairsApi* | [**list_metatype_relationship_pairs**](docs/MetatypeRelationshipPairsApi.md#list_metatype_relationship_pairs) | **GET** /containers/{container_id}/metatype_relationship_pairs | ListMetatypeRelationshipPairs
*MetatypeRelationshipPairsApi* | [**retrieve_metatype_relationship_pair**](docs/MetatypeRelationshipPairsApi.md#retrieve_metatype_relationship_pair) | **GET** /containers/{container_id}/metatype_relationship_pairs/{pair_id} | RetrieveMetatypeRelationshipPair
*MetatypeRelationshipPairsApi* | [**update_metatype_relationship_pair**](docs/MetatypeRelationshipPairsApi.md#update_metatype_relationship_pair) | **PUT** /containers/{container_id}/metatype_relationship_pairs/{pair_id} | UpdateMetatypeRelationshipPair
*MetatypeRelationshipsApi* | [**archive_metatype_relationship**](docs/MetatypeRelationshipsApi.md#archive_metatype_relationship) | **DELETE** /containers/{container_id}/metatype_relationships/{relationship_id} | ArchiveMetatypeRelationship
*MetatypeRelationshipsApi* | [**create_metatype_relationship**](docs/MetatypeRelationshipsApi.md#create_metatype_relationship) | **POST** /containers/{container_id}/metatype_relationships | CreateMetatypeRelationship
*MetatypeRelationshipsApi* | [**list_metatype_relationships**](docs/MetatypeRelationshipsApi.md#list_metatype_relationships) | **GET** /containers/{container_id}/metatype_relationships | ListMetatypeRelationships
*MetatypeRelationshipsApi* | [**retrieve_metatype_relationship**](docs/MetatypeRelationshipsApi.md#retrieve_metatype_relationship) | **GET** /containers/{container_id}/metatype_relationships/{relationship_id} | RetrieveMetatypeRelationship
*MetatypeRelationshipsApi* | [**update_metatype_relationship**](docs/MetatypeRelationshipsApi.md#update_metatype_relationship) | **PUT** /containers/{container_id}/metatype_relationships/{relationship_id} | UpdateMetatypeRelationship
*MetatypesApi* | [**archive_metatype**](docs/MetatypesApi.md#archive_metatype) | **DELETE** /containers/{container_id}/metatypes/{metatype_id} | ArchiveMetatype
*MetatypesApi* | [**create_metatype**](docs/MetatypesApi.md#create_metatype) | **POST** /containers/{container_id}/metatypes | CreateMetatype
*MetatypesApi* | [**list_metatypes**](docs/MetatypesApi.md#list_metatypes) | **GET** /containers/{container_id}/metatypes | ListMetatypes
*MetatypesApi* | [**retrieve_metaype**](docs/MetatypesApi.md#retrieve_metaype) | **GET** /containers/{container_id}/metatypes/{metatype_id} | RetrieveMetaype
*MetatypesApi* | [**update_metatype**](docs/MetatypesApi.md#update_metatype) | **PUT** /containers/{container_id}/metatypes/{metatype_id} | UpdateMetatype
*MiscApi* | [**health**](docs/MiscApi.md#health) | **GET** /health | Health
*UsersApi* | [**accept_container_invite**](docs/UsersApi.md#accept_container_invite) | **GET** /users/invite | AcceptContainerInvite
*UsersApi* | [**assign_user_role**](docs/UsersApi.md#assign_user_role) | **POST** /containers/{container_id}/users/roles | AssignUserRole
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /users/{user_id} | DeleteUser
*UsersApi* | [**invite_user_to_container**](docs/UsersApi.md#invite_user_to_container) | **POST** /containers/{container_id}/users/invite | InviteUserToContainer
*UsersApi* | [**list_invited_users_for_container**](docs/UsersApi.md#list_invited_users_for_container) | **GET** /containers/{container_id}/users/invite | ListInvitedUsersForContainer
*UsersApi* | [**list_outstanding_invites**](docs/UsersApi.md#list_outstanding_invites) | **GET** /users/invites | ListOutstandingInvites
*UsersApi* | [**list_user_permissions**](docs/UsersApi.md#list_user_permissions) | **GET** /users/permissions | ListUserPermissions
*UsersApi* | [**list_users**](docs/UsersApi.md#list_users) | **GET** /users | ListUsers
*UsersApi* | [**list_users_for_container**](docs/UsersApi.md#list_users_for_container) | **GET** /containers/{container_id}/users | ListUsersForContainer
*UsersApi* | [**list_users_roles**](docs/UsersApi.md#list_users_roles) | **GET** /containers/{container_id}/users/{user_id}/roles | ListUsersRoles
*UsersApi* | [**retrieve_user**](docs/UsersApi.md#retrieve_user) | **GET** /containers/{container_id}/users/{user_id} | RetrieveUser
*UsersApi* | [**update_user**](docs/UsersApi.md#update_user) | **PUT** /users/{user_id} | UpdateUser

## Documentation For Models

 - [AddDataToImportResponse](docs/AddDataToImportResponse.md)
 - [AssignRoleRequest](docs/AssignRoleRequest.md)
 - [BatchContainerUpdateRequest](docs/BatchContainerUpdateRequest.md)
 - [BatchUpdateContainerResponse](docs/BatchUpdateContainerResponse.md)
 - [Challenge](docs/Challenge.md)
 - [ChallengeMethods](docs/ChallengeMethods.md)
 - [Container](docs/Container.md)
 - [ContainerConfig](docs/ContainerConfig.md)
 - [ContainerImportRequest](docs/ContainerImportRequest.md)
 - [ContainerImportResponse](docs/ContainerImportResponse.md)
 - [ContainerImportUpdateResponse](docs/ContainerImportUpdateResponse.md)
 - [ContainerInvite](docs/ContainerInvite.md)
 - [ContainersDatasourcesImportsRequest](docs/ContainersDatasourcesImportsRequest.md)
 - [ContainersImportBody](docs/ContainersImportBody.md)
 - [ContainersQueryResponse](docs/ContainersQueryResponse.md)
 - [Context](docs/Context.md)
 - [CreateContainerRequest](docs/CreateContainerRequest.md)
 - [CreateContainerResponse](docs/CreateContainerResponse.md)
 - [CreateDataSourceConfig](docs/CreateDataSourceConfig.md)
 - [CreateDataSourceRequest](docs/CreateDataSourceRequest.md)
 - [CreateDataSourcesResponse](docs/CreateDataSourcesResponse.md)
 - [CreateEventResponse](docs/CreateEventResponse.md)
 - [CreateImportResponse](docs/CreateImportResponse.md)
 - [CreateManualImport](docs/CreateManualImport.md)
 - [CreateManualImportResponse](docs/CreateManualImportResponse.md)
 - [CreateMetatypeKeysResponse](docs/CreateMetatypeKeysResponse.md)
 - [CreateMetatypeRelationshipKeysResponse](docs/CreateMetatypeRelationshipKeysResponse.md)
 - [CreateMetatypeRelationshipPairsResponse](docs/CreateMetatypeRelationshipPairsResponse.md)
 - [CreateMetatypeRelationshipsResponse](docs/CreateMetatypeRelationshipsResponse.md)
 - [CreateMetatypesResponse](docs/CreateMetatypesResponse.md)
 - [CreateOrUpdateEdgesRequest](docs/CreateOrUpdateEdgesRequest.md)
 - [CreateOrUpdateNodesRequest](docs/CreateOrUpdateNodesRequest.md)
 - [CreateRegisteredEventRequest](docs/CreateRegisteredEventRequest.md)
 - [CreateTransformationResponse](docs/CreateTransformationResponse.md)
 - [CreateTypeMappingTransformationsRequest](docs/CreateTypeMappingTransformationsRequest.md)
 - [CredentialValidationResult](docs/CredentialValidationResult.md)
 - [DataExportConfig](docs/DataExportConfig.md)
 - [DataSource](docs/DataSource.md)
 - [DataSourceConfig](docs/DataSourceConfig.md)
 - [DataSourceIdFilesBody](docs/DataSourceIdFilesBody.md)
 - [DataSourceImport](docs/DataSourceImport.md)
 - [DataStaging](docs/DataStaging.md)
 - [Edge](docs/Edge.md)
 - [ErrorModel](docs/ErrorModel.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Event](docs/Event.md)
 - [Exporter](docs/Exporter.md)
 - [ExporterConfig](docs/ExporterConfig.md)
 - [FileInfo](docs/FileInfo.md)
 - [FileModel](docs/FileModel.md)
 - [Generic200Response](docs/Generic200Response.md)
 - [GetContainerResponse](docs/GetContainerResponse.md)
 - [GetDataExportResponse](docs/GetDataExportResponse.md)
 - [GetDataSourceResponse](docs/GetDataSourceResponse.md)
 - [GetDataTypeMappingResponse](docs/GetDataTypeMappingResponse.md)
 - [GetEdgeResponse](docs/GetEdgeResponse.md)
 - [GetEventResponse](docs/GetEventResponse.md)
 - [GetFileInfoResponse](docs/GetFileInfoResponse.md)
 - [GetImportDataResponse](docs/GetImportDataResponse.md)
 - [GetMetatypeKeyResponse](docs/GetMetatypeKeyResponse.md)
 - [GetMetatypeRelationshipKeyResponse](docs/GetMetatypeRelationshipKeyResponse.md)
 - [GetMetatypeRelationshipPairResponse](docs/GetMetatypeRelationshipPairResponse.md)
 - [GetMetatypeRelationshipResponse](docs/GetMetatypeRelationshipResponse.md)
 - [GetMetatypeResponse](docs/GetMetatypeResponse.md)
 - [GetNodeResponse](docs/GetNodeResponse.md)
 - [GetUserResponse](docs/GetUserResponse.md)
 - [ImportContainerIdBody](docs/ImportContainerIdBody.md)
 - [ImportIdDataBody](docs/ImportIdDataBody.md)
 - [ImportModel](docs/ImportModel.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [KeyValidation](docs/KeyValidation.md)
 - [ListContainerInvitesResponse](docs/ListContainerInvitesResponse.md)
 - [ListContainerResponse](docs/ListContainerResponse.md)
 - [ListDataExportsResponse](docs/ListDataExportsResponse.md)
 - [ListDataSourceImportsResponse](docs/ListDataSourceImportsResponse.md)
 - [ListDataSourcesResponse](docs/ListDataSourcesResponse.md)
 - [ListDataTypeMappingResponse](docs/ListDataTypeMappingResponse.md)
 - [ListEdgeFiles](docs/ListEdgeFiles.md)
 - [ListEdgesResponse](docs/ListEdgesResponse.md)
 - [ListEventsResponse](docs/ListEventsResponse.md)
 - [ListImportDataResponse](docs/ListImportDataResponse.md)
 - [ListMetatypeKeysResponse](docs/ListMetatypeKeysResponse.md)
 - [ListMetatypeRelationshipKeysResponse](docs/ListMetatypeRelationshipKeysResponse.md)
 - [ListMetatypeRelationshipPairsResponse](docs/ListMetatypeRelationshipPairsResponse.md)
 - [ListMetatypeRelationshipsResponse](docs/ListMetatypeRelationshipsResponse.md)
 - [ListMetatypesResponse](docs/ListMetatypesResponse.md)
 - [ListNodeFiles](docs/ListNodeFiles.md)
 - [ListNodesResponse](docs/ListNodesResponse.md)
 - [ListTransformationResponse](docs/ListTransformationResponse.md)
 - [ListUserInvitesResponse](docs/ListUserInvitesResponse.md)
 - [ListUserPermissionsResponse](docs/ListUserPermissionsResponse.md)
 - [ListUserRoles](docs/ListUserRoles.md)
 - [ListUsersForContainerResponse](docs/ListUsersForContainerResponse.md)
 - [ListUsersResponse](docs/ListUsersResponse.md)
 - [MappingsImportBody](docs/MappingsImportBody.md)
 - [Metatype](docs/Metatype.md)
 - [MetatypeKey](docs/MetatypeKey.md)
 - [MetatypeRelationship](docs/MetatypeRelationship.md)
 - [NewDataExportRequest](docs/NewDataExportRequest.md)
 - [NewMetatypeKeyRequest](docs/NewMetatypeKeyRequest.md)
 - [NewMetatypeRelationshipKeyRequest](docs/NewMetatypeRelationshipKeyRequest.md)
 - [NewMetatypeRelationshipPairRequest](docs/NewMetatypeRelationshipPairRequest.md)
 - [NewMetatypeRelationshipRequest](docs/NewMetatypeRelationshipRequest.md)
 - [NewMetatypeRequest](docs/NewMetatypeRequest.md)
 - [Node](docs/Node.md)
 - [NodeMetatypeBody](docs/NodeMetatypeBody.md)
 - [NotFound404](docs/NotFound404.md)
 - [OneOfinlineResponse200](docs/OneOfinlineResponse200.md)
 - [Prompt](docs/Prompt.md)
 - [RSACancelRequest](docs/RSACancelRequest.md)
 - [RSAInitRequest](docs/RSAInitRequest.md)
 - [RSAResponse](docs/RSAResponse.md)
 - [RSAStatusRequest](docs/RSAStatusRequest.md)
 - [RSAStatusResponse](docs/RSAStatusResponse.md)
 - [RSAVerifyRequest](docs/RSAVerifyRequest.md)
 - [RelationshipKey](docs/RelationshipKey.md)
 - [RelationshipPair](docs/RelationshipPair.md)
 - [RequiredMethod](docs/RequiredMethod.md)
 - [TokenExchangeRequest](docs/TokenExchangeRequest.md)
 - [Transformation](docs/Transformation.md)
 - [TransformationCondition](docs/TransformationCondition.md)
 - [TransformationKey](docs/TransformationKey.md)
 - [TypeMapping](docs/TypeMapping.md)
 - [TypeMappingExportPayload](docs/TypeMappingExportPayload.md)
 - [UpdateContainerRequest](docs/UpdateContainerRequest.md)
 - [UpdateContainerResponse](docs/UpdateContainerResponse.md)
 - [UpdateDataSourceResponse](docs/UpdateDataSourceResponse.md)
 - [UpdateDataTypeMappingResponse](docs/UpdateDataTypeMappingResponse.md)
 - [UpdateImportDataResponse](docs/UpdateImportDataResponse.md)
 - [UpdateMetatypeKeyRequest](docs/UpdateMetatypeKeyRequest.md)
 - [UpdateMetatypeKeyResponse](docs/UpdateMetatypeKeyResponse.md)
 - [UpdateMetatypeRelationshipKeyResponse](docs/UpdateMetatypeRelationshipKeyResponse.md)
 - [UpdateMetatypeRelationshipPairResponse](docs/UpdateMetatypeRelationshipPairResponse.md)
 - [UpdateMetatypeRelationshipRequest](docs/UpdateMetatypeRelationshipRequest.md)
 - [UpdateMetatypeRelationshipResponse](docs/UpdateMetatypeRelationshipResponse.md)
 - [UpdateMetatypeRequest](docs/UpdateMetatypeRequest.md)
 - [UpdateMetatypeResponse](docs/UpdateMetatypeResponse.md)
 - [UpdateRegisteredEventRequest](docs/UpdateRegisteredEventRequest.md)
 - [UpdateTransformationResponse](docs/UpdateTransformationResponse.md)
 - [UploadFileResponse](docs/UploadFileResponse.md)
 - [User](docs/User.md)
 - [UserKey](docs/UserKey.md)
 - [ValidateMetatypePropertiesResponse](docs/ValidateMetatypePropertiesResponse.md)
 - [Validation](docs/Validation.md)
 - [Value](docs/Value.md)
 - [Version](docs/Version.md)

### Other Software
Idaho National Laboratory is a cutting edge research facility which is a constantly producing high quality research and software. Feel free to take a look at our other software and scientific offerings at:

[Primary Technology Offerings Page](https://www.inl.gov/inl-initiatives/technology-deployment)

[Supported Open Source Software](https://github.com/idaholab)

[Raw Experiment Open Source Software](https://github.com/IdahoLabResearch)

[Unsupported Open Source Software](https://github.com/IdahoLabCuttingBoard)

### License

Copyright 2021 Battelle Energy Alliance, LLC

Licensed under the MIT License (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  https://opensource.org/licenses/MIT  

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.



Licensing
-----
This software is licensed under the terms you may find in the file named "LICENSE" in this directory.


Developers
-----
By contributing to this software project, you are agreeing to the following terms and conditions for your contributions:

You agree your contributions are submitted under the MIT license. You represent you are authorized to make the contributions and grant the license. If your employer has rights to intellectual property that includes your contributions, you represent that you have received permission to make contributions and grant the required license on behalf of that employer.

