#!/usr/bin/env python

#
# For test purposes.
# Change this so that it imports your module generated by generateDS.py.
import collect_children_lib as gdslib


def collect_children(instance, allclassnames):
    """Collect values of instance variables that are defined classes.

    Requires that the module is generated with generateDS.py using
    command line option --member-specs=dict.
    However, it could be modified to work with modules generated
    with --member-specs=list.

    Args:
        instance: The instance whose values are to be collected
        allclassnames: The names of all defined classes.  Use either
            module.__all__ or (for faster lookup) set(module.__all__).

    Returns:
        A list of instances of classes defined in this module
        generated by generateDS.py.
    """
    children = []
    if hasattr(instance, 'member_data_items_'):
        for childname, childdef in instance.member_data_items_.items():
            #if childname in allclassnames:
            if childdef.data_type in allclassnames:
                item = getattr(instance, childname)
                #print('adding -- childname: {}  data_type: {}  '
                #      'item: {}'.format(
                #          childname, childdef.data_type, item))
                if item is not None:
                    if childdef.container:
                        children.extend(item)
                    else:
                        children.append(item)
    return children


def walk_tree(node, allclassnames, level=0):
    indent = '    ' * level
    print('{}class: {}'.format(indent, node.__class__.__name__))
    children = collect_children(node, allclassnames)
    level += 1
    for child in children:
        walk_tree(child, allclassnames, level)


def test():
    plant1 = gdslib.plantType(plantname="poppy", plantcolor="25")
    plant2 = gdslib.plantType(plantname="phacelia", plantcolor="35")
    plant3 = gdslib.plantType(plantname="jasmine", plantcolor="45")
    container1 = gdslib.containerType(
        field1=25,
        field1A=[10, 20, 30],
        field3=plant1,
        field3A=[plant2, plant3],
    )
    children = collect_children(container1, gdslib.__all__)
    print('children: {}'.format(children))
    print('-' * 50)
    walk_tree(container1, gdslib.__all__)


def main():
    test()


if __name__ == '__main__':
    main()
