"""
    Lob

    The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors. <p> Looking for our [previous documentation](https://lob.github.io/legacy-docs/)?   # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: lob-openapi@lob.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lob_python.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from lob_python.exceptions import ApiAttributeError

from lob_python.model.campaign_creative import CampaignCreative
from lob_python.model.cmp_id import CmpId
from lob_python.model.cmp_schedule_type import CmpScheduleType
from lob_python.model.cmp_use_type import CmpUseType
from lob_python.model.metadata_model import MetadataModel
from lob_python.model.resource_description import ResourceDescription
globals()['CampaignCreative'] = CampaignCreative
globals()['CmpId'] = CmpId
globals()['CmpScheduleType'] = CmpScheduleType
globals()['CmpUseType'] = CmpUseType
globals()['MetadataModel'] = MetadataModel
globals()['ResourceDescription'] = ResourceDescription


class Campaign(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('object',): {
            'CAMPAIGN': "campaign",
        },
    }

    validations = {
        ('billing_group_id',): {
            'regex': {
                'pattern': r'^bg_[a-zA-Z0-9]+$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'name': (str,),  # noqa: E501
            'schedule_type': (CmpScheduleType,),  # noqa: E501
            'auto_cancel_if_ncoa': (bool,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'is_draft': (bool,),  # noqa: E501
            'creatives': (list,),  # noqa: E501
            'date_created': (datetime,),  # noqa: E501
            'date_modified': (datetime,),  # noqa: E501
            'object': (str,),  # noqa: E501
            'billing_group_id': (str, type(None)),  # noqa: E501
            'description': (str, type(None)),  # noqa: E501
            'target_delivery_date': (datetime, type(None)),  # noqa: E501
            'send_date': (datetime, type(None)),  # noqa: E501
            'cancel_window_campaign_minutes': (int, type(None)),  # noqa: E501
            'metadata': (MetadataModel, type(None)),  # noqa: E501
            'use_type': (CmpUseType, type(None)),  # noqa: E501
            'account_id': (str, type(None)),  # noqa: E501
            'deleted': (bool, type(None)),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'name': 'name',  # noqa: E501
        'schedule_type': 'schedule_type',  # noqa: E501
        'auto_cancel_if_ncoa': 'auto_cancel_if_ncoa',  # noqa: E501
        'id': 'id',  # noqa: E501
        'is_draft': 'is_draft',  # noqa: E501
        'creatives': 'creatives',  # noqa: E501
        'date_created': 'date_created',  # noqa: E501
        'date_modified': 'date_modified',  # noqa: E501
        'object': 'object',  # noqa: E501
        'billing_group_id': 'billing_group_id',  # noqa: E501
        'description': 'description',  # noqa: E501
        'target_delivery_date': 'target_delivery_date',  # noqa: E501
        'send_date': 'send_date',  # noqa: E501
        'cancel_window_campaign_minutes': 'cancel_window_campaign_minutes',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'use_type': 'use_type',  # noqa: E501
        'account_id': 'account_id',  # noqa: E501
        'deleted': 'deleted',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, name, schedule_type, auto_cancel_if_ncoa, id, creatives, date_created, date_modified, *args, **kwargs):  # noqa: E501
        """Campaign - a model defined in OpenAPI

        Args:
            name (str): Name of the campaign.
            schedule_type (CmpScheduleType):
            auto_cancel_if_ncoa (bool): Whether or not a mail piece should be automatically canceled and not sent if the address is updated via NCOA.
            id (str):
            creatives (list): An array of creatives that have been associated with this campaign.
            date_created (datetime): A timestamp in ISO 8601 format of the date the resource was created.
            date_modified (datetime): A timestamp in ISO 8601 format of the date the resource was last modified.

        Keyword Args:
            is_draft (bool): Whether or not the campaign is still a draft.. defaults to True  # noqa: E501
            object (str): Value is resource type.. defaults to "campaign", must be one of ["campaign", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            billing_group_id (str, type(None)): Unique identifier prefixed with `bg_`.. [optional] # noqa: E501
            description (str, type(None)): [optional] # noqa: E501
            target_delivery_date (datetime, type(None)): If `schedule_type` is `target_delivery_date`, provide a targeted delivery date for mail pieces in this campaign.. [optional] # noqa: E501
            send_date (datetime, type(None)): If `schedule_type` is `scheduled_send_date`, provide a date to send this campaign.. [optional] # noqa: E501
            cancel_window_campaign_minutes (int, type(None)): A window, in minutes, within which the campaign can be canceled.. [optional] # noqa: E501
            metadata (MetadataModel, type(None)): [optional] # noqa: E501
            use_type (CmpUseType, type(None)): [optional] # noqa: E501
            account_id (str, type(None)): Account ID that this campaign is associated with.. [optional] # noqa: E501
            deleted (bool, type(None)): Only returned if the resource has been successfully deleted.. [optional] # noqa: E501
        """

        is_draft = kwargs.get('is_draft', True)
        object = kwargs.get('object', "campaign")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        self.schedule_type = schedule_type
        self.auto_cancel_if_ncoa = auto_cancel_if_ncoa
        self.id = id
        self.is_draft = is_draft
        self.creatives = creatives
        self.date_created = date_created
        self.date_modified = date_modified
        self.object = object
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, name, schedule_type, auto_cancel_if_ncoa, id, creatives, date_created, date_modified, *args, **kwargs):  # noqa: E501
        """Campaign - a model defined in OpenAPI

        Args:
            name (str): Name of the campaign.
            schedule_type (CmpScheduleType):
            auto_cancel_if_ncoa (bool): Whether or not a mail piece should be automatically canceled and not sent if the address is updated via NCOA.
            id (CmpId):
            creatives ([CampaignCreative]): An array of creatives that have been associated with this campaign.
            date_created (datetime): A timestamp in ISO 8601 format of the date the resource was created.
            date_modified (datetime): A timestamp in ISO 8601 format of the date the resource was last modified.

        Keyword Args:
            is_draft (bool): Whether or not the campaign is still a draft.. defaults to True  # noqa: E501
            object (str): Value is resource type.. defaults to "campaign", must be one of ["campaign", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            billing_group_id (str, type(None)): Unique identifier prefixed with `bg_`.. [optional] # noqa: E501
            description (str, type(None)): [optional] # noqa: E501
            target_delivery_date (datetime, type(None)): If `schedule_type` is `target_delivery_date`, provide a targeted delivery date for mail pieces in this campaign.. [optional] # noqa: E501
            send_date (datetime, type(None)): If `schedule_type` is `scheduled_send_date`, provide a date to send this campaign.. [optional] # noqa: E501
            cancel_window_campaign_minutes (int, type(None)): A window, in minutes, within which the campaign can be canceled.. [optional] # noqa: E501
            metadata (MetadataModel, type(None)): [optional] # noqa: E501
            use_type (CmpUseType, type(None)): [optional] # noqa: E501
            account_id (str, type(None)): Account ID that this campaign is associated with.. [optional] # noqa: E501
            deleted (bool, type(None)): Only returned if the resource has been successfully deleted.. [optional] # noqa: E501
        """

        is_draft = kwargs.get('is_draft', True)
        object = kwargs.get('object', "campaign")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        self.schedule_type = schedule_type
        self.auto_cancel_if_ncoa = auto_cancel_if_ncoa
        self.id = id
        self.is_draft = is_draft
        self.creatives = creatives
        self.date_created = date_created
        self.date_modified = date_modified
        self.object = object
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
