# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['neattext']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'neattext',
    'version': '0.0.2',
    'description': 'Neattext - a simple NLP package for cleaning text',
    'long_description': '# neattext\nNeatText:a simple NLP package for cleaning textual data and text preprocessing\n\n[![Build Status](https://travis-ci.org/Jcharis/neattext.svg?branch=master)](https://travis-ci.org/Jcharis/neattext)\n\n[![GitHub license](https://img.shields.io/github/license/Jcharis/neattext)](https://github.com/Jcharis/neattext/blob/master/LICENSE)\n\n#### Problem\n+ Cleaning of unstructured text data\n+ Reduce noise [special characters,stopwords]\n+ Reducing repetition of using the same code for text preprocessing\n\n#### Solution\n+ convert the already known solution for cleaning text into a reuseable package\n\n\n#### Installation\n```bash\npip install neattext\n```\n\n### Usage\n+ The OOP Way(Object Oriented Way)\n\n#### Clean Text\n+ Clean text by removing emails,numbers,stopwords,emojis,etc\n```python\n>>> from neattext import TextCleaner\n>>> docx = TextCleaner()\n>>> docx.text = "This is the mail example@gmail.com ,our WEBSITE is https://example.com 😊."\n>>> docx.clean_text()\n```\n\n#### Remove Emails,Numbers,Phone Numbers \n```python\n>>> docx.remove_emails()\n>>> \'This is the mail  ,our WEBSITE is https://example.com 😊.\'\n>>>\n>>> docx.remove_stopwords()\n>>> \'This mail example@gmail.com ,our WEBSITE https://example.com 😊.\'\n>>>\n>>> docx.remove_numbers()\n>>> docx.remove_phone_numbers()\n```\n\n\n#### Remove Special Characters\n```python\n>>> docx.remove_special_characters()\n```\n\n#### Remove Emojis\n```python\n>>> docx.remove_emojis()\n>>> \'This is the mail example@gmail.com ,our WEBSITE is https://example.com .\'\n```\n\n#### Replace Emails,Numbers,Phone Numbers\n```python\n>>> docx.replace_emails()\n>>> docx.replace_numbers()\n>>> docx.replace_phone_numbers()\n```\n\n### Using TextExtractor\n+ To Extract emails,phone numbers,numbers,urls,emojis from text\n```python\n>>> from neattext import TextExtractor\n>>> docx = TextExtractor()\n>>> docx.text = "This is the mail example@gmail.com ,our WEBSITE is https://example.com 😊."\n>>> docx.extract_emails()\n>>> [\'example@gmail.com\']\n>>>\n>>> docx.extract_emojis()\n>>> [\'😊\']\n```\n\n\n### Using TextMetrics\n+ To Find the Words Stats such as counts of vowels,consonants,stopwords,word-stats\n```python\n>>> from neattext import TextMetrics\n>>> docx = TextMetrics()\n>>> docx.text = "This is the mail example@gmail.com ,our WEBSITE is https://example.com 😊."\n>>> docx.count_vowels()\n>>> docx.count_consonants()\n>>> docx.count_stopwords()\n>>> docx.word_stats()\n```\n\n### Usage \n+ The MOP(method/function oriented way) Way\n\n```python\n>>> from neattext.neattext import clean_text,extract_emails\n>>> t1 = "This is the mail example@gmail.com ,our WEBSITE is https://example.com ."\n>>> clean_text(t1,True)\n>>>\'this is the mail <email> ,our website is <url> .\'\n>>> extract_emails(t1)\n>>> [\'example@gmail.com\']\n```\n\n### Documentation\nPlease read the [documentation](https://github.com/Jcharis/neattext/wiki) for more information on what neattext does and how to use is for your needs.\n\n### More Features To Add\n+ unicode explainer\n+ currency normalizer\n\n#### Acknowledgements\n+ Inspired by packages like `clean-text` from Johannes Fillter and `textify` by JCharisTech\n\n\n#### NB\n+ Contributions Are Welcomed\n+ Notice a bug, please let us know.\n+ Thanks A lot\n\n\n#### By\n+ Jesse E.Agbe(JCharis)\n+ Jesus Saves @JCharisTech\n\n\n\n',
    'author': 'Jesse E.Agbe(JCharis)',
    'author_email': 'jcharistech@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Jcharis/neattext',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.3,<4.0',
}


setup(**setup_kwargs)
