#include <cmath>
#include <matplot/matplot.h>

matplot::vector_2d get_u();
matplot::vector_2d get_v();
matplot::vector_2d get_w();

int main() {
    using namespace matplot;
    vector_1d x = iota(-3, 0.5, 3);
    vector_1d y = iota(-3, 0.5, 3);
    auto [X, Y] = meshgrid(x, y);
    vector_2d Z = transform(
        X, Y, [](double x, double y) { return pow(y, 2) - pow(x, 2); });
    auto U = get_u();
    auto V = get_v();
    auto W = get_w();

    quiver3(Z, U, V, W, 5);
    view(-35, 45);

    show();
    return 0;
}

matplot::vector_2d get_u() {
    matplot::vector_2d x = {
        {-0.688247, -0.620174, -0.534522, -0.428571, -0.301511, -0.156174, 0,
         0.156174, 0.301511, 0.428571, 0.534522, 0.620174, 0.688247},
        {-0.744208, -0.680414, -0.596285, -0.486664, -0.348155, -0.182574, 0,
         0.182574, 0.348155, 0.486664, 0.596285, 0.680414, 0.744208},
        {-0.801784, -0.745356, -0.666667, -0.557086, -0.408248, -0.218218, 0,
         0.218218, 0.408248, 0.557086, 0.666667, 0.745356, 0.801784},
        {-0.857143, -0.811107, -0.742781, -0.639602, -0.485071, -0.267261, 0,
         0.267261, 0.485071, 0.639602, 0.742781, 0.811107, 0.857143},
        {-0.904534, -0.870388, -0.816497, -0.727607, -0.57735, -0.333333, 0,
         0.333333, 0.57735, 0.727607, 0.816497, 0.870388, 0.904534},
        {-0.937043, -0.912871, -0.872872, -0.801784, -0.666667, -0.408248, 0,
         0.408248, 0.666667, 0.801784, 0.872872, 0.912871, 0.937043},
        {-0.948683, -0.928477, -0.894427, -0.83205, -0.707107, -0.447214, -0,
         0.447214, 0.707107, 0.83205, 0.894427, 0.928477, 0.948683},
        {-0.937043, -0.912871, -0.872872, -0.801784, -0.666667, -0.408248, -0,
         0.408248, 0.666667, 0.801784, 0.872872, 0.912871, 0.937043},
        {-0.904534, -0.870388, -0.816497, -0.727607, -0.57735, -0.333333, -0,
         0.333333, 0.57735, 0.727607, 0.816497, 0.870388, 0.904534},
        {-0.857143, -0.811107, -0.742781, -0.639602, -0.485071, -0.267261, -0,
         0.267261, 0.485071, 0.639602, 0.742781, 0.811107, 0.857143},
        {-0.801784, -0.745356, -0.666667, -0.557086, -0.408248, -0.218218, -0,
         0.218218, 0.408248, 0.557086, 0.666667, 0.745356, 0.801784},
        {-0.744208, -0.680414, -0.596285, -0.486664, -0.348155, -0.182574, -0,
         0.182574, 0.348155, 0.486664, 0.596285, 0.680414, 0.744208},
        {-0.688247, -0.620174, -0.534522, -0.428571, -0.301511, -0.156174, -0,
         0.156174, 0.301511, 0.428571, 0.534522, 0.620174, 0.688247}};
    return x;
}

matplot::vector_2d get_v() {
    matplot::vector_2d x = {
        {0.688247, 0.744208, 0.801784, 0.857143, 0.904534, 0.937043, 0.948683,
         0.937043, 0.904534, 0.857143, 0.801784, 0.744208, 0.688247},
        {0.620174, 0.680414, 0.745356, 0.811107, 0.870388, 0.912871, 0.928477,
         0.912871, 0.870388, 0.811107, 0.745356, 0.680414, 0.620174},
        {0.534522, 0.596285, 0.666667, 0.742781, 0.816497, 0.872872, 0.894427,
         0.872872, 0.816497, 0.742781, 0.666667, 0.596285, 0.534522},
        {0.428571, 0.486664, 0.557086, 0.639602, 0.727607, 0.801784, 0.83205,
         0.801784, 0.727607, 0.639602, 0.557086, 0.486664, 0.428571},
        {0.301511, 0.348155, 0.408248, 0.485071, 0.57735, 0.666667, 0.707107,
         0.666667, 0.57735, 0.485071, 0.408248, 0.348155, 0.301511},
        {0.156174, 0.182574, 0.218218, 0.267261, 0.333333, 0.408248, 0.447214,
         0.408248, 0.333333, 0.267261, 0.218218, 0.182574, 0.156174},
        {-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0},
        {-0.156174, -0.182574, -0.218218, -0.267261, -0.333333, -0.408248,
         -0.447214, -0.408248, -0.333333, -0.267261, -0.218218, -0.182574,
         -0.156174},
        {-0.301511, -0.348155, -0.408248, -0.485071, -0.57735, -0.666667,
         -0.707107, -0.666667, -0.57735, -0.485071, -0.408248, -0.348155,
         -0.301511},
        {-0.428571, -0.486664, -0.557086, -0.639602, -0.727607, -0.801784,
         -0.83205, -0.801784, -0.727607, -0.639602, -0.557086, -0.486664,
         -0.428571},
        {-0.534522, -0.596285, -0.666667, -0.742781, -0.816497, -0.872872,
         -0.894427, -0.872872, -0.816497, -0.742781, -0.666667, -0.596285,
         -0.534522},
        {-0.620174, -0.680414, -0.745356, -0.811107, -0.870388, -0.912871,
         -0.928477, -0.912871, -0.870388, -0.811107, -0.745356, -0.680414,
         -0.620174},
        {-0.688247, -0.744208, -0.801784, -0.857143, -0.904534, -0.937043,
         -0.948683, -0.937043, -0.904534, -0.857143, -0.801784, -0.744208,
         -0.688247}};
    return x;
}

matplot::vector_2d get_w() {
    matplot::vector_2d x = {
        {0.229416, 0.248069, 0.267261, 0.285714, 0.301511, 0.312348, 0.316228,
         0.312348, 0.301511, 0.285714, 0.267261, 0.248069, 0.229416},
        {0.248069, 0.272166, 0.298142, 0.324443, 0.348155, 0.365148, 0.371391,
         0.365148, 0.348155, 0.324443, 0.298142, 0.272166, 0.248069},
        {0.267261, 0.298142, 0.333333, 0.371391, 0.408248, 0.436436, 0.447214,
         0.436436, 0.408248, 0.371391, 0.333333, 0.298142, 0.267261},
        {0.285714, 0.324443, 0.371391, 0.426401, 0.485071, 0.534522, 0.5547,
         0.534522, 0.485071, 0.426401, 0.371391, 0.324443, 0.285714},
        {0.301511, 0.348155, 0.408248, 0.485071, 0.57735, 0.666667, 0.707107,
         0.666667, 0.57735, 0.485071, 0.408248, 0.348155, 0.301511},
        {0.312348, 0.365148, 0.436436, 0.534522, 0.666667, 0.816497, 0.894427,
         0.816497, 0.666667, 0.534522, 0.436436, 0.365148, 0.312348},
        {0.316228, 0.371391, 0.447214, 0.5547, 0.707107, 0.894427, 1, 0.894427,
         0.707107, 0.5547, 0.447214, 0.371391, 0.316228},
        {0.312348, 0.365148, 0.436436, 0.534522, 0.666667, 0.816497, 0.894427,
         0.816497, 0.666667, 0.534522, 0.436436, 0.365148, 0.312348},
        {0.301511, 0.348155, 0.408248, 0.485071, 0.57735, 0.666667, 0.707107,
         0.666667, 0.57735, 0.485071, 0.408248, 0.348155, 0.301511},
        {0.285714, 0.324443, 0.371391, 0.426401, 0.485071, 0.534522, 0.5547,
         0.534522, 0.485071, 0.426401, 0.371391, 0.324443, 0.285714},
        {0.267261, 0.298142, 0.333333, 0.371391, 0.408248, 0.436436, 0.447214,
         0.436436, 0.408248, 0.371391, 0.333333, 0.298142, 0.267261},
        {0.248069, 0.272166, 0.298142, 0.324443, 0.348155, 0.365148, 0.371391,
         0.365148, 0.348155, 0.324443, 0.298142, 0.272166, 0.248069},
        {0.229416, 0.248069, 0.267261, 0.285714, 0.301511, 0.312348, 0.316228,
         0.312348, 0.301511, 0.285714, 0.267261, 0.248069, 0.229416}};
    return x;
}
