/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.util.logging.Redwood;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CountWrapper {
    private static Redwood.RedwoodChannels log = Redwood.channels(CountWrapper.class);
    private String word;
    private int countPart;
    private int countThat;
    private int countIn;
    private int countRB;

    public CountWrapper() {
    }

    protected CountWrapper(String word, int countPart, int countThat, int countIn, int countRB) {
        assert (word != null);
        this.word = word;
        this.countPart = countPart;
        this.countThat = countThat;
        this.countIn = countIn;
        this.countRB = countRB;
    }

    protected void incThat() {
        ++this.countThat;
    }

    public int getCountPart() {
        return this.countPart;
    }

    public int getCountThat() {
        return this.countThat;
    }

    public int getCountIn() {
        return this.countIn;
    }

    public int getCountRB() {
        return this.countRB;
    }

    public String getWord() {
        return this.word;
    }

    public int hashCode() {
        return this.word.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CountWrapper)) {
            return false;
        }
        CountWrapper cw = (CountWrapper)obj;
        return this.word.equals(cw.word);
    }

    protected void save(DataOutputStream rf) {
        try {
            rf.writeInt(this.word.length());
            rf.write(this.word.getBytes());
            rf.writeInt(this.countPart);
            rf.writeInt(this.countThat);
            rf.writeInt(this.countIn);
            rf.writeInt(this.countRB);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void read(DataInputStream rf) {
        try {
            int len = rf.readInt();
            byte[] buff = new byte[len];
            if (rf.read(buff) != len) {
                log.info("Error: rewrite CountWrapper.read");
            }
            this.word = new String(buff);
            assert (this.word != null);
            this.countPart = rf.readInt();
            this.countThat = rf.readInt();
            this.countIn = rf.readInt();
            this.countRB = rf.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

