/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.objectbank.IdentityFunction;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.util.AbstractIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class LineIterator<X>
extends AbstractIterator<X> {
    private final Function<String, X> op;
    private final BufferedReader in;
    private X nextToken;

    public LineIterator(Reader r) {
        this(r, new IdentityFunction());
    }

    public LineIterator(Reader r, Function<String, X> op) {
        this.op = op;
        this.in = new BufferedReader(r);
        this.setNext();
    }

    private void setNext() {
        String line = null;
        try {
            line = this.in.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.nextToken = line != null ? this.op.apply(line) : null;
    }

    @Override
    public boolean hasNext() {
        return this.nextToken != null;
    }

    @Override
    public X next() {
        if (this.nextToken == null) {
            throw new NoSuchElementException("LineIterator reader exhausted");
        }
        X token = this.nextToken;
        this.setNext();
        return token;
    }

    public Object peek() {
        return this.nextToken;
    }

    public static <X> IteratorFromReaderFactory<X> getFactory() {
        return new LineIteratorFactory();
    }

    public static <X> IteratorFromReaderFactory<X> getFactory(Function<String, X> op) {
        return new LineIteratorFactory<X>(op);
    }

    public static class LineIteratorFactory<X>
    implements IteratorFromReaderFactory<X>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Function<String, X> function;

        public LineIteratorFactory() {
            this(new IdentityFunction());
        }

        public LineIteratorFactory(Function<String, X> op) {
            this.function = op;
        }

        @Override
        public Iterator<X> getIterator(Reader r) {
            return new LineIterator<X>(r, this.function);
        }
    }
}

