/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.PriorModelFactory;
import edu.stanford.nlp.ie.crf.CRFClassifierEvaluator;
import edu.stanford.nlp.ie.crf.CRFClassifierFloat;
import edu.stanford.nlp.ie.crf.CRFClassifierNoisyLabel;
import edu.stanford.nlp.ie.crf.CRFClassifierNonlinear;
import edu.stanford.nlp.ie.crf.CRFClassifierWithDropout;
import edu.stanford.nlp.ie.crf.CRFClassifierWithLOP;
import edu.stanford.nlp.ie.crf.CRFCliqueTree;
import edu.stanford.nlp.ie.crf.CRFDatum;
import edu.stanford.nlp.ie.crf.CRFFeatureExporter;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFunction;
import edu.stanford.nlp.ie.crf.CliquePotentialFunction;
import edu.stanford.nlp.ie.crf.FactorTable;
import edu.stanford.nlp.ie.crf.HasCliquePotentialFunction;
import edu.stanford.nlp.ie.crf.LabelDictionary;
import edu.stanford.nlp.ie.crf.LinearCliquePotentialFunction;
import edu.stanford.nlp.ie.crf.TestSequenceModel;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.optimization.HasEvaluators;
import edu.stanford.nlp.optimization.HybridMinimizer;
import edu.stanford.nlp.optimization.InefficientSGDMinimizer;
import edu.stanford.nlp.optimization.MemoryEvaluator;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.optimization.QNMinimizer;
import edu.stanford.nlp.optimization.ResultStoringMonitor;
import edu.stanford.nlp.optimization.SGDMinimizer;
import edu.stanford.nlp.optimization.SGDToQNMinimizer;
import edu.stanford.nlp.optimization.SGDWithAdaGradAndFOBOS;
import edu.stanford.nlp.optimization.SMDMinimizer;
import edu.stanford.nlp.optimization.ScaledSGDMinimizer;
import edu.stanford.nlp.optimization.StochasticDiffFunctionTester;
import edu.stanford.nlp.sequences.BeamBestSequenceFinder;
import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.CoolingSchedule;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.ExactBestSequenceFinder;
import edu.stanford.nlp.sequences.FactoredSequenceListener;
import edu.stanford.nlp.sequences.FactoredSequenceModel;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.ListeningSequenceModel;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.sequences.SequenceGibbsSampler;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.ConvertByteArray;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.MaxSizeConcurrentHashSet;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;

public class CRFClassifier<IN extends CoreMap>
extends AbstractSequenceClassifier<IN> {
    private static final Redwood.RedwoodChannels log = Redwood.channels(CRFClassifier.class);
    List<Index<CRFLabel>> labelIndices;
    Index<String> tagIndex;
    private Pair<double[][], double[][]> entityMatrices;
    CliquePotentialFunction cliquePotentialFunction;
    HasCliquePotentialFunction cliquePotentialFunctionHelper;
    double[][] weights;
    Index<String> featureIndex;
    int[] map;
    Random random = new Random(Integer.MAX_VALUE);
    Index<Integer> nodeFeatureIndicesMap;
    Index<Integer> edgeFeatureIndicesMap;
    private Map<String, double[]> embeddings;
    public static final String DEFAULT_CLASSIFIER = "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz";
    private static final boolean VERBOSE = false;
    private Pattern suffixPatt = Pattern.compile(".+?((?:-[A-Z]+)+)\\|.*C");
    private Index<String> templateGroupIndex;
    private Map<Integer, Integer> featureIndexToTemplateIndex;
    private LabelDictionary labelDictionary;

    protected CRFClassifier() {
        super(new SeqClassifierFlags());
    }

    public CRFClassifier(Properties props) {
        super(props);
    }

    public CRFClassifier(SeqClassifierFlags flags) {
        super(flags);
    }

    public CRFClassifier(CRFClassifier<IN> crf) {
        super(crf.flags);
        this.windowSize = crf.windowSize;
        this.featureFactories = crf.featureFactories;
        this.pad = crf.pad;
        if (crf.knownLCWords == null) {
            this.knownLCWords = new MaxSizeConcurrentHashSet(crf.flags.maxAdditionalKnownLCWords);
        } else {
            this.knownLCWords = new MaxSizeConcurrentHashSet(crf.knownLCWords);
            this.knownLCWords.setMaxSize(this.knownLCWords.size() + crf.flags.maxAdditionalKnownLCWords);
        }
        this.featureIndex = crf.featureIndex != null ? new HashIndex<String>(crf.featureIndex.objectsList()) : null;
        Index index = this.classIndex = crf.classIndex != null ? new HashIndex(crf.classIndex.objectsList()) : null;
        if (crf.labelIndices != null) {
            this.labelIndices = new ArrayList<Index<CRFLabel>>(crf.labelIndices.size());
            for (int i = 0; i < crf.labelIndices.size(); ++i) {
                this.labelIndices.add((Index<CRFLabel>)(crf.labelIndices.get(i) != null ? new HashIndex<CRFLabel>(crf.labelIndices.get(i).objectsList()) : null));
            }
        } else {
            this.labelIndices = null;
        }
        this.cliquePotentialFunction = crf.cliquePotentialFunction;
    }

    public int getNumWeights() {
        if (this.weights == null) {
            return 0;
        }
        int numWeights = 0;
        for (double[] wts : this.weights) {
            numWeights += wts.length;
        }
        return numWeights;
    }

    private int getFeatureTypeIndex(int i) {
        return CRFClassifier.getFeatureTypeIndex(this.featureIndex.get(i));
    }

    private static int getFeatureTypeIndex(String feature) {
        if (feature.endsWith("|C")) {
            return 0;
        }
        if (feature.endsWith("|CpC")) {
            return 1;
        }
        if (feature.endsWith("|Cp2C")) {
            return 2;
        }
        if (feature.endsWith("|Cp3C")) {
            return 3;
        }
        if (feature.endsWith("|Cp4C")) {
            return 4;
        }
        if (feature.endsWith("|Cp5C")) {
            return 5;
        }
        throw new RuntimeException("Unknown feature type " + feature);
    }

    public void scaleWeights(double scale) {
        for (int i = 0; i < this.weights.length; ++i) {
            int j = 0;
            while (j < this.weights[i].length) {
                double[] dArray = this.weights[i];
                int n = j++;
                dArray[n] = dArray[n] * scale;
            }
        }
    }

    private void combineWeights(CRFClassifier<IN> crf, double weight) {
        int i;
        int i2;
        int numFeatures = this.featureIndex.size();
        int oldNumFeatures = this.weights.length;
        Map<CRFLabel, CRFLabel> crfLabelMap = Generics.newHashMap();
        for (i2 = 0; i2 < crf.labelIndices.size(); ++i2) {
            for (int j = 0; j < crf.labelIndices.get(i2).size(); ++j) {
                CRFLabel labels = crf.labelIndices.get(i2).get(j);
                int[] newLabelIndices = new int[i2 + 1];
                for (int ci = 0; ci <= i2; ++ci) {
                    String classLabel = (String)crf.classIndex.get(labels.getLabel()[ci]);
                    newLabelIndices[ci] = this.classIndex.indexOf(classLabel);
                }
                CRFLabel newLabels = new CRFLabel(newLabelIndices);
                crfLabelMap.put(labels, newLabels);
                int classLabel = this.labelIndices.get(i2).indexOf(newLabels);
            }
        }
        this.map = new int[numFeatures];
        for (i2 = 0; i2 < numFeatures; ++i2) {
            this.map[i2] = this.getFeatureTypeIndex(i2);
        }
        double[][] newWeights = new double[numFeatures][];
        for (i = 0; i < numFeatures; ++i) {
            int length = this.labelIndices.get(this.map[i]).size();
            newWeights[i] = new double[length];
            if (i >= oldNumFeatures) continue;
            assert (length >= this.weights[i].length);
            System.arraycopy(this.weights[i], 0, newWeights[i], 0, this.weights[i].length);
        }
        this.weights = newWeights;
        for (i = 0; i < crf.weights.length; ++i) {
            String feature = crf.featureIndex.get(i);
            int newIndex = this.featureIndex.indexOf(feature);
            if (this.weights[newIndex].length < crf.weights[i].length) {
                throw new RuntimeException("Incompatible CRFClassifier: weight length mismatch for feature " + newIndex + ": " + this.featureIndex.get(newIndex) + " (also feature " + i + ": " + crf.featureIndex.get(i) + ") " + ", len1=" + this.weights[newIndex].length + ", len2=" + crf.weights[i].length);
            }
            int featureTypeIndex = this.map[newIndex];
            for (int j = 0; j < crf.weights[i].length; ++j) {
                CRFLabel labels = crf.labelIndices.get(featureTypeIndex).get(j);
                CRFLabel newLabels = (CRFLabel)crfLabelMap.get(labels);
                int k = this.labelIndices.get(featureTypeIndex).indexOf(newLabels);
                double[] dArray = this.weights[newIndex];
                int n = k;
                dArray[n] = dArray[n] + crf.weights[i][j] * weight;
            }
        }
    }

    public void combine(CRFClassifier<IN> crf, double weight) {
        Timing timer = new Timing();
        if (!this.pad.equals(crf.pad)) {
            throw new RuntimeException("Incompatible CRFClassifier: pad does not match");
        }
        if (this.windowSize != crf.windowSize) {
            throw new RuntimeException("Incompatible CRFClassifier: windowSize does not match");
        }
        if (this.labelIndices.size() != crf.labelIndices.size()) {
            throw new RuntimeException("Incompatible CRFClassifier: labelIndices length does not match");
        }
        this.classIndex.addAll(crf.classIndex.objectsList());
        int oldNumFeatures1 = this.featureIndex.size();
        int oldNumFeatures2 = crf.featureIndex.size();
        int oldNumWeights1 = this.getNumWeights();
        int oldNumWeights2 = crf.getNumWeights();
        this.featureIndex.addAll(crf.featureIndex.objectsList());
        this.knownLCWords.addAll(crf.knownLCWords);
        assert (this.weights.length == oldNumFeatures1);
        for (int i = 0; i < this.labelIndices.size(); ++i) {
            this.labelIndices.get(i).addAll(crf.labelIndices.get(i).objectsList());
        }
        log.info("Combining weights: will automatically match labelIndices");
        this.combineWeights(crf, weight);
        int numFeatures = this.featureIndex.size();
        int numWeights = this.getNumWeights();
        long elapsedMs = timer.stop();
        log.info("numFeatures: orig1=" + oldNumFeatures1 + ", orig2=" + oldNumFeatures2 + ", combined=" + numFeatures);
        log.info("numWeights: orig1=" + oldNumWeights1 + ", orig2=" + oldNumWeights2 + ", combined=" + numWeights);
        log.info("Time to combine CRFClassifier: " + Timing.toSecondsString(elapsedMs) + " seconds");
    }

    public void dropFeaturesBelowThreshold(double threshold) {
        HashIndex<String> newFeatureIndex = new HashIndex<String>();
        block0: for (int i = 0; i < this.weights.length; ++i) {
            double smallest = this.weights[i][0];
            double biggest = this.weights[i][0];
            for (int j = 1; j < this.weights[i].length; ++j) {
                if (this.weights[i][j] > biggest) {
                    biggest = this.weights[i][j];
                }
                if (this.weights[i][j] < smallest) {
                    smallest = this.weights[i][j];
                }
                if (!(biggest - smallest > threshold)) continue;
                newFeatureIndex.add(this.featureIndex.get(i));
                continue block0;
            }
        }
        int[] newMap = new int[newFeatureIndex.size()];
        for (int i = 0; i < newMap.length; ++i) {
            int index = this.featureIndex.indexOf((String)newFeatureIndex.get(i));
            newMap[i] = this.map[index];
        }
        this.map = newMap;
        this.featureIndex = newFeatureIndex;
    }

    public Triple<int[][][], int[], double[][][]> documentToDataAndLabels(List<IN> document) {
        int docSize = document.size();
        int[][][] data = new int[docSize][this.windowSize][];
        double[][][] featureVals = new double[docSize][this.windowSize][];
        int[] labels = new int[docSize];
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        for (int j = 0; j < docSize; ++j) {
            CRFDatum<List<String>, CRFLabel> d = this.makeDatum(document, j, this.featureFactories);
            List<List<String>> features = d.asFeatures();
            List<double[]> featureValList = d.asFeatureVals();
            int fSize = features.size();
            for (int k = 0; k < fSize; ++k) {
                Collection cliqueFeatures = features.get(k);
                data[j][k] = new int[cliqueFeatures.size()];
                if (featureValList != null) {
                    featureVals[j][k] = featureValList.get(k);
                }
                int m = 0;
                for (String feature : cliqueFeatures) {
                    int index = this.featureIndex.indexOf(feature);
                    if (index < 0) continue;
                    data[j][k][m] = index;
                    ++m;
                }
                if (m >= data[j][k].length) continue;
                int[] f = new int[m];
                System.arraycopy(data[j][k], 0, f, 0, m);
                data[j][k] = f;
                if (featureVals[j][k] == null) continue;
                double[] fVal = new double[m];
                System.arraycopy(featureVals[j][k], 0, fVal, 0, m);
                featureVals[j][k] = fVal;
            }
            CoreMap wi = (CoreMap)document.get(j);
            labels[j] = this.classIndex.indexOf(wi.get(CoreAnnotations.AnswerAnnotation.class));
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        return new Triple<int[][][], int[], double[][][]>(data, labels, featureVals);
    }

    private int[][][] transformDocData(int[][][] docData) {
        int[][][] transData = new int[docData.length][][];
        for (int i = 0; i < docData.length; ++i) {
            transData[i] = new int[docData[i].length][];
            for (int j = 0; j < docData[i].length; ++j) {
                int[] cliqueFeatures = docData[i][j];
                transData[i][j] = new int[cliqueFeatures.length];
                for (int n = 0; n < cliqueFeatures.length; ++n) {
                    int transFeatureIndex;
                    if (j == 0) {
                        transFeatureIndex = this.nodeFeatureIndicesMap.indexOf(cliqueFeatures[n]);
                        if (transFeatureIndex == -1) {
                            throw new RuntimeException("node cliqueFeatures[n]=" + cliqueFeatures[n] + " not found, nodeFeatureIndicesMap.size=" + this.nodeFeatureIndicesMap.size());
                        }
                    } else {
                        transFeatureIndex = this.edgeFeatureIndicesMap.indexOf(cliqueFeatures[n]);
                        if (transFeatureIndex == -1) {
                            throw new RuntimeException("edge cliqueFeatures[n]=" + cliqueFeatures[n] + " not found, edgeFeatureIndicesMap.size=" + this.edgeFeatureIndicesMap.size());
                        }
                    }
                    transData[i][j][n] = transFeatureIndex;
                }
            }
        }
        return transData;
    }

    public void printLabelInformation(String testFile, DocumentReaderAndWriter<IN> readerAndWriter) throws Exception {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(testFile, readerAndWriter);
        for (List<IN> document : documents) {
            this.printLabelValue(document);
        }
    }

    public void printLabelValue(List<IN> document) {
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        DecimalFormat nf = new DecimalFormat();
        ArrayList classes = new ArrayList();
        for (int i = 0; i < this.classIndex.size(); ++i) {
            classes.add(this.classIndex.get(i));
        }
        Object[] columnHeaders = classes.toArray(new String[classes.size()]);
        for (int j = 0; j < document.size(); ++j) {
            System.out.println("--== " + (String)((CoreMap)document.get(j)).get(CoreAnnotations.TextAnnotation.class) + " ==--");
            ArrayList<String[]> lines = new ArrayList<String[]>();
            ArrayList<String> rowHeaders = new ArrayList<String>();
            ArrayList<String> line = new ArrayList<String>();
            for (int p = 0; p < this.labelIndices.size(); ++p) {
                if (j + p >= document.size()) continue;
                CRFDatum<List<String>, CRFLabel> d = this.makeDatum(document, j + p, this.featureFactories);
                List<List<String>> features = d.asFeatures();
                int fSize = features.size();
                for (int k = p; k < fSize; ++k) {
                    Collection cliqueFeatures = features.get(k);
                    for (String feature : cliqueFeatures) {
                        int index = this.featureIndex.indexOf(feature);
                        if (index < 0) continue;
                        rowHeaders.add(feature + '[' + -p + ']');
                        double[] values = new double[this.labelIndices.get(0).size()];
                        for (CRFLabel label : this.labelIndices.get(k)) {
                            int[] l = label.getLabel();
                            double v = this.weights[index][this.labelIndices.get(k).indexOf(label)];
                            int n = l[l.length - 1 - p];
                            values[n] = values[n] + v;
                        }
                        for (Object value : (Object)values) {
                            line.add(nf.format((double)value));
                        }
                        lines.add(line.toArray(new String[line.size()]));
                        line = new ArrayList();
                    }
                }
                System.out.println(StringUtils.makeTextTable((Object[][])lines.toArray((T[])new String[lines.size()][0]), rowHeaders.toArray(new String[rowHeaders.size()]), columnHeaders, 0, 1, true));
                System.out.println();
            }
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
    }

    public Triple<int[][][][], int[][], double[][][][]> documentsToDataAndLabels(Collection<List<IN>> documents) {
        ArrayList<int[][][]> data = new ArrayList<int[][][]>();
        ArrayList<double[][][]> featureVal = new ArrayList<double[][][]>();
        ArrayList<int[]> labels = new ArrayList<int[]>();
        int numDatums = 0;
        for (List<IN> doc : documents) {
            Triple<int[][][], int[], double[][][]> docTriple = this.documentToDataAndLabels(doc);
            data.add(docTriple.first());
            labels.add(docTriple.second());
            if (this.flags.useEmbedding) {
                featureVal.add(docTriple.third());
            }
            numDatums += doc.size();
        }
        log.info("numClasses: " + this.classIndex.size() + ' ' + this.classIndex);
        log.info("numDocuments: " + data.size());
        log.info("numDatums: " + numDatums);
        log.info("numFeatures: " + this.featureIndex.size());
        this.printFeatures();
        double[][][][] featureValArr = null;
        if (this.flags.useEmbedding) {
            featureValArr = (double[][][][])featureVal.toArray((T[])new double[data.size()][][][]);
        }
        return new Triple<T[], T[], double[][][][]>(data.toArray((T[])new int[data.size()][][][]), labels.toArray((T[])new int[labels.size()][]), featureValArr);
    }

    public List<Triple<int[][][], int[], double[][][]>> documentsToDataAndLabelsList(Collection<List<IN>> documents) {
        int numDatums = 0;
        ArrayList<Triple<int[][][], int[], double[][][]>> docList = new ArrayList<Triple<int[][][], int[], double[][][]>>();
        for (List<IN> doc : documents) {
            Triple<int[][][], int[], double[][][]> docTriple = this.documentToDataAndLabels(doc);
            docList.add(docTriple);
            numDatums += doc.size();
        }
        log.info("numClasses: " + this.classIndex.size() + ' ' + this.classIndex);
        log.info("numDocuments: " + docList.size());
        log.info("numDatums: " + numDatums);
        log.info("numFeatures: " + this.featureIndex.size());
        return docList;
    }

    protected void printFeatures() {
        if (this.flags.printFeatures == null) {
            return;
        }
        try {
            String enc = this.flags.inputEncoding;
            if (this.flags.inputEncoding == null) {
                log.info("flags.inputEncoding doesn't exist, using UTF-8 as default");
                enc = "UTF-8";
            }
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream("features-" + this.flags.printFeatures + ".txt"), enc), true);
            for (String feat : this.featureIndex) {
                pw.println(feat);
            }
            pw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void makeAnswerArraysAndTagIndex(Collection<List<IN>> ob) {
        int i;
        int i2;
        boolean useFeatureCountThresh = this.flags.featureCountThresh > 1;
        HashSet[] featureIndices = new HashSet[this.windowSize];
        HashMap[] featureCountIndices = null;
        for (i2 = 0; i2 < this.windowSize; ++i2) {
            featureIndices[i2] = Generics.newHashSet();
        }
        if (useFeatureCountThresh) {
            featureCountIndices = new HashMap[this.windowSize];
            for (i2 = 0; i2 < this.windowSize; ++i2) {
                featureCountIndices[i2] = Generics.newHashMap();
            }
        }
        this.labelIndices = new ArrayList<Index<CRFLabel>>(this.windowSize);
        for (i2 = 0; i2 < this.windowSize; ++i2) {
            this.labelIndices.add(new HashIndex());
        }
        Index<CRFLabel> labelIndex = this.labelIndices.get(this.windowSize - 1);
        if (this.classIndex == null) {
            this.classIndex = new HashIndex();
        }
        this.classIndex.add(this.flags.backgroundSymbol);
        HashSet[] seenBackgroundFeatures = new HashSet[]{Generics.newHashSet(), Generics.newHashSet()};
        int wordCount = 0;
        if (this.flags.labelDictionaryCutoff > 0) {
            this.labelDictionary = new LabelDictionary();
        }
        for (List<IN> doc : ob) {
            if (this.flags.useReverse) {
                Collections.reverse(doc);
            }
            for (CoreMap token : doc) {
                ++wordCount;
                String ans = (String)token.get(CoreAnnotations.AnswerAnnotation.class);
                if (ans == null || ans.isEmpty()) {
                    throw new IllegalArgumentException("Word " + wordCount + " (\"" + (String)token.get(CoreAnnotations.TextAnnotation.class) + "\") has a blank answer");
                }
                this.classIndex.add(ans);
                if (this.labelDictionary == null) continue;
                String observation = (String)token.get(CoreAnnotations.TextAnnotation.class);
                this.labelDictionary.increment(observation, ans);
            }
            int docSize = doc.size();
            for (int j = 0; j < docSize; ++j) {
                CRFDatum<List<String>, CRFLabel> d = this.makeDatum(doc, j, this.featureFactories);
                labelIndex.add(d.label());
                List<List<String>> features = d.asFeatures();
                int fSize = features.size();
                for (int k = 0; k < fSize; ++k) {
                    Collection cliqueFeatures = features.get(k);
                    if (k < 2 && this.flags.removeBackgroundSingletonFeatures) {
                        String ans = (String)((CoreMap)doc.get(j)).get(CoreAnnotations.AnswerAnnotation.class);
                        boolean background = ans.equals(this.flags.backgroundSymbol);
                        if (k == 1 && j > 0 && background) {
                            ans = (String)((CoreMap)doc.get(j - 1)).get(CoreAnnotations.AnswerAnnotation.class);
                            background = ans.equals(this.flags.backgroundSymbol);
                        }
                        if (background) {
                            for (String f : cliqueFeatures) {
                                if (useFeatureCountThresh) {
                                    if (featureCountIndices[k].containsKey(f)) continue;
                                    if (seenBackgroundFeatures[k].contains(f)) {
                                        seenBackgroundFeatures[k].remove(f);
                                        featureCountIndices[k].put(f, 1);
                                        continue;
                                    }
                                    seenBackgroundFeatures[k].add(f);
                                    continue;
                                }
                                if (featureIndices[k].contains(f)) continue;
                                if (seenBackgroundFeatures[k].contains(f)) {
                                    seenBackgroundFeatures[k].remove(f);
                                    featureIndices[k].add(f);
                                    continue;
                                }
                                seenBackgroundFeatures[k].add(f);
                            }
                            continue;
                        }
                        seenBackgroundFeatures[k].removeAll(cliqueFeatures);
                        if (useFeatureCountThresh) {
                            HashMap fCountIndex = featureCountIndices[k];
                            for (String f : cliqueFeatures) {
                                if (fCountIndex.containsKey(f)) {
                                    fCountIndex.put(f, (Integer)fCountIndex.get(f) + 1);
                                    continue;
                                }
                                fCountIndex.put(f, 1);
                            }
                            continue;
                        }
                        featureIndices[k].addAll(cliqueFeatures);
                        continue;
                    }
                    if (useFeatureCountThresh) {
                        HashMap fCountIndex = featureCountIndices[k];
                        for (String f : cliqueFeatures) {
                            if (fCountIndex.containsKey(f)) {
                                fCountIndex.put(f, (Integer)fCountIndex.get(f) + 1);
                                continue;
                            }
                            fCountIndex.put(f, 1);
                        }
                        continue;
                    }
                    featureIndices[k].addAll(cliqueFeatures);
                }
            }
            if (!this.flags.useReverse) continue;
            Collections.reverse(doc);
        }
        if (useFeatureCountThresh) {
            int i3;
            int numFeatures = 0;
            for (i3 = 0; i3 < this.windowSize; ++i3) {
                numFeatures += featureCountIndices[i3].size();
            }
            log.info("Before feature count thresholding, numFeatures = " + numFeatures);
            for (i3 = 0; i3 < this.windowSize; ++i3) {
                Iterator it = featureCountIndices[i3].entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if ((Integer)entry.getValue() >= this.flags.featureCountThresh) continue;
                    it.remove();
                }
                featureIndices[i3].addAll(featureCountIndices[i3].keySet());
                featureCountIndices[i3] = null;
            }
        }
        int numFeatures = 0;
        for (i = 0; i < this.windowSize; ++i) {
            numFeatures += featureIndices[i].size();
        }
        log.info("numFeatures = " + numFeatures);
        this.featureIndex = new HashIndex<String>();
        this.map = new int[numFeatures];
        if (this.flags.groupByFeatureTemplate) {
            this.templateGroupIndex = new HashIndex<String>();
            this.featureIndexToTemplateIndex = new HashMap<Integer, Integer>();
        }
        for (i = 0; i < this.windowSize; ++i) {
            HashIndex<Integer> featureIndexMap = new HashIndex<Integer>();
            this.featureIndex.addAll(featureIndices[i]);
            for (String str : featureIndices[i]) {
                int index = this.featureIndex.indexOf(str);
                this.map[index] = i;
                featureIndexMap.add(index);
                if (!this.flags.groupByFeatureTemplate) continue;
                Matcher m = this.suffixPatt.matcher(str);
                String groupSuffix = "NoTemplate";
                if (m.matches()) {
                    groupSuffix = m.group(1);
                }
                groupSuffix = groupSuffix + "-c:" + i;
                int groupIndex = this.templateGroupIndex.addToIndex(groupSuffix);
                this.featureIndexToTemplateIndex.put(index, groupIndex);
            }
            if (i == 0) {
                this.nodeFeatureIndicesMap = featureIndexMap;
                continue;
            }
            this.edgeFeatureIndicesMap = featureIndexMap;
        }
        if (this.flags.numOfFeatureSlices > 0) {
            log.info("Taking " + this.flags.numOfFeatureSlices + " out of " + this.flags.totalFeatureSlice + " slices of node features for training");
            this.pruneNodeFeatureIndices(this.flags.totalFeatureSlice, this.flags.numOfFeatureSlices);
        }
        if (this.flags.useObservedSequencesOnly) {
            int liSize = labelIndex.size();
            for (i = 0; i < liSize; ++i) {
                CRFLabel label = labelIndex.get(i);
                for (int j = this.windowSize - 2; j >= 0; --j) {
                    label = label.getOneSmallerLabel();
                    this.labelIndices.get(j).add(label);
                }
            }
        } else {
            for (i = 0; i < this.labelIndices.size(); ++i) {
                this.labelIndices.set(i, CRFClassifier.allLabels(i + 1, this.classIndex));
            }
        }
        if (this.labelDictionary != null) {
            this.labelDictionary.lock(this.flags.labelDictionaryCutoff, this.classIndex);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static Index<CRFLabel> allLabels(int window, Index<String> classIndex) {
        label = new int[window];
        numClasses = classIndex.size();
        labelIndex = new HashIndex<CRFLabel>();
        block0: while (true) {
            l = new CRFLabel(label);
            labelIndex.add(l);
            label1 = new int[window];
            System.arraycopy(label, 0, label1, 0, label.length);
            label = label1;
            j = 0;
            while (true) {
                if (j >= label.length) continue block0;
                v0 = j;
                label[v0] = label[v0] + 1;
                if (label[j] >= numClasses) ** break;
                continue block0;
                label[j] = 0;
                if (j == label.length - 1) break block0;
                ++j;
            }
            break;
        }
        return labelIndex;
    }

    public CRFDatum<List<String>, CRFLabel> makeDatum(List<IN> info, int loc, List<FeatureFactory<IN>> featureFactories) {
        PaddedList<CoreMap> pInfo = new PaddedList<CoreMap>(info, this.pad);
        ArrayList<List<String>> features = new ArrayList<List<String>>();
        ArrayList<double[]> featureVals = new ArrayList<double[]>();
        Set<Clique> done = Generics.newHashSet();
        for (int i = 0; i < this.windowSize; ++i) {
            ArrayList<String> featuresC = new ArrayList<String>();
            List<Clique> windowCliques = FeatureFactory.getCliques(i, 0);
            windowCliques.removeAll(done);
            done.addAll(windowCliques);
            double[] featureValArr = null;
            if (this.flags.useEmbedding && i == 0) {
                featureValArr = this.makeDatumUsingEmbedding(info, loc, featureFactories, pInfo, featuresC, windowCliques);
            } else {
                for (Clique c : windowCliques) {
                    for (FeatureFactory<CoreMap> featureFactory : featureFactories) {
                        featuresC.addAll(featureFactory.getCliqueFeatures(pInfo, loc, c));
                    }
                }
            }
            features.add(featuresC);
            featureVals.add(featureValArr);
        }
        int[] labels = new int[this.windowSize];
        for (int i = 0; i < this.windowSize; ++i) {
            String answer = (String)pInfo.get(loc + i - this.windowSize + 1).get(CoreAnnotations.AnswerAnnotation.class);
            labels[i] = this.classIndex.indexOf(answer);
        }
        this.printFeatureLists(pInfo.get(loc), features);
        CRFDatum<List<String>, CRFLabel> d = new CRFDatum<List<String>, CRFLabel>(features, new CRFLabel(labels), featureVals);
        return d;
    }

    private double[] makeDatumUsingEmbedding(List<IN> info, int loc, List<FeatureFactory<IN>> featureFactories, PaddedList<IN> pInfo, List<String> featuresC, List<Clique> windowCliques) {
        double[] featureValArr;
        ArrayList<double[]> embeddingList = new ArrayList<double[]>();
        int concatEmbeddingLen = 0;
        String currentWord = null;
        for (int currLoc = loc - 2; currLoc <= loc + 2; ++currLoc) {
            double[] embedding;
            if (currLoc >= 0 && currLoc < info.size()) {
                currentWord = (String)((CoreMap)info.get(loc)).get(CoreAnnotations.TextAnnotation.class);
                String word = currentWord.toLowerCase();
                embedding = this.embeddings.containsKey(word = word.replaceAll("(-)?\\d+(\\.\\d*)?", "0")) ? this.embeddings.get(word) : this.embeddings.get("UNKNOWN");
            } else {
                embedding = this.embeddings.get("PADDING");
            }
            for (int e = 0; e < embedding.length; ++e) {
                featuresC.add("EMBEDDING-(" + (currLoc - loc) + ")-" + e);
            }
            if (this.flags.addCapitalFeatures) {
                int numOfCapitalFeatures = 4;
                double[] newEmbedding = new double[embedding.length + numOfCapitalFeatures];
                int currLen = embedding.length;
                System.arraycopy(embedding, 0, newEmbedding, 0, currLen);
                for (int e = 0; e < numOfCapitalFeatures; ++e) {
                    featuresC.add("CAPITAL-(" + (currLoc - loc) + ")-" + e);
                }
                if (currLoc >= 0 && currLoc < info.size()) {
                    if (currentWord.toUpperCase().equals(currentWord)) {
                        newEmbedding[currLen] = 1.0;
                    } else {
                        ++currLen;
                        if (currentWord.toLowerCase().equals(currentWord)) {
                            newEmbedding[currLen] = 1.0;
                        } else {
                            ++currLen;
                            if (Character.isUpperCase(currentWord.charAt(0))) {
                                newEmbedding[currLen] = 1.0;
                            } else {
                                ++currLen;
                                String remainder = currentWord.substring(1);
                                if (!remainder.toLowerCase().equals(remainder)) {
                                    newEmbedding[currLen] = 1.0;
                                }
                            }
                        }
                    }
                }
                embedding = newEmbedding;
            }
            embeddingList.add(embedding);
            concatEmbeddingLen += embedding.length;
        }
        double[] concatEmbedding = new double[concatEmbeddingLen];
        int currPos = 0;
        for (double[] em : embeddingList) {
            System.arraycopy(em, 0, concatEmbedding, currPos, em.length);
            currPos += em.length;
        }
        if (this.flags.prependEmbedding) {
            int additionalFeatureCount = 0;
            for (Clique c : windowCliques) {
                for (FeatureFactory<IN> featureFactory : featureFactories) {
                    Collection<String> fCol = featureFactory.getCliqueFeatures(pInfo, loc, c);
                    featuresC.addAll(fCol);
                    additionalFeatureCount += fCol.size();
                }
            }
            featureValArr = new double[concatEmbedding.length + additionalFeatureCount];
            System.arraycopy(concatEmbedding, 0, featureValArr, 0, concatEmbedding.length);
            Arrays.fill(featureValArr, concatEmbedding.length, featureValArr.length, 1.0);
        } else {
            featureValArr = concatEmbedding;
        }
        if (this.flags.addBiasToEmbedding) {
            featuresC.add("BIAS-FEATURE");
            double[] newFeatureValArr = new double[featureValArr.length + 1];
            System.arraycopy(featureValArr, 0, newFeatureValArr, 0, featureValArr.length);
            newFeatureValArr[newFeatureValArr.length - 1] = 1.0;
            featureValArr = newFeatureValArr;
        }
        return featureValArr;
    }

    @Override
    public void dumpFeatures(Collection<List<IN>> docs) {
        if (this.flags.exportFeatures != null) {
            Timing timer = new Timing();
            CRFFeatureExporter<IN> featureExporter = new CRFFeatureExporter<IN>(this);
            featureExporter.printFeatures(this.flags.exportFeatures, docs);
            long elapsedMs = timer.stop();
            log.info("Time to export features: " + Timing.toSecondsString(elapsedMs) + " seconds");
        }
    }

    @Override
    public List<IN> classify(List<IN> document) {
        if (this.flags.doGibbs) {
            try {
                return this.classifyGibbs(document);
            }
            catch (Exception e) {
                throw new RuntimeException("Error running testGibbs inference!", e);
            }
        }
        if (this.flags.crfType.equalsIgnoreCase("maxent")) {
            return this.classifyMaxEnt(document);
        }
        throw new RuntimeException("Unsupported inference type: " + this.flags.crfType);
    }

    private List<IN> classify(List<IN> document, Triple<int[][][], int[], double[][][]> documentDataAndLabels) {
        if (this.flags.doGibbs) {
            try {
                return this.classifyGibbs(document, documentDataAndLabels);
            }
            catch (Exception e) {
                throw new RuntimeException("Error running testGibbs inference!", e);
            }
        }
        if (this.flags.crfType.equalsIgnoreCase("maxent")) {
            return this.classifyMaxEnt(document, documentDataAndLabels);
        }
        throw new RuntimeException("Unsupported inference type: " + this.flags.crfType);
    }

    void classifyAndWriteAnswers(Collection<List<IN>> documents, List<Triple<int[][][], int[], double[][][]>> documentDataAndLabels, PrintWriter printWriter, DocumentReaderAndWriter<IN> readerAndWriter) throws IOException {
        Timing timer = new Timing();
        ClassicCounter<String> entityTP = new ClassicCounter<String>();
        ClassicCounter<String> entityFP = new ClassicCounter<String>();
        ClassicCounter<String> entityFN = new ClassicCounter<String>();
        boolean resultsCounted = true;
        int numWords = 0;
        int numDocs = 0;
        for (List<IN> doc : documents) {
            this.classify(doc, documentDataAndLabels.get(numDocs));
            numWords += doc.size();
            this.writeAnswers(doc, printWriter, readerAndWriter);
            resultsCounted = resultsCounted && this.countResults(doc, entityTP, entityFP, entityFN);
            ++numDocs;
        }
        long millis = timer.stop();
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        if (!this.flags.suppressTestDebug) {
            log.info(StringUtils.getShortClassName(this) + " tagged " + numWords + " words in " + numDocs + " documents at " + nf.format(wordspersec) + " words per second.");
        }
        if (resultsCounted && !this.flags.suppressTestDebug) {
            CRFClassifier.printResults(entityTP, entityFP, entityFN);
        }
    }

    @Override
    public SequenceModel getSequenceModel(List<IN> doc) {
        Triple<int[][][], int[], double[][][]> p = this.documentToDataAndLabels(doc);
        return this.getSequenceModel(p, doc);
    }

    private SequenceModel getSequenceModel(Triple<int[][][], int[], double[][][]> documentDataAndLabels, List<IN> document) {
        return this.labelDictionary == null ? new TestSequenceModel(this.getCliqueTree(documentDataAndLabels)) : new TestSequenceModel(this.getCliqueTree(documentDataAndLabels), this.labelDictionary, document);
    }

    protected CliquePotentialFunction getCliquePotentialFunctionForTest() {
        if (this.cliquePotentialFunction == null) {
            this.cliquePotentialFunction = new LinearCliquePotentialFunction(this.weights);
        }
        return this.cliquePotentialFunction;
    }

    public void updateWeightsForTest(double[] x) {
        this.cliquePotentialFunction = this.cliquePotentialFunctionHelper.getCliquePotentialFunction(x);
    }

    public List<IN> classifyMaxEnt(List<IN> document) {
        if (document.isEmpty()) {
            return document;
        }
        SequenceModel model = this.getSequenceModel(document);
        return this.classifyMaxEnt(document, model);
    }

    private List<IN> classifyMaxEnt(List<IN> document, Triple<int[][][], int[], double[][][]> documentDataAndLabels) {
        if (document.isEmpty()) {
            return document;
        }
        SequenceModel model = this.getSequenceModel(documentDataAndLabels, document);
        return this.classifyMaxEnt(document, model);
    }

    private List<IN> classifyMaxEnt(List<IN> document, SequenceModel model) {
        BestSequenceFinder tagInference;
        if (document.isEmpty()) {
            return document;
        }
        if (this.flags.inferenceType == null) {
            this.flags.inferenceType = "Viterbi";
        }
        if (this.flags.inferenceType.equalsIgnoreCase("Viterbi")) {
            tagInference = new ExactBestSequenceFinder();
        } else if (this.flags.inferenceType.equalsIgnoreCase("Beam")) {
            tagInference = new BeamBestSequenceFinder(this.flags.beamSize);
        } else {
            throw new RuntimeException("Unknown inference type: " + this.flags.inferenceType + ". Your options are Viterbi|Beam.");
        }
        int[] bestSequence = tagInference.bestSequence(model);
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        int docSize = document.size();
        for (int j = 0; j < docSize; ++j) {
            CoreMap wi = (CoreMap)document.get(j);
            String guess = (String)this.classIndex.get(bestSequence[j + this.windowSize - 1]);
            wi.set(CoreAnnotations.AnswerAnnotation.class, guess);
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        return document;
    }

    public List<IN> classifyGibbs(List<IN> document) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Triple<int[][][], int[], double[][][]> p = this.documentToDataAndLabels(document);
        return this.classifyGibbs(document, p);
    }

    public List<IN> classifyGibbs(List<IN> document, Triple<int[][][], int[], double[][][]> documentDataAndLabels) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        List<IN> newDocument = document;
        if (this.flags.useReverse) {
            Collections.reverse(document);
            newDocument = new ArrayList<IN>(document);
            Collections.reverse(document);
        }
        CRFCliqueTree<String> cliqueTree = this.getCliqueTree(documentDataAndLabels);
        PriorModelFactory pmf = (PriorModelFactory)Class.forName(this.flags.priorModelFactory).newInstance();
        ListeningSequenceModel prior = pmf.getInstance(this.flags.backgroundSymbol, this.classIndex, this.tagIndex, newDocument, this.entityMatrices, this.flags);
        if (!this.flags.useUniformPrior) {
            throw new RuntimeException("no prior specified");
        }
        FactoredSequenceModel model = new FactoredSequenceModel(cliqueTree, prior);
        FactoredSequenceListener listener = new FactoredSequenceListener(cliqueTree, prior);
        SequenceGibbsSampler sampler = new SequenceGibbsSampler(0, 0, listener);
        int[] sequence = new int[cliqueTree.length()];
        if (this.flags.initViterbi) {
            TestSequenceModel testSequenceModel = new TestSequenceModel(cliqueTree);
            ExactBestSequenceFinder tagInference = new ExactBestSequenceFinder();
            int[] bestSequence = tagInference.bestSequence(testSequenceModel);
            System.arraycopy(bestSequence, this.windowSize - 1, sequence, 0, sequence.length);
        } else {
            int[] initialSequence = SequenceGibbsSampler.getRandomSequence(model);
            System.arraycopy(initialSequence, 0, sequence, 0, sequence.length);
        }
        SequenceGibbsSampler.verbose = 0;
        if (this.flags.annealingType.equalsIgnoreCase("linear")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getLinearSchedule(1.0, this.flags.numSamples), sequence);
        } else if (this.flags.annealingType.equalsIgnoreCase("exp") || this.flags.annealingType.equalsIgnoreCase("exponential")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getExponentialSchedule(1.0, this.flags.annealingRate, this.flags.numSamples), sequence);
        } else {
            throw new RuntimeException("No annealing type specified");
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        int dsize = newDocument.size();
        for (int j = 0; j < dsize; ++j) {
            CoreMap wi = (CoreMap)document.get(j);
            if (wi == null) {
                throw new RuntimeException("");
            }
            if (this.classIndex == null) {
                throw new RuntimeException("");
            }
            wi.set(CoreAnnotations.AnswerAnnotation.class, this.classIndex.get(sequence[j]));
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        return document;
    }

    @Override
    public Triple<Counter<Integer>, Counter<Integer>, TwoDimensionalCounter<Integer, String>> printProbsDocument(List<IN> document) {
        int numBins = 10;
        boolean verbose = this.flags.verboseMode;
        Triple<int[][][], int[], double[][][]> p = this.documentToDataAndLabels(document);
        CRFCliqueTree<String> cliqueTree = this.getCliqueTree(p);
        ClassicCounter<Integer> calibration = new ClassicCounter<Integer>();
        ClassicCounter<Integer> correctByBin = new ClassicCounter<Integer>();
        TwoDimensionalCounter<Integer, String> calibratedTokens = new TwoDimensionalCounter<Integer, String>();
        for (int i = 0; i < cliqueTree.length(); ++i) {
            CoreMap wi = (CoreMap)document.get(i);
            String token = (String)wi.get(CoreAnnotations.TextAnnotation.class);
            String goldAnswer = (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class);
            System.out.print(token);
            System.out.print('\t');
            System.out.print(goldAnswer);
            double maxProb = Double.NEGATIVE_INFINITY;
            String bestClass = "";
            for (String label : this.classIndex) {
                int index = this.classIndex.indexOf(label);
                double prob = cliqueTree.prob(i, index);
                if (prob > maxProb) {
                    bestClass = label;
                }
                System.out.print('\t');
                System.out.print(label);
                System.out.print('=');
                System.out.print(prob);
                if (!verbose) continue;
                int binnedProb = (int)(prob * 10.0);
                if (binnedProb > 9) {
                    binnedProb = 9;
                }
                calibration.incrementCount(binnedProb);
                if (!label.equals(goldAnswer)) continue;
                if (bestClass.equals(goldAnswer)) {
                    correctByBin.incrementCount(binnedProb);
                }
                if (label.equals(this.flags.backgroundSymbol)) continue;
                calibratedTokens.incrementCount(binnedProb, token);
            }
            System.out.println();
        }
        if (verbose) {
            return new Triple<Counter<Integer>, Counter<Integer>, TwoDimensionalCounter<Integer, String>>(calibration, correctByBin, calibratedTokens);
        }
        return null;
    }

    public void printFirstOrderProbs(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        ObjectBank<List<IN>> docs = this.makeObjectBankFromFile(filename, readerAndWriter);
        this.printFirstOrderProbsDocuments(docs);
    }

    public void printFirstOrderProbsDocuments(ObjectBank<List<IN>> documents) {
        for (List<IN> doc : documents) {
            this.printFirstOrderProbsDocument(doc);
            System.out.println();
        }
    }

    public void printFactorTable(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        ObjectBank<List<IN>> docs = this.makeObjectBankFromFile(filename, readerAndWriter);
        this.printFactorTableDocuments(docs);
    }

    public void printFactorTableDocuments(ObjectBank<List<IN>> documents) {
        for (List<IN> doc : documents) {
            this.printFactorTableDocument(doc);
            System.out.println();
        }
    }

    public List<CRFCliqueTree<String>> getCliqueTrees(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        ArrayList<CRFCliqueTree<String>> cts = new ArrayList<CRFCliqueTree<String>>();
        ObjectBank<List<IN>> docs = this.makeObjectBankFromFile(filename, readerAndWriter);
        for (List<IN> doc : docs) {
            cts.add(this.getCliqueTree(doc));
        }
        return cts;
    }

    public CRFCliqueTree<String> getCliqueTree(Triple<int[][][], int[], double[][][]> p) {
        int[][][] data = p.first();
        double[][][] featureVal = p.third();
        return CRFCliqueTree.getCalibratedCliqueTree(data, this.labelIndices, this.classIndex.size(), this.classIndex, this.flags.backgroundSymbol, this.getCliquePotentialFunctionForTest(), featureVal);
    }

    public CRFCliqueTree<String> getCliqueTree(List<IN> document) {
        Triple<int[][][], int[], double[][][]> p = this.documentToDataAndLabels(document);
        return this.getCliqueTree(p);
    }

    public void printFactorTableDocument(List<IN> document) {
        CRFCliqueTree<String> cliqueTree = this.getCliqueTree(document);
        FactorTable[] factorTables = cliqueTree.getFactorTables();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < factorTables.length; ++i) {
            CoreMap wi = (CoreMap)document.get(i);
            sb.append((String)wi.get(CoreAnnotations.TextAnnotation.class));
            sb.append('\t');
            FactorTable table = factorTables[i];
            for (int j = 0; j < table.size(); ++j) {
                int[] arr = table.toArray(j);
                sb.append((String)this.classIndex.get(arr[0]));
                sb.append(':');
                sb.append((String)this.classIndex.get(arr[1]));
                sb.append(':');
                sb.append(cliqueTree.logProb(i, arr));
                sb.append(' ');
            }
            sb.append('\n');
        }
        System.out.print(sb);
    }

    public void printFirstOrderProbsDocument(List<IN> document) {
        CRFCliqueTree<String> cliqueTree = this.getCliqueTree(document);
        for (int i = 0; i < cliqueTree.length(); ++i) {
            CoreMap wi = (CoreMap)document.get(i);
            System.out.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + '\t');
            Iterator iter = this.classIndex.iterator();
            while (iter.hasNext()) {
                String label = (String)iter.next();
                int index = this.classIndex.indexOf(label);
                if (i == 0) {
                    double prob = cliqueTree.prob(i, index);
                    System.out.print(label + '=' + prob);
                    if (iter.hasNext()) {
                        System.out.print("\t");
                        continue;
                    }
                    System.out.print("\n");
                    continue;
                }
                Iterator iter1 = this.classIndex.iterator();
                while (iter1.hasNext()) {
                    String label1 = (String)iter1.next();
                    int index1 = this.classIndex.indexOf(label1);
                    double prob = cliqueTree.prob(i, new int[]{index1, index});
                    System.out.print(label1 + '_' + label + '=' + prob);
                    if (iter.hasNext() || iter1.hasNext()) {
                        System.out.print("\t");
                        continue;
                    }
                    System.out.print("\n");
                }
            }
        }
    }

    protected Collection<List<IN>> loadAuxiliaryData(Collection<List<IN>> docs, DocumentReaderAndWriter<IN> readerAndWriter) {
        return docs;
    }

    @Override
    public void train(Collection<List<IN>> objectBankWrapper, DocumentReaderAndWriter<IN> readerAndWriter) {
        Timing timer = new Timing();
        List<List<Object>> docs = new ArrayList<List<IN>>();
        for (List<IN> list : objectBankWrapper) {
            docs.add(list);
        }
        if (this.flags.numOfSlices > 0) {
            log.info("Taking " + this.flags.numOfSlices + " out of " + this.flags.totalDataSlice + " slices of data for training");
            ArrayList<List> docsToShuffle = new ArrayList<List>();
            for (List list : docs) {
                docsToShuffle.add(list);
            }
            Collections.shuffle(docsToShuffle, this.random);
            int n = (int)((double)docsToShuffle.size() / ((double)this.flags.totalDataSlice + 0.0) * (double)this.flags.numOfSlices);
            docs = docsToShuffle.subList(0, n);
        }
        Collection<List<IN>> totalDocs = this.loadAuxiliaryData(docs, readerAndWriter);
        this.makeAnswerArraysAndTagIndex(totalDocs);
        long l = timer.stop();
        log.info("Time to convert docs to feature indices: " + Timing.toSecondsString(l) + " seconds");
        if (this.flags.serializeClassIndexTo != null) {
            timer.start();
            this.serializeClassIndex(this.flags.serializeClassIndexTo);
            l = timer.stop();
            log.info("Time to export class index : " + Timing.toSecondsString(l) + " seconds");
        }
        if (this.flags.exportFeatures != null) {
            this.dumpFeatures(docs);
        }
        for (int i = 0; i <= this.flags.numTimesPruneFeatures; ++i) {
            double[] oneDimWeights;
            List<List<CRFDatum<Collection<String>, String>>> processedData;
            timer.start();
            Triple<int[][][][], int[][], double[][][][]> dataAndLabelsAndFeatureVals = this.documentsToDataAndLabels(docs);
            l = timer.stop();
            log.info("Time to convert docs to data/labels: " + Timing.toSecondsString(l) + " seconds");
            Evaluator[] evaluators = null;
            if (this.flags.evaluateIters > 0 || this.flags.terminateOnEvalImprovement) {
                Object labels;
                CRFClassifierEvaluator<IN> crfEvaluator;
                ArrayList<Evaluator> evaluatorList = new ArrayList<Evaluator>();
                if (this.flags.useMemoryEvaluator) {
                    evaluatorList.add(new MemoryEvaluator());
                }
                if (this.flags.evaluateTrain) {
                    crfEvaluator = new CRFClassifierEvaluator<IN>("Train set", this);
                    ArrayList<Triple<int[][][], int[], double[][][]>> trainDataAndLabels = new ArrayList<Triple<int[][][], int[], double[][][]>>();
                    int[][][][] data = dataAndLabelsAndFeatureVals.first();
                    labels = dataAndLabelsAndFeatureVals.second();
                    double[][][][] featureVal = dataAndLabelsAndFeatureVals.third();
                    for (int j = 0; j < data.length; ++j) {
                        Triple<int[][][], int[], double[][][]> p = new Triple<int[][][], int[], double[][][]>(data[j], labels[j], featureVal[j]);
                        trainDataAndLabels.add(p);
                    }
                    crfEvaluator.setTestData(docs, trainDataAndLabels);
                    if (this.flags.evalCmd.length() > 0) {
                        crfEvaluator.setEvalCmd(this.flags.evalCmd);
                    }
                    evaluatorList.add(crfEvaluator);
                }
                if (this.flags.testFile != null) {
                    crfEvaluator = new CRFClassifierEvaluator("Test set (" + this.flags.testFile + ")", this);
                    ObjectBank<List<IN>> testObjBank = this.makeObjectBankFromFile(this.flags.testFile, readerAndWriter);
                    ArrayList<List<IN>> testDocs = new ArrayList<List<IN>>();
                    labels = testObjBank.iterator();
                    while (labels.hasNext()) {
                        List doc = (List)labels.next();
                        testDocs.add(doc);
                    }
                    List<Triple<int[][][], int[], double[][][]>> testDataAndLabels = this.documentsToDataAndLabelsList(testDocs);
                    crfEvaluator.setTestData(testDocs, testDataAndLabels);
                    if (this.flags.evalCmd.length() > 0) {
                        crfEvaluator.setEvalCmd(this.flags.evalCmd);
                    }
                    evaluatorList.add(crfEvaluator);
                }
                if (this.flags.testFiles != null) {
                    String[] testFiles = this.flags.testFiles.split(",");
                    for (String testFile : testFiles) {
                        CRFClassifierEvaluator<IN> crfEvaluator2 = new CRFClassifierEvaluator<IN>("Test set (" + testFile + ')', this);
                        ObjectBank<List<IN>> testObjBank = this.makeObjectBankFromFile(testFile, readerAndWriter);
                        List<Triple<int[][][], int[], double[][][]>> testDataAndLabels = this.documentsToDataAndLabelsList(testObjBank);
                        crfEvaluator2.setTestData(testObjBank, testDataAndLabels);
                        if (this.flags.evalCmd.length() > 0) {
                            crfEvaluator2.setEvalCmd(this.flags.evalCmd);
                        }
                        evaluatorList.add(crfEvaluator2);
                    }
                }
                evaluators = new Evaluator[evaluatorList.size()];
                evaluatorList.toArray(evaluators);
            }
            if (this.flags.numTimesPruneFeatures == i) {
                docs = null;
            }
            File featIndexFile = null;
            if (this.flags.saveFeatureIndexToDisk) {
                try {
                    log.info("Writing feature index to temporary file.");
                    featIndexFile = IOUtils.writeObjectToTempFile(this.featureIndex, "featIndex" + i + ".tmp");
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not open temporary feature index file for writing.");
                }
            }
            Object data = dataAndLabelsAndFeatureVals.first();
            Object labels = dataAndLabelsAndFeatureVals.second();
            Object featureVals = dataAndLabelsAndFeatureVals.third();
            if (this.flags.loadProcessedData != null && (processedData = CRFClassifier.loadProcessedData(this.flags.loadProcessedData)) != null) {
                int[][][][] allData = new int[((int[][][][])data).length + processedData.size()][][][];
                double[][][][] allFeatureVals = new double[((double[][][][])featureVals).length + processedData.size()][][][];
                int[][] allLabels = new int[((int[][])labels).length + processedData.size()][];
                System.arraycopy(data, 0, allData, 0, ((int[][][][])data).length);
                System.arraycopy(labels, 0, allLabels, 0, ((int[][])labels).length);
                System.arraycopy(featureVals, 0, allFeatureVals, 0, ((double[][][][])featureVals).length);
                this.addProcessedData(processedData, allData, allLabels, allFeatureVals, ((int[][][][])data).length);
                data = allData;
                labels = allLabels;
                featureVals = allFeatureVals;
            }
            if ((oneDimWeights = this.trainWeights((int[][][][])data, (int[][])labels, evaluators, i, (double[][][][])featureVals)) != null) {
                this.weights = CRFClassifier.to2D(oneDimWeights, this.labelIndices, this.map);
            }
            if (this.flags.saveFeatureIndexToDisk) {
                try {
                    log.info("Reading temporary feature index file.");
                    this.featureIndex = (Index)IOUtils.readObjectFromFile(featIndexFile);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not open temporary feature index file for reading.");
                }
            }
            if (i == this.flags.numTimesPruneFeatures) continue;
            this.dropFeaturesBelowThreshold(this.flags.featureDiffThresh);
            log.info("Removing features with weight below " + this.flags.featureDiffThresh + " and retraining...");
        }
    }

    public static double[][] to2D(double[] weights, List<Index<CRFLabel>> labelIndices, int[] map) {
        double[][] newWeights = new double[map.length][];
        int index = 0;
        for (int i = 0; i < map.length; ++i) {
            newWeights[i] = new double[labelIndices.get(map[i]).size()];
            System.arraycopy(weights, index, newWeights[i], 0, labelIndices.get(map[i]).size());
            index += labelIndices.get(map[i]).size();
        }
        return newWeights;
    }

    protected void pruneNodeFeatureIndices(int totalNumOfFeatureSlices, int numOfFeatureSlices) {
        int index;
        String f;
        int numOfNodeFeatures = this.nodeFeatureIndicesMap.size();
        int beginIndex = 0;
        int endIndex = Math.min((int)((double)numOfNodeFeatures / ((double)totalNumOfFeatureSlices + 0.0) * (double)numOfFeatureSlices), numOfNodeFeatures);
        List<Integer> nodeFeatureOriginalIndices = this.nodeFeatureIndicesMap.objectsList();
        List<Integer> edgeFeatureOriginalIndices = this.edgeFeatureIndicesMap.objectsList();
        HashIndex<Integer> newNodeFeatureIndex = new HashIndex<Integer>();
        HashIndex<Integer> newEdgeFeatureIndex = new HashIndex<Integer>();
        HashIndex<String> newFeatureIndex = new HashIndex<String>();
        for (int i = beginIndex; i < endIndex; ++i) {
            int oldIndex = nodeFeatureOriginalIndices.get(i);
            f = this.featureIndex.get(oldIndex);
            index = newFeatureIndex.addToIndex(f);
            newNodeFeatureIndex.add(index);
        }
        for (Integer edgeFIndex : edgeFeatureOriginalIndices) {
            f = this.featureIndex.get(edgeFIndex);
            index = newFeatureIndex.addToIndex(f);
            newEdgeFeatureIndex.add(index);
        }
        this.nodeFeatureIndicesMap = newNodeFeatureIndex;
        this.edgeFeatureIndicesMap = newEdgeFeatureIndex;
        int[] newMap = new int[newFeatureIndex.size()];
        for (int i = 0; i < newMap.length; ++i) {
            int index2 = this.featureIndex.indexOf((String)newFeatureIndex.get(i));
            newMap[i] = this.map[index2];
        }
        this.map = newMap;
        this.featureIndex = newFeatureIndex;
    }

    protected CRFLogConditionalObjectiveFunction getObjectiveFunction(int[][][][] data, int[][] labels) {
        return new CRFLogConditionalObjectiveFunction(data, labels, this.windowSize, this.classIndex, this.labelIndices, this.map, this.flags.priorType, this.flags.backgroundSymbol, this.flags.sigma, null, this.flags.multiThreadGrad);
    }

    protected double[] trainWeights(int[][][][] data, int[][] labels, Evaluator[] evaluators, int pruneFeatureItr, double[][][][] featureVals) {
        double[] initialWeights;
        int cliqueOutClass;
        int numCliqueTypeOutputClass;
        int cliqueType;
        int pIndex;
        CRFLogConditionalObjectiveFunction func = this.getObjectiveFunction(data, labels);
        this.cliquePotentialFunctionHelper = func;
        HashMap featureSets = null;
        if (this.flags.groupByOutputClass) {
            featureSets = new HashMap();
            if (this.flags.groupByFeatureTemplate) {
                pIndex = 0;
                for (int fIndex = 0; fIndex < this.map.length; ++fIndex) {
                    cliqueType = this.map[fIndex];
                    numCliqueTypeOutputClass = this.labelIndices.get(this.map[fIndex]).size();
                    for (cliqueOutClass = 0; cliqueOutClass < numCliqueTypeOutputClass; ++cliqueOutClass) {
                        String name = "c:" + cliqueType + "-o:" + cliqueOutClass + "-g:" + this.featureIndexToTemplateIndex.get(fIndex);
                        if (featureSets.containsKey(name)) {
                            ((Set)featureSets.get(name)).add(pIndex);
                        } else {
                            HashSet<Integer> newSet = new HashSet<Integer>();
                            newSet.add(pIndex);
                            featureSets.put(name, newSet);
                        }
                        ++pIndex;
                    }
                }
            } else {
                pIndex = 0;
                for (int cliqueType2 : this.map) {
                    int numCliqueTypeOutputClass2 = this.labelIndices.get(cliqueType2).size();
                    for (int cliqueOutClass2 = 0; cliqueOutClass2 < numCliqueTypeOutputClass2; ++cliqueOutClass2) {
                        String name = "c:" + cliqueType2 + "-o:" + cliqueOutClass2;
                        if (featureSets.containsKey(name)) {
                            ((Set)featureSets.get(name)).add(pIndex);
                        } else {
                            HashSet<Integer> newSet = new HashSet<Integer>();
                            newSet.add(pIndex);
                            featureSets.put(name, newSet);
                        }
                        ++pIndex;
                    }
                }
            }
        } else if (this.flags.groupByFeatureTemplate) {
            featureSets = new HashMap();
            pIndex = 0;
            for (int fIndex = 0; fIndex < this.map.length; ++fIndex) {
                cliqueType = this.map[fIndex];
                numCliqueTypeOutputClass = this.labelIndices.get(this.map[fIndex]).size();
                for (cliqueOutClass = 0; cliqueOutClass < numCliqueTypeOutputClass; ++cliqueOutClass) {
                    String name = "c:" + cliqueType + "-g:" + this.featureIndexToTemplateIndex.get(fIndex);
                    if (featureSets.containsKey(name)) {
                        ((Set)featureSets.get(name)).add(pIndex);
                    } else {
                        HashSet<Integer> newSet = new HashSet<Integer>();
                        newSet.add(pIndex);
                        featureSets.put(name, newSet);
                    }
                    ++pIndex;
                }
            }
        }
        if (featureSets != null) {
            int[][] fg = new int[featureSets.size()][];
            log.info("After feature grouping, total of " + fg.length + " groups");
            int count = 0;
            for (Set aSet : featureSets.values()) {
                fg[count] = new int[aSet.size()];
                int i = 0;
                for (Integer val : aSet) {
                    fg[count][i++] = val;
                }
                ++count;
            }
            func.setFeatureGrouping(fg);
        }
        Minimizer<DiffFunction> minimizer = this.getMinimizer(pruneFeatureItr, evaluators);
        if (this.flags.initialWeights == null) {
            initialWeights = func.initial();
        } else {
            try {
                log.info("Reading initial weights from file " + this.flags.initialWeights);
                DataInputStream dis = IOUtils.getDataInputStream(this.flags.initialWeights);
                initialWeights = ConvertByteArray.readDoubleArr(dis);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read from double initial weight file " + this.flags.initialWeights);
            }
        }
        log.info("numWeights: " + initialWeights.length);
        if (this.flags.testObjFunction) {
            StochasticDiffFunctionTester tester = new StochasticDiffFunctionTester(func);
            if (tester.testSumOfBatches(initialWeights, 1.0E-4)) {
                log.info("Successfully tested stochastic objective function.");
            } else {
                throw new IllegalStateException("Testing of stochastic objective function failed.");
            }
        }
        if (this.flags.checkGradient) {
            if (func.gradientCheck()) {
                log.info("gradient check passed");
            } else {
                throw new RuntimeException("gradient check failed");
            }
        }
        return minimizer.minimize(func, this.flags.tolerance, initialWeights);
    }

    public Minimizer<DiffFunction> getMinimizer() {
        return this.getMinimizer(0, null);
    }

    public Minimizer<DiffFunction> getMinimizer(int featurePruneIteration, Evaluator[] evaluators) {
        Minimizer<DiffFunction> minimizer = null;
        QNMinimizer qnMinimizer = null;
        if (this.flags.useQN || this.flags.useSGDtoQN) {
            int qnMem = featurePruneIteration == 0 ? this.flags.QNsize : this.flags.QNsize2;
            if (this.flags.interimOutputFreq != 0) {
                ResultStoringMonitor monitor = new ResultStoringMonitor(this.flags.interimOutputFreq, this.flags.serializeTo);
                qnMinimizer = new QNMinimizer(monitor, qnMem, this.flags.useRobustQN);
            } else {
                qnMinimizer = new QNMinimizer(qnMem, this.flags.useRobustQN);
            }
            qnMinimizer.terminateOnMaxItr(this.flags.maxQNItr);
            qnMinimizer.terminateOnEvalImprovement(this.flags.terminateOnEvalImprovement);
            qnMinimizer.setTerminateOnEvalImprovementNumOfEpoch(this.flags.terminateOnEvalImprovementNumOfEpoch);
            qnMinimizer.suppressTestPrompt(this.flags.suppressTestDebug);
            if (this.flags.useOWLQN) {
                qnMinimizer.useOWLQN(this.flags.useOWLQN, this.flags.priorLambda);
            }
        }
        if (this.flags.useQN) {
            minimizer = qnMinimizer;
        } else if (this.flags.useInPlaceSGD) {
            SGDMinimizer<DiffFunction> sgdMinimizer = new SGDMinimizer<DiffFunction>(this.flags.sigma, this.flags.SGDPasses, this.flags.tuneSampleSize, this.flags.stochasticBatchSize);
            minimizer = this.flags.useSGDtoQN ? new HybridMinimizer(sgdMinimizer, qnMinimizer, this.flags.SGDPasses) : sgdMinimizer;
        } else if (this.flags.useAdaGradFOBOS) {
            double lambda = 0.5 / (this.flags.sigma * this.flags.sigma);
            minimizer = new SGDWithAdaGradAndFOBOS(this.flags.initRate, lambda, this.flags.SGDPasses, this.flags.stochasticBatchSize, this.flags.priorType, this.flags.priorAlpha, this.flags.useAdaDelta, this.flags.useAdaDiff, this.flags.adaGradEps, this.flags.adaDeltaRho);
            ((SGDWithAdaGradAndFOBOS)minimizer).terminateOnEvalImprovement(this.flags.terminateOnEvalImprovement);
            ((SGDWithAdaGradAndFOBOS)minimizer).terminateOnAvgImprovement(this.flags.terminateOnAvgImprovement, this.flags.tolerance);
            ((SGDWithAdaGradAndFOBOS)minimizer).setTerminateOnEvalImprovementNumOfEpoch(this.flags.terminateOnEvalImprovementNumOfEpoch);
            ((SGDWithAdaGradAndFOBOS)minimizer).suppressTestPrompt(this.flags.suppressTestDebug);
        } else if (this.flags.useSGDtoQN) {
            minimizer = new SGDToQNMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize, this.flags.SGDPasses, this.flags.QNPasses, this.flags.SGD2QNhessSamples, this.flags.QNsize, this.flags.outputIterationsToFile);
        } else if (this.flags.useSMD) {
            minimizer = new SMDMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize, this.flags.stochasticMethod, this.flags.SGDPasses);
        } else if (this.flags.useSGD) {
            minimizer = new InefficientSGDMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize);
        } else if (this.flags.useScaledSGD) {
            minimizer = new ScaledSGDMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize, this.flags.SGDPasses, this.flags.scaledSGDMethod);
        } else if (this.flags.l1reg > 0.0) {
            minimizer = (Minimizer)ReflectionLoading.loadByReflection("edu.stanford.nlp.optimization.OWLQNMinimizer", this.flags.l1reg);
        } else {
            throw new RuntimeException("No minimizer assigned!");
        }
        if (minimizer instanceof HasEvaluators) {
            if (minimizer instanceof QNMinimizer) {
                minimizer.setEvaluators(this.flags.evaluateIters, this.flags.startEvaluateIters, evaluators);
            } else {
                ((HasEvaluators)((Object)minimizer)).setEvaluators(this.flags.evaluateIters, evaluators);
            }
        }
        return minimizer;
    }

    protected List<CRFDatum<? extends Collection<String>, ? extends CharSequence>> extractDatumSequence(int[][][] allData, int beginPosition, int endPosition, List<IN> labeledWordInfos) {
        CRFDatum datum;
        ArrayList<double[]> featureVals;
        ArrayList<List<Object>> cliqueFeatures;
        int position;
        ArrayList<CRFDatum<? extends Collection<String>, ? extends CharSequence>> result = new ArrayList<CRFDatum<? extends Collection<String>, ? extends CharSequence>>();
        int beginContext = beginPosition - this.windowSize + 1;
        if (beginContext < 0) {
            beginContext = 0;
        }
        for (position = beginContext; position < beginPosition; ++position) {
            cliqueFeatures = new ArrayList<List<Object>>();
            featureVals = new ArrayList<double[]>();
            for (int i = 0; i < this.windowSize; ++i) {
                cliqueFeatures.add(Collections.emptyList());
                featureVals.add(null);
            }
            datum = new CRFDatum(cliqueFeatures, ((CoreMap)labeledWordInfos.get(position)).get(CoreAnnotations.AnswerAnnotation.class), featureVals);
            result.add(datum);
        }
        for (position = beginPosition; position <= endPosition; ++position) {
            cliqueFeatures = new ArrayList();
            featureVals = new ArrayList();
            for (int i = 0; i < this.windowSize; ++i) {
                ArrayList<String> features = new ArrayList<String>();
                for (int j = 0; j < allData[position][i].length; ++j) {
                    features.add(this.featureIndex.get(allData[position][i][j]));
                }
                cliqueFeatures.add(features);
                featureVals.add(null);
            }
            datum = new CRFDatum(cliqueFeatures, ((CoreMap)labeledWordInfos.get(position)).get(CoreAnnotations.AnswerAnnotation.class), featureVals);
            result.add(datum);
        }
        return result;
    }

    protected void addProcessedData(List<List<CRFDatum<Collection<String>, String>>> processedData, int[][][][] data, int[][] labels, double[][][][] featureVals, int offset) {
        int pdSize = processedData.size();
        for (int i = 0; i < pdSize; ++i) {
            int dataIndex = i + offset;
            List<CRFDatum<Collection<String>, String>> document = processedData.get(i);
            int dsize = document.size();
            labels[dataIndex] = new int[dsize];
            data[dataIndex] = new int[dsize][][];
            if (featureVals != null) {
                featureVals[dataIndex] = new double[dsize][][];
            }
            for (int j = 0; j < dsize; ++j) {
                CRFDatum<Collection<String>, String> crfDatum = document.get(j);
                labels[dataIndex][j] = this.classIndex.indexOf(crfDatum.label());
                List<double[]> featureValList = null;
                if (featureVals != null) {
                    featureValList = crfDatum.asFeatureVals();
                }
                List<Collection<String>> cliques = crfDatum.asFeatures();
                int csize = cliques.size();
                data[dataIndex][j] = new int[csize][];
                if (featureVals != null) {
                    featureVals[dataIndex][j] = new double[csize][];
                }
                for (int k = 0; k < csize; ++k) {
                    Collection<String> features = cliques.get(k);
                    data[dataIndex][j][k] = new int[features.size()];
                    if (featureVals != null) {
                        featureVals[dataIndex][j][k] = featureValList.get(k);
                    }
                    int m = 0;
                    try {
                        for (String feature : features) {
                            if (this.featureIndex == null) {
                                System.out.println("Feature is NULL!");
                            }
                            data[dataIndex][j][k][m] = this.featureIndex.indexOf(feature);
                            ++m;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Add processed data failed.", e);
                        log.info(String.format("[index=%d, j=%d, k=%d, m=%d]%n", dataIndex, j, k, m));
                        log.info("data.length                    " + data.length);
                        log.info("data[dataIndex].length         " + data[dataIndex].length);
                        log.info("data[dataIndex][j].length      " + data[dataIndex][j].length);
                        log.info("data[dataIndex][j][k].length   " + data[dataIndex][j].length);
                        log.info("data[dataIndex][j][k][m]       " + data[dataIndex][j][k][m]);
                        return;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveProcessedData(List<?> datums, String filename) {
        log.info("Saving processed data of size " + datums.size() + " to serialized file...");
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(filename));
            oos.writeObject(datums);
        }
        catch (IOException iOException) {
            IOUtils.closeIgnoringExceptions(oos);
        }
        catch (Throwable throwable) {
            IOUtils.closeIgnoringExceptions(oos);
            throw throwable;
        }
        IOUtils.closeIgnoringExceptions(oos);
        log.info("done.");
    }

    protected static List<List<CRFDatum<Collection<String>, String>>> loadProcessedData(String filename) {
        List<List<CRFDatum<Collection<String>, String>>> result;
        try {
            result = (List<List<CRFDatum<Collection<String>, String>>>)IOUtils.readObjectFromURLOrClasspathOrFileSystem(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = Collections.emptyList();
        }
        log.info("Loading processed data from serialized file ... done. Got " + result.size() + " datums.");
        return result;
    }

    protected void loadTextClassifier(BufferedReader br) throws Exception {
        String[] featureFactoryName;
        int count;
        String line = br.readLine();
        String[] toks = line.split("\\t");
        if (!toks[0].equals("labelIndices.length=")) {
            throw new RuntimeException("format error");
        }
        int size = Integer.parseInt(toks[1]);
        this.labelIndices = new ArrayList<Index<CRFLabel>>(size);
        for (int labelIndicesIdx = 0; labelIndicesIdx < size; ++labelIndicesIdx) {
            line = br.readLine();
            toks = line.split("\\t");
            if (!toks[0].startsWith("labelIndices[") || !toks[0].endsWith("].size()=")) {
                throw new RuntimeException("format error");
            }
            int labelIndexSize = Integer.parseInt(toks[1]);
            this.labelIndices.add(new HashIndex());
            for (int count2 = 0; count2 < labelIndexSize; ++count2) {
                line = br.readLine();
                toks = line.split("\\t");
                int idx = Integer.parseInt(toks[0]);
                if (count2 != idx) {
                    throw new RuntimeException("format error");
                }
                String[] crflabelstr = toks[1].split(" ");
                int[] crflabel = new int[crflabelstr.length];
                for (int i = 0; i < crflabelstr.length; ++i) {
                    crflabel[i] = Integer.parseInt(crflabelstr[i]);
                }
                CRFLabel crfL = new CRFLabel(crflabel);
                this.labelIndices.get(labelIndicesIdx).add(crfL);
            }
        }
        for (Index<CRFLabel> index : this.labelIndices) {
            for (int j = 0; j < index.size(); ++j) {
                int[] label = index.get(j).getLabel();
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int l : label) {
                    list.add(l);
                }
            }
        }
        line = br.readLine();
        toks = line.split("\\t");
        if (!toks[0].equals("classIndex.size()=")) {
            throw new RuntimeException("format error");
        }
        int classIndexSize = Integer.parseInt(toks[1]);
        this.classIndex = new HashIndex();
        for (count = 0; count < classIndexSize; ++count) {
            line = br.readLine();
            toks = line.split("\\t");
            int idx = Integer.parseInt(toks[0]);
            if (count != idx) {
                throw new RuntimeException("format error");
            }
            this.classIndex.add(toks[1]);
        }
        line = br.readLine();
        toks = line.split("\\t");
        if (!toks[0].equals("featureIndex.size()=")) {
            throw new RuntimeException("format error");
        }
        int featureIndexSize = Integer.parseInt(toks[1]);
        this.featureIndex = new HashIndex<String>();
        for (count = 0; count < featureIndexSize; ++count) {
            line = br.readLine();
            toks = line.split("\\t");
            int idx = Integer.parseInt(toks[0]);
            if (count != idx) {
                throw new RuntimeException("format error");
            }
            this.featureIndex.add(toks[1]);
        }
        line = br.readLine();
        if (!line.equals("<flags>")) {
            throw new RuntimeException("format error");
        }
        Properties p = new Properties();
        line = br.readLine();
        while (!line.equals("</flags>")) {
            String[] keyValue = line.split("=");
            p.setProperty(keyValue[0], keyValue[1]);
            line = br.readLine();
        }
        this.flags = new SeqClassifierFlags(p);
        if (this.flags.useEmbedding) {
            line = br.readLine();
            toks = line.split("\\t");
            if (!toks[0].equals("embeddings.size()=")) {
                throw new RuntimeException("format error in embeddings");
            }
            int embeddingSize = Integer.parseInt(toks[1]);
            this.embeddings = Generics.newHashMap(embeddingSize);
            for (count = 0; count < embeddingSize; ++count) {
                line = br.readLine().trim();
                toks = line.split("\\t");
                String word = toks[0];
                double[] arr = ArrayUtils.toDoubleArray(toks[1].split(" "));
                this.embeddings.put(word, arr);
            }
        }
        if ((featureFactoryName = (line = br.readLine()).split(" ")).length < 2 || !featureFactoryName[0].equals("<featureFactory>") || !featureFactoryName[featureFactoryName.length - 1].equals("</featureFactory>")) {
            throw new RuntimeException("format error unexpected featureFactory line: " + line);
        }
        this.featureFactories = Generics.newArrayList();
        for (int ff = 1; ff < featureFactoryName.length - 1; ++ff) {
            FeatureFactory featureFactory = (FeatureFactory)Class.forName(featureFactoryName[1]).newInstance();
            featureFactory.init(this.flags);
            this.featureFactories.add(featureFactory);
        }
        this.reinit();
        line = br.readLine();
        String[] windowSizeName = line.split(" ");
        if (!windowSizeName[0].equals("<windowSize>") || !windowSizeName[2].equals("</windowSize>")) {
            throw new RuntimeException("format error");
        }
        this.windowSize = Integer.parseInt(windowSizeName[1]);
        line = br.readLine();
        toks = line.split("\\t");
        if (!toks[0].equals("weights.length=")) {
            throw new RuntimeException("format error");
        }
        int weightsLength = Integer.parseInt(toks[1]);
        this.weights = new double[weightsLength][];
        for (count = 0; count < weightsLength; ++count) {
            line = br.readLine();
            toks = line.split("\\t");
            int weights2Length = Integer.parseInt(toks[0]);
            this.weights[count] = new double[weights2Length];
            String[] weightsValue = toks[1].split(" ");
            if (weights2Length != weightsValue.length) {
                throw new RuntimeException("weights format error");
            }
            for (int i2 = 0; i2 < weights2Length; ++i2) {
                this.weights[count][i2] = Double.parseDouble(weightsValue[i2]);
            }
        }
        System.err.printf("DEBUG: double[%d][] weights loaded%n", weightsLength);
        line = br.readLine();
        if (line != null) {
            throw new RuntimeException("weights format error");
        }
    }

    public void loadTextClassifier(String text, Properties props) throws ClassCastException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        log.info("Loading Text Classifier from " + text);
        try (BufferedReader br = IOUtils.readerFromString(text);){
            this.loadTextClassifier(br);
        }
        catch (Exception ex) {
            log.info("Exception in loading text classifier from " + text, ex);
        }
    }

    protected void serializeTextClassifier(PrintWriter pw) throws Exception {
        int i;
        pw.printf("labelIndices.length=\t%d%n", this.labelIndices.size());
        for (i = 0; i < this.labelIndices.size(); ++i) {
            pw.printf("labelIndices[%d].size()=\t%d%n", i, this.labelIndices.get(i).size());
            for (int j = 0; j < this.labelIndices.get(i).size(); ++j) {
                int[] label = this.labelIndices.get(i).get(j).getLabel();
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int l : label) {
                    list.add(l);
                }
                pw.printf("%d\t%s%n", j, StringUtils.join(list, " "));
            }
        }
        pw.printf("classIndex.size()=\t%d%n", this.classIndex.size());
        for (i = 0; i < this.classIndex.size(); ++i) {
            pw.printf("%d\t%s%n", i, this.classIndex.get(i));
        }
        pw.printf("featureIndex.size()=\t%d%n", this.featureIndex.size());
        for (i = 0; i < this.featureIndex.size(); ++i) {
            pw.printf("%d\t%s%n", i, this.featureIndex.get(i));
        }
        pw.println("<flags>");
        pw.print(this.flags);
        pw.println("</flags>");
        if (this.flags.useEmbedding) {
            pw.printf("embeddings.size()=\t%d%n", this.embeddings.size());
            for (String word : this.embeddings.keySet()) {
                double[] arr = this.embeddings.get(word);
                Object[] arrUnboxed = new Double[arr.length];
                for (int i2 = 0; i2 < arr.length; ++i2) {
                    arrUnboxed[i2] = arr[i2];
                }
                pw.printf("%s\t%s%n", word, StringUtils.join(arrUnboxed, " "));
            }
        }
        pw.printf("<featureFactory>", new Object[0]);
        for (FeatureFactory featureFactory : this.featureFactories) {
            pw.printf(" %s ", featureFactory.getClass().getName());
        }
        pw.printf("</featureFactory>%n", new Object[0]);
        pw.printf("<windowSize> %d </windowSize>%n", this.windowSize);
        pw.printf("weights.length=\t%d%n", this.weights.length);
        for (Object ws : (Object)this.weights) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (Object w : ws) {
                list.add((double)w);
            }
            pw.printf("%d\t%s%n", ((Object)ws).length, StringUtils.join(list, " "));
        }
    }

    public void serializeTextClassifier(String serializePath) {
        try {
            PrintWriter pw = new PrintWriter(new GZIPOutputStream(new FileOutputStream(serializePath)));
            this.serializeTextClassifier(pw);
            pw.close();
            log.info("Serializing Text classifier to " + serializePath + "... done.");
        }
        catch (Exception e) {
            log.info("Serializing Text classifier to " + serializePath + "... FAILED.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeClassIndex(String serializePath) {
        ObjectOutputStream oos = null;
        try {
            oos = IOUtils.writeStreamFromString(serializePath);
            oos.writeObject(this.classIndex);
            log.info("Serializing class index to " + serializePath + "... done.");
        }
        catch (Exception e) {
            log.info("Serializing class index to " + serializePath + "... FAILED.", e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(oos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Index<String> loadClassIndexFromFile(String serializePath) {
        ObjectInputStream ois = null;
        Index c = null;
        try {
            ois = IOUtils.readStreamFromString(serializePath);
            c = (Index)ois.readObject();
            log.info("Reading class index from " + serializePath + "... done.");
        }
        catch (Exception e) {
            log.info("Reading class index from " + serializePath + "... FAILED.", e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(ois);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeWeights(String serializePath) {
        ObjectOutputStream oos = null;
        try {
            oos = IOUtils.writeStreamFromString(serializePath);
            oos.writeObject(this.weights);
            log.info("Serializing weights to " + serializePath + "... done.");
        }
        catch (Exception e) {
            log.info("Serializing weights to " + serializePath + "... FAILED.", e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(oos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[][] loadWeightsFromFile(String serializePath) {
        ObjectInputStream ois = null;
        double[][] w = null;
        try {
            ois = IOUtils.readStreamFromString(serializePath);
            w = (double[][])ois.readObject();
            log.info("Reading weights from " + serializePath + "... done.");
        }
        catch (Exception e) {
            log.info("Reading weights from " + serializePath + "... FAILED.", e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(ois);
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeFeatureIndex(String serializePath) {
        ObjectOutputStream oos = null;
        try {
            oos = IOUtils.writeStreamFromString(serializePath);
            oos.writeObject(this.featureIndex);
            log.info("Serializing FeatureIndex to " + serializePath + "... done.");
        }
        catch (Exception e) {
            log.info("Failed");
            log.info("Serializing FeatureIndex to " + serializePath + "... FAILED.", e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(oos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Index<String> loadFeatureIndexFromFile(String serializePath) {
        ObjectInputStream ois = null;
        Index f = null;
        try {
            ois = IOUtils.readStreamFromString(serializePath);
            f = (Index)ois.readObject();
            log.info("Reading FeatureIndex from " + serializePath + "... done.");
        }
        catch (Exception e) {
            log.info("Reading FeatureIndex from " + serializePath + "... FAILED.", e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(ois);
        }
        return f;
    }

    @Override
    public void serializeClassifier(String serializePath) {
        ObjectOutputStream oos = null;
        try {
            oos = IOUtils.writeStreamFromString(serializePath);
            this.serializeClassifier(oos);
            log.info("Serializing classifier to " + serializePath + "... done.");
        }
        catch (Exception e) {
            throw new RuntimeIOException("Serializing classifier to " + serializePath + "... FAILED", e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(oos);
        }
    }

    @Override
    public void serializeClassifier(ObjectOutputStream oos) {
        try {
            oos.writeObject(this.labelIndices);
            oos.writeObject(this.classIndex);
            oos.writeObject(this.featureIndex);
            oos.writeObject(this.flags);
            if (this.flags.useEmbedding) {
                oos.writeObject(this.embeddings);
            }
            oos.writeObject(this.featureFactories.size());
            for (FeatureFactory ff : this.featureFactories) {
                oos.writeObject(ff);
            }
            oos.writeInt(this.windowSize);
            oos.writeObject(this.weights);
            oos.writeObject(this.knownLCWords);
            if (this.labelDictionary != null) {
                oos.writeObject(this.labelDictionary);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void loadClassifier(ObjectInputStream ois, Properties props) throws ClassCastException, IOException, ClassNotFoundException {
        Object featureFactory;
        Object o = ois.readObject();
        if (o instanceof List) {
            this.labelIndices = (List)o;
        } else {
            Index[] indexArray = (Index[])o;
            this.labelIndices = new ArrayList<Index<CRFLabel>>(indexArray.length);
            Collections.addAll(this.labelIndices, indexArray);
        }
        this.classIndex = (Index)ois.readObject();
        this.featureIndex = (Index)ois.readObject();
        this.flags = (SeqClassifierFlags)ois.readObject();
        if (this.flags.useEmbedding) {
            this.embeddings = (Map)ois.readObject();
        }
        if ((featureFactory = ois.readObject()) instanceof List) {
            this.featureFactories = (List)ErasureUtils.uncheckedCast(this.featureFactories);
        } else if (featureFactory instanceof FeatureFactory) {
            this.featureFactories = Generics.newArrayList();
            this.featureFactories.add((FeatureFactory)featureFactory);
        } else if (featureFactory instanceof Integer) {
            int size = (Integer)featureFactory;
            this.featureFactories = Generics.newArrayList(size);
            for (int i = 0; i < size; ++i) {
                featureFactory = ois.readObject();
                if (!(featureFactory instanceof FeatureFactory)) {
                    throw new RuntimeIOException("Should have FeatureFactory but got " + featureFactory.getClass());
                }
                this.featureFactories.add((FeatureFactory)featureFactory);
            }
        }
        if (props != null) {
            this.flags.setProperties(props, false);
        }
        this.windowSize = ois.readInt();
        this.weights = (double[][])ois.readObject();
        Set lcWords = (Set)ois.readObject();
        this.knownLCWords = lcWords instanceof MaxSizeConcurrentHashSet ? (MaxSizeConcurrentHashSet)lcWords : new MaxSizeConcurrentHashSet(lcWords);
        this.reinit();
        if (this.flags.labelDictionaryCutoff > 0) {
            this.labelDictionary = (LabelDictionary)ois.readObject();
        }
    }

    public void loadDefaultClassifier() {
        this.loadClassifierNoExceptions(DEFAULT_CLASSIFIER);
    }

    public void loadTagIndex() {
        if (this.tagIndex == null) {
            this.tagIndex = new HashIndex<String>();
            for (String tag : this.classIndex.objectsList()) {
                String[] parts = tag.split("-");
                this.tagIndex.add(parts[parts.length - 1]);
            }
            this.tagIndex.add(this.flags.backgroundSymbol);
        }
        if (this.flags.useNERPriorBIO && this.entityMatrices == null) {
            this.entityMatrices = CRFClassifier.readEntityMatrices(this.flags.entityMatrix, this.tagIndex);
        }
    }

    private static double[][] parseMatrix(String[] lines, Index<String> tagIndex, int matrixSize, boolean smooth) {
        return CRFClassifier.parseMatrix(lines, tagIndex, matrixSize, smooth, true);
    }

    static double[][] parseMatrix(String[] lines, Index<String> tagIndex, int matrixSize, boolean smooth, boolean useLogProb) {
        double[][] matrix = new double[matrixSize][matrixSize];
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = new double[matrixSize];
        }
        for (String line : lines) {
            String[] parts;
            for (String part : parts = line.split("\t")) {
                String[] subparts = part.split(" ");
                String[] subsubparts = subparts[0].split(":");
                double counts = Double.parseDouble(subparts[1]);
                if (counts == 0.0 && smooth) {
                    counts = 1.0;
                }
                int tagIndex1 = tagIndex.indexOf(subsubparts[0]);
                int tagIndex2 = tagIndex.indexOf(subsubparts[1]);
                matrix[tagIndex1][tagIndex2] = counts;
            }
        }
        for (int i = 0; i < matrix.length; ++i) {
            double sum = ArrayMath.sum(matrix[i]);
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = useLogProb ? Math.log(matrix[i][j] / sum) : matrix[i][j] / sum;
            }
        }
        return matrix;
    }

    static Pair<double[][], double[][]> readEntityMatrices(String fileName, Index<String> tagIndex) {
        int numTags = tagIndex.size();
        int matrixSize = numTags - 1;
        String[] matrixLines = new String[matrixSize];
        String[] subMatrixLines = new String[matrixSize];
        try (BufferedReader br = IOUtils.readerFromString(fileName);){
            String line;
            int lineCount = 0;
            while ((line = br.readLine()) != null) {
                line = line.trim();
                if (lineCount < matrixSize) {
                    matrixLines[lineCount] = line;
                } else {
                    subMatrixLines[lineCount - matrixSize] = line;
                }
                ++lineCount;
            }
        }
        catch (Exception ex) {
            throw new RuntimeIOException(ex);
        }
        double[][] matrix = CRFClassifier.parseMatrix(matrixLines, tagIndex, matrixSize, true);
        double[][] subMatrix = CRFClassifier.parseMatrix(subMatrixLines, tagIndex, matrixSize, true);
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = matrix[i][j] / 2.0;
            }
        }
        log.info("Matrix: ");
        log.info(ArrayUtils.toString(matrix));
        log.info("SubMatrix: ");
        log.info(ArrayUtils.toString(subMatrix));
        return new Pair<double[][], double[][]>(matrix, subMatrix);
    }

    public void writeWeights(PrintStream p) {
        for (String feature : this.featureIndex) {
            int index = this.featureIndex.indexOf(feature);
            double[] v = this.weights[index];
            Index<CRFLabel> l = this.labelIndices.get(0);
            p.println(feature + "\t\t");
            for (CRFLabel label : l) {
                p.print(label.toString(this.classIndex) + ":" + v[l.indexOf(label)] + "\t");
            }
            p.println();
        }
    }

    public Map<String, Counter<String>> topWeights() {
        HashMap<String, Counter<String>> w = new HashMap<String, Counter<String>>();
        for (String feature : this.featureIndex) {
            int index = this.featureIndex.indexOf(feature);
            double[] v = this.weights[index];
            Index<CRFLabel> l = this.labelIndices.get(0);
            for (CRFLabel label : l) {
                if (!w.containsKey(label.toString(this.classIndex))) {
                    w.put(label.toString(this.classIndex), new ClassicCounter());
                }
                ((Counter)w.get(label.toString(this.classIndex))).setCount(feature, v[l.indexOf(label)]);
            }
        }
        return w;
    }

    private void readEmbeddingsData() throws IOException {
        System.err.printf("Reading embedding files %s and %s.%n", this.flags.embeddingWords, this.flags.embeddingVectors);
        ArrayList<String> wordList = new ArrayList<String>();
        try (BufferedReader br = IOUtils.readerFromString(this.flags.embeddingWords);){
            String line;
            while ((line = br.readLine()) != null) {
                wordList.add(line.trim());
            }
            log.info("Found a dictionary of size " + wordList.size());
        }
        this.embeddings = Generics.newHashMap();
        int count = 0;
        int vectorSize = -1;
        boolean warned = false;
        try (BufferedReader br = IOUtils.readerFromString(this.flags.embeddingVectors);){
            String line;
            while ((line = br.readLine()) != null) {
                double[] vector = ArrayUtils.toDoubleArray(line.trim().split(" "));
                if (vectorSize < 0) {
                    vectorSize = vector.length;
                } else if (vectorSize != vector.length && !warned) {
                    log.info("Inconsistent vector lengths: " + vectorSize + " vs. " + vector.length);
                    warned = true;
                }
                this.embeddings.put((String)wordList.get(count++), vector);
            }
            log.info("Found " + count + " matching embeddings of dimension " + vectorSize);
        }
    }

    @Override
    public List<IN> classifyWithGlobalInformation(List<IN> tokenSeq, CoreMap doc, CoreMap sent) {
        return this.classify(tokenSeq);
    }

    public void loadDefaultClassifier(Properties props) {
        this.loadClassifierNoExceptions(DEFAULT_CLASSIFIER, props);
    }

    public static <INN extends CoreMap> CRFClassifier<INN> getDefaultClassifier() {
        CRFClassifier crf = new CRFClassifier();
        crf.loadDefaultClassifier();
        return crf;
    }

    public static <INN extends CoreMap> CRFClassifier<INN> getDefaultClassifier(Properties props) {
        CRFClassifier crf = new CRFClassifier();
        crf.loadDefaultClassifier(props);
        return crf;
    }

    public static <INN extends CoreMap> CRFClassifier<INN> getClassifier(File file) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifier(file);
        return crf;
    }

    public static <INN extends CoreMap> CRFClassifier<INN> getClassifier(InputStream in) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifier(in);
        return crf;
    }

    public static <INN extends CoreMap> CRFClassifier<INN> getClassifier(ObjectInputStream ois) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifier(ois, null);
        return crf;
    }

    public static <INN extends CoreMap> CRFClassifier<INN> getClassifierNoExceptions(String loadPath) {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifierNoExceptions(loadPath);
        return crf;
    }

    public static CRFClassifier<CoreLabel> getClassifier(String loadPath) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier<CoreLabel> crf = new CRFClassifier<CoreLabel>();
        crf.loadClassifier(loadPath);
        return crf;
    }

    public static <INN extends CoreMap> CRFClassifier<INN> getClassifier(String loadPath, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifier(loadPath, props);
        return crf;
    }

    public static <INN extends CoreMap> CRFClassifier<INN> getClassifier(ObjectInputStream ois, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifier(ois, props);
        return crf;
    }

    private static CRFClassifier<CoreLabel> chooseCRFClassifier(SeqClassifierFlags flags) {
        CRFClassifier crf = flags.useFloat ? new CRFClassifierFloat<CoreLabel>(flags) : (flags.nonLinearCRF ? new CRFClassifierNonlinear(flags) : (flags.numLopExpert > 1 ? new CRFClassifierWithLOP(flags) : (flags.priorType.equals("DROPOUT") ? new CRFClassifierWithDropout(flags) : (flags.useNoisyLabel ? new CRFClassifierNoisyLabel(flags) : new CRFClassifier(flags)))));
        return crf;
    }

    public static void main(String[] args) throws Exception {
        List<File> files;
        StringUtils.logInvocationString(log, args);
        Properties props = StringUtils.argsToProperties(args);
        SeqClassifierFlags flags = new SeqClassifierFlags(props);
        CRFClassifier<CoreLabel> crf = CRFClassifier.chooseCRFClassifier(flags);
        String testFile = flags.testFile;
        String testFiles = flags.testFiles;
        String textFile = flags.textFile;
        String textFiles = flags.textFiles;
        String loadPath = flags.loadClassifier;
        String loadTextPath = flags.loadTextClassifier;
        String serializeTo = flags.serializeTo;
        String serializeToText = flags.serializeToText;
        if (crf.flags.useEmbedding && crf.flags.embeddingWords != null && crf.flags.embeddingVectors != null) {
            super.readEmbeddingsData();
        }
        if (crf.flags.loadClassIndexFrom != null) {
            crf.classIndex = CRFClassifier.loadClassIndexFromFile(crf.flags.loadClassIndexFrom);
        }
        if (loadPath != null) {
            crf.loadClassifierNoExceptions(loadPath, props);
        } else if (loadTextPath != null) {
            log.info("Warning: this is now only tested for Chinese Segmenter");
            log.info("(Sun Dec 23 00:59:39 2007) (pichuan)");
            try {
                crf.loadTextClassifier(loadTextPath, props);
            }
            catch (Exception e) {
                throw new RuntimeException("error loading " + loadTextPath, e);
            }
        } else if (crf.flags.loadJarClassifier != null) {
            crf.loadClassifierNoExceptions(crf.flags.loadJarClassifier, props);
        } else if (crf.flags.trainFile != null || crf.flags.trainFileList != null) {
            Timing timing = new Timing();
            int knownLCWordsLimit = crf.knownLCWords.getMaxSize();
            crf.knownLCWords.setMaxSize(-1);
            crf.train();
            crf.knownLCWords.setMaxSize(knownLCWordsLimit);
            timing.done(log, "CRFClassifier training");
        } else {
            crf.loadDefaultClassifier();
        }
        crf.loadTagIndex();
        if (serializeTo != null) {
            crf.serializeClassifier(serializeTo);
        }
        if (crf.flags.serializeWeightsTo != null) {
            crf.serializeWeights(crf.flags.serializeWeightsTo);
        }
        if (crf.flags.serializeFeatureIndexTo != null) {
            crf.serializeFeatureIndex(crf.flags.serializeFeatureIndexTo);
        }
        if (serializeToText != null) {
            crf.serializeTextClassifier(serializeToText);
        }
        if (testFile != null) {
            DocumentReaderAndWriter readerAndWriter = crf.defaultReaderAndWriter();
            if (crf.flags.searchGraphPrefix != null) {
                crf.classifyAndWriteViterbiSearchGraph(testFile, crf.flags.searchGraphPrefix, readerAndWriter);
            } else if (crf.flags.printFirstOrderProbs) {
                crf.printFirstOrderProbs(testFile, readerAndWriter);
            } else if (crf.flags.printFactorTable) {
                crf.printFactorTable(testFile, readerAndWriter);
            } else if (crf.flags.printProbs) {
                crf.printProbs(testFile, readerAndWriter);
            } else if (crf.flags.useKBest) {
                int k = crf.flags.kBest;
                crf.classifyAndWriteAnswersKBest(testFile, k, readerAndWriter);
            } else if (crf.flags.printLabelValue) {
                crf.printLabelInformation(testFile, readerAndWriter);
            } else {
                crf.classifyAndWriteAnswers(testFile, readerAndWriter, true);
            }
        }
        if (testFiles != null) {
            files = Arrays.stream(testFiles.split(",")).map(File::new).collect(Collectors.toList());
            if (crf.flags.printProbs) {
                crf.printProbs(files, crf.defaultReaderAndWriter());
            } else {
                crf.classifyFilesAndWriteAnswers(files, crf.defaultReaderAndWriter(), true);
            }
        }
        if (textFile != null) {
            crf.classifyAndWriteAnswers(textFile, crf.plainTextReaderAndWriter(), false);
        }
        if (textFiles != null) {
            files = Arrays.stream(textFiles.split(",")).map(File::new).collect(Collectors.toList());
            crf.classifyFilesAndWriteAnswers(files);
        }
        if (crf.flags.readStdin) {
            crf.classifyStdin();
        }
    }
}

