/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.DependencyPrinter;
import edu.stanford.nlp.trees.DependencyReader;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.NPTmpRetainingTreeNormalizer;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.SimpleTree;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.UniversalPOSMapper;
import edu.stanford.nlp.trees.international.pennchinese.CTBErrorCorrectingTreeNormalizer;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class GrammaticalStructureConversionUtils {
    public static final String DEFAULT_PARSER_FILE = "edu/stanford/nlp/models/lexparser/englishPCFG.ser.gz";
    private static Redwood.RedwoodChannels log = Redwood.channels(GrammaticalStructureConversionUtils.class);

    private GrammaticalStructureConversionUtils() {
    }

    public static void printDependencies(GrammaticalStructure gs, Collection<TypedDependency> deps, Tree tree, boolean conllx, boolean extraSep, boolean convertToUPOS) {
        System.out.println(GrammaticalStructureConversionUtils.dependenciesToString(gs, deps, tree, conllx, extraSep, convertToUPOS));
    }

    public static String dependenciesToCoNLLXString(GrammaticalStructure gs, CoreMap sentence) {
        return GrammaticalStructureConversionUtils.dependenciesToCoNLLXString(gs.typedDependencies(), sentence);
    }

    public static String dependenciesToCoNLLXString(Collection<TypedDependency> deps, CoreMap sentence) {
        StringBuilder bf = new StringBuilder();
        HashMap<Integer, TypedDependency> indexedDeps = new HashMap<Integer, TypedDependency>(deps.size());
        for (TypedDependency dep : deps) {
            indexedDeps.put(dep.dep().index(), dep);
        }
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        if (tokens == null) {
            throw new RuntimeException("dependenciesToCoNLLXString: CoreMap does not have required TokensAnnotation.");
        }
        int idx = 1;
        for (CoreLabel token : tokens) {
            String word = token.value();
            String pos = token.tag();
            String cPos = token.get(CoreAnnotations.CoarseTagAnnotation.class) != null ? (String)token.get(CoreAnnotations.CoarseTagAnnotation.class) : pos;
            String lemma = token.lemma() != null ? token.lemma() : "_";
            Integer gov = indexedDeps.containsKey(idx) ? ((TypedDependency)indexedDeps.get(idx)).gov().index() : 0;
            String reln = indexedDeps.containsKey(idx) ? ((TypedDependency)indexedDeps.get(idx)).reln().toString() : "erased";
            String out2 = String.format("%d\t%s\t%s\t%s\t%s\t_\t%d\t%s\t_\t_\n", idx, word, lemma, cPos, pos, gov, reln);
            bf.append(out2);
            ++idx;
        }
        return bf.toString();
    }

    public static String dependenciesToString(GrammaticalStructure gs, Collection<TypedDependency> deps, Tree tree, boolean conllx, boolean extraSep, boolean convertToUPOS) {
        StringBuilder bf;
        block9: {
            Map<Integer, Integer> indexToPos;
            block10: {
                block8: {
                    Object uposLabels;
                    bf = new StringBuilder();
                    indexToPos = Generics.newHashMap();
                    indexToPos.put(0, 0);
                    List gsLeaves = gs.root().getLeaves();
                    for (int i = 0; i < gsLeaves.size(); ++i) {
                        TreeGraphNode leaf = (TreeGraphNode)gsLeaves.get(i);
                        indexToPos.put(leaf.label().index(), i + 1);
                    }
                    if (!conllx) break block8;
                    List leaves = tree.getLeaves();
                    if (convertToUPOS) {
                        Tree uposTree = UniversalPOSMapper.mapTree(tree);
                        uposLabels = uposTree.preTerminalYield();
                    } else {
                        uposLabels = tree.preTerminalYield();
                    }
                    int index = 0;
                    CoreLabel sentence = new CoreLabel();
                    ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>(leaves.size());
                    for (Tree leaf : leaves) {
                        if (!indexToPos.containsKey(++index)) continue;
                        CoreLabel token = new CoreLabel();
                        token.setIndex(index);
                        token.setValue(leaf.value());
                        token.setWord(leaf.value());
                        token.setTag(leaf.parent(tree).value());
                        token.set(CoreAnnotations.CoarseTagAnnotation.class, ((Label)uposLabels.get(index - 1)).value());
                        tokens.add(token);
                    }
                    sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
                    bf.append(GrammaticalStructureConversionUtils.dependenciesToCoNLLXString(deps, (CoreMap)sentence));
                    break block9;
                }
                if (!extraSep) break block10;
                ArrayList<TypedDependency> extraDeps = new ArrayList<TypedDependency>();
                for (TypedDependency dep : deps) {
                    if (dep.extra()) {
                        extraDeps.add(dep);
                        continue;
                    }
                    bf.append(GrammaticalStructureConversionUtils.toStringIndex(dep, indexToPos));
                    bf.append('\n');
                }
                if (extraDeps.isEmpty()) break block9;
                bf.append("======\n");
                for (TypedDependency dep : extraDeps) {
                    bf.append(GrammaticalStructureConversionUtils.toStringIndex(dep, indexToPos));
                    bf.append('\n');
                }
                break block9;
            }
            for (TypedDependency dep : deps) {
                bf.append(GrammaticalStructureConversionUtils.toStringIndex(dep, indexToPos));
                bf.append('\n');
            }
        }
        return bf.toString();
    }

    private static String toStringIndex(TypedDependency td, Map<Integer, Integer> indexToPos) {
        IndexedWord gov = td.gov();
        IndexedWord dep = td.dep();
        return td.reln() + "(" + gov.value() + "-" + indexToPos.get(gov.index()) + gov.toPrimes() + ", " + dep.value() + "-" + indexToPos.get(dep.index()) + dep.toPrimes() + ")";
    }

    private static String[] parseClassConstructArgs(String namePlusArgs) {
        String[] args = StringUtils.EMPTY_STRING_ARRAY;
        String name = namePlusArgs;
        if (namePlusArgs.matches(".*\\([^)]*\\)$")) {
            String argStr = namePlusArgs.replaceFirst("^.*\\(([^)]*)\\)$", "$1");
            args = argStr.split(",");
            name = namePlusArgs.replaceFirst("\\([^)]*\\)$", "");
        }
        String[] tokens = new String[1 + args.length];
        tokens[0] = name;
        System.arraycopy(args, 0, tokens, 1, args.length);
        return tokens;
    }

    private static DependencyReader loadAlternateDependencyReader(String altDepReaderName) {
        DependencyReader altDepReader;
        Class<?> cl2;
        Class<DependencyReader> altDepReaderClass = null;
        String[] toks = GrammaticalStructureConversionUtils.parseClassConstructArgs(altDepReaderName);
        altDepReaderName = toks[0];
        String[] depReaderArgs = new String[toks.length - 1];
        System.arraycopy(toks, 1, depReaderArgs, 0, toks.length - 1);
        try {
            cl2 = Class.forName(altDepReaderName);
            altDepReaderClass = cl2.asSubclass(DependencyReader.class);
        }
        catch (ClassNotFoundException cl2) {
            // empty catch block
        }
        if (altDepReaderClass == null) {
            try {
                cl2 = Class.forName("edu.stanford.nlp.trees." + altDepReaderName);
                altDepReaderClass = cl2.asSubclass(DependencyReader.class);
            }
            catch (ClassNotFoundException cl3) {
                // empty catch block
            }
        }
        if (altDepReaderClass == null) {
            log.info("Can't load dependency reader " + altDepReaderName + " or edu.stanford.nlp.trees." + altDepReaderName);
            return null;
        }
        if (depReaderArgs.length == 0) {
            try {
                altDepReader = altDepReaderClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                log.info("No argument constructor to " + altDepReaderName + " is not public");
                return null;
            }
        }
        try {
            altDepReader = altDepReaderClass.getConstructor(String[].class).newInstance(new Object[]{depReaderArgs});
        }
        catch (IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            log.info(depReaderArgs.length + " argument constructor to " + altDepReaderName + " is not public.");
            return null;
        }
        catch (NoSuchMethodException e) {
            log.info("String arguments constructor to " + altDepReaderName + " does not exist.");
            return null;
        }
        return altDepReader;
    }

    private static DependencyPrinter loadAlternateDependencyPrinter(String altDepPrinterName) {
        Class<?> cl2;
        Class<DependencyPrinter> altDepPrinterClass = null;
        String[] toks = GrammaticalStructureConversionUtils.parseClassConstructArgs(altDepPrinterName);
        altDepPrinterName = toks[0];
        Object[] depPrintArgs = new String[toks.length - 1];
        System.arraycopy(toks, 1, depPrintArgs, 0, toks.length - 1);
        try {
            cl2 = Class.forName(altDepPrinterName);
            altDepPrinterClass = cl2.asSubclass(DependencyPrinter.class);
        }
        catch (ClassNotFoundException cl2) {
            // empty catch block
        }
        if (altDepPrinterClass == null) {
            try {
                cl2 = Class.forName("edu.stanford.nlp.trees." + altDepPrinterName);
                altDepPrinterClass = cl2.asSubclass(DependencyPrinter.class);
            }
            catch (ClassNotFoundException cl3) {
                // empty catch block
            }
        }
        if (altDepPrinterClass == null) {
            System.err.printf("Unable to load alternative printer %s or %s. Is your classpath set correctly?\n", altDepPrinterName, "edu.stanford.nlp.trees." + altDepPrinterName);
            return null;
        }
        try {
            DependencyPrinter depPrinter = depPrintArgs.length == 0 ? altDepPrinterClass.newInstance() : altDepPrinterClass.getConstructor(String[].class).newInstance(new Object[]{depPrintArgs});
            return depPrinter;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            if (depPrintArgs.length == 0) {
                System.err.printf("Can't find no-argument constructor %s().%n", altDepPrinterName);
            } else {
                System.err.printf("Can't find constructor %s(%s).%n", altDepPrinterName, Arrays.toString(depPrintArgs));
            }
            return null;
        }
    }

    private static Function<List<? extends HasWord>, Tree> loadParser(String parserFile, String parserOptions, boolean makeCopulaHead) {
        Function lp;
        if (parserFile == null || parserFile.isEmpty()) {
            parserFile = DEFAULT_PARSER_FILE;
            if (parserOptions == null) {
                parserOptions = "-retainTmpSubcategories";
            }
        }
        if (parserOptions == null) {
            parserOptions = "";
        }
        if (makeCopulaHead) {
            parserOptions = "-makeCopulaHead " + parserOptions;
        }
        parserOptions = parserOptions.trim();
        try {
            Class[] classes = new Class[]{String.class, String[].class};
            Method method = Class.forName("edu.stanford.nlp.parser.lexparser.LexicalizedParser").getMethod("loadModel", classes);
            String[] opts = StringUtils.EMPTY_STRING_ARRAY;
            if (!parserOptions.isEmpty()) {
                opts = parserOptions.split(" +");
            }
            lp = (Function)method.invoke(null, parserFile, opts);
        }
        catch (Exception cnfe) {
            throw new RuntimeException(cnfe);
        }
        return lp;
    }

    public static void convertTrees(String[] args, String defaultLang) {
        MemoryTreebank tb;
        Iterable<GrammaticalStructure> gsBank = null;
        Properties props = StringUtils.argsToProperties(args);
        String language = props.getProperty("language", defaultLang);
        ConverterOptions opts = ConverterOptions.getConverterOptions(language);
        Iterable<Tree> trees = tb = new MemoryTreebank(opts.treeNormalizer);
        String encoding = props.getProperty("encoding", "utf-8");
        try {
            System.setOut(new PrintStream((OutputStream)System.out, true, encoding));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String treeFileName = props.getProperty("treeFile");
        String sentFileName = props.getProperty("sentFile");
        String conllXFileName = props.getProperty("conllxFile");
        String altDepPrinterName = props.getProperty("altprinter");
        String altDepReaderName = props.getProperty("altreader");
        String altDepReaderFilename = props.getProperty("altreaderfile");
        String filter = props.getProperty("filter");
        boolean makeCopulaHead = props.getProperty("makeCopulaHead") != null;
        boolean generateOriginalDependencies = props.getProperty("originalDependencies") != null || opts.stanfordDependencies;
        String tLPP = props.getProperty("tLPP", opts.tlPPClassName);
        TreebankLangParserParams params = (TreebankLangParserParams)ReflectionLoading.loadByReflection(tLPP, new Object[0]);
        params.setGenerateOriginalDependencies(generateOriginalDependencies);
        if (makeCopulaHead) {
            String[] options = new String[]{"-makeCopulaHead"};
            params.setOptionFlag(options, 0);
        }
        if (sentFileName == null && (altDepReaderName == null || altDepReaderFilename == null) && treeFileName == null && conllXFileName == null && filter == null) {
            try {
                System.err.printf("Usage: java %s%n", GrammaticalStructure.class.getCanonicalName());
                System.err.println("Options:");
                System.err.println("  Dependency representation:");
                System.err.println("    -basic:\t\tGenerate basic dependencies.");
                System.err.println("    -enhanced:\t\tGenerate enhanced dependencies, currently only implemented for English UD.");
                System.err.println("    -enhanced++:\tGenerate enhanced++ dependencies (default), currently only implemented for English UD.");
                System.err.println("    -collapsed:\t\tGenerate collapsed dependencies, deprecated.");
                System.err.println("    -CCprocessed:\tGenerate CC-processed dependencies, deprecated.");
                System.err.println("    -collapsedTree:\tGenerate collapsed-tree dependencies, deprecated.");
                System.err.println("");
                System.err.println("  Input:");
                System.err.println("    -treeFile <FILE>:\tConvert from constituency trees in <FILE>");
                System.err.println("    -sentFile <FILE>:\tParse and convert sentences from <FILE>. Only implemented for English.");
                System.err.println("");
                System.err.println("  Output:");
                System.err.println("    -conllx:\t\tOutput dependencies in CoNLL format.");
                System.err.println("");
                System.err.println("  Language:");
                System.err.println("    -language [en|zh|en-sd|zh-sd]:\t (Universal English Dependencies, Universal Chinese Dependencies, English Stanford Dependencies, Chinese Stanford Dependencies)");
                System.err.println("");
                System.err.println("");
                System.err.println("");
                System.err.println("Example:");
                PennTreeReader tr = new PennTreeReader(new StringReader("((S (NP (NNP Sam)) (VP (VBD died) (NP-TMP (NN today)))))"));
                tb.add(tr.readTree());
            }
            catch (Exception e) {
                log.info("Horrible error: " + e);
                e.printStackTrace();
            }
        } else {
            if (altDepReaderName != null && altDepReaderFilename != null) {
                DependencyReader altDepReader = GrammaticalStructureConversionUtils.loadAlternateDependencyReader(altDepReaderName);
                try {
                    gsBank = altDepReader.readDependencies(altDepReaderFilename);
                }
                catch (IOException e) {
                    log.info("Error reading " + altDepReaderFilename);
                    return;
                }
            }
            if (treeFileName != null) {
                tb.loadPath(treeFileName);
            } else if (filter != null) {
                tb.load(IOUtils.readerFromStdin());
            } else {
                if (conllXFileName != null) {
                    try {
                        gsBank = params.readGrammaticalStructureFromFile(conllXFileName);
                    }
                    catch (RuntimeIOException e) {
                        log.info("Error reading " + conllXFileName);
                        return;
                    }
                }
                String parserFile = props.getProperty("parserFile");
                String parserOpts = props.getProperty("parserOpts");
                boolean tokenized = props.getProperty("tokenized") != null;
                Function<List<? extends HasWord>, Tree> lp = GrammaticalStructureConversionUtils.loadParser(parserFile, parserOpts, makeCopulaHead);
                trees = new LazyLoadTreesByParsing(sentFileName, encoding, tokenized, lp);
                try {
                    Method method = lp.getClass().getMethod("getTLPParams", new Class[0]);
                    params = (TreebankLangParserParams)method.invoke(lp, new Object[0]);
                    params.setGenerateOriginalDependencies(generateOriginalDependencies);
                }
                catch (Exception cnfe) {
                    throw new RuntimeException(cnfe);
                }
            }
        }
        boolean basic = props.getProperty("basic") != null;
        boolean collapsed = props.getProperty("collapsed") != null;
        boolean CCprocessed = props.getProperty("CCprocessed") != null;
        boolean collapsedTree = props.getProperty("collapsedTree") != null;
        boolean nonCollapsed = props.getProperty("nonCollapsed") != null;
        boolean extraSep = props.getProperty("extraSep") != null;
        boolean parseTree = props.getProperty("parseTree") != null;
        boolean test = props.getProperty("test") != null;
        boolean keepPunct = true;
        boolean conllx = props.getProperty("conllx") != null;
        boolean checkConnected = props.getProperty("checkConnected") != null;
        boolean portray = props.getProperty("portray") != null;
        boolean enhanced = props.getProperty("enhanced") != null;
        boolean enhancedPlusPlus = props.getProperty("enhanced++") != null;
        DependencyPrinter altDepPrinter = null;
        if (altDepPrinterName != null) {
            altDepPrinter = GrammaticalStructureConversionUtils.loadAlternateDependencyPrinter(altDepPrinterName);
        }
        Method m = null;
        if (test) {
            try {
                Class<?> sgf = Class.forName("edu.stanford.nlp.semgraph.SemanticGraphFactory");
                m = sgf.getDeclaredMethod("makeFromTree", GrammaticalStructure.class, SemanticGraphFactory.Mode.class, GrammaticalStructure.Extras.class, Predicate.class);
            }
            catch (Exception e) {
                log.info("Test cannot check for cycles in tree format (classes not available)");
            }
        }
        if (gsBank == null) {
            gsBank = new TreeBankGrammaticalStructureWrapper(trees, keepPunct, params);
        }
        for (GrammaticalStructure gs : gsBank) {
            Tree tree = gsBank instanceof TreeBankGrammaticalStructureWrapper ? ((TreeBankGrammaticalStructureWrapper)gsBank).getOriginalTree(gs) : gs.root();
            if (test) {
                System.out.println("============= parse tree =======================");
                tree.pennPrint();
                System.out.println();
                System.out.println("------------- GrammaticalStructure -------------");
                System.out.println(gs);
                boolean allConnected = true;
                Collection<TypedDependency> bungRoots = null;
                System.out.println("------------- basic dependencies ---------------");
                List<TypedDependency> gsb = gs.typedDependencies(GrammaticalStructure.Extras.NONE);
                System.out.println(StringUtils.join(gsb, "\n"));
                boolean connected = GrammaticalStructure.isConnected(gsb);
                if (!connected && bungRoots == null) {
                    bungRoots = GrammaticalStructure.getRoots(gsb);
                }
                allConnected = connected && allConnected;
                System.out.println("------------- non-collapsed dependencies (basic + extra) ---------------");
                List<TypedDependency> gse = gs.typedDependencies(GrammaticalStructure.Extras.MAXIMAL);
                System.out.println(StringUtils.join(gse, "\n"));
                connected = GrammaticalStructure.isConnected(gse);
                if (!connected && bungRoots == null) {
                    bungRoots = GrammaticalStructure.getRoots(gse);
                }
                allConnected = connected && allConnected;
                System.out.println("------------- collapsed dependencies -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsed(GrammaticalStructure.Extras.MAXIMAL), "\n"));
                System.out.println("------------- collapsed dependencies tree -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsedTree(), "\n"));
                System.out.println("------------- CCprocessed dependencies --------");
                List<TypedDependency> gscc = gs.typedDependenciesCollapsed(GrammaticalStructure.Extras.MAXIMAL);
                System.out.println(StringUtils.join(gscc, "\n"));
                System.out.println("-----------------------------------------------");
                connected = GrammaticalStructure.isConnected(gscc);
                if (!connected && bungRoots == null) {
                    bungRoots = GrammaticalStructure.getRoots(gscc);
                }
                boolean bl = allConnected = connected && allConnected;
                if (allConnected) {
                    System.out.println("dependencies form connected graphs.");
                } else {
                    System.out.println("dependency graph NOT connected! possible offending nodes: " + bungRoots);
                }
                if (m != null) {
                    try {
                        Object semGraph = m.invoke(null, new Object[]{gs, SemanticGraphFactory.Mode.CCPROCESSED, GrammaticalStructure.Extras.MAXIMAL, null});
                        Class<?> sg = Class.forName("edu.stanford.nlp.semgraph.SemanticGraph");
                        Method mDag = sg.getDeclaredMethod("isDag", new Class[0]);
                        boolean isDag = (Boolean)mDag.invoke(semGraph, new Object[0]);
                        System.out.println("tree dependencies form a DAG: " + isDag);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                if (parseTree) {
                    System.out.println("============= parse tree =======================");
                    tree.pennPrint();
                    System.out.println();
                }
                if (basic) {
                    if (collapsed || CCprocessed || collapsedTree || nonCollapsed || enhanced || enhancedPlusPlus) {
                        System.out.println("------------- basic dependencies ---------------");
                    }
                    if (altDepPrinter == null) {
                        GrammaticalStructureConversionUtils.printDependencies(gs, gs.typedDependencies(GrammaticalStructure.Extras.NONE), tree, conllx, false, opts.convertToUPOS);
                    } else {
                        System.out.println(altDepPrinter.dependenciesToString(gs, gs.typedDependencies(GrammaticalStructure.Extras.NONE), tree));
                    }
                }
                if (nonCollapsed) {
                    if (basic || CCprocessed || collapsed || collapsedTree) {
                        System.out.println("----------- non-collapsed dependencies (basic + extra) -----------");
                    }
                    GrammaticalStructureConversionUtils.printDependencies(gs, gs.allTypedDependencies(), tree, conllx, extraSep, opts.convertToUPOS);
                }
                if (collapsed) {
                    if (basic || CCprocessed || collapsedTree || nonCollapsed) {
                        System.out.println("----------- collapsed dependencies -----------");
                    }
                    GrammaticalStructureConversionUtils.printDependencies(gs, gs.typedDependenciesCollapsed(GrammaticalStructure.Extras.MAXIMAL), tree, conllx, false, opts.convertToUPOS);
                }
                if (CCprocessed) {
                    if (basic || collapsed || collapsedTree || nonCollapsed) {
                        System.out.println("---------- CCprocessed dependencies ----------");
                    }
                    List<TypedDependency> deps = gs.typedDependenciesCCprocessed(GrammaticalStructure.Extras.MAXIMAL);
                    if (checkConnected && !GrammaticalStructure.isConnected(deps)) {
                        log.info("Graph is not connected for:");
                        log.info(tree);
                        log.info("possible offending nodes: " + GrammaticalStructure.getRoots(deps));
                    }
                    GrammaticalStructureConversionUtils.printDependencies(gs, deps, tree, conllx, false, opts.convertToUPOS);
                }
                if (collapsedTree) {
                    if (basic || CCprocessed || collapsed || nonCollapsed) {
                        System.out.println("----------- collapsed dependencies tree -----------");
                    }
                    GrammaticalStructureConversionUtils.printDependencies(gs, gs.typedDependenciesCollapsedTree(), tree, conllx, false, opts.convertToUPOS);
                }
                if (enhanced) {
                    if (basic || enhancedPlusPlus) {
                        System.out.println("----------- enhanced dependencies tree -----------");
                    }
                    GrammaticalStructureConversionUtils.printDependencies(gs, gs.typedDependenciesEnhanced(), tree, conllx, false, opts.convertToUPOS);
                }
                if (enhancedPlusPlus) {
                    if (basic || enhanced) {
                        System.out.println("----------- enhanced++ dependencies tree -----------");
                    }
                    GrammaticalStructureConversionUtils.printDependencies(gs, gs.typedDependenciesEnhancedPlusPlus(), tree, conllx, false, opts.convertToUPOS);
                }
                if (!(basic || collapsed || CCprocessed || collapsedTree || nonCollapsed || enhanced || enhancedPlusPlus)) {
                    if (generateOriginalDependencies) {
                        GrammaticalStructureConversionUtils.printDependencies(gs, gs.typedDependenciesCCprocessed(GrammaticalStructure.Extras.MAXIMAL), tree, conllx, false, opts.convertToUPOS);
                    } else {
                        GrammaticalStructureConversionUtils.printDependencies(gs, gs.typedDependenciesEnhancedPlusPlus(), tree, conllx, false, opts.convertToUPOS);
                    }
                }
            }
            if (!portray) continue;
            try {
                Class<?> sgu = Class.forName("edu.stanford.nlp.rte.gui.SemanticGraphVisualization");
                Method mRender = sgu.getDeclaredMethod("render", GrammaticalStructure.class, String.class);
                mRender.invoke(null, gs, "Collapsed, CC processed deps");
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't use swing to portray semantic graph", e);
            }
        }
    }

    static class LazyLoadTreesByParsing
    implements Iterable<Tree> {
        final Reader reader;
        final String filename;
        final boolean tokenized;
        final String encoding;
        final Function<List<? extends HasWord>, Tree> lp;

        public LazyLoadTreesByParsing(String filename, String encoding, boolean tokenized, Function<List<? extends HasWord>, Tree> lp) {
            this.filename = filename;
            this.encoding = encoding;
            this.reader = null;
            this.tokenized = tokenized;
            this.lp = lp;
        }

        @Override
        public Iterator<Tree> iterator() {
            BufferedReader iReader;
            if (this.reader != null) {
                iReader = new BufferedReader(this.reader);
            } else {
                try {
                    iReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), this.encoding));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new Iterator<Tree>(){
                String line;

                @Override
                public boolean hasNext() {
                    if (this.line != null) {
                        return true;
                    }
                    try {
                        this.line = iReader.readLine();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (this.line == null) {
                        try {
                            if (reader == null) {
                                iReader.close();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return false;
                    }
                    return true;
                }

                @Override
                public Tree next() {
                    if (this.line == null) {
                        throw new NoSuchElementException();
                    }
                    StringReader lineReader = new StringReader(this.line);
                    this.line = null;
                    List words = tokenized ? WhitespaceTokenizer.newWordWhitespaceTokenizer(lineReader).tokenize() : PTBTokenizer.newPTBTokenizer(lineReader).tokenize();
                    if (!words.isEmpty()) {
                        Tree parseTree = lp.apply(words);
                        return parseTree;
                    }
                    return new SimpleTree();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static enum ConverterOptions {
        UniversalEnglish("en", new NPTmpRetainingTreeNormalizer(0, false, 1, false), "edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams", false, true),
        UniversalChinese("zh", new CTBErrorCorrectingTreeNormalizer(false, false, false, false), "edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams", false, false),
        English("en-sd", new NPTmpRetainingTreeNormalizer(0, false, 1, false), "edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams", true, true),
        Chinese("zh-sd", new CTBErrorCorrectingTreeNormalizer(false, false, false, false), "edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams", true, false);

        public final String abbreviation;
        public final TreeNormalizer treeNormalizer;
        public final String tlPPClassName;
        public final boolean stanfordDependencies;
        public final boolean convertToUPOS;
        private static final Map<String, ConverterOptions> nameToTokenizerMap;

        private ConverterOptions(String abbreviation, TreeNormalizer treeNormalizer, String tlPPClassName, boolean stanfordDependencies, boolean convertToUPOS) {
            this.abbreviation = abbreviation;
            this.treeNormalizer = treeNormalizer;
            this.tlPPClassName = tlPPClassName;
            this.stanfordDependencies = stanfordDependencies;
            this.convertToUPOS = convertToUPOS;
        }

        private static Map<String, ConverterOptions> initializeNameMap() {
            Map<String, ConverterOptions> map = Generics.newHashMap();
            for (ConverterOptions opts : ConverterOptions.values()) {
                if (opts.abbreviation != null) {
                    map.put(opts.abbreviation.toUpperCase(), opts);
                }
                map.put(opts.toString().toUpperCase(), opts);
            }
            return Collections.unmodifiableMap(map);
        }

        public static ConverterOptions getConverterOptions(String language) {
            if (language == null) {
                return nameToTokenizerMap.get("EN");
            }
            ConverterOptions opts = nameToTokenizerMap.get(language.toUpperCase());
            return opts != null ? opts : nameToTokenizerMap.get("EN");
        }

        static {
            nameToTokenizerMap = ConverterOptions.initializeNameMap();
        }
    }

    private static class TreeBankGrammaticalStructureWrapper
    implements Iterable<GrammaticalStructure> {
        private final Iterable<Tree> trees;
        private final boolean keepPunct;
        private final TreebankLangParserParams params;
        private final Map<GrammaticalStructure, Tree> origTrees = new WeakHashMap<GrammaticalStructure, Tree>();

        public TreeBankGrammaticalStructureWrapper(Iterable<Tree> wrappedTrees, boolean keepPunct, TreebankLangParserParams params) {
            this.trees = wrappedTrees;
            this.keepPunct = keepPunct;
            this.params = params;
        }

        @Override
        public Iterator<GrammaticalStructure> iterator() {
            return new GsIterator();
        }

        public Tree getOriginalTree(GrammaticalStructure gs) {
            return this.origTrees.get(gs);
        }

        private class GsIterator
        implements Iterator<GrammaticalStructure> {
            private final Iterator<Tree> tbIterator;
            private final Predicate<String> puncFilter;
            private final HeadFinder hf;
            private GrammaticalStructure next;

            public GsIterator() {
                this.tbIterator = TreeBankGrammaticalStructureWrapper.this.trees.iterator();
                this.puncFilter = TreeBankGrammaticalStructureWrapper.this.keepPunct ? Filters.acceptFilter() : (TreeBankGrammaticalStructureWrapper.this.params.generateOriginalDependencies() ? TreeBankGrammaticalStructureWrapper.this.params.treebankLanguagePack().punctuationWordRejectFilter() : TreeBankGrammaticalStructureWrapper.this.params.treebankLanguagePack().punctuationTagRejectFilter());
                this.hf = TreeBankGrammaticalStructureWrapper.this.params.typedDependencyHeadFinder();
                this.primeGs();
            }

            private void primeGs() {
                GrammaticalStructure gs = null;
                while (gs == null && this.tbIterator.hasNext()) {
                    Tree t = this.tbIterator.next();
                    if (t == null) continue;
                    try {
                        gs = TreeBankGrammaticalStructureWrapper.this.params.getGrammaticalStructure(t, this.puncFilter, this.hf);
                        TreeBankGrammaticalStructureWrapper.this.origTrees.put(gs, t);
                        this.next = gs;
                        return;
                    }
                    catch (NullPointerException npe) {
                        log.info("Bung tree caused below dump. Continuing....");
                        log.info(t);
                        npe.printStackTrace();
                    }
                }
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public GrammaticalStructure next() {
                GrammaticalStructure ret = this.next;
                if (ret == null) {
                    throw new NoSuchElementException();
                }
                this.primeGs();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

