/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.MutableInteger;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TwoDimensionalIntCounter<K1, K2>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<K1, IntCounter<K2>> map;
    private int total;
    private MapFactory<K1, IntCounter<K2>> outerMF;
    private MapFactory<K2, MutableInteger> innerMF;
    private int defaultValue = 0;

    public void defaultReturnValue(double rv) {
        this.defaultValue = (int)rv;
    }

    public void defaultReturnValue(int rv) {
        this.defaultValue = rv;
    }

    public int defaultReturnValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TwoDimensionalIntCounter)) {
            return false;
        }
        return ((TwoDimensionalIntCounter)o).map.equals(this.map);
    }

    public int hashCode() {
        return this.map.hashCode() + 17;
    }

    public IntCounter<K2> getCounter(K1 o) {
        IntCounter<K2> c = this.map.get(o);
        if (c == null) {
            c = new IntCounter<K2>(this.innerMF);
            c.setDefaultReturnValue(this.defaultValue);
            this.map.put(o, c);
        }
        return c;
    }

    public Set<Map.Entry<K1, IntCounter<K2>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        int result = 0;
        for (K1 o : this.firstKeySet()) {
            IntCounter<K2> c = this.map.get(o);
            result += c.size();
        }
        return result;
    }

    public boolean containsKey(K1 o1, K2 o2) {
        if (!this.map.containsKey(o1)) {
            return false;
        }
        IntCounter<K2> c = this.map.get(o1);
        return c.containsKey(o2);
    }

    public void incrementCount(K1 o1, K2 o2) {
        this.incrementCount(o1, o2, 1);
    }

    public void incrementCount(K1 o1, K2 o2, double count) {
        this.incrementCount(o1, o2, (int)count);
    }

    public void incrementCount(K1 o1, K2 o2, int count) {
        IntCounter<K2> c = this.getCounter(o1);
        c.incrementCount(o2, count);
        this.total += count;
    }

    public void decrementCount(K1 o1, K2 o2) {
        this.incrementCount(o1, o2, -1);
    }

    public void decrementCount(K1 o1, K2 o2, double count) {
        this.incrementCount(o1, o2, -count);
    }

    public void decrementCount(K1 o1, K2 o2, int count) {
        this.incrementCount(o1, o2, -count);
    }

    public void setCount(K1 o1, K2 o2, double count) {
        this.setCount(o1, o2, (int)count);
    }

    public void setCount(K1 o1, K2 o2, int count) {
        IntCounter<K2> c = this.getCounter(o1);
        int oldCount = this.getCount(o1, o2);
        this.total -= oldCount;
        c.setCount(o2, count);
        this.total += count;
    }

    public int remove(K1 o1, K2 o2) {
        IntCounter<K2> c = this.getCounter(o1);
        int oldCount = this.getCount(o1, o2);
        this.total -= oldCount;
        c.remove(o2);
        if (c.isEmpty()) {
            this.map.remove(o1);
        }
        return oldCount;
    }

    public int getCount(K1 o1, K2 o2) {
        IntCounter<K2> c = this.getCounter(o1);
        if (c.totalCount() == 0.0 && !c.keySet().contains(o2)) {
            return this.defaultReturnValue();
        }
        return c.getIntCount(o2);
    }

    public int totalCount() {
        return this.total;
    }

    public int totalCount(K1 k1) {
        IntCounter<K2> c = this.getCounter(k1);
        return c.totalIntCount();
    }

    public IntCounter<K1> totalCounts() {
        IntCounter<K1> tc = new IntCounter<K1>();
        for (K1 k1 : this.map.keySet()) {
            tc.setCount(k1, this.map.get(k1).totalCount());
        }
        return tc;
    }

    public Set<K1> firstKeySet() {
        return this.map.keySet();
    }

    public IntCounter<K2> setCounter(K1 o, IntCounter<K2> c) {
        IntCounter<K2> old = this.getCounter(o);
        this.total -= old.totalIntCount();
        this.map.put(o, c);
        this.total += c.totalIntCount();
        return old;
    }

    public static <K1, K2> TwoDimensionalIntCounter<K2, K1> reverseIndexOrder(TwoDimensionalIntCounter<K1, K2> cc) {
        TwoDimensionalIntCounter<K2, K1> result = new TwoDimensionalIntCounter<K2, K1>(cc.outerMF, cc.innerMF);
        for (K1 key1 : cc.firstKeySet()) {
            IntCounter<K2> c = cc.getCounter(key1);
            for (K2 key2 : c.keySet()) {
                int count = c.getIntCount(key2);
                result.setCount(key2, key1, count);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        for (K1 key1 : this.map.keySet()) {
            IntCounter<K2> c = this.getCounter(key1);
            for (K2 key2 : c.keySet()) {
                double score = c.getCount(key2);
                buff.append(key1).append("\t").append(key2).append("\t").append(score).append("\n");
            }
        }
        return buff.toString();
    }

    public String toMatrixString(int cellSize) {
        ArrayList<K1> firstKeys = new ArrayList<K1>(this.firstKeySet());
        ArrayList<K2> secondKeys = new ArrayList<K2>(this.secondKeySet());
        Collections.sort(firstKeys);
        Collections.sort(secondKeys);
        int[][] counts = this.toMatrix(firstKeys, secondKeys);
        return ArrayMath.toString(counts, firstKeys.toArray(), secondKeys.toArray(), cellSize, cellSize, new DecimalFormat(), true);
    }

    public int[][] toMatrix(List<K1> firstKeys, List<K2> secondKeys) {
        int[][] counts = new int[firstKeys.size()][secondKeys.size()];
        for (int i = 0; i < firstKeys.size(); ++i) {
            for (int j = 0; j < secondKeys.size(); ++j) {
                counts[i][j] = this.getCount(firstKeys.get(i), secondKeys.get(j));
            }
        }
        return counts;
    }

    public String toCSVString(NumberFormat nf) {
        ArrayList<K1> firstKeys = new ArrayList<K1>(this.firstKeySet());
        ArrayList<K2> secondKeys = new ArrayList<K2>(this.secondKeySet());
        Collections.sort(firstKeys);
        Collections.sort(secondKeys);
        StringBuilder b = new StringBuilder();
        String[] headerRow = new String[secondKeys.size() + 1];
        headerRow[0] = "";
        for (int j = 0; j < secondKeys.size(); ++j) {
            headerRow[j + 1] = secondKeys.get(j).toString();
        }
        b.append(StringUtils.toCSVString(headerRow)).append("\n");
        for (Object rowLabel : firstKeys) {
            String[] row = new String[secondKeys.size() + 1];
            row[0] = rowLabel.toString();
            for (int j = 0; j < secondKeys.size(); ++j) {
                Object colLabel = secondKeys.get(j);
                row[j + 1] = nf.format(this.getCount(rowLabel, colLabel));
            }
            b.append(StringUtils.toCSVString(row)).append("\n");
        }
        return b.toString();
    }

    public static <CK1 extends Comparable<CK1>, CK2 extends Comparable<CK2>> String toCSVString(TwoDimensionalIntCounter<CK1, CK2> counter, NumberFormat nf, Comparator<CK1> key1Comparator, Comparator<CK2> key2Comparator) {
        ArrayList<CK1> firstKeys = new ArrayList<CK1>(counter.firstKeySet());
        ArrayList<CK2> secondKeys = new ArrayList<CK2>(counter.secondKeySet());
        Collections.sort(firstKeys, key1Comparator);
        Collections.sort(secondKeys, key2Comparator);
        StringBuilder b = new StringBuilder();
        int secondKeysSize = secondKeys.size();
        String[] headerRow = new String[secondKeysSize + 1];
        headerRow[0] = "";
        for (int j = 0; j < secondKeysSize; ++j) {
            headerRow[j + 1] = ((Comparable)secondKeys.get(j)).toString();
        }
        b.append(StringUtils.toCSVString(headerRow)).append('\n');
        for (Comparable rowLabel : firstKeys) {
            String[] row = new String[secondKeysSize + 1];
            row[0] = rowLabel.toString();
            for (int j = 0; j < secondKeysSize; ++j) {
                Comparable colLabel = (Comparable)secondKeys.get(j);
                row[j + 1] = nf.format(counter.getCount(rowLabel, colLabel));
            }
            b.append(StringUtils.toCSVString(row)).append('\n');
        }
        return b.toString();
    }

    public Set<K2> secondKeySet() {
        Set<K2> result = Generics.newHashSet();
        for (K1 k1 : this.firstKeySet()) {
            for (K2 k2 : this.getCounter(k1).keySet()) {
                result.add(k2);
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public IntCounter<Pair<K1, K2>> flatten() {
        IntCounter<Pair<K1, K2>> result = new IntCounter<Pair<K1, K2>>();
        result.setDefaultReturnValue(this.defaultValue);
        for (K1 key1 : this.firstKeySet()) {
            IntCounter<K2> inner = this.getCounter(key1);
            for (K2 key2 : inner.keySet()) {
                result.setCount(new Pair<K1, K2>(key1, key2), inner.getIntCount(key2));
            }
        }
        return result;
    }

    public void addAll(TwoDimensionalIntCounter<K1, K2> c) {
        for (K1 key : c.firstKeySet()) {
            IntCounter<K2> inner = c.getCounter(key);
            IntCounter<K2> myInner = this.getCounter(key);
            Counters.addInPlace(myInner, inner);
            this.total += inner.totalIntCount();
        }
    }

    public void addAll(K1 key, IntCounter<K2> c) {
        IntCounter<K2> myInner = this.getCounter(key);
        Counters.addInPlace(myInner, c);
        this.total += c.totalIntCount();
    }

    public void subtractAll(K1 key, IntCounter<K2> c) {
        IntCounter<K2> myInner = this.getCounter(key);
        Counters.subtractInPlace(myInner, c);
        this.total -= c.totalIntCount();
    }

    public void subtractAll(TwoDimensionalIntCounter<K1, K2> c, boolean removeKeys) {
        for (K1 key : c.firstKeySet()) {
            IntCounter<K2> inner = c.getCounter(key);
            IntCounter<K2> myInner = this.getCounter(key);
            Counters.subtractInPlace(myInner, inner);
            if (removeKeys) {
                Counters.retainNonZeros(myInner);
            }
            this.total -= inner.totalIntCount();
        }
    }

    public void removeZeroCounts() {
        Set<K1> firstKeySet = Generics.newHashSet(this.firstKeySet());
        for (K1 k1 : firstKeySet) {
            IntCounter<K2> c = this.getCounter(k1);
            Counters.retainNonZeros(c);
            if (!c.isEmpty()) continue;
            this.map.remove(k1);
        }
    }

    public void remove(K1 key) {
        IntCounter<K2> counter = this.map.get(key);
        if (counter != null) {
            this.total -= counter.totalIntCount();
        }
        this.map.remove(key);
    }

    public void clean() {
        for (K1 key1 : Generics.newHashSet(this.map.keySet())) {
            IntCounter<K2> c = this.map.get(key1);
            for (K2 key2 : Generics.newHashSet(c.keySet())) {
                if (c.getIntCount(key2) != 0) continue;
                c.remove(key2);
            }
            if (!c.keySet().isEmpty()) continue;
            this.map.remove(key1);
        }
    }

    public MapFactory<K1, IntCounter<K2>> getOuterMapFactory() {
        return this.outerMF;
    }

    public MapFactory<K2, MutableInteger> getInnerMapFactory() {
        return this.innerMF;
    }

    public TwoDimensionalIntCounter() {
        this(MapFactory.hashMapFactory(), MapFactory.hashMapFactory());
    }

    public TwoDimensionalIntCounter(int initialCapacity) {
        this(MapFactory.hashMapFactory(), MapFactory.hashMapFactory(), initialCapacity);
    }

    public TwoDimensionalIntCounter(MapFactory<K1, IntCounter<K2>> outerFactory, MapFactory<K2, MutableInteger> innerFactory) {
        this(outerFactory, innerFactory, 100);
    }

    public TwoDimensionalIntCounter(MapFactory<K1, IntCounter<K2>> outerFactory, MapFactory<K2, MutableInteger> innerFactory, int initialCapacity) {
        this.innerMF = innerFactory;
        this.outerMF = outerFactory;
        this.map = outerFactory.newMap(initialCapacity);
        this.total = 0;
    }
}

