/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.spanish;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SpanishVerbStripper
implements Serializable {
    private static final Redwood.RedwoodChannels log = Redwood.channels(SpanishVerbStripper.class);
    private static final Map<String, SpanishVerbStripper> instances = new HashMap<String, SpanishVerbStripper>();
    private final HashMap<String, String> dict;
    private static final String DEFAULT_DICT = "edu/stanford/nlp/international/spanish/enclitic-inflections.data";
    private static final String PATTERN_ATTACHED_PRONOUNS = "(?:(?:[mts]e|n?os|les?)(?:l[oa]s?)?|l[oa]s?)$";
    private static final Pattern pTwoAttachedPronouns = Pattern.compile("([mts]e|n?os|les?)(l[eoa]s?)$");
    private static final Pattern pOneAttachedPronoun = Pattern.compile("([mts]e|n?os|les?|l[oa]s?)$");
    private static final Pattern pStrippable = Pattern.compile("(?:[aei\u00e1\u00e9\u00ed]r|[\u00e1\u00e9]ndo|[ae\u00e1\u00e9]n?|[ae\u00e1\u00e9]mos?|[aei\u00e1\u00e9\u00ed](?:d(?!os)|(?=os)))(?:(?:[mts]e|n?os|les?)(?:l[oa]s?)?|l[oa]s?)$");
    private static final Pattern pIrregulars = Pattern.compile("^(?:d[i\u00ed]|h[a\u00e1]z|v[e\u00e9]|p[o\u00f3]n|s[a\u00e1]l|s\u00e9|t[e\u00e9]n|v[e\u00e9]n|(?:id(?=os$)))(?:(?:[mts]e|n?os|les?)(?:l[oa]s?)?|l[oa]s?)$");
    private static final Pair<Pattern, String>[] accentFixes = new Pair[]{new Pair<Pattern, String>(Pattern.compile("\u00e1"), "a"), new Pair<Pattern, String>(Pattern.compile("\u00e9"), "e"), new Pair<Pattern, String>(Pattern.compile("\u00ed"), "i"), new Pair<Pattern, String>(Pattern.compile("\u00f3"), "o"), new Pair<Pattern, String>(Pattern.compile("\u00fa"), "u")};
    private static final Set<String> accentedInfinitives = new HashSet<String>(Arrays.asList("desle\u00edr", "deso\u00edr", "emba\u00edr", "engre\u00edr", "entreo\u00edr", "fre\u00edr", "o\u00edr", "refre\u00edr", "re\u00edr", "sofre\u00edr", "sonre\u00edr"));
    private static final Pattern nosse = Pattern.compile("nos|se");
    private static final long serialVersionUID = -4780144226395772354L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, String> setupDictionary(String dictPath) {
        HashMap<String, String> dictionary = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            String line;
            br = IOUtils.readerFromString(dictPath);
            while ((line = br.readLine()) != null) {
                String[] words = line.trim().split("\\s");
                if (words.length < 3) {
                    System.err.printf("SpanishVerbStripper: adding words to dict, missing fields, ignoring line: %s%n", line);
                    continue;
                }
                dictionary.put(words[0], words[2]);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            log.info("Could not load Spanish data file " + dictPath);
        }
        finally {
            IOUtils.closeIgnoringExceptions(br);
        }
        return dictionary;
    }

    private SpanishVerbStripper(String dictPath) {
        this.dict = SpanishVerbStripper.setupDictionary(dictPath);
    }

    public static SpanishVerbStripper getInstance() {
        return SpanishVerbStripper.getInstance(DEFAULT_DICT);
    }

    public static SpanishVerbStripper getInstance(String dictPath) {
        SpanishVerbStripper svs = instances.get(dictPath);
        if (svs == null) {
            svs = new SpanishVerbStripper(dictPath);
            instances.put(dictPath, svs);
        }
        return svs;
    }

    public static boolean isStrippable(String word) {
        return pStrippable.matcher(word).find() || pIrregulars.matcher(word).find();
    }

    private static String removeAccents(String word) {
        if (accentedInfinitives.contains(word)) {
            return word;
        }
        String stripped = word;
        for (Pair<Pattern, String> accentFix : accentFixes) {
            stripped = accentFix.first().matcher(stripped).replaceAll(accentFix.second());
        }
        return stripped;
    }

    private static char getCase(String original, char letter) {
        if (Character.isUpperCase(original.charAt(original.length() - 1))) {
            return Character.toUpperCase(letter);
        }
        return Character.toLowerCase(letter);
    }

    private boolean normalizeStrippedVerb(StrippedVerb verb) {
        String normalized = SpanishVerbStripper.removeAccents(verb.getOriginalStem());
        String firstPron = verb.getPronouns().get(0).toLowerCase();
        String verbKey = normalized.toLowerCase();
        String pos = this.dict.get(verbKey);
        boolean valid = false;
        if (pos != null) {
            valid = !pos.equals("VMM02P0") || !firstPron.equalsIgnoreCase("os");
        } else if (firstPron.equalsIgnoreCase("os") && this.dict.containsKey(verbKey + 'd')) {
            normalized = normalized + SpanishVerbStripper.getCase(normalized, 'd');
            valid = true;
        } else if (nosse.matcher(firstPron).matches() && this.dict.containsKey(verbKey + 's')) {
            normalized = normalized + SpanishVerbStripper.getCase(normalized, 's');
            valid = true;
        }
        if (valid) {
            verb.setStem(normalized);
            return true;
        }
        return false;
    }

    private StrippedVerb stripSuffix(String word, Pattern pSuffix) {
        Matcher m = pSuffix.matcher(word);
        if (m.find()) {
            String stripped = word.substring(0, m.start());
            ArrayList<String> attached = new ArrayList<String>();
            for (int i = 0; i < m.groupCount(); ++i) {
                attached.add(m.group(i + 1));
            }
            return new StrippedVerb(stripped, attached);
        }
        return null;
    }

    public StrippedVerb separatePronouns(String verb) {
        StrippedVerb result = this.stripSuffix(verb, pOneAttachedPronoun);
        if (result != null && this.normalizeStrippedVerb(result)) {
            return result;
        }
        result = this.stripSuffix(verb, pTwoAttachedPronouns);
        if (result != null && this.normalizeStrippedVerb(result)) {
            return result;
        }
        return null;
    }

    public String stripVerb(String verb) {
        StrippedVerb separated = this.separatePronouns(verb);
        if (separated != null) {
            return separated.getStem();
        }
        return null;
    }

    public static class StrippedVerb {
        private String stem;
        private String originalStem;
        private List<String> pronouns;

        public StrippedVerb(String originalStem, List<String> pronouns) {
            this.originalStem = originalStem;
            this.pronouns = pronouns;
        }

        public void setStem(String stem) {
            this.stem = stem;
        }

        public String getStem() {
            return this.stem;
        }

        public String getOriginalStem() {
            return this.originalStem;
        }

        public List<String> getPronouns() {
            return this.pronouns;
        }
    }
}

