<a id="mypy-boto3-batch"></a>

# mypy-boto3-batch

[![PyPI - mypy-boto3-batch](https://img.shields.io/pypi/v/mypy-boto3-batch.svg?color=blue)](https://pypi.org/project/mypy-boto3-batch)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-batch.svg?color=blue)](https://pypi.org/project/mypy-boto3-batch)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-batch?color=blue)](https://pypistats.org/packages/mypy-boto3-batch)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Batch 1.17.91](https://boto3.amazonaws.com/v1/documentation/api/1.17.91/reference/services/batch.html#Batch)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.17.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-batch docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_batch/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-batch](#mypy-boto3-batch)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Batch` service.

```bash
python -m pip install boto3-stubs[batch]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[batch]` in your environment:
  `python -m pip install 'boto3-stubs[batch]'`

Both type checking and auto-complete should work for `Batch` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[batch]` in your environment:
  `python -m pip install 'boto3-stubs[batch]'`

Both type checking and auto-complete should work for `Batch` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[batch]` in your environment:
  `python -m pip install 'boto3-stubs[batch]'`
- Run `mypy` as usual

Type checking should work for `Batch` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[batch]` in your environment:
  `python -m pip install 'boto3-stubs[batch]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Batch` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`BatchClient` provides annotations for `boto3.client("batch")`.

```python
import boto3

from mypy_boto3_batch import BatchClient

client: BatchClient = boto3.client("batch")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: BatchClient = session.client("batch")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_batch.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_batch import BatchClient
from mypy_boto3_batch.paginator import (
    DescribeComputeEnvironmentsPaginator,
    DescribeJobDefinitionsPaginator,
    DescribeJobQueuesPaginator,
    ListJobsPaginator,
)

client: BatchClient = boto3.client("batch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_compute_environments_paginator: DescribeComputeEnvironmentsPaginator = client.get_paginator("describe_compute_environments")
describe_job_definitions_paginator: DescribeJobDefinitionsPaginator = client.get_paginator("describe_job_definitions")
describe_job_queues_paginator: DescribeJobQueuesPaginator = client.get_paginator("describe_job_queues")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
```

<a id="literals"></a>

### Literals

`mypy_boto3_batch.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_batch.literals import (
    ArrayJobDependencyType,
    AssignPublicIpType,
    CEStateType,
    CEStatusType,
    CETypeType,
    CRAllocationStrategyType,
    CRTypeType,
    DescribeComputeEnvironmentsPaginatorName,
    DescribeJobDefinitionsPaginatorName,
    DescribeJobQueuesPaginatorName,
    DeviceCgroupPermissionType,
    EFSAuthorizationConfigIAMType,
    EFSTransitEncryptionType,
    JQStateType,
    JQStatusType,
    JobDefinitionTypeType,
    JobStatusType,
    ListJobsPaginatorName,
    LogDriverType,
    PlatformCapabilityType,
    ResourceTypeType,
    RetryActionType,
)

def check_value(value: ArrayJobDependencyType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_batch.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_batch.type_defs import (
    ArrayPropertiesDetailTypeDef,
    ArrayPropertiesSummaryTypeDef,
    ArrayPropertiesTypeDef,
    AttemptContainerDetailTypeDef,
    AttemptDetailTypeDef,
    ComputeEnvironmentDetailTypeDef,
    ComputeEnvironmentOrderTypeDef,
    ComputeResourceTypeDef,
    ComputeResourceUpdateTypeDef,
    ContainerDetailTypeDef,
    ContainerOverridesTypeDef,
    ContainerPropertiesTypeDef,
    ContainerSummaryTypeDef,
    CreateComputeEnvironmentResponseTypeDef,
    CreateJobQueueResponseTypeDef,
    DescribeComputeEnvironmentsResponseTypeDef,
    DescribeJobDefinitionsResponseTypeDef,
    DescribeJobQueuesResponseTypeDef,
    DescribeJobsResponseTypeDef,
    DeviceTypeDef,
    EFSAuthorizationConfigTypeDef,
    EFSVolumeConfigurationTypeDef,
    Ec2ConfigurationTypeDef,
    EvaluateOnExitTypeDef,
    FargatePlatformConfigurationTypeDef,
    HostTypeDef,
    JobDefinitionTypeDef,
    JobDependencyTypeDef,
    JobDetailTypeDef,
    JobQueueDetailTypeDef,
    JobSummaryTypeDef,
    JobTimeoutTypeDef,
    KeyValuePairTypeDef,
    LaunchTemplateSpecificationTypeDef,
    LinuxParametersTypeDef,
    ListJobsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    LogConfigurationTypeDef,
    MountPointTypeDef,
    NetworkConfigurationTypeDef,
    NetworkInterfaceTypeDef,
    NodeDetailsTypeDef,
    NodeOverridesTypeDef,
    NodePropertiesSummaryTypeDef,
    NodePropertiesTypeDef,
    NodePropertyOverrideTypeDef,
    NodeRangePropertyTypeDef,
    PaginatorConfigTypeDef,
    RegisterJobDefinitionResponseTypeDef,
    ResourceRequirementTypeDef,
    RetryStrategyTypeDef,
    SecretTypeDef,
    SubmitJobResponseTypeDef,
    TmpfsTypeDef,
    UlimitTypeDef,
    UpdateComputeEnvironmentResponseTypeDef,
    UpdateJobQueueResponseTypeDef,
    VolumeTypeDef,
)

def get_structure() -> ArrayPropertiesDetailTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-batch` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-batch docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_batch/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
