from __future__ import annotations

from typing import Any, Optional

from .progressbar import ProgressBar as ProgressBar

def config_callbacks(
    callbacks: Optional[Any] = ...,
    model: Optional[Any] = ...,
    batch_size: Optional[Any] = ...,
    epochs: Optional[Any] = ...,
    steps: Optional[Any] = ...,
    log_freq: int = ...,
    verbose: int = ...,
    save_freq: int = ...,
    save_dir: Optional[Any] = ...,
    metrics: Optional[Any] = ...,
    mode: str = ...,
): ...

class CallbackList:
    callbacks: Any = ...
    params: Any = ...
    model: Any = ...
    def __init__(self, callbacks: Optional[Any] = ...) -> None: ...
    def append(self, callback: Any) -> None: ...
    def __iter__(self) -> Any: ...
    def set_params(self, params: Any) -> None: ...
    def set_model(self, model: Any) -> None: ...
    def on_begin(self, mode: Any, logs: Optional[Any] = ...) -> None: ...
    def on_end(self, mode: Any, logs: Optional[Any] = ...) -> None: ...
    def on_epoch_begin(self, epoch: Optional[Any] = ..., logs: Optional[Any] = ...) -> None: ...
    def on_epoch_end(self, epoch: Optional[Any] = ..., logs: Optional[Any] = ...) -> None: ...
    def on_batch_begin(self, mode: Any, step: Optional[Any] = ..., logs: Optional[Any] = ...) -> None: ...
    def on_batch_end(self, mode: Any, step: Optional[Any] = ..., logs: Optional[Any] = ...) -> None: ...

class Callback:
    model: Any = ...
    params: Any = ...
    def __init__(self) -> None: ...
    def set_params(self, params: Any) -> None: ...
    def set_model(self, model: Any) -> None: ...
    def on_train_begin(self, logs: Optional[Any] = ...) -> None: ...
    def on_train_end(self, logs: Optional[Any] = ...) -> None: ...
    def on_eval_begin(self, logs: Optional[Any] = ...) -> None: ...
    def on_eval_end(self, logs: Optional[Any] = ...) -> None: ...
    def on_predict_begin(self, logs: Optional[Any] = ...) -> None: ...
    def on_predict_end(self, logs: Optional[Any] = ...) -> None: ...
    def on_epoch_begin(self, epoch: Any, logs: Optional[Any] = ...) -> None: ...
    def on_epoch_end(self, epoch: Any, logs: Optional[Any] = ...) -> None: ...
    def on_train_batch_begin(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    def on_train_batch_end(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    def on_eval_batch_begin(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    def on_eval_batch_end(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    def on_predict_batch_begin(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    def on_predict_batch_end(self, step: Any, logs: Optional[Any] = ...) -> None: ...

class ProgBarLogger(Callback):
    epochs: Any = ...
    steps: Any = ...
    progbar: Any = ...
    verbose: Any = ...
    log_freq: Any = ...
    def __init__(self, log_freq: int = ..., verbose: int = ...) -> None: ...
    train_metrics: Any = ...
    def on_train_begin(self, logs: Optional[Any] = ...) -> None: ...
    epoch: Any = ...
    train_step: int = ...
    train_progbar: Any = ...
    def on_epoch_begin(self, epoch: Optional[Any] = ..., logs: Optional[Any] = ...) -> None: ...
    def on_train_batch_begin(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    def on_train_batch_end(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    def on_epoch_end(self, epoch: Any, logs: Optional[Any] = ...) -> None: ...
    eval_steps: Any = ...
    eval_metrics: Any = ...
    eval_step: int = ...
    evaled_samples: int = ...
    eval_progbar: Any = ...
    def on_eval_begin(self, logs: Optional[Any] = ...) -> None: ...
    def on_eval_batch_begin(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    def on_eval_batch_end(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    test_steps: Any = ...
    test_metrics: Any = ...
    test_step: int = ...
    tested_samples: int = ...
    test_progbar: Any = ...
    def on_predict_begin(self, logs: Optional[Any] = ...) -> None: ...
    def on_predict_batch_begin(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    def on_predict_batch_end(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    def on_eval_end(self, logs: Optional[Any] = ...) -> None: ...
    def on_predict_end(self, logs: Optional[Any] = ...) -> None: ...

class ModelCheckpoint(Callback):
    save_freq: Any = ...
    save_dir: Any = ...
    def __init__(self, save_freq: int = ..., save_dir: Optional[Any] = ...) -> None: ...
    epoch: Any = ...
    def on_epoch_begin(self, epoch: Optional[Any] = ..., logs: Optional[Any] = ...) -> None: ...
    def on_epoch_end(self, epoch: Any, logs: Optional[Any] = ...) -> None: ...
    def on_train_end(self, logs: Optional[Any] = ...) -> None: ...

class LRScheduler(Callback):
    by_step: Any = ...
    by_epoch: Any = ...
    def __init__(self, by_step: bool = ..., by_epoch: bool = ...) -> None: ...
    def on_epoch_end(self, epoch: Any, logs: Optional[Any] = ...) -> None: ...
    def on_train_batch_end(self, step: Any, logs: Optional[Any] = ...) -> None: ...

class EarlyStopping(Callback):
    monitor: Any = ...
    patience: Any = ...
    verbose: Any = ...
    baseline: Any = ...
    min_delta: Any = ...
    wait_epoch: int = ...
    best_weights: Any = ...
    stopped_epoch: int = ...
    save_best_model: Any = ...
    save_dir: Any = ...
    monitor_op: Any = ...
    def __init__(
        self,
        monitor: str = ...,
        mode: str = ...,
        patience: int = ...,
        verbose: int = ...,
        min_delta: int = ...,
        baseline: Optional[Any] = ...,
        save_best_model: bool = ...,
    ) -> None: ...
    best_value: Any = ...
    def on_train_begin(self, logs: Optional[Any] = ...) -> None: ...
    def on_eval_end(self, logs: Optional[Any] = ...) -> None: ...

class VisualDL(Callback):
    log_dir: Any = ...
    epochs: Any = ...
    steps: Any = ...
    epoch: int = ...
    def __init__(self, log_dir: Any) -> None: ...
    train_metrics: Any = ...
    train_step: int = ...
    def on_train_begin(self, logs: Optional[Any] = ...) -> None: ...
    def on_epoch_begin(self, epoch: Optional[Any] = ..., logs: Optional[Any] = ...) -> None: ...
    def on_train_batch_end(self, step: Any, logs: Optional[Any] = ...) -> None: ...
    eval_steps: Any = ...
    eval_metrics: Any = ...
    eval_step: int = ...
    evaled_samples: int = ...
    def on_eval_begin(self, logs: Optional[Any] = ...) -> None: ...
    def on_train_end(self, logs: Optional[Any] = ...) -> None: ...
    def on_eval_end(self, logs: Optional[Any] = ...) -> None: ...

class ReduceLROnPlateau(Callback):
    monitor: Any = ...
    factor: Any = ...
    min_lr: Any = ...
    min_delta: Any = ...
    patience: Any = ...
    verbose: Any = ...
    cooldown: Any = ...
    cooldown_counter: int = ...
    wait: int = ...
    best: int = ...
    mode: Any = ...
    monitor_op: Any = ...
    epoch: int = ...
    def __init__(
        self,
        monitor: str = ...,
        factor: float = ...,
        patience: int = ...,
        verbose: int = ...,
        mode: str = ...,
        min_delta: float = ...,
        cooldown: int = ...,
        min_lr: int = ...,
    ) -> None: ...
    def on_train_begin(self, logs: Optional[Any] = ...) -> None: ...
    def on_eval_end(self, logs: Optional[Any] = ...) -> None: ...
    def in_cooldown(self): ...
