from media_platform.auth.app_authenticator import AppAuthenticator
from media_platform.http.authenticated_http_client import AuthenticatedHTTPClient
from media_platform.service.image_service.extract_features_request import ExtractFeaturesRequest
from media_platform.service.image_service.image_operation_request import ImageOperationRequest
from media_platform.service.image_service.image_token import ImageToken, Policy, Watermark
from media_platform.service.media_platform_service import MediaPlatformService


class ImageService(MediaPlatformService):
    def __init__(self, domain, authenticated_http_client, app_authenticator):
        # type: (str, AuthenticatedHTTPClient, AppAuthenticator) -> None
        super(ImageService, self).__init__(domain, authenticated_http_client)
        self.app_authenticator = app_authenticator

    def extract_features_request(self):
        # type: () -> ExtractFeaturesRequest
        return ExtractFeaturesRequest(self._authenticated_http_client, self._base_url)

    def image_operation_request(self):
        # type: () -> ImageOperationRequest
        return ImageOperationRequest(self._authenticated_http_client, self._base_url)

    def token(self, policy=None, watermark=None):
        # type: (Policy, Watermark) -> ImageToken
        token = self.app_authenticator.default_token()

        image_token = ImageToken.from_token(token)
        image_token.policy = policy
        image_token.watermark = watermark

        return image_token

    def sign_token(self, token):
        # type: (ImageToken) -> str
        return self.app_authenticator.sign_token(token)
