# dao
# 道

将中国传统哲学思想结合到python编程思想中，用于优化代码逻辑结构，增强可读性，增加以往代码可序列化的可能性

道、法、术、器、势、志

>   传统的辩证哲学思想跟现代企业管理的对应关系: 好在“道、法、术、器、势、志”,先进于外国的管理思想很多年。是目前唯一可以解释整个世界由上到下的3D立体、无死角的逻辑关系的利器,是有效整合其它管理理论的理论

道生一(志),一生二(法、术),二生三（器）,三生（势）万物

>   志：产生类要达到的目的    
>   势： 函数生产者    
>   法： 函数如何调度消费者的方法，汇聚结果    
>   术： 消费者具体实现处理逻辑    
>   器： 消费者载体（进程、线程、函数、属性等）    
>   万物： 每个消费者产生的函数结果    

```
道：就是核心思想、理念、本质规律。很多时候有人纠结是自然规律，还是人定的思想，其实王阳明早说了“天理即人心”，我说“天理因人而存在”。这六个字，完全是因为人类存在而存在的，包括外星人。
法：就是法律、规章、制度、方法。是以“道”为基础制定的不可违背的原则，比如有些经常挂在嘴边却不知所云的“大道自然”或者“以人为本”。
术：行为与技巧，是可以以道为原则，做出反应和选择的，是以“道”为指导原则的。即“以道御术”，出自老子的《道德经》，很多人把“御”翻译成“承载”，实际上更贴切的是“驾驭”。以联想企业文化为例，联想提出“如果遇到公司没有相关规定的事，就按‘企业文化’办！”，这就是以道御术。
器：是指工具，比如桌椅板凳或者企业里的打卡机，还有EXCEL管理表格之类的。总之“器”用来体现道的思想，是人体器官的延伸，从而简化问题，更快达成目标，是体现“器以载道”的应用。
势：是从“道、法、术、器”体现的势能，比如“军魂、班风”之类的气场、气势、执行力。这个在“图1”里表现的是一个圈，其实画出来更应该像是太阳的光芒一样，感觉的到，摸 不到。以某个人为例，状态可以达到“善、诚、美、大、圣、神”的六重境界，善为别人以为你拥有美德，诚为你确实有美德，充盈为美，溢出为大，影响数个时代，众人为圣。影响千秋万代不同民族为神，比如佛教、基督教、伊斯兰教的创始人。
志：主要是指目标，只有通过势能才能达到，势就是火箭助推器形成的力量。
```


更多详细可见 example.py 文件

```python
from dao import D


def handle(data):
    print(data)
    return data+1

if __name__ == '__main__':

    # 志(物质) = 道(势, 术+器， 法)(意识)

    # 结果 = 目的(生产者, 消费者)(过程)


    res = D(range, handle)(1, 10)
    print(res)


    res = D(range, handle).zhi(1, 10).wd(list, handle).wu_dao(list, handle)()
    print(res)

```