#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Aug 24 12:16:12 2021 by generateDS.py version 2.30.11.
# Python 2.7.18 (default, May 19 2021, 00:00:00)  [GCC 11.1.1 20210428 (Red Hat 11.1.1-1)]
#
# Command line options:
#   ('-o', 'nml.py')
#   ('--use-getter-setter', 'none')
#   ('--silence', '')
#   ('--user-methods', 'helper_methods')
#
# Command line arguments:
#   NeuroML_v2.2.xsd
#
# Command line:
#   /home/asinha/.local/share/virtualenvs/generateds-2.7/bin/generateDS.py -o "nml.py" --use-getter-setter="none" --silence --user-methods="helper_methods" NeuroML_v2.2.xsd
#
# Current working directory (os.getcwd()):
#   nml
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_

try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc


def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element


#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for a example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r"(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$")

        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name

            def utcoffset(self, dt):
                return self.__offset

            def tzname(self, dt):
                return self.__name

            def dst(self, dt):
                return None

        def gds_format_string(self, input_data, input_name=""):
            return input_data

        def gds_validate_string(self, input_data, node=None, input_name=""):
            if not input_data:
                return ""
            else:
                return input_data

        def gds_format_base64(self, input_data, input_name=""):
            return base64.b64encode(input_data)

        def gds_validate_base64(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_integer(self, input_data, input_name=""):
            return "%d" % input_data

        def gds_validate_integer(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_integer_list(self, input_data, input_name=""):
            return "%s" % " ".join(input_data)

        def gds_validate_integer_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of integers")
            return values

        def gds_format_float(self, input_data, input_name=""):
            return ("%.15f" % input_data).rstrip("0")

        def gds_validate_float(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_float_list(self, input_data, input_name=""):
            return "%s" % " ".join(input_data)

        def gds_validate_float_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of floats")
            return values

        def gds_format_double(self, input_data, input_name=""):
            return "%e" % input_data

        def gds_validate_double(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_double_list(self, input_data, input_name=""):
            return "%s" % " ".join(input_data)

        def gds_validate_double_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of doubles")
            return values

        def gds_format_boolean(self, input_data, input_name=""):
            return ("%s" % input_data).lower()

        def gds_validate_boolean(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_boolean_list(self, input_data, input_name=""):
            return "%s" % " ".join(input_data)

        def gds_validate_boolean_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                if value not in (
                    "true",
                    "1",
                    "false",
                    "0",
                ):
                    raise_parse_error(
                        node,
                        "Requires sequence of booleans " '("true", "1", "false", "0")',
                    )
            return values

        def gds_validate_datetime(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_datetime(self, input_data, input_name=""):
            if input_data.microsecond == 0:
                _svalue = "%04d-%02d-%02dT%02d:%02d:%02d" % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = "%04d-%02d-%02dT%02d:%02d:%02d.%s" % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ("%f" % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += "Z"
                    else:
                        if total_seconds < 0:
                            _svalue += "-"
                            total_seconds *= -1
                        else:
                            _svalue += "+"
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            return _svalue

        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split(".")
            if len(time_parts) > 1:
                micro_seconds = int(float("0." + time_parts[1]) * 1000000)
                input_data = "%s.%s" % (
                    time_parts[0],
                    "{}".format(micro_seconds).rjust(6, "0"),
                )
                dt = datetime_.datetime.strptime(input_data, "%Y-%m-%dT%H:%M:%S.%f")
            else:
                dt = datetime_.datetime.strptime(input_data, "%Y-%m-%dT%H:%M:%S")
            dt = dt.replace(tzinfo=tz)
            return dt

        def gds_validate_date(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_date(self, input_data, input_name=""):
            _svalue = "%04d-%02d-%02d" % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += "Z"
                        else:
                            if total_seconds < 0:
                                _svalue += "-"
                                total_seconds *= -1
                            else:
                                _svalue += "+"
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            except AttributeError:
                pass
            return _svalue

        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, "%Y-%m-%d")
            dt = dt.replace(tzinfo=tz)
            return dt.date()

        def gds_validate_time(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_time(self, input_data, input_name=""):
            if input_data.microsecond == 0:
                _svalue = "%02d:%02d:%02d" % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = "%02d:%02d:%02d.%s" % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ("%f" % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += "Z"
                    else:
                        if total_seconds < 0:
                            _svalue += "-"
                            total_seconds *= -1
                        else:
                            _svalue += "+"
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            return _svalue

        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1

        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split(".")) > 1:
                dt = datetime_.datetime.strptime(input_data, "%H:%M:%S.%f")
            else:
                dt = datetime_.datetime.strptime(input_data, "%H:%M:%S")
            dt = dt.replace(tzinfo=tz)
            return dt.time()

        def gds_str_lower(self, instring):
            return instring.lower()

        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = "/".join(path_list)
            return path

        Tag_strip_pattern_ = re_.compile(r"\{.*\}")

        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub("", node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)

        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if "xsi" in node.nsmap:
                classname = node.get("{%s}type" % node.nsmap["xsi"])
                if classname is not None:
                    names = classname.split(":")
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1

        def gds_build_any(self, node, type_name=None):
            return None

        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))

        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = "utf-8"
                return instring.encode(encoding)
            else:
                return instring

        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode("utf8")
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result

        def __eq__(self, other):
            if type(self) != type(other):
                return False
            return self.__dict__ == other.__dict__

        def __ne__(self, other):
            return not self.__eq__(other)

    def getSubclassFromModule_(module, class_):
        """Get the subclass of a class from a specific module."""
        name = class_.__name__ + "Sub"
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ""
Tag_pattern_ = re_.compile(r"({.*})?(.*)")
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r"{(.*)}(.*)")
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write("    ")


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ""
    s1 = isinstance(inStr, BaseStrType_) and inStr or "%s" % inStr
    s2 = ""
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos : mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start() : mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace("&", "&amp;")
    s1 = s1.replace("<", "&lt;")
    s1 = s1.replace(">", "&gt;")
    return s1


def quote_attrib(inStr):
    s1 = isinstance(inStr, BaseStrType_) and inStr or "%s" % inStr
    s1 = s1.replace("&", "&amp;")
    s1 = s1.replace("<", "&lt;")
    s1 = s1.replace(">", "&gt;")
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find("\n") == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find("\n") == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ""
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(":")
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get(
                "{%s}%s"
                % (
                    namespace,
                    name,
                )
            )
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = "%s (element %s/line %d)" % (
        msg,
        node.tag,
        node.sourceline,
    )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8

    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value

    def getCategory(self):
        return self.category

    def getContenttype(self, content_type):
        return self.content_type

    def getValue(self):
        return self.value

    def getName(self):
        return self.name

    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:  # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name, pretty_print=pretty_print
            )

    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write("<%s>%s</%s>" % (self.name, self.value, self.name))
        elif (
            self.content_type == MixedContainer.TypeInteger
            or self.content_type == MixedContainer.TypeBoolean
        ):
            outfile.write("<%s>%d</%s>" % (self.name, self.value, self.name))
        elif (
            self.content_type == MixedContainer.TypeFloat
            or self.content_type == MixedContainer.TypeDecimal
        ):
            outfile.write("<%s>%f</%s>" % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write("<%s>%g</%s>" % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write(
                "<%s>%s</%s>" % (self.name, base64.b64encode(self.value), self.name)
            )

    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, "%s" % self.name)
            subelement.text = self.to_etree_simple()
        else:  # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)

    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (
            self.content_type == MixedContainer.TypeInteger
            or self.content_type == MixedContainer.TypeBoolean
        ):
            text = "%d" % self.value
        elif (
            self.content_type == MixedContainer.TypeFloat
            or self.content_type == MixedContainer.TypeDecimal
        ):
            text = "%f" % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = "%g" % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = "%s" % base64.b64encode(self.value)
        return text

    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value)
            )
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value)
            )
        else:  # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n'
                % (
                    self.category,
                    self.content_type,
                    self.name,
                )
            )
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(")\n")


class MemberSpec_(object):
    def __init__(
        self,
        name="",
        data_type="",
        container=0,
        optional=0,
        child_attrs=None,
        choice=None,
    ):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional

    def set_name(self, name):
        self.name = name

    def get_name(self):
        return self.name

    def set_data_type(self, data_type):
        self.data_type = data_type

    def get_data_type_chain(self):
        return self.data_type

    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return "xs:string"
        else:
            return self.data_type

    def set_container(self, container):
        self.container = container

    def get_container(self):
        return self.container

    def set_child_attrs(self, child_attrs):
        self.child_attrs = child_attrs

    def get_child_attrs(self):
        return self.child_attrs

    def set_choice(self, choice):
        self.choice = choice

    def get_choice(self):
        return self.choice

    def set_optional(self, optional):
        self.optional = optional

    def get_optional(self):
        return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Data representation classes.
#


class BlockTypes(object):
    VOLTAGE_CONC_DEP_BLOCK_MECHANISM = "voltageConcDepBlockMechanism"


class Metric(object):
    PATH_LENGTHFROMROOT = "Path Length from root"


class PlasticityTypes(object):
    TSODYKS_MARKRAM_DEP_MECHANISM = "tsodyksMarkramDepMechanism"
    TSODYKS_MARKRAM_DEP_FAC_MECHANISM = "tsodyksMarkramDepFacMechanism"


class ZeroOrOne(object):
    _0 = "0"
    _1 = "1"


class allowedSpaces(object):
    EUCLIDEAN__1_D = "Euclidean_1D"
    EUCLIDEAN__2_D = "Euclidean_2D"
    EUCLIDEAN__3_D = "Euclidean_3D"
    GRID__1_D = "Grid_1D"
    GRID__2_D = "Grid_2D"
    GRID__3_D = "Grid_3D"


class channelTypes(object):
    ION_CHANNEL_PASSIVE = "ionChannelPassive"
    ION_CHANNEL_HH = "ionChannelHH"


class gateTypes(object):
    GATE_H_HRATES = "gateHHrates"
    GATE_H_HRATES_TAU = "gateHHratesTau"
    GATE_H_HTAU_INF = "gateHHtauInf"
    GATE_H_HRATES_INF = "gateHHratesInf"
    GATE_H_HRATES_TAU_INF = "gateHHratesTauInf"
    GATE_HH_INSTANTANEOUS = "gateHHInstantaneous"
    GATE_KS = "gateKS"
    GATE_FRACTIONAL = "gateFractional"


class networkTypes(object):
    NETWORK = "network"
    NETWORK_WITH_TEMPERATURE = "networkWithTemperature"


class populationTypes(object):
    POPULATION = "population"
    POPULATION_LIST = "populationList"


class Property(GeneratedsSuper):
    """Generic property with a tag and value"""

    member_data_items_ = [
        MemberSpec_("tag", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("value", "xs:string", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, tag=None, value=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.tag = _cast(None, tag)
        self.value = _cast(None, value)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Property)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Property.subclass:
            return Property.subclass(*args_, **kwargs_)
        else:
            return Property(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Property",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Property")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Property"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Property",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Property"
    ):
        if self.tag is not None and "tag" not in already_processed:
            already_processed.add("tag")
            outfile.write(
                " tag=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.tag), input_name="tag")
                    ),
                )
            )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Property",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("tag", node)
        if value is not None and "tag" not in already_processed:
            already_processed.add("tag")
            self.tag = value
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Property


class Annotation(GeneratedsSuper):
    """Placeholder for MIRIAM related metadata, among others."""

    member_data_items_ = [
        MemberSpec_(
            "__ANY__",
            "__ANY__",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"processContents": u"skip",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, anytypeobjs_=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Annotation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Annotation.subclass:
            return Annotation.subclass(*args_, **kwargs_)
        else:
            return Annotation(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.anytypeobjs_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Annotation",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Annotation")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Annotation"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Annotation",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Annotation"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Annotation",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, "Annotation")
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)


# end class Annotation


class ComponentType(GeneratedsSuper):
    """Contains an extension to NeuroML by creating custom LEMS
    ComponentType."""

    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("extends", "xs:string", 0, 1, {"use": u"optional"}),
        MemberSpec_("description", "xs:string", 0, 1, {"use": u"optional"}),
        MemberSpec_(
            "Property",
            "Property",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"LEMS_Property",
                u"name": u"Property",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "Parameter",
            "Parameter",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Parameter",
                u"name": u"Parameter",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "Constant",
            "Constant",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Constant",
                u"name": u"Constant",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "Exposure",
            "Exposure",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Exposure",
                u"name": u"Exposure",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "Requirement",
            "Requirement",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Requirement",
                u"name": u"Requirement",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "InstanceRequirement",
            "InstanceRequirement",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"InstanceRequirement",
                u"name": u"InstanceRequirement",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "Dynamics",
            "Dynamics",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Dynamics",
                u"name": u"Dynamics",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        name=None,
        extends=None,
        description=None,
        Property=None,
        Parameter=None,
        Constant=None,
        Exposure=None,
        Requirement=None,
        InstanceRequirement=None,
        Dynamics=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.name = _cast(None, name)
        self.extends = _cast(None, extends)
        self.description = _cast(None, description)
        if Property is None:
            self.Property = []
        else:
            self.Property = Property
        if Parameter is None:
            self.Parameter = []
        else:
            self.Parameter = Parameter
        if Constant is None:
            self.Constant = []
        else:
            self.Constant = Constant
        if Exposure is None:
            self.Exposure = []
        else:
            self.Exposure = Exposure
        if Requirement is None:
            self.Requirement = []
        else:
            self.Requirement = Requirement
        if InstanceRequirement is None:
            self.InstanceRequirement = []
        else:
            self.InstanceRequirement = InstanceRequirement
        if Dynamics is None:
            self.Dynamics = []
        else:
            self.Dynamics = Dynamics

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ComponentType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ComponentType.subclass:
            return ComponentType.subclass(*args_, **kwargs_)
        else:
            return ComponentType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.Property
            or self.Parameter
            or self.Constant
            or self.Exposure
            or self.Requirement
            or self.InstanceRequirement
            or self.Dynamics
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ComponentType",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ComponentType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ComponentType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ComponentType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ComponentType",
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.extends is not None and "extends" not in already_processed:
            already_processed.add("extends")
            outfile.write(
                " extends=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.extends), input_name="extends"
                        )
                    ),
                )
            )
        if self.description is not None and "description" not in already_processed:
            already_processed.add("description")
            outfile.write(
                " description=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.description), input_name="description"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ComponentType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for Property_ in self.Property:
            Property_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Property",
                pretty_print=pretty_print,
            )
        for Parameter_ in self.Parameter:
            Parameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Parameter",
                pretty_print=pretty_print,
            )
        for Constant_ in self.Constant:
            Constant_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Constant",
                pretty_print=pretty_print,
            )
        for Exposure_ in self.Exposure:
            Exposure_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Exposure",
                pretty_print=pretty_print,
            )
        for Requirement_ in self.Requirement:
            Requirement_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Requirement",
                pretty_print=pretty_print,
            )
        for InstanceRequirement_ in self.InstanceRequirement:
            InstanceRequirement_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="InstanceRequirement",
                pretty_print=pretty_print,
            )
        for Dynamics_ in self.Dynamics:
            Dynamics_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Dynamics",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("extends", node)
        if value is not None and "extends" not in already_processed:
            already_processed.add("extends")
            self.extends = value
        value = find_attr_value_("description", node)
        if value is not None and "description" not in already_processed:
            already_processed.add("description")
            self.description = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "Property":
            obj_ = LEMS_Property.factory(parent_object_=self)
            obj_.build(child_)
            self.Property.append(obj_)
            obj_.original_tagname_ = "Property"
        elif nodeName_ == "Parameter":
            obj_ = Parameter.factory(parent_object_=self)
            obj_.build(child_)
            self.Parameter.append(obj_)
            obj_.original_tagname_ = "Parameter"
        elif nodeName_ == "Constant":
            obj_ = Constant.factory(parent_object_=self)
            obj_.build(child_)
            self.Constant.append(obj_)
            obj_.original_tagname_ = "Constant"
        elif nodeName_ == "Exposure":
            obj_ = Exposure.factory(parent_object_=self)
            obj_.build(child_)
            self.Exposure.append(obj_)
            obj_.original_tagname_ = "Exposure"
        elif nodeName_ == "Requirement":
            obj_ = Requirement.factory(parent_object_=self)
            obj_.build(child_)
            self.Requirement.append(obj_)
            obj_.original_tagname_ = "Requirement"
        elif nodeName_ == "InstanceRequirement":
            obj_ = InstanceRequirement.factory(parent_object_=self)
            obj_.build(child_)
            self.InstanceRequirement.append(obj_)
            obj_.original_tagname_ = "InstanceRequirement"
        elif nodeName_ == "Dynamics":
            obj_ = Dynamics.factory(parent_object_=self)
            obj_.build(child_)
            self.Dynamics.append(obj_)
            obj_.original_tagname_ = "Dynamics"


# end class ComponentType


class Constant(GeneratedsSuper):
    """LEMS ComponentType for Constant."""

    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("dimension", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("value", "Nml2Quantity", 0, 0, {"use": u"required"}),
        MemberSpec_("description", "xs:string", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, name=None, dimension=None, value=None, description=None, **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.name = _cast(None, name)
        self.dimension = _cast(None, dimension)
        self.value = _cast(None, value)
        self.description = _cast(None, description)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Constant)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Constant.subclass:
            return Constant.subclass(*args_, **kwargs_)
        else:
            return Constant(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity(self, value):
        # Validate type Nml2Quantity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_patterns_,
                    )
                )

    validate_Nml2Quantity_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*([_a-zA-Z0-9])*$"]
    ]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Constant",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Constant")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Constant"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Constant",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Constant"
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.dimension is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            outfile.write(
                " dimension=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.dimension), input_name="dimension"
                        )
                    ),
                )
            )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(" value=%s" % (quote_attrib(self.value),))
        if self.description is not None and "description" not in already_processed:
            already_processed.add("description")
            outfile.write(
                " description=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.description), input_name="description"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Constant",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("dimension", node)
        if value is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            self.dimension = value
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
            self.validate_Nml2Quantity(self.value)  # validate type Nml2Quantity
        value = find_attr_value_("description", node)
        if value is not None and "description" not in already_processed:
            already_processed.add("description")
            self.description = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Constant


class Exposure(GeneratedsSuper):
    """LEMS Exposure (ComponentType property)"""

    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("dimension", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("description", "xs:string", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, name=None, dimension=None, description=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.name = _cast(None, name)
        self.dimension = _cast(None, dimension)
        self.description = _cast(None, description)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Exposure)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Exposure.subclass:
            return Exposure.subclass(*args_, **kwargs_)
        else:
            return Exposure(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Exposure",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Exposure")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Exposure"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Exposure",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Exposure"
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.dimension is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            outfile.write(
                " dimension=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.dimension), input_name="dimension"
                        )
                    ),
                )
            )
        if self.description is not None and "description" not in already_processed:
            already_processed.add("description")
            outfile.write(
                " description=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.description), input_name="description"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Exposure",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("dimension", node)
        if value is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            self.dimension = value
        value = find_attr_value_("description", node)
        if value is not None and "description" not in already_processed:
            already_processed.add("description")
            self.description = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Exposure


class NamedDimensionalType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("dimension", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("description", "xs:string", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.name = _cast(None, name)
        self.dimension = _cast(None, dimension)
        self.description = _cast(None, description)
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NamedDimensionalType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NamedDimensionalType.subclass:
            return NamedDimensionalType.subclass(*args_, **kwargs_)
        else:
            return NamedDimensionalType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NamedDimensionalType",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("NamedDimensionalType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="NamedDimensionalType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="NamedDimensionalType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="NamedDimensionalType",
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.dimension is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            outfile.write(
                " dimension=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.dimension), input_name="dimension"
                        )
                    ),
                )
            )
        if self.description is not None and "description" not in already_processed:
            already_processed.add("description")
            outfile.write(
                " description=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.description), input_name="description"
                        )
                    ),
                )
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NamedDimensionalType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("dimension", node)
        if value is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            self.dimension = value
        value = find_attr_value_("description", node)
        if value is not None and "description" not in already_processed:
            already_processed.add("description")
            self.description = value
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class NamedDimensionalType


class NamedDimensionalVariable(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("dimension", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("description", "xs:string", 0, 1, {"use": u"optional"}),
        MemberSpec_("exposure", "xs:string", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        exposure=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.name = _cast(None, name)
        self.dimension = _cast(None, dimension)
        self.description = _cast(None, description)
        self.exposure = _cast(None, exposure)
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NamedDimensionalVariable
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NamedDimensionalVariable.subclass:
            return NamedDimensionalVariable.subclass(*args_, **kwargs_)
        else:
            return NamedDimensionalVariable(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NamedDimensionalVariable",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("NamedDimensionalVariable")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="NamedDimensionalVariable",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="NamedDimensionalVariable",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="NamedDimensionalVariable",
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.dimension is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            outfile.write(
                " dimension=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.dimension), input_name="dimension"
                        )
                    ),
                )
            )
        if self.description is not None and "description" not in already_processed:
            already_processed.add("description")
            outfile.write(
                " description=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.description), input_name="description"
                        )
                    ),
                )
            )
        if self.exposure is not None and "exposure" not in already_processed:
            already_processed.add("exposure")
            outfile.write(
                " exposure=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.exposure), input_name="exposure"
                        )
                    ),
                )
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NamedDimensionalVariable",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("dimension", node)
        if value is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            self.dimension = value
        value = find_attr_value_("description", node)
        if value is not None and "description" not in already_processed:
            already_processed.add("description")
            self.description = value
        value = find_attr_value_("exposure", node)
        if value is not None and "exposure" not in already_processed:
            already_processed.add("exposure")
            self.exposure = value
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class NamedDimensionalVariable


class Parameter(NamedDimensionalType):
    member_data_items_ = []
    subclass = None
    superclass = NamedDimensionalType

    def __init__(self, name=None, dimension=None, description=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(Parameter, self).__init__(name, dimension, description, **kwargs_)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Parameter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Parameter.subclass:
            return Parameter.subclass(*args_, **kwargs_)
        else:
            return Parameter(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(Parameter, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Parameter",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Parameter")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Parameter"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Parameter",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Parameter"
    ):
        super(Parameter, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Parameter"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Parameter",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Parameter, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(Parameter, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Parameter, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class Parameter


class LEMS_Property(NamedDimensionalType):
    member_data_items_ = [
        MemberSpec_("default_value", "xs:double", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = NamedDimensionalType

    def __init__(
        self, name=None, dimension=None, description=None, default_value=None, **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(LEMS_Property, self).__init__(name, dimension, description, **kwargs_)
        self.default_value = _cast(float, default_value)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, LEMS_Property)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LEMS_Property.subclass:
            return LEMS_Property.subclass(*args_, **kwargs_)
        else:
            return LEMS_Property(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(LEMS_Property, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="LEMS_Property",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("LEMS_Property")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="LEMS_Property"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="LEMS_Property",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="LEMS_Property",
    ):
        super(LEMS_Property, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="LEMS_Property"
        )
        if self.default_value is not None and "default_value" not in already_processed:
            already_processed.add("default_value")
            outfile.write(
                ' defaultValue="%s"'
                % self.gds_format_double(self.default_value, input_name="defaultValue")
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="LEMS_Property",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(LEMS_Property, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("defaultValue", node)
        if value is not None and "defaultValue" not in already_processed:
            already_processed.add("defaultValue")
            try:
                self.default_value = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (defaultValue): %s" % exp)
        super(LEMS_Property, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(LEMS_Property, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class LEMS_Property


class Requirement(NamedDimensionalType):
    member_data_items_ = []
    subclass = None
    superclass = NamedDimensionalType

    def __init__(self, name=None, dimension=None, description=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(Requirement, self).__init__(name, dimension, description, **kwargs_)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Requirement)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Requirement.subclass:
            return Requirement.subclass(*args_, **kwargs_)
        else:
            return Requirement(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(Requirement, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Requirement",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Requirement")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Requirement"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Requirement",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="Requirement",
    ):
        super(Requirement, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Requirement"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Requirement",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Requirement, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(Requirement, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Requirement, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class Requirement


class InstanceRequirement(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("type", "xs:string", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, name=None, type=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.name = _cast(None, name)
        self.type = _cast(None, type)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InstanceRequirement
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InstanceRequirement.subclass:
            return InstanceRequirement.subclass(*args_, **kwargs_)
        else:
            return InstanceRequirement(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InstanceRequirement",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InstanceRequirement")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="InstanceRequirement",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InstanceRequirement",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="InstanceRequirement",
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InstanceRequirement",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class InstanceRequirement


class Dynamics(GeneratedsSuper):
    """LEMS ComponentType for Dynamics"""

    member_data_items_ = [
        MemberSpec_(
            "StateVariable",
            "StateVariable",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"StateVariable",
                u"name": u"StateVariable",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "DerivedVariable",
            "DerivedVariable",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"DerivedVariable",
                u"name": u"DerivedVariable",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "ConditionalDerivedVariable",
            "ConditionalDerivedVariable",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ConditionalDerivedVariable",
                u"name": u"ConditionalDerivedVariable",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "TimeDerivative",
            "TimeDerivative",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"TimeDerivative",
                u"name": u"TimeDerivative",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        StateVariable=None,
        DerivedVariable=None,
        ConditionalDerivedVariable=None,
        TimeDerivative=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        if StateVariable is None:
            self.StateVariable = []
        else:
            self.StateVariable = StateVariable
        if DerivedVariable is None:
            self.DerivedVariable = []
        else:
            self.DerivedVariable = DerivedVariable
        if ConditionalDerivedVariable is None:
            self.ConditionalDerivedVariable = []
        else:
            self.ConditionalDerivedVariable = ConditionalDerivedVariable
        if TimeDerivative is None:
            self.TimeDerivative = []
        else:
            self.TimeDerivative = TimeDerivative

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Dynamics)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Dynamics.subclass:
            return Dynamics.subclass(*args_, **kwargs_)
        else:
            return Dynamics(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.StateVariable
            or self.DerivedVariable
            or self.ConditionalDerivedVariable
            or self.TimeDerivative
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Dynamics",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Dynamics")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Dynamics"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Dynamics",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Dynamics"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Dynamics",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for StateVariable_ in self.StateVariable:
            StateVariable_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="StateVariable",
                pretty_print=pretty_print,
            )
        for DerivedVariable_ in self.DerivedVariable:
            DerivedVariable_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="DerivedVariable",
                pretty_print=pretty_print,
            )
        for ConditionalDerivedVariable_ in self.ConditionalDerivedVariable:
            ConditionalDerivedVariable_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="ConditionalDerivedVariable",
                pretty_print=pretty_print,
            )
        for TimeDerivative_ in self.TimeDerivative:
            TimeDerivative_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="TimeDerivative",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "StateVariable":
            obj_ = StateVariable.factory(parent_object_=self)
            obj_.build(child_)
            self.StateVariable.append(obj_)
            obj_.original_tagname_ = "StateVariable"
        elif nodeName_ == "DerivedVariable":
            obj_ = DerivedVariable.factory(parent_object_=self)
            obj_.build(child_)
            self.DerivedVariable.append(obj_)
            obj_.original_tagname_ = "DerivedVariable"
        elif nodeName_ == "ConditionalDerivedVariable":
            obj_ = ConditionalDerivedVariable.factory(parent_object_=self)
            obj_.build(child_)
            self.ConditionalDerivedVariable.append(obj_)
            obj_.original_tagname_ = "ConditionalDerivedVariable"
        elif nodeName_ == "TimeDerivative":
            obj_ = TimeDerivative.factory(parent_object_=self)
            obj_.build(child_)
            self.TimeDerivative.append(obj_)
            obj_.original_tagname_ = "TimeDerivative"


# end class Dynamics


class DerivedVariable(NamedDimensionalVariable):
    """LEMS ComponentType for DerivedVariable"""

    member_data_items_ = [
        MemberSpec_("value", "xs:string", 0, 1, {"use": u"optional"}),
        MemberSpec_("select", "xs:string", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = NamedDimensionalVariable

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        exposure=None,
        value=None,
        select=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(DerivedVariable, self).__init__(
            name, dimension, description, exposure, **kwargs_
        )
        self.value = _cast(None, value)
        self.select = _cast(None, select)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, DerivedVariable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DerivedVariable.subclass:
            return DerivedVariable.subclass(*args_, **kwargs_)
        else:
            return DerivedVariable(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(DerivedVariable, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DerivedVariable",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("DerivedVariable")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="DerivedVariable"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="DerivedVariable",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="DerivedVariable",
    ):
        super(DerivedVariable, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="DerivedVariable"
        )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )
        if self.select is not None and "select" not in already_processed:
            already_processed.add("select")
            outfile.write(
                " select=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.select), input_name="select"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DerivedVariable",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(DerivedVariable, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
        value = find_attr_value_("select", node)
        if value is not None and "select" not in already_processed:
            already_processed.add("select")
            self.select = value
        super(DerivedVariable, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(DerivedVariable, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class DerivedVariable


class StateVariable(NamedDimensionalVariable):
    member_data_items_ = []
    subclass = None
    superclass = NamedDimensionalVariable

    def __init__(
        self, name=None, dimension=None, description=None, exposure=None, **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(StateVariable, self).__init__(
            name, dimension, description, exposure, **kwargs_
        )

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, StateVariable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StateVariable.subclass:
            return StateVariable.subclass(*args_, **kwargs_)
        else:
            return StateVariable(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(StateVariable, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="StateVariable",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("StateVariable")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="StateVariable"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="StateVariable",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="StateVariable",
    ):
        super(StateVariable, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="StateVariable"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="StateVariable",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(StateVariable, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(StateVariable, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(StateVariable, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class StateVariable


class ConditionalDerivedVariable(NamedDimensionalVariable):
    """LEMS ComponentType for ConditionalDerivedVariable"""

    member_data_items_ = [
        MemberSpec_(
            "Case",
            "Case",
            1,
            0,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Case",
                u"name": u"Case",
                u"minOccurs": u"1",
            },
            None,
        ),
    ]
    subclass = None
    superclass = NamedDimensionalVariable

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        exposure=None,
        Case=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ConditionalDerivedVariable, self).__init__(
            name, dimension, description, exposure, **kwargs_
        )
        if Case is None:
            self.Case = []
        else:
            self.Case = Case

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConditionalDerivedVariable
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConditionalDerivedVariable.subclass:
            return ConditionalDerivedVariable.subclass(*args_, **kwargs_)
        else:
            return ConditionalDerivedVariable(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.Case or super(ConditionalDerivedVariable, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ConditionalDerivedVariable",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ConditionalDerivedVariable")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ConditionalDerivedVariable",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ConditionalDerivedVariable",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ConditionalDerivedVariable",
    ):
        super(ConditionalDerivedVariable, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ConditionalDerivedVariable",
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ConditionalDerivedVariable",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ConditionalDerivedVariable, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for Case_ in self.Case:
            Case_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Case",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(ConditionalDerivedVariable, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "Case":
            obj_ = Case.factory(parent_object_=self)
            obj_.build(child_)
            self.Case.append(obj_)
            obj_.original_tagname_ = "Case"
        super(ConditionalDerivedVariable, self).buildChildren(
            child_, node, nodeName_, True
        )


# end class ConditionalDerivedVariable


class Case(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("condition", "xs:string", 0, 1, {"use": u"optional"}),
        MemberSpec_("value", "xs:string", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, condition=None, value=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.condition = _cast(None, condition)
        self.value = _cast(None, value)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Case)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Case.subclass:
            return Case.subclass(*args_, **kwargs_)
        else:
            return Case(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Case",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Case")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Case"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Case",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Case"
    ):
        if self.condition is not None and "condition" not in already_processed:
            already_processed.add("condition")
            outfile.write(
                " condition=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.condition), input_name="condition"
                        )
                    ),
                )
            )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Case",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("condition", node)
        if value is not None and "condition" not in already_processed:
            already_processed.add("condition")
            self.condition = value
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Case


class TimeDerivative(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("variable", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("value", "xs:string", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, variable=None, value=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.variable = _cast(None, variable)
        self.value = _cast(None, value)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, TimeDerivative)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TimeDerivative.subclass:
            return TimeDerivative.subclass(*args_, **kwargs_)
        else:
            return TimeDerivative(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TimeDerivative",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TimeDerivative")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="TimeDerivative"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="TimeDerivative",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="TimeDerivative",
    ):
        if self.variable is not None and "variable" not in already_processed:
            already_processed.add("variable")
            outfile.write(
                " variable=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.variable), input_name="variable"
                        )
                    ),
                )
            )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TimeDerivative",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("variable", node)
        if value is not None and "variable" not in already_processed:
            already_processed.add("variable")
            self.variable = value
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class TimeDerivative


class IncludeType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("href", "xs:anyURI", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, href=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.href = _cast(None, href)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, IncludeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IncludeType.subclass:
            return IncludeType.subclass(*args_, **kwargs_)
        else:
            return IncludeType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IncludeType",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("IncludeType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="IncludeType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="IncludeType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="IncludeType",
    ):
        if self.href is not None and "href" not in already_processed:
            already_processed.add("href")
            outfile.write(
                " href=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.href), input_name="href"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IncludeType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("href", node)
        if value is not None and "href" not in already_processed:
            already_processed.add("href")
            self.href = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class IncludeType


class Q10ConductanceScaling(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("q10_factor", "Nml2Quantity_none", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "experimental_temp", "Nml2Quantity_temperature", 0, 0, {"use": u"required"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, q10_factor=None, experimental_temp=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.q10_factor = _cast(None, q10_factor)
        self.experimental_temp = _cast(None, experimental_temp)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Q10ConductanceScaling
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Q10ConductanceScaling.subclass:
            return Q10ConductanceScaling.subclass(*args_, **kwargs_)
        else:
            return Q10ConductanceScaling(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$"]
    ]

    def validate_Nml2Quantity_temperature(self, value):
        # Validate type Nml2Quantity_temperature, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_temperature_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_temperature_patterns_,
                    )
                )

    validate_Nml2Quantity_temperature_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(degC)$"]
    ]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Q10ConductanceScaling",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Q10ConductanceScaling")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="Q10ConductanceScaling",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Q10ConductanceScaling",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="Q10ConductanceScaling",
    ):
        if self.q10_factor is not None and "q10_factor" not in already_processed:
            already_processed.add("q10_factor")
            outfile.write(" q10Factor=%s" % (quote_attrib(self.q10_factor),))
        if (
            self.experimental_temp is not None
            and "experimental_temp" not in already_processed
        ):
            already_processed.add("experimental_temp")
            outfile.write(
                " experimentalTemp=%s" % (quote_attrib(self.experimental_temp),)
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Q10ConductanceScaling",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("q10Factor", node)
        if value is not None and "q10Factor" not in already_processed:
            already_processed.add("q10Factor")
            self.q10_factor = value
            self.validate_Nml2Quantity_none(
                self.q10_factor
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("experimentalTemp", node)
        if value is not None and "experimentalTemp" not in already_processed:
            already_processed.add("experimentalTemp")
            self.experimental_temp = value
            self.validate_Nml2Quantity_temperature(
                self.experimental_temp
            )  # validate type Nml2Quantity_temperature

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Q10ConductanceScaling


class Q10Settings(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("type", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("fixed_q10", "Nml2Quantity_none", 0, 1, {"use": u"optional"}),
        MemberSpec_("q10_factor", "Nml2Quantity_none", 0, 1, {"use": u"optional"}),
        MemberSpec_(
            "experimental_temp", "Nml2Quantity_temperature", 0, 1, {"use": u"optional"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        type=None,
        fixed_q10=None,
        q10_factor=None,
        experimental_temp=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.type = _cast(None, type)
        self.fixed_q10 = _cast(None, fixed_q10)
        self.q10_factor = _cast(None, q10_factor)
        self.experimental_temp = _cast(None, experimental_temp)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Q10Settings)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Q10Settings.subclass:
            return Q10Settings.subclass(*args_, **kwargs_)
        else:
            return Q10Settings(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$"]
    ]

    def validate_Nml2Quantity_temperature(self, value):
        # Validate type Nml2Quantity_temperature, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_temperature_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_temperature_patterns_,
                    )
                )

    validate_Nml2Quantity_temperature_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(degC)$"]
    ]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Q10Settings",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Q10Settings")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Q10Settings"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Q10Settings",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="Q10Settings",
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(" type=%s" % (quote_attrib(self.type),))
        if self.fixed_q10 is not None and "fixed_q10" not in already_processed:
            already_processed.add("fixed_q10")
            outfile.write(" fixedQ10=%s" % (quote_attrib(self.fixed_q10),))
        if self.q10_factor is not None and "q10_factor" not in already_processed:
            already_processed.add("q10_factor")
            outfile.write(" q10Factor=%s" % (quote_attrib(self.q10_factor),))
        if (
            self.experimental_temp is not None
            and "experimental_temp" not in already_processed
        ):
            already_processed.add("experimental_temp")
            outfile.write(
                " experimentalTemp=%s" % (quote_attrib(self.experimental_temp),)
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Q10Settings",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_NmlId(self.type)  # validate type NmlId
        value = find_attr_value_("fixedQ10", node)
        if value is not None and "fixedQ10" not in already_processed:
            already_processed.add("fixedQ10")
            self.fixed_q10 = value
            self.validate_Nml2Quantity_none(
                self.fixed_q10
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("q10Factor", node)
        if value is not None and "q10Factor" not in already_processed:
            already_processed.add("q10Factor")
            self.q10_factor = value
            self.validate_Nml2Quantity_none(
                self.q10_factor
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("experimentalTemp", node)
        if value is not None and "experimentalTemp" not in already_processed:
            already_processed.add("experimentalTemp")
            self.experimental_temp = value
            self.validate_Nml2Quantity_temperature(
                self.experimental_temp
            )  # validate type Nml2Quantity_temperature

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Q10Settings


class HHRate(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("type", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("rate", "Nml2Quantity_pertime", 0, 1, {"use": u"optional"}),
        MemberSpec_("midpoint", "Nml2Quantity_voltage", 0, 1, {"use": u"optional"}),
        MemberSpec_("scale", "Nml2Quantity_voltage", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, type=None, rate=None, midpoint=None, scale=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.type = _cast(None, type)
        self.rate = _cast(None, rate)
        self.midpoint = _cast(None, midpoint)
        self.scale = _cast(None, scale)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, HHRate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HHRate.subclass:
            return HHRate.subclass(*args_, **kwargs_)
        else:
            return HHRate(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_pertime_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_pertime_patterns_,
                    )
                )

    validate_Nml2Quantity_pertime_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s|per_ms|Hz)$"]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV)$"]
    ]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHRate",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("HHRate")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="HHRate"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="HHRate",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="HHRate"
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(" type=%s" % (quote_attrib(self.type),))
        if self.rate is not None and "rate" not in already_processed:
            already_processed.add("rate")
            outfile.write(" rate=%s" % (quote_attrib(self.rate),))
        if self.midpoint is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            outfile.write(" midpoint=%s" % (quote_attrib(self.midpoint),))
        if self.scale is not None and "scale" not in already_processed:
            already_processed.add("scale")
            outfile.write(" scale=%s" % (quote_attrib(self.scale),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHRate",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_NmlId(self.type)  # validate type NmlId
        value = find_attr_value_("rate", node)
        if value is not None and "rate" not in already_processed:
            already_processed.add("rate")
            self.rate = value
            self.validate_Nml2Quantity_pertime(
                self.rate
            )  # validate type Nml2Quantity_pertime
        value = find_attr_value_("midpoint", node)
        if value is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(
                self.midpoint
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("scale", node)
        if value is not None and "scale" not in already_processed:
            already_processed.add("scale")
            self.scale = value
            self.validate_Nml2Quantity_voltage(
                self.scale
            )  # validate type Nml2Quantity_voltage

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class HHRate


class HHVariable(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("type", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("rate", "xs:float", 0, 1, {"use": u"optional"}),
        MemberSpec_("midpoint", "Nml2Quantity_voltage", 0, 1, {"use": u"optional"}),
        MemberSpec_("scale", "Nml2Quantity_voltage", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, type=None, rate=None, midpoint=None, scale=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.type = _cast(None, type)
        self.rate = _cast(float, rate)
        self.midpoint = _cast(None, midpoint)
        self.scale = _cast(None, scale)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, HHVariable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HHVariable.subclass:
            return HHVariable.subclass(*args_, **kwargs_)
        else:
            return HHVariable(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV)$"]
    ]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHVariable",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("HHVariable")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="HHVariable"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="HHVariable",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="HHVariable"
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(" type=%s" % (quote_attrib(self.type),))
        if self.rate is not None and "rate" not in already_processed:
            already_processed.add("rate")
            outfile.write(
                ' rate="%s"' % self.gds_format_float(self.rate, input_name="rate")
            )
        if self.midpoint is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            outfile.write(" midpoint=%s" % (quote_attrib(self.midpoint),))
        if self.scale is not None and "scale" not in already_processed:
            already_processed.add("scale")
            outfile.write(" scale=%s" % (quote_attrib(self.scale),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHVariable",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_NmlId(self.type)  # validate type NmlId
        value = find_attr_value_("rate", node)
        if value is not None and "rate" not in already_processed:
            already_processed.add("rate")
            try:
                self.rate = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (rate): %s" % exp)
        value = find_attr_value_("midpoint", node)
        if value is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(
                self.midpoint
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("scale", node)
        if value is not None and "scale" not in already_processed:
            already_processed.add("scale")
            self.scale = value
            self.validate_Nml2Quantity_voltage(
                self.scale
            )  # validate type Nml2Quantity_voltage

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class HHVariable


class HHTime(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("type", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("rate", "Nml2Quantity_time", 0, 1, {"use": u"optional"}),
        MemberSpec_("midpoint", "Nml2Quantity_voltage", 0, 1, {"use": u"optional"}),
        MemberSpec_("scale", "Nml2Quantity_voltage", 0, 1, {"use": u"optional"}),
        MemberSpec_("tau", "Nml2Quantity_time", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, type=None, rate=None, midpoint=None, scale=None, tau=None, **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.type = _cast(None, type)
        self.rate = _cast(None, rate)
        self.midpoint = _cast(None, midpoint)
        self.scale = _cast(None, scale)
        self.tau = _cast(None, tau)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, HHTime)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HHTime.subclass:
            return HHTime.subclass(*args_, **kwargs_)
        else:
            return HHTime(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV)$"]
    ]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHTime",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("HHTime")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="HHTime"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="HHTime",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="HHTime"
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(" type=%s" % (quote_attrib(self.type),))
        if self.rate is not None and "rate" not in already_processed:
            already_processed.add("rate")
            outfile.write(" rate=%s" % (quote_attrib(self.rate),))
        if self.midpoint is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            outfile.write(" midpoint=%s" % (quote_attrib(self.midpoint),))
        if self.scale is not None and "scale" not in already_processed:
            already_processed.add("scale")
            outfile.write(" scale=%s" % (quote_attrib(self.scale),))
        if self.tau is not None and "tau" not in already_processed:
            already_processed.add("tau")
            outfile.write(" tau=%s" % (quote_attrib(self.tau),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHTime",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_NmlId(self.type)  # validate type NmlId
        value = find_attr_value_("rate", node)
        if value is not None and "rate" not in already_processed:
            already_processed.add("rate")
            self.rate = value
            self.validate_Nml2Quantity_time(
                self.rate
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("midpoint", node)
        if value is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(
                self.midpoint
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("scale", node)
        if value is not None and "scale" not in already_processed:
            already_processed.add("scale")
            self.scale = value
            self.validate_Nml2Quantity_voltage(
                self.scale
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("tau", node)
        if value is not None and "tau" not in already_processed:
            already_processed.add("tau")
            self.tau = value
            self.validate_Nml2Quantity_time(self.tau)  # validate type Nml2Quantity_time

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class HHTime


class BlockMechanism(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("type", "BlockTypes", 0, 0, {"use": u"required"}),
        MemberSpec_("species", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "block_concentration",
            "Nml2Quantity_concentration",
            0,
            0,
            {"use": u"required"},
        ),
        MemberSpec_(
            "scaling_conc", "Nml2Quantity_concentration", 0, 0, {"use": u"required"}
        ),
        MemberSpec_("scaling_volt", "Nml2Quantity_voltage", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        type=None,
        species=None,
        block_concentration=None,
        scaling_conc=None,
        scaling_volt=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.type = _cast(None, type)
        self.species = _cast(None, species)
        self.block_concentration = _cast(None, block_concentration)
        self.scaling_conc = _cast(None, scaling_conc)
        self.scaling_volt = _cast(None, scaling_volt)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, BlockMechanism)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BlockMechanism.subclass:
            return BlockMechanism.subclass(*args_, **kwargs_)
        else:
            return BlockMechanism(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_BlockTypes(self, value):
        # Validate type BlockTypes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ["voltageConcDepBlockMechanism"]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on BlockTypes'
                    % {"value": value.encode("utf-8")}
                )

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_concentration_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_concentration_patterns_,
                    )
                )

    validate_Nml2Quantity_concentration_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m3|mol_per_cm3|M|mM)$"]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV)$"]
    ]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BlockMechanism",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BlockMechanism")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BlockMechanism"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BlockMechanism",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BlockMechanism",
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(" type=%s" % (quote_attrib(self.type),))
        if self.species is not None and "species" not in already_processed:
            already_processed.add("species")
            outfile.write(" species=%s" % (quote_attrib(self.species),))
        if (
            self.block_concentration is not None
            and "block_concentration" not in already_processed
        ):
            already_processed.add("block_concentration")
            outfile.write(
                " blockConcentration=%s" % (quote_attrib(self.block_concentration),)
            )
        if self.scaling_conc is not None and "scaling_conc" not in already_processed:
            already_processed.add("scaling_conc")
            outfile.write(" scalingConc=%s" % (quote_attrib(self.scaling_conc),))
        if self.scaling_volt is not None and "scaling_volt" not in already_processed:
            already_processed.add("scaling_volt")
            outfile.write(" scalingVolt=%s" % (quote_attrib(self.scaling_volt),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BlockMechanism",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_BlockTypes(self.type)  # validate type BlockTypes
        value = find_attr_value_("species", node)
        if value is not None and "species" not in already_processed:
            already_processed.add("species")
            self.species = value
            self.validate_NmlId(self.species)  # validate type NmlId
        value = find_attr_value_("blockConcentration", node)
        if value is not None and "blockConcentration" not in already_processed:
            already_processed.add("blockConcentration")
            self.block_concentration = value
            self.validate_Nml2Quantity_concentration(
                self.block_concentration
            )  # validate type Nml2Quantity_concentration
        value = find_attr_value_("scalingConc", node)
        if value is not None and "scalingConc" not in already_processed:
            already_processed.add("scalingConc")
            self.scaling_conc = value
            self.validate_Nml2Quantity_concentration(
                self.scaling_conc
            )  # validate type Nml2Quantity_concentration
        value = find_attr_value_("scalingVolt", node)
        if value is not None and "scalingVolt" not in already_processed:
            already_processed.add("scalingVolt")
            self.scaling_volt = value
            self.validate_Nml2Quantity_voltage(
                self.scaling_volt
            )  # validate type Nml2Quantity_voltage

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class BlockMechanism


class PlasticityMechanism(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("type", "PlasticityTypes", 0, 0, {"use": u"required"}),
        MemberSpec_("init_release_prob", "ZeroToOne", 0, 0, {"use": u"required"}),
        MemberSpec_("tau_rec", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("tau_fac", "Nml2Quantity_time", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, type=None, init_release_prob=None, tau_rec=None, tau_fac=None, **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.type = _cast(None, type)
        self.init_release_prob = _cast(float, init_release_prob)
        self.tau_rec = _cast(None, tau_rec)
        self.tau_fac = _cast(None, tau_fac)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PlasticityMechanism
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PlasticityMechanism.subclass:
            return PlasticityMechanism.subclass(*args_, **kwargs_)
        else:
            return PlasticityMechanism(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_PlasticityTypes(self, value):
        # Validate type PlasticityTypes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = [
                "tsodyksMarkramDepMechanism",
                "tsodyksMarkramDepFacMechanism",
            ]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on PlasticityTypes'
                    % {"value": value.encode("utf-8")}
                )

    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd minInclusive restriction on ZeroToOne'
                    % {"value": value}
                )
            if value > 1:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd maxInclusive restriction on ZeroToOne'
                    % {"value": value}
                )

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PlasticityMechanism",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PlasticityMechanism")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="PlasticityMechanism",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PlasticityMechanism",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PlasticityMechanism",
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(" type=%s" % (quote_attrib(self.type),))
        if (
            self.init_release_prob is not None
            and "init_release_prob" not in already_processed
        ):
            already_processed.add("init_release_prob")
            outfile.write(
                " initReleaseProb=%s" % (quote_attrib(self.init_release_prob),)
            )
        if self.tau_rec is not None and "tau_rec" not in already_processed:
            already_processed.add("tau_rec")
            outfile.write(" tauRec=%s" % (quote_attrib(self.tau_rec),))
        if self.tau_fac is not None and "tau_fac" not in already_processed:
            already_processed.add("tau_fac")
            outfile.write(" tauFac=%s" % (quote_attrib(self.tau_fac),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PlasticityMechanism",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_PlasticityTypes(self.type)  # validate type PlasticityTypes
        value = find_attr_value_("initReleaseProb", node)
        if value is not None and "initReleaseProb" not in already_processed:
            already_processed.add("initReleaseProb")
            try:
                self.init_release_prob = float(value)
            except ValueError as exp:
                raise ValueError(
                    "Bad float/double attribute (initReleaseProb): %s" % exp
                )
            self.validate_ZeroToOne(self.init_release_prob)  # validate type ZeroToOne
        value = find_attr_value_("tauRec", node)
        if value is not None and "tauRec" not in already_processed:
            already_processed.add("tauRec")
            self.tau_rec = value
            self.validate_Nml2Quantity_time(
                self.tau_rec
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("tauFac", node)
        if value is not None and "tauFac" not in already_processed:
            already_processed.add("tauFac")
            self.tau_fac = value
            self.validate_Nml2Quantity_time(
                self.tau_fac
            )  # validate type Nml2Quantity_time

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class PlasticityMechanism


class SegmentParent(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("segments", "NonNegativeInteger", 0, 0, {"use": u"required"}),
        MemberSpec_("fraction_along", "ZeroToOne", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, segments=None, fraction_along="1", **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.segments = _cast(int, segments)
        self.fraction_along = _cast(float, fraction_along)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SegmentParent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SegmentParent.subclass:
            return SegmentParent.subclass(*args_, **kwargs_)
        else:
            return SegmentParent(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd minInclusive restriction on ZeroToOne'
                    % {"value": value}
                )
            if value > 1:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd maxInclusive restriction on ZeroToOne'
                    % {"value": value}
                )

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SegmentParent",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SegmentParent")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SegmentParent"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SegmentParent",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SegmentParent",
    ):
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(" segment=%s" % (quote_attrib(self.segments),))
        if self.fraction_along != 1 and "fraction_along" not in already_processed:
            already_processed.add("fraction_along")
            outfile.write(" fractionAlong=%s" % (quote_attrib(self.fraction_along),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SegmentParent",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            try:
                self.segments = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.segments < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segments
            )  # validate type NonNegativeInteger
        value = find_attr_value_("fractionAlong", node)
        if value is not None and "fractionAlong" not in already_processed:
            already_processed.add("fractionAlong")
            try:
                self.fraction_along = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (fractionAlong): %s" % exp)
            self.validate_ZeroToOne(self.fraction_along)  # validate type ZeroToOne

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class SegmentParent


class Point3DWithDiam(GeneratedsSuper):
    """A 3D point with diameter."""

    member_data_items_ = [
        MemberSpec_("x", "xs:double", 0, 0, {"use": u"required"}),
        MemberSpec_("y", "xs:double", 0, 0, {"use": u"required"}),
        MemberSpec_("z", "xs:double", 0, 0, {"use": u"required"}),
        MemberSpec_("diameter", "DoubleGreaterThanZero", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, x=None, y=None, z=None, diameter=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.x = _cast(float, x)
        self.y = _cast(float, y)
        self.z = _cast(float, z)
        self.diameter = _cast(float, diameter)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Point3DWithDiam)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Point3DWithDiam.subclass:
            return Point3DWithDiam.subclass(*args_, **kwargs_)
        else:
            return Point3DWithDiam(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_DoubleGreaterThanZero(self, value):
        # Validate type DoubleGreaterThanZero, a restriction on xs:double.
        if value is not None and Validate_simpletypes_:
            if value <= 0:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd minExclusive restriction on DoubleGreaterThanZero'
                    % {"value": value}
                )

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Point3DWithDiam",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Point3DWithDiam")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Point3DWithDiam"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Point3DWithDiam",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="Point3DWithDiam",
    ):
        if self.x is not None and "x" not in already_processed:
            already_processed.add("x")
            outfile.write(' x="%s"' % self.gds_format_double(self.x, input_name="x"))
        if self.y is not None and "y" not in already_processed:
            already_processed.add("y")
            outfile.write(' y="%s"' % self.gds_format_double(self.y, input_name="y"))
        if self.z is not None and "z" not in already_processed:
            already_processed.add("z")
            outfile.write(' z="%s"' % self.gds_format_double(self.z, input_name="z"))
        if self.diameter is not None and "diameter" not in already_processed:
            already_processed.add("diameter")
            outfile.write(" diameter=%s" % (quote_attrib(self.diameter),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Point3DWithDiam",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("x", node)
        if value is not None and "x" not in already_processed:
            already_processed.add("x")
            try:
                self.x = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (x): %s" % exp)
        value = find_attr_value_("y", node)
        if value is not None and "y" not in already_processed:
            already_processed.add("y")
            try:
                self.y = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (y): %s" % exp)
        value = find_attr_value_("z", node)
        if value is not None and "z" not in already_processed:
            already_processed.add("z")
            try:
                self.z = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (z): %s" % exp)
        value = find_attr_value_("diameter", node)
        if value is not None and "diameter" not in already_processed:
            already_processed.add("diameter")
            try:
                self.diameter = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (diameter): %s" % exp)
            self.validate_DoubleGreaterThanZero(
                self.diameter
            )  # validate type DoubleGreaterThanZero

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass

    def __str__(self):

        return (
            "("
            + str(self.x)
            + ", "
            + str(self.y)
            + ", "
            + str(self.z)
            + "), diam "
            + str(self.diameter)
            + "um"
        )

    def __repr__(self):

        return str(self)

    def distance_to(self, other_3d_point):
        """Find the distance between this point and another.

        :param other_3d_point: other 3D point to calculate distance to
        :type other_3d_point: Point3DWithDiam
        :returns: distance between the two points
        :rtype: float
        """
        a_x = self.x
        a_y = self.y
        a_z = self.z

        b_x = other_3d_point.x
        b_y = other_3d_point.y
        b_z = other_3d_point.z

        distance = ((a_x - b_x) ** 2 + (a_y - b_y) ** 2 + (a_z - b_z) ** 2) ** (0.5)
        return distance


# end class Point3DWithDiam


class ProximalDetails(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("translation_start", "xs:double", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, translation_start=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.translation_start = _cast(float, translation_start)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ProximalDetails)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ProximalDetails.subclass:
            return ProximalDetails.subclass(*args_, **kwargs_)
        else:
            return ProximalDetails(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ProximalDetails",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ProximalDetails")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ProximalDetails"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ProximalDetails",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ProximalDetails",
    ):
        if (
            self.translation_start is not None
            and "translation_start" not in already_processed
        ):
            already_processed.add("translation_start")
            outfile.write(
                ' translationStart="%s"'
                % self.gds_format_double(
                    self.translation_start, input_name="translationStart"
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ProximalDetails",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("translationStart", node)
        if value is not None and "translationStart" not in already_processed:
            already_processed.add("translationStart")
            try:
                self.translation_start = float(value)
            except ValueError as exp:
                raise ValueError(
                    "Bad float/double attribute (translationStart): %s" % exp
                )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class ProximalDetails


class DistalDetails(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("normalization_end", "xs:double", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, normalization_end=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.normalization_end = _cast(float, normalization_end)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, DistalDetails)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DistalDetails.subclass:
            return DistalDetails.subclass(*args_, **kwargs_)
        else:
            return DistalDetails(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DistalDetails",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("DistalDetails")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="DistalDetails"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="DistalDetails",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="DistalDetails",
    ):
        if (
            self.normalization_end is not None
            and "normalization_end" not in already_processed
        ):
            already_processed.add("normalization_end")
            outfile.write(
                ' normalizationEnd="%s"'
                % self.gds_format_double(
                    self.normalization_end, input_name="normalizationEnd"
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DistalDetails",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("normalizationEnd", node)
        if value is not None and "normalizationEnd" not in already_processed:
            already_processed.add("normalizationEnd")
            try:
                self.normalization_end = float(value)
            except ValueError as exp:
                raise ValueError(
                    "Bad float/double attribute (normalizationEnd): %s" % exp
                )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class DistalDetails


class Member(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("segments", "NonNegativeInteger", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, segments=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.segments = _cast(int, segments)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Member)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Member.subclass:
            return Member.subclass(*args_, **kwargs_)
        else:
            return Member(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Member",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Member")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Member"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Member",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Member"
    ):
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(" segment=%s" % (quote_attrib(self.segments),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Member",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            try:
                self.segments = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.segments < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segments
            )  # validate type NonNegativeInteger

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Member


class Include(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("segment_groups", "NmlId", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, segment_groups=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.segment_groups = _cast(None, segment_groups)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Include)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Include.subclass:
            return Include.subclass(*args_, **kwargs_)
        else:
            return Include(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Include",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Include")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Include"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Include",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Include"
    ):
        if (
            self.segment_groups is not None
            and "segment_groups" not in already_processed
        ):
            already_processed.add("segment_groups")
            outfile.write(" segmentGroup=%s" % (quote_attrib(self.segment_groups),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Include",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Include


class Path(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_(
            "from_",
            "SegmentEndPoint",
            0,
            1,
            {u"type": u"SegmentEndPoint", u"name": u"from", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "to",
            "SegmentEndPoint",
            0,
            1,
            {u"type": u"SegmentEndPoint", u"name": u"to", u"minOccurs": u"0"},
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, from_=None, to=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.from_ = from_
        self.to = to

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Path)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Path.subclass:
            return Path.subclass(*args_, **kwargs_)
        else:
            return Path(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.from_ is not None or self.to is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Path",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Path")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Path"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Path",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Path"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Path",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.from_ is not None:
            self.from_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="from",
                pretty_print=pretty_print,
            )
        if self.to is not None:
            self.to.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="to",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "from":
            obj_ = SegmentEndPoint.factory(parent_object_=self)
            obj_.build(child_)
            self.from_ = obj_
            obj_.original_tagname_ = "from"
        elif nodeName_ == "to":
            obj_ = SegmentEndPoint.factory(parent_object_=self)
            obj_.build(child_)
            self.to = obj_
            obj_.original_tagname_ = "to"


# end class Path


class SubTree(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_(
            "from_",
            "SegmentEndPoint",
            0,
            1,
            {u"type": u"SegmentEndPoint", u"name": u"from", u"minOccurs": u"0"},
            3,
        ),
        MemberSpec_(
            "to",
            "SegmentEndPoint",
            0,
            1,
            {u"type": u"SegmentEndPoint", u"name": u"to", u"minOccurs": u"0"},
            3,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, from_=None, to=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.from_ = from_
        self.to = to

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SubTree)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SubTree.subclass:
            return SubTree.subclass(*args_, **kwargs_)
        else:
            return SubTree(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.from_ is not None or self.to is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SubTree",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SubTree")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SubTree"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SubTree",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="SubTree"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SubTree",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.from_ is not None:
            self.from_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="from",
                pretty_print=pretty_print,
            )
        if self.to is not None:
            self.to.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="to",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "from":
            obj_ = SegmentEndPoint.factory(parent_object_=self)
            obj_.build(child_)
            self.from_ = obj_
            obj_.original_tagname_ = "from"
        elif nodeName_ == "to":
            obj_ = SegmentEndPoint.factory(parent_object_=self)
            obj_.build(child_)
            self.to = obj_
            obj_.original_tagname_ = "to"


# end class SubTree


class SegmentEndPoint(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("segments", "NonNegativeInteger", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, segments=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.segments = _cast(int, segments)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SegmentEndPoint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SegmentEndPoint.subclass:
            return SegmentEndPoint.subclass(*args_, **kwargs_)
        else:
            return SegmentEndPoint(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SegmentEndPoint",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SegmentEndPoint")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SegmentEndPoint"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SegmentEndPoint",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SegmentEndPoint",
    ):
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(" segment=%s" % (quote_attrib(self.segments),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SegmentEndPoint",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            try:
                self.segments = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.segments < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segments
            )  # validate type NonNegativeInteger

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class SegmentEndPoint


class MembraneProperties(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_(
            "channel_populations",
            "ChannelPopulation",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ChannelPopulation",
                u"name": u"channelPopulation",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "channel_densities",
            "ChannelDensity",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ChannelDensity",
                u"name": u"channelDensity",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_v_shifts",
            "ChannelDensityVShift",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ChannelDensityVShift",
                u"name": u"channelDensityVShift",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_nernsts",
            "ChannelDensityNernst",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ChannelDensityNernst",
                u"name": u"channelDensityNernst",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_ghks",
            "ChannelDensityGHK",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ChannelDensityGHK",
                u"name": u"channelDensityGHK",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_ghk2s",
            "ChannelDensityGHK2",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ChannelDensityGHK2",
                u"name": u"channelDensityGHK2",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_non_uniforms",
            "ChannelDensityNonUniform",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ChannelDensityNonUniform",
                u"name": u"channelDensityNonUniform",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_non_uniform_nernsts",
            "ChannelDensityNonUniformNernst",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ChannelDensityNonUniformNernst",
                u"name": u"channelDensityNonUniformNernst",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_non_uniform_ghks",
            "ChannelDensityNonUniformGHK",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ChannelDensityNonUniformGHK",
                u"name": u"channelDensityNonUniformGHK",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "spike_threshes",
            "SpikeThresh",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SpikeThresh",
                u"name": u"spikeThresh",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "specific_capacitances",
            "SpecificCapacitance",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SpecificCapacitance",
                u"name": u"specificCapacitance",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "init_memb_potentials",
            "InitMembPotential",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"InitMembPotential",
                u"name": u"initMembPotential",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        channel_populations=None,
        channel_densities=None,
        channel_density_v_shifts=None,
        channel_density_nernsts=None,
        channel_density_ghks=None,
        channel_density_ghk2s=None,
        channel_density_non_uniforms=None,
        channel_density_non_uniform_nernsts=None,
        channel_density_non_uniform_ghks=None,
        spike_threshes=None,
        specific_capacitances=None,
        init_memb_potentials=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        if channel_populations is None:
            self.channel_populations = []
        else:
            self.channel_populations = channel_populations
        if channel_densities is None:
            self.channel_densities = []
        else:
            self.channel_densities = channel_densities
        if channel_density_v_shifts is None:
            self.channel_density_v_shifts = []
        else:
            self.channel_density_v_shifts = channel_density_v_shifts
        if channel_density_nernsts is None:
            self.channel_density_nernsts = []
        else:
            self.channel_density_nernsts = channel_density_nernsts
        if channel_density_ghks is None:
            self.channel_density_ghks = []
        else:
            self.channel_density_ghks = channel_density_ghks
        if channel_density_ghk2s is None:
            self.channel_density_ghk2s = []
        else:
            self.channel_density_ghk2s = channel_density_ghk2s
        if channel_density_non_uniforms is None:
            self.channel_density_non_uniforms = []
        else:
            self.channel_density_non_uniforms = channel_density_non_uniforms
        if channel_density_non_uniform_nernsts is None:
            self.channel_density_non_uniform_nernsts = []
        else:
            self.channel_density_non_uniform_nernsts = (
                channel_density_non_uniform_nernsts
            )
        if channel_density_non_uniform_ghks is None:
            self.channel_density_non_uniform_ghks = []
        else:
            self.channel_density_non_uniform_ghks = channel_density_non_uniform_ghks
        if spike_threshes is None:
            self.spike_threshes = []
        else:
            self.spike_threshes = spike_threshes
        if specific_capacitances is None:
            self.specific_capacitances = []
        else:
            self.specific_capacitances = specific_capacitances
        if init_memb_potentials is None:
            self.init_memb_potentials = []
        else:
            self.init_memb_potentials = init_memb_potentials
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MembraneProperties
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MembraneProperties.subclass:
            return MembraneProperties.subclass(*args_, **kwargs_)
        else:
            return MembraneProperties(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.channel_populations
            or self.channel_densities
            or self.channel_density_v_shifts
            or self.channel_density_nernsts
            or self.channel_density_ghks
            or self.channel_density_ghk2s
            or self.channel_density_non_uniforms
            or self.channel_density_non_uniform_nernsts
            or self.channel_density_non_uniform_ghks
            or self.spike_threshes
            or self.specific_capacitances
            or self.init_memb_potentials
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="MembraneProperties",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("MembraneProperties")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="MembraneProperties",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="MembraneProperties",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="MembraneProperties",
    ):
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="MembraneProperties",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for channelPopulation_ in self.channel_populations:
            channelPopulation_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelPopulation",
                pretty_print=pretty_print,
            )
        for channelDensity_ in self.channel_densities:
            channelDensity_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensity",
                pretty_print=pretty_print,
            )
        for channelDensityVShift_ in self.channel_density_v_shifts:
            channelDensityVShift_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityVShift",
                pretty_print=pretty_print,
            )
        for channelDensityNernst_ in self.channel_density_nernsts:
            channelDensityNernst_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityNernst",
                pretty_print=pretty_print,
            )
        for channelDensityGHK_ in self.channel_density_ghks:
            channelDensityGHK_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityGHK",
                pretty_print=pretty_print,
            )
        for channelDensityGHK2_ in self.channel_density_ghk2s:
            channelDensityGHK2_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityGHK2",
                pretty_print=pretty_print,
            )
        for channelDensityNonUniform_ in self.channel_density_non_uniforms:
            channelDensityNonUniform_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityNonUniform",
                pretty_print=pretty_print,
            )
        for channelDensityNonUniformNernst_ in self.channel_density_non_uniform_nernsts:
            channelDensityNonUniformNernst_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityNonUniformNernst",
                pretty_print=pretty_print,
            )
        for channelDensityNonUniformGHK_ in self.channel_density_non_uniform_ghks:
            channelDensityNonUniformGHK_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityNonUniformGHK",
                pretty_print=pretty_print,
            )
        for spikeThresh_ in self.spike_threshes:
            spikeThresh_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="spikeThresh",
                pretty_print=pretty_print,
            )
        for specificCapacitance_ in self.specific_capacitances:
            specificCapacitance_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="specificCapacitance",
                pretty_print=pretty_print,
            )
        for initMembPotential_ in self.init_memb_potentials:
            initMembPotential_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="initMembPotential",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "channelPopulation":
            obj_ = ChannelPopulation.factory(parent_object_=self)
            obj_.build(child_)
            self.channel_populations.append(obj_)
            obj_.original_tagname_ = "channelPopulation"
        elif nodeName_ == "channelDensity":
            class_obj_ = self.get_class_obj_(child_, ChannelDensity)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.channel_densities.append(obj_)
            obj_.original_tagname_ = "channelDensity"
        elif nodeName_ == "channelDensityVShift":
            obj_ = ChannelDensityVShift.factory(parent_object_=self)
            obj_.build(child_)
            self.channel_density_v_shifts.append(obj_)
            obj_.original_tagname_ = "channelDensityVShift"
        elif nodeName_ == "channelDensityNernst":
            class_obj_ = self.get_class_obj_(child_, ChannelDensityNernst)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.channel_density_nernsts.append(obj_)
            obj_.original_tagname_ = "channelDensityNernst"
        elif nodeName_ == "channelDensityGHK":
            obj_ = ChannelDensityGHK.factory(parent_object_=self)
            obj_.build(child_)
            self.channel_density_ghks.append(obj_)
            obj_.original_tagname_ = "channelDensityGHK"
        elif nodeName_ == "channelDensityGHK2":
            obj_ = ChannelDensityGHK2.factory(parent_object_=self)
            obj_.build(child_)
            self.channel_density_ghk2s.append(obj_)
            obj_.original_tagname_ = "channelDensityGHK2"
        elif nodeName_ == "channelDensityNonUniform":
            obj_ = ChannelDensityNonUniform.factory(parent_object_=self)
            obj_.build(child_)
            self.channel_density_non_uniforms.append(obj_)
            obj_.original_tagname_ = "channelDensityNonUniform"
        elif nodeName_ == "channelDensityNonUniformNernst":
            obj_ = ChannelDensityNonUniformNernst.factory(parent_object_=self)
            obj_.build(child_)
            self.channel_density_non_uniform_nernsts.append(obj_)
            obj_.original_tagname_ = "channelDensityNonUniformNernst"
        elif nodeName_ == "channelDensityNonUniformGHK":
            obj_ = ChannelDensityNonUniformGHK.factory(parent_object_=self)
            obj_.build(child_)
            self.channel_density_non_uniform_ghks.append(obj_)
            obj_.original_tagname_ = "channelDensityNonUniformGHK"
        elif nodeName_ == "spikeThresh":
            obj_ = SpikeThresh.factory(parent_object_=self)
            obj_.build(child_)
            self.spike_threshes.append(obj_)
            obj_.original_tagname_ = "spikeThresh"
        elif nodeName_ == "specificCapacitance":
            obj_ = SpecificCapacitance.factory(parent_object_=self)
            obj_.build(child_)
            self.specific_capacitances.append(obj_)
            obj_.original_tagname_ = "specificCapacitance"
        elif nodeName_ == "initMembPotential":
            obj_ = InitMembPotential.factory(parent_object_=self)
            obj_.build(child_)
            self.init_memb_potentials.append(obj_)
            obj_.original_tagname_ = "initMembPotential"


# end class MembraneProperties


class MembraneProperties2CaPools(MembraneProperties):
    member_data_items_ = [
        MemberSpec_(
            "channel_density_nernst_ca2s",
            "ChannelDensityNernstCa2",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ChannelDensityNernstCa2",
                u"name": u"channelDensityNernstCa2",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = MembraneProperties

    def __init__(
        self,
        channel_populations=None,
        channel_densities=None,
        channel_density_v_shifts=None,
        channel_density_nernsts=None,
        channel_density_ghks=None,
        channel_density_ghk2s=None,
        channel_density_non_uniforms=None,
        channel_density_non_uniform_nernsts=None,
        channel_density_non_uniform_ghks=None,
        spike_threshes=None,
        specific_capacitances=None,
        init_memb_potentials=None,
        channel_density_nernst_ca2s=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(MembraneProperties2CaPools, self).__init__(
            channel_populations,
            channel_densities,
            channel_density_v_shifts,
            channel_density_nernsts,
            channel_density_ghks,
            channel_density_ghk2s,
            channel_density_non_uniforms,
            channel_density_non_uniform_nernsts,
            channel_density_non_uniform_ghks,
            spike_threshes,
            specific_capacitances,
            init_memb_potentials,
            **kwargs_
        )
        if channel_density_nernst_ca2s is None:
            self.channel_density_nernst_ca2s = []
        else:
            self.channel_density_nernst_ca2s = channel_density_nernst_ca2s

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MembraneProperties2CaPools
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MembraneProperties2CaPools.subclass:
            return MembraneProperties2CaPools.subclass(*args_, **kwargs_)
        else:
            return MembraneProperties2CaPools(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.channel_density_nernst_ca2s
            or super(MembraneProperties2CaPools, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="MembraneProperties2CaPools",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("MembraneProperties2CaPools")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="MembraneProperties2CaPools",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="MembraneProperties2CaPools",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="MembraneProperties2CaPools",
    ):
        super(MembraneProperties2CaPools, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="MembraneProperties2CaPools",
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="MembraneProperties2CaPools",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(MembraneProperties2CaPools, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for channelDensityNernstCa2_ in self.channel_density_nernst_ca2s:
            channelDensityNernstCa2_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityNernstCa2",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(MembraneProperties2CaPools, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "channelDensityNernstCa2":
            obj_ = ChannelDensityNernstCa2.factory(parent_object_=self)
            obj_.build(child_)
            self.channel_density_nernst_ca2s.append(obj_)
            obj_.original_tagname_ = "channelDensityNernstCa2"
        super(MembraneProperties2CaPools, self).buildChildren(
            child_, node, nodeName_, True
        )


# end class MembraneProperties2CaPools


class SpikeThresh(GeneratedsSuper):
    """Membrane potential at which to emit a spiking event. Note, usually
    the spiking event will not be emitted again until the membrane
    potential has fallen below this value and rises again to cross
    it in a positive direction."""

    member_data_items_ = [
        MemberSpec_("value", "Nml2Quantity_voltage", 0, 0, {"use": u"required"}),
        MemberSpec_("segment_groups", "NmlId", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, value=None, segment_groups="all", **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.value = _cast(None, value)
        self.segment_groups = _cast(None, segment_groups)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SpikeThresh)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeThresh.subclass:
            return SpikeThresh.subclass(*args_, **kwargs_)
        else:
            return SpikeThresh(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV)$"]
    ]

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeThresh",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeThresh")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpikeThresh"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeThresh",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpikeThresh",
    ):
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(" value=%s" % (quote_attrib(self.value),))
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(" segmentGroup=%s" % (quote_attrib(self.segment_groups),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeThresh",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
            self.validate_Nml2Quantity_voltage(
                self.value
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class SpikeThresh


class SpecificCapacitance(GeneratedsSuper):
    """Capacitance per unit area"""

    member_data_items_ = [
        MemberSpec_(
            "value", "Nml2Quantity_specificCapacitance", 0, 0, {"use": u"required"}
        ),
        MemberSpec_("segment_groups", "NmlId", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, value=None, segment_groups="all", **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.value = _cast(None, value)
        self.segment_groups = _cast(None, segment_groups)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpecificCapacitance
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpecificCapacitance.subclass:
            return SpecificCapacitance.subclass(*args_, **kwargs_)
        else:
            return SpecificCapacitance(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_specificCapacitance(self, value):
        # Validate type Nml2Quantity_specificCapacitance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_specificCapacitance_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_specificCapacitance_patterns_,
                    )
                )

    validate_Nml2Quantity_specificCapacitance_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(F_per_m2|uF_per_cm2)$"]
    ]

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpecificCapacitance",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpecificCapacitance")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpecificCapacitance",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpecificCapacitance",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpecificCapacitance",
    ):
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(" value=%s" % (quote_attrib(self.value),))
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(" segmentGroup=%s" % (quote_attrib(self.segment_groups),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpecificCapacitance",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
            self.validate_Nml2Quantity_specificCapacitance(
                self.value
            )  # validate type Nml2Quantity_specificCapacitance
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class SpecificCapacitance


class InitMembPotential(GeneratedsSuper):
    """Explicitly set initial membrane potential for the cell"""

    member_data_items_ = [
        MemberSpec_("value", "Nml2Quantity_voltage", 0, 0, {"use": u"required"}),
        MemberSpec_("segment_groups", "NmlId", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, value=None, segment_groups="all", **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.value = _cast(None, value)
        self.segment_groups = _cast(None, segment_groups)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, InitMembPotential)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InitMembPotential.subclass:
            return InitMembPotential.subclass(*args_, **kwargs_)
        else:
            return InitMembPotential(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV)$"]
    ]

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InitMembPotential",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InitMembPotential")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="InitMembPotential",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InitMembPotential",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="InitMembPotential",
    ):
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(" value=%s" % (quote_attrib(self.value),))
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(" segmentGroup=%s" % (quote_attrib(self.segment_groups),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InitMembPotential",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
            self.validate_Nml2Quantity_voltage(
                self.value
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class InitMembPotential


class Resistivity(GeneratedsSuper):
    """The resistivity, or specific axial resistance, of the cytoplasm"""

    member_data_items_ = [
        MemberSpec_("value", "Nml2Quantity_resistivity", 0, 0, {"use": u"required"}),
        MemberSpec_("segment_groups", "NmlId", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, value=None, segment_groups="all", **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.value = _cast(None, value)
        self.segment_groups = _cast(None, segment_groups)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Resistivity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Resistivity.subclass:
            return Resistivity.subclass(*args_, **kwargs_)
        else:
            return Resistivity(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_resistivity(self, value):
        # Validate type Nml2Quantity_resistivity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_resistivity_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_resistivity_patterns_,
                    )
                )

    validate_Nml2Quantity_resistivity_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(ohm_cm|kohm_cm|ohm_m)$"]
    ]

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Resistivity",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Resistivity")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Resistivity"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Resistivity",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="Resistivity",
    ):
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(" value=%s" % (quote_attrib(self.value),))
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(" segmentGroup=%s" % (quote_attrib(self.segment_groups),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Resistivity",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
            self.validate_Nml2Quantity_resistivity(
                self.value
            )  # validate type Nml2Quantity_resistivity
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Resistivity


class VariableParameter(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("parameter", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("segment_groups", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "inhomogeneous_value",
            "InhomogeneousValue",
            0,
            1,
            {
                u"type": u"InhomogeneousValue",
                u"name": u"inhomogeneousValue",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, parameter=None, segment_groups=None, inhomogeneous_value=None, **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.parameter = _cast(None, parameter)
        self.segment_groups = _cast(None, segment_groups)
        self.inhomogeneous_value = inhomogeneous_value

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, VariableParameter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VariableParameter.subclass:
            return VariableParameter.subclass(*args_, **kwargs_)
        else:
            return VariableParameter(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.inhomogeneous_value is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="VariableParameter",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("VariableParameter")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="VariableParameter",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="VariableParameter",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="VariableParameter",
    ):
        if self.parameter is not None and "parameter" not in already_processed:
            already_processed.add("parameter")
            outfile.write(
                " parameter=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.parameter), input_name="parameter"
                        )
                    ),
                )
            )
        if (
            self.segment_groups is not None
            and "segment_groups" not in already_processed
        ):
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="VariableParameter",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.inhomogeneous_value is not None:
            self.inhomogeneous_value.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="inhomogeneousValue",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("parameter", node)
        if value is not None and "parameter" not in already_processed:
            already_processed.add("parameter")
            self.parameter = value
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "inhomogeneousValue":
            obj_ = InhomogeneousValue.factory(parent_object_=self)
            obj_.build(child_)
            self.inhomogeneous_value = obj_
            obj_.original_tagname_ = "inhomogeneousValue"


# end class VariableParameter


class InhomogeneousValue(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_(
            "inhomogeneous_parameters", "xs:string", 0, 0, {"use": u"required"}
        ),
        MemberSpec_("value", "xs:string", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, inhomogeneous_parameters=None, value=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.inhomogeneous_parameters = _cast(None, inhomogeneous_parameters)
        self.value = _cast(None, value)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InhomogeneousValue
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InhomogeneousValue.subclass:
            return InhomogeneousValue.subclass(*args_, **kwargs_)
        else:
            return InhomogeneousValue(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InhomogeneousValue",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InhomogeneousValue")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="InhomogeneousValue",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InhomogeneousValue",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="InhomogeneousValue",
    ):
        if (
            self.inhomogeneous_parameters is not None
            and "inhomogeneous_parameters" not in already_processed
        ):
            already_processed.add("inhomogeneous_parameters")
            outfile.write(
                " inhomogeneousParameter=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.inhomogeneous_parameters),
                            input_name="inhomogeneousParameter",
                        )
                    ),
                )
            )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InhomogeneousValue",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("inhomogeneousParameter", node)
        if value is not None and "inhomogeneousParameter" not in already_processed:
            already_processed.add("inhomogeneousParameter")
            self.inhomogeneous_parameters = value
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class InhomogeneousValue


class Species(GeneratedsSuper):
    """Specifying the ion here again is redundant, the ion name should be
    the same as id. Kept for now until LEMS implementation can
    select by id. TODO: remove."""

    member_data_items_ = [
        MemberSpec_("id", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("concentration_model", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("ion", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_(
            "initial_concentration",
            "Nml2Quantity_concentration",
            0,
            0,
            {"use": u"required"},
        ),
        MemberSpec_(
            "initial_ext_concentration",
            "Nml2Quantity_concentration",
            0,
            0,
            {"use": u"required"},
        ),
        MemberSpec_("segment_groups", "NmlId", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        id=None,
        concentration_model=None,
        ion=None,
        initial_concentration=None,
        initial_ext_concentration=None,
        segment_groups="all",
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.id = _cast(None, id)
        self.concentration_model = _cast(None, concentration_model)
        self.ion = _cast(None, ion)
        self.initial_concentration = _cast(None, initial_concentration)
        self.initial_ext_concentration = _cast(None, initial_ext_concentration)
        self.segment_groups = _cast(None, segment_groups)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Species)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Species.subclass:
            return Species.subclass(*args_, **kwargs_)
        else:
            return Species(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_concentration_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_concentration_patterns_,
                    )
                )

    validate_Nml2Quantity_concentration_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m3|mol_per_cm3|M|mM)$"]
    ]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Species",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Species")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Species"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Species",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Species"
    ):
        if self.id is not None and "id" not in already_processed:
            already_processed.add("id")
            outfile.write(" id=%s" % (quote_attrib(self.id),))
        if (
            self.concentration_model is not None
            and "concentration_model" not in already_processed
        ):
            already_processed.add("concentration_model")
            outfile.write(
                " concentrationModel=%s" % (quote_attrib(self.concentration_model),)
            )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(" ion=%s" % (quote_attrib(self.ion),))
        if (
            self.initial_concentration is not None
            and "initial_concentration" not in already_processed
        ):
            already_processed.add("initial_concentration")
            outfile.write(
                " initialConcentration=%s" % (quote_attrib(self.initial_concentration),)
            )
        if (
            self.initial_ext_concentration is not None
            and "initial_ext_concentration" not in already_processed
        ):
            already_processed.add("initial_ext_concentration")
            outfile.write(
                " initialExtConcentration=%s"
                % (quote_attrib(self.initial_ext_concentration),)
            )
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(" segmentGroup=%s" % (quote_attrib(self.segment_groups),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Species",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("id", node)
        if value is not None and "id" not in already_processed:
            already_processed.add("id")
            self.id = value
            self.validate_NmlId(self.id)  # validate type NmlId
        value = find_attr_value_("concentrationModel", node)
        if value is not None and "concentrationModel" not in already_processed:
            already_processed.add("concentrationModel")
            self.concentration_model = value
            self.validate_NmlId(self.concentration_model)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        value = find_attr_value_("initialConcentration", node)
        if value is not None and "initialConcentration" not in already_processed:
            already_processed.add("initialConcentration")
            self.initial_concentration = value
            self.validate_Nml2Quantity_concentration(
                self.initial_concentration
            )  # validate type Nml2Quantity_concentration
        value = find_attr_value_("initialExtConcentration", node)
        if value is not None and "initialExtConcentration" not in already_processed:
            already_processed.add("initialExtConcentration")
            self.initial_ext_concentration = value
            self.validate_Nml2Quantity_concentration(
                self.initial_ext_concentration
            )  # validate type Nml2Quantity_concentration
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Species


class IntracellularProperties(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_(
            "species",
            "Species",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Species",
                u"name": u"species",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "resistivities",
            "Resistivity",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Resistivity",
                u"name": u"resistivity",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, species=None, resistivities=None, extensiontype_=None, **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        if species is None:
            self.species = []
        else:
            self.species = species
        if resistivities is None:
            self.resistivities = []
        else:
            self.resistivities = resistivities
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IntracellularProperties
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IntracellularProperties.subclass:
            return IntracellularProperties.subclass(*args_, **kwargs_)
        else:
            return IntracellularProperties(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.species or self.resistivities:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IntracellularProperties",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("IntracellularProperties")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="IntracellularProperties",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="IntracellularProperties",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="IntracellularProperties",
    ):
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IntracellularProperties",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for species_ in self.species:
            species_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="species",
                pretty_print=pretty_print,
            )
        for resistivity_ in self.resistivities:
            resistivity_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="resistivity",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "species":
            obj_ = Species.factory(parent_object_=self)
            obj_.build(child_)
            self.species.append(obj_)
            obj_.original_tagname_ = "species"
        elif nodeName_ == "resistivity":
            obj_ = Resistivity.factory(parent_object_=self)
            obj_.build(child_)
            self.resistivities.append(obj_)
            obj_.original_tagname_ = "resistivity"


# end class IntracellularProperties


class IntracellularProperties2CaPools(IntracellularProperties):
    member_data_items_ = []
    subclass = None
    superclass = IntracellularProperties

    def __init__(self, species=None, resistivities=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(IntracellularProperties2CaPools, self).__init__(
            species, resistivities, **kwargs_
        )

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IntracellularProperties2CaPools
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IntracellularProperties2CaPools.subclass:
            return IntracellularProperties2CaPools.subclass(*args_, **kwargs_)
        else:
            return IntracellularProperties2CaPools(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(IntracellularProperties2CaPools, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IntracellularProperties2CaPools",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "IntracellularProperties2CaPools"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="IntracellularProperties2CaPools",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="IntracellularProperties2CaPools",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="IntracellularProperties2CaPools",
    ):
        super(IntracellularProperties2CaPools, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="IntracellularProperties2CaPools",
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IntracellularProperties2CaPools",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(IntracellularProperties2CaPools, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(IntracellularProperties2CaPools, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IntracellularProperties2CaPools, self).buildChildren(
            child_, node, nodeName_, True
        )
        pass


# end class IntracellularProperties2CaPools


class ExtracellularPropertiesLocal(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_(
            "species",
            "Species",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Species",
                u"name": u"species",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, species=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        if species is None:
            self.species = []
        else:
            self.species = species

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExtracellularPropertiesLocal
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExtracellularPropertiesLocal.subclass:
            return ExtracellularPropertiesLocal.subclass(*args_, **kwargs_)
        else:
            return ExtracellularPropertiesLocal(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.species:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ExtracellularPropertiesLocal",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ExtracellularPropertiesLocal")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ExtracellularPropertiesLocal",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ExtracellularPropertiesLocal",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ExtracellularPropertiesLocal",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ExtracellularPropertiesLocal",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for species_ in self.species:
            species_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="species",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "species":
            obj_ = Species.factory(parent_object_=self)
            obj_.build(child_)
            self.species.append(obj_)
            obj_.original_tagname_ = "species"


# end class ExtracellularPropertiesLocal


class SpaceStructure(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("x_spacing", "xs:float", 0, 1, {"use": "optional"}),
        MemberSpec_("y_spacing", "xs:float", 0, 1, {"use": u"optional"}),
        MemberSpec_("z_spacing", "xs:float", 0, 1, {"use": u"optional"}),
        MemberSpec_("x_start", "xs:float", 0, 1, {"use": u"optional"}),
        MemberSpec_("y_start", "xs:float", 0, 1, {"use": u"optional"}),
        MemberSpec_("z_start", "xs:float", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        x_spacing=None,
        y_spacing=None,
        z_spacing=None,
        x_start=0,
        y_start=0,
        z_start=0,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.x_spacing = _cast(float, x_spacing)
        self.y_spacing = _cast(float, y_spacing)
        self.z_spacing = _cast(float, z_spacing)
        self.x_start = _cast(float, x_start)
        self.y_start = _cast(float, y_start)
        self.z_start = _cast(float, z_start)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SpaceStructure)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpaceStructure.subclass:
            return SpaceStructure.subclass(*args_, **kwargs_)
        else:
            return SpaceStructure(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpaceStructure",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpaceStructure")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpaceStructure"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpaceStructure",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpaceStructure",
    ):
        if self.x_spacing is not None and "x_spacing" not in already_processed:
            already_processed.add("x_spacing")
            outfile.write(
                ' xSpacing="%s"'
                % self.gds_format_float(self.x_spacing, input_name="xSpacing")
            )
        if self.y_spacing is not None and "y_spacing" not in already_processed:
            already_processed.add("y_spacing")
            outfile.write(
                ' ySpacing="%s"'
                % self.gds_format_float(self.y_spacing, input_name="ySpacing")
            )
        if self.z_spacing is not None and "z_spacing" not in already_processed:
            already_processed.add("z_spacing")
            outfile.write(
                ' zSpacing="%s"'
                % self.gds_format_float(self.z_spacing, input_name="zSpacing")
            )
        if self.x_start != 0 and "x_start" not in already_processed:
            already_processed.add("x_start")
            outfile.write(
                ' xStart="%s"'
                % self.gds_format_float(self.x_start, input_name="xStart")
            )
        if self.y_start != 0 and "y_start" not in already_processed:
            already_processed.add("y_start")
            outfile.write(
                ' yStart="%s"'
                % self.gds_format_float(self.y_start, input_name="yStart")
            )
        if self.z_start != 0 and "z_start" not in already_processed:
            already_processed.add("z_start")
            outfile.write(
                ' zStart="%s"'
                % self.gds_format_float(self.z_start, input_name="zStart")
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpaceStructure",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xSpacing", node)
        if value is not None and "xSpacing" not in already_processed:
            already_processed.add("xSpacing")
            try:
                self.x_spacing = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (xSpacing): %s" % exp)
        value = find_attr_value_("ySpacing", node)
        if value is not None and "ySpacing" not in already_processed:
            already_processed.add("ySpacing")
            try:
                self.y_spacing = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (ySpacing): %s" % exp)
        value = find_attr_value_("zSpacing", node)
        if value is not None and "zSpacing" not in already_processed:
            already_processed.add("zSpacing")
            try:
                self.z_spacing = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (zSpacing): %s" % exp)
        value = find_attr_value_("xStart", node)
        if value is not None and "xStart" not in already_processed:
            already_processed.add("xStart")
            try:
                self.x_start = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (xStart): %s" % exp)
        value = find_attr_value_("yStart", node)
        if value is not None and "yStart" not in already_processed:
            already_processed.add("yStart")
            try:
                self.y_start = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (yStart): %s" % exp)
        value = find_attr_value_("zStart", node)
        if value is not None and "zStart" not in already_processed:
            already_processed.add("zStart")
            try:
                self.z_start = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (zStart): %s" % exp)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class SpaceStructure


class Layout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("spaces", "NmlId", 0, 1, {"use": "optional"}),
        MemberSpec_(
            "random",
            "RandomLayout",
            0,
            0,
            {u"type": u"RandomLayout", u"name": u"random"},
            5,
        ),
        MemberSpec_(
            "grid", "GridLayout", 0, 0, {u"type": u"GridLayout", u"name": u"grid"}, 5
        ),
        MemberSpec_(
            "unstructured",
            "UnstructuredLayout",
            0,
            0,
            {u"type": u"UnstructuredLayout", u"name": u"unstructured"},
            5,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, spaces=None, random=None, grid=None, unstructured=None, **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.spaces = _cast(None, spaces)
        self.random = random
        self.grid = grid
        self.unstructured = unstructured

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Layout)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Layout.subclass:
            return Layout.subclass(*args_, **kwargs_)
        else:
            return Layout(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if (
            self.random is not None
            or self.grid is not None
            or self.unstructured is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Layout",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Layout")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Layout"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Layout",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Layout"
    ):
        if self.spaces is not None and "spaces" not in already_processed:
            already_processed.add("spaces")
            outfile.write(" space=%s" % (quote_attrib(self.spaces),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Layout",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.random is not None:
            self.random.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="random",
                pretty_print=pretty_print,
            )
        if self.grid is not None:
            self.grid.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="grid",
                pretty_print=pretty_print,
            )
        if self.unstructured is not None:
            self.unstructured.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="unstructured",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("space", node)
        if value is not None and "space" not in already_processed:
            already_processed.add("space")
            self.spaces = value
            self.validate_NmlId(self.spaces)  # validate type NmlId

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "random":
            obj_ = RandomLayout.factory(parent_object_=self)
            obj_.build(child_)
            self.random = obj_
            obj_.original_tagname_ = "random"
        elif nodeName_ == "grid":
            obj_ = GridLayout.factory(parent_object_=self)
            obj_.build(child_)
            self.grid = obj_
            obj_.original_tagname_ = "grid"
        elif nodeName_ == "unstructured":
            obj_ = UnstructuredLayout.factory(parent_object_=self)
            obj_.build(child_)
            self.unstructured = obj_
            obj_.original_tagname_ = "unstructured"


# end class Layout


class UnstructuredLayout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("number", "xs:nonNegativeInteger", 0, 1, {"use": "optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, number=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.number = _cast(int, number)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UnstructuredLayout
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UnstructuredLayout.subclass:
            return UnstructuredLayout.subclass(*args_, **kwargs_)
        else:
            return UnstructuredLayout(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="UnstructuredLayout",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("UnstructuredLayout")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="UnstructuredLayout",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="UnstructuredLayout",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="UnstructuredLayout",
    ):
        if self.number is not None and "number" not in already_processed:
            already_processed.add("number")
            outfile.write(
                ' number="%s"'
                % self.gds_format_integer(self.number, input_name="number")
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="UnstructuredLayout",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("number", node)
        if value is not None and "number" not in already_processed:
            already_processed.add("number")
            try:
                self.number = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.number < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class UnstructuredLayout


class RandomLayout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("number", "xs:nonNegativeInteger", 0, 1, {"use": "optional"}),
        MemberSpec_("regions", "NmlId", 0, 1, {"use": "optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, number=None, regions=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.number = _cast(int, number)
        self.regions = _cast(None, regions)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, RandomLayout)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RandomLayout.subclass:
            return RandomLayout.subclass(*args_, **kwargs_)
        else:
            return RandomLayout(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RandomLayout",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("RandomLayout")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="RandomLayout"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="RandomLayout",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="RandomLayout",
    ):
        if self.number is not None and "number" not in already_processed:
            already_processed.add("number")
            outfile.write(
                ' number="%s"'
                % self.gds_format_integer(self.number, input_name="number")
            )
        if self.regions is not None and "regions" not in already_processed:
            already_processed.add("regions")
            outfile.write(" region=%s" % (quote_attrib(self.regions),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RandomLayout",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("number", node)
        if value is not None and "number" not in already_processed:
            already_processed.add("number")
            try:
                self.number = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.number < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("region", node)
        if value is not None and "region" not in already_processed:
            already_processed.add("region")
            self.regions = value
            self.validate_NmlId(self.regions)  # validate type NmlId

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class RandomLayout


class GridLayout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("x_size", "xs:nonNegativeInteger", 0, 1, {"use": "optional"}),
        MemberSpec_("y_size", "xs:nonNegativeInteger", 0, 1, {"use": u"optional"}),
        MemberSpec_("z_size", "xs:nonNegativeInteger", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, x_size=None, y_size=None, z_size=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.x_size = _cast(int, x_size)
        self.y_size = _cast(int, y_size)
        self.z_size = _cast(int, z_size)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, GridLayout)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GridLayout.subclass:
            return GridLayout.subclass(*args_, **kwargs_)
        else:
            return GridLayout(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GridLayout",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GridLayout")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GridLayout"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GridLayout",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="GridLayout"
    ):
        if self.x_size is not None and "x_size" not in already_processed:
            already_processed.add("x_size")
            outfile.write(
                ' xSize="%s"' % self.gds_format_integer(self.x_size, input_name="xSize")
            )
        if self.y_size is not None and "y_size" not in already_processed:
            already_processed.add("y_size")
            outfile.write(
                ' ySize="%s"' % self.gds_format_integer(self.y_size, input_name="ySize")
            )
        if self.z_size is not None and "z_size" not in already_processed:
            already_processed.add("z_size")
            outfile.write(
                ' zSize="%s"' % self.gds_format_integer(self.z_size, input_name="zSize")
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GridLayout",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xSize", node)
        if value is not None and "xSize" not in already_processed:
            already_processed.add("xSize")
            try:
                self.x_size = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.x_size < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("ySize", node)
        if value is not None and "ySize" not in already_processed:
            already_processed.add("ySize")
            try:
                self.y_size = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.y_size < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("zSize", node)
        if value is not None and "zSize" not in already_processed:
            already_processed.add("zSize")
            try:
                self.z_size = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.z_size < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class GridLayout


class Instance(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("id", "xs:nonNegativeInteger", 0, 1, {"use": "optional"}),
        MemberSpec_("i", "xs:nonNegativeInteger", 0, 1, {"use": "optional"}),
        MemberSpec_("j", "xs:nonNegativeInteger", 0, 1, {"use": "optional"}),
        MemberSpec_("k", "xs:nonNegativeInteger", 0, 1, {"use": "optional"}),
        MemberSpec_(
            "location",
            "Location",
            0,
            0,
            {u"type": u"Location", u"name": u"location"},
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, id=None, i=None, j=None, k=None, location=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.id = _cast(int, id)
        self.i = _cast(int, i)
        self.j = _cast(int, j)
        self.k = _cast(int, k)
        self.location = location

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Instance)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Instance.subclass:
            return Instance.subclass(*args_, **kwargs_)
        else:
            return Instance(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.location is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Instance",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Instance")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Instance"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Instance",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Instance"
    ):
        if self.id is not None and "id" not in already_processed:
            already_processed.add("id")
            outfile.write(
                ' id="%s"' % self.gds_format_integer(self.id, input_name="id")
            )
        if self.i is not None and "i" not in already_processed:
            already_processed.add("i")
            outfile.write(' i="%s"' % self.gds_format_integer(self.i, input_name="i"))
        if self.j is not None and "j" not in already_processed:
            already_processed.add("j")
            outfile.write(' j="%s"' % self.gds_format_integer(self.j, input_name="j"))
        if self.k is not None and "k" not in already_processed:
            already_processed.add("k")
            outfile.write(' k="%s"' % self.gds_format_integer(self.k, input_name="k"))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Instance",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.location is not None:
            self.location.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="location",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("id", node)
        if value is not None and "id" not in already_processed:
            already_processed.add("id")
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.id < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("i", node)
        if value is not None and "i" not in already_processed:
            already_processed.add("i")
            try:
                self.i = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.i < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("j", node)
        if value is not None and "j" not in already_processed:
            already_processed.add("j")
            try:
                self.j = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.j < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("k", node)
        if value is not None and "k" not in already_processed:
            already_processed.add("k")
            try:
                self.k = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.k < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "location":
            obj_ = Location.factory(parent_object_=self)
            obj_.build(child_)
            self.location = obj_
            obj_.original_tagname_ = "location"

    def __str__(self):

        return (
            "Instance "
            + str(self.id)
            + (" at location: " + str(self.location) if self.location else "")
        )

    def __repr__(self):

        return str(self)


# end class Instance


class Location(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_("x", "xs:float", 0, 0, {"use": u"required"}),
        MemberSpec_("y", "xs:float", 0, 0, {"use": u"required"}),
        MemberSpec_("z", "xs:float", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, x=None, y=None, z=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.x = _cast(float, x)
        self.y = _cast(float, y)
        self.z = _cast(float, z)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Location)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Location.subclass:
            return Location.subclass(*args_, **kwargs_)
        else:
            return Location(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Location",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Location")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Location"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Location",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Location"
    ):
        if self.x is not None and "x" not in already_processed:
            already_processed.add("x")
            outfile.write(' x="%s"' % self.gds_format_float(self.x, input_name="x"))
        if self.y is not None and "y" not in already_processed:
            already_processed.add("y")
            outfile.write(' y="%s"' % self.gds_format_float(self.y, input_name="y"))
        if self.z is not None and "z" not in already_processed:
            already_processed.add("z")
            outfile.write(' z="%s"' % self.gds_format_float(self.z, input_name="z"))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Location",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("x", node)
        if value is not None and "x" not in already_processed:
            already_processed.add("x")
            try:
                self.x = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (x): %s" % exp)
        value = find_attr_value_("y", node)
        if value is not None and "y" not in already_processed:
            already_processed.add("y")
            try:
                self.y = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (y): %s" % exp)
        value = find_attr_value_("z", node)
        if value is not None and "z" not in already_processed:
            already_processed.add("z")
            try:
                self.z = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (z): %s" % exp)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass

    def _format(self, value):

        if int(value) == value:
            return str(int(value))
        else:
            return "%.4f" % value

    def __str__(self):

        return (
            "("
            + self._format(self.x)
            + ", "
            + self._format(self.y)
            + ", "
            + self._format(self.z)
            + ")"
        )

    def __repr__(self):

        return str(self)


# end class Location


class SynapticConnection(GeneratedsSuper):
    """Single explicit connection. Introduced to test connections in LEMS.
    Will probably be removed in favour of connections wrapped in
    projection element"""

    member_data_items_ = [
        MemberSpec_("from_", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("to", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("synapse", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("destination", "NmlId", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, from_=None, to=None, synapse=None, destination=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.from_ = _cast(None, from_)
        self.to = _cast(None, to)
        self.synapse = _cast(None, synapse)
        self.destination = _cast(None, destination)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SynapticConnection
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SynapticConnection.subclass:
            return SynapticConnection.subclass(*args_, **kwargs_)
        else:
            return SynapticConnection(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SynapticConnection",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SynapticConnection")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SynapticConnection",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SynapticConnection",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SynapticConnection",
    ):
        if self.from_ is not None and "from_" not in already_processed:
            already_processed.add("from_")
            outfile.write(
                " from=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.from_), input_name="from"
                        )
                    ),
                )
            )
        if self.to is not None and "to" not in already_processed:
            already_processed.add("to")
            outfile.write(
                " to=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.to), input_name="to")
                    ),
                )
            )
        if self.synapse is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            outfile.write(
                " synapse=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.synapse), input_name="synapse"
                        )
                    ),
                )
            )
        if self.destination is not None and "destination" not in already_processed:
            already_processed.add("destination")
            outfile.write(" destination=%s" % (quote_attrib(self.destination),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SynapticConnection",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("from", node)
        if value is not None and "from" not in already_processed:
            already_processed.add("from")
            self.from_ = value
        value = find_attr_value_("to", node)
        if value is not None and "to" not in already_processed:
            already_processed.add("to")
            self.to = value
        value = find_attr_value_("synapse", node)
        if value is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            self.synapse = value
        value = find_attr_value_("destination", node)
        if value is not None and "destination" not in already_processed:
            already_processed.add("destination")
            self.destination = value
            self.validate_NmlId(self.destination)  # validate type NmlId

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass

    def _get_cell_id(self, ref):
        """Get cell ID"""
        if "[" in ref:
            return int(ref.split("[")[1].split("]")[0])
        else:
            return int(ref.split("/")[2])

    def _get_population(self, ref):
        """Get population"""
        if "[" in ref:
            return ref.split("[")[0]
        else:
            return ref.split("/")[0]

    def __str__(self):

        dest = self.destination if self.destination else "unspecified"
        return (
            "Synaptic connection from "
            + str(self._get_population(self.from_))
            + "(cell "
            + str(self._get_cell_id(self.from_))
            + ") -> "
            + str(self._get_population(self.to))
            + "(cell "
            + str(self._get_cell_id(self.to))
            + "), syn: "
            + self.synapse
            + ", destination: "
            + dest
        )

    # end class SynapticConnection


class ExplicitInput(GeneratedsSuper):
    """Single explicit input. Introduced to test inputs in LEMS. Will
    probably be removed in favour of inputs wrapped in inputList
    element"""

    member_data_items_ = [
        MemberSpec_("target", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("input", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("destination", "xs:string", 0, 1, {"use": "optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, target=None, input=None, destination=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.target = _cast(None, target)
        self.input = _cast(None, input)
        self.destination = _cast(None, destination)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ExplicitInput)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExplicitInput.subclass:
            return ExplicitInput.subclass(*args_, **kwargs_)
        else:
            return ExplicitInput(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ExplicitInput",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ExplicitInput")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ExplicitInput"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ExplicitInput",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ExplicitInput",
    ):
        if self.target is not None and "target" not in already_processed:
            already_processed.add("target")
            outfile.write(
                " target=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.target), input_name="target"
                        )
                    ),
                )
            )
        if self.input is not None and "input" not in already_processed:
            already_processed.add("input")
            outfile.write(
                " input=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.input), input_name="input"
                        )
                    ),
                )
            )
        if self.destination is not None and "destination" not in already_processed:
            already_processed.add("destination")
            outfile.write(
                " destination=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.destination), input_name="destination"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ExplicitInput",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("target", node)
        if value is not None and "target" not in already_processed:
            already_processed.add("target")
            self.target = value
        value = find_attr_value_("input", node)
        if value is not None and "input" not in already_processed:
            already_processed.add("input")
            self.input = value
        value = find_attr_value_("destination", node)
        if value is not None and "destination" not in already_processed:
            already_processed.add("destination")
            self.destination = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass

    def _get_cell_id(self, id_string):
        if "[" in id_string:
            return int(id_string.split("[")[1].split("]")[0])
        else:
            return int(id_string.split("/")[2])

    def get_target_cell_id(self):
        """Get ID of target cell."""

        return self._get_cell_id(self.target)

    def get_segment_id(self):
        """Get the ID of the segment.

        Returns 0 if segment_id was not set.
        """
        return int(self.segment_id) if self.segment_id else 0

    def get_fraction_along(self):
        """Get fraction along.

        Returns 0.5 is fraction_along was not set.
        """

        return float(self.fraction_along) if self.fraction_along else 0.5

    def __str__(self):

        return (
            "Input "
            + str(self.id)
            + ": "
            + str(self.get_target_cell_id())
            + ":"
            + str(self.get_segment_id())
            + "("
            + "%.6f" % self.get_fraction_along()
            + ")"
        )

    def get_target_cell_id(
        self,
    ):
        """Get target cell ID"""
        if "[" in self.target:
            return int(self.target.split("[")[1].split("]")[0])
        else:
            return int(self.target.split("/")[2])

    def get_target_population(
        self,
    ):
        """Get target population."""
        if "[" in self.target:
            return self.target.split("[")[0]
        else:
            return self.target.split("/")[0]

    def __str__(self):

        dest = self.destination if self.destination else "unspecified"
        return (
            "Explicit Input of type "
            + str(self.input)
            + " to "
            + self.get_target_population()
            + "(cell "
            + str(self.get_target_cell_id())
            + "), destination: "
            + dest
        )

    # end class ExplicitInput


class Input(GeneratedsSuper):
    """Individual input to the cell specified by target"""

    member_data_items_ = [
        MemberSpec_("id", "NonNegativeInteger", 0, 0, {"use": u"required"}),
        MemberSpec_("target", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("destination", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("segment_id", "NonNegativeInteger", 0, 1, {"use": "optional"}),
        MemberSpec_("fraction_along", "ZeroToOne", 0, 1, {"use": "optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        id=None,
        target=None,
        destination=None,
        segment_id=None,
        fraction_along=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.id = _cast(int, id)
        self.target = _cast(None, target)
        self.destination = _cast(None, destination)
        self.segment_id = _cast(int, segment_id)
        self.fraction_along = _cast(float, fraction_along)
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Input)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Input.subclass:
            return Input.subclass(*args_, **kwargs_)
        else:
            return Input(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd minInclusive restriction on ZeroToOne'
                    % {"value": value}
                )
            if value > 1:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd maxInclusive restriction on ZeroToOne'
                    % {"value": value}
                )

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Input",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Input")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Input"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Input",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Input"
    ):
        if self.id is not None and "id" not in already_processed:
            already_processed.add("id")
            outfile.write(" id=%s" % (quote_attrib(self.id),))
        if self.target is not None and "target" not in already_processed:
            already_processed.add("target")
            outfile.write(
                " target=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.target), input_name="target"
                        )
                    ),
                )
            )
        if self.destination is not None and "destination" not in already_processed:
            already_processed.add("destination")
            outfile.write(" destination=%s" % (quote_attrib(self.destination),))
        if self.segment_id is not None and "segment_id" not in already_processed:
            already_processed.add("segment_id")
            outfile.write(" segmentId=%s" % (quote_attrib(self.segment_id),))
        if (
            self.fraction_along is not None
            and "fraction_along" not in already_processed
        ):
            already_processed.add("fraction_along")
            outfile.write(" fractionAlong=%s" % (quote_attrib(self.fraction_along),))
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Input",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("id", node)
        if value is not None and "id" not in already_processed:
            already_processed.add("id")
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.id < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.id
            )  # validate type NonNegativeInteger
        value = find_attr_value_("target", node)
        if value is not None and "target" not in already_processed:
            already_processed.add("target")
            self.target = value
        value = find_attr_value_("destination", node)
        if value is not None and "destination" not in already_processed:
            already_processed.add("destination")
            self.destination = value
            self.validate_NmlId(self.destination)  # validate type NmlId
        value = find_attr_value_("segmentId", node)
        if value is not None and "segmentId" not in already_processed:
            already_processed.add("segmentId")
            try:
                self.segment_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.segment_id < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segment_id
            )  # validate type NonNegativeInteger
        value = find_attr_value_("fractionAlong", node)
        if value is not None and "fractionAlong" not in already_processed:
            already_processed.add("fractionAlong")
            try:
                self.fraction_along = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (fractionAlong): %s" % exp)
            self.validate_ZeroToOne(self.fraction_along)  # validate type ZeroToOne
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass

    def _get_cell_id(self, id_string):
        if "[" in id_string:
            return int(id_string.split("[")[1].split("]")[0])
        else:
            return int(id_string.split("/")[2])

    def get_target_cell_id(self):
        """Get ID of target cell."""

        return self._get_cell_id(self.target)

    def get_segment_id(self):
        """Get the ID of the segment.

        Returns 0 if segment_id was not set.
        """
        return int(self.segment_id) if self.segment_id else 0

    def get_fraction_along(self):
        """Get fraction along.

        Returns 0.5 is fraction_along was not set.
        """

        return float(self.fraction_along) if self.fraction_along else 0.5

    def __str__(self):

        return (
            "Input "
            + str(self.id)
            + ": "
            + str(self.get_target_cell_id())
            + ":"
            + str(self.get_segment_id())
            + "("
            + "%.6f" % self.get_fraction_along()
            + ")"
        )

    # end class Input


class InputW(Input):
    """Individual input to the cell specified by target. Includes setting
    of _weight for the connection"""

    member_data_items_ = [
        MemberSpec_("weight", "xs:float", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Input

    def __init__(
        self,
        id=None,
        target=None,
        destination=None,
        segment_id=None,
        fraction_along=None,
        weight=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(InputW, self).__init__(
            id, target, destination, segment_id, fraction_along, **kwargs_
        )
        self.weight = _cast(float, weight)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, InputW)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InputW.subclass:
            return InputW.subclass(*args_, **kwargs_)
        else:
            return InputW(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(InputW, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InputW",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InputW")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="InputW"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InputW",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="InputW"
    ):
        super(InputW, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="InputW"
        )
        if self.weight is not None and "weight" not in already_processed:
            already_processed.add("weight")
            outfile.write(
                ' weight="%s"' % self.gds_format_float(self.weight, input_name="weight")
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InputW",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(InputW, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("weight", node)
        if value is not None and "weight" not in already_processed:
            already_processed.add("weight")
            try:
                self.weight = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (weight): %s" % exp)
        super(InputW, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(InputW, self).buildChildren(child_, node, nodeName_, True)
        pass

    def get_weight(self):
        """Get weight.

        If weight is not set, the default value of 1.0 is returned.
        """

        return float(self.weight) if self.weight != None else 1.0

    def __str__(self):

        return (
            "Input (weight) "
            + str(self.id)
            + ": "
            + str(self.get_target_cell_id())
            + ":"
            + str(self.get_segment_id())
            + "("
            + "%.6f" % self.get_fraction_along()
            + "), weight: "
            + "%.6f" % self.get_weight()
        )

    # end class InputW


class BaseWithoutId(GeneratedsSuper):
    """Base element without ID specified *yet*, e.g. for an element with a
    particular requirement on its id which does not comply with
    NmlId (e.g. Segment needs nonNegativeInteger)."""

    member_data_items_ = [
        MemberSpec_("neuro_lex_id", "NeuroLexId", 0, 1, {"use": u"optional"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, neuro_lex_id=None, extensiontype_=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.neuro_lex_id = _cast(None, neuro_lex_id)
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, BaseWithoutId)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseWithoutId.subclass:
            return BaseWithoutId.subclass(*args_, **kwargs_)
        else:
            return BaseWithoutId(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NeuroLexId(self, value):
        # Validate type NeuroLexId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NeuroLexId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NeuroLexId_patterns_,
                    )
                )

    validate_NeuroLexId_patterns_ = [[u"^[a-zA-Z0-9_:]*$"]]

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseWithoutId",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BaseWithoutId")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseWithoutId"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BaseWithoutId",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BaseWithoutId",
    ):
        if self.neuro_lex_id is not None and "neuro_lex_id" not in already_processed:
            already_processed.add("neuro_lex_id")
            outfile.write(" neuroLexId=%s" % (quote_attrib(self.neuro_lex_id),))
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseWithoutId",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("neuroLexId", node)
        if value is not None and "neuroLexId" not in already_processed:
            already_processed.add("neuroLexId")
            self.neuro_lex_id = value
            self.validate_NeuroLexId(self.neuro_lex_id)  # validate type NeuroLexId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class BaseWithoutId


class BaseNonNegativeIntegerId(BaseWithoutId):
    """Anything which can have a unique (within its parent) id, which must
    be an integer zero or greater."""

    member_data_items_ = [
        MemberSpec_("id", "NonNegativeInteger", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = BaseWithoutId

    def __init__(self, neuro_lex_id=None, id=None, extensiontype_=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(BaseNonNegativeIntegerId, self).__init__(
            neuro_lex_id, extensiontype_, **kwargs_
        )
        self.id = _cast(int, id)
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseNonNegativeIntegerId
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseNonNegativeIntegerId.subclass:
            return BaseNonNegativeIntegerId.subclass(*args_, **kwargs_)
        else:
            return BaseNonNegativeIntegerId(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if super(BaseNonNegativeIntegerId, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseNonNegativeIntegerId",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BaseNonNegativeIntegerId")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BaseNonNegativeIntegerId",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BaseNonNegativeIntegerId",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BaseNonNegativeIntegerId",
    ):
        super(BaseNonNegativeIntegerId, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BaseNonNegativeIntegerId",
        )
        if self.id is not None and "id" not in already_processed:
            already_processed.add("id")
            outfile.write(" id=%s" % (quote_attrib(self.id),))
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseNonNegativeIntegerId",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BaseNonNegativeIntegerId, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("id", node)
        if value is not None and "id" not in already_processed:
            already_processed.add("id")
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.id < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.id
            )  # validate type NonNegativeInteger
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(BaseNonNegativeIntegerId, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseNonNegativeIntegerId, self).buildChildren(
            child_, node, nodeName_, True
        )
        pass


# end class BaseNonNegativeIntegerId


class Base(BaseWithoutId):
    """Anything which can have a unique (within its parent) id of the form
    NmlId (spaceless combination of letters, numbers and
    underscore)."""

    member_data_items_ = [
        MemberSpec_("id", "NmlId", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = BaseWithoutId

    def __init__(self, neuro_lex_id=None, id=None, extensiontype_=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(Base, self).__init__(neuro_lex_id, extensiontype_, **kwargs_)
        self.id = _cast(None, id)
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Base)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Base.subclass:
            return Base.subclass(*args_, **kwargs_)
        else:
            return Base(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if super(Base, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Base",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Base")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Base"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Base",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Base"
    ):
        super(Base, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Base"
        )
        if self.id is not None and "id" not in already_processed:
            already_processed.add("id")
            outfile.write(" id=%s" % (quote_attrib(self.id),))
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Base",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Base, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("id", node)
        if value is not None and "id" not in already_processed:
            already_processed.add("id")
            self.id = value
            self.validate_NmlId(self.id)  # validate type NmlId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(Base, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Base, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class Base


class Standalone(Base):
    """Elements which can stand alone and be referenced by id, e.g. cell,
    morphology."""

    member_data_items_ = [
        MemberSpec_("metaid", "MetaId", 0, 1, {"use": u"optional"}),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "properties",
            "Property",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Property",
                u"name": u"property",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "annotation",
            "Annotation",
            0,
            1,
            {u"type": u"Annotation", u"name": u"annotation", u"minOccurs": u"0"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(Standalone, self).__init__(neuro_lex_id, id, extensiontype_, **kwargs_)
        self.metaid = _cast(None, metaid)
        self.notes = notes
        self.validate_Notes(self.notes)
        if properties is None:
            self.properties = []
        else:
            self.properties = properties
        self.annotation = annotation
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Standalone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Standalone.subclass:
            return Standalone.subclass(*args_, **kwargs_)
        else:
            return Standalone(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_MetaId(self, value):
        # Validate type MetaId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_MetaId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_MetaId_patterns_,
                    )
                )

    validate_MetaId_patterns_ = [[u"^[a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if (
            self.notes is not None
            or self.properties
            or self.annotation is not None
            or super(Standalone, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Standalone",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Standalone")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Standalone"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Standalone",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Standalone"
    ):
        super(Standalone, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Standalone"
        )
        if self.metaid is not None and "metaid" not in already_processed:
            already_processed.add("metaid")
            outfile.write(" metaid=%s" % (quote_attrib(self.metaid),))
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Standalone",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Standalone, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        for property_ in self.properties:
            property_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="property",
                pretty_print=pretty_print,
            )
        if self.annotation is not None:
            self.annotation.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="annotation",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("metaid", node)
        if value is not None and "metaid" not in already_processed:
            already_processed.add("metaid")
            self.metaid = value
            self.validate_MetaId(self.metaid)  # validate type MetaId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(Standalone, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "property":
            obj_ = Property.factory(parent_object_=self)
            obj_.build(child_)
            self.properties.append(obj_)
            obj_.original_tagname_ = "property"
        elif nodeName_ == "annotation":
            obj_ = Annotation.factory(parent_object_=self)
            obj_.build(child_)
            self.annotation = obj_
            obj_.original_tagname_ = "annotation"
        super(Standalone, self).buildChildren(child_, node, nodeName_, True)


# end class Standalone


class SpikeSourcePoisson(Standalone):
    member_data_items_ = [
        MemberSpec_("start", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("duration", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("rate", "Nml2Quantity_pertime", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        start=None,
        duration=None,
        rate=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(SpikeSourcePoisson, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.start = _cast(None, start)
        self.duration = _cast(None, duration)
        self.rate = _cast(None, rate)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeSourcePoisson
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeSourcePoisson.subclass:
            return SpikeSourcePoisson.subclass(*args_, **kwargs_)
        else:
            return SpikeSourcePoisson(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_pertime_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_pertime_patterns_,
                    )
                )

    validate_Nml2Quantity_pertime_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s|per_ms|Hz)$"]
    ]

    def hasContent_(self):
        if super(SpikeSourcePoisson, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeSourcePoisson",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeSourcePoisson")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeSourcePoisson",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeSourcePoisson",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpikeSourcePoisson",
    ):
        super(SpikeSourcePoisson, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeSourcePoisson",
        )
        if self.start is not None and "start" not in already_processed:
            already_processed.add("start")
            outfile.write(" start=%s" % (quote_attrib(self.start),))
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(" duration=%s" % (quote_attrib(self.duration),))
        if self.rate is not None and "rate" not in already_processed:
            already_processed.add("rate")
            outfile.write(" rate=%s" % (quote_attrib(self.rate),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeSourcePoisson",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SpikeSourcePoisson, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("start", node)
        if value is not None and "start" not in already_processed:
            already_processed.add("start")
            self.start = value
            self.validate_Nml2Quantity_time(
                self.start
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("rate", node)
        if value is not None and "rate" not in already_processed:
            already_processed.add("rate")
            self.rate = value
            self.validate_Nml2Quantity_pertime(
                self.rate
            )  # validate type Nml2Quantity_pertime
        super(SpikeSourcePoisson, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeSourcePoisson, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class SpikeSourcePoisson


class InputList(Base):
    """List of inputs to a population. Currents will be provided by the
    specified component."""

    member_data_items_ = [
        MemberSpec_("populations", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("component", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "input",
            "Input",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Input",
                u"name": u"input",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "input_ws",
            "InputW",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"InputW",
                u"name": u"inputW",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        populations=None,
        component=None,
        input=None,
        input_ws=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(InputList, self).__init__(neuro_lex_id, id, **kwargs_)
        self.populations = _cast(None, populations)
        self.component = _cast(None, component)
        if input is None:
            self.input = []
        else:
            self.input = input
        if input_ws is None:
            self.input_ws = []
        else:
            self.input_ws = input_ws

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, InputList)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InputList.subclass:
            return InputList.subclass(*args_, **kwargs_)
        else:
            return InputList(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if self.input or self.input_ws or super(InputList, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InputList",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InputList")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="InputList"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InputList",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="InputList"
    ):
        super(InputList, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="InputList"
        )
        if self.populations is not None and "populations" not in already_processed:
            already_processed.add("populations")
            outfile.write(" population=%s" % (quote_attrib(self.populations),))
        if self.component is not None and "component" not in already_processed:
            already_processed.add("component")
            outfile.write(" component=%s" % (quote_attrib(self.component),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InputList",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(InputList, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for input_ in self.input:
            input_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="input",
                pretty_print=pretty_print,
            )
        for inputW_ in self.input_ws:
            inputW_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="inputW",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("population", node)
        if value is not None and "population" not in already_processed:
            already_processed.add("population")
            self.populations = value
            self.validate_NmlId(self.populations)  # validate type NmlId
        value = find_attr_value_("component", node)
        if value is not None and "component" not in already_processed:
            already_processed.add("component")
            self.component = value
            self.validate_NmlId(self.component)  # validate type NmlId
        super(InputList, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "input":
            class_obj_ = self.get_class_obj_(child_, Input)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.input.append(obj_)
            obj_.original_tagname_ = "input"
        elif nodeName_ == "inputW":
            obj_ = InputW.factory(parent_object_=self)
            obj_.build(child_)
            self.input_ws.append(obj_)
            obj_.original_tagname_ = "inputW"
        super(InputList, self).buildChildren(child_, node, nodeName_, True)

    def exportHdf5(self, h5file, h5Group):
        """Export to HDF5 file."""
        # print("Exporting InputList: "+str(self.id)+" as HDF5")

        import numpy

        ilGroup = h5file.create_group(h5Group, "inputList_" + self.id)
        ilGroup._f_setattr("id", self.id)
        ilGroup._f_setattr("component", self.component)
        ilGroup._f_setattr("population", self.populations)

        cols = 4

        extra_cols = {}

        num_tot = len(self.input) + len(self.input_ws)

        if len(self.input_ws) > 0:
            extra_cols["column_" + str(cols)] = "weight"
            cols += 1

        # print("Exporting "+str(num_tot)+" inputs")
        a = numpy.zeros([num_tot, cols], numpy.float32)

        count = 0

        for input in self.input:
            a[count, 0] = input.id
            a[count, 1] = input.get_target_cell_id()
            a[count, 2] = input.get_segment_id()
            a[count, 3] = input.get_fraction_along()
            count += 1

        for input in self.input_ws:
            a[count, 0] = input.id
            a[count, 1] = input.get_target_cell_id()
            a[count, 2] = input.get_segment_id()
            a[count, 3] = input.get_fraction_along()
            a[count, 4] = input.get_weight()
            count += 1

        array = h5file.create_carray(
            ilGroup, self.id, obj=a, title="Locations of inputs in " + self.id
        )

        array._f_setattr("column_0", "id")
        array._f_setattr("column_1", "target_cell_id")
        array._f_setattr("column_2", "segment_id")
        array._f_setattr("column_3", "fraction_along")
        for k in extra_cols:
            array._f_setattr(k, extra_cols[k])

    def __str__(self):

        return (
            "Input list: "
            + self.id
            + " to "
            + self.populations
            + ", component "
            + self.component
        )

    # end class InputList


class BaseConnection(BaseNonNegativeIntegerId):
    """Base of all synaptic connections (chemical/electrical/analog, etc.)
    inside projections"""

    member_data_items_ = []
    subclass = None
    superclass = BaseNonNegativeIntegerId

    def __init__(self, neuro_lex_id=None, id=None, extensiontype_=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(BaseConnection, self).__init__(
            neuro_lex_id, id, extensiontype_, **kwargs_
        )
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, BaseConnection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseConnection.subclass:
            return BaseConnection.subclass(*args_, **kwargs_)
        else:
            return BaseConnection(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(BaseConnection, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseConnection",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BaseConnection")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseConnection"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BaseConnection",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BaseConnection",
    ):
        super(BaseConnection, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseConnection"
        )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseConnection",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BaseConnection, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(BaseConnection, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseConnection, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class BaseConnection


class BaseProjection(Base):
    """Base for projection (set of synaptic connections) between two
    populations"""

    member_data_items_ = [
        MemberSpec_("presynaptic_population", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("postsynaptic_population", "NmlId", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        presynaptic_population=None,
        postsynaptic_population=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(BaseProjection, self).__init__(
            neuro_lex_id, id, extensiontype_, **kwargs_
        )
        self.presynaptic_population = _cast(None, presynaptic_population)
        self.postsynaptic_population = _cast(None, postsynaptic_population)
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, BaseProjection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseProjection.subclass:
            return BaseProjection.subclass(*args_, **kwargs_)
        else:
            return BaseProjection(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if super(BaseProjection, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseProjection",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BaseProjection")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseProjection"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BaseProjection",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BaseProjection",
    ):
        super(BaseProjection, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseProjection"
        )
        if (
            self.presynaptic_population is not None
            and "presynaptic_population" not in already_processed
        ):
            already_processed.add("presynaptic_population")
            outfile.write(
                " presynapticPopulation=%s"
                % (quote_attrib(self.presynaptic_population),)
            )
        if (
            self.postsynaptic_population is not None
            and "postsynaptic_population" not in already_processed
        ):
            already_processed.add("postsynaptic_population")
            outfile.write(
                " postsynapticPopulation=%s"
                % (quote_attrib(self.postsynaptic_population),)
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseProjection",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BaseProjection, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("presynapticPopulation", node)
        if value is not None and "presynapticPopulation" not in already_processed:
            already_processed.add("presynapticPopulation")
            self.presynaptic_population = value
            self.validate_NmlId(self.presynaptic_population)  # validate type NmlId
        value = find_attr_value_("postsynapticPopulation", node)
        if value is not None and "postsynapticPopulation" not in already_processed:
            already_processed.add("postsynapticPopulation")
            self.postsynaptic_population = value
            self.validate_NmlId(self.postsynaptic_population)  # validate type NmlId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(BaseProjection, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseProjection, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class BaseProjection


class CellSet(Base):
    member_data_items_ = [
        MemberSpec_("select", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "__ANY__",
            "__ANY__",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"processContents": u"skip",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self, neuro_lex_id=None, id=None, select=None, anytypeobjs_=None, **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(CellSet, self).__init__(neuro_lex_id, id, **kwargs_)
        self.select = _cast(None, select)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, CellSet)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CellSet.subclass:
            return CellSet.subclass(*args_, **kwargs_)
        else:
            return CellSet(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.anytypeobjs_ or super(CellSet, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CellSet",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CellSet")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CellSet"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CellSet",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="CellSet"
    ):
        super(CellSet, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CellSet"
        )
        if self.select is not None and "select" not in already_processed:
            already_processed.add("select")
            outfile.write(
                " select=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.select), input_name="select"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CellSet",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(CellSet, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("select", node)
        if value is not None and "select" not in already_processed:
            already_processed.add("select")
            self.select = value
        super(CellSet, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, "CellSet")
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(CellSet, self).buildChildren(child_, node, nodeName_, True)


# end class CellSet


class Population(Standalone):
    member_data_items_ = [
        MemberSpec_("component", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("size", "NonNegativeInteger", 0, 1, {"use": u"optional"}),
        MemberSpec_("type", "populationTypes", 0, 1, {"use": u"optional"}),
        MemberSpec_("extracellular_properties", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_(
            "layout",
            "Layout",
            0,
            1,
            {u"type": u"Layout", u"name": u"layout", u"minOccurs": u"0"},
            4,
        ),
        MemberSpec_(
            "instances",
            "Instance",
            1,
            0,
            {u"maxOccurs": u"unbounded", u"type": u"Instance", u"name": u"instance"},
            4,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        component=None,
        size=None,
        type=None,
        extracellular_properties=None,
        layout=None,
        instances=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(Population, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.component = _cast(None, component)
        self.size = _cast(int, size)
        self.type = _cast(None, type)
        self.extracellular_properties = _cast(None, extracellular_properties)
        self.layout = layout
        if instances is None:
            self.instances = []
        else:
            self.instances = instances

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Population)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Population.subclass:
            return Population.subclass(*args_, **kwargs_)
        else:
            return Population(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_populationTypes(self, value):
        # Validate type populationTypes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ["population", "populationList"]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on populationTypes'
                    % {"value": value.encode("utf-8")}
                )

    def hasContent_(self):
        if (
            self.layout is not None
            or self.instances
            or super(Population, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Population",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Population")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Population"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Population",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Population"
    ):
        super(Population, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Population"
        )
        if self.component is not None and "component" not in already_processed:
            already_processed.add("component")
            outfile.write(" component=%s" % (quote_attrib(self.component),))
        if self.size is not None and "size" not in already_processed:
            already_processed.add("size")
            outfile.write(" size=%s" % (quote_attrib(self.size),))
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(" type=%s" % (quote_attrib(self.type),))
        if (
            self.extracellular_properties is not None
            and "extracellular_properties" not in already_processed
        ):
            already_processed.add("extracellular_properties")
            outfile.write(
                " extracellularProperties=%s"
                % (quote_attrib(self.extracellular_properties),)
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Population",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Population, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.layout is not None:
            self.layout.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="layout",
                pretty_print=pretty_print,
            )
        for instance_ in self.instances:
            instance_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="instance",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("component", node)
        if value is not None and "component" not in already_processed:
            already_processed.add("component")
            self.component = value
            self.validate_NmlId(self.component)  # validate type NmlId
        value = find_attr_value_("size", node)
        if value is not None and "size" not in already_processed:
            already_processed.add("size")
            try:
                self.size = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.size < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.size
            )  # validate type NonNegativeInteger
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_populationTypes(self.type)  # validate type populationTypes
        value = find_attr_value_("extracellularProperties", node)
        if value is not None and "extracellularProperties" not in already_processed:
            already_processed.add("extracellularProperties")
            self.extracellular_properties = value
            self.validate_NmlId(self.extracellular_properties)  # validate type NmlId
        super(Population, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "layout":
            obj_ = Layout.factory(parent_object_=self)
            obj_.build(child_)
            self.layout = obj_
            obj_.original_tagname_ = "layout"
        elif nodeName_ == "instance":
            obj_ = Instance.factory(parent_object_=self)
            obj_.build(child_)
            self.instances.append(obj_)
            obj_.original_tagname_ = "instance"
        super(Population, self).buildChildren(child_, node, nodeName_, True)

    def exportHdf5(self, h5file, h5Group):
        """Export to HDF5 file."""
        # print("Exporting Population: "+str(self.id)+" as HDF5")

        import numpy

        popGroup = h5file.create_group(h5Group, "population_" + self.id)
        popGroup._f_setattr("id", self.id)
        popGroup._f_setattr("component", self.component)
        for p in self.properties:
            popGroup._f_setattr("property:" + p.tag, p.value)

        if len(self.instances) > 0:

            colCount = 3
            a = numpy.zeros([len(self.instances), colCount], numpy.float32)

            count = 0
            for instance in self.instances:
                a[count, 0] = instance.location.x
                a[count, 1] = instance.location.y
                a[count, 2] = instance.location.z

                count = count + 1

            popGroup._f_setattr("size", count)
            popGroup._f_setattr("type", "populationList")

            array = h5file.create_carray(
                popGroup, self.id, obj=a, title="Locations of cells in " + self.id
            )
            array._f_setattr("column_0", "x")
            array._f_setattr("column_1", "y")
            array._f_setattr("column_2", "z")

        else:
            popGroup._f_setattr("size", self.size)

    def get_size(self):
        return (
            len(self.instances)
            if len(self.instances) > 0
            else (self.size if self.size else 0)
        )

    def __str__(self):

        return (
            "Population: "
            + str(self.id)
            + " with "
            + str(self.get_size())
            + " components of type "
            + (self.component if self.component else "???")
        )

    # end class Population


class Region(Base):
    member_data_items_ = [
        MemberSpec_("spaces", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_(
            "__ANY__",
            "__ANY__",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"processContents": u"skip",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self, neuro_lex_id=None, id=None, spaces=None, anytypeobjs_=None, **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(Region, self).__init__(neuro_lex_id, id, **kwargs_)
        self.spaces = _cast(None, spaces)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Region)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Region.subclass:
            return Region.subclass(*args_, **kwargs_)
        else:
            return Region(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if self.anytypeobjs_ or super(Region, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Region",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Region")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Region"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Region",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Region"
    ):
        super(Region, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Region"
        )
        if self.spaces is not None and "spaces" not in already_processed:
            already_processed.add("spaces")
            outfile.write(" space=%s" % (quote_attrib(self.spaces),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Region",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Region, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("space", node)
        if value is not None and "space" not in already_processed:
            already_processed.add("space")
            self.spaces = value
            self.validate_NmlId(self.spaces)  # validate type NmlId
        super(Region, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, "Region")
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(Region, self).buildChildren(child_, node, nodeName_, True)


# end class Region


class Space(Base):
    member_data_items_ = [
        MemberSpec_("based_on", "allowedSpaces", 0, 1, {"use": u"optional"}),
        MemberSpec_(
            "structure",
            "SpaceStructure",
            0,
            1,
            {u"type": u"SpaceStructure", u"name": u"structure", u"minOccurs": u"0"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self, neuro_lex_id=None, id=None, based_on=None, structure=None, **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(Space, self).__init__(neuro_lex_id, id, **kwargs_)
        self.based_on = _cast(None, based_on)
        self.structure = structure

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Space)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Space.subclass:
            return Space.subclass(*args_, **kwargs_)
        else:
            return Space(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_allowedSpaces(self, value):
        # Validate type allowedSpaces, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = [
                "Euclidean_1D",
                "Euclidean_2D",
                "Euclidean_3D",
                "Grid_1D",
                "Grid_2D",
                "Grid_3D",
            ]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on allowedSpaces'
                    % {"value": value.encode("utf-8")}
                )

    def hasContent_(self):
        if self.structure is not None or super(Space, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Space",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Space")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Space"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Space",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Space"
    ):
        super(Space, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Space"
        )
        if self.based_on is not None and "based_on" not in already_processed:
            already_processed.add("based_on")
            outfile.write(" basedOn=%s" % (quote_attrib(self.based_on),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Space",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Space, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.structure is not None:
            self.structure.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="structure",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("basedOn", node)
        if value is not None and "basedOn" not in already_processed:
            already_processed.add("basedOn")
            self.based_on = value
            self.validate_allowedSpaces(self.based_on)  # validate type allowedSpaces
        super(Space, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "structure":
            obj_ = SpaceStructure.factory(parent_object_=self)
            obj_.build(child_)
            self.structure = obj_
            obj_.original_tagname_ = "structure"
        super(Space, self).buildChildren(child_, node, nodeName_, True)


# end class Space


class Network(Standalone):
    member_data_items_ = [
        MemberSpec_("type", "networkTypes", 0, 1, {"use": u"optional"}),
        MemberSpec_(
            "temperature", "Nml2Quantity_temperature", 0, 1, {"use": u"optional"}
        ),
        MemberSpec_(
            "spaces",
            "Space",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Space",
                u"name": u"space",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "regions",
            "Region",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Region",
                u"name": u"region",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "extracellular_properties",
            "ExtracellularPropertiesLocal",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ExtracellularPropertiesLocal",
                u"name": u"extracellularProperties",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "populations",
            "Population",
            1,
            0,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Population",
                u"name": u"population",
            },
            None,
        ),
        MemberSpec_(
            "cell_sets",
            "CellSet",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"CellSet",
                u"name": u"cellSet",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "synaptic_connections",
            "SynapticConnection",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SynapticConnection",
                u"name": u"synapticConnection",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "projections",
            "Projection",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Projection",
                u"name": u"projection",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "electrical_projections",
            "ElectricalProjection",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ElectricalProjection",
                u"name": u"electricalProjection",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "continuous_projections",
            "ContinuousProjection",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ContinuousProjection",
                u"name": u"continuousProjection",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "explicit_inputs",
            "ExplicitInput",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ExplicitInput",
                u"name": u"explicitInput",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "input_lists",
            "InputList",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"InputList",
                u"name": u"inputList",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        type=None,
        temperature=None,
        spaces=None,
        regions=None,
        extracellular_properties=None,
        populations=None,
        cell_sets=None,
        synaptic_connections=None,
        projections=None,
        electrical_projections=None,
        continuous_projections=None,
        explicit_inputs=None,
        input_lists=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(Network, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.type = _cast(None, type)
        self.temperature = _cast(None, temperature)
        if spaces is None:
            self.spaces = []
        else:
            self.spaces = spaces
        if regions is None:
            self.regions = []
        else:
            self.regions = regions
        if extracellular_properties is None:
            self.extracellular_properties = []
        else:
            self.extracellular_properties = extracellular_properties
        if populations is None:
            self.populations = []
        else:
            self.populations = populations
        if cell_sets is None:
            self.cell_sets = []
        else:
            self.cell_sets = cell_sets
        if synaptic_connections is None:
            self.synaptic_connections = []
        else:
            self.synaptic_connections = synaptic_connections
        if projections is None:
            self.projections = []
        else:
            self.projections = projections
        if electrical_projections is None:
            self.electrical_projections = []
        else:
            self.electrical_projections = electrical_projections
        if continuous_projections is None:
            self.continuous_projections = []
        else:
            self.continuous_projections = continuous_projections
        if explicit_inputs is None:
            self.explicit_inputs = []
        else:
            self.explicit_inputs = explicit_inputs
        if input_lists is None:
            self.input_lists = []
        else:
            self.input_lists = input_lists

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Network)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Network.subclass:
            return Network.subclass(*args_, **kwargs_)
        else:
            return Network(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_networkTypes(self, value):
        # Validate type networkTypes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ["network", "networkWithTemperature"]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on networkTypes'
                    % {"value": value.encode("utf-8")}
                )

    def validate_Nml2Quantity_temperature(self, value):
        # Validate type Nml2Quantity_temperature, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_temperature_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_temperature_patterns_,
                    )
                )

    validate_Nml2Quantity_temperature_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(degC)$"]
    ]

    def hasContent_(self):
        if (
            self.spaces
            or self.regions
            or self.extracellular_properties
            or self.populations
            or self.cell_sets
            or self.synaptic_connections
            or self.projections
            or self.electrical_projections
            or self.continuous_projections
            or self.explicit_inputs
            or self.input_lists
            or super(Network, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Network",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Network")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Network"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Network",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Network"
    ):
        super(Network, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Network"
        )
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(" type=%s" % (quote_attrib(self.type),))
        if self.temperature is not None and "temperature" not in already_processed:
            already_processed.add("temperature")
            outfile.write(" temperature=%s" % (quote_attrib(self.temperature),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Network",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Network, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for space_ in self.spaces:
            space_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="space",
                pretty_print=pretty_print,
            )
        for region_ in self.regions:
            region_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="region",
                pretty_print=pretty_print,
            )
        for extracellularProperties_ in self.extracellular_properties:
            extracellularProperties_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="extracellularProperties",
                pretty_print=pretty_print,
            )
        for population_ in self.populations:
            population_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="population",
                pretty_print=pretty_print,
            )
        for cellSet_ in self.cell_sets:
            cellSet_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="cellSet",
                pretty_print=pretty_print,
            )
        for synapticConnection_ in self.synaptic_connections:
            synapticConnection_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="synapticConnection",
                pretty_print=pretty_print,
            )
        for projection_ in self.projections:
            projection_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="projection",
                pretty_print=pretty_print,
            )
        for electricalProjection_ in self.electrical_projections:
            electricalProjection_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="electricalProjection",
                pretty_print=pretty_print,
            )
        for continuousProjection_ in self.continuous_projections:
            continuousProjection_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="continuousProjection",
                pretty_print=pretty_print,
            )
        for explicitInput_ in self.explicit_inputs:
            explicitInput_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="explicitInput",
                pretty_print=pretty_print,
            )
        for inputList_ in self.input_lists:
            inputList_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="inputList",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_networkTypes(self.type)  # validate type networkTypes
        value = find_attr_value_("temperature", node)
        if value is not None and "temperature" not in already_processed:
            already_processed.add("temperature")
            self.temperature = value
            self.validate_Nml2Quantity_temperature(
                self.temperature
            )  # validate type Nml2Quantity_temperature
        super(Network, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "space":
            obj_ = Space.factory(parent_object_=self)
            obj_.build(child_)
            self.spaces.append(obj_)
            obj_.original_tagname_ = "space"
        elif nodeName_ == "region":
            obj_ = Region.factory(parent_object_=self)
            obj_.build(child_)
            self.regions.append(obj_)
            obj_.original_tagname_ = "region"
        elif nodeName_ == "extracellularProperties":
            obj_ = ExtracellularPropertiesLocal.factory(parent_object_=self)
            obj_.build(child_)
            self.extracellular_properties.append(obj_)
            obj_.original_tagname_ = "extracellularProperties"
        elif nodeName_ == "population":
            obj_ = Population.factory(parent_object_=self)
            obj_.build(child_)
            self.populations.append(obj_)
            obj_.original_tagname_ = "population"
        elif nodeName_ == "cellSet":
            obj_ = CellSet.factory(parent_object_=self)
            obj_.build(child_)
            self.cell_sets.append(obj_)
            obj_.original_tagname_ = "cellSet"
        elif nodeName_ == "synapticConnection":
            obj_ = SynapticConnection.factory(parent_object_=self)
            obj_.build(child_)
            self.synaptic_connections.append(obj_)
            obj_.original_tagname_ = "synapticConnection"
        elif nodeName_ == "projection":
            obj_ = Projection.factory(parent_object_=self)
            obj_.build(child_)
            self.projections.append(obj_)
            obj_.original_tagname_ = "projection"
        elif nodeName_ == "electricalProjection":
            obj_ = ElectricalProjection.factory(parent_object_=self)
            obj_.build(child_)
            self.electrical_projections.append(obj_)
            obj_.original_tagname_ = "electricalProjection"
        elif nodeName_ == "continuousProjection":
            obj_ = ContinuousProjection.factory(parent_object_=self)
            obj_.build(child_)
            self.continuous_projections.append(obj_)
            obj_.original_tagname_ = "continuousProjection"
        elif nodeName_ == "explicitInput":
            obj_ = ExplicitInput.factory(parent_object_=self)
            obj_.build(child_)
            self.explicit_inputs.append(obj_)
            obj_.original_tagname_ = "explicitInput"
        elif nodeName_ == "inputList":
            obj_ = InputList.factory(parent_object_=self)
            obj_.build(child_)
            self.input_lists.append(obj_)
            obj_.original_tagname_ = "inputList"
        super(Network, self).buildChildren(child_, node, nodeName_, True)

    warn_count = 0

    def get_by_id(self, id):
        """Get a component by its ID

        :param id: ID of component to find
        :type id: str
        :returns:  component with specified ID or None if no component with specified ID found
        """
        all_ids = []
        for ms in self.member_data_items_:
            mlist = self.__getattribute__(ms.name)
            for m in mlist:
                if hasattr(m, "id"):
                    if m.id == id:
                        return m
                    else:
                        all_ids.append(m.id)
        from neuroml.loaders import print_

        if self.warn_count < 10:
            print_(
                "Id "
                + id
                + " not found in <network> element. All ids: "
                + str(sorted(all_ids))
            )
            self.warn_count += 1
        elif self.warn_count == 10:
            print_(" - Suppressing further warnings about id not found...")
        return None

    def __str__(self):

        return (
            "Network "
            + str(self.id)
            + " with "
            + str(len(self.populations))
            + " population(s)"
        )

    def exportHdf5(self, h5file, h5Group):
        """Export to HDF5 file."""
        # print("Exporting Network: "+str(self.id)+" as HDF5")

        import numpy

        netGroup = h5file.create_group(h5Group, "network")
        netGroup._f_setattr("id", self.id)
        netGroup._f_setattr("notes", self.notes)
        if self.temperature:
            netGroup._f_setattr("temperature", self.temperature)

        for pop in self.populations:
            pop.exportHdf5(h5file, netGroup)

        if len(self.synaptic_connections) > 0:
            raise Exception("<synapticConnection> not yet supported in HDF5 export")
        if len(self.explicit_inputs) > 0:
            raise Exception("<explicitInput> not yet supported in HDF5 export")

        for proj in self.projections:
            proj.exportHdf5(h5file, netGroup)

        for eproj in self.electrical_projections:
            eproj.exportHdf5(h5file, netGroup)

        for cproj in self.continuous_projections:
            cproj.exportHdf5(h5file, netGroup)

        for il in self.input_lists:
            il.exportHdf5(h5file, netGroup)

    # end class Network


class TransientPoissonFiringSynapse(Standalone):
    member_data_items_ = [
        MemberSpec_("average_rate", "Nml2Quantity_pertime", 0, 0, {"use": u"required"}),
        MemberSpec_("delay", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("duration", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("synapse", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("spike_target", "xs:string", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        average_rate=None,
        delay=None,
        duration=None,
        synapse=None,
        spike_target=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(TransientPoissonFiringSynapse, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.average_rate = _cast(None, average_rate)
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.synapse = _cast(None, synapse)
        self.spike_target = _cast(None, spike_target)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TransientPoissonFiringSynapse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TransientPoissonFiringSynapse.subclass:
            return TransientPoissonFiringSynapse.subclass(*args_, **kwargs_)
        else:
            return TransientPoissonFiringSynapse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_pertime_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_pertime_patterns_,
                    )
                )

    validate_Nml2Quantity_pertime_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s|per_ms|Hz)$"]
    ]

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def hasContent_(self):
        if super(TransientPoissonFiringSynapse, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TransientPoissonFiringSynapse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TransientPoissonFiringSynapse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TransientPoissonFiringSynapse",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="TransientPoissonFiringSynapse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="TransientPoissonFiringSynapse",
    ):
        super(TransientPoissonFiringSynapse, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TransientPoissonFiringSynapse",
        )
        if self.average_rate is not None and "average_rate" not in already_processed:
            already_processed.add("average_rate")
            outfile.write(" averageRate=%s" % (quote_attrib(self.average_rate),))
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(" delay=%s" % (quote_attrib(self.delay),))
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(" duration=%s" % (quote_attrib(self.duration),))
        if self.synapse is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            outfile.write(
                " synapse=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.synapse), input_name="synapse"
                        )
                    ),
                )
            )
        if self.spike_target is not None and "spike_target" not in already_processed:
            already_processed.add("spike_target")
            outfile.write(
                " spikeTarget=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.spike_target), input_name="spikeTarget"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TransientPoissonFiringSynapse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(TransientPoissonFiringSynapse, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("averageRate", node)
        if value is not None and "averageRate" not in already_processed:
            already_processed.add("averageRate")
            self.average_rate = value
            self.validate_Nml2Quantity_pertime(
                self.average_rate
            )  # validate type Nml2Quantity_pertime
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("synapse", node)
        if value is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            self.synapse = value
        value = find_attr_value_("spikeTarget", node)
        if value is not None and "spikeTarget" not in already_processed:
            already_processed.add("spikeTarget")
            self.spike_target = value
        super(TransientPoissonFiringSynapse, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(TransientPoissonFiringSynapse, self).buildChildren(
            child_, node, nodeName_, True
        )
        pass


# end class TransientPoissonFiringSynapse


class PoissonFiringSynapse(Standalone):
    member_data_items_ = [
        MemberSpec_("average_rate", "Nml2Quantity_pertime", 0, 0, {"use": u"required"}),
        MemberSpec_("synapse", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("spike_target", "xs:string", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        average_rate=None,
        synapse=None,
        spike_target=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(PoissonFiringSynapse, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.average_rate = _cast(None, average_rate)
        self.synapse = _cast(None, synapse)
        self.spike_target = _cast(None, spike_target)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PoissonFiringSynapse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PoissonFiringSynapse.subclass:
            return PoissonFiringSynapse.subclass(*args_, **kwargs_)
        else:
            return PoissonFiringSynapse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_pertime_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_pertime_patterns_,
                    )
                )

    validate_Nml2Quantity_pertime_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s|per_ms|Hz)$"]
    ]

    def hasContent_(self):
        if super(PoissonFiringSynapse, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PoissonFiringSynapse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PoissonFiringSynapse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="PoissonFiringSynapse",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PoissonFiringSynapse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PoissonFiringSynapse",
    ):
        super(PoissonFiringSynapse, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="PoissonFiringSynapse",
        )
        if self.average_rate is not None and "average_rate" not in already_processed:
            already_processed.add("average_rate")
            outfile.write(" averageRate=%s" % (quote_attrib(self.average_rate),))
        if self.synapse is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            outfile.write(
                " synapse=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.synapse), input_name="synapse"
                        )
                    ),
                )
            )
        if self.spike_target is not None and "spike_target" not in already_processed:
            already_processed.add("spike_target")
            outfile.write(
                " spikeTarget=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.spike_target), input_name="spikeTarget"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PoissonFiringSynapse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(PoissonFiringSynapse, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("averageRate", node)
        if value is not None and "averageRate" not in already_processed:
            already_processed.add("averageRate")
            self.average_rate = value
            self.validate_Nml2Quantity_pertime(
                self.average_rate
            )  # validate type Nml2Quantity_pertime
        value = find_attr_value_("synapse", node)
        if value is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            self.synapse = value
        value = find_attr_value_("spikeTarget", node)
        if value is not None and "spikeTarget" not in already_processed:
            already_processed.add("spikeTarget")
            self.spike_target = value
        super(PoissonFiringSynapse, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(PoissonFiringSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class PoissonFiringSynapse


class SpikeGeneratorPoisson(Standalone):
    member_data_items_ = [
        MemberSpec_("average_rate", "Nml2Quantity_pertime", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        average_rate=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(SpikeGeneratorPoisson, self).__init__(
            neuro_lex_id,
            id,
            metaid,
            notes,
            properties,
            annotation,
            extensiontype_,
            **kwargs_
        )
        self.average_rate = _cast(None, average_rate)
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeGeneratorPoisson
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeGeneratorPoisson.subclass:
            return SpikeGeneratorPoisson.subclass(*args_, **kwargs_)
        else:
            return SpikeGeneratorPoisson(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_pertime_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_pertime_patterns_,
                    )
                )

    validate_Nml2Quantity_pertime_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s|per_ms|Hz)$"]
    ]

    def hasContent_(self):
        if super(SpikeGeneratorPoisson, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGeneratorPoisson",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeGeneratorPoisson")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeGeneratorPoisson",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeGeneratorPoisson",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpikeGeneratorPoisson",
    ):
        super(SpikeGeneratorPoisson, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeGeneratorPoisson",
        )
        if self.average_rate is not None and "average_rate" not in already_processed:
            already_processed.add("average_rate")
            outfile.write(" averageRate=%s" % (quote_attrib(self.average_rate),))
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGeneratorPoisson",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SpikeGeneratorPoisson, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("averageRate", node)
        if value is not None and "averageRate" not in already_processed:
            already_processed.add("averageRate")
            self.average_rate = value
            self.validate_Nml2Quantity_pertime(
                self.average_rate
            )  # validate type Nml2Quantity_pertime
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(SpikeGeneratorPoisson, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeGeneratorPoisson, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class SpikeGeneratorPoisson


class SpikeGeneratorRandom(Standalone):
    member_data_items_ = [
        MemberSpec_("max_isi", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("min_isi", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        max_isi=None,
        min_isi=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(SpikeGeneratorRandom, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.max_isi = _cast(None, max_isi)
        self.min_isi = _cast(None, min_isi)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeGeneratorRandom
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeGeneratorRandom.subclass:
            return SpikeGeneratorRandom.subclass(*args_, **kwargs_)
        else:
            return SpikeGeneratorRandom(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def hasContent_(self):
        if super(SpikeGeneratorRandom, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGeneratorRandom",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeGeneratorRandom")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeGeneratorRandom",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeGeneratorRandom",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpikeGeneratorRandom",
    ):
        super(SpikeGeneratorRandom, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeGeneratorRandom",
        )
        if self.max_isi is not None and "max_isi" not in already_processed:
            already_processed.add("max_isi")
            outfile.write(" maxISI=%s" % (quote_attrib(self.max_isi),))
        if self.min_isi is not None and "min_isi" not in already_processed:
            already_processed.add("min_isi")
            outfile.write(" minISI=%s" % (quote_attrib(self.min_isi),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGeneratorRandom",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SpikeGeneratorRandom, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("maxISI", node)
        if value is not None and "maxISI" not in already_processed:
            already_processed.add("maxISI")
            self.max_isi = value
            self.validate_Nml2Quantity_time(
                self.max_isi
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("minISI", node)
        if value is not None and "minISI" not in already_processed:
            already_processed.add("minISI")
            self.min_isi = value
            self.validate_Nml2Quantity_time(
                self.min_isi
            )  # validate type Nml2Quantity_time
        super(SpikeGeneratorRandom, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeGeneratorRandom, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class SpikeGeneratorRandom


class SpikeGenerator(Standalone):
    member_data_items_ = [
        MemberSpec_("period", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        period=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(SpikeGenerator, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.period = _cast(None, period)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SpikeGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeGenerator.subclass:
            return SpikeGenerator.subclass(*args_, **kwargs_)
        else:
            return SpikeGenerator(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def hasContent_(self):
        if super(SpikeGenerator, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGenerator",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeGenerator")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpikeGenerator"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeGenerator",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpikeGenerator",
    ):
        super(SpikeGenerator, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpikeGenerator"
        )
        if self.period is not None and "period" not in already_processed:
            already_processed.add("period")
            outfile.write(" period=%s" % (quote_attrib(self.period),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGenerator",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SpikeGenerator, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("period", node)
        if value is not None and "period" not in already_processed:
            already_processed.add("period")
            self.period = value
            self.validate_Nml2Quantity_time(
                self.period
            )  # validate type Nml2Quantity_time
        super(SpikeGenerator, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class SpikeGenerator


class TimedSynapticInput(Standalone):
    member_data_items_ = [
        MemberSpec_("synapse", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("spike_target", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "spikes",
            "Spike",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Spike",
                u"name": u"spike",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        synapse=None,
        spike_target=None,
        spikes=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(TimedSynapticInput, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.synapse = _cast(None, synapse)
        self.spike_target = _cast(None, spike_target)
        if spikes is None:
            self.spikes = []
        else:
            self.spikes = spikes

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TimedSynapticInput
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TimedSynapticInput.subclass:
            return TimedSynapticInput.subclass(*args_, **kwargs_)
        else:
            return TimedSynapticInput(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if self.spikes or super(TimedSynapticInput, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TimedSynapticInput",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TimedSynapticInput")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TimedSynapticInput",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="TimedSynapticInput",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="TimedSynapticInput",
    ):
        super(TimedSynapticInput, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TimedSynapticInput",
        )
        if self.synapse is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            outfile.write(" synapse=%s" % (quote_attrib(self.synapse),))
        if self.spike_target is not None and "spike_target" not in already_processed:
            already_processed.add("spike_target")
            outfile.write(
                " spikeTarget=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.spike_target), input_name="spikeTarget"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TimedSynapticInput",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(TimedSynapticInput, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for spike_ in self.spikes:
            spike_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="spike",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("synapse", node)
        if value is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            self.synapse = value
            self.validate_NmlId(self.synapse)  # validate type NmlId
        value = find_attr_value_("spikeTarget", node)
        if value is not None and "spikeTarget" not in already_processed:
            already_processed.add("spikeTarget")
            self.spike_target = value
        super(TimedSynapticInput, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "spike":
            obj_ = Spike.factory(parent_object_=self)
            obj_.build(child_)
            self.spikes.append(obj_)
            obj_.original_tagname_ = "spike"
        super(TimedSynapticInput, self).buildChildren(child_, node, nodeName_, True)


# end class TimedSynapticInput


class SpikeArray(Standalone):
    member_data_items_ = [
        MemberSpec_(
            "spikes",
            "Spike",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Spike",
                u"name": u"spike",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        spikes=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(SpikeArray, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        if spikes is None:
            self.spikes = []
        else:
            self.spikes = spikes

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SpikeArray)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeArray.subclass:
            return SpikeArray.subclass(*args_, **kwargs_)
        else:
            return SpikeArray(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.spikes or super(SpikeArray, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeArray",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeArray")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpikeArray"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeArray",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="SpikeArray"
    ):
        super(SpikeArray, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpikeArray"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeArray",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SpikeArray, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for spike_ in self.spikes:
            spike_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="spike",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(SpikeArray, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "spike":
            obj_ = Spike.factory(parent_object_=self)
            obj_.build(child_)
            self.spikes.append(obj_)
            obj_.original_tagname_ = "spike"
        super(SpikeArray, self).buildChildren(child_, node, nodeName_, True)


# end class SpikeArray


class Spike(BaseNonNegativeIntegerId):
    member_data_items_ = [
        MemberSpec_("time", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = BaseNonNegativeIntegerId

    def __init__(self, neuro_lex_id=None, id=None, time=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(Spike, self).__init__(neuro_lex_id, id, **kwargs_)
        self.time = _cast(None, time)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Spike)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Spike.subclass:
            return Spike.subclass(*args_, **kwargs_)
        else:
            return Spike(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def hasContent_(self):
        if super(Spike, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Spike",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Spike")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Spike"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Spike",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Spike"
    ):
        super(Spike, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Spike"
        )
        if self.time is not None and "time" not in already_processed:
            already_processed.add("time")
            outfile.write(" time=%s" % (quote_attrib(self.time),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Spike",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Spike, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("time", node)
        if value is not None and "time" not in already_processed:
            already_processed.add("time")
            self.time = value
            self.validate_Nml2Quantity_time(
                self.time
            )  # validate type Nml2Quantity_time
        super(Spike, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Spike, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class Spike


class VoltageClampTriple(Standalone):
    member_data_items_ = [
        MemberSpec_("active", "ZeroOrOne", 0, 0, {"use": u"required"}),
        MemberSpec_("delay", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("duration", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "conditioning_voltage", "Nml2Quantity_voltage", 0, 0, {"use": u"required"}
        ),
        MemberSpec_(
            "testing_voltage", "Nml2Quantity_voltage", 0, 0, {"use": u"required"}
        ),
        MemberSpec_(
            "return_voltage", "Nml2Quantity_voltage", 0, 0, {"use": u"required"}
        ),
        MemberSpec_(
            "simple_series_resistance",
            "Nml2Quantity_resistance",
            0,
            0,
            {"use": u"required"},
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        active=None,
        delay=None,
        duration=None,
        conditioning_voltage=None,
        testing_voltage=None,
        return_voltage=None,
        simple_series_resistance=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(VoltageClampTriple, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.active = _cast(float, active)
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.conditioning_voltage = _cast(None, conditioning_voltage)
        self.testing_voltage = _cast(None, testing_voltage)
        self.return_voltage = _cast(None, return_voltage)
        self.simple_series_resistance = _cast(None, simple_series_resistance)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VoltageClampTriple
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VoltageClampTriple.subclass:
            return VoltageClampTriple.subclass(*args_, **kwargs_)
        else:
            return VoltageClampTriple(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_ZeroOrOne(self, value):
        # Validate type ZeroOrOne, a restriction on xs:double.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ["0", "1"]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on ZeroOrOne'
                    % {"value": value.encode("utf-8")}
                )

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV)$"]
    ]

    def validate_Nml2Quantity_resistance(self, value):
        # Validate type Nml2Quantity_resistance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_resistance_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_resistance_patterns_,
                    )
                )

    validate_Nml2Quantity_resistance_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(ohm|kohm|Mohm)$"]
    ]

    def hasContent_(self):
        if super(VoltageClampTriple, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="VoltageClampTriple",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("VoltageClampTriple")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="VoltageClampTriple",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="VoltageClampTriple",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="VoltageClampTriple",
    ):
        super(VoltageClampTriple, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="VoltageClampTriple",
        )
        if self.active is not None and "active" not in already_processed:
            already_processed.add("active")
            outfile.write(" active=%s" % (quote_attrib(self.active),))
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(" delay=%s" % (quote_attrib(self.delay),))
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(" duration=%s" % (quote_attrib(self.duration),))
        if (
            self.conditioning_voltage is not None
            and "conditioning_voltage" not in already_processed
        ):
            already_processed.add("conditioning_voltage")
            outfile.write(
                " conditioningVoltage=%s" % (quote_attrib(self.conditioning_voltage),)
            )
        if (
            self.testing_voltage is not None
            and "testing_voltage" not in already_processed
        ):
            already_processed.add("testing_voltage")
            outfile.write(" testingVoltage=%s" % (quote_attrib(self.testing_voltage),))
        if (
            self.return_voltage is not None
            and "return_voltage" not in already_processed
        ):
            already_processed.add("return_voltage")
            outfile.write(" returnVoltage=%s" % (quote_attrib(self.return_voltage),))
        if (
            self.simple_series_resistance is not None
            and "simple_series_resistance" not in already_processed
        ):
            already_processed.add("simple_series_resistance")
            outfile.write(
                " simpleSeriesResistance=%s"
                % (quote_attrib(self.simple_series_resistance),)
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="VoltageClampTriple",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(VoltageClampTriple, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("active", node)
        if value is not None and "active" not in already_processed:
            already_processed.add("active")
            try:
                self.active = float(value)
            except ValueError as exp:
                raise ValueError("Bad float/double attribute (active): %s" % exp)
            self.validate_ZeroOrOne(self.active)  # validate type ZeroOrOne
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("conditioningVoltage", node)
        if value is not None and "conditioningVoltage" not in already_processed:
            already_processed.add("conditioningVoltage")
            self.conditioning_voltage = value
            self.validate_Nml2Quantity_voltage(
                self.conditioning_voltage
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("testingVoltage", node)
        if value is not None and "testingVoltage" not in already_processed:
            already_processed.add("testingVoltage")
            self.testing_voltage = value
            self.validate_Nml2Quantity_voltage(
                self.testing_voltage
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("returnVoltage", node)
        if value is not None and "returnVoltage" not in already_processed:
            already_processed.add("returnVoltage")
            self.return_voltage = value
            self.validate_Nml2Quantity_voltage(
                self.return_voltage
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("simpleSeriesResistance", node)
        if value is not None and "simpleSeriesResistance" not in already_processed:
            already_processed.add("simpleSeriesResistance")
            self.simple_series_resistance = value
            self.validate_Nml2Quantity_resistance(
                self.simple_series_resistance
            )  # validate type Nml2Quantity_resistance
        super(VoltageClampTriple, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(VoltageClampTriple, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class VoltageClampTriple


class VoltageClamp(Standalone):
    member_data_items_ = [
        MemberSpec_("delay", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("duration", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "target_voltage", "Nml2Quantity_voltage", 0, 0, {"use": u"required"}
        ),
        MemberSpec_(
            "simple_series_resistance",
            "Nml2Quantity_resistance",
            0,
            0,
            {"use": u"required"},
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        duration=None,
        target_voltage=None,
        simple_series_resistance=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(VoltageClamp, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.target_voltage = _cast(None, target_voltage)
        self.simple_series_resistance = _cast(None, simple_series_resistance)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, VoltageClamp)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VoltageClamp.subclass:
            return VoltageClamp.subclass(*args_, **kwargs_)
        else:
            return VoltageClamp(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV)$"]
    ]

    def validate_Nml2Quantity_resistance(self, value):
        # Validate type Nml2Quantity_resistance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_resistance_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_resistance_patterns_,
                    )
                )

    validate_Nml2Quantity_resistance_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(ohm|kohm|Mohm)$"]
    ]

    def hasContent_(self):
        if super(VoltageClamp, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="VoltageClamp",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("VoltageClamp")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="VoltageClamp"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="VoltageClamp",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="VoltageClamp",
    ):
        super(VoltageClamp, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="VoltageClamp"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(" delay=%s" % (quote_attrib(self.delay),))
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(" duration=%s" % (quote_attrib(self.duration),))
        if (
            self.target_voltage is not None
            and "target_voltage" not in already_processed
        ):
            already_processed.add("target_voltage")
            outfile.write(" targetVoltage=%s" % (quote_attrib(self.target_voltage),))
        if (
            self.simple_series_resistance is not None
            and "simple_series_resistance" not in already_processed
        ):
            already_processed.add("simple_series_resistance")
            outfile.write(
                " simpleSeriesResistance=%s"
                % (quote_attrib(self.simple_series_resistance),)
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="VoltageClamp",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(VoltageClamp, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("targetVoltage", node)
        if value is not None and "targetVoltage" not in already_processed:
            already_processed.add("targetVoltage")
            self.target_voltage = value
            self.validate_Nml2Quantity_voltage(
                self.target_voltage
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("simpleSeriesResistance", node)
        if value is not None and "simpleSeriesResistance" not in already_processed:
            already_processed.add("simpleSeriesResistance")
            self.simple_series_resistance = value
            self.validate_Nml2Quantity_resistance(
                self.simple_series_resistance
            )  # validate type Nml2Quantity_resistance
        super(VoltageClamp, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(VoltageClamp, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class VoltageClamp


class CompoundInputDL(Standalone):
    member_data_items_ = [
        MemberSpec_(
            "pulse_generator_dls",
            "PulseGeneratorDL",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"PulseGeneratorDL",
                u"name": u"pulseGeneratorDL",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "sine_generator_dls",
            "SineGeneratorDL",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SineGeneratorDL",
                u"name": u"sineGeneratorDL",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "ramp_generator_dls",
            "RampGeneratorDL",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"RampGeneratorDL",
                u"name": u"rampGeneratorDL",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        pulse_generator_dls=None,
        sine_generator_dls=None,
        ramp_generator_dls=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(CompoundInputDL, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        if pulse_generator_dls is None:
            self.pulse_generator_dls = []
        else:
            self.pulse_generator_dls = pulse_generator_dls
        if sine_generator_dls is None:
            self.sine_generator_dls = []
        else:
            self.sine_generator_dls = sine_generator_dls
        if ramp_generator_dls is None:
            self.ramp_generator_dls = []
        else:
            self.ramp_generator_dls = ramp_generator_dls

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, CompoundInputDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CompoundInputDL.subclass:
            return CompoundInputDL.subclass(*args_, **kwargs_)
        else:
            return CompoundInputDL(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.pulse_generator_dls
            or self.sine_generator_dls
            or self.ramp_generator_dls
            or super(CompoundInputDL, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CompoundInputDL",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CompoundInputDL")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CompoundInputDL"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CompoundInputDL",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="CompoundInputDL",
    ):
        super(CompoundInputDL, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CompoundInputDL"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CompoundInputDL",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(CompoundInputDL, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for pulseGeneratorDL_ in self.pulse_generator_dls:
            pulseGeneratorDL_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="pulseGeneratorDL",
                pretty_print=pretty_print,
            )
        for sineGeneratorDL_ in self.sine_generator_dls:
            sineGeneratorDL_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="sineGeneratorDL",
                pretty_print=pretty_print,
            )
        for rampGeneratorDL_ in self.ramp_generator_dls:
            rampGeneratorDL_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="rampGeneratorDL",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(CompoundInputDL, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "pulseGeneratorDL":
            obj_ = PulseGeneratorDL.factory(parent_object_=self)
            obj_.build(child_)
            self.pulse_generator_dls.append(obj_)
            obj_.original_tagname_ = "pulseGeneratorDL"
        elif nodeName_ == "sineGeneratorDL":
            obj_ = SineGeneratorDL.factory(parent_object_=self)
            obj_.build(child_)
            self.sine_generator_dls.append(obj_)
            obj_.original_tagname_ = "sineGeneratorDL"
        elif nodeName_ == "rampGeneratorDL":
            obj_ = RampGeneratorDL.factory(parent_object_=self)
            obj_.build(child_)
            self.ramp_generator_dls.append(obj_)
            obj_.original_tagname_ = "rampGeneratorDL"
        super(CompoundInputDL, self).buildChildren(child_, node, nodeName_, True)


# end class CompoundInputDL


class CompoundInput(Standalone):
    member_data_items_ = [
        MemberSpec_(
            "pulse_generators",
            "PulseGenerator",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"PulseGenerator",
                u"name": u"pulseGenerator",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "sine_generators",
            "SineGenerator",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SineGenerator",
                u"name": u"sineGenerator",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "ramp_generators",
            "RampGenerator",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"RampGenerator",
                u"name": u"rampGenerator",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        pulse_generators=None,
        sine_generators=None,
        ramp_generators=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(CompoundInput, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        if pulse_generators is None:
            self.pulse_generators = []
        else:
            self.pulse_generators = pulse_generators
        if sine_generators is None:
            self.sine_generators = []
        else:
            self.sine_generators = sine_generators
        if ramp_generators is None:
            self.ramp_generators = []
        else:
            self.ramp_generators = ramp_generators

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, CompoundInput)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CompoundInput.subclass:
            return CompoundInput.subclass(*args_, **kwargs_)
        else:
            return CompoundInput(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.pulse_generators
            or self.sine_generators
            or self.ramp_generators
            or super(CompoundInput, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CompoundInput",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CompoundInput")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CompoundInput"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CompoundInput",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="CompoundInput",
    ):
        super(CompoundInput, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CompoundInput"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CompoundInput",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(CompoundInput, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for pulseGenerator_ in self.pulse_generators:
            pulseGenerator_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="pulseGenerator",
                pretty_print=pretty_print,
            )
        for sineGenerator_ in self.sine_generators:
            sineGenerator_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="sineGenerator",
                pretty_print=pretty_print,
            )
        for rampGenerator_ in self.ramp_generators:
            rampGenerator_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="rampGenerator",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(CompoundInput, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "pulseGenerator":
            obj_ = PulseGenerator.factory(parent_object_=self)
            obj_.build(child_)
            self.pulse_generators.append(obj_)
            obj_.original_tagname_ = "pulseGenerator"
        elif nodeName_ == "sineGenerator":
            obj_ = SineGenerator.factory(parent_object_=self)
            obj_.build(child_)
            self.sine_generators.append(obj_)
            obj_.original_tagname_ = "sineGenerator"
        elif nodeName_ == "rampGenerator":
            obj_ = RampGenerator.factory(parent_object_=self)
            obj_.build(child_)
            self.ramp_generators.append(obj_)
            obj_.original_tagname_ = "rampGenerator"
        super(CompoundInput, self).buildChildren(child_, node, nodeName_, True)


# end class CompoundInput


class RampGeneratorDL(Standalone):
    member_data_items_ = [
        MemberSpec_("delay", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("duration", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("start_amplitude", "Nml2Quantity_none", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "finish_amplitude", "Nml2Quantity_none", 0, 0, {"use": u"required"}
        ),
        MemberSpec_(
            "baseline_amplitude", "Nml2Quantity_none", 0, 0, {"use": u"required"}
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        duration=None,
        start_amplitude=None,
        finish_amplitude=None,
        baseline_amplitude=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(RampGeneratorDL, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.start_amplitude = _cast(None, start_amplitude)
        self.finish_amplitude = _cast(None, finish_amplitude)
        self.baseline_amplitude = _cast(None, baseline_amplitude)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, RampGeneratorDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RampGeneratorDL.subclass:
            return RampGeneratorDL.subclass(*args_, **kwargs_)
        else:
            return RampGeneratorDL(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$"]
    ]

    def hasContent_(self):
        if super(RampGeneratorDL, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RampGeneratorDL",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("RampGeneratorDL")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="RampGeneratorDL"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="RampGeneratorDL",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="RampGeneratorDL",
    ):
        super(RampGeneratorDL, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="RampGeneratorDL"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(" delay=%s" % (quote_attrib(self.delay),))
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(" duration=%s" % (quote_attrib(self.duration),))
        if (
            self.start_amplitude is not None
            and "start_amplitude" not in already_processed
        ):
            already_processed.add("start_amplitude")
            outfile.write(" startAmplitude=%s" % (quote_attrib(self.start_amplitude),))
        if (
            self.finish_amplitude is not None
            and "finish_amplitude" not in already_processed
        ):
            already_processed.add("finish_amplitude")
            outfile.write(
                " finishAmplitude=%s" % (quote_attrib(self.finish_amplitude),)
            )
        if (
            self.baseline_amplitude is not None
            and "baseline_amplitude" not in already_processed
        ):
            already_processed.add("baseline_amplitude")
            outfile.write(
                " baselineAmplitude=%s" % (quote_attrib(self.baseline_amplitude),)
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RampGeneratorDL",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(RampGeneratorDL, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("startAmplitude", node)
        if value is not None and "startAmplitude" not in already_processed:
            already_processed.add("startAmplitude")
            self.start_amplitude = value
            self.validate_Nml2Quantity_none(
                self.start_amplitude
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("finishAmplitude", node)
        if value is not None and "finishAmplitude" not in already_processed:
            already_processed.add("finishAmplitude")
            self.finish_amplitude = value
            self.validate_Nml2Quantity_none(
                self.finish_amplitude
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("baselineAmplitude", node)
        if value is not None and "baselineAmplitude" not in already_processed:
            already_processed.add("baselineAmplitude")
            self.baseline_amplitude = value
            self.validate_Nml2Quantity_none(
                self.baseline_amplitude
            )  # validate type Nml2Quantity_none
        super(RampGeneratorDL, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(RampGeneratorDL, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class RampGeneratorDL


class RampGenerator(Standalone):
    member_data_items_ = [
        MemberSpec_("delay", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("duration", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "start_amplitude", "Nml2Quantity_current", 0, 0, {"use": u"required"}
        ),
        MemberSpec_(
            "finish_amplitude", "Nml2Quantity_current", 0, 0, {"use": u"required"}
        ),
        MemberSpec_(
            "baseline_amplitude", "Nml2Quantity_current", 0, 0, {"use": u"required"}
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        duration=None,
        start_amplitude=None,
        finish_amplitude=None,
        baseline_amplitude=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(RampGenerator, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.start_amplitude = _cast(None, start_amplitude)
        self.finish_amplitude = _cast(None, finish_amplitude)
        self.baseline_amplitude = _cast(None, baseline_amplitude)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, RampGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RampGenerator.subclass:
            return RampGenerator.subclass(*args_, **kwargs_)
        else:
            return RampGenerator(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_current_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_current_patterns_,
                    )
                )

    validate_Nml2Quantity_current_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A|uA|nA|pA)$"]
    ]

    def hasContent_(self):
        if super(RampGenerator, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RampGenerator",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("RampGenerator")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="RampGenerator"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="RampGenerator",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="RampGenerator",
    ):
        super(RampGenerator, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="RampGenerator"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(" delay=%s" % (quote_attrib(self.delay),))
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(" duration=%s" % (quote_attrib(self.duration),))
        if (
            self.start_amplitude is not None
            and "start_amplitude" not in already_processed
        ):
            already_processed.add("start_amplitude")
            outfile.write(" startAmplitude=%s" % (quote_attrib(self.start_amplitude),))
        if (
            self.finish_amplitude is not None
            and "finish_amplitude" not in already_processed
        ):
            already_processed.add("finish_amplitude")
            outfile.write(
                " finishAmplitude=%s" % (quote_attrib(self.finish_amplitude),)
            )
        if (
            self.baseline_amplitude is not None
            and "baseline_amplitude" not in already_processed
        ):
            already_processed.add("baseline_amplitude")
            outfile.write(
                " baselineAmplitude=%s" % (quote_attrib(self.baseline_amplitude),)
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RampGenerator",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(RampGenerator, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("startAmplitude", node)
        if value is not None and "startAmplitude" not in already_processed:
            already_processed.add("startAmplitude")
            self.start_amplitude = value
            self.validate_Nml2Quantity_current(
                self.start_amplitude
            )  # validate type Nml2Quantity_current
        value = find_attr_value_("finishAmplitude", node)
        if value is not None and "finishAmplitude" not in already_processed:
            already_processed.add("finishAmplitude")
            self.finish_amplitude = value
            self.validate_Nml2Quantity_current(
                self.finish_amplitude
            )  # validate type Nml2Quantity_current
        value = find_attr_value_("baselineAmplitude", node)
        if value is not None and "baselineAmplitude" not in already_processed:
            already_processed.add("baselineAmplitude")
            self.baseline_amplitude = value
            self.validate_Nml2Quantity_current(
                self.baseline_amplitude
            )  # validate type Nml2Quantity_current
        super(RampGenerator, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(RampGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class RampGenerator


class SineGeneratorDL(Standalone):
    member_data_items_ = [
        MemberSpec_("delay", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("phase", "Nml2Quantity_none", 0, 0, {"use": u"required"}),
        MemberSpec_("duration", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("amplitude", "Nml2Quantity_none", 0, 0, {"use": u"required"}),
        MemberSpec_("period", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        phase=None,
        duration=None,
        amplitude=None,
        period=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(SineGeneratorDL, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.phase = _cast(None, phase)
        self.duration = _cast(None, duration)
        self.amplitude = _cast(None, amplitude)
        self.period = _cast(None, period)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SineGeneratorDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SineGeneratorDL.subclass:
            return SineGeneratorDL.subclass(*args_, **kwargs_)
        else:
            return SineGeneratorDL(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$"]
    ]

    def hasContent_(self):
        if super(SineGeneratorDL, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SineGeneratorDL",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SineGeneratorDL")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SineGeneratorDL"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SineGeneratorDL",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SineGeneratorDL",
    ):
        super(SineGeneratorDL, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SineGeneratorDL"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(" delay=%s" % (quote_attrib(self.delay),))
        if self.phase is not None and "phase" not in already_processed:
            already_processed.add("phase")
            outfile.write(" phase=%s" % (quote_attrib(self.phase),))
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(" duration=%s" % (quote_attrib(self.duration),))
        if self.amplitude is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            outfile.write(" amplitude=%s" % (quote_attrib(self.amplitude),))
        if self.period is not None and "period" not in already_processed:
            already_processed.add("period")
            outfile.write(" period=%s" % (quote_attrib(self.period),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SineGeneratorDL",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SineGeneratorDL, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("phase", node)
        if value is not None and "phase" not in already_processed:
            already_processed.add("phase")
            self.phase = value
            self.validate_Nml2Quantity_none(
                self.phase
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("amplitude", node)
        if value is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            self.amplitude = value
            self.validate_Nml2Quantity_none(
                self.amplitude
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("period", node)
        if value is not None and "period" not in already_processed:
            already_processed.add("period")
            self.period = value
            self.validate_Nml2Quantity_time(
                self.period
            )  # validate type Nml2Quantity_time
        super(SineGeneratorDL, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SineGeneratorDL, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class SineGeneratorDL


class SineGenerator(Standalone):
    member_data_items_ = [
        MemberSpec_("delay", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("phase", "Nml2Quantity_none", 0, 0, {"use": u"required"}),
        MemberSpec_("duration", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("amplitude", "Nml2Quantity_current", 0, 0, {"use": u"required"}),
        MemberSpec_("period", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        phase=None,
        duration=None,
        amplitude=None,
        period=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(SineGenerator, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.phase = _cast(None, phase)
        self.duration = _cast(None, duration)
        self.amplitude = _cast(None, amplitude)
        self.period = _cast(None, period)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SineGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SineGenerator.subclass:
            return SineGenerator.subclass(*args_, **kwargs_)
        else:
            return SineGenerator(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$"]
    ]

    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_current_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_current_patterns_,
                    )
                )

    validate_Nml2Quantity_current_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A|uA|nA|pA)$"]
    ]

    def hasContent_(self):
        if super(SineGenerator, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SineGenerator",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SineGenerator")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SineGenerator"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SineGenerator",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SineGenerator",
    ):
        super(SineGenerator, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SineGenerator"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(" delay=%s" % (quote_attrib(self.delay),))
        if self.phase is not None and "phase" not in already_processed:
            already_processed.add("phase")
            outfile.write(" phase=%s" % (quote_attrib(self.phase),))
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(" duration=%s" % (quote_attrib(self.duration),))
        if self.amplitude is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            outfile.write(" amplitude=%s" % (quote_attrib(self.amplitude),))
        if self.period is not None and "period" not in already_processed:
            already_processed.add("period")
            outfile.write(" period=%s" % (quote_attrib(self.period),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SineGenerator",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SineGenerator, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("phase", node)
        if value is not None and "phase" not in already_processed:
            already_processed.add("phase")
            self.phase = value
            self.validate_Nml2Quantity_none(
                self.phase
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("amplitude", node)
        if value is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            self.amplitude = value
            self.validate_Nml2Quantity_current(
                self.amplitude
            )  # validate type Nml2Quantity_current
        value = find_attr_value_("period", node)
        if value is not None and "period" not in already_processed:
            already_processed.add("period")
            self.period = value
            self.validate_Nml2Quantity_time(
                self.period
            )  # validate type Nml2Quantity_time
        super(SineGenerator, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SineGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class SineGenerator


class PulseGeneratorDL(Standalone):
    """Generates a constant current pulse of a certain amplitude (non
    dimensional) for a specified duration after a delay."""

    member_data_items_ = [
        MemberSpec_("delay", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("duration", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("amplitude", "Nml2Quantity_none", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        duration=None,
        amplitude=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(PulseGeneratorDL, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.amplitude = _cast(None, amplitude)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PulseGeneratorDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PulseGeneratorDL.subclass:
            return PulseGeneratorDL.subclass(*args_, **kwargs_)
        else:
            return PulseGeneratorDL(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$"]
    ]

    def hasContent_(self):
        if super(PulseGeneratorDL, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PulseGeneratorDL",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PulseGeneratorDL")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="PulseGeneratorDL",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PulseGeneratorDL",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PulseGeneratorDL",
    ):
        super(PulseGeneratorDL, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="PulseGeneratorDL",
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(" delay=%s" % (quote_attrib(self.delay),))
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(" duration=%s" % (quote_attrib(self.duration),))
        if self.amplitude is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            outfile.write(" amplitude=%s" % (quote_attrib(self.amplitude),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PulseGeneratorDL",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(PulseGeneratorDL, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("amplitude", node)
        if value is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            self.amplitude = value
            self.validate_Nml2Quantity_none(
                self.amplitude
            )  # validate type Nml2Quantity_none
        super(PulseGeneratorDL, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(PulseGeneratorDL, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class PulseGeneratorDL


class PulseGenerator(Standalone):
    """Generates a constant current pulse of a certain amplitude (with
    dimensions for current) for a specified duration after a delay."""

    member_data_items_ = [
        MemberSpec_("delay", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("duration", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("amplitude", "Nml2Quantity_current", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        duration=None,
        amplitude=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(PulseGenerator, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.amplitude = _cast(None, amplitude)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PulseGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PulseGenerator.subclass:
            return PulseGenerator.subclass(*args_, **kwargs_)
        else:
            return PulseGenerator(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_current_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_current_patterns_,
                    )
                )

    validate_Nml2Quantity_current_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A|uA|nA|pA)$"]
    ]

    def hasContent_(self):
        if super(PulseGenerator, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PulseGenerator",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PulseGenerator")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="PulseGenerator"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PulseGenerator",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PulseGenerator",
    ):
        super(PulseGenerator, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="PulseGenerator"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(" delay=%s" % (quote_attrib(self.delay),))
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(" duration=%s" % (quote_attrib(self.duration),))
        if self.amplitude is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            outfile.write(" amplitude=%s" % (quote_attrib(self.amplitude),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PulseGenerator",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(PulseGenerator, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("amplitude", node)
        if value is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            self.amplitude = value
            self.validate_Nml2Quantity_current(
                self.amplitude
            )  # validate type Nml2Quantity_current
        super(PulseGenerator, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(PulseGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class PulseGenerator


class ReactionScheme(Base):
    member_data_items_ = [
        MemberSpec_("source", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("type", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "__ANY__",
            "__ANY__",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"processContents": u"skip",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        source=None,
        type=None,
        anytypeobjs_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ReactionScheme, self).__init__(neuro_lex_id, id, **kwargs_)
        self.source = _cast(None, source)
        self.type = _cast(None, type)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReactionScheme)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReactionScheme.subclass:
            return ReactionScheme.subclass(*args_, **kwargs_)
        else:
            return ReactionScheme(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.anytypeobjs_ or super(ReactionScheme, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReactionScheme",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReactionScheme")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ReactionScheme"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReactionScheme",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReactionScheme",
    ):
        super(ReactionScheme, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ReactionScheme"
        )
        if self.source is not None and "source" not in already_processed:
            already_processed.add("source")
            outfile.write(
                " source=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.source), input_name="source"
                        )
                    ),
                )
            )
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReactionScheme",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ReactionScheme, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("source", node)
        if value is not None and "source" not in already_processed:
            already_processed.add("source")
            self.source = value
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
        super(ReactionScheme, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, "ReactionScheme")
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(ReactionScheme, self).buildChildren(child_, node, nodeName_, True)


# end class ReactionScheme


class ExtracellularProperties(Base):
    member_data_items_ = [
        MemberSpec_(
            "species",
            "Species",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Species",
                u"name": u"species",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(self, neuro_lex_id=None, id=None, species=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ExtracellularProperties, self).__init__(neuro_lex_id, id, **kwargs_)
        if species is None:
            self.species = []
        else:
            self.species = species

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExtracellularProperties
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExtracellularProperties.subclass:
            return ExtracellularProperties.subclass(*args_, **kwargs_)
        else:
            return ExtracellularProperties(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if self.species or super(ExtracellularProperties, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ExtracellularProperties",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ExtracellularProperties")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ExtracellularProperties",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ExtracellularProperties",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ExtracellularProperties",
    ):
        super(ExtracellularProperties, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ExtracellularProperties",
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ExtracellularProperties",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ExtracellularProperties, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for species_ in self.species:
            species_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="species",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(ExtracellularProperties, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "species":
            obj_ = Species.factory(parent_object_=self)
            obj_.build(child_)
            self.species.append(obj_)
            obj_.original_tagname_ = "species"
        super(ExtracellularProperties, self).buildChildren(
            child_, node, nodeName_, True
        )


# end class ExtracellularProperties


class ChannelDensityGHK2(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""

    member_data_items_ = [
        MemberSpec_("ion_channel", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "cond_density",
            "Nml2Quantity_conductanceDensity",
            0,
            1,
            {"use": u"optional"},
        ),
        MemberSpec_("segment_groups", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_("segments", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        cond_density=None,
        segment_groups="all",
        segments=None,
        ion=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ChannelDensityGHK2, self).__init__(neuro_lex_id, id, **kwargs_)
        self.ion_channel = _cast(None, ion_channel)
        self.cond_density = _cast(None, cond_density)
        self.segment_groups = _cast(None, segment_groups)
        self.segments = _cast(None, segments)
        self.ion = _cast(None, ion)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityGHK2
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityGHK2.subclass:
            return ChannelDensityGHK2.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityGHK2(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_conductanceDensity(self, value):
        # Validate type Nml2Quantity_conductanceDensity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_conductanceDensity_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_conductanceDensity_patterns_,
                    )
                )

    validate_Nml2Quantity_conductanceDensity_patterns_ = [
        [
            u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S_per_m2|mS_per_cm2|S_per_cm2)$"
        ]
    ]

    def hasContent_(self):
        if super(ChannelDensityGHK2, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityGHK2",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensityGHK2")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityGHK2",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityGHK2",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityGHK2",
    ):
        super(ChannelDensityGHK2, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityGHK2",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(" ionChannel=%s" % (quote_attrib(self.ion_channel),))
        if self.cond_density is not None and "cond_density" not in already_processed:
            already_processed.add("cond_density")
            outfile.write(" condDensity=%s" % (quote_attrib(self.cond_density),))
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(" segmentGroup=%s" % (quote_attrib(self.segment_groups),))
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(" segment=%s" % (quote_attrib(self.segments),))
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(" ion=%s" % (quote_attrib(self.ion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityGHK2",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityGHK2, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("condDensity", node)
        if value is not None and "condDensity" not in already_processed:
            already_processed.add("condDensity")
            self.cond_density = value
            self.validate_Nml2Quantity_conductanceDensity(
                self.cond_density
            )  # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            self.segments = value
            self.validate_NmlId(self.segments)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelDensityGHK2, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ChannelDensityGHK2, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class ChannelDensityGHK2


class ChannelDensityGHK(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""

    member_data_items_ = [
        MemberSpec_("ion_channel", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "permeability", "Nml2Quantity_permeability", 0, 0, {"use": u"required"}
        ),
        MemberSpec_("segment_groups", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_("segments", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        permeability=None,
        segment_groups="all",
        segments=None,
        ion=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ChannelDensityGHK, self).__init__(neuro_lex_id, id, **kwargs_)
        self.ion_channel = _cast(None, ion_channel)
        self.permeability = _cast(None, permeability)
        self.segment_groups = _cast(None, segment_groups)
        self.segments = _cast(None, segments)
        self.ion = _cast(None, ion)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ChannelDensityGHK)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityGHK.subclass:
            return ChannelDensityGHK.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityGHK(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_permeability(self, value):
        # Validate type Nml2Quantity_permeability, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_permeability_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_permeability_patterns_,
                    )
                )

    validate_Nml2Quantity_permeability_patterns_ = [
        [
            u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(m_per_s|                        um_per_ms|cm_per_s|cm_per_ms)$"
        ]
    ]

    def hasContent_(self):
        if super(ChannelDensityGHK, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityGHK",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensityGHK")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityGHK",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityGHK",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityGHK",
    ):
        super(ChannelDensityGHK, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityGHK",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(" ionChannel=%s" % (quote_attrib(self.ion_channel),))
        if self.permeability is not None and "permeability" not in already_processed:
            already_processed.add("permeability")
            outfile.write(" permeability=%s" % (quote_attrib(self.permeability),))
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(" segmentGroup=%s" % (quote_attrib(self.segment_groups),))
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(" segment=%s" % (quote_attrib(self.segments),))
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(" ion=%s" % (quote_attrib(self.ion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityGHK",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityGHK, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("permeability", node)
        if value is not None and "permeability" not in already_processed:
            already_processed.add("permeability")
            self.permeability = value
            self.validate_Nml2Quantity_permeability(
                self.permeability
            )  # validate type Nml2Quantity_permeability
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            self.segments = value
            self.validate_NmlId(self.segments)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelDensityGHK, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ChannelDensityGHK, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class ChannelDensityGHK


class ChannelDensityNernst(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""

    member_data_items_ = [
        MemberSpec_("ion_channel", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "cond_density",
            "Nml2Quantity_conductanceDensity",
            0,
            1,
            {"use": u"optional"},
        ),
        MemberSpec_("segment_groups", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_("segments", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"VariableParameter",
                u"name": u"variableParameter",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        cond_density=None,
        segment_groups="all",
        segments=None,
        ion=None,
        variable_parameters=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ChannelDensityNernst, self).__init__(
            neuro_lex_id, id, extensiontype_, **kwargs_
        )
        self.ion_channel = _cast(None, ion_channel)
        self.cond_density = _cast(None, cond_density)
        self.segment_groups = _cast(None, segment_groups)
        self.segments = _cast(None, segments)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNernst
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNernst.subclass:
            return ChannelDensityNernst.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNernst(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_conductanceDensity(self, value):
        # Validate type Nml2Quantity_conductanceDensity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_conductanceDensity_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_conductanceDensity_patterns_,
                    )
                )

    validate_Nml2Quantity_conductanceDensity_patterns_ = [
        [
            u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S_per_m2|mS_per_cm2|S_per_cm2)$"
        ]
    ]

    def hasContent_(self):
        if self.variable_parameters or super(ChannelDensityNernst, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityNernst",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensityNernst")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNernst",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityNernst",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityNernst",
    ):
        super(ChannelDensityNernst, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNernst",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(" ionChannel=%s" % (quote_attrib(self.ion_channel),))
        if self.cond_density is not None and "cond_density" not in already_processed:
            already_processed.add("cond_density")
            outfile.write(" condDensity=%s" % (quote_attrib(self.cond_density),))
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(" segmentGroup=%s" % (quote_attrib(self.segment_groups),))
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(" segment=%s" % (quote_attrib(self.segments),))
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(" ion=%s" % (quote_attrib(self.ion),))
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityNernst",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityNernst, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("condDensity", node)
        if value is not None and "condDensity" not in already_processed:
            already_processed.add("condDensity")
            self.cond_density = value
            self.validate_Nml2Quantity_conductanceDensity(
                self.cond_density
            )  # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            self.segments = value
            self.validate_NmlId(self.segments)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(ChannelDensityNernst, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelDensityNernst, self).buildChildren(child_, node, nodeName_, True)


# end class ChannelDensityNernst


class ChannelDensity(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""

    member_data_items_ = [
        MemberSpec_("ion_channel", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "cond_density",
            "Nml2Quantity_conductanceDensity",
            0,
            1,
            {"use": u"optional"},
        ),
        MemberSpec_("erev", "Nml2Quantity_voltage", 0, 0, {"use": u"required"}),
        MemberSpec_("segment_groups", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_("segments", "NonNegativeInteger", 0, 1, {"use": u"optional"}),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"VariableParameter",
                u"name": u"variableParameter",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        cond_density=None,
        erev=None,
        segment_groups="all",
        segments=None,
        ion=None,
        variable_parameters=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ChannelDensity, self).__init__(
            neuro_lex_id, id, extensiontype_, **kwargs_
        )
        self.ion_channel = _cast(None, ion_channel)
        self.cond_density = _cast(None, cond_density)
        self.erev = _cast(None, erev)
        self.segment_groups = _cast(None, segment_groups)
        self.segments = _cast(int, segments)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ChannelDensity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensity.subclass:
            return ChannelDensity.subclass(*args_, **kwargs_)
        else:
            return ChannelDensity(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_conductanceDensity(self, value):
        # Validate type Nml2Quantity_conductanceDensity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_conductanceDensity_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_conductanceDensity_patterns_,
                    )
                )

    validate_Nml2Quantity_conductanceDensity_patterns_ = [
        [
            u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S_per_m2|mS_per_cm2|S_per_cm2)$"
        ]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV)$"]
    ]

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if self.variable_parameters or super(ChannelDensity, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensity",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensity")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ChannelDensity"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensity",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensity",
    ):
        super(ChannelDensity, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ChannelDensity"
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(" ionChannel=%s" % (quote_attrib(self.ion_channel),))
        if self.cond_density is not None and "cond_density" not in already_processed:
            already_processed.add("cond_density")
            outfile.write(" condDensity=%s" % (quote_attrib(self.cond_density),))
        if self.erev is not None and "erev" not in already_processed:
            already_processed.add("erev")
            outfile.write(" erev=%s" % (quote_attrib(self.erev),))
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(" segmentGroup=%s" % (quote_attrib(self.segment_groups),))
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(" segment=%s" % (quote_attrib(self.segments),))
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(" ion=%s" % (quote_attrib(self.ion),))
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensity",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensity, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("condDensity", node)
        if value is not None and "condDensity" not in already_processed:
            already_processed.add("condDensity")
            self.cond_density = value
            self.validate_Nml2Quantity_conductanceDensity(
                self.cond_density
            )  # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_("erev", node)
        if value is not None and "erev" not in already_processed:
            already_processed.add("erev")
            self.erev = value
            self.validate_Nml2Quantity_voltage(
                self.erev
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            try:
                self.segments = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.segments < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segments
            )  # validate type NonNegativeInteger
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(ChannelDensity, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelDensity, self).buildChildren(child_, node, nodeName_, True)


# end class ChannelDensity


class ChannelDensityNonUniformGHK(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""

    member_data_items_ = [
        MemberSpec_("ion_channel", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"VariableParameter",
                u"name": u"variableParameter",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        ion=None,
        variable_parameters=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ChannelDensityNonUniformGHK, self).__init__(neuro_lex_id, id, **kwargs_)
        self.ion_channel = _cast(None, ion_channel)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNonUniformGHK
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNonUniformGHK.subclass:
            return ChannelDensityNonUniformGHK.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNonUniformGHK(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if (
            self.variable_parameters
            or super(ChannelDensityNonUniformGHK, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityNonUniformGHK",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensityNonUniformGHK")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniformGHK",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityNonUniformGHK",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityNonUniformGHK",
    ):
        super(ChannelDensityNonUniformGHK, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniformGHK",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(" ionChannel=%s" % (quote_attrib(self.ion_channel),))
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(" ion=%s" % (quote_attrib(self.ion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityNonUniformGHK",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityNonUniformGHK, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelDensityNonUniformGHK, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelDensityNonUniformGHK, self).buildChildren(
            child_, node, nodeName_, True
        )


# end class ChannelDensityNonUniformGHK


class ChannelDensityNonUniformNernst(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""

    member_data_items_ = [
        MemberSpec_("ion_channel", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"VariableParameter",
                u"name": u"variableParameter",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        ion=None,
        variable_parameters=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ChannelDensityNonUniformNernst, self).__init__(
            neuro_lex_id, id, **kwargs_
        )
        self.ion_channel = _cast(None, ion_channel)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNonUniformNernst
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNonUniformNernst.subclass:
            return ChannelDensityNonUniformNernst.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNonUniformNernst(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if (
            self.variable_parameters
            or super(ChannelDensityNonUniformNernst, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityNonUniformNernst",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "ChannelDensityNonUniformNernst"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniformNernst",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityNonUniformNernst",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityNonUniformNernst",
    ):
        super(ChannelDensityNonUniformNernst, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniformNernst",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(" ionChannel=%s" % (quote_attrib(self.ion_channel),))
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(" ion=%s" % (quote_attrib(self.ion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityNonUniformNernst",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityNonUniformNernst, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelDensityNonUniformNernst, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelDensityNonUniformNernst, self).buildChildren(
            child_, node, nodeName_, True
        )


# end class ChannelDensityNonUniformNernst


class ChannelDensityNonUniform(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""

    member_data_items_ = [
        MemberSpec_("ion_channel", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("erev", "Nml2Quantity_voltage", 0, 0, {"use": u"required"}),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"VariableParameter",
                u"name": u"variableParameter",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        erev=None,
        ion=None,
        variable_parameters=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ChannelDensityNonUniform, self).__init__(neuro_lex_id, id, **kwargs_)
        self.ion_channel = _cast(None, ion_channel)
        self.erev = _cast(None, erev)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNonUniform
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNonUniform.subclass:
            return ChannelDensityNonUniform.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNonUniform(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV)$"]
    ]

    def hasContent_(self):
        if (
            self.variable_parameters
            or super(ChannelDensityNonUniform, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityNonUniform",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensityNonUniform")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniform",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityNonUniform",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityNonUniform",
    ):
        super(ChannelDensityNonUniform, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniform",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(" ionChannel=%s" % (quote_attrib(self.ion_channel),))
        if self.erev is not None and "erev" not in already_processed:
            already_processed.add("erev")
            outfile.write(" erev=%s" % (quote_attrib(self.erev),))
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(" ion=%s" % (quote_attrib(self.ion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityNonUniform",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityNonUniform, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("erev", node)
        if value is not None and "erev" not in already_processed:
            already_processed.add("erev")
            self.erev = value
            self.validate_Nml2Quantity_voltage(
                self.erev
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelDensityNonUniform, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelDensityNonUniform, self).buildChildren(
            child_, node, nodeName_, True
        )


# end class ChannelDensityNonUniform


class ChannelPopulation(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""

    member_data_items_ = [
        MemberSpec_("ion_channel", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("number", "NonNegativeInteger", 0, 0, {"use": u"required"}),
        MemberSpec_("erev", "Nml2Quantity_voltage", 0, 0, {"use": u"required"}),
        MemberSpec_("segment_groups", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_("segments", "NonNegativeInteger", 0, 1, {"use": u"optional"}),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"VariableParameter",
                u"name": u"variableParameter",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        number=None,
        erev=None,
        segment_groups="all",
        segments=None,
        ion=None,
        variable_parameters=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ChannelPopulation, self).__init__(neuro_lex_id, id, **kwargs_)
        self.ion_channel = _cast(None, ion_channel)
        self.number = _cast(int, number)
        self.erev = _cast(None, erev)
        self.segment_groups = _cast(None, segment_groups)
        self.segments = _cast(int, segments)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ChannelPopulation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelPopulation.subclass:
            return ChannelPopulation.subclass(*args_, **kwargs_)
        else:
            return ChannelPopulation(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV)$"]
    ]

    def hasContent_(self):
        if self.variable_parameters or super(ChannelPopulation, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelPopulation",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelPopulation")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelPopulation",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelPopulation",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelPopulation",
    ):
        super(ChannelPopulation, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelPopulation",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(" ionChannel=%s" % (quote_attrib(self.ion_channel),))
        if self.number is not None and "number" not in already_processed:
            already_processed.add("number")
            outfile.write(" number=%s" % (quote_attrib(self.number),))
        if self.erev is not None and "erev" not in already_processed:
            already_processed.add("erev")
            outfile.write(" erev=%s" % (quote_attrib(self.erev),))
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(" segmentGroup=%s" % (quote_attrib(self.segment_groups),))
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(" segment=%s" % (quote_attrib(self.segments),))
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(" ion=%s" % (quote_attrib(self.ion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelPopulation",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelPopulation, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("number", node)
        if value is not None and "number" not in already_processed:
            already_processed.add("number")
            try:
                self.number = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.number < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.number
            )  # validate type NonNegativeInteger
        value = find_attr_value_("erev", node)
        if value is not None and "erev" not in already_processed:
            already_processed.add("erev")
            self.erev = value
            self.validate_Nml2Quantity_voltage(
                self.erev
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            try:
                self.segments = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.segments < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segments
            )  # validate type NonNegativeInteger
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelPopulation, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelPopulation, self).buildChildren(child_, node, nodeName_, True)


# end class ChannelPopulation


class BiophysicalProperties2CaPools(Standalone):
    """Standalone element which is usually inside a single cell, but could
    be outside and referenced by id."""

    member_data_items_ = [
        MemberSpec_(
            "membrane_properties2_ca_pools",
            "MembraneProperties2CaPools",
            0,
            0,
            {
                u"type": u"MembraneProperties2CaPools",
                u"name": u"membraneProperties2CaPools",
            },
            None,
        ),
        MemberSpec_(
            "intracellular_properties2_ca_pools",
            "IntracellularProperties2CaPools",
            0,
            1,
            {
                u"type": u"IntracellularProperties2CaPools",
                u"name": u"intracellularProperties2CaPools",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "extracellular_properties",
            "ExtracellularProperties",
            0,
            1,
            {
                u"type": u"ExtracellularProperties",
                u"name": u"extracellularProperties",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        membrane_properties2_ca_pools=None,
        intracellular_properties2_ca_pools=None,
        extracellular_properties=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(BiophysicalProperties2CaPools, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.membrane_properties2_ca_pools = membrane_properties2_ca_pools
        self.intracellular_properties2_ca_pools = intracellular_properties2_ca_pools
        self.extracellular_properties = extracellular_properties

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BiophysicalProperties2CaPools
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BiophysicalProperties2CaPools.subclass:
            return BiophysicalProperties2CaPools.subclass(*args_, **kwargs_)
        else:
            return BiophysicalProperties2CaPools(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.membrane_properties2_ca_pools is not None
            or self.intracellular_properties2_ca_pools is not None
            or self.extracellular_properties is not None
            or super(BiophysicalProperties2CaPools, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BiophysicalProperties2CaPools",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BiophysicalProperties2CaPools")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BiophysicalProperties2CaPools",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BiophysicalProperties2CaPools",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BiophysicalProperties2CaPools",
    ):
        super(BiophysicalProperties2CaPools, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BiophysicalProperties2CaPools",
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BiophysicalProperties2CaPools",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BiophysicalProperties2CaPools, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.membrane_properties2_ca_pools is not None:
            self.membrane_properties2_ca_pools.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="membraneProperties2CaPools",
                pretty_print=pretty_print,
            )
        if self.intracellular_properties2_ca_pools is not None:
            self.intracellular_properties2_ca_pools.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="intracellularProperties2CaPools",
                pretty_print=pretty_print,
            )
        if self.extracellular_properties is not None:
            self.extracellular_properties.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="extracellularProperties",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(BiophysicalProperties2CaPools, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "membraneProperties2CaPools":
            obj_ = MembraneProperties2CaPools.factory(parent_object_=self)
            obj_.build(child_)
            self.membrane_properties2_ca_pools = obj_
            obj_.original_tagname_ = "membraneProperties2CaPools"
        elif nodeName_ == "intracellularProperties2CaPools":
            obj_ = IntracellularProperties2CaPools.factory(parent_object_=self)
            obj_.build(child_)
            self.intracellular_properties2_ca_pools = obj_
            obj_.original_tagname_ = "intracellularProperties2CaPools"
        elif nodeName_ == "extracellularProperties":
            obj_ = ExtracellularProperties.factory(parent_object_=self)
            obj_.build(child_)
            self.extracellular_properties = obj_
            obj_.original_tagname_ = "extracellularProperties"
        super(BiophysicalProperties2CaPools, self).buildChildren(
            child_, node, nodeName_, True
        )


# end class BiophysicalProperties2CaPools


class BiophysicalProperties(Standalone):
    """Standalone element which is usually inside a single cell, but could
    be outside and referenced by id."""

    member_data_items_ = [
        MemberSpec_(
            "membrane_properties",
            "MembraneProperties",
            0,
            0,
            {u"type": u"MembraneProperties", u"name": u"membraneProperties"},
            None,
        ),
        MemberSpec_(
            "intracellular_properties",
            "IntracellularProperties",
            0,
            1,
            {
                u"type": u"IntracellularProperties",
                u"name": u"intracellularProperties",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "extracellular_properties",
            "ExtracellularProperties",
            0,
            1,
            {
                u"type": u"ExtracellularProperties",
                u"name": u"extracellularProperties",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        membrane_properties=None,
        intracellular_properties=None,
        extracellular_properties=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(BiophysicalProperties, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.membrane_properties = membrane_properties
        self.intracellular_properties = intracellular_properties
        self.extracellular_properties = extracellular_properties

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BiophysicalProperties
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BiophysicalProperties.subclass:
            return BiophysicalProperties.subclass(*args_, **kwargs_)
        else:
            return BiophysicalProperties(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.membrane_properties is not None
            or self.intracellular_properties is not None
            or self.extracellular_properties is not None
            or super(BiophysicalProperties, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BiophysicalProperties",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BiophysicalProperties")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BiophysicalProperties",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BiophysicalProperties",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BiophysicalProperties",
    ):
        super(BiophysicalProperties, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BiophysicalProperties",
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BiophysicalProperties",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BiophysicalProperties, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.membrane_properties is not None:
            self.membrane_properties.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="membraneProperties",
                pretty_print=pretty_print,
            )
        if self.intracellular_properties is not None:
            self.intracellular_properties.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="intracellularProperties",
                pretty_print=pretty_print,
            )
        if self.extracellular_properties is not None:
            self.extracellular_properties.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="extracellularProperties",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(BiophysicalProperties, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "membraneProperties":
            class_obj_ = self.get_class_obj_(child_, MembraneProperties)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.membrane_properties = obj_
            obj_.original_tagname_ = "membraneProperties"
        elif nodeName_ == "intracellularProperties":
            class_obj_ = self.get_class_obj_(child_, IntracellularProperties)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.intracellular_properties = obj_
            obj_.original_tagname_ = "intracellularProperties"
        elif nodeName_ == "extracellularProperties":
            obj_ = ExtracellularProperties.factory(parent_object_=self)
            obj_.build(child_)
            self.extracellular_properties = obj_
            obj_.original_tagname_ = "extracellularProperties"
        super(BiophysicalProperties, self).buildChildren(child_, node, nodeName_, True)


# end class BiophysicalProperties


class InhomogeneousParameter(Base):
    member_data_items_ = [
        MemberSpec_("variable", "xs:string", 0, 0, {"use": u"required"}),
        MemberSpec_("metric", "Metric", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "proximal",
            "ProximalDetails",
            0,
            1,
            {u"type": u"ProximalDetails", u"name": u"proximal", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "distal",
            "DistalDetails",
            0,
            1,
            {u"type": u"DistalDetails", u"name": u"distal", u"minOccurs": u"0"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        variable=None,
        metric=None,
        proximal=None,
        distal=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(InhomogeneousParameter, self).__init__(neuro_lex_id, id, **kwargs_)
        self.variable = _cast(None, variable)
        self.metric = _cast(None, metric)
        self.proximal = proximal
        self.distal = distal

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InhomogeneousParameter
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InhomogeneousParameter.subclass:
            return InhomogeneousParameter.subclass(*args_, **kwargs_)
        else:
            return InhomogeneousParameter(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Metric(self, value):
        # Validate type Metric, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ["Path Length from root"]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on Metric'
                    % {"value": value.encode("utf-8")}
                )

    def hasContent_(self):
        if (
            self.proximal is not None
            or self.distal is not None
            or super(InhomogeneousParameter, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InhomogeneousParameter",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InhomogeneousParameter")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="InhomogeneousParameter",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InhomogeneousParameter",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="InhomogeneousParameter",
    ):
        super(InhomogeneousParameter, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="InhomogeneousParameter",
        )
        if self.variable is not None and "variable" not in already_processed:
            already_processed.add("variable")
            outfile.write(
                " variable=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.variable), input_name="variable"
                        )
                    ),
                )
            )
        if self.metric is not None and "metric" not in already_processed:
            already_processed.add("metric")
            outfile.write(" metric=%s" % (quote_attrib(self.metric),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InhomogeneousParameter",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(InhomogeneousParameter, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.proximal is not None:
            self.proximal.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="proximal",
                pretty_print=pretty_print,
            )
        if self.distal is not None:
            self.distal.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="distal",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("variable", node)
        if value is not None and "variable" not in already_processed:
            already_processed.add("variable")
            self.variable = value
        value = find_attr_value_("metric", node)
        if value is not None and "metric" not in already_processed:
            already_processed.add("metric")
            self.metric = value
            self.validate_Metric(self.metric)  # validate type Metric
        super(InhomogeneousParameter, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "proximal":
            obj_ = ProximalDetails.factory(parent_object_=self)
            obj_.build(child_)
            self.proximal = obj_
            obj_.original_tagname_ = "proximal"
        elif nodeName_ == "distal":
            obj_ = DistalDetails.factory(parent_object_=self)
            obj_.build(child_)
            self.distal = obj_
            obj_.original_tagname_ = "distal"
        super(InhomogeneousParameter, self).buildChildren(child_, node, nodeName_, True)


# end class InhomogeneousParameter


class SegmentGroup(Base):
    member_data_items_ = [
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "properties",
            "Property",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Property",
                u"name": u"property",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "annotation",
            "Annotation",
            0,
            1,
            {u"type": u"Annotation", u"name": u"annotation", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "members",
            "Member",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Member",
                u"name": u"member",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "includes",
            "Include",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Include",
                u"name": u"include",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "paths",
            "Path",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Path",
                u"name": u"path",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "sub_trees",
            "SubTree",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SubTree",
                u"name": u"subTree",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "inhomogeneous_parameters",
            "InhomogeneousParameter",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"InhomogeneousParameter",
                u"name": u"inhomogeneousParameter",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        notes=None,
        properties=None,
        annotation=None,
        members=None,
        includes=None,
        paths=None,
        sub_trees=None,
        inhomogeneous_parameters=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(SegmentGroup, self).__init__(neuro_lex_id, id, **kwargs_)
        self.notes = notes
        self.validate_Notes(self.notes)
        if properties is None:
            self.properties = []
        else:
            self.properties = properties
        self.annotation = annotation
        if members is None:
            self.members = []
        else:
            self.members = members
        if includes is None:
            self.includes = []
        else:
            self.includes = includes
        if paths is None:
            self.paths = []
        else:
            self.paths = paths
        if sub_trees is None:
            self.sub_trees = []
        else:
            self.sub_trees = sub_trees
        if inhomogeneous_parameters is None:
            self.inhomogeneous_parameters = []
        else:
            self.inhomogeneous_parameters = inhomogeneous_parameters

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SegmentGroup)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SegmentGroup.subclass:
            return SegmentGroup.subclass(*args_, **kwargs_)
        else:
            return SegmentGroup(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.notes is not None
            or self.properties
            or self.annotation is not None
            or self.members
            or self.includes
            or self.paths
            or self.sub_trees
            or self.inhomogeneous_parameters
            or super(SegmentGroup, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SegmentGroup",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SegmentGroup")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SegmentGroup"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SegmentGroup",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SegmentGroup",
    ):
        super(SegmentGroup, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SegmentGroup"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SegmentGroup",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SegmentGroup, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        for property_ in self.properties:
            property_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="property",
                pretty_print=pretty_print,
            )
        if self.annotation is not None:
            self.annotation.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="annotation",
                pretty_print=pretty_print,
            )
        for member_ in self.members:
            member_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="member",
                pretty_print=pretty_print,
            )
        for include_ in self.includes:
            include_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="include",
                pretty_print=pretty_print,
            )
        for path_ in self.paths:
            path_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="path",
                pretty_print=pretty_print,
            )
        for subTree_ in self.sub_trees:
            subTree_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="subTree",
                pretty_print=pretty_print,
            )
        for inhomogeneousParameter_ in self.inhomogeneous_parameters:
            inhomogeneousParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="inhomogeneousParameter",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(SegmentGroup, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "property":
            obj_ = Property.factory(parent_object_=self)
            obj_.build(child_)
            self.properties.append(obj_)
            obj_.original_tagname_ = "property"
        elif nodeName_ == "annotation":
            obj_ = Annotation.factory(parent_object_=self)
            obj_.build(child_)
            self.annotation = obj_
            obj_.original_tagname_ = "annotation"
        elif nodeName_ == "member":
            obj_ = Member.factory(parent_object_=self)
            obj_.build(child_)
            self.members.append(obj_)
            obj_.original_tagname_ = "member"
        elif nodeName_ == "include":
            obj_ = Include.factory(parent_object_=self)
            obj_.build(child_)
            self.includes.append(obj_)
            obj_.original_tagname_ = "include"
        elif nodeName_ == "path":
            obj_ = Path.factory(parent_object_=self)
            obj_.build(child_)
            self.paths.append(obj_)
            obj_.original_tagname_ = "path"
        elif nodeName_ == "subTree":
            obj_ = SubTree.factory(parent_object_=self)
            obj_.build(child_)
            self.sub_trees.append(obj_)
            obj_.original_tagname_ = "subTree"
        elif nodeName_ == "inhomogeneousParameter":
            obj_ = InhomogeneousParameter.factory(parent_object_=self)
            obj_.build(child_)
            self.inhomogeneous_parameters.append(obj_)
            obj_.original_tagname_ = "inhomogeneousParameter"
        super(SegmentGroup, self).buildChildren(child_, node, nodeName_, True)

    def __str__(self):

        return (
            "SegmentGroup: "
            + str(self.id)
            + ", "
            + str(len(self.members))
            + " member(s), "
            + str(len(self.includes))
            + " included group(s)"
        )

    def __repr__(self):

        return str(self)


# end class SegmentGroup


class Segment(BaseNonNegativeIntegerId):
    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 1, {"use": u"optional"}),
        MemberSpec_(
            "parent",
            "SegmentParent",
            0,
            1,
            {u"type": u"SegmentParent", u"name": u"parent", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "proximal",
            "Point3DWithDiam",
            0,
            1,
            {u"type": u"Point3DWithDiam", u"name": u"proximal", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "distal",
            "Point3DWithDiam",
            0,
            0,
            {u"type": u"Point3DWithDiam", u"name": u"distal", u"minOccurs": u"1"},
            None,
        ),
    ]
    subclass = None
    superclass = BaseNonNegativeIntegerId

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        name=None,
        parent=None,
        proximal=None,
        distal=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(Segment, self).__init__(neuro_lex_id, id, **kwargs_)
        self.name = _cast(None, name)
        self.parent = parent
        self.proximal = proximal
        self.distal = distal

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Segment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Segment.subclass:
            return Segment.subclass(*args_, **kwargs_)
        else:
            return Segment(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.parent is not None
            or self.proximal is not None
            or self.distal is not None
            or super(Segment, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Segment",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Segment")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Segment"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Segment",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Segment"
    ):
        super(Segment, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Segment"
        )
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Segment",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Segment, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.parent is not None:
            self.parent.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="parent",
                pretty_print=pretty_print,
            )
        if self.proximal is not None:
            self.proximal.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="proximal",
                pretty_print=pretty_print,
            )
        if self.distal is not None:
            self.distal.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="distal",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        super(Segment, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "parent":
            obj_ = SegmentParent.factory(parent_object_=self)
            obj_.build(child_)
            self.parent = obj_
            obj_.original_tagname_ = "parent"
        elif nodeName_ == "proximal":
            obj_ = Point3DWithDiam.factory(parent_object_=self)
            obj_.build(child_)
            self.proximal = obj_
            obj_.original_tagname_ = "proximal"
        elif nodeName_ == "distal":
            obj_ = Point3DWithDiam.factory(parent_object_=self)
            obj_.build(child_)
            self.distal = obj_
            obj_.original_tagname_ = "distal"
        super(Segment, self).buildChildren(child_, node, nodeName_, True)

    @property
    def length(self):
        """Get the length of the segment.

        :returns: length of the segment
        :rtype: float
        """

        if self.proximal == None:
            raise Exception(
                "Cannot get length of segment "
                + str(self.id)
                + " using the length property, since no proximal point is set on it (the proximal point comes from the parent segment). Use the method get_segment_length(segment_id) on the cell instead."
            )

        prox_x = self.proximal.x
        prox_y = self.proximal.y
        prox_z = self.proximal.z

        dist_x = self.distal.x
        dist_y = self.distal.y
        dist_z = self.distal.z

        length = (
            (prox_x - dist_x) ** 2 + (prox_y - dist_y) ** 2 + (prox_z - dist_z) ** 2
        ) ** (0.5)

        return length

    def __str__(self):

        return (
            "<Segment|"
            + str(self.id)
            + ("|" + self.name if self.name is not None else "")
            + ">"
        )

    def __repr__(self):

        return str(self)

    @property
    def volume(self):
        """Get the volume of the segment.

        :returns: volume of segment
        :rtype: float
        """

        from math import pi

        if self.proximal == None:
            raise Exception(
                "Cannot get volume of segment "
                + str(self.id)
                + " using the volume property, since no proximal point is set on it (the proximal point comes from the parent segment). Use the method get_segment_volume(segment_id) on the cell instead."
            )

        prox_rad = self.proximal.diameter / 2.0
        dist_rad = self.distal.diameter / 2.0

        if (
            self.proximal.x == self.distal.x
            and self.proximal.y == self.distal.y
            and self.proximal.z == self.distal.z
        ):

            if prox_rad != dist_rad:
                raise Exception(
                    "Cannot get volume of segment "
                    + str(self.id)
                    + ". The (x,y,z) coordinates of the proximal and distal points match (i.e. it is a sphere), but the diameters of these points are different, making the volume calculation ambiguous."
                )

            return 4.0 / 3 * pi * prox_rad ** 3

        length = self.length

        volume = (
            (pi / 3) * length * (prox_rad ** 2 + dist_rad ** 2 + prox_rad * dist_rad)
        )

        return volume

    @property
    def surface_area(self):
        """Get the surface area of the segment.

        :returns: surface area of segment
        :rtype: float
        """
        from math import pi
        from math import sqrt

        if self.proximal == None:
            raise Exception(
                "Cannot get surface area of segment "
                + str(self.id)
                + " using the surface_area property, since no proximal point is set on it (the proximal point comes from the parent segment). Use the method get_segment_surface_area(segment_id) on the cell instead."
            )

        prox_rad = self.proximal.diameter / 2.0
        dist_rad = self.distal.diameter / 2.0

        if (
            self.proximal.x == self.distal.x
            and self.proximal.y == self.distal.y
            and self.proximal.z == self.distal.z
        ):

            if prox_rad != dist_rad:
                raise Exception(
                    "Cannot get surface area of segment "
                    + str(self.id)
                    + ". The (x,y,z) coordinates of the proximal and distal points match (i.e. it is a sphere), but the diameters of these points are different, making the surface area calculation ambiguous."
                )

            return 4.0 * pi * prox_rad ** 2

        length = self.length

        surface_area = (
            pi * (prox_rad + dist_rad) * sqrt((prox_rad - dist_rad) ** 2 + length ** 2)
        )

        return surface_area

    # end class Segment


class Morphology(Standalone):
    """Standalone element which is usually inside a single cell, but could
    be outside and referenced by id."""

    member_data_items_ = [
        MemberSpec_(
            "segments",
            "Segment",
            1,
            0,
            {u"maxOccurs": u"unbounded", u"type": u"Segment", u"name": u"segment"},
            None,
        ),
        MemberSpec_(
            "segment_groups",
            "SegmentGroup",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SegmentGroup",
                u"name": u"segmentGroup",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        segments=None,
        segment_groups=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(Morphology, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        if segments is None:
            self.segments = []
        else:
            self.segments = segments
        if segment_groups is None:
            self.segment_groups = []
        else:
            self.segment_groups = segment_groups

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Morphology)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Morphology.subclass:
            return Morphology.subclass(*args_, **kwargs_)
        else:
            return Morphology(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.segments
            or self.segment_groups
            or super(Morphology, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Morphology",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Morphology")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Morphology"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Morphology",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Morphology"
    ):
        super(Morphology, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Morphology"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Morphology",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Morphology, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for segment_ in self.segments:
            segment_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="segment",
                pretty_print=pretty_print,
            )
        for segmentGroup_ in self.segment_groups:
            segmentGroup_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="segmentGroup",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(Morphology, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "segment":
            obj_ = Segment.factory(parent_object_=self)
            obj_.build(child_)
            self.segments.append(obj_)
            obj_.original_tagname_ = "segment"
        elif nodeName_ == "segmentGroup":
            obj_ = SegmentGroup.factory(parent_object_=self)
            obj_.build(child_)
            self.segment_groups.append(obj_)
            obj_.original_tagname_ = "segmentGroup"
        super(Morphology, self).buildChildren(child_, node, nodeName_, True)

    @property
    def num_segments(self):
        """Get the number of segments included in this cell morphology.

        :returns: number of segments
        :rtype: int
        """
        return len(self.segments)


# end class Morphology


class BaseCell(Standalone):
    member_data_items_ = []
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(BaseCell, self).__init__(
            neuro_lex_id,
            id,
            metaid,
            notes,
            properties,
            annotation,
            extensiontype_,
            **kwargs_
        )
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, BaseCell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseCell.subclass:
            return BaseCell.subclass(*args_, **kwargs_)
        else:
            return BaseCell(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(BaseCell, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseCell",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BaseCell")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseCell"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BaseCell",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="BaseCell"
    ):
        super(BaseCell, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseCell"
        )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseCell",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BaseCell, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(BaseCell, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseCell, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class BaseCell


class BaseSynapse(Standalone):
    member_data_items_ = []
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(BaseSynapse, self).__init__(
            neuro_lex_id,
            id,
            metaid,
            notes,
            properties,
            annotation,
            extensiontype_,
            **kwargs_
        )
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, BaseSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseSynapse.subclass:
            return BaseSynapse.subclass(*args_, **kwargs_)
        else:
            return BaseSynapse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(BaseSynapse, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseSynapse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BaseSynapse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseSynapse"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BaseSynapse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BaseSynapse",
    ):
        super(BaseSynapse, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseSynapse"
        )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseSynapse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BaseSynapse, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(BaseSynapse, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class BaseSynapse


class FixedFactorConcentrationModel(Standalone):
    """Should not be required, as it's present on the species element!"""

    member_data_items_ = [
        MemberSpec_("ion", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "resting_conc", "Nml2Quantity_concentration", 0, 0, {"use": u"required"}
        ),
        MemberSpec_("decay_constant", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_("rho", "Nml2Quantity_rhoFactor", 0, 0, {"use": u"required"}),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        ion=None,
        resting_conc=None,
        decay_constant=None,
        rho=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(FixedFactorConcentrationModel, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.ion = _cast(None, ion)
        self.resting_conc = _cast(None, resting_conc)
        self.decay_constant = _cast(None, decay_constant)
        self.rho = _cast(None, rho)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FixedFactorConcentrationModel
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FixedFactorConcentrationModel.subclass:
            return FixedFactorConcentrationModel.subclass(*args_, **kwargs_)
        else:
            return FixedFactorConcentrationModel(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_concentration_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_concentration_patterns_,
                    )
                )

    validate_Nml2Quantity_concentration_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m3|mol_per_cm3|M|mM)$"]
    ]

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_rhoFactor(self, value):
        # Validate type Nml2Quantity_rhoFactor, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_rhoFactor_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_rhoFactor_patterns_,
                    )
                )

    validate_Nml2Quantity_rhoFactor_patterns_ = [
        [
            u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m_per_A_per_s|mol_per_cm_per_uA_per_ms)$"
        ]
    ]

    def hasContent_(self):
        if super(FixedFactorConcentrationModel, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="FixedFactorConcentrationModel",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("FixedFactorConcentrationModel")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="FixedFactorConcentrationModel",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="FixedFactorConcentrationModel",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="FixedFactorConcentrationModel",
    ):
        super(FixedFactorConcentrationModel, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="FixedFactorConcentrationModel",
        )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(" ion=%s" % (quote_attrib(self.ion),))
        if self.resting_conc is not None and "resting_conc" not in already_processed:
            already_processed.add("resting_conc")
            outfile.write(" restingConc=%s" % (quote_attrib(self.resting_conc),))
        if (
            self.decay_constant is not None
            and "decay_constant" not in already_processed
        ):
            already_processed.add("decay_constant")
            outfile.write(" decayConstant=%s" % (quote_attrib(self.decay_constant),))
        if self.rho is not None and "rho" not in already_processed:
            already_processed.add("rho")
            outfile.write(" rho=%s" % (quote_attrib(self.rho),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="FixedFactorConcentrationModel",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(FixedFactorConcentrationModel, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        value = find_attr_value_("restingConc", node)
        if value is not None and "restingConc" not in already_processed:
            already_processed.add("restingConc")
            self.resting_conc = value
            self.validate_Nml2Quantity_concentration(
                self.resting_conc
            )  # validate type Nml2Quantity_concentration
        value = find_attr_value_("decayConstant", node)
        if value is not None and "decayConstant" not in already_processed:
            already_processed.add("decayConstant")
            self.decay_constant = value
            self.validate_Nml2Quantity_time(
                self.decay_constant
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("rho", node)
        if value is not None and "rho" not in already_processed:
            already_processed.add("rho")
            self.rho = value
            self.validate_Nml2Quantity_rhoFactor(
                self.rho
            )  # validate type Nml2Quantity_rhoFactor
        super(FixedFactorConcentrationModel, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(FixedFactorConcentrationModel, self).buildChildren(
            child_, node, nodeName_, True
        )
        pass


# end class FixedFactorConcentrationModel


class DecayingPoolConcentrationModel(Standalone):
    """Should not be required, as it's present on the species element!"""

    member_data_items_ = [
        MemberSpec_("ion", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "resting_conc", "Nml2Quantity_concentration", 0, 0, {"use": u"required"}
        ),
        MemberSpec_("decay_constant", "Nml2Quantity_time", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "shell_thickness", "Nml2Quantity_length", 0, 0, {"use": u"required"}
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        ion=None,
        resting_conc=None,
        decay_constant=None,
        shell_thickness=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(DecayingPoolConcentrationModel, self).__init__(
            neuro_lex_id,
            id,
            metaid,
            notes,
            properties,
            annotation,
            extensiontype_,
            **kwargs_
        )
        self.ion = _cast(None, ion)
        self.resting_conc = _cast(None, resting_conc)
        self.decay_constant = _cast(None, decay_constant)
        self.shell_thickness = _cast(None, shell_thickness)
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DecayingPoolConcentrationModel
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DecayingPoolConcentrationModel.subclass:
            return DecayingPoolConcentrationModel.subclass(*args_, **kwargs_)
        else:
            return DecayingPoolConcentrationModel(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_concentration_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_concentration_patterns_,
                    )
                )

    validate_Nml2Quantity_concentration_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m3|mol_per_cm3|M|mM)$"]
    ]

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms)$"]
    ]

    def validate_Nml2Quantity_length(self, value):
        # Validate type Nml2Quantity_length, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_length_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_length_patterns_,
                    )
                )

    validate_Nml2Quantity_length_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(m|cm|um)$"]
    ]

    def hasContent_(self):
        if super(DecayingPoolConcentrationModel, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DecayingPoolConcentrationModel",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "DecayingPoolConcentrationModel"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="DecayingPoolConcentrationModel",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="DecayingPoolConcentrationModel",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="DecayingPoolConcentrationModel",
    ):
        super(DecayingPoolConcentrationModel, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="DecayingPoolConcentrationModel",
        )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(" ion=%s" % (quote_attrib(self.ion),))
        if self.resting_conc is not None and "resting_conc" not in already_processed:
            already_processed.add("resting_conc")
            outfile.write(" restingConc=%s" % (quote_attrib(self.resting_conc),))
        if (
            self.decay_constant is not None
            and "decay_constant" not in already_processed
        ):
            already_processed.add("decay_constant")
            outfile.write(" decayConstant=%s" % (quote_attrib(self.decay_constant),))
        if (
            self.shell_thickness is not None
            and "shell_thickness" not in already_processed
        ):
            already_processed.add("shell_thickness")
            outfile.write(" shellThickness=%s" % (quote_attrib(self.shell_thickness),))
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DecayingPoolConcentrationModel",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(DecayingPoolConcentrationModel, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        value = find_attr_value_("restingConc", node)
        if value is not None and "restingConc" not in already_processed:
            already_processed.add("restingConc")
            self.resting_conc = value
            self.validate_Nml2Quantity_concentration(
                self.resting_conc
            )  # validate type Nml2Quantity_concentration
        value = find_attr_value_("decayConstant", node)
        if value is not None and "decayConstant" not in already_processed:
            already_processed.add("decayConstant")
            self.decay_constant = value
            self.validate_Nml2Quantity_time(
                self.decay_constant
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("shellThickness", node)
        if value is not None and "shellThickness" not in already_processed:
            already_processed.add("shellThickness")
            self.shell_thickness = value
            self.validate_Nml2Quantity_length(
                self.shell_thickness
            )  # validate type Nml2Quantity_length
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(DecayingPoolConcentrationModel, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(DecayingPoolConcentrationModel, self).buildChildren(
            child_, node, nodeName_, True
        )
        pass


# end class DecayingPoolConcentrationModel


class GateFractionalSubgate(Base):
    member_data_items_ = [
        MemberSpec_(
            "fractional_conductance", "Nml2Quantity_none", 0, 0, {"use": u"required"}
        ),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "q10_settings",
            "Q10Settings",
            0,
            1,
            {u"type": u"Q10Settings", u"name": u"q10Settings", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "steady_state",
            "HHVariable",
            0,
            0,
            {u"type": u"HHVariable", u"name": u"steadyState", u"minOccurs": u"1"},
            None,
        ),
        MemberSpec_(
            "time_course",
            "HHTime",
            0,
            0,
            {u"type": u"HHTime", u"name": u"timeCourse", u"minOccurs": u"1"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        fractional_conductance=None,
        notes=None,
        q10_settings=None,
        steady_state=None,
        time_course=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(GateFractionalSubgate, self).__init__(neuro_lex_id, id, **kwargs_)
        self.fractional_conductance = _cast(None, fractional_conductance)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.steady_state = steady_state
        self.time_course = time_course

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateFractionalSubgate
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateFractionalSubgate.subclass:
            return GateFractionalSubgate.subclass(*args_, **kwargs_)
        else:
            return GateFractionalSubgate(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$"]
    ]

    def hasContent_(self):
        if (
            self.notes is not None
            or self.q10_settings is not None
            or self.steady_state is not None
            or self.time_course is not None
            or super(GateFractionalSubgate, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateFractionalSubgate",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GateFractionalSubgate")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="GateFractionalSubgate",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GateFractionalSubgate",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="GateFractionalSubgate",
    ):
        super(GateFractionalSubgate, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="GateFractionalSubgate",
        )
        if (
            self.fractional_conductance is not None
            and "fractional_conductance" not in already_processed
        ):
            already_processed.add("fractional_conductance")
            outfile.write(
                " fractionalConductance=%s"
                % (quote_attrib(self.fractional_conductance),)
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateFractionalSubgate",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(GateFractionalSubgate, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.q10_settings is not None:
            self.q10_settings.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="q10Settings",
                pretty_print=pretty_print,
            )
        if self.steady_state is not None:
            self.steady_state.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="steadyState",
                pretty_print=pretty_print,
            )
        if self.time_course is not None:
            self.time_course.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="timeCourse",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("fractionalConductance", node)
        if value is not None and "fractionalConductance" not in already_processed:
            already_processed.add("fractionalConductance")
            self.fractional_conductance = value
            self.validate_Nml2Quantity_none(
                self.fractional_conductance
            )  # validate type Nml2Quantity_none
        super(GateFractionalSubgate, self).buildAttributes(
            node, attrs, already_processed
        )

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "q10Settings":
            obj_ = Q10Settings.factory(parent_object_=self)
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = "q10Settings"
        elif nodeName_ == "steadyState":
            obj_ = HHVariable.factory(parent_object_=self)
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = "steadyState"
        elif nodeName_ == "timeCourse":
            obj_ = HHTime.factory(parent_object_=self)
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = "timeCourse"
        super(GateFractionalSubgate, self).buildChildren(child_, node, nodeName_, True)


# end class GateFractionalSubgate


class GateFractional(Base):
    member_data_items_ = [
        MemberSpec_("instances", "PositiveInteger", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "q10_settings",
            "Q10Settings",
            0,
            1,
            {u"type": u"Q10Settings", u"name": u"q10Settings", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "sub_gates",
            "GateFractionalSubgate",
            1,
            0,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"GateFractionalSubgate",
                u"name": u"subGate",
                u"minOccurs": u"1",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        instances=None,
        notes=None,
        q10_settings=None,
        sub_gates=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(GateFractional, self).__init__(neuro_lex_id, id, **kwargs_)
        self.instances = _cast(int, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        if sub_gates is None:
            self.sub_gates = []
        else:
            self.sub_gates = sub_gates

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, GateFractional)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateFractional.subclass:
            return GateFractional.subclass(*args_, **kwargs_)
        else:
            return GateFractional(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.notes is not None
            or self.q10_settings is not None
            or self.sub_gates
            or super(GateFractional, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateFractional",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GateFractional")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateFractional"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GateFractional",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="GateFractional",
    ):
        super(GateFractional, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateFractional"
        )
        if self.instances is not None and "instances" not in already_processed:
            already_processed.add("instances")
            outfile.write(" instances=%s" % (quote_attrib(self.instances),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateFractional",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(GateFractional, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.q10_settings is not None:
            self.q10_settings.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="q10Settings",
                pretty_print=pretty_print,
            )
        for subGate_ in self.sub_gates:
            subGate_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="subGate",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("instances", node)
        if value is not None and "instances" not in already_processed:
            already_processed.add("instances")
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.instances <= 0:
                raise_parse_error(node, "Invalid PositiveInteger")
            self.validate_PositiveInteger(
                self.instances
            )  # validate type PositiveInteger
        super(GateFractional, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "q10Settings":
            obj_ = Q10Settings.factory(parent_object_=self)
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = "q10Settings"
        elif nodeName_ == "subGate":
            obj_ = GateFractionalSubgate.factory(parent_object_=self)
            obj_.build(child_)
            self.sub_gates.append(obj_)
            obj_.original_tagname_ = "subGate"
        super(GateFractional, self).buildChildren(child_, node, nodeName_, True)


# end class GateFractional


class GateHHInstantaneous(Base):
    member_data_items_ = [
        MemberSpec_("instances", "PositiveInteger", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "steady_state",
            "HHVariable",
            0,
            0,
            {u"type": u"HHVariable", u"name": u"steadyState", u"minOccurs": u"1"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        instances=None,
        notes=None,
        steady_state=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(GateHHInstantaneous, self).__init__(neuro_lex_id, id, **kwargs_)
        self.instances = _cast(int, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.steady_state = steady_state

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateHHInstantaneous
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHInstantaneous.subclass:
            return GateHHInstantaneous.subclass(*args_, **kwargs_)
        else:
            return GateHHInstantaneous(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.notes is not None
            or self.steady_state is not None
            or super(GateHHInstantaneous, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHInstantaneous",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GateHHInstantaneous")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="GateHHInstantaneous",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GateHHInstantaneous",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="GateHHInstantaneous",
    ):
        super(GateHHInstantaneous, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="GateHHInstantaneous",
        )
        if self.instances is not None and "instances" not in already_processed:
            already_processed.add("instances")
            outfile.write(" instances=%s" % (quote_attrib(self.instances),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHInstantaneous",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(GateHHInstantaneous, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.steady_state is not None:
            self.steady_state.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="steadyState",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("instances", node)
        if value is not None and "instances" not in already_processed:
            already_processed.add("instances")
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.instances <= 0:
                raise_parse_error(node, "Invalid PositiveInteger")
            self.validate_PositiveInteger(
                self.instances
            )  # validate type PositiveInteger
        super(GateHHInstantaneous, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "steadyState":
            obj_ = HHVariable.factory(parent_object_=self)
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = "steadyState"
        super(GateHHInstantaneous, self).buildChildren(child_, node, nodeName_, True)


# end class GateHHInstantaneous


class GateHHRatesInf(Base):
    member_data_items_ = [
        MemberSpec_("instances", "PositiveInteger", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "q10_settings",
            "Q10Settings",
            0,
            1,
            {u"type": u"Q10Settings", u"name": u"q10Settings", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "forward_rate",
            "HHRate",
            0,
            0,
            {u"type": u"HHRate", u"name": u"forwardRate", u"minOccurs": u"1"},
            None,
        ),
        MemberSpec_(
            "reverse_rate",
            "HHRate",
            0,
            0,
            {u"type": u"HHRate", u"name": u"reverseRate", u"minOccurs": u"1"},
            None,
        ),
        MemberSpec_(
            "steady_state",
            "HHVariable",
            0,
            0,
            {u"type": u"HHVariable", u"name": u"steadyState", u"minOccurs": u"1"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        instances=None,
        notes=None,
        q10_settings=None,
        forward_rate=None,
        reverse_rate=None,
        steady_state=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(GateHHRatesInf, self).__init__(neuro_lex_id, id, **kwargs_)
        self.instances = _cast(int, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
        self.steady_state = steady_state

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, GateHHRatesInf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHRatesInf.subclass:
            return GateHHRatesInf.subclass(*args_, **kwargs_)
        else:
            return GateHHRatesInf(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.notes is not None
            or self.q10_settings is not None
            or self.forward_rate is not None
            or self.reverse_rate is not None
            or self.steady_state is not None
            or super(GateHHRatesInf, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHRatesInf",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GateHHRatesInf")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateHHRatesInf"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GateHHRatesInf",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="GateHHRatesInf",
    ):
        super(GateHHRatesInf, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateHHRatesInf"
        )
        if self.instances is not None and "instances" not in already_processed:
            already_processed.add("instances")
            outfile.write(" instances=%s" % (quote_attrib(self.instances),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHRatesInf",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(GateHHRatesInf, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.q10_settings is not None:
            self.q10_settings.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="q10Settings",
                pretty_print=pretty_print,
            )
        if self.forward_rate is not None:
            self.forward_rate.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="forwardRate",
                pretty_print=pretty_print,
            )
        if self.reverse_rate is not None:
            self.reverse_rate.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="reverseRate",
                pretty_print=pretty_print,
            )
        if self.steady_state is not None:
            self.steady_state.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="steadyState",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("instances", node)
        if value is not None and "instances" not in already_processed:
            already_processed.add("instances")
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.instances <= 0:
                raise_parse_error(node, "Invalid PositiveInteger")
            self.validate_PositiveInteger(
                self.instances
            )  # validate type PositiveInteger
        super(GateHHRatesInf, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "q10Settings":
            obj_ = Q10Settings.factory(parent_object_=self)
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = "q10Settings"
        elif nodeName_ == "forwardRate":
            obj_ = HHRate.factory(parent_object_=self)
            obj_.build(child_)
            self.forward_rate = obj_
            obj_.original_tagname_ = "forwardRate"
        elif nodeName_ == "reverseRate":
            obj_ = HHRate.factory(parent_object_=self)
            obj_.build(child_)
            self.reverse_rate = obj_
            obj_.original_tagname_ = "reverseRate"
        elif nodeName_ == "steadyState":
            obj_ = HHVariable.factory(parent_object_=self)
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = "steadyState"
        super(GateHHRatesInf, self).buildChildren(child_, node, nodeName_, True)


# end class GateHHRatesInf


class GateHHRatesTau(Base):
    member_data_items_ = [
        MemberSpec_("instances", "PositiveInteger", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "q10_settings",
            "Q10Settings",
            0,
            1,
            {u"type": u"Q10Settings", u"name": u"q10Settings", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "forward_rate",
            "HHRate",
            0,
            0,
            {u"type": u"HHRate", u"name": u"forwardRate", u"minOccurs": u"1"},
            None,
        ),
        MemberSpec_(
            "reverse_rate",
            "HHRate",
            0,
            0,
            {u"type": u"HHRate", u"name": u"reverseRate", u"minOccurs": u"1"},
            None,
        ),
        MemberSpec_(
            "time_course",
            "HHTime",
            0,
            0,
            {u"type": u"HHTime", u"name": u"timeCourse", u"minOccurs": u"1"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        instances=None,
        notes=None,
        q10_settings=None,
        forward_rate=None,
        reverse_rate=None,
        time_course=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(GateHHRatesTau, self).__init__(neuro_lex_id, id, **kwargs_)
        self.instances = _cast(int, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
        self.time_course = time_course

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, GateHHRatesTau)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHRatesTau.subclass:
            return GateHHRatesTau.subclass(*args_, **kwargs_)
        else:
            return GateHHRatesTau(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.notes is not None
            or self.q10_settings is not None
            or self.forward_rate is not None
            or self.reverse_rate is not None
            or self.time_course is not None
            or super(GateHHRatesTau, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHRatesTau",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GateHHRatesTau")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateHHRatesTau"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GateHHRatesTau",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="GateHHRatesTau",
    ):
        super(GateHHRatesTau, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateHHRatesTau"
        )
        if self.instances is not None and "instances" not in already_processed:
            already_processed.add("instances")
            outfile.write(" instances=%s" % (quote_attrib(self.instances),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHRatesTau",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(GateHHRatesTau, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.q10_settings is not None:
            self.q10_settings.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="q10Settings",
                pretty_print=pretty_print,
            )
        if self.forward_rate is not None:
            self.forward_rate.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="forwardRate",
                pretty_print=pretty_print,
            )
        if self.reverse_rate is not None:
            self.reverse_rate.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="reverseRate",
                pretty_print=pretty_print,
            )
        if self.time_course is not None:
            self.time_course.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="timeCourse",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("instances", node)
        if value is not None and "instances" not in already_processed:
            already_processed.add("instances")
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.instances <= 0:
                raise_parse_error(node, "Invalid PositiveInteger")
            self.validate_PositiveInteger(
                self.instances
            )  # validate type PositiveInteger
        super(GateHHRatesTau, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "q10Settings":
            obj_ = Q10Settings.factory(parent_object_=self)
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = "q10Settings"
        elif nodeName_ == "forwardRate":
            obj_ = HHRate.factory(parent_object_=self)
            obj_.build(child_)
            self.forward_rate = obj_
            obj_.original_tagname_ = "forwardRate"
        elif nodeName_ == "reverseRate":
            obj_ = HHRate.factory(parent_object_=self)
            obj_.build(child_)
            self.reverse_rate = obj_
            obj_.original_tagname_ = "reverseRate"
        elif nodeName_ == "timeCourse":
            obj_ = HHTime.factory(parent_object_=self)
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = "timeCourse"
        super(GateHHRatesTau, self).buildChildren(child_, node, nodeName_, True)


# end class GateHHRatesTau


class GateHHRatesTauInf(Base):
    member_data_items_ = [
        MemberSpec_("instances", "PositiveInteger", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "q10_settings",
            "Q10Settings",
            0,
            1,
            {u"type": u"Q10Settings", u"name": u"q10Settings", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "forward_rate",
            "HHRate",
            0,
            0,
            {u"type": u"HHRate", u"name": u"forwardRate", u"minOccurs": u"1"},
            None,
        ),
        MemberSpec_(
            "reverse_rate",
            "HHRate",
            0,
            0,
            {u"type": u"HHRate", u"name": u"reverseRate", u"minOccurs": u"1"},
            None,
        ),
        MemberSpec_(
            "time_course",
            "HHTime",
            0,
            0,
            {u"type": u"HHTime", u"name": u"timeCourse", u"minOccurs": u"1"},
            None,
        ),
        MemberSpec_(
            "steady_state",
            "HHVariable",
            0,
            0,
            {u"type": u"HHVariable", u"name": u"steadyState", u"minOccurs": u"1"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        instances=None,
        notes=None,
        q10_settings=None,
        forward_rate=None,
        reverse_rate=None,
        time_course=None,
        steady_state=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(GateHHRatesTauInf, self).__init__(neuro_lex_id, id, **kwargs_)
        self.instances = _cast(int, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
        self.time_course = time_course
        self.steady_state = steady_state

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, GateHHRatesTauInf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHRatesTauInf.subclass:
            return GateHHRatesTauInf.subclass(*args_, **kwargs_)
        else:
            return GateHHRatesTauInf(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.notes is not None
            or self.q10_settings is not None
            or self.forward_rate is not None
            or self.reverse_rate is not None
            or self.time_course is not None
            or self.steady_state is not None
            or super(GateHHRatesTauInf, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHRatesTauInf",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GateHHRatesTauInf")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="GateHHRatesTauInf",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GateHHRatesTauInf",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="GateHHRatesTauInf",
    ):
        super(GateHHRatesTauInf, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="GateHHRatesTauInf",
        )
        if self.instances is not None and "instances" not in already_processed:
            already_processed.add("instances")
            outfile.write(" instances=%s" % (quote_attrib(self.instances),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHRatesTauInf",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(GateHHRatesTauInf, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.q10_settings is not None:
            self.q10_settings.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="q10Settings",
                pretty_print=pretty_print,
            )
        if self.forward_rate is not None:
            self.forward_rate.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="forwardRate",
                pretty_print=pretty_print,
            )
        if self.reverse_rate is not None:
            self.reverse_rate.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="reverseRate",
                pretty_print=pretty_print,
            )
        if self.time_course is not None:
            self.time_course.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="timeCourse",
                pretty_print=pretty_print,
            )
        if self.steady_state is not None:
            self.steady_state.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="steadyState",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("instances", node)
        if value is not None and "instances" not in already_processed:
            already_processed.add("instances")
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.instances <= 0:
                raise_parse_error(node, "Invalid PositiveInteger")
            self.validate_PositiveInteger(
                self.instances
            )  # validate type PositiveInteger
        super(GateHHRatesTauInf, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "q10Settings":
            obj_ = Q10Settings.factory(parent_object_=self)
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = "q10Settings"
        elif nodeName_ == "forwardRate":
            obj_ = HHRate.factory(parent_object_=self)
            obj_.build(child_)
            self.forward_rate = obj_
            obj_.original_tagname_ = "forwardRate"
        elif nodeName_ == "reverseRate":
            obj_ = HHRate.factory(parent_object_=self)
            obj_.build(child_)
            self.reverse_rate = obj_
            obj_.original_tagname_ = "reverseRate"
        elif nodeName_ == "timeCourse":
            obj_ = HHTime.factory(parent_object_=self)
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = "timeCourse"
        elif nodeName_ == "steadyState":
            obj_ = HHVariable.factory(parent_object_=self)
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = "steadyState"
        super(GateHHRatesTauInf, self).buildChildren(child_, node, nodeName_, True)


# end class GateHHRatesTauInf


class GateHHTauInf(Base):
    member_data_items_ = [
        MemberSpec_("instances", "PositiveInteger", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "q10_settings",
            "Q10Settings",
            0,
            1,
            {u"type": u"Q10Settings", u"name": u"q10Settings", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "time_course",
            "HHTime",
            0,
            0,
            {u"type": u"HHTime", u"name": u"timeCourse", u"minOccurs": u"1"},
            None,
        ),
        MemberSpec_(
            "steady_state",
            "HHVariable",
            0,
            0,
            {u"type": u"HHVariable", u"name": u"steadyState", u"minOccurs": u"1"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        instances=None,
        notes=None,
        q10_settings=None,
        time_course=None,
        steady_state=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(GateHHTauInf, self).__init__(neuro_lex_id, id, **kwargs_)
        self.instances = _cast(int, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.time_course = time_course
        self.steady_state = steady_state

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, GateHHTauInf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHTauInf.subclass:
            return GateHHTauInf.subclass(*args_, **kwargs_)
        else:
            return GateHHTauInf(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.notes is not None
            or self.q10_settings is not None
            or self.time_course is not None
            or self.steady_state is not None
            or super(GateHHTauInf, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHTauInf",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GateHHTauInf")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateHHTauInf"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GateHHTauInf",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="GateHHTauInf",
    ):
        super(GateHHTauInf, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateHHTauInf"
        )
        if self.instances is not None and "instances" not in already_processed:
            already_processed.add("instances")
            outfile.write(" instances=%s" % (quote_attrib(self.instances),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHTauInf",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(GateHHTauInf, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.q10_settings is not None:
            self.q10_settings.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="q10Settings",
                pretty_print=pretty_print,
            )
        if self.time_course is not None:
            self.time_course.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="timeCourse",
                pretty_print=pretty_print,
            )
        if self.steady_state is not None:
            self.steady_state.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="steadyState",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("instances", node)
        if value is not None and "instances" not in already_processed:
            already_processed.add("instances")
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.instances <= 0:
                raise_parse_error(node, "Invalid PositiveInteger")
            self.validate_PositiveInteger(
                self.instances
            )  # validate type PositiveInteger
        super(GateHHTauInf, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "q10Settings":
            obj_ = Q10Settings.factory(parent_object_=self)
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = "q10Settings"
        elif nodeName_ == "timeCourse":
            obj_ = HHTime.factory(parent_object_=self)
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = "timeCourse"
        elif nodeName_ == "steadyState":
            obj_ = HHVariable.factory(parent_object_=self)
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = "steadyState"
        super(GateHHTauInf, self).buildChildren(child_, node, nodeName_, True)


# end class GateHHTauInf


class GateHHRates(Base):
    member_data_items_ = [
        MemberSpec_("instances", "PositiveInteger", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "q10_settings",
            "Q10Settings",
            0,
            1,
            {u"type": u"Q10Settings", u"name": u"q10Settings", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "forward_rate",
            "HHRate",
            0,
            0,
            {u"type": u"HHRate", u"name": u"forwardRate", u"minOccurs": u"1"},
            None,
        ),
        MemberSpec_(
            "reverse_rate",
            "HHRate",
            0,
            0,
            {u"type": u"HHRate", u"name": u"reverseRate", u"minOccurs": u"1"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        instances=None,
        notes=None,
        q10_settings=None,
        forward_rate=None,
        reverse_rate=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(GateHHRates, self).__init__(neuro_lex_id, id, **kwargs_)
        self.instances = _cast(int, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, GateHHRates)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHRates.subclass:
            return GateHHRates.subclass(*args_, **kwargs_)
        else:
            return GateHHRates(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.notes is not None
            or self.q10_settings is not None
            or self.forward_rate is not None
            or self.reverse_rate is not None
            or super(GateHHRates, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHRates",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GateHHRates")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateHHRates"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GateHHRates",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="GateHHRates",
    ):
        super(GateHHRates, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateHHRates"
        )
        if self.instances is not None and "instances" not in already_processed:
            already_processed.add("instances")
            outfile.write(" instances=%s" % (quote_attrib(self.instances),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHRates",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(GateHHRates, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.q10_settings is not None:
            self.q10_settings.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="q10Settings",
                pretty_print=pretty_print,
            )
        if self.forward_rate is not None:
            self.forward_rate.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="forwardRate",
                pretty_print=pretty_print,
            )
        if self.reverse_rate is not None:
            self.reverse_rate.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="reverseRate",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("instances", node)
        if value is not None and "instances" not in already_processed:
            already_processed.add("instances")
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.instances <= 0:
                raise_parse_error(node, "Invalid PositiveInteger")
            self.validate_PositiveInteger(
                self.instances
            )  # validate type PositiveInteger
        super(GateHHRates, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "q10Settings":
            obj_ = Q10Settings.factory(parent_object_=self)
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = "q10Settings"
        elif nodeName_ == "forwardRate":
            obj_ = HHRate.factory(parent_object_=self)
            obj_.build(child_)
            self.forward_rate = obj_
            obj_.original_tagname_ = "forwardRate"
        elif nodeName_ == "reverseRate":
            obj_ = HHRate.factory(parent_object_=self)
            obj_.build(child_)
            self.reverse_rate = obj_
            obj_.original_tagname_ = "reverseRate"
        super(GateHHRates, self).buildChildren(child_, node, nodeName_, True)


# end class GateHHRates


class GateHHUndetermined(Base):
    """Note all sub elements for gateHHrates, gateHHratesTau,
    gateFractional etc. allowed here. Which are valid should be
    constrained by what type is set"""

    member_data_items_ = [
        MemberSpec_("instances", "PositiveInteger", 0, 0, {"use": u"required"}),
        MemberSpec_("type", "gateTypes", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "q10_settings",
            "Q10Settings",
            0,
            1,
            {u"type": u"Q10Settings", u"name": u"q10Settings", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "forward_rate",
            "HHRate",
            0,
            1,
            {u"type": u"HHRate", u"name": u"forwardRate", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "reverse_rate",
            "HHRate",
            0,
            1,
            {u"type": u"HHRate", u"name": u"reverseRate", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "time_course",
            "HHTime",
            0,
            1,
            {u"type": u"HHTime", u"name": u"timeCourse", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "steady_state",
            "HHVariable",
            0,
            1,
            {u"type": u"HHVariable", u"name": u"steadyState", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "sub_gates",
            "GateFractionalSubgate",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"GateFractionalSubgate",
                u"name": u"subGate",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        instances=None,
        type=None,
        notes=None,
        q10_settings=None,
        forward_rate=None,
        reverse_rate=None,
        time_course=None,
        steady_state=None,
        sub_gates=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(GateHHUndetermined, self).__init__(neuro_lex_id, id, **kwargs_)
        self.instances = _cast(int, instances)
        self.type = _cast(None, type)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
        self.time_course = time_course
        self.steady_state = steady_state
        if sub_gates is None:
            self.sub_gates = []
        else:
            self.sub_gates = sub_gates

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateHHUndetermined
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHUndetermined.subclass:
            return GateHHUndetermined.subclass(*args_, **kwargs_)
        else:
            return GateHHUndetermined(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_gateTypes(self, value):
        # Validate type gateTypes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = [
                "gateHHrates",
                "gateHHratesTau",
                "gateHHtauInf",
                "gateHHratesInf",
                "gateHHratesTauInf",
                "gateHHInstantaneous",
                "gateKS",
                "gateFractional",
            ]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on gateTypes'
                    % {"value": value.encode("utf-8")}
                )

    def hasContent_(self):
        if (
            self.notes is not None
            or self.q10_settings is not None
            or self.forward_rate is not None
            or self.reverse_rate is not None
            or self.time_course is not None
            or self.steady_state is not None
            or self.sub_gates
            or super(GateHHUndetermined, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHUndetermined",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GateHHUndetermined")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="GateHHUndetermined",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GateHHUndetermined",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="GateHHUndetermined",
    ):
        super(GateHHUndetermined, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="GateHHUndetermined",
        )
        if self.instances is not None and "instances" not in already_processed:
            already_processed.add("instances")
            outfile.write(" instances=%s" % (quote_attrib(self.instances),))
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(" type=%s" % (quote_attrib(self.type),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateHHUndetermined",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(GateHHUndetermined, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.q10_settings is not None:
            self.q10_settings.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="q10Settings",
                pretty_print=pretty_print,
            )
        if self.forward_rate is not None:
            self.forward_rate.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="forwardRate",
                pretty_print=pretty_print,
            )
        if self.reverse_rate is not None:
            self.reverse_rate.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="reverseRate",
                pretty_print=pretty_print,
            )
        if self.time_course is not None:
            self.time_course.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="timeCourse",
                pretty_print=pretty_print,
            )
        if self.steady_state is not None:
            self.steady_state.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="steadyState",
                pretty_print=pretty_print,
            )
        for subGate_ in self.sub_gates:
            subGate_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="subGate",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("instances", node)
        if value is not None and "instances" not in already_processed:
            already_processed.add("instances")
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.instances <= 0:
                raise_parse_error(node, "Invalid PositiveInteger")
            self.validate_PositiveInteger(
                self.instances
            )  # validate type PositiveInteger
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_gateTypes(self.type)  # validate type gateTypes
        super(GateHHUndetermined, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "q10Settings":
            obj_ = Q10Settings.factory(parent_object_=self)
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = "q10Settings"
        elif nodeName_ == "forwardRate":
            obj_ = HHRate.factory(parent_object_=self)
            obj_.build(child_)
            self.forward_rate = obj_
            obj_.original_tagname_ = "forwardRate"
        elif nodeName_ == "reverseRate":
            obj_ = HHRate.factory(parent_object_=self)
            obj_.build(child_)
            self.reverse_rate = obj_
            obj_.original_tagname_ = "reverseRate"
        elif nodeName_ == "timeCourse":
            obj_ = HHTime.factory(parent_object_=self)
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = "timeCourse"
        elif nodeName_ == "steadyState":
            obj_ = HHVariable.factory(parent_object_=self)
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = "steadyState"
        elif nodeName_ == "subGate":
            obj_ = GateFractionalSubgate.factory(parent_object_=self)
            obj_.build(child_)
            self.sub_gates.append(obj_)
            obj_.original_tagname_ = "subGate"
        super(GateHHUndetermined, self).buildChildren(child_, node, nodeName_, True)


# end class GateHHUndetermined


class GateKS(Base):
    member_data_items_ = [
        MemberSpec_("instances", "PositiveInteger", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {u"type": u"xs:string", u"name": u"notes", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "q10_settings",
            "Q10Settings",
            0,
            1,
            {u"type": u"Q10Settings", u"name": u"q10Settings", u"minOccurs": u"0"},
            None,
        ),
        MemberSpec_(
            "closed_states",
            "ClosedState",
            1,
            0,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ClosedState",
                u"name": u"closedState",
                u"minOccurs": u"1",
            },
            None,
        ),
        MemberSpec_(
            "open_states",
            "OpenState",
            1,
            0,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"OpenState",
                u"name": u"openState",
                u"minOccurs": u"1",
            },
            None,
        ),
        MemberSpec_(
            "forward_transition",
            "ForwardTransition",
            1,
            0,
            {u"type": u"ForwardTransition", u"name": u"forwardTransition"},
            2,
        ),
        MemberSpec_(
            "reverse_transition",
            "ReverseTransition",
            1,
            0,
            {u"type": u"ReverseTransition", u"name": u"reverseTransition"},
            2,
        ),
        MemberSpec_(
            "tau_inf_transition",
            "TauInfTransition",
            1,
            0,
            {u"type": u"TauInfTransition", u"name": u"tauInfTransition"},
            2,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        instances=None,
        notes=None,
        q10_settings=None,
        closed_states=None,
        open_states=None,
        forward_transition=None,
        reverse_transition=None,
        tau_inf_transition=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(GateKS, self).__init__(neuro_lex_id, id, **kwargs_)
        self.instances = _cast(int, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        if closed_states is None:
            self.closed_states = []
        else:
            self.closed_states = closed_states
        if open_states is None:
            self.open_states = []
        else:
            self.open_states = open_states
        if forward_transition is None:
            self.forward_transition = []
        else:
            self.forward_transition = forward_transition
        if reverse_transition is None:
            self.reverse_transition = []
        else:
            self.reverse_transition = reverse_transition
        if tau_inf_transition is None:
            self.tau_inf_transition = []
        else:
            self.tau_inf_transition = tau_inf_transition

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, GateKS)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateKS.subclass:
            return GateKS.subclass(*args_, **kwargs_)
        else:
            return GateKS(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.notes is not None
            or self.q10_settings is not None
            or self.closed_states
            or self.open_states
            or self.forward_transition
            or self.reverse_transition
            or self.tau_inf_transition
            or super(GateKS, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateKS",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GateKS")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateKS"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GateKS",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="GateKS"
    ):
        super(GateKS, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GateKS"
        )
        if self.instances is not None and "instances" not in already_processed:
            already_processed.add("instances")
            outfile.write(" instances=%s" % (quote_attrib(self.instances),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GateKS",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(GateKS, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.q10_settings is not None:
            self.q10_settings.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="q10Settings",
                pretty_print=pretty_print,
            )
        for closedState_ in self.closed_states:
            closedState_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="closedState",
                pretty_print=pretty_print,
            )
        for openState_ in self.open_states:
            openState_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="openState",
                pretty_print=pretty_print,
            )
        for forwardTransition_ in self.forward_transition:
            forwardTransition_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="forwardTransition",
                pretty_print=pretty_print,
            )
        for reverseTransition_ in self.reverse_transition:
            reverseTransition_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="reverseTransition",
                pretty_print=pretty_print,
            )
        for tauInfTransition_ in self.tau_inf_transition:
            tauInfTransition_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="tauInfTransition",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("instances", node)
        if value is not None and "instances" not in already_processed:
            already_processed.add("instances")
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.instances <= 0:
                raise_parse_error(node, "Invalid PositiveInteger")
            self.validate_PositiveInteger(
                self.instances
            )  # validate type PositiveInteger
        super(GateKS, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "notes":
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, "notes")
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "q10Settings":
            obj_ = Q10Settings.factory(parent_object_=self)
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = "q10Settings"
        elif nodeName_ == "closedState":
            obj_ = ClosedState.factory(parent_object_=self)
            obj_.build(child_)
            self.closed_states.append(obj_)
            obj_.original_tagname_ = "closedState"
        elif nodeName_ == "openState":
            obj_ = OpenState.factory(parent_object_=self)
            obj_.build(child_)
            self.open_states.append(obj_)
            obj_.original_tagname_ = "openState"
        elif nodeName_ == "forwardTransition":
            obj_ = ForwardTransition.factory(parent_object_=self)
            obj_.build(child_)
            self.forward_transition.append(obj_)
            obj_.original_tagname_ = "forwardTransition"
        elif nodeName_ == "reverseTransition":
            obj_ = ReverseTransition.factory(parent_object_=self)
            obj_.build(child_)
            self.reverse_transition.append(obj_)
            obj_.original_tagname_ = "reverseTransition"
        elif nodeName_ == "tauInfTransition":
            obj_ = TauInfTransition.factory(parent_object_=self)
            obj_.build(child_)
            self.tau_inf_transition.append(obj_)
            obj_.original_tagname_ = "tauInfTransition"
        super(GateKS, self).buildChildren(child_, node, nodeName_, True)


# end class GateKS


class TauInfTransition(Base):
    member_data_items_ = [
        MemberSpec_("from_", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("to", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "steady_state",
            "HHVariable",
            0,
            0,
            {u"type": u"HHVariable", u"name": u"steadyState"},
            None,
        ),
        MemberSpec_(
            "time_course",
            "HHTime",
            0,
            0,
            {u"type": u"HHTime", u"name": u"timeCourse"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        from_=None,
        to=None,
        steady_state=None,
        time_course=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(TauInfTransition, self).__init__(neuro_lex_id, id, **kwargs_)
        self.from_ = _cast(None, from_)
        self.to = _cast(None, to)
        self.steady_state = steady_state
        self.time_course = time_course

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, TauInfTransition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TauInfTransition.subclass:
            return TauInfTransition.subclass(*args_, **kwargs_)
        else:
            return TauInfTransition(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if (
            self.steady_state is not None
            or self.time_course is not None
            or super(TauInfTransition, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TauInfTransition",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TauInfTransition")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TauInfTransition",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="TauInfTransition",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="TauInfTransition",
    ):
        super(TauInfTransition, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TauInfTransition",
        )
        if self.from_ is not None and "from_" not in already_processed:
            already_processed.add("from_")
            outfile.write(" from=%s" % (quote_attrib(self.from_),))
        if self.to is not None and "to" not in already_processed:
            already_processed.add("to")
            outfile.write(" to=%s" % (quote_attrib(self.to),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TauInfTransition",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(TauInfTransition, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.steady_state is not None:
            self.steady_state.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="steadyState",
                pretty_print=pretty_print,
            )
        if self.time_course is not None:
            self.time_course.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="timeCourse",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("from", node)
        if value is not None and "from" not in already_processed:
            already_processed.add("from")
            self.from_ = value
            self.validate_NmlId(self.from_)  # validate type NmlId
        value = find_attr_value_("to", node)
        if value is not None and "to" not in already_processed:
            already_processed.add("to")
            self.to = value
            self.validate_NmlId(self.to)  # validate type NmlId
        super(TauInfTransition, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "steadyState":
            obj_ = HHVariable.factory(parent_object_=self)
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = "steadyState"
        elif nodeName_ == "timeCourse":
            obj_ = HHTime.factory(parent_object_=self)
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = "timeCourse"
        super(TauInfTransition, self).buildChildren(child_, node, nodeName_, True)


# end class TauInfTransition


class ReverseTransition(Base):
    member_data_items_ = [
        MemberSpec_("from_", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("to", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "__ANY__",
            "__ANY__",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"processContents": u"skip",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        from_=None,
        to=None,
        anytypeobjs_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ReverseTransition, self).__init__(neuro_lex_id, id, **kwargs_)
        self.from_ = _cast(None, from_)
        self.to = _cast(None, to)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReverseTransition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReverseTransition.subclass:
            return ReverseTransition.subclass(*args_, **kwargs_)
        else:
            return ReverseTransition(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if self.anytypeobjs_ or super(ReverseTransition, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReverseTransition",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReverseTransition")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ReverseTransition",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReverseTransition",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReverseTransition",
    ):
        super(ReverseTransition, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ReverseTransition",
        )
        if self.from_ is not None and "from_" not in already_processed:
            already_processed.add("from_")
            outfile.write(" from=%s" % (quote_attrib(self.from_),))
        if self.to is not None and "to" not in already_processed:
            already_processed.add("to")
            outfile.write(" to=%s" % (quote_attrib(self.to),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReverseTransition",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ReverseTransition, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("from", node)
        if value is not None and "from" not in already_processed:
            already_processed.add("from")
            self.from_ = value
            self.validate_NmlId(self.from_)  # validate type NmlId
        value = find_attr_value_("to", node)
        if value is not None and "to" not in already_processed:
            already_processed.add("to")
            self.to = value
            self.validate_NmlId(self.to)  # validate type NmlId
        super(ReverseTransition, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, "ReverseTransition")
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(ReverseTransition, self).buildChildren(child_, node, nodeName_, True)


# end class ReverseTransition


class ForwardTransition(Base):
    member_data_items_ = [
        MemberSpec_("from_", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_("to", "NmlId", 0, 0, {"use": u"required"}),
        MemberSpec_(
            "__ANY__",
            "__ANY__",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"processContents": u"skip",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        from_=None,
        to=None,
        anytypeobjs_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ForwardTransition, self).__init__(neuro_lex_id, id, **kwargs_)
        self.from_ = _cast(None, from_)
        self.to = _cast(None, to)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ForwardTransition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ForwardTransition.subclass:
            return ForwardTransition.subclass(*args_, **kwargs_)
        else:
            return ForwardTransition(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def hasContent_(self):
        if self.anytypeobjs_ or super(ForwardTransition, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ForwardTransition",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ForwardTransition")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ForwardTransition",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ForwardTransition",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ForwardTransition",
    ):
        super(ForwardTransition, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ForwardTransition",
        )
        if self.from_ is not None and "from_" not in already_processed:
            already_processed.add("from_")
            outfile.write(" from=%s" % (quote_attrib(self.from_),))
        if self.to is not None and "to" not in already_processed:
            already_processed.add("to")
            outfile.write(" to=%s" % (quote_attrib(self.to),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ForwardTransition",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ForwardTransition, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("from", node)
        if value is not None and "from" not in already_processed:
            already_processed.add("from")
            self.from_ = value
            self.validate_NmlId(self.from_)  # validate type NmlId
        value = find_attr_value_("to", node)
        if value is not None and "to" not in already_processed:
            already_processed.add("to")
            self.to = value
            self.validate_NmlId(self.to)  # validate type NmlId
        super(ForwardTransition, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, "ForwardTransition")
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(ForwardTransition, self).buildChildren(child_, node, nodeName_, True)


# end class ForwardTransition


class OpenState(Base):
    member_data_items_ = []
    subclass = None
    superclass = Base

    def __init__(self, neuro_lex_id=None, id=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(OpenState, self).__init__(neuro_lex_id, id, **kwargs_)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, OpenState)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OpenState.subclass:
            return OpenState.subclass(*args_, **kwargs_)
        else:
            return OpenState(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(OpenState, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="OpenState",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("OpenState")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="OpenState"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="OpenState",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="OpenState"
    ):
        super(OpenState, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="OpenState"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="OpenState",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(OpenState, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(OpenState, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OpenState, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class OpenState


class ClosedState(Base):
    member_data_items_ = []
    subclass = None
    superclass = Base

    def __init__(self, neuro_lex_id=None, id=None, **kwargs_):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(ClosedState, self).__init__(neuro_lex_id, id, **kwargs_)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ClosedState)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ClosedState.subclass:
            return ClosedState.subclass(*args_, **kwargs_)
        else:
            return ClosedState(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if super(ClosedState, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ClosedState",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ClosedState")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ClosedState"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ClosedState",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ClosedState",
    ):
        super(ClosedState, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ClosedState"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ClosedState",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ClosedState, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(ClosedState, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ClosedState, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class ClosedState


class IonChannelKS(Standalone):
    """Kinetic scheme based ion channel."""

    member_data_items_ = [
        MemberSpec_("species", "NmlId", 0, 1, {"use": u"optional"}),
        MemberSpec_(
            "conductance", "Nml2Quantity_conductance", 0, 1, {"use": u"optional"}
        ),
        MemberSpec_(
            "gate_kses",
            "GateKS",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"GateKS",
                u"name": u"gateKS",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        species=None,
        conductance=None,
        gate_kses=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(IonChannelKS, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.species = _cast(None, species)
        self.conductance = _cast(None, conductance)
        if gate_kses is None:
            self.gate_kses = []
        else:
            self.gate_kses = gate_kses

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, IonChannelKS)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IonChannelKS.subclass:
            return IonChannelKS.subclass(*args_, **kwargs_)
        else:
            return IonChannelKS(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [[u"^[a-zA-Z_][a-zA-Z0-9_]*$"]]

    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_conductance_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        value.encode("utf-8"),
                        self.validate_Nml2Quantity_conductance_patterns_,
                    )
                )

    validate_Nml2Quantity_conductance_patterns_ = [
        [u"^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S|mS|uS|nS|pS)$"]
    ]

    def hasContent_(self):
        if self.gate_kses or super(IonChannelKS, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IonChannelKS",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("IonChannelKS")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="IonChannelKS"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="IonChannelKS",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="IonChannelKS",
    ):
        super(IonChannelKS, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="IonChannelKS"
        )
        if self.species is not None and "species" not in already_processed:
            already_processed.add("species")
            outfile.write(" species=%s" % (quote_attrib(self.species),))
        if self.conductance is not None and "conductance" not in already_processed:
            already_processed.add("conductance")
            outfile.write(" conductance=%s" % (quote_attrib(self.conductance),))

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IonChannelKS",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(IonChannelKS, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for gateKS_ in self.gate_kses:
            gateKS_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="gateKS",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("species", node)
        if value is not None and "species" not in already_processed:
            already_processed.add("species")
            self.species = value
            self.validate_NmlId(self.species)  # validate type NmlId
        value = find_attr_value_("conductance", node)
        if value is not None and "conductance" not in already_processed:
            already_processed.add("conductance")
            self.conductance = value
            self.validate_Nml2Quantity_conductance(
                self.conductance
            )  # validate type Nml2Quantity_conductance
        super(IonChannelKS, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "gateKS":
            obj_ = GateKS.factory(parent_object_=self)
            obj_.build(child_)
            self.gate_kses.append(obj_)
            obj_.original_tagname_ = "gateKS"
        super(IonChannelKS, self).buildChildren(child_, node, nodeName_, True)


# end class IonChannelKS


class IonChannelScalable(Standalone):
    member_data_items_ = [
        MemberSpec_(
            "q10_conductance_scalings",
            "Q10ConductanceScaling",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Q10ConductanceScaling",
                u"name": u"q10ConductanceScaling",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        q10_conductance_scalings=None,
        extensiontype_=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(IonChannelScalable, self).__init__(
            neuro_lex_id,
            id,
            metaid,
            notes,
            properties,
            annotation,
            extensiontype_,
            **kwargs_
        )
        if q10_conductance_scalings is None:
            self.q10_conductance_scalings = []
        else:
            self.q10_conductance_scalings = q10_conductance_scalings
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IonChannelScalable
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IonChannelScalable.subclass:
            return IonChannelScalable.subclass(*args_, **kwargs_)
        else:
            return IonChannelScalable(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.q10_conductance_scalings
            or super(IonChannelScalable, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IonChannelScalable",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("IonChannelScalable")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="IonChannelScalable",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="IonChannelScalable",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="IonChannelScalable",
    ):
        super(IonChannelScalable, self).exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="IonChannelScalable",
        )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IonChannelScalable",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(IonChannelScalable, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for q10ConductanceScaling_ in self.q10_conductance_scalings:
            q10ConductanceScaling_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="q10ConductanceScaling",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(IonChannelScalable, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "q10ConductanceScaling":
            obj_ = Q10ConductanceScaling.factory(parent_object_=self)
            obj_.build(child_)
            self.q10_conductance_scalings.append(obj_)
            obj_.original_tagname_ = "q10ConductanceScaling"
        super(IonChannelScalable, self).buildChildren(child_, node, nodeName_, True)


# end class IonChannelScalable


class NeuroMLDocument(Standalone):
    member_data_items_ = [
        MemberSpec_(
            "includes",
            "IncludeType",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IncludeType",
                u"name": u"include",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "extracellular_properties",
            "ExtracellularProperties",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ExtracellularProperties",
                u"name": u"extracellularProperties",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "intracellular_properties",
            "IntracellularProperties",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IntracellularProperties",
                u"name": u"intracellularProperties",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "morphology",
            "Morphology",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Morphology",
                u"name": u"morphology",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "ion_channel",
            "IonChannel",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IonChannel",
                u"name": u"ionChannel",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "ion_channel_hhs",
            "IonChannelHH",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IonChannelHH",
                u"name": u"ionChannelHH",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "ion_channel_v_shifts",
            "IonChannelVShift",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IonChannelVShift",
                u"name": u"ionChannelVShift",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "ion_channel_kses",
            "IonChannelKS",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IonChannelKS",
                u"name": u"ionChannelKS",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "decaying_pool_concentration_models",
            "DecayingPoolConcentrationModel",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"DecayingPoolConcentrationModel",
                u"name": u"decayingPoolConcentrationModel",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "fixed_factor_concentration_models",
            "FixedFactorConcentrationModel",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"FixedFactorConcentrationModel",
                u"name": u"fixedFactorConcentrationModel",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "alpha_current_synapses",
            "AlphaCurrentSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"AlphaCurrentSynapse",
                u"name": u"alphaCurrentSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "alpha_synapses",
            "AlphaSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"AlphaSynapse",
                u"name": u"alphaSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "exp_one_synapses",
            "ExpOneSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ExpOneSynapse",
                u"name": u"expOneSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "exp_two_synapses",
            "ExpTwoSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ExpTwoSynapse",
                u"name": u"expTwoSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "exp_three_synapses",
            "ExpThreeSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ExpThreeSynapse",
                u"name": u"expThreeSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "blocking_plastic_synapses",
            "BlockingPlasticSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"BlockingPlasticSynapse",
                u"name": u"blockingPlasticSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "double_synapses",
            "DoubleSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"DoubleSynapse",
                u"name": u"doubleSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "gap_junctions",
            "GapJunction",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"GapJunction",
                u"name": u"gapJunction",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "silent_synapses",
            "SilentSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SilentSynapse",
                u"name": u"silentSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "linear_graded_synapses",
            "LinearGradedSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"LinearGradedSynapse",
                u"name": u"linearGradedSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "graded_synapses",
            "GradedSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"GradedSynapse",
                u"name": u"gradedSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "biophysical_properties",
            "BiophysicalProperties",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"BiophysicalProperties",
                u"name": u"biophysicalProperties",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "cells",
            "Cell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Cell",
                u"name": u"cell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "cell2_ca_poolses",
            "Cell2CaPools",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Cell2CaPools",
                u"name": u"cell2CaPools",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "base_cells",
            "BaseCell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"BaseCell",
                u"name": u"baseCell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "iaf_tau_cells",
            "IafTauCell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IafTauCell",
                u"name": u"iafTauCell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "iaf_tau_ref_cells",
            "IafTauRefCell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IafTauRefCell",
                u"name": u"iafTauRefCell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "iaf_cells",
            "IafCell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IafCell",
                u"name": u"iafCell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "iaf_ref_cells",
            "IafRefCell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IafRefCell",
                u"name": u"iafRefCell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "izhikevich_cells",
            "IzhikevichCell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IzhikevichCell",
                u"name": u"izhikevichCell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "izhikevich2007_cells",
            "Izhikevich2007Cell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Izhikevich2007Cell",
                u"name": u"izhikevich2007Cell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "ad_ex_ia_f_cells",
            "AdExIaFCell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"AdExIaFCell",
                u"name": u"adExIaFCell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "fitz_hugh_nagumo_cells",
            "FitzHughNagumoCell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"FitzHughNagumoCell",
                u"name": u"fitzHughNagumoCell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "fitz_hugh_nagumo1969_cells",
            "FitzHughNagumo1969Cell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"FitzHughNagumo1969Cell",
                u"name": u"fitzHughNagumo1969Cell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "pinsky_rinzel_ca3_cells",
            "PinskyRinzelCA3Cell",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"PinskyRinzelCA3Cell",
                u"name": u"pinskyRinzelCA3Cell",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "pulse_generators",
            "PulseGenerator",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"PulseGenerator",
                u"name": u"pulseGenerator",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "pulse_generator_dls",
            "PulseGeneratorDL",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"PulseGeneratorDL",
                u"name": u"pulseGeneratorDL",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "sine_generators",
            "SineGenerator",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SineGenerator",
                u"name": u"sineGenerator",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "sine_generator_dls",
            "SineGeneratorDL",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SineGeneratorDL",
                u"name": u"sineGeneratorDL",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "ramp_generators",
            "RampGenerator",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"RampGenerator",
                u"name": u"rampGenerator",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "ramp_generator_dls",
            "RampGeneratorDL",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"RampGeneratorDL",
                u"name": u"rampGeneratorDL",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "compound_inputs",
            "CompoundInput",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"CompoundInput",
                u"name": u"compoundInput",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "compound_input_dls",
            "CompoundInputDL",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"CompoundInputDL",
                u"name": u"compoundInputDL",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "voltage_clamps",
            "VoltageClamp",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"VoltageClamp",
                u"name": u"voltageClamp",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "voltage_clamp_triples",
            "VoltageClampTriple",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"VoltageClampTriple",
                u"name": u"voltageClampTriple",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "spike_arrays",
            "SpikeArray",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SpikeArray",
                u"name": u"spikeArray",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "timed_synaptic_inputs",
            "TimedSynapticInput",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"TimedSynapticInput",
                u"name": u"timedSynapticInput",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "spike_generators",
            "SpikeGenerator",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SpikeGenerator",
                u"name": u"spikeGenerator",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "spike_generator_randoms",
            "SpikeGeneratorRandom",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SpikeGeneratorRandom",
                u"name": u"spikeGeneratorRandom",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "spike_generator_poissons",
            "SpikeGeneratorPoisson",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SpikeGeneratorPoisson",
                u"name": u"spikeGeneratorPoisson",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "spike_generator_ref_poissons",
            "SpikeGeneratorRefPoisson",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SpikeGeneratorRefPoisson",
                u"name": u"spikeGeneratorRefPoisson",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "poisson_firing_synapses",
            "PoissonFiringSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"PoissonFiringSynapse",
                u"name": u"poissonFiringSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "transient_poisson_firing_synapses",
            "TransientPoissonFiringSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"TransientPoissonFiringSynapse",
                u"name": u"transientPoissonFiringSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "IF_curr_alpha",
            "IF_curr_alpha",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IF_curr_alpha",
                u"name": u"IF_curr_alpha",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "IF_curr_exp",
            "IF_curr_exp",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IF_curr_exp",
                u"name": u"IF_curr_exp",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "IF_cond_alpha",
            "IF_cond_alpha",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IF_cond_alpha",
                u"name": u"IF_cond_alpha",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "IF_cond_exp",
            "IF_cond_exp",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"IF_cond_exp",
                u"name": u"IF_cond_exp",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "EIF_cond_exp_isfa_ista",
            "EIF_cond_exp_isfa_ista",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"EIF_cond_exp_isfa_ista",
                u"name": u"EIF_cond_exp_isfa_ista",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "EIF_cond_alpha_isfa_ista",
            "EIF_cond_alpha_isfa_ista",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"EIF_cond_alpha_isfa_ista",
                u"name": u"EIF_cond_alpha_isfa_ista",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "HH_cond_exp",
            "HH_cond_exp",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"HH_cond_exp",
                u"name": u"HH_cond_exp",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "exp_cond_synapses",
            "ExpCondSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ExpCondSynapse",
                u"name": u"expCondSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "alpha_cond_synapses",
            "AlphaCondSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"AlphaCondSynapse",
                u"name": u"alphaCondSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "exp_curr_synapses",
            "ExpCurrSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ExpCurrSynapse",
                u"name": u"expCurrSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "alpha_curr_synapses",
            "AlphaCurrSynapse",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"AlphaCurrSynapse",
                u"name": u"alphaCurrSynapse",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "SpikeSourcePoisson",
            "SpikeSourcePoisson",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"SpikeSourcePoisson",
                u"name": u"SpikeSourcePoisson",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "networks",
            "Network",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"Network",
                u"name": u"network",
                u"minOccurs": u"0",
            },
            None,
        ),
        MemberSpec_(
            "ComponentType",
            "ComponentType",
            1,
            1,
            {
                u"maxOccurs": u"unbounded",
                u"type": u"ComponentType",
                u"name": u"ComponentType",
                u"minOccurs": u"0",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        includes=None,
        extracellular_properties=None,
        intracellular_properties=None,
        morphology=None,
        ion_channel=None,
        ion_channel_hhs=None,
        ion_channel_v_shifts=None,
        ion_channel_kses=None,
        decaying_pool_concentration_models=None,
        fixed_factor_concentration_models=None,
        alpha_current_synapses=None,
        alpha_synapses=None,
        exp_one_synapses=None,
        exp_two_synapses=None,
        exp_three_synapses=None,
        blocking_plastic_synapses=None,
        double_synapses=None,
        gap_junctions=None,
        silent_synapses=None,
        linear_graded_synapses=None,
        graded_synapses=None,
        biophysical_properties=None,
        cells=None,
        cell2_ca_poolses=None,
        base_cells=None,
        iaf_tau_cells=None,
        iaf_tau_ref_cells=None,
        iaf_cells=None,
        iaf_ref_cells=None,
        izhikevich_cells=None,
        izhikevich2007_cells=None,
        ad_ex_ia_f_cells=None,
        fitz_hugh_nagumo_cells=None,
        fitz_hugh_nagumo1969_cells=None,
        pinsky_rinzel_ca3_cells=None,
        pulse_generators=None,
        pulse_generator_dls=None,
        sine_generators=None,
        sine_generator_dls=None,
        ramp_generators=None,
        ramp_generator_dls=None,
        compound_inputs=None,
        compound_input_dls=None,
        voltage_clamps=None,
        voltage_clamp_triples=None,
        spike_arrays=None,
        timed_synaptic_inputs=None,
        spike_generators=None,
        spike_generator_randoms=None,
        spike_generator_poissons=None,
        spike_generator_ref_poissons=None,
        poisson_firing_synapses=None,
        transient_poisson_firing_synapses=None,
        IF_curr_alpha=None,
        IF_curr_exp=None,
        IF_cond_alpha=None,
        IF_cond_exp=None,
        EIF_cond_exp_isfa_ista=None,
        EIF_cond_alpha_isfa_ista=None,
        HH_cond_exp=None,
        exp_cond_synapses=None,
        alpha_cond_synapses=None,
        exp_curr_synapses=None,
        alpha_curr_synapses=None,
        SpikeSourcePoisson=None,
        networks=None,
        ComponentType=None,
        **kwargs_
    ):
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        super(NeuroMLDocument, self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        if includes is None:
            self.includes = []
        else:
            self.includes = includes
        if extracellular_properties is None:
            self.extracellular_properties = []
        else:
            self.extracellular_properties = extracellular_properties
        if intracellular_properties is None:
            self.intracellular_properties = []
        else:
            self.intracellular_properties = intracellular_properties
        if morphology is None:
            self.morphology = []
        else:
            self.morphology = morphology
        if ion_channel is None:
            self.ion_channel = []
        else:
            self.ion_channel = ion_channel
        if ion_channel_hhs is None:
            self.ion_channel_hhs = []
        else:
            self.ion_channel_hhs = ion_channel_hhs
        if ion_channel_v_shifts is None:
            self.ion_channel_v_shifts = []
        else:
            self.ion_channel_v_shifts = ion_channel_v_shifts
        if ion_channel_kses is None:
            self.ion_channel_kses = []
        else:
            self.ion_channel_kses = ion_channel_kses
        if decaying_pool_concentration_models is None:
            self.decaying_pool_concentration_models = []
        else:
            self.decaying_pool_concentration_models = decaying_pool_concentration_models
        if fixed_factor_concentration_models is None:
            self.fixed_factor_concentration_models = []
        else:
            self.fixed_factor_concentration_models = fixed_factor_concentration_models
        if alpha_current_synapses is None:
            self.alpha_current_synapses = []
        else:
            self.alpha_current_synapses = alpha_current_synapses
        if alpha_synapses is None:
            self.alpha_synapses = []
        else:
            self.alpha_synapses = alpha_synapses
        if exp_one_synapses is None:
            self.exp_one_synapses = []
        else:
            self.exp_one_synapses = exp_one_synapses
        if exp_two_synapses is None:
            self.exp_two_synapses = []
        else:
            self.exp_two_synapses = exp_two_synapses
        if exp_three_synapses is None:
            self.exp_three_synapses = []
        else:
            self.exp_three_synapses = exp_three_synapses
        if blocking_plastic_synapses is None:
            self.blocking_plastic_synapses = []
        else:
            self.blocking_plastic_synapses = blocking_plastic_synapses
        if double_synapses is None:
            self.double_synapses = []
        else:
            self.double_synapses = double_synapses
        if gap_junctions is None:
            self.gap_junctions = []
        else:
            self.gap_junctions = gap_junctions
        if silent_synapses is None:
            self.silent_synapses = []
        else:
            self.silent_synapses = silent_synapses
        if linear_graded_synapses is None:
            self.linear_graded_synapses = []
        else:
            self.linear_graded_synapses = linear_graded_synapses
        if graded_synapses is None:
            self.graded_synapses = []
        else:
            self.graded_synapses = graded_synapses
        if biophysical_properties is None:
            self.biophysical_properties = []
        else:
            self.biophysical_properties = biophysical_properties
        if cells is None:
            self.cells = []
        else:
            self.cells = cells
        if cell2_ca_poolses is None:
            self.cell2_ca_poolses = []
        else:
            self.cell2_ca_poolses = cell2_ca_poolses
        if base_cells is None:
            self.base_cells = []
        else:
            self.base_cells = base_cells
        if iaf_tau_cells is None:
            self.iaf_tau_cells = []
        else:
            self.iaf_tau_cells = iaf_tau_cells
        if iaf_tau_ref_cells is None:
            self.iaf_tau_ref_cells = []
        else:
            self.iaf_tau_ref_cells = iaf_tau_ref_cells
        if iaf_cells is None:
            self.iaf_cells = []
        else:
            self.iaf_cells = iaf_cells
        if iaf_ref_cells is None:
            self.iaf_ref_cells = []
        else:
            self.iaf_ref_cells = iaf_ref_cells
        if izhikevich_cells is None:
            self.izhikevich_cells = []
        else:
            self.izhikevich_cells = izhikevich_cells
        if izhikevich2007_cells is None:
            self.izhikevich2007_cells = []
        else:
            self.izhikevich2007_cells = izhikevich2007_cells
        if ad_ex_ia_f_cells is None:
            self.ad_ex_ia_f_cells = []
        else:
            self.ad_ex_ia_f_cells = ad_ex_ia_f_cells
        if fitz_hugh_nagumo_cells is None:
            self.fitz_hugh_nagumo_cells = []
        else:
            self.fitz_hugh_nagumo_cells = fitz_hugh_nagumo_cells
        if fitz_hugh_nagumo1969_cells is None:
            self.fitz_hugh_nagumo1969_cells = []
        else:
            self.fitz_hugh_nagumo1969_cells = fitz_hugh_nagumo1969_cells
        if pinsky_rinzel_ca3_cells is None:
            self.pinsky_rinzel_ca3_cells = []
        else:
            self.pinsky_rinzel_ca3_cells = pinsky_rinzel_ca3_cells
        if pulse_generators is None:
            self.pulse_generators = []
        else:
            self.pulse_generators = pulse_generators
        if pulse_generator_dls is None:
            self.pulse_generator_dls = []
        else:
            self.pulse_generator_dls = pulse_generator_dls
        if sine_generators is None:
            self.sine_generators = []
        else:
            self.sine_generators = sine_generators
        if sine_generator_dls is None:
            self.sine_generator_dls = []
        else:
            self.sine_generator_dls = sine_generator_dls
        if ramp_generators is None:
            self.ramp_generators = []
        else:
            self.ramp_generators = ramp_generators
        if ramp_generator_dls is None:
            self.ramp_generator_dls = []
        else:
            self.ramp_generator_dls = ramp_generator_dls
        if compound_inputs is None:
            self.compound_inputs = []
        else:
            self.compound_inputs = compound_inputs
        if compound_input_dls is None:
            self.compound_input_dls = []
        else:
            self.compound_input_dls = compound_input_dls
        if voltage_clamps is None:
            self.voltage_clamps = []
        else:
            self.voltage_clamps = voltage_clamps
        if voltage_clamp_triples is None:
            self.voltage_clamp_triples = []
        else:
            self.voltage_clamp_triples = voltage_clamp_triples
        if spike_arrays is None:
            self.spike_arrays = []
        else:
            self.spike_arrays = spike_arrays
        if timed_synaptic_inputs is None:
            self.timed_synaptic_inputs = []
        else:
            self.timed_synaptic_inputs = timed_synaptic_inputs
        if spike_generators is None:
            self.spike_generators = []
        else:
            self.spike_generators = spike_generators
        if spike_generator_randoms is None:
            self.spike_generator_randoms = []
        else:
            self.spike_generator_randoms = spike_generator_randoms
        if spike_generator_poissons is None:
            self.spike_generator_poissons = []
        else:
            self.spike_generator_poissons = spike_generator_poissons
        if spike_generator_ref_poissons is None:
            self.spike_generator_ref_poissons = []
        else:
            self.spike_generator_ref_poissons = spike_generator_ref_poissons
        if poisson_firing_synapses is None:
            self.poisson_firing_synapses = []
        else:
            self.poisson_firing_synapses = poisson_firing_synapses
        if transient_poisson_firing_synapses is None:
            self.transient_poisson_firing_synapses = []
        else:
            self.transient_poisson_firing_synapses = transient_poisson_firing_synapses
        if IF_curr_alpha is None:
            self.IF_curr_alpha = []
        else:
            self.IF_curr_alpha = IF_curr_alpha
        if IF_curr_exp is None:
            self.IF_curr_exp = []
        else:
            self.IF_curr_exp = IF_curr_exp
        if IF_cond_alpha is None:
            self.IF_cond_alpha = []
        else:
            self.IF_cond_alpha = IF_cond_alpha
        if IF_cond_exp is None:
            self.IF_cond_exp = []
        else:
            self.IF_cond_exp = IF_cond_exp
        if EIF_cond_exp_isfa_ista is None:
            self.EIF_cond_exp_isfa_ista = []
        else:
            self.EIF_cond_exp_isfa_ista = EIF_cond_exp_isfa_ista
        if EIF_cond_alpha_isfa_ista is None:
            self.EIF_cond_alpha_isfa_ista = []
        else:
            self.EIF_cond_alpha_isfa_ista = EIF_cond_alpha_isfa_ista
        if HH_cond_exp is None:
            self.HH_cond_exp = []
        else:
            self.HH_cond_exp = HH_cond_exp
        if exp_cond_synapses is None:
            self.exp_cond_synapses = []
        else:
            self.exp_cond_synapses = exp_cond_synapses
        if alpha_cond_synapses is None:
            self.alpha_cond_synapses = []
        else:
            self.alpha_cond_synapses = alpha_cond_synapses
        if exp_curr_synapses is None:
            self.exp_curr_synapses = []
        else:
            self.exp_curr_synapses = exp_curr_synapses
        if alpha_curr_synapses is None:
            self.alpha_curr_synapses = []
        else:
            self.alpha_curr_synapses = alpha_curr_synapses
        if SpikeSourcePoisson is None:
            self.SpikeSourcePoisson = []
        else:
            self.SpikeSourcePoisson = SpikeSourcePoisson
        if networks is None:
            self.networks = []
        else:
            self.networks = networks
        if ComponentType is None:
            self.ComponentType = []
        else:
            self.ComponentType = ComponentType

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, NeuroMLDocument)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NeuroMLDocument.subclass:
            return NeuroMLDocument.subclass(*args_, **kwargs_)
        else:
            return NeuroMLDocument(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (
            self.includes
            or self.extracellular_properties
            or self.intracellular_properties
            or self.morphology
            or self.ion_channel
            or self.ion_channel_hhs
            or self.ion_channel_v_shifts
            or self.ion_channel_kses
            or self.decaying_pool_concentration_models
            or self.fixed_factor_concentration_models
            or self.alpha_current_synapses
            or self.alpha_synapses
            or self.exp_one_synapses
            or self.exp_two_synapses
            or self.exp_three_synapses
            or self.blocking_plastic_synapses
            or self.double_synapses
            or self.gap_junctions
            or self.silent_synapses
            or self.linear_graded_synapses
            or self.graded_synapses
            or self.biophysical_properties
            or self.cells
            or self.cell2_ca_poolses
            or self.base_cells
            or self.iaf_tau_cells
            or self.iaf_tau_ref_cells
            or self.iaf_cells
            or self.iaf_ref_cells
            or self.izhikevich_cells
            or self.izhikevich2007_cells
            or self.ad_ex_ia_f_cells
            or self.fitz_hugh_nagumo_cells
            or self.fitz_hugh_nagumo1969_cells
            or self.pinsky_rinzel_ca3_cells
            or self.pulse_generators
            or self.pulse_generator_dls
            or self.sine_generators
            or self.sine_generator_dls
            or self.ramp_generators
            or self.ramp_generator_dls
            or self.compound_inputs
            or self.compound_input_dls
            or self.voltage_clamps
            or self.voltage_clamp_triples
            or self.spike_arrays
            or self.timed_synaptic_inputs
            or self.spike_generators
            or self.spike_generator_randoms
            or self.spike_generator_poissons
            or self.spike_generator_ref_poissons
            or self.poisson_firing_synapses
            or self.transient_poisson_firing_synapses
            or self.IF_curr_alpha
            or self.IF_curr_exp
            or self.IF_cond_alpha
            or self.IF_cond_exp
            or self.EIF_cond_exp_isfa_ista
            or self.EIF_cond_alpha_isfa_ista
            or self.HH_cond_exp
            or self.exp_cond_synapses
            or self.alpha_cond_synapses
            or self.exp_curr_synapses
            or self.alpha_curr_synapses
            or self.SpikeSourcePoisson
            or self.networks
            or self.ComponentType
            or super(NeuroMLDocument, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NeuroMLDocument",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("NeuroMLDocument")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="NeuroMLDocument"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="NeuroMLDocument",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="NeuroMLDocument",
    ):
        super(NeuroMLDocument, self).exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="NeuroMLDocument"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NeuroMLDocument",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(NeuroMLDocument, self).exportChildren(
            outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for include_ in self.includes:
            include_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="include",
                pretty_print=pretty_print,
            )
        for extracellularProperties_ in self.extracellular_properties:
            extracellularProperties_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="extracellularProperties",
                pretty_print=pretty_print,
            )
        for intracellularProperties_ in self.intracellular_properties:
            intracellularProperties_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="intracellularProperties",
                pretty_print=pretty_print,
            )
        for morphology_ in self.morphology:
            morphology_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="morphology",
                pretty_print=pretty_print,
            )
        for ionChannel_ in self.ion_channel:
            ionChannel_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="ionChannel",
                pretty_print=pretty_print,
            )
        for ionChannelHH_ in self.ion_channel_hhs:
            ionChannelHH_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="ionChannelHH",
                pretty_print=pretty_print,
            )
        for ionChannelVShift_ in self.ion_channel_v_shifts:
            ionChannelVShift_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="ionChannelVShift",
                pretty_print=pretty_print,
            )
        for ionChannelKS_ in self.ion_channel_kses:
            ionChannelKS_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="ionChannelKS",
                pretty_print=pretty_print,
            )
        for decayingPoolConcentrationModel_ in self.decaying_pool_concentration_models:
            decayingPoolConcentrationModel_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="decayingPoolConcentrationModel",
                pretty_print=pretty_print,
            )
        for fixedFactorConcentrationModel_ in self.fixed_factor_concentration_models:
            fixedFactorConcentrationModel_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="fixedFactorConcentrationModel",
                pretty_print=pretty_print,
            )
        for alphaCurrentSynapse_ in self.alpha_current_synapses:
            alphaCurrentSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="alphaCurrentSynapse",
                pretty_print=pretty_print,
            )
        for alphaSynapse_ in self.alpha_synapses:
            alphaSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="alphaSynapse",
                pretty_print=pretty_print,
            )
        for expOneSynapse_ in self.exp_one_synapses:
            expOneSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="expOneSynapse",
                pretty_print=pretty_print,
            )
        for expTwoSynapse_ in self.exp_two_synapses:
            expTwoSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="expTwoSynapse",
                pretty_print=pretty_print,
            )
        for expThreeSynapse_ in self.exp_three_synapses:
            expThreeSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="expThreeSynapse",
                pretty_print=pretty_print,
            )
        for blockingPlasticSynapse_ in self.blocking_plastic_synapses:
            blockingPlasticSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="blockingPlasticSynapse",
                pretty_print=pretty_print,
            )
        for doubleSynapse_ in self.double_synapses:
            doubleSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="doubleSynapse",
                pretty_print=pretty_print,
            )
        for gapJunction_ in self.gap_junctions:
            gapJunction_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="gapJunction",
                pretty_print=pretty_print,
            )
        for silentSynapse_ in self.silent_synapses:
            silentSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="silentSynapse",
                pretty_print=pretty_print,
            )
        for linearGradedSynapse_ in self.linear_graded_synapses:
            linearGradedSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="linearGradedSynapse",
                pretty_print=pretty_print,
            )
        for gradedSynapse_ in self.graded_synapses:
            gradedSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="gradedSynapse",
                pretty_print=pretty_print,
            )
        for biophysicalProperties_ in self.biophysical_properties:
            biophysicalProperties_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="biophysicalProperties",
                pretty_print=pretty_print,
            )
        for cell_ in self.cells:
            cell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="cell",
                pretty_print=pretty_print,
            )
        for cell2CaPools_ in self.cell2_ca_poolses:
            cell2CaPools_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="cell2CaPools",
                pretty_print=pretty_print,
            )
        for baseCell_ in self.base_cells:
            baseCell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="baseCell",
                pretty_print=pretty_print,
            )
        for iafTauCell_ in self.iaf_tau_cells:
            iafTauCell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="iafTauCell",
                pretty_print=pretty_print,
            )
        for iafTauRefCell_ in self.iaf_tau_ref_cells:
            iafTauRefCell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="iafTauRefCell",
                pretty_print=pretty_print,
            )
        for iafCell_ in self.iaf_cells:
            iafCell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="iafCell",
                pretty_print=pretty_print,
            )
        for iafRefCell_ in self.iaf_ref_cells:
            iafRefCell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="iafRefCell",
                pretty_print=pretty_print,
            )
        for izhikevichCell_ in self.izhikevich_cells:
            izhikevichCell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="izhikevichCell",
                pretty_print=pretty_print,
            )
        for izhikevich2007Cell_ in self.izhikevich2007_cells:
            izhikevich2007Cell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="izhikevich2007Cell",
                pretty_print=pretty_print,
            )
        for adExIaFCell_ in self.ad_ex_ia_f_cells:
            adExIaFCell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="adExIaFCell",
                pretty_print=pretty_print,
            )
        for fitzHughNagumoCell_ in self.fitz_hugh_nagumo_cells:
            fitzHughNagumoCell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="fitzHughNagumoCell",
                pretty_print=pretty_print,
            )
        for fitzHughNagumo1969Cell_ in self.fitz_hugh_nagumo1969_cells:
            fitzHughNagumo1969Cell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="fitzHughNagumo1969Cell",
                pretty_print=pretty_print,
            )
        for pinskyRinzelCA3Cell_ in self.pinsky_rinzel_ca3_cells:
            pinskyRinzelCA3Cell_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="pinskyRinzelCA3Cell",
                pretty_print=pretty_print,
            )
        for pulseGenerator_ in self.pulse_generators:
            pulseGenerator_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="pulseGenerator",
                pretty_print=pretty_print,
            )
        for pulseGeneratorDL_ in self.pulse_generator_dls:
            pulseGeneratorDL_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="pulseGeneratorDL",
                pretty_print=pretty_print,
            )
        for sineGenerator_ in self.sine_generators:
            sineGenerator_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="sineGenerator",
                pretty_print=pretty_print,
            )
        for sineGeneratorDL_ in self.sine_generator_dls:
            sineGeneratorDL_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="sineGeneratorDL",
                pretty_print=pretty_print,
            )
        for rampGenerator_ in self.ramp_generators:
            rampGenerator_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="rampGenerator",
                pretty_print=pretty_print,
            )
        for rampGeneratorDL_ in self.ramp_generator_dls:
            rampGeneratorDL_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="rampGeneratorDL",
                pretty_print=pretty_print,
            )
        for compoundInput_ in self.compound_inputs:
            compoundInput_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="compoundInput",
                pretty_print=pretty_print,
            )
        for compoundInputDL_ in self.compound_input_dls:
            compoundInputDL_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="compoundInputDL",
                pretty_print=pretty_print,
            )
        for voltageClamp_ in self.voltage_clamps:
            voltageClamp_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="voltageClamp",
                pretty_print=pretty_print,
            )
        for voltageClampTriple_ in self.voltage_clamp_triples:
            voltageClampTriple_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="voltageClampTriple",
                pretty_print=pretty_print,
            )
        for spikeArray_ in self.spike_arrays:
            spikeArray_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="spikeArray",
                pretty_print=pretty_print,
            )
        for timedSynapticInput_ in self.timed_synaptic_inputs:
            timedSynapticInput_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="timedSynapticInput",
                pretty_print=pretty_print,
            )
        for spikeGenerator_ in self.spike_generators:
            spikeGenerator_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="spikeGenerator",
                pretty_print=pretty_print,
            )
        for spikeGeneratorRandom_ in self.spike_generator_randoms:
            spikeGeneratorRandom_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="spikeGeneratorRandom",
                pretty_print=pretty_print,
            )
        for spikeGeneratorPoisson_ in self.spike_generator_poissons:
            spikeGeneratorPoisson_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="spikeGeneratorPoisson",
                pretty_print=pretty_print,
            )
        for spikeGeneratorRefPoisson_ in self.spike_generator_ref_poissons:
            spikeGeneratorRefPoisson_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="spikeGeneratorRefPoisson",
                pretty_print=pretty_print,
            )
        for poissonFiringSynapse_ in self.poisson_firing_synapses:
            poissonFiringSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="poissonFiringSynapse",
                pretty_print=pretty_print,
            )
        for transientPoissonFiringSynapse_ in self.transient_poisson_firing_synapses:
            transientPoissonFiringSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="transientPoissonFiringSynapse",
                pretty_print=pretty_print,
            )
        for IF_curr_alpha_ in self.IF_curr_alpha:
            IF_curr_alpha_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="IF_curr_alpha",
                pretty_print=pretty_print,
            )
        for IF_curr_exp_ in self.IF_curr_exp:
            IF_curr_exp_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="IF_curr_exp",
                pretty_print=pretty_print,
            )
        for IF_cond_alpha_ in self.IF_cond_alpha:
            IF_cond_alpha_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="IF_cond_alpha",
                pretty_print=pretty_print,
            )
        for IF_cond_exp_ in self.IF_cond_exp:
            IF_cond_exp_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="IF_cond_exp",
                pretty_print=pretty_print,
            )
        for EIF_cond_exp_isfa_ista_ in self.EIF_cond_exp_isfa_ista:
            EIF_cond_exp_isfa_ista_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="EIF_cond_exp_isfa_ista",
                pretty_print=pretty_print,
            )
        for EIF_cond_alpha_isfa_ista_ in self.EIF_cond_alpha_isfa_ista:
            EIF_cond_alpha_isfa_ista_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="EIF_cond_alpha_isfa_ista",
                pretty_print=pretty_print,
            )
        for HH_cond_exp_ in self.HH_cond_exp:
            HH_cond_exp_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="HH_cond_exp",
                pretty_print=pretty_print,
            )
        for expCondSynapse_ in self.exp_cond_synapses:
            expCondSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="expCondSynapse",
                pretty_print=pretty_print,
            )
        for alphaCondSynapse_ in self.alpha_cond_synapses:
            alphaCondSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="alphaCondSynapse",
                pretty_print=pretty_print,
            )
        for expCurrSynapse_ in self.exp_curr_synapses:
            expCurrSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="expCurrSynapse",
                pretty_print=pretty_print,
            )
        for alphaCurrSynapse_ in self.alpha_curr_synapses:
            alphaCurrSynapse_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="alphaCurrSynapse",
                pretty_print=pretty_print,
            )
        for SpikeSourcePoisson_ in self.SpikeSourcePoisson:
            SpikeSourcePoisson_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="SpikeSourcePoisson",
                pretty_print=pretty_print,
            )
        for network_ in self.networks:
            network_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="network",
                pretty_print=pretty_print,
            )
        for ComponentType_ in self.ComponentType:
            ComponentType_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="ComponentType",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(NeuroMLDocument, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "include":
            obj_ = IncludeType.factory(parent_object_=self)
            obj_.build(child_)
            self.includes.append(obj_)
            obj_.original_tagname_ = "include"
        elif nodeName_ == "extracellularProperties":
            obj_ = ExtracellularProperties.factory(parent_object_=self)
            obj_.build(child_)
            self.extracellular_properties.append(obj_)
            obj_.original_tagname_ = "extracellularProperties"
        elif nodeName_ == "intracellularProperties":
            class_obj_ = self.get_class_obj_(child_, IntracellularProperties)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.intracellular_properties.append(obj_)
            obj_.original_tagname_ = "intracellularProperties"
        elif nodeName_ == "morphology":
            obj_ = Morphology.factory(parent_object_=self)
            obj_.build(child_)
            self.morphology.append(obj_)
            obj_.original_tagname_ = "morphology"
        elif nodeName_ == "ionChannel":
            class_obj_ = self.get_class_obj_(child_, IonChannel)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.ion_channel.append(obj_)
            obj_.original_tagname_ = "ionChannel"
        elif nodeName_ == "ionChannelHH":
            obj_ = IonChannelHH.factory(parent_object_=self)
            obj_.build(child_)
            self.ion_channel_hhs.append(obj_)
            obj_.original_tagname_ = "ionChannelHH"
        elif nodeName_ == "ionChannelVShift":
            obj_ = IonChannelVShift.factory(parent_object_=self)
            obj_.build(child_)
            self.ion_channel_v_shifts.append(obj_)
            obj_.original_tagname_ = "ionChannelVShift"
        elif nodeName_ == "ionChannelKS":
            obj_ = IonChannelKS.factory(parent_object_=self)
            obj_.build(child_)
            self.ion_channel_kses.append(obj_)
            obj_.original_tagname_ = "ionChannelKS"
        elif nodeName_ == "decayingPoolConcentrationModel":
            class_obj_ = self.get_class_obj_(child_, DecayingPoolConcentrationModel)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.decaying_pool_concentration_models.append(obj_)
            obj_.original_tagname_ = "decayingPoolConcentrationModel"
        elif nodeName_ == "fixedFactorConcentrationModel":
            obj_ = FixedFactorConcentrationModel.factory(parent_object_=self)
            obj_.build(child_)
            self.fixed_factor_concentration_models.append(obj_)
            obj_.original_tagname_ = "fixedFactorConcentrationModel"
        elif nodeName_ == "alphaCurrentSynapse":
            obj_ = AlphaCurrentSynapse.factory(parent_object_=self)
            obj_.build(child_)
            self.alpha_current_synapses.append(obj_)
            obj_.original_tagname_ = "alphaCurrentSynapse"
        elif nodeName_ == "alphaSynapse":
            obj_ = AlphaSynapse.factory(parent_object_=self)
            obj_.build(child_)
            self.alpha_synapses.append(obj_)
            obj_.original_tagname_ = "alphaSynapse"
        elif nodeName_ == "expOneSynapse":
            obj_ = ExpOneSynapse.factory(parent_object_=self)
            obj_.build(child_)
            self.exp_one_synapses.append(obj_)
            obj_.original_tagname_ = "expOneSynapse"
        elif nodeName_ == "expTwoSynapse":
            class_obj_ = self.get_class_obj_(child_, ExpTwoSynapse)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.exp_two_synapses.append(obj_)
            obj_.original_tagname_ = "expTwoSynapse"
        elif nodeName_ == "expThreeSynapse":
            obj_ = ExpThreeSynapse.factory(parent_object_=self)
            obj_.build(child_)
            self.exp_three_synapses.append(obj_)
            obj_.original_tagname_ = "expThreeSynapse"
        elif nodeName_ == "blockingPlasticSynapse":
            obj_ = BlockingPlasticSynapse.factory(parent_object_=self)
            obj_.build(child_)
            self.blocking_plastic_synapses.append(obj_)
            obj_.original_tagname_ = "blockingPlasticSynapse"
        elif nodeName_ == "doubleSynapse":
            obj_ = DoubleSynapse.factory(parent_object_=self)
            obj_.build(child_)
            self.double_synapses.append(obj_)
            obj_.original_tagname_ = "doubleSynapse"
        elif nodeName_ == "gapJunction":
            obj_ = GapJunction.factory(parent_object_=self)
            obj_.build(child_)
            self.gap_junctions.append(obj_)
            obj_.original_tagname_ = "gapJunction"
        elif nodeName_ == "silentSynapse":
            obj_ = SilentSynapse.factory(parent_object_=self)
            obj_.build(child_)
            self.silent_synapses.append(obj_)
            obj_.original_tagname_ = "silentSynapse"
        elif nodeName_ == "linearGradedSynapse":
            obj_ = LinearGradedSynapse.factory(parent_object_=self)
            obj_.build(child_)
            self.linear_graded_synapses.append(obj_)
            obj_.original_tagname_ = "linearGradedSynapse"
        elif nodeName_ == "gradedSynapse":
            obj_ = GradedSynapse.factory(parent_object_=self)
            obj_.build(child_)
            self.graded_synapses.append(obj_)
            obj_.original_tagname_ = "gradedSynapse"
        elif nodeName_ == "biophysicalProperties":
            obj_ = BiophysicalProperties.factory(parent_object_=self)
            obj_.build(child_)
            self.biophysical_properties.append(obj_)
            obj_.original_tagname_ = "biophysicalProperties"
        elif nodeName_ == "cell":
            class_obj_ = self.get_class_obj_(child_, Cell)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.cells.append(obj_)
            obj_.original_tagname_ = "cell"
        elif nodeName_ == "cell2CaPools":
            obj_ = Cell2CaPools.factory(parent_object_=self)
            obj_.build(child_)
            self.cell2_ca_poolses.append(obj_)
            obj_.original_tagname_ = "cell2CaPools"
        elif nodeName_ == "baseCell":
            class_obj_ = self.get_class_obj_(child_, BaseCell)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.base_cells.append(obj_)
            obj_.original_tagname_ = "baseCell"
        elif nodeName_ == "iafTauCell":
            class_obj_ = self.get_class_obj_(child_, IafTauCell)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_)
            self.iaf_tau_cells.append(obj_)
            obj_.original_tagname_ = "iafTauCell"
        elif nodeName_ == "iafTauRefCell":
            obj_ = IafTauRefCell.factory(parent_object_=self)
            obj_.build(child_)
            self.iaf_tau_ref_cells.append(obj_)
            obj_.original_tagname_ = "iafTauRefCell"
        elif nodeName_ == "iafCell":
            class_obj_ = self.get_class_obj_(child_, IafCell)
            obj_ = class_obj_.factory(parent_object_