# AUTOGENERATED! DO NOT EDIT! File to edit: 00_input.ipynb (unless otherwise specified).

__all__ = ['merge_inputlist_with_ctxindex']

# Cell
from pathlib import Path

import pandas as pd
from planetarypy.pds.apps import get_index

# Cell
def merge_inputlist_with_ctxindex(path_to_input_csv, has_header=True):
    if not has_header:
        kwargs = dict(header=None, names=["CTX image name"])
    else:
        kwargs = {}
    inlist = pd.read_csv(path_to_input_csv, **kwargs)
    inlist["CTX image name"] = inlist["CTX image name"].map(lambda x: x.strip())
    ctxindex = get_index("mro.ctx.indexes.edr")
    merged = inlist.merge(ctxindex, left_on="CTX image name", right_on="PRODUCT_ID")
    return merged