"use strict";
// Integration test to deploy some resources, create an alarm on it and create a dashboard.
//
// Because literally every other library is going to depend on @aws-cdk/aws-cloudwatch, we drop down
// to the very lowest level to create CloudFormation resources by hand, without even generated
// library support.
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cloudwatch = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudwatch');
const queue = new cdk.CfnResource(stack, 'queue', { type: 'AWS::SQS::Queue' });
const metric = new cloudwatch.Metric({
    namespace: 'AWS/SQS',
    metricName: 'ApproximateNumberOfMessagesVisible',
    dimensions: { QueueName: queue.getAtt('QueueName') },
});
const alarm = metric.createAlarm(stack, 'Alarm', {
    threshold: 100,
    evaluationPeriods: 3,
    datapointsToAlarm: 2,
});
const dashboard = new cloudwatch.Dashboard(stack, 'Dash', {
    dashboardName: 'MyCustomDashboardName',
    start: '-9H',
    end: '2018-12-17T06:00:00.000Z',
    periodOverride: cloudwatch.PeriodOverride.INHERIT,
});
dashboard.addWidgets(new cloudwatch.TextWidget({ markdown: '# This is my dashboard' }), new cloudwatch.TextWidget({ markdown: 'you like?' }));
dashboard.addWidgets(new cloudwatch.AlarmWidget({
    title: 'Messages in queue',
    alarm,
}));
dashboard.addWidgets(new cloudwatch.GraphWidget({
    title: 'More messages in queue with alarm annotation',
    left: [metric],
    leftAnnotations: [alarm.toAnnotation()],
}));
dashboard.addWidgets(new cloudwatch.SingleValueWidget({
    title: 'Current messages in queue',
    metrics: [metric],
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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