# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, Optional
from pydantic import BaseModel, Field, StrictStr
from seaplane.gen.carrier.models.metadata_headers import MetadataHeaders


class SyncResponseSyncResponse(BaseModel):
    """
    Configuration for SyncResponse
    """

    status: Optional[StrictStr] = Field(
        None, description="Specify the status code to return with synchronous responses"
    )
    headers: Optional[Dict[str, StrictStr]] = Field(
        None, description="Specify headers to return with synchronous responses."
    )
    metadata_headers: Optional[MetadataHeaders] = None
    __properties = ["status", "headers", "metadata_headers"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SyncResponseSyncResponse:
        """Create an instance of SyncResponseSyncResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of metadata_headers
        if self.metadata_headers:
            _dict["metadata_headers"] = self.metadata_headers.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SyncResponseSyncResponse:
        """Create an instance of SyncResponseSyncResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SyncResponseSyncResponse.parse_obj(obj)

        _obj = SyncResponseSyncResponse.parse_obj(
            {
                "status": obj.get("status"),
                "headers": obj.get("headers"),
                "metadata_headers": MetadataHeaders.from_dict(
                    obj.get("metadata_headers")
                )
                if obj.get("metadata_headers") is not None
                else None,
            }
        )
        return _obj
