# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from seaplane.gen.carrier.models.azure_blob_storage_output import AzureBlobStorageOutput
from seaplane.gen.carrier.models.broker import Broker
from seaplane.gen.carrier.models.carrier_output import CarrierOutput
from seaplane.gen.carrier.models.http_client_output import HttpClientOutput
from seaplane.gen.carrier.models.sql_raw import SqlRaw
from seaplane.gen.carrier.models.sync_response import SyncResponse
from typing import Any, List
from pydantic import StrictStr, Field

SWITCHOUTPUT_ONE_OF_SCHEMAS = [
    "AzureBlobStorageOutput",
    "Broker",
    "CarrierOutput",
    "HttpClientOutput",
    "SqlRaw",
    "SyncResponse",
]


class SwitchOutput(BaseModel):
    """
    SwitchOutput
    """

    # data type: AzureBlobStorageOutput
    oneof_schema_1_validator: Optional[AzureBlobStorageOutput] = None
    # data type: Broker
    oneof_schema_2_validator: Optional[Broker] = None
    # data type: CarrierOutput
    oneof_schema_3_validator: Optional[CarrierOutput] = None
    # data type: SqlRaw
    oneof_schema_4_validator: Optional[SqlRaw] = None
    # data type: SyncResponse
    oneof_schema_5_validator: Optional[SyncResponse] = None
    # data type: HttpClientOutput
    oneof_schema_6_validator: Optional[HttpClientOutput] = None
    actual_instance: Any
    one_of_schemas: List[str] = Field(SWITCHOUTPUT_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs):
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator("actual_instance")
    def actual_instance_must_validate_oneof(cls, v):
        instance = SwitchOutput.construct()
        error_messages = []
        match = 0
        # validate data type: AzureBlobStorageOutput
        if not isinstance(v, AzureBlobStorageOutput):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `AzureBlobStorageOutput`"
            )
        else:
            match += 1
        # validate data type: Broker
        if not isinstance(v, Broker):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Broker`")
        else:
            match += 1
        # validate data type: CarrierOutput
        if not isinstance(v, CarrierOutput):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CarrierOutput`"
            )
        else:
            match += 1
        # validate data type: SqlRaw
        if not isinstance(v, SqlRaw):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SqlRaw`")
        else:
            match += 1
        # validate data type: SyncResponse
        if not isinstance(v, SyncResponse):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `SyncResponse`"
            )
        else:
            match += 1
        # validate data type: HttpClientOutput
        if not isinstance(v, HttpClientOutput):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `HttpClientOutput`"
            )
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when setting `actual_instance` in SwitchOutput with oneOf schemas: AzureBlobStorageOutput, Broker, CarrierOutput, HttpClientOutput, SqlRaw, SyncResponse. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when setting `actual_instance` in SwitchOutput with oneOf schemas: AzureBlobStorageOutput, Broker, CarrierOutput, HttpClientOutput, SqlRaw, SyncResponse. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> SwitchOutput:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> SwitchOutput:
        """Returns the object represented by the json string"""
        instance = SwitchOutput.construct()
        error_messages = []
        match = 0

        # deserialize data into AzureBlobStorageOutput
        try:
            instance.actual_instance = AzureBlobStorageOutput.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Broker
        try:
            instance.actual_instance = Broker.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CarrierOutput
        try:
            instance.actual_instance = CarrierOutput.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SqlRaw
        try:
            instance.actual_instance = SqlRaw.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SyncResponse
        try:
            instance.actual_instance = SyncResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into HttpClientOutput
        try:
            instance.actual_instance = HttpClientOutput.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into SwitchOutput with oneOf schemas: AzureBlobStorageOutput, Broker, CarrierOutput, HttpClientOutput, SqlRaw, SyncResponse. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into SwitchOutput with oneOf schemas: AzureBlobStorageOutput, Broker, CarrierOutput, HttpClientOutput, SqlRaw, SyncResponse. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())
