# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from seaplane.gen.carrier.models.switch_nested1 import SwitchNested1
from seaplane.gen.carrier.models.switch_output import SwitchOutput
from typing import Any, List
from pydantic import StrictStr, Field

SWITCHNESTED2SWITCHCASESINNEROUTPUT_ONE_OF_SCHEMAS = ["SwitchNested1", "SwitchOutput"]


class SwitchNested2SwitchCasesInnerOutput(BaseModel):
    """
    SwitchNested2SwitchCasesInnerOutput
    """

    # data type: SwitchOutput
    oneof_schema_1_validator: Optional[SwitchOutput] = None
    # data type: SwitchNested1
    oneof_schema_2_validator: Optional[SwitchNested1] = None
    actual_instance: Any
    one_of_schemas: List[str] = Field(
        SWITCHNESTED2SWITCHCASESINNEROUTPUT_ONE_OF_SCHEMAS, const=True
    )

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs):
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator("actual_instance")
    def actual_instance_must_validate_oneof(cls, v):
        instance = SwitchNested2SwitchCasesInnerOutput.construct()
        error_messages = []
        match = 0
        # validate data type: SwitchOutput
        if not isinstance(v, SwitchOutput):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `SwitchOutput`"
            )
        else:
            match += 1
        # validate data type: SwitchNested1
        if not isinstance(v, SwitchNested1):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `SwitchNested1`"
            )
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when setting `actual_instance` in SwitchNested2SwitchCasesInnerOutput with oneOf schemas: SwitchNested1, SwitchOutput. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when setting `actual_instance` in SwitchNested2SwitchCasesInnerOutput with oneOf schemas: SwitchNested1, SwitchOutput. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> SwitchNested2SwitchCasesInnerOutput:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> SwitchNested2SwitchCasesInnerOutput:
        """Returns the object represented by the json string"""
        instance = SwitchNested2SwitchCasesInnerOutput.construct()
        error_messages = []
        match = 0

        # deserialize data into SwitchOutput
        try:
            instance.actual_instance = SwitchOutput.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SwitchNested1
        try:
            instance.actual_instance = SwitchNested1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into SwitchNested2SwitchCasesInnerOutput with oneOf schemas: SwitchNested1, SwitchOutput. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into SwitchNested2SwitchCasesInnerOutput with oneOf schemas: SwitchNested1, SwitchOutput. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())
