# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from pydantic import BaseModel, Field, constr, validator
from seaplane.gen.carrier.models.switch_nested1_switch_cases_inner_output import (
    SwitchNested1SwitchCasesInnerOutput,
)


class SwitchNested1SwitchCasesInner(BaseModel):
    """
    A switch case
    """

    check: constr(strict=True) = Field(..., description="Bloblang boolean expression")
    output: SwitchNested1SwitchCasesInnerOutput = Field(...)
    __properties = ["check", "output"]

    @validator("check")
    def check_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^.+$", value):
            raise ValueError(r"must validate the regular expression /^.+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SwitchNested1SwitchCasesInner:
        """Create an instance of SwitchNested1SwitchCasesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of output
        if self.output:
            _dict["output"] = self.output.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SwitchNested1SwitchCasesInner:
        """Create an instance of SwitchNested1SwitchCasesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SwitchNested1SwitchCasesInner.parse_obj(obj)

        _obj = SwitchNested1SwitchCasesInner.parse_obj(
            {
                "check": obj.get("check"),
                "output": SwitchNested1SwitchCasesInnerOutput.from_dict(
                    obj.get("output")
                )
                if obj.get("output") is not None
                else None,
            }
        )
        return _obj
