# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field
from seaplane.gen.carrier.models.azure_blob_storage_output import AzureBlobStorageOutput
from seaplane.gen.carrier.models.carrier_output import CarrierOutput
from seaplane.gen.carrier.models.http_client_output import HttpClientOutput
from seaplane.gen.carrier.models.sql_raw import SqlRaw
from seaplane.gen.carrier.models.sync_response import SyncResponse


class SwitchCasesInnerOutput(BaseModel):
    """
    Output definition for this case
    """

    carrier: Optional[CarrierOutput] = None
    sync_response: Optional[SyncResponse] = None
    drop: Optional[Dict[str, Any]] = Field(
        None, description="Drop a message (but ack input as successful)"
    )
    http_client: Optional[HttpClientOutput] = None
    azure_blob_storage: Optional[AzureBlobStorageOutput] = None
    sql_raw: Optional[SqlRaw] = None
    __properties = [
        "carrier",
        "sync_response",
        "drop",
        "http_client",
        "azure_blob_storage",
        "sql_raw",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SwitchCasesInnerOutput:
        """Create an instance of SwitchCasesInnerOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of carrier
        if self.carrier:
            _dict["carrier"] = self.carrier.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sync_response
        if self.sync_response:
            _dict["sync_response"] = self.sync_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of http_client
        if self.http_client:
            _dict["http_client"] = self.http_client.to_dict()
        # override the default output from pydantic by calling `to_dict()` of azure_blob_storage
        if self.azure_blob_storage:
            _dict["azure_blob_storage"] = self.azure_blob_storage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sql_raw
        if self.sql_raw:
            _dict["sql_raw"] = self.sql_raw.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SwitchCasesInnerOutput:
        """Create an instance of SwitchCasesInnerOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SwitchCasesInnerOutput.parse_obj(obj)

        _obj = SwitchCasesInnerOutput.parse_obj(
            {
                "carrier": CarrierOutput.from_dict(obj.get("carrier"))
                if obj.get("carrier") is not None
                else None,
                "sync_response": SyncResponse.from_dict(obj.get("sync_response"))
                if obj.get("sync_response") is not None
                else None,
                "drop": obj.get("drop"),
                "http_client": HttpClientOutput.from_dict(obj.get("http_client"))
                if obj.get("http_client") is not None
                else None,
                "azure_blob_storage": AzureBlobStorageOutput.from_dict(
                    obj.get("azure_blob_storage")
                )
                if obj.get("azure_blob_storage") is not None
                else None,
                "sql_raw": SqlRaw.from_dict(obj.get("sql_raw"))
                if obj.get("sql_raw") is not None
                else None,
            }
        )
        return _obj
