# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator


class Secret(BaseModel):
    """
    A flow secret
    """

    value: Optional[constr(strict=True)] = Field(None, description="Secret value")
    timestamp: Optional[StrictInt] = Field(None, description="Last modification time")
    hash: Optional[constr(strict=True)] = Field(None, description="Truncated sha256")
    destination: Optional[StrictStr] = Field(
        None, description="Send the secret to io, processor, or all"
    )
    __properties = ["value", "timestamp", "hash", "destination"]

    @validator("value")
    def value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r".+", value):
            raise ValueError(r"must validate the regular expression /.+/")
        return value

    @validator("hash")
    def hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Fa-f]{1,32}$", value):
            raise ValueError(
                r"must validate the regular expression /^[0-9A-Fa-f]{1,32}$/"
            )
        return value

    @validator("destination")
    def destination_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("carrier-io", "processor", "all"):
            raise ValueError(
                "must be one of enum values ('carrier-io', 'processor', 'all')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Secret:
        """Create an instance of Secret from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Secret:
        """Create an instance of Secret from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Secret.parse_obj(obj)

        _obj = Secret.parse_obj(
            {
                "value": obj.get("value"),
                "timestamp": obj.get("timestamp"),
                "hash": obj.get("hash"),
                "destination": obj.get("destination"),
            }
        )
        return _obj
